# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{6,7} )

inherit eutils python-single-r1

DESCRIPTION="Windows Exploit Suggester - Next Generation"
HOMEPAGE="https://github.com/bitsadmin/wesng"

if [[ ${PV} == *9999 ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/bitsadmin/wesng"
else
	HASH_COMMIT="7dbdaf26d5e8345fd09b78c2d6ec411f4c4fb9bc" # 20200616
	SRC_URI="https://github.com/bitsadmin/wesng/archive/${HASH_COMMIT}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"

	S="${WORKDIR}/${PN}-${HASH_COMMIT}"
fi

LICENSE="BSD"
SLOT="0"

DEPEND="${PYTHON_DEPS}"
RDEPEND="${DEPEND}
	$(python_gen_cond_dep '
		dev-python/chardet[${PYTHON_MULTI_USEDEP}]
		dev-python/MechanicalSoup[${PYTHON_MULTI_USEDEP}]
	')"

pkg_setup() {
	python-single-r1_pkg_setup
}

src_prepare() {
	python_fix_shebang "${S}"
	default
}

src_install() {
	insinto "/usr/share/${PN}"
	doins -r collector/ validation/ definitions.zip *.py

	python_optimize "${D}/usr/share/${PN}"

	make_wrapper wes \
		"${PYTHON} /usr/share/${PN}/wes.py" \
		"/usr/share/${PN}"

	dodoc README.md CHANGELOG.md CMDLINE.md
}
