# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{6,7} )
PYTHON_REQ_USE="readline(+)"

inherit distutils-r1

DESCRIPTION="An open-source exploitation framework dedicated to embedded devices"
HOMEPAGE="https://github.com/threat9/routersploit/wiki"

if [[ ${PV} == *9999 ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/threat9/routersploit"
else
	SRC_URI="https://github.com/threat9/routersploit/archive/v${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~arm ~x86"
fi

LICENSE="BSD"
SLOT="0"
IUSE="doc"

RDEPEND="${PYTHON_DEPS}
	dev-python/future[${PYTHON_USEDEP}]
	dev-python/requests[${PYTHON_USEDEP}]
	dev-python/paramiko[${PYTHON_USEDEP}]
	dev-python/pysnmp[${PYTHON_USEDEP}]
	dev-python/pycryptodome[${PYTHON_USEDEP}]
	dev-python/bluepy[${PYTHON_USEDEP}]"

DEPEND="${RDEPEND}"

src_prepare() {
	# TODO: add tests support
	rm -rf tests || die

	# use normal oldstyle names of exec files
	mv rsf.py rsf && sed -i \
		-e "s/scripts=('rsf.py',),/scripts=('rsf',),/" \
		setup.py || die

	default
}
