# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit eutils git-r3

DESCRIPTION="All exploits from exploit-db.com"
HOMEPAGE="https://www.exploit-db.com/"

EGIT_REPO_URI="https://github.com/offensive-security/exploit-database"
if [[ ${PV} != *9999 ]]; then
	EGIT_COMMIT="${PV:0:4}-${PV:4:2}-${PV:6:2}"
	KEYWORDS="amd64 x86"
fi

LICENSE="GPL-2"
SLOT="0"
IUSE="doc"

RDEPEND="
	doc? ( ~app-exploits/exploitdb-papers-${PV} )
	dev-libs/libxml2:2
	virtual/awk
	x11-misc/xclip"

PATCHES=( "${FILESDIR}"/disable-update.patch )

src_install() {
	insinto "/etc"
	doins "${FILESDIR}"/searchsploit_rc

	insinto "/usr/share/${PN}"
	doins -r *

	fperms +x "/usr/share/${PN}/searchsploit"
	dosym "../share/${PN}/searchsploit" "/usr/bin/searchsploit"
}
