# Copyright 2017-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

CRATES="
adler32-1.0.4
aho-corasick-0.7.7
ansi_term-0.11.0
anyhow-1.0.26
arrayref-0.3.6
arrayvec-0.4.12
arrayvec-0.5.1
atty-0.2.14
autocfg-0.1.7
autocfg-1.0.0
backtrace-0.3.43
backtrace-sys-0.1.32
base64-0.10.1
base64-0.11.0
bitflags-1.2.1
blake2-0.8.1
blake2b_simd-0.5.10
block-buffer-0.7.3
block-padding-0.1.5
boxxy-0.11.0
bs58-0.3.0
bufstream-0.1.4
bumpalo-3.1.2
byte-tools-0.3.1
byteorder-1.3.2
bytes-0.4.12
bytesize-1.0.0
c2-chacha-0.2.3
caps-0.3.4
cc-1.0.50
cfg-if-0.1.10
chrono-0.4.10
chrootable-https-0.14.0
clap-2.33.0
cloudabi-0.0.3
color_quant-1.0.1
colored-1.9.2
constant_time_eq-0.1.5
crc32fast-1.2.0
crossbeam-channel-0.4.0
crossbeam-deque-0.7.2
crossbeam-epoch-0.8.0
crossbeam-queue-0.1.2
crossbeam-queue-0.2.1
crossbeam-utils-0.6.6
crossbeam-utils-0.7.0
crypto-mac-0.7.0
cssparser-0.25.9
cssparser-macros-0.3.6
ct-logs-0.6.0
ctrlc-3.1.3
data-encoding-2.1.2
data-encoding-macro-0.1.7
data-encoding-macro-internal-0.1.7
deflate-0.7.20
der-parser-3.0.3
diesel-1.4.3
diesel_derives-1.4.1
diesel_migrations-1.4.0
digest-0.8.1
dirs-2.0.2
dirs-sys-0.3.4
dtoa-0.4.5
dtoa-short-0.3.2
either-1.5.3
endian-type-0.1.2
enum-as-inner-0.2.1
env_logger-0.7.1
errno-0.2.4
errno-dragonfly-0.1.1
error-chain-0.12.1
failure-0.1.6
failure_derive-0.1.6
fake-simd-0.1.2
fnv-1.0.6
fuchsia-cprng-0.1.1
fuchsia-zircon-0.3.3
fuchsia-zircon-sys-0.3.3
futf-0.1.4
futures-0.1.29
futures-cpupool-0.1.8
fxhash-0.2.1
gcc-0.3.55
generic-array-0.12.3
getrandom-0.1.14
gif-0.10.3
h2-0.1.26
heck-0.3.1
hermit-abi-0.1.6
hex-0.3.2
hlua-badtouch-0.4.2
hmac-0.7.1
hostname-0.1.5
html5ever-0.23.0
http-0.1.21
http-body-0.1.0
httparse-1.3.4
humantime-1.3.0
hyper-0.12.35
hyper-rustls-0.17.1
idna-0.2.0
image-0.22.4
indexmap-1.3.1
inflate-0.4.5
input_buffer-0.2.0
iovec-0.1.4
ipconfig-0.2.1
ipnetwork-0.15.1
itoa-0.4.5
jpeg-decoder-0.1.18
js-sys-0.3.35
kamadak-exif-0.4.0
keccak-0.1.0
kernel32-sys-0.2.2
kuchiki-0.7.3
lazy_static-1.4.0
lexical-core-0.4.6
libc-0.2.66
libsqlite3-sys-0.16.0
linked-hash-map-0.5.2
lock_api-0.3.3
log-0.4.8
lru-cache-0.1.2
lua52-sys-0.1.2
lzw-0.10.0
mac-0.1.1
maplit-1.0.2
markup5ever-0.8.1
matches-0.1.8
maxminddb-0.13.0
maybe-uninit-2.0.0
md-5-0.8.0
memchr-2.3.0
memoffset-0.5.3
migrations_internals-1.4.0
migrations_macros-1.4.1
mio-0.6.21
mio-uds-0.6.7
miow-0.2.1
mutate_once-0.1.1
net2-0.2.33
new_debug_unreachable-1.0.4
nibble_vec-0.0.4
nix-0.14.1
nix-0.15.0
nix-0.16.1
nodrop-0.1.14
nom-4.2.3
nom-5.1.0
nude-0.2.0
num-bigint-0.2.6
num-derive-0.2.5
num-integer-0.1.42
num-iter-0.1.40
num-rational-0.2.3
num-traits-0.2.11
num_cpus-1.12.0
opaque-debug-0.2.3
opener-0.4.1
parking_lot-0.9.0
parking_lot_core-0.6.2
pem-0.7.0
percent-encoding-2.1.0
phf-0.7.24
phf_codegen-0.7.24
phf_generator-0.7.24
phf_shared-0.7.24
pkg-config-0.3.17
pledge-0.3.1
png-0.15.3
ppv-lite86-0.2.6
precomputed-hash-0.1.1
proc-macro-error-0.4.5
proc-macro-error-attr-0.4.5
proc-macro-hack-0.5.11
proc-macro2-0.4.30
proc-macro2-1.0.8
procedural-masquerade-0.1.6
publicsuffix-1.5.4
quick-error-1.2.3
quote-0.6.13
quote-1.0.2
radix_trie-0.1.6
rand-0.6.5
rand-0.7.3
rand_chacha-0.1.1
rand_chacha-0.2.1
rand_core-0.3.1
rand_core-0.4.2
rand_core-0.5.1
rand_hc-0.1.0
rand_hc-0.2.0
rand_isaac-0.1.1
rand_jitter-0.1.4
rand_os-0.1.3
rand_pcg-0.1.2
rand_xorshift-0.1.1
rayon-1.3.0
rayon-core-1.7.0
rdrand-0.4.0
redox_syscall-0.1.56
redox_users-0.3.4
regex-1.3.3
regex-syntax-0.6.13
remove_dir_all-0.5.2
resolv-conf-0.6.2
ring-0.16.9
rocket_failure_errors-0.2.0
rust-argon2-0.7.0
rustc-demangle-0.1.16
rustc_version-0.2.3
rusticata-macros-2.0.4
rustls-0.16.0
rustversion-1.0.2
rustyline-5.0.6
ryu-1.0.2
same-file-1.0.6
scoped-tls-0.1.2
scoped_threadpool-0.1.9
scopeguard-1.0.0
sct-0.6.0
seccomp-sys-0.1.3
selectors-0.21.0
semver-0.9.0
semver-parser-0.7.0
separator-0.4.1
serde-1.0.104
serde_derive-1.0.104
serde_json-1.0.45
serde_urlencoded-0.6.1
servo_arc-0.1.1
sha-1-0.8.2
sha2-0.8.1
sha3-0.8.2
shellwords-1.0.0
siphasher-0.2.3
slab-0.4.2
sloppy-rfc4880-0.1.5
smallvec-0.6.13
smallvec-1.2.0
sn0int-0.16.0
sn0int-common-0.9.0
socket2-0.3.11
sourcefile-0.1.4
spin-0.5.2
stable_deref_trait-1.1.1
static_assertions-0.3.4
string-0.2.1
string_cache-0.7.5
string_cache_codegen-0.4.4
string_cache_shared-0.3.0
strsim-0.8.0
structopt-0.3.8
structopt-derive-0.4.1
strum-0.15.0
strum-0.17.1
strum_macros-0.15.0
strum_macros-0.17.1
subtle-1.0.0
syn-0.15.44
syn-1.0.14
syn-mid-0.4.0
synstructure-0.12.3
syscallz-0.12.0
tempfile-3.1.0
tendril-0.4.1
termcolor-1.1.0
textwrap-0.11.0
thin-slice-0.1.1
thread_local-1.0.1
threadpool-1.7.1
tiff-0.3.1
time-0.1.42
tokio-0.1.22
tokio-buf-0.1.1
tokio-codec-0.1.1
tokio-core-0.1.17
tokio-current-thread-0.1.6
tokio-executor-0.1.9
tokio-fs-0.1.6
tokio-io-0.1.12
tokio-reactor-0.1.11
tokio-rustls-0.10.3
tokio-sync-0.1.7
tokio-tcp-0.1.3
tokio-threadpool-0.1.17
tokio-timer-0.2.12
tokio-udp-0.1.5
tokio-uds-0.2.5
toml-0.5.6
trust-dns-0.17.0
trust-dns-proto-0.8.0
try-lock-0.2.2
tungstenite-0.9.2
typenum-1.11.2
unicode-bidi-0.3.4
unicode-normalization-0.1.12
unicode-segmentation-1.6.0
unicode-width-0.1.7
unicode-xid-0.1.0
unicode-xid-0.2.0
untrusted-0.7.0
unveil-0.2.0
url-2.1.1
utf-8-0.7.5
utf8parse-0.1.1
vcpkg-0.2.8
vec_map-0.8.1
version_check-0.1.5
void-1.0.2
walkdir-2.3.1
want-0.2.0
wasi-0.9.0+wasi-snapshot-preview1
wasm-bindgen-0.2.58
wasm-bindgen-backend-0.2.58
wasm-bindgen-macro-0.2.58
wasm-bindgen-macro-support-0.2.58
wasm-bindgen-shared-0.2.58
wasm-bindgen-webidl-0.2.58
web-sys-0.3.35
webpki-0.21.0
webpki-roots-0.17.0
webpki-roots-0.18.0
weedle-0.10.0
widestring-0.4.0
winapi-0.2.8
winapi-0.3.8
winapi-build-0.1.1
winapi-i686-pc-windows-gnu-0.4.0
winapi-util-0.1.3
winapi-x86_64-pc-windows-gnu-0.4.0
winreg-0.6.2
winutil-0.1.1
ws2_32-sys-0.2.1
x509-parser-0.6.0
xml-rs-0.8.0
"

inherit bash-completion-r1 cargo fcaps

DESCRIPTION="Semi-automatic OSINT framework and package manager"
HOMEPAGE="https://github.com/kpcyrd/sn0int"
SRC_URI="$(cargo_crate_uris ${CRATES})"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~x86"
IUSE="doc"

RESTRICT="mirror"

BDEPEND="doc? ( dev-python/sphinx )"
RDEPEND="
	dev-db/sqlite:=
	sys-libs/libseccomp"
DEPEND="${RDEPEND}"

src_compile() {
	cargo_src_compile
	target/release/sn0int completions bash > "${T}"/sn0int.bash-completion || die
}

src_install() {
	cargo_src_install

	newbashcomp "${T}"/sn0int.bash-completion $PN

	if use doc; then
		emake docs
		dodoc -r docs/_build/html
	fi

	dodoc *.md Dockerfile contrib/docker/Dockerfile.alpine
}

pkg_postinst() {
	fcaps CAP_SYS_CHROOT /usr/bin/sn0int
}
