# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{6,7} )

#inherit python-single-r1
inherit eutils python-single-r1

DESCRIPTION="Windows post-exploitation framework using Windows Script Host"
HOMEPAGE="https://github.com/entynetproject/proton"
HASH_COMMIT="e253fbcf9f082fb0ad791121ba5aa763c94c2c55"
SRC_URI="https://github.com/entynetproject/proton/archive/${HASH_COMMIT}.tar.gz -> ${P}.tar.gz"

LICENSE="GPL-3"
SLOT="0"
#https://github.com/entynetproject/proton/issues/4
#https://github.com/entynetproject/proton/issues/3
#KEYWORDS="~amd64 ~x86"
IUSE="test"

DEPEND="${PYTHON_DEPS}"
RDEPEND="${DEPEND}
	$(python_gen_cond_dep '
	dev-python/impacket[${PYTHON_MULTI_USEDEP}]
	dev-python/pycryptodome[${PYTHON_MULTI_USEDEP}]
	dev-python/pyasn1[${PYTHON_MULTI_USEDEP}]
	dev-python/tabulate[${PYTHON_MULTI_USEDEP}]
	dev-python/rjsmin[${PYTHON_MULTI_USEDEP}]
	dev-python/playsound[${PYTHON_MULTI_USEDEP}]
	')"

S="${WORKDIR}/${PN}-${HASH_COMMIT}"

pkg_setup() {
	python-single-r1_pkg_setup
}

src_prepare() {
	python_fix_shebang "${S}"
	default
}

src_install() {
	insinto "/usr/share/${PN}"
	doins -r .

	python_optimize "${D}/usr/share/${PN}"

	make_wrapper $PN \
		"${PYTHON} /usr/share/${PN}/${PN}"

	dodoc README.md
}
