# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{6,7} )

inherit eutils python-single-r1

DESCRIPTION="Generate and search pattern string for exploit development"
HOMEPAGE="https://github.com/Svenito/exploit-pattern"

if [[ ${PV} = *9999 ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/Svenito/exploit-pattern.git"
else
	HASH_COMMIT="40c8cf63e24f207cadf9783e9453d43a5c312f0d"

	SRC_URI="https://github.com/Svenito/exploit-pattern/archive/${HASH_COMMIT}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"
fi

LICENSE="MIT"
SLOT="0"

S="${WORKDIR}/${PN}-${HASH_COMMIT}"

pkg_setup() {
	python-single-r1_pkg_setup
}

src_prepare() {
	default
	python_fix_shebang "${S}"
}

src_install() {
	newbin pattern.py pattern

	dodoc README.md
}
