# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

#https://github.com/BC-SECURITY/Empire/issues/196 python3.8
PYTHON_COMPAT=( python3_{6,7} )
PYTHON_REQ_USE="sqlite"

inherit eutils python-single-r1

DESCRIPTION="A post-exploitation framework"
HOMEPAGE="https://github.com/BC-SECURITY/Empire"
SRC_URI="https://github.com/BC-SECURITY/Empire/archive/v${PV}.tar.gz -> ${P}.tar.gz"

KEYWORDS="~amd64 ~x86"
LICENSE="BSD"
SLOT="0"
IUSE="powershell java"
REQUIRED_USE="powershell? ( amd64 )"

# waiting for the upstream
# https://bugs.gentoo.org/684734
RDEPEND="${PYTHON_DEPS}
	$(python_gen_cond_dep '
		dev-python/urllib3[${PYTHON_MULTI_USEDEP}]
		dev-python/requests[${PYTHON_MULTI_USEDEP}]
		dev-python/python-iptools[${PYTHON_MULTI_USEDEP}]
		dev-python/pydispatcher[${PYTHON_MULTI_USEDEP}]
		dev-python/flask[${PYTHON_MULTI_USEDEP}]
		dev-python/macholib[${PYTHON_MULTI_USEDEP}]
		dev-python/dropbox-sdk[${PYTHON_MULTI_USEDEP}]
		dev-python/pyopenssl[${PYTHON_MULTI_USEDEP}]
		dev-python/pyinstaller[${PYTHON_MULTI_USEDEP}]
		dev-python/zlib_wrapper[${PYTHON_MULTI_USEDEP}]
		dev-python/netifaces[${PYTHON_MULTI_USEDEP}]
		dev-python/m2crypto[${PYTHON_MULTI_USEDEP}]
		dev-python/jinja[${PYTHON_MULTI_USEDEP}]
		dev-python/cryptography[${PYTHON_MULTI_USEDEP}]
		dev-python/pyminifier[${PYTHON_MULTI_USEDEP}]
		dev-python/xlutils[${PYTHON_MULTI_USEDEP}]
		dev-python/pefile[${PYTHON_MULTI_USEDEP}]
		dev-python/simplejson[${PYTHON_MULTI_USEDEP}]
		dev-python/bcrypt[${PYTHON_MULTI_USEDEP}]
		dev-python/pycryptodome[${PYTHON_MULTI_USEDEP}]
	')
	powershell? (
		amd64? ( app-shells/pwsh-bin ) )
	java? (
		|| ( virtual/jre:* virtual/jdk:* ) )"

DEPEND="${RDEPEND}"

S="${WORKDIR}/Empire-${PV}"

pkg_setup() {
	python-single-r1_pkg_setup
}

src_prepare() {
	python_fix_shebang "${S}"
	default
}

#https://github.com/BC-SECURITY/Empire/issues/39
src_install() {
	insinto "/usr/share/${PN}"
	doins -r data/ lib/ plugins/ setup/ empire

	python_optimize "${D}/usr/share/${PN}/lib"

	make_wrapper $PN \
		"${PYTHON} /usr/share/${PN}/empire" \
		"/usr/share/${PN}"

	dodoc README.md Dockerfile changelog
}

pkg_config() {
	local _yesno_ask
	local _em_home="${EROOT}/usr/share/${PN}"

	pushd "${_em_home}" >/dev/null || die

	if [ -f "${_em_home}/data/empire.db" ]; then
		ewarn "Drop old database "${_em_home}/data/empire.db" for new configuring ..."
		read -r -p " [>] Are you sure? [y/N] " _yesno_ask

		if [[ ${_yesno_ask,,} =~ ^(yes|y)$ ]]; then
			rm -f data/empire.db > /dev/null 2>&1 || die
		else
			return
		fi
	fi

	ebegin "Press ENTER to create password for database or Control-C to abort now"
	python3 setup/setup_database.py
	eend ${?} || die

	if [ -f "${_em_home}/data/empire-chain.pem" ] || [ -f "${_em_home}/data/empire-priv.key" ]; then
		ewarn "Drop old ${_em_home}/data/empire-chain.pem and generate new cert ..."
		read -r -p " [>] Are you sure? [y/N] " _yesno_ask

		if [[ ${_yesno_ask,,} =~ ^(yes|y)$ ]]; then
			rm -f data/{empire-chain.pem,empire-priv.key} > /dev/null 2>&1 || die
		else
			return
		fi
	fi

	openssl req -newkey rsa:2048 -new -nodes -x509 \
		-subj "/C=US/ST=Denial/L=Springfield/O=Dis/CN=www.pentoo.ch" \
		-keyout data/empire-priv.key \
		-out data/empire-chain.pem || die

	popd >/dev/null || die
}

pkg_postinst() {
	ewarn "\nWarning. This software does not support system-wide installation"
	ewarn "See the following bug report for more details:"
	ewarn "https://github.com/BC-SECURITY/Empire/issues/39"
	ewarn
	ewarn "You need to run it from /usr/share/${PN} directory under 'root' account"
	ewarn "\nPlease configure your installation before using:"
	ewarn "    emerge --config \"=${CATEGORY}/${PF}\"\n"
}
