# Contribution Guidelines
As the owner of the open-source project, I welcome and encourage the community to contribute to project NoirVisor. This document is intended to standardize the rules on contribution.

## Programming Language Selection in Contribution
As already announced in the "readme" file in NoirVisor's repository, NoirVisor's owner, Zero Tang, does not welcome languages other than C and Assembly to involve the NoirVisor's core.

## Sign-Off
It is significant that NoirVisor will record contributions and corresponding contributors. Contribution details will be stated as a piece of comment in relevant code area. <br>
For successful contribution, please write down your name at the bottom that can directly recognize you with following format: <br>
Netizen Name, [E-Mail Address] <br>
By saying Netizen Name, it refers to the name you use in GitHub. Your real name can also be accepted. If you prefer the name you use in other forums, you may state down that forum website. <br>
Starting from your first contribution, you, nonetheless, cannot use other names on your future contribution, unless you contribute through another account.

## Coding Conventions
- In VT-Core and SVM-Core, use lower-case when coding.
- For Windows platform-specific, use Windows API style.
- No spaces unless it significantly affects reading.

## Raising Issues
Before you start raising the issue, search over the issue list. If there is already someone raised the issue, you may give additional comments. <br>
For faster resolution, please give your opinion, or give partial code, on resolution as you raise the issue. <br>
If you have no idea why issue occurs, just state down the phenomena you see detailedly. Plus, state down how to retrigger the problem.

## Language Selection
Developers in all around the world speak different languages. Hence, language used in contributing is significant. From my perspective, I suggest developers to use such language that their intention will be described most accurately. <br>
However, I am not able to speak all languages around the world. So, I should define following guidelines of language selection. <br>
It is recommended to use following languages:
- Simplified Chinese, PRC (简体汉语，中华人民共和国)
- English, US

It could also be fine if it is stated in following languages:
- Traditional Chinese, Taiwan Province (繁體中文，臺灣省)
- Traditional Chinese, Hong Kong S.A.R (繁體中文，香港特別行政區)
- English, UK

Other written forms of Chinese (e.g Simplified Chinese, Singapore; 简体中文，新加坡) or English (e.g English, Canada), meaning not confusing, are fine as well. <br>
For example, if you can describe an issue more accurately in Chinese than English, use Chinese even if you can speak English, despite the widely use of English in GitHub.