#!/usr/bin/env bash

# This is a script to find, and correct, a problem with old versions of
# configure that affect powerpc64 and powerpc64le.

# The issue causes configure to incorrectly determine that shared library
# support is not present in the linker. This causes the package to build a
# static library rather than a dynamic one and although the build will succeed,
# it may cause packages that link with the static library it to fail due to
# undefined symbols.

# This script searches for files named 'configure' that appear to have this
# issue (by searching for a known bad pattern) and patching them.

set -e

if [ $# -ne 1 ]; then
	echo "Usage: $0 <package build directory>"
	exit 2
fi

srcdir="$1"
files=$(cd "$srcdir" && find . -name configure \
-exec grep -qF 'Generated by GNU Autoconf' {} \; \
-exec grep -qF 'ppc*-*linux*|powerpc*-*linux*)' {} \; -print)

# --ignore-whitespace is needed because some packages have included
# copies of configure scripts where tabs have been replaced with spaces.
for c in $files; do
	patch --ignore-whitespace "$srcdir"/"$c" <<'EOF'
--- a/configure	2016-11-16 15:31:46.097447271 +1100
+++ b/configure	2008-07-21 12:17:23.000000000 +1000
@@ -4433,7 +4433,10 @@
         x86_64-*linux*)
           LD="${LD-ld} -m elf_x86_64"
           ;;
-        ppc*-*linux*|powerpc*-*linux*)
+	  powerpcle-*linux*)
+	    LD="${LD-ld} -m elf64lppc"
+	    ;;
+	  powerpc-*linux*)
           LD="${LD-ld} -m elf64ppc"
           ;;
         s390*-*linux*)
EOF
done

