/*
 * socket.h
 *
 * Copyright (C) 2018 Nikias Bassen <nikias@gmx.li>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 or version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __SOCKET_H
#define __SOCKET_H

#include <stdint.h>
#include <sys/time.h>

int socket_connect_unix(const char *filename);
int socket_connect(const char *addr, uint16_t port);
int socket_connect_timeout(const char *addr, uint16_t port, struct timeval *timeout);
int socket_create_unix(const char *socket_path);
int socket_close(int sfd);

#endif
