# Table of contents

* [Initial page](README.md)
* [Github](https://github.com/vtil-project)

## Instruction Set

* [General Information](instruction-set/general-information.md)
* [Data movement](instruction-set/data-movement/README.md)
  * [MOV](instruction-set/data-movement/mov.md)
  * [MOVSX](instruction-set/data-movement/movsx.md)
  * [STR](instruction-set/data-movement/str.md)
  * [LDD](instruction-set/data-movement/ldd.md)
* [Arithmetic](instruction-set/arithmetic/README.md)
  * [NEG](instruction-set/arithmetic/neg.md)
  * [ADD](instruction-set/arithmetic/add.md)
  * [SUB](instruction-set/arithmetic/sub.md)
  * [MUL](instruction-set/arithmetic/mul.md)
  * [MULHI](instruction-set/arithmetic/mulhi.md)
  * [IMUL](instruction-set/arithmetic/imul.md)
  * [IMULHI](instruction-set/arithmetic/imulhi.md)
  * [DIV](instruction-set/arithmetic/div.md)
  * [IDIV](instruction-set/arithmetic/idiv.md)
  * [REM](instruction-set/arithmetic/rem.md)
  * [IREM](instruction-set/arithmetic/irem.md)
* [Bitwise](instruction-set/instructions/README.md)
  * [POPCNT](instruction-set/instructions/popcnt.md)
  * [BSF](instruction-set/instructions/bsf.md)
  * [BSR](instruction-set/instructions/bsr.md)
  * [NOT](instruction-set/instructions/not.md)
  * [SHR](instruction-set/instructions/shr.md)
  * [SHL](instruction-set/instructions/shl.md)
  * [XOR](instruction-set/instructions/xor.md)
  * [OR](instruction-set/instructions/or.md)
  * [AND](instruction-set/instructions/and.md)
  * [ROR](instruction-set/instructions/ror.md)
  * [ROL](instruction-set/instructions/rol.md)
* [Conditionals](instruction-set/conditionals/README.md)
  * [TG](instruction-set/conditionals/tg-1.md)
  * [TGE](instruction-set/conditionals/tge.md)
  * [TE](instruction-set/conditionals/te.md)
  * [TNE](instruction-set/conditionals/tne.md)
  * [TL](instruction-set/conditionals/tl.md)
  * [TLE](instruction-set/conditionals/tle.md)
  * [TUG](instruction-set/conditionals/tug.md)
  * [TUGE](instruction-set/conditionals/tuge.md)
  * [TUL](instruction-set/conditionals/tul.md)
  * [TULE](instruction-set/conditionals/tule.md)
  * [IFS](instruction-set/conditionals/ifs.md)
* [Control Flow](instruction-set/control-flow/README.md)
  * [JS](instruction-set/control-flow/js.md)
  * [JMP](instruction-set/control-flow/jmp.md)
  * [VEXIT](instruction-set/control-flow/vexit.md)
  * [VXCALL](instruction-set/control-flow/vxcall.md)
* [Special Instructions](instruction-set/special-instructions/README.md)
  * [NOP](instruction-set/special-instructions/nop.md)
  * [VEMIT](instruction-set/special-instructions/vemit.md)
  * [VPINR](instruction-set/special-instructions/vpinr.md)
  * [VPINW](instruction-set/special-instructions/vpinw.md)
  * [VPINRM](instruction-set/special-instructions/vpinrm.md)
  * [VPINWM](instruction-set/special-instructions/vpinwm.md)

