﻿//  Copyright 2016 Google Inc. All Rights Reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
namespace NtApiDotNet
{
#pragma warning disable 1591
    /// <summary>
    /// NT status values
    /// </summary>
    public enum NtStatus : uint
    {
        STATUS_SUCCESS = 0x00000000,
        STATUS_WAIT_1 = 0x00000001,
        STATUS_WAIT_2 = 0x00000002,
        STATUS_WAIT_3 = 0x00000003,
        STATUS_WAIT_63 = 0x0000003F,
        STATUS_ABANDONED = 0x00000080,
        STATUS_ABANDONED_WAIT_0 = 0x00000080,
        STATUS_ABANDONED_WAIT_63 = 0x000000BF,
        STATUS_USER_APC = 0x000000C0,
        STATUS_ALREADY_COMPLETE = 0x000000FF,
        STATUS_KERNEL_APC = 0x00000100,
        STATUS_ALERTED = 0x00000101,
        STATUS_TIMEOUT = 0x00000102,
        STATUS_PENDING = 0x00000103,
        STATUS_REPARSE = 0x00000104,
        STATUS_MORE_ENTRIES = 0x00000105,
        STATUS_NOT_ALL_ASSIGNED = 0x00000106,
        STATUS_SOME_NOT_MAPPED = 0x00000107,
        STATUS_OPLOCK_BREAK_IN_PROGRESS = 0x00000108,
        STATUS_VOLUME_MOUNTED = 0x00000109,
        STATUS_RXACT_COMMITTED = 0x0000010A,
        STATUS_NOTIFY_CLEANUP = 0x0000010B,
        STATUS_NOTIFY_ENUM_DIR = 0x0000010C,
        STATUS_NO_QUOTAS_FOR_ACCOUNT = 0x0000010D,
        STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED = 0x0000010E,
        STATUS_PAGE_FAULT_TRANSITION = 0x00000110,
        STATUS_PAGE_FAULT_DEMAND_ZERO = 0x00000111,
        STATUS_PAGE_FAULT_COPY_ON_WRITE = 0x00000112,
        STATUS_PAGE_FAULT_GUARD_PAGE = 0x00000113,
        STATUS_PAGE_FAULT_PAGING_FILE = 0x00000114,
        STATUS_CACHE_PAGE_LOCKED = 0x00000115,
        STATUS_CRASH_DUMP = 0x00000116,
        STATUS_BUFFER_ALL_ZEROS = 0x00000117,
        STATUS_REPARSE_OBJECT = 0x00000118,
        STATUS_RESOURCE_REQUIREMENTS_CHANGED = 0x00000119,
        STATUS_TRANSLATION_COMPLETE = 0x00000120,
        STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY = 0x00000121,
        STATUS_NOTHING_TO_TERMINATE = 0x00000122,
        STATUS_PROCESS_NOT_IN_JOB = 0x00000123,
        STATUS_PROCESS_IN_JOB = 0x00000124,
        STATUS_VOLSNAP_HIBERNATE_READY = 0x00000125,
        STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY = 0x00000126,
        STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED = 0x00000127,
        STATUS_INTERRUPT_STILL_CONNECTED = 0x00000128,
        STATUS_PROCESS_CLONED = 0x00000129,
        STATUS_FILE_LOCKED_WITH_ONLY_READERS = 0x0000012A,
        STATUS_FILE_LOCKED_WITH_WRITERS = 0x0000012B,
        STATUS_VALID_IMAGE_HASH = 0x0000012C,
        STATUS_VALID_CATALOG_HASH = 0x0000012D,
        STATUS_VALID_STRONG_CODE_HASH = 0x0000012E,
        STATUS_GHOSTED = 0x0000012F,
        STATUS_DATA_OVERWRITTEN = 0x00000130,
        STATUS_RESOURCEMANAGER_READ_ONLY = 0x00000202,
        STATUS_RING_PREVIOUSLY_EMPTY = 0x00000210,
        STATUS_RING_PREVIOUSLY_FULL = 0x00000211,
        STATUS_RING_PREVIOUSLY_ABOVE_QUOTA = 0x00000212,
        STATUS_RING_NEWLY_EMPTY = 0x00000213,
        STATUS_RING_SIGNAL_OPPOSITE_ENDPOINT = 0x00000214,
        STATUS_OPLOCK_SWITCHED_TO_NEW_HANDLE = 0x00000215,
        STATUS_OPLOCK_HANDLE_CLOSED = 0x00000216,
        STATUS_WAIT_FOR_OPLOCK = 0x00000367,
        STATUS_REPARSE_GLOBAL = 0x00000368,
        DBG_EXCEPTION_HANDLED = 0x00010001,
        DBG_CONTINUE = 0x00010002,
        STATUS_FLT_IO_COMPLETE = 0x001C0001,
        STATUS_OBJECT_NAME_EXISTS = 0x40000000,
        STATUS_THREAD_WAS_SUSPENDED = 0x40000001,
        STATUS_WORKING_SET_LIMIT_RANGE = 0x40000002,
        STATUS_IMAGE_NOT_AT_BASE = 0x40000003,
        STATUS_RXACT_STATE_CREATED = 0x40000004,
        STATUS_SEGMENT_NOTIFICATION = 0x40000005,
        STATUS_LOCAL_USER_SESSION_KEY = 0x40000006,
        STATUS_BAD_CURRENT_DIRECTORY = 0x40000007,
        STATUS_SERIAL_MORE_WRITES = 0x40000008,
        STATUS_REGISTRY_RECOVERED = 0x40000009,
        STATUS_FT_READ_RECOVERY_FROM_BACKUP = 0x4000000A,
        STATUS_FT_WRITE_RECOVERY = 0x4000000B,
        STATUS_SERIAL_COUNTER_TIMEOUT = 0x4000000C,
        STATUS_NULL_LM_PASSWORD = 0x4000000D,
        STATUS_IMAGE_MACHINE_TYPE_MISMATCH = 0x4000000E,
        STATUS_RECEIVE_PARTIAL = 0x4000000F,
        STATUS_RECEIVE_EXPEDITED = 0x40000010,
        STATUS_RECEIVE_PARTIAL_EXPEDITED = 0x40000011,
        STATUS_EVENT_DONE = 0x40000012,
        STATUS_EVENT_PENDING = 0x40000013,
        STATUS_CHECKING_FILE_SYSTEM = 0x40000014,
        STATUS_FATAL_APP_EXIT = 0x40000015,
        STATUS_PREDEFINED_HANDLE = 0x40000016,
        STATUS_WAS_UNLOCKED = 0x40000017,
        STATUS_SERVICE_NOTIFICATION = 0x40000018,
        STATUS_WAS_LOCKED = 0x40000019,
        STATUS_LOG_HARD_ERROR = 0x4000001A,
        STATUS_ALREADY_WIN32 = 0x4000001B,
        STATUS_WX86_UNSIMULATE = 0x4000001C,
        STATUS_WX86_CONTINUE = 0x4000001D,
        STATUS_WX86_SINGLE_STEP = 0x4000001E,
        STATUS_WX86_BREAKPOINT = 0x4000001F,
        STATUS_WX86_EXCEPTION_CONTINUE = 0x40000020,
        STATUS_WX86_EXCEPTION_LASTCHANCE = 0x40000021,
        STATUS_WX86_EXCEPTION_CHAIN = 0x40000022,
        STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE = 0x40000023,
        STATUS_NO_YIELD_PERFORMED = 0x40000024,
        STATUS_TIMER_RESUME_IGNORED = 0x40000025,
        STATUS_ARBITRATION_UNHANDLED = 0x40000026,
        STATUS_CARDBUS_NOT_SUPPORTED = 0x40000027,
        STATUS_WX86_CREATEWX86TIB = 0x40000028,
        STATUS_MP_PROCESSOR_MISMATCH = 0x40000029,
        STATUS_HIBERNATED = 0x4000002A,
        STATUS_RESUME_HIBERNATION = 0x4000002B,
        STATUS_FIRMWARE_UPDATED = 0x4000002C,
        STATUS_DRIVERS_LEAKING_LOCKED_PAGES = 0x4000002D,
        STATUS_MESSAGE_RETRIEVED = 0x4000002E,
        STATUS_SYSTEM_POWERSTATE_TRANSITION = 0x4000002F,
        STATUS_ALPC_CHECK_COMPLETION_LIST = 0x40000030,
        STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION = 0x40000031,
        STATUS_ACCESS_AUDIT_BY_POLICY = 0x40000032,
        STATUS_ABANDON_HIBERFILE = 0x40000033,
        STATUS_BIZRULES_NOT_ENABLED = 0x40000034,
        STATUS_FT_READ_FROM_COPY = 0x40000035,
        STATUS_IMAGE_AT_DIFFERENT_BASE = 0x40000036,
        STATUS_PATCH_DEFERRED = 0x40000037,
        DBG_REPLY_LATER = 0x40010001,
        DBG_UNABLE_TO_PROVIDE_HANDLE = 0x40010002,
        DBG_TERMINATE_THREAD = 0x40010003,
        DBG_TERMINATE_PROCESS = 0x40010004,
        DBG_CONTROL_C = 0x40010005,
        DBG_PRINTEXCEPTION_C = 0x40010006,
        DBG_RIPEXCEPTION = 0x40010007,
        DBG_CONTROL_BREAK = 0x40010008,
        DBG_COMMAND_EXCEPTION = 0x40010009,
        DBG_PRINTEXCEPTION_WIDE_C = 0x4001000A,
        STATUS_HEURISTIC_DAMAGE_POSSIBLE = 0x40190001,
        STATUS_GUARD_PAGE_VIOLATION = 0x80000001,
        STATUS_DATATYPE_MISALIGNMENT = 0x80000002,
        STATUS_BREAKPOINT = 0x80000003,
        STATUS_SINGLE_STEP = 0x80000004,
        STATUS_BUFFER_OVERFLOW = 0x80000005,
        STATUS_NO_MORE_FILES = 0x80000006,
        STATUS_WAKE_SYSTEM_DEBUGGER = 0x80000007,
        STATUS_HANDLES_CLOSED = 0x8000000A,
        STATUS_NO_INHERITANCE = 0x8000000B,
        STATUS_GUID_SUBSTITUTION_MADE = 0x8000000C,
        STATUS_PARTIAL_COPY = 0x8000000D,
        STATUS_DEVICE_PAPER_EMPTY = 0x8000000E,
        STATUS_DEVICE_POWERED_OFF = 0x8000000F,
        STATUS_DEVICE_OFF_LINE = 0x80000010,
        STATUS_DEVICE_BUSY = 0x80000011,
        STATUS_NO_MORE_EAS = 0x80000012,
        STATUS_INVALID_EA_NAME = 0x80000013,
        STATUS_EA_LIST_INCONSISTENT = 0x80000014,
        STATUS_INVALID_EA_FLAG = 0x80000015,
        STATUS_VERIFY_REQUIRED = 0x80000016,
        STATUS_EXTRANEOUS_INFORMATION = 0x80000017,
        STATUS_RXACT_COMMIT_NECESSARY = 0x80000018,
        STATUS_NO_MORE_ENTRIES = 0x8000001A,
        STATUS_FILEMARK_DETECTED = 0x8000001B,
        STATUS_MEDIA_CHANGED = 0x8000001C,
        STATUS_BUS_RESET = 0x8000001D,
        STATUS_END_OF_MEDIA = 0x8000001E,
        STATUS_BEGINNING_OF_MEDIA = 0x8000001F,
        STATUS_MEDIA_CHECK = 0x80000020,
        STATUS_SETMARK_DETECTED = 0x80000021,
        STATUS_NO_DATA_DETECTED = 0x80000022,
        STATUS_REDIRECTOR_HAS_OPEN_HANDLES = 0x80000023,
        STATUS_SERVER_HAS_OPEN_HANDLES = 0x80000024,
        STATUS_ALREADY_DISCONNECTED = 0x80000025,
        STATUS_LONGJUMP = 0x80000026,
        STATUS_CLEANER_CARTRIDGE_INSTALLED = 0x80000027,
        STATUS_PLUGPLAY_QUERY_VETOED = 0x80000028,
        STATUS_UNWIND_CONSOLIDATE = 0x80000029,
        STATUS_REGISTRY_HIVE_RECOVERED = 0x8000002A,
        STATUS_DLL_MIGHT_BE_INSECURE = 0x8000002B,
        STATUS_DLL_MIGHT_BE_INCOMPATIBLE = 0x8000002C,
        STATUS_STOPPED_ON_SYMLINK = 0x8000002D,
        STATUS_CANNOT_GRANT_REQUESTED_OPLOCK = 0x8000002E,
        STATUS_NO_ACE_CONDITION = 0x8000002F,
        STATUS_DEVICE_SUPPORT_IN_PROGRESS = 0x80000030,
        STATUS_DEVICE_POWER_CYCLE_REQUIRED = 0x80000031,
        STATUS_NO_WORK_DONE = 0x80000032,
        DBG_EXCEPTION_NOT_HANDLED = 0x80010001,
        STATUS_CLUSTER_NODE_ALREADY_UP = 0x80130001,
        STATUS_CLUSTER_NODE_ALREADY_DOWN = 0x80130002,
        STATUS_CLUSTER_NETWORK_ALREADY_ONLINE = 0x80130003,
        STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE = 0x80130004,
        STATUS_CLUSTER_NODE_ALREADY_MEMBER = 0x80130005,
        STATUS_FLT_BUFFER_TOO_SMALL = 0x801C0001,
        STATUS_FVE_PARTIAL_METADATA = 0x80210001,
        STATUS_FVE_TRANSIENT_STATE = 0x80210002,
        STATUS_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH = 0x8000CF00,
        STATUS_UNSUCCESSFUL = 0xC0000001,
        STATUS_NOT_IMPLEMENTED = 0xC0000002,
        STATUS_INVALID_INFO_CLASS = 0xC0000003,
        STATUS_INFO_LENGTH_MISMATCH = 0xC0000004,
        STATUS_ACCESS_VIOLATION = 0xC0000005,
        STATUS_IN_PAGE_ERROR = 0xC0000006,
        STATUS_PAGEFILE_QUOTA = 0xC0000007,
        STATUS_INVALID_HANDLE = 0xC0000008,
        STATUS_BAD_INITIAL_STACK = 0xC0000009,
        STATUS_BAD_INITIAL_PC = 0xC000000A,
        STATUS_INVALID_CID = 0xC000000B,
        STATUS_TIMER_NOT_CANCELED = 0xC000000C,
        STATUS_INVALID_PARAMETER = 0xC000000D,
        STATUS_NO_SUCH_DEVICE = 0xC000000E,
        STATUS_NO_SUCH_FILE = 0xC000000F,
        STATUS_INVALID_DEVICE_REQUEST = 0xC0000010,
        STATUS_END_OF_FILE = 0xC0000011,
        STATUS_WRONG_VOLUME = 0xC0000012,
        STATUS_NO_MEDIA_IN_DEVICE = 0xC0000013,
        STATUS_UNRECOGNIZED_MEDIA = 0xC0000014,
        STATUS_NONEXISTENT_SECTOR = 0xC0000015,
        STATUS_MORE_PROCESSING_REQUIRED = 0xC0000016,
        STATUS_NO_MEMORY = 0xC0000017,
        STATUS_CONFLICTING_ADDRESSES = 0xC0000018,
        STATUS_NOT_MAPPED_VIEW = 0xC0000019,
        STATUS_UNABLE_TO_FREE_VM = 0xC000001A,
        STATUS_UNABLE_TO_DELETE_SECTION = 0xC000001B,
        STATUS_INVALID_SYSTEM_SERVICE = 0xC000001C,
        STATUS_ILLEGAL_INSTRUCTION = 0xC000001D,
        STATUS_INVALID_LOCK_SEQUENCE = 0xC000001E,
        STATUS_INVALID_VIEW_SIZE = 0xC000001F,
        STATUS_INVALID_FILE_FOR_SECTION = 0xC0000020,
        STATUS_ALREADY_COMMITTED = 0xC0000021,
        STATUS_ACCESS_DENIED = 0xC0000022,
        STATUS_BUFFER_TOO_SMALL = 0xC0000023,
        STATUS_OBJECT_TYPE_MISMATCH = 0xC0000024,
        STATUS_NONCONTINUABLE_EXCEPTION = 0xC0000025,
        STATUS_INVALID_DISPOSITION = 0xC0000026,
        STATUS_UNWIND = 0xC0000027,
        STATUS_BAD_STACK = 0xC0000028,
        STATUS_INVALID_UNWIND_TARGET = 0xC0000029,
        STATUS_NOT_LOCKED = 0xC000002A,
        STATUS_PARITY_ERROR = 0xC000002B,
        STATUS_UNABLE_TO_DECOMMIT_VM = 0xC000002C,
        STATUS_NOT_COMMITTED = 0xC000002D,
        STATUS_INVALID_PORT_ATTRIBUTES = 0xC000002E,
        STATUS_PORT_MESSAGE_TOO_LONG = 0xC000002F,
        STATUS_INVALID_PARAMETER_MIX = 0xC0000030,
        STATUS_INVALID_QUOTA_LOWER = 0xC0000031,
        STATUS_DISK_CORRUPT_ERROR = 0xC0000032,
        STATUS_OBJECT_NAME_INVALID = 0xC0000033,
        STATUS_OBJECT_NAME_NOT_FOUND = 0xC0000034,
        STATUS_OBJECT_NAME_COLLISION = 0xC0000035,
        STATUS_PORT_DO_NOT_DISTURB = 0xC0000036,
        STATUS_PORT_DISCONNECTED = 0xC0000037,
        STATUS_DEVICE_ALREADY_ATTACHED = 0xC0000038,
        STATUS_OBJECT_PATH_INVALID = 0xC0000039,
        STATUS_OBJECT_PATH_NOT_FOUND = 0xC000003A,
        STATUS_OBJECT_PATH_SYNTAX_BAD = 0xC000003B,
        STATUS_DATA_OVERRUN = 0xC000003C,
        STATUS_DATA_LATE_ERROR = 0xC000003D,
        STATUS_DATA_ERROR = 0xC000003E,
        STATUS_CRC_ERROR = 0xC000003F,
        STATUS_SECTION_TOO_BIG = 0xC0000040,
        STATUS_PORT_CONNECTION_REFUSED = 0xC0000041,
        STATUS_INVALID_PORT_HANDLE = 0xC0000042,
        STATUS_SHARING_VIOLATION = 0xC0000043,
        STATUS_QUOTA_EXCEEDED = 0xC0000044,
        STATUS_INVALID_PAGE_PROTECTION = 0xC0000045,
        STATUS_MUTANT_NOT_OWNED = 0xC0000046,
        STATUS_SEMAPHORE_LIMIT_EXCEEDED = 0xC0000047,
        STATUS_PORT_ALREADY_SET = 0xC0000048,
        STATUS_SECTION_NOT_IMAGE = 0xC0000049,
        STATUS_SUSPEND_COUNT_EXCEEDED = 0xC000004A,
        STATUS_THREAD_IS_TERMINATING = 0xC000004B,
        STATUS_BAD_WORKING_SET_LIMIT = 0xC000004C,
        STATUS_INCOMPATIBLE_FILE_MAP = 0xC000004D,
        STATUS_SECTION_PROTECTION = 0xC000004E,
        STATUS_EAS_NOT_SUPPORTED = 0xC000004F,
        STATUS_EA_TOO_LARGE = 0xC0000050,
        STATUS_NONEXISTENT_EA_ENTRY = 0xC0000051,
        STATUS_NO_EAS_ON_FILE = 0xC0000052,
        STATUS_EA_CORRUPT_ERROR = 0xC0000053,
        STATUS_FILE_LOCK_CONFLICT = 0xC0000054,
        STATUS_LOCK_NOT_GRANTED = 0xC0000055,
        STATUS_DELETE_PENDING = 0xC0000056,
        STATUS_CTL_FILE_NOT_SUPPORTED = 0xC0000057,
        STATUS_UNKNOWN_REVISION = 0xC0000058,
        STATUS_REVISION_MISMATCH = 0xC0000059,
        STATUS_INVALID_OWNER = 0xC000005A,
        STATUS_INVALID_PRIMARY_GROUP = 0xC000005B,
        STATUS_NO_IMPERSONATION_TOKEN = 0xC000005C,
        STATUS_CANT_DISABLE_MANDATORY = 0xC000005D,
        STATUS_NO_LOGON_SERVERS = 0xC000005E,
        STATUS_NO_SUCH_LOGON_SESSION = 0xC000005F,
        STATUS_NO_SUCH_PRIVILEGE = 0xC0000060,
        STATUS_PRIVILEGE_NOT_HELD = 0xC0000061,
        STATUS_INVALID_ACCOUNT_NAME = 0xC0000062,
        STATUS_USER_EXISTS = 0xC0000063,
        STATUS_NO_SUCH_USER = 0xC0000064,
        STATUS_GROUP_EXISTS = 0xC0000065,
        STATUS_NO_SUCH_GROUP = 0xC0000066,
        STATUS_MEMBER_IN_GROUP = 0xC0000067,
        STATUS_MEMBER_NOT_IN_GROUP = 0xC0000068,
        STATUS_LAST_ADMIN = 0xC0000069,
        STATUS_WRONG_PASSWORD = 0xC000006A,
        STATUS_ILL_FORMED_PASSWORD = 0xC000006B,
        STATUS_PASSWORD_RESTRICTION = 0xC000006C,
        STATUS_LOGON_FAILURE = 0xC000006D,
        STATUS_ACCOUNT_RESTRICTION = 0xC000006E,
        STATUS_INVALID_LOGON_HOURS = 0xC000006F,
        STATUS_INVALID_WORKSTATION = 0xC0000070,
        STATUS_PASSWORD_EXPIRED = 0xC0000071,
        STATUS_ACCOUNT_DISABLED = 0xC0000072,
        STATUS_NONE_MAPPED = 0xC0000073,
        STATUS_TOO_MANY_LUIDS_REQUESTED = 0xC0000074,
        STATUS_LUIDS_EXHAUSTED = 0xC0000075,
        STATUS_INVALID_SUB_AUTHORITY = 0xC0000076,
        STATUS_INVALID_ACL = 0xC0000077,
        STATUS_INVALID_SID = 0xC0000078,
        STATUS_INVALID_SECURITY_DESCR = 0xC0000079,
        STATUS_PROCEDURE_NOT_FOUND = 0xC000007A,
        STATUS_INVALID_IMAGE_FORMAT = 0xC000007B,
        STATUS_NO_TOKEN = 0xC000007C,
        STATUS_BAD_INHERITANCE_ACL = 0xC000007D,
        STATUS_RANGE_NOT_LOCKED = 0xC000007E,
        STATUS_DISK_FULL = 0xC000007F,
        STATUS_SERVER_DISABLED = 0xC0000080,
        STATUS_SERVER_NOT_DISABLED = 0xC0000081,
        STATUS_TOO_MANY_GUIDS_REQUESTED = 0xC0000082,
        STATUS_GUIDS_EXHAUSTED = 0xC0000083,
        STATUS_INVALID_ID_AUTHORITY = 0xC0000084,
        STATUS_AGENTS_EXHAUSTED = 0xC0000085,
        STATUS_INVALID_VOLUME_LABEL = 0xC0000086,
        STATUS_SECTION_NOT_EXTENDED = 0xC0000087,
        STATUS_NOT_MAPPED_DATA = 0xC0000088,
        STATUS_RESOURCE_DATA_NOT_FOUND = 0xC0000089,
        STATUS_RESOURCE_TYPE_NOT_FOUND = 0xC000008A,
        STATUS_RESOURCE_NAME_NOT_FOUND = 0xC000008B,
        STATUS_ARRAY_BOUNDS_EXCEEDED = 0xC000008C,
        STATUS_FLOAT_DENORMAL_OPERAND = 0xC000008D,
        STATUS_FLOAT_DIVIDE_BY_ZERO = 0xC000008E,
        STATUS_FLOAT_INEXACT_RESULT = 0xC000008F,
        STATUS_FLOAT_INVALID_OPERATION = 0xC0000090,
        STATUS_FLOAT_OVERFLOW = 0xC0000091,
        STATUS_FLOAT_STACK_CHECK = 0xC0000092,
        STATUS_FLOAT_UNDERFLOW = 0xC0000093,
        STATUS_INTEGER_DIVIDE_BY_ZERO = 0xC0000094,
        STATUS_INTEGER_OVERFLOW = 0xC0000095,
        STATUS_PRIVILEGED_INSTRUCTION = 0xC0000096,
        STATUS_TOO_MANY_PAGING_FILES = 0xC0000097,
        STATUS_FILE_INVALID = 0xC0000098,
        STATUS_ALLOTTED_SPACE_EXCEEDED = 0xC0000099,
        STATUS_INSUFFICIENT_RESOURCES = 0xC000009A,
        STATUS_DFS_EXIT_PATH_FOUND = 0xC000009B,
        STATUS_DEVICE_DATA_ERROR = 0xC000009C,
        STATUS_DEVICE_NOT_CONNECTED = 0xC000009D,
        STATUS_DEVICE_POWER_FAILURE = 0xC000009E,
        STATUS_FREE_VM_NOT_AT_BASE = 0xC000009F,
        STATUS_MEMORY_NOT_ALLOCATED = 0xC00000A0,
        STATUS_WORKING_SET_QUOTA = 0xC00000A1,
        STATUS_MEDIA_WRITE_PROTECTED = 0xC00000A2,
        STATUS_DEVICE_NOT_READY = 0xC00000A3,
        STATUS_INVALID_GROUP_ATTRIBUTES = 0xC00000A4,
        STATUS_BAD_IMPERSONATION_LEVEL = 0xC00000A5,
        STATUS_CANT_OPEN_ANONYMOUS = 0xC00000A6,
        STATUS_BAD_VALIDATION_CLASS = 0xC00000A7,
        STATUS_BAD_TOKEN_TYPE = 0xC00000A8,
        STATUS_BAD_MASTER_BOOT_RECORD = 0xC00000A9,
        STATUS_INSTRUCTION_MISALIGNMENT = 0xC00000AA,
        STATUS_INSTANCE_NOT_AVAILABLE = 0xC00000AB,
        STATUS_PIPE_NOT_AVAILABLE = 0xC00000AC,
        STATUS_INVALID_PIPE_STATE = 0xC00000AD,
        STATUS_PIPE_BUSY = 0xC00000AE,
        STATUS_ILLEGAL_FUNCTION = 0xC00000AF,
        STATUS_PIPE_DISCONNECTED = 0xC00000B0,
        STATUS_PIPE_CLOSING = 0xC00000B1,
        STATUS_PIPE_CONNECTED = 0xC00000B2,
        STATUS_PIPE_LISTENING = 0xC00000B3,
        STATUS_INVALID_READ_MODE = 0xC00000B4,
        STATUS_IO_TIMEOUT = 0xC00000B5,
        STATUS_FILE_FORCED_CLOSED = 0xC00000B6,
        STATUS_PROFILING_NOT_STARTED = 0xC00000B7,
        STATUS_PROFILING_NOT_STOPPED = 0xC00000B8,
        STATUS_COULD_NOT_INTERPRET = 0xC00000B9,
        STATUS_FILE_IS_A_DIRECTORY = 0xC00000BA,
        STATUS_NOT_SUPPORTED = 0xC00000BB,
        STATUS_REMOTE_NOT_LISTENING = 0xC00000BC,
        STATUS_DUPLICATE_NAME = 0xC00000BD,
        STATUS_BAD_NETWORK_PATH = 0xC00000BE,
        STATUS_NETWORK_BUSY = 0xC00000BF,
        STATUS_DEVICE_DOES_NOT_EXIST = 0xC00000C0,
        STATUS_TOO_MANY_COMMANDS = 0xC00000C1,
        STATUS_ADAPTER_HARDWARE_ERROR = 0xC00000C2,
        STATUS_INVALID_NETWORK_RESPONSE = 0xC00000C3,
        STATUS_UNEXPECTED_NETWORK_ERROR = 0xC00000C4,
        STATUS_BAD_REMOTE_ADAPTER = 0xC00000C5,
        STATUS_PRINT_QUEUE_FULL = 0xC00000C6,
        STATUS_NO_SPOOL_SPACE = 0xC00000C7,
        STATUS_PRINT_CANCELLED = 0xC00000C8,
        STATUS_NETWORK_NAME_DELETED = 0xC00000C9,
        STATUS_NETWORK_ACCESS_DENIED = 0xC00000CA,
        STATUS_BAD_DEVICE_TYPE = 0xC00000CB,
        STATUS_BAD_NETWORK_NAME = 0xC00000CC,
        STATUS_TOO_MANY_NAMES = 0xC00000CD,
        STATUS_TOO_MANY_SESSIONS = 0xC00000CE,
        STATUS_SHARING_PAUSED = 0xC00000CF,
        STATUS_REQUEST_NOT_ACCEPTED = 0xC00000D0,
        STATUS_REDIRECTOR_PAUSED = 0xC00000D1,
        STATUS_NET_WRITE_FAULT = 0xC00000D2,
        STATUS_PROFILING_AT_LIMIT = 0xC00000D3,
        STATUS_NOT_SAME_DEVICE = 0xC00000D4,
        STATUS_FILE_RENAMED = 0xC00000D5,
        STATUS_VIRTUAL_CIRCUIT_CLOSED = 0xC00000D6,
        STATUS_NO_SECURITY_ON_OBJECT = 0xC00000D7,
        STATUS_CANT_WAIT = 0xC00000D8,
        STATUS_PIPE_EMPTY = 0xC00000D9,
        STATUS_CANT_ACCESS_DOMAIN_INFO = 0xC00000DA,
        STATUS_CANT_TERMINATE_SELF = 0xC00000DB,
        STATUS_INVALID_SERVER_STATE = 0xC00000DC,
        STATUS_INVALID_DOMAIN_STATE = 0xC00000DD,
        STATUS_INVALID_DOMAIN_ROLE = 0xC00000DE,
        STATUS_NO_SUCH_DOMAIN = 0xC00000DF,
        STATUS_DOMAIN_EXISTS = 0xC00000E0,
        STATUS_DOMAIN_LIMIT_EXCEEDED = 0xC00000E1,
        STATUS_OPLOCK_NOT_GRANTED = 0xC00000E2,
        STATUS_INVALID_OPLOCK_PROTOCOL = 0xC00000E3,
        STATUS_INTERNAL_DB_CORRUPTION = 0xC00000E4,
        STATUS_INTERNAL_ERROR = 0xC00000E5,
        STATUS_GENERIC_NOT_MAPPED = 0xC00000E6,
        STATUS_BAD_DESCRIPTOR_FORMAT = 0xC00000E7,
        STATUS_INVALID_USER_BUFFER = 0xC00000E8,
        STATUS_UNEXPECTED_IO_ERROR = 0xC00000E9,
        STATUS_UNEXPECTED_MM_CREATE_ERR = 0xC00000EA,
        STATUS_UNEXPECTED_MM_MAP_ERROR = 0xC00000EB,
        STATUS_UNEXPECTED_MM_EXTEND_ERR = 0xC00000EC,
        STATUS_NOT_LOGON_PROCESS = 0xC00000ED,
        STATUS_LOGON_SESSION_EXISTS = 0xC00000EE,
        STATUS_INVALID_PARAMETER_1 = 0xC00000EF,
        STATUS_INVALID_PARAMETER_2 = 0xC00000F0,
        STATUS_INVALID_PARAMETER_3 = 0xC00000F1,
        STATUS_INVALID_PARAMETER_4 = 0xC00000F2,
        STATUS_INVALID_PARAMETER_5 = 0xC00000F3,
        STATUS_INVALID_PARAMETER_6 = 0xC00000F4,
        STATUS_INVALID_PARAMETER_7 = 0xC00000F5,
        STATUS_INVALID_PARAMETER_8 = 0xC00000F6,
        STATUS_INVALID_PARAMETER_9 = 0xC00000F7,
        STATUS_INVALID_PARAMETER_10 = 0xC00000F8,
        STATUS_INVALID_PARAMETER_11 = 0xC00000F9,
        STATUS_INVALID_PARAMETER_12 = 0xC00000FA,
        STATUS_REDIRECTOR_NOT_STARTED = 0xC00000FB,
        STATUS_REDIRECTOR_STARTED = 0xC00000FC,
        STATUS_STACK_OVERFLOW = 0xC00000FD,
        STATUS_NO_SUCH_PACKAGE = 0xC00000FE,
        STATUS_BAD_FUNCTION_TABLE = 0xC00000FF,
        STATUS_VARIABLE_NOT_FOUND = 0xC0000100,
        STATUS_DIRECTORY_NOT_EMPTY = 0xC0000101,
        STATUS_FILE_CORRUPT_ERROR = 0xC0000102,
        STATUS_NOT_A_DIRECTORY = 0xC0000103,
        STATUS_BAD_LOGON_SESSION_STATE = 0xC0000104,
        STATUS_LOGON_SESSION_COLLISION = 0xC0000105,
        STATUS_NAME_TOO_LONG = 0xC0000106,
        STATUS_FILES_OPEN = 0xC0000107,
        STATUS_CONNECTION_IN_USE = 0xC0000108,
        STATUS_MESSAGE_NOT_FOUND = 0xC0000109,
        STATUS_PROCESS_IS_TERMINATING = 0xC000010A,
        STATUS_INVALID_LOGON_TYPE = 0xC000010B,
        STATUS_NO_GUID_TRANSLATION = 0xC000010C,
        STATUS_CANNOT_IMPERSONATE = 0xC000010D,
        STATUS_IMAGE_ALREADY_LOADED = 0xC000010E,
        STATUS_ABIOS_NOT_PRESENT = 0xC000010F,
        STATUS_ABIOS_LID_NOT_EXIST = 0xC0000110,
        STATUS_ABIOS_LID_ALREADY_OWNED = 0xC0000111,
        STATUS_ABIOS_NOT_LID_OWNER = 0xC0000112,
        STATUS_ABIOS_INVALID_COMMAND = 0xC0000113,
        STATUS_ABIOS_INVALID_LID = 0xC0000114,
        STATUS_ABIOS_SELECTOR_NOT_AVAILABLE = 0xC0000115,
        STATUS_ABIOS_INVALID_SELECTOR = 0xC0000116,
        STATUS_NO_LDT = 0xC0000117,
        STATUS_INVALID_LDT_SIZE = 0xC0000118,
        STATUS_INVALID_LDT_OFFSET = 0xC0000119,
        STATUS_INVALID_LDT_DESCRIPTOR = 0xC000011A,
        STATUS_INVALID_IMAGE_NE_FORMAT = 0xC000011B,
        STATUS_RXACT_INVALID_STATE = 0xC000011C,
        STATUS_RXACT_COMMIT_FAILURE = 0xC000011D,
        STATUS_MAPPED_FILE_SIZE_ZERO = 0xC000011E,
        STATUS_TOO_MANY_OPENED_FILES = 0xC000011F,
        STATUS_CANCELLED = 0xC0000120,
        STATUS_CANNOT_DELETE = 0xC0000121,
        STATUS_INVALID_COMPUTER_NAME = 0xC0000122,
        STATUS_FILE_DELETED = 0xC0000123,
        STATUS_SPECIAL_ACCOUNT = 0xC0000124,
        STATUS_SPECIAL_GROUP = 0xC0000125,
        STATUS_SPECIAL_USER = 0xC0000126,
        STATUS_MEMBERS_PRIMARY_GROUP = 0xC0000127,
        STATUS_FILE_CLOSED = 0xC0000128,
        STATUS_TOO_MANY_THREADS = 0xC0000129,
        STATUS_THREAD_NOT_IN_PROCESS = 0xC000012A,
        STATUS_TOKEN_ALREADY_IN_USE = 0xC000012B,
        STATUS_PAGEFILE_QUOTA_EXCEEDED = 0xC000012C,
        STATUS_COMMITMENT_LIMIT = 0xC000012D,
        STATUS_INVALID_IMAGE_LE_FORMAT = 0xC000012E,
        STATUS_INVALID_IMAGE_NOT_MZ = 0xC000012F,
        STATUS_INVALID_IMAGE_PROTECT = 0xC0000130,
        STATUS_INVALID_IMAGE_WIN_16 = 0xC0000131,
        STATUS_LOGON_SERVER_CONFLICT = 0xC0000132,
        STATUS_TIME_DIFFERENCE_AT_DC = 0xC0000133,
        STATUS_SYNCHRONIZATION_REQUIRED = 0xC0000134,
        STATUS_DLL_NOT_FOUND = 0xC0000135,
        STATUS_OPEN_FAILED = 0xC0000136,
        STATUS_IO_PRIVILEGE_FAILED = 0xC0000137,
        STATUS_ORDINAL_NOT_FOUND = 0xC0000138,
        STATUS_ENTRYPOINT_NOT_FOUND = 0xC0000139,
        STATUS_CONTROL_C_EXIT = 0xC000013A,
        STATUS_LOCAL_DISCONNECT = 0xC000013B,
        STATUS_REMOTE_DISCONNECT = 0xC000013C,
        STATUS_REMOTE_RESOURCES = 0xC000013D,
        STATUS_LINK_FAILED = 0xC000013E,
        STATUS_LINK_TIMEOUT = 0xC000013F,
        STATUS_INVALID_CONNECTION = 0xC0000140,
        STATUS_INVALID_ADDRESS = 0xC0000141,
        STATUS_DLL_INIT_FAILED = 0xC0000142,
        STATUS_MISSING_SYSTEMFILE = 0xC0000143,
        STATUS_UNHANDLED_EXCEPTION = 0xC0000144,
        STATUS_APP_INIT_FAILURE = 0xC0000145,
        STATUS_PAGEFILE_CREATE_FAILED = 0xC0000146,
        STATUS_NO_PAGEFILE = 0xC0000147,
        STATUS_INVALID_LEVEL = 0xC0000148,
        STATUS_WRONG_PASSWORD_CORE = 0xC0000149,
        STATUS_ILLEGAL_FLOAT_CONTEXT = 0xC000014A,
        STATUS_PIPE_BROKEN = 0xC000014B,
        STATUS_REGISTRY_CORRUPT = 0xC000014C,
        STATUS_REGISTRY_IO_FAILED = 0xC000014D,
        STATUS_NO_EVENT_PAIR = 0xC000014E,
        STATUS_UNRECOGNIZED_VOLUME = 0xC000014F,
        STATUS_SERIAL_NO_DEVICE_INITED = 0xC0000150,
        STATUS_NO_SUCH_ALIAS = 0xC0000151,
        STATUS_MEMBER_NOT_IN_ALIAS = 0xC0000152,
        STATUS_MEMBER_IN_ALIAS = 0xC0000153,
        STATUS_ALIAS_EXISTS = 0xC0000154,
        STATUS_LOGON_NOT_GRANTED = 0xC0000155,
        STATUS_TOO_MANY_SECRETS = 0xC0000156,
        STATUS_SECRET_TOO_LONG = 0xC0000157,
        STATUS_INTERNAL_DB_ERROR = 0xC0000158,
        STATUS_FULLSCREEN_MODE = 0xC0000159,
        STATUS_TOO_MANY_CONTEXT_IDS = 0xC000015A,
        STATUS_LOGON_TYPE_NOT_GRANTED = 0xC000015B,
        STATUS_NOT_REGISTRY_FILE = 0xC000015C,
        STATUS_NT_CROSS_ENCRYPTION_REQUIRED = 0xC000015D,
        STATUS_DOMAIN_CTRLR_CONFIG_ERROR = 0xC000015E,
        STATUS_FT_MISSING_MEMBER = 0xC000015F,
        STATUS_ILL_FORMED_SERVICE_ENTRY = 0xC0000160,
        STATUS_ILLEGAL_CHARACTER = 0xC0000161,
        STATUS_UNMAPPABLE_CHARACTER = 0xC0000162,
        STATUS_UNDEFINED_CHARACTER = 0xC0000163,
        STATUS_FLOPPY_VOLUME = 0xC0000164,
        STATUS_FLOPPY_ID_MARK_NOT_FOUND = 0xC0000165,
        STATUS_FLOPPY_WRONG_CYLINDER = 0xC0000166,
        STATUS_FLOPPY_UNKNOWN_ERROR = 0xC0000167,
        STATUS_FLOPPY_BAD_REGISTERS = 0xC0000168,
        STATUS_DISK_RECALIBRATE_FAILED = 0xC0000169,
        STATUS_DISK_OPERATION_FAILED = 0xC000016A,
        STATUS_DISK_RESET_FAILED = 0xC000016B,
        STATUS_SHARED_IRQ_BUSY = 0xC000016C,
        STATUS_FT_ORPHANING = 0xC000016D,
        STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT = 0xC000016E,
        STATUS_PARTITION_FAILURE = 0xC0000172,
        STATUS_INVALID_BLOCK_LENGTH = 0xC0000173,
        STATUS_DEVICE_NOT_PARTITIONED = 0xC0000174,
        STATUS_UNABLE_TO_LOCK_MEDIA = 0xC0000175,
        STATUS_UNABLE_TO_UNLOAD_MEDIA = 0xC0000176,
        STATUS_EOM_OVERFLOW = 0xC0000177,
        STATUS_NO_MEDIA = 0xC0000178,
        STATUS_NO_SUCH_MEMBER = 0xC000017A,
        STATUS_INVALID_MEMBER = 0xC000017B,
        STATUS_KEY_DELETED = 0xC000017C,
        STATUS_NO_LOG_SPACE = 0xC000017D,
        STATUS_TOO_MANY_SIDS = 0xC000017E,
        STATUS_LM_CROSS_ENCRYPTION_REQUIRED = 0xC000017F,
        STATUS_KEY_HAS_CHILDREN = 0xC0000180,
        STATUS_CHILD_MUST_BE_VOLATILE = 0xC0000181,
        STATUS_DEVICE_CONFIGURATION_ERROR = 0xC0000182,
        STATUS_DRIVER_INTERNAL_ERROR = 0xC0000183,
        STATUS_INVALID_DEVICE_STATE = 0xC0000184,
        STATUS_IO_DEVICE_ERROR = 0xC0000185,
        STATUS_DEVICE_PROTOCOL_ERROR = 0xC0000186,
        STATUS_BACKUP_CONTROLLER = 0xC0000187,
        STATUS_LOG_FILE_FULL = 0xC0000188,
        STATUS_TOO_LATE = 0xC0000189,
        STATUS_NO_TRUST_LSA_SECRET = 0xC000018A,
        STATUS_NO_TRUST_SAM_ACCOUNT = 0xC000018B,
        STATUS_TRUSTED_DOMAIN_FAILURE = 0xC000018C,
        STATUS_TRUSTED_RELATIONSHIP_FAILURE = 0xC000018D,
        STATUS_EVENTLOG_FILE_CORRUPT = 0xC000018E,
        STATUS_EVENTLOG_CANT_START = 0xC000018F,
        STATUS_TRUST_FAILURE = 0xC0000190,
        STATUS_MUTANT_LIMIT_EXCEEDED = 0xC0000191,
        STATUS_NETLOGON_NOT_STARTED = 0xC0000192,
        STATUS_ACCOUNT_EXPIRED = 0xC0000193,
        STATUS_POSSIBLE_DEADLOCK = 0xC0000194,
        STATUS_NETWORK_CREDENTIAL_CONFLICT = 0xC0000195,
        STATUS_REMOTE_SESSION_LIMIT = 0xC0000196,
        STATUS_EVENTLOG_FILE_CHANGED = 0xC0000197,
        STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 0xC0000198,
        STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 0xC0000199,
        STATUS_NOLOGON_SERVER_TRUST_ACCOUNT = 0xC000019A,
        STATUS_DOMAIN_TRUST_INCONSISTENT = 0xC000019B,
        STATUS_FS_DRIVER_REQUIRED = 0xC000019C,
        STATUS_IMAGE_ALREADY_LOADED_AS_DLL = 0xC000019D,
        STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING = 0xC000019E,
        STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME = 0xC000019F,
        STATUS_SECURITY_STREAM_IS_INCONSISTENT = 0xC00001A0,
        STATUS_INVALID_LOCK_RANGE = 0xC00001A1,
        STATUS_INVALID_ACE_CONDITION = 0xC00001A2,
        STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT = 0xC00001A3,
        STATUS_NOTIFICATION_GUID_ALREADY_DEFINED = 0xC00001A4,
        STATUS_INVALID_EXCEPTION_HANDLER = 0xC00001A5,
        STATUS_DUPLICATE_PRIVILEGES = 0xC00001A6,
        STATUS_NOT_ALLOWED_ON_SYSTEM_FILE = 0xC00001A7,
        STATUS_REPAIR_NEEDED = 0xC00001A8,
        STATUS_QUOTA_NOT_ENABLED = 0xC00001A9,
        STATUS_NO_APPLICATION_PACKAGE = 0xC00001AA,
        STATUS_FILE_METADATA_OPTIMIZATION_IN_PROGRESS = 0xC00001AB,
        STATUS_NOT_SAME_OBJECT = 0xC00001AC,
        STATUS_FATAL_MEMORY_EXHAUSTION = 0xC00001AD,
        STATUS_ERROR_PROCESS_NOT_IN_JOB = 0xC00001AE,
        STATUS_CPU_SET_INVALID = 0xC00001AF,
        STATUS_IO_DEVICE_INVALID_DATA = 0xC00001B0,
        STATUS_NETWORK_OPEN_RESTRICTION = 0xC0000201,
        STATUS_NO_USER_SESSION_KEY = 0xC0000202,
        STATUS_USER_SESSION_DELETED = 0xC0000203,
        STATUS_RESOURCE_LANG_NOT_FOUND = 0xC0000204,
        STATUS_INSUFF_SERVER_RESOURCES = 0xC0000205,
        STATUS_INVALID_BUFFER_SIZE = 0xC0000206,
        STATUS_INVALID_ADDRESS_COMPONENT = 0xC0000207,
        STATUS_INVALID_ADDRESS_WILDCARD = 0xC0000208,
        STATUS_TOO_MANY_ADDRESSES = 0xC0000209,
        STATUS_ADDRESS_ALREADY_EXISTS = 0xC000020A,
        STATUS_ADDRESS_CLOSED = 0xC000020B,
        STATUS_CONNECTION_DISCONNECTED = 0xC000020C,
        STATUS_CONNECTION_RESET = 0xC000020D,
        STATUS_TOO_MANY_NODES = 0xC000020E,
        STATUS_TRANSACTION_ABORTED = 0xC000020F,
        STATUS_TRANSACTION_TIMED_OUT = 0xC0000210,
        STATUS_TRANSACTION_NO_RELEASE = 0xC0000211,
        STATUS_TRANSACTION_NO_MATCH = 0xC0000212,
        STATUS_TRANSACTION_RESPONDED = 0xC0000213,
        STATUS_TRANSACTION_INVALID_ID = 0xC0000214,
        STATUS_TRANSACTION_INVALID_TYPE = 0xC0000215,
        STATUS_NOT_SERVER_SESSION = 0xC0000216,
        STATUS_NOT_CLIENT_SESSION = 0xC0000217,
        STATUS_CANNOT_LOAD_REGISTRY_FILE = 0xC0000218,
        STATUS_DEBUG_ATTACH_FAILED = 0xC0000219,
        STATUS_SYSTEM_PROCESS_TERMINATED = 0xC000021A,
        STATUS_DATA_NOT_ACCEPTED = 0xC000021B,
        STATUS_NO_BROWSER_SERVERS_FOUND = 0xC000021C,
        STATUS_VDM_HARD_ERROR = 0xC000021D,
        STATUS_DRIVER_CANCEL_TIMEOUT = 0xC000021E,
        STATUS_REPLY_MESSAGE_MISMATCH = 0xC000021F,
        STATUS_MAPPED_ALIGNMENT = 0xC0000220,
        STATUS_IMAGE_CHECKSUM_MISMATCH = 0xC0000221,
        STATUS_LOST_WRITEBEHIND_DATA = 0xC0000222,
        STATUS_CLIENT_SERVER_PARAMETERS_INVALID = 0xC0000223,
        STATUS_PASSWORD_MUST_CHANGE = 0xC0000224,
        STATUS_NOT_FOUND = 0xC0000225,
        STATUS_NOT_TINY_STREAM = 0xC0000226,
        STATUS_RECOVERY_FAILURE = 0xC0000227,
        STATUS_STACK_OVERFLOW_READ = 0xC0000228,
        STATUS_FAIL_CHECK = 0xC0000229,
        STATUS_DUPLICATE_OBJECTID = 0xC000022A,
        STATUS_OBJECTID_EXISTS = 0xC000022B,
        STATUS_CONVERT_TO_LARGE = 0xC000022C,
        STATUS_RETRY = 0xC000022D,
        STATUS_FOUND_OUT_OF_SCOPE = 0xC000022E,
        STATUS_ALLOCATE_BUCKET = 0xC000022F,
        STATUS_PROPSET_NOT_FOUND = 0xC0000230,
        STATUS_MARSHALL_OVERFLOW = 0xC0000231,
        STATUS_INVALID_VARIANT = 0xC0000232,
        STATUS_DOMAIN_CONTROLLER_NOT_FOUND = 0xC0000233,
        STATUS_ACCOUNT_LOCKED_OUT = 0xC0000234,
        STATUS_HANDLE_NOT_CLOSABLE = 0xC0000235,
        STATUS_CONNECTION_REFUSED = 0xC0000236,
        STATUS_GRACEFUL_DISCONNECT = 0xC0000237,
        STATUS_ADDRESS_ALREADY_ASSOCIATED = 0xC0000238,
        STATUS_ADDRESS_NOT_ASSOCIATED = 0xC0000239,
        STATUS_CONNECTION_INVALID = 0xC000023A,
        STATUS_CONNECTION_ACTIVE = 0xC000023B,
        STATUS_NETWORK_UNREACHABLE = 0xC000023C,
        STATUS_HOST_UNREACHABLE = 0xC000023D,
        STATUS_PROTOCOL_UNREACHABLE = 0xC000023E,
        STATUS_PORT_UNREACHABLE = 0xC000023F,
        STATUS_REQUEST_ABORTED = 0xC0000240,
        STATUS_CONNECTION_ABORTED = 0xC0000241,
        STATUS_BAD_COMPRESSION_BUFFER = 0xC0000242,
        STATUS_USER_MAPPED_FILE = 0xC0000243,
        STATUS_AUDIT_FAILED = 0xC0000244,
        STATUS_TIMER_RESOLUTION_NOT_SET = 0xC0000245,
        STATUS_CONNECTION_COUNT_LIMIT = 0xC0000246,
        STATUS_LOGIN_TIME_RESTRICTION = 0xC0000247,
        STATUS_LOGIN_WKSTA_RESTRICTION = 0xC0000248,
        STATUS_IMAGE_MP_UP_MISMATCH = 0xC0000249,
        STATUS_INSUFFICIENT_LOGON_INFO = 0xC0000250,
        STATUS_BAD_DLL_ENTRYPOINT = 0xC0000251,
        STATUS_BAD_SERVICE_ENTRYPOINT = 0xC0000252,
        STATUS_LPC_REPLY_LOST = 0xC0000253,
        STATUS_IP_ADDRESS_CONFLICT1 = 0xC0000254,
        STATUS_IP_ADDRESS_CONFLICT2 = 0xC0000255,
        STATUS_REGISTRY_QUOTA_LIMIT = 0xC0000256,
        STATUS_PATH_NOT_COVERED = 0xC0000257,
        STATUS_NO_CALLBACK_ACTIVE = 0xC0000258,
        STATUS_LICENSE_QUOTA_EXCEEDED = 0xC0000259,
        STATUS_PWD_TOO_SHORT = 0xC000025A,
        STATUS_PWD_TOO_RECENT = 0xC000025B,
        STATUS_PWD_HISTORY_CONFLICT = 0xC000025C,
        STATUS_PLUGPLAY_NO_DEVICE = 0xC000025E,
        STATUS_UNSUPPORTED_COMPRESSION = 0xC000025F,
        STATUS_INVALID_HW_PROFILE = 0xC0000260,
        STATUS_INVALID_PLUGPLAY_DEVICE_PATH = 0xC0000261,
        STATUS_DRIVER_ORDINAL_NOT_FOUND = 0xC0000262,
        STATUS_DRIVER_ENTRYPOINT_NOT_FOUND = 0xC0000263,
        STATUS_RESOURCE_NOT_OWNED = 0xC0000264,
        STATUS_TOO_MANY_LINKS = 0xC0000265,
        STATUS_QUOTA_LIST_INCONSISTENT = 0xC0000266,
        STATUS_FILE_IS_OFFLINE = 0xC0000267,
        STATUS_EVALUATION_EXPIRATION = 0xC0000268,
        STATUS_ILLEGAL_DLL_RELOCATION = 0xC0000269,
        STATUS_LICENSE_VIOLATION = 0xC000026A,
        STATUS_DLL_INIT_FAILED_LOGOFF = 0xC000026B,
        STATUS_DRIVER_UNABLE_TO_LOAD = 0xC000026C,
        STATUS_DFS_UNAVAILABLE = 0xC000026D,
        STATUS_VOLUME_DISMOUNTED = 0xC000026E,
        STATUS_WX86_INTERNAL_ERROR = 0xC000026F,
        STATUS_WX86_FLOAT_STACK_CHECK = 0xC0000270,
        STATUS_VALIDATE_CONTINUE = 0xC0000271,
        STATUS_NO_MATCH = 0xC0000272,
        STATUS_NO_MORE_MATCHES = 0xC0000273,
        STATUS_NOT_A_REPARSE_POINT = 0xC0000275,
        STATUS_IO_REPARSE_TAG_INVALID = 0xC0000276,
        STATUS_IO_REPARSE_TAG_MISMATCH = 0xC0000277,
        STATUS_IO_REPARSE_DATA_INVALID = 0xC0000278,
        STATUS_IO_REPARSE_TAG_NOT_HANDLED = 0xC0000279,
        STATUS_PWD_TOO_LONG = 0xC000027A,
        STATUS_STOWED_EXCEPTION = 0xC000027B,
        STATUS_CONTEXT_STOWED_EXCEPTION = 0xC000027C,
        STATUS_REPARSE_POINT_NOT_RESOLVED = 0xC0000280,
        STATUS_DIRECTORY_IS_A_REPARSE_POINT = 0xC0000281,
        STATUS_RANGE_LIST_CONFLICT = 0xC0000282,
        STATUS_SOURCE_ELEMENT_EMPTY = 0xC0000283,
        STATUS_DESTINATION_ELEMENT_FULL = 0xC0000284,
        STATUS_ILLEGAL_ELEMENT_ADDRESS = 0xC0000285,
        STATUS_MAGAZINE_NOT_PRESENT = 0xC0000286,
        STATUS_REINITIALIZATION_NEEDED = 0xC0000287,
        STATUS_DEVICE_REQUIRES_CLEANING = 0x80000288,
        STATUS_DEVICE_DOOR_OPEN = 0x80000289,
        STATUS_ENCRYPTION_FAILED = 0xC000028A,
        STATUS_DECRYPTION_FAILED = 0xC000028B,
        STATUS_RANGE_NOT_FOUND = 0xC000028C,
        STATUS_NO_RECOVERY_POLICY = 0xC000028D,
        STATUS_NO_EFS = 0xC000028E,
        STATUS_WRONG_EFS = 0xC000028F,
        STATUS_NO_USER_KEYS = 0xC0000290,
        STATUS_FILE_NOT_ENCRYPTED = 0xC0000291,
        STATUS_NOT_EXPORT_FORMAT = 0xC0000292,
        STATUS_FILE_ENCRYPTED = 0xC0000293,
        STATUS_WAKE_SYSTEM = 0x40000294,
        STATUS_WMI_GUID_NOT_FOUND = 0xC0000295,
        STATUS_WMI_INSTANCE_NOT_FOUND = 0xC0000296,
        STATUS_WMI_ITEMID_NOT_FOUND = 0xC0000297,
        STATUS_WMI_TRY_AGAIN = 0xC0000298,
        STATUS_SHARED_POLICY = 0xC0000299,
        STATUS_POLICY_OBJECT_NOT_FOUND = 0xC000029A,
        STATUS_POLICY_ONLY_IN_DS = 0xC000029B,
        STATUS_VOLUME_NOT_UPGRADED = 0xC000029C,
        STATUS_REMOTE_STORAGE_NOT_ACTIVE = 0xC000029D,
        STATUS_REMOTE_STORAGE_MEDIA_ERROR = 0xC000029E,
        STATUS_NO_TRACKING_SERVICE = 0xC000029F,
        STATUS_SERVER_SID_MISMATCH = 0xC00002A0,
        STATUS_DS_NO_ATTRIBUTE_OR_VALUE = 0xC00002A1,
        STATUS_DS_INVALID_ATTRIBUTE_SYNTAX = 0xC00002A2,
        STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED = 0xC00002A3,
        STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS = 0xC00002A4,
        STATUS_DS_BUSY = 0xC00002A5,
        STATUS_DS_UNAVAILABLE = 0xC00002A6,
        STATUS_DS_NO_RIDS_ALLOCATED = 0xC00002A7,
        STATUS_DS_NO_MORE_RIDS = 0xC00002A8,
        STATUS_DS_INCORRECT_ROLE_OWNER = 0xC00002A9,
        STATUS_DS_RIDMGR_INIT_ERROR = 0xC00002AA,
        STATUS_DS_OBJ_CLASS_VIOLATION = 0xC00002AB,
        STATUS_DS_CANT_ON_NON_LEAF = 0xC00002AC,
        STATUS_DS_CANT_ON_RDN = 0xC00002AD,
        STATUS_DS_CANT_MOD_OBJ_CLASS = 0xC00002AE,
        STATUS_DS_CROSS_DOM_MOVE_FAILED = 0xC00002AF,
        STATUS_DS_GC_NOT_AVAILABLE = 0xC00002B0,
        STATUS_DIRECTORY_SERVICE_REQUIRED = 0xC00002B1,
        STATUS_REPARSE_ATTRIBUTE_CONFLICT = 0xC00002B2,
        STATUS_CANT_ENABLE_DENY_ONLY = 0xC00002B3,
        STATUS_FLOAT_MULTIPLE_FAULTS = 0xC00002B4,
        STATUS_FLOAT_MULTIPLE_TRAPS = 0xC00002B5,
        STATUS_DEVICE_REMOVED = 0xC00002B6,
        STATUS_JOURNAL_DELETE_IN_PROGRESS = 0xC00002B7,
        STATUS_JOURNAL_NOT_ACTIVE = 0xC00002B8,
        STATUS_NOINTERFACE = 0xC00002B9,
        STATUS_DS_RIDMGR_DISABLED = 0xC00002BA,
        STATUS_DS_ADMIN_LIMIT_EXCEEDED = 0xC00002C1,
        STATUS_DRIVER_FAILED_SLEEP = 0xC00002C2,
        STATUS_MUTUAL_AUTHENTICATION_FAILED = 0xC00002C3,
        STATUS_CORRUPT_SYSTEM_FILE = 0xC00002C4,
        STATUS_DATATYPE_MISALIGNMENT_ERROR = 0xC00002C5,
        STATUS_WMI_READ_ONLY = 0xC00002C6,
        STATUS_WMI_SET_FAILURE = 0xC00002C7,
        STATUS_COMMITMENT_MINIMUM = 0xC00002C8,
        STATUS_REG_NAT_CONSUMPTION = 0xC00002C9,
        STATUS_TRANSPORT_FULL = 0xC00002CA,
        STATUS_DS_SAM_INIT_FAILURE = 0xC00002CB,
        STATUS_ONLY_IF_CONNECTED = 0xC00002CC,
        STATUS_DS_SENSITIVE_GROUP_VIOLATION = 0xC00002CD,
        STATUS_PNP_RESTART_ENUMERATION = 0xC00002CE,
        STATUS_JOURNAL_ENTRY_DELETED = 0xC00002CF,
        STATUS_DS_CANT_MOD_PRIMARYGROUPID = 0xC00002D0,
        STATUS_SYSTEM_IMAGE_BAD_SIGNATURE = 0xC00002D1,
        STATUS_PNP_REBOOT_REQUIRED = 0xC00002D2,
        STATUS_POWER_STATE_INVALID = 0xC00002D3,
        STATUS_DS_INVALID_GROUP_TYPE = 0xC00002D4,
        STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 0xC00002D5,
        STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 0xC00002D6,
        STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 0xC00002D7,
        STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 0xC00002D8,
        STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 0xC00002D9,
        STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 0xC00002DA,
        STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 0xC00002DB,
        STATUS_DS_HAVE_PRIMARY_MEMBERS = 0xC00002DC,
        STATUS_WMI_NOT_SUPPORTED = 0xC00002DD,
        STATUS_INSUFFICIENT_POWER = 0xC00002DE,
        STATUS_SAM_NEED_BOOTKEY_PASSWORD = 0xC00002DF,
        STATUS_SAM_NEED_BOOTKEY_FLOPPY = 0xC00002E0,
        STATUS_DS_CANT_START = 0xC00002E1,
        STATUS_DS_INIT_FAILURE = 0xC00002E2,
        STATUS_SAM_INIT_FAILURE = 0xC00002E3,
        STATUS_DS_GC_REQUIRED = 0xC00002E4,
        STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 0xC00002E5,
        STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS = 0xC00002E6,
        STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 0xC00002E7,
        STATUS_MULTIPLE_FAULT_VIOLATION = 0xC00002E8,
        STATUS_CURRENT_DOMAIN_NOT_ALLOWED = 0xC00002E9,
        STATUS_CANNOT_MAKE = 0xC00002EA,
        STATUS_SYSTEM_SHUTDOWN = 0xC00002EB,
        STATUS_DS_INIT_FAILURE_CONSOLE = 0xC00002EC,
        STATUS_DS_SAM_INIT_FAILURE_CONSOLE = 0xC00002ED,
        STATUS_UNFINISHED_CONTEXT_DELETED = 0xC00002EE,
        STATUS_NO_TGT_REPLY = 0xC00002EF,
        STATUS_OBJECTID_NOT_FOUND = 0xC00002F0,
        STATUS_NO_IP_ADDRESSES = 0xC00002F1,
        STATUS_WRONG_CREDENTIAL_HANDLE = 0xC00002F2,
        STATUS_CRYPTO_SYSTEM_INVALID = 0xC00002F3,
        STATUS_MAX_REFERRALS_EXCEEDED = 0xC00002F4,
        STATUS_MUST_BE_KDC = 0xC00002F5,
        STATUS_STRONG_CRYPTO_NOT_SUPPORTED = 0xC00002F6,
        STATUS_TOO_MANY_PRINCIPALS = 0xC00002F7,
        STATUS_NO_PA_DATA = 0xC00002F8,
        STATUS_PKINIT_NAME_MISMATCH = 0xC00002F9,
        STATUS_SMARTCARD_LOGON_REQUIRED = 0xC00002FA,
        STATUS_KDC_INVALID_REQUEST = 0xC00002FB,
        STATUS_KDC_UNABLE_TO_REFER = 0xC00002FC,
        STATUS_KDC_UNKNOWN_ETYPE = 0xC00002FD,
        STATUS_SHUTDOWN_IN_PROGRESS = 0xC00002FE,
        STATUS_SERVER_SHUTDOWN_IN_PROGRESS = 0xC00002FF,
        STATUS_NOT_SUPPORTED_ON_SBS = 0xC0000300,
        STATUS_WMI_GUID_DISCONNECTED = 0xC0000301,
        STATUS_WMI_ALREADY_DISABLED = 0xC0000302,
        STATUS_WMI_ALREADY_ENABLED = 0xC0000303,
        STATUS_MFT_TOO_FRAGMENTED = 0xC0000304,
        STATUS_COPY_PROTECTION_FAILURE = 0xC0000305,
        STATUS_CSS_AUTHENTICATION_FAILURE = 0xC0000306,
        STATUS_CSS_KEY_NOT_PRESENT = 0xC0000307,
        STATUS_CSS_KEY_NOT_ESTABLISHED = 0xC0000308,
        STATUS_CSS_SCRAMBLED_SECTOR = 0xC0000309,
        STATUS_CSS_REGION_MISMATCH = 0xC000030A,
        STATUS_CSS_RESETS_EXHAUSTED = 0xC000030B,
        STATUS_PASSWORD_CHANGE_REQUIRED = 0xC000030C,
        STATUS_LOST_MODE_LOGON_RESTRICTION = 0xC000030D,
        STATUS_PKINIT_FAILURE = 0xC0000320,
        STATUS_SMARTCARD_SUBSYSTEM_FAILURE = 0xC0000321,
        STATUS_NO_KERB_KEY = 0xC0000322,
        STATUS_HOST_DOWN = 0xC0000350,
        STATUS_UNSUPPORTED_PREAUTH = 0xC0000351,
        STATUS_EFS_ALG_BLOB_TOO_BIG = 0xC0000352,
        STATUS_PORT_NOT_SET = 0xC0000353,
        STATUS_DEBUGGER_INACTIVE = 0xC0000354,
        STATUS_DS_VERSION_CHECK_FAILURE = 0xC0000355,
        STATUS_AUDITING_DISABLED = 0xC0000356,
        STATUS_PRENT4_MACHINE_ACCOUNT = 0xC0000357,
        STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = 0xC0000358,
        STATUS_INVALID_IMAGE_WIN_32 = 0xC0000359,
        STATUS_INVALID_IMAGE_WIN_64 = 0xC000035A,
        STATUS_BAD_BINDINGS = 0xC000035B,
        STATUS_NETWORK_SESSION_EXPIRED = 0xC000035C,
        STATUS_APPHELP_BLOCK = 0xC000035D,
        STATUS_ALL_SIDS_FILTERED = 0xC000035E,
        STATUS_NOT_SAFE_MODE_DRIVER = 0xC000035F,
        STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT = 0xC0000361,
        STATUS_ACCESS_DISABLED_BY_POLICY_PATH = 0xC0000362,
        STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER = 0xC0000363,
        STATUS_ACCESS_DISABLED_BY_POLICY_OTHER = 0xC0000364,
        STATUS_FAILED_DRIVER_ENTRY = 0xC0000365,
        STATUS_DEVICE_ENUMERATION_ERROR = 0xC0000366,
        STATUS_MOUNT_POINT_NOT_RESOLVED = 0xC0000368,
        STATUS_INVALID_DEVICE_OBJECT_PARAMETER = 0xC0000369,
        STATUS_MCA_OCCURED = 0xC000036A,
        STATUS_DRIVER_BLOCKED_CRITICAL = 0xC000036B,
        STATUS_DRIVER_BLOCKED = 0xC000036C,
        STATUS_DRIVER_DATABASE_ERROR = 0xC000036D,
        STATUS_SYSTEM_HIVE_TOO_LARGE = 0xC000036E,
        STATUS_INVALID_IMPORT_OF_NON_DLL = 0xC000036F,
        STATUS_DS_SHUTTING_DOWN = 0x40000370,
        STATUS_NO_SECRETS = 0xC0000371,
        STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY = 0xC0000372,
        STATUS_FAILED_STACK_SWITCH = 0xC0000373,
        STATUS_HEAP_CORRUPTION = 0xC0000374,
        STATUS_SMARTCARD_WRONG_PIN = 0xC0000380,
        STATUS_SMARTCARD_CARD_BLOCKED = 0xC0000381,
        STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED = 0xC0000382,
        STATUS_SMARTCARD_NO_CARD = 0xC0000383,
        STATUS_SMARTCARD_NO_KEY_CONTAINER = 0xC0000384,
        STATUS_SMARTCARD_NO_CERTIFICATE = 0xC0000385,
        STATUS_SMARTCARD_NO_KEYSET = 0xC0000386,
        STATUS_SMARTCARD_IO_ERROR = 0xC0000387,
        STATUS_DOWNGRADE_DETECTED = 0xC0000388,
        STATUS_SMARTCARD_CERT_REVOKED = 0xC0000389,
        STATUS_ISSUING_CA_UNTRUSTED = 0xC000038A,
        STATUS_REVOCATION_OFFLINE_C = 0xC000038B,
        STATUS_PKINIT_CLIENT_FAILURE = 0xC000038C,
        STATUS_SMARTCARD_CERT_EXPIRED = 0xC000038D,
        STATUS_DRIVER_FAILED_PRIOR_UNLOAD = 0xC000038E,
        STATUS_SMARTCARD_SILENT_CONTEXT = 0xC000038F,
        STATUS_PER_USER_TRUST_QUOTA_EXCEEDED = 0xC0000401,
        STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED = 0xC0000402,
        STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED = 0xC0000403,
        STATUS_DS_NAME_NOT_UNIQUE = 0xC0000404,
        STATUS_DS_DUPLICATE_ID_FOUND = 0xC0000405,
        STATUS_DS_GROUP_CONVERSION_ERROR = 0xC0000406,
        STATUS_VOLSNAP_PREPARE_HIBERNATE = 0xC0000407,
        STATUS_USER2USER_REQUIRED = 0xC0000408,
        STATUS_STACK_BUFFER_OVERRUN = 0xC0000409,
        STATUS_NO_S4U_PROT_SUPPORT = 0xC000040A,
        STATUS_CROSSREALM_DELEGATION_FAILURE = 0xC000040B,
        STATUS_REVOCATION_OFFLINE_KDC = 0xC000040C,
        STATUS_ISSUING_CA_UNTRUSTED_KDC = 0xC000040D,
        STATUS_KDC_CERT_EXPIRED = 0xC000040E,
        STATUS_KDC_CERT_REVOKED = 0xC000040F,
        STATUS_PARAMETER_QUOTA_EXCEEDED = 0xC0000410,
        STATUS_HIBERNATION_FAILURE = 0xC0000411,
        STATUS_DELAY_LOAD_FAILED = 0xC0000412,
        STATUS_AUTHENTICATION_FIREWALL_FAILED = 0xC0000413,
        STATUS_VDM_DISALLOWED = 0xC0000414,
        STATUS_HUNG_DISPLAY_DRIVER_THREAD = 0xC0000415,
        STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE = 0xC0000416,
        STATUS_INVALID_CRUNTIME_PARAMETER = 0xC0000417,
        STATUS_NTLM_BLOCKED = 0xC0000418,
        STATUS_DS_SRC_SID_EXISTS_IN_FOREST = 0xC0000419,
        STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST = 0xC000041A,
        STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST = 0xC000041B,
        STATUS_INVALID_USER_PRINCIPAL_NAME = 0xC000041C,
        STATUS_FATAL_USER_CALLBACK_EXCEPTION = 0xC000041D,
        STATUS_ASSERTION_FAILURE = 0xC0000420,
        STATUS_VERIFIER_STOP = 0xC0000421,
        STATUS_CALLBACK_POP_STACK = 0xC0000423,
        STATUS_INCOMPATIBLE_DRIVER_BLOCKED = 0xC0000424,
        STATUS_HIVE_UNLOADED = 0xC0000425,
        STATUS_COMPRESSION_DISABLED = 0xC0000426,
        STATUS_FILE_SYSTEM_LIMITATION = 0xC0000427,
        STATUS_INVALID_IMAGE_HASH = 0xC0000428,
        STATUS_NOT_CAPABLE = 0xC0000429,
        STATUS_REQUEST_OUT_OF_SEQUENCE = 0xC000042A,
        STATUS_IMPLEMENTATION_LIMIT = 0xC000042B,
        STATUS_ELEVATION_REQUIRED = 0xC000042C,
        STATUS_NO_SECURITY_CONTEXT = 0xC000042D,
        STATUS_PKU2U_CERT_FAILURE = 0xC000042F,
        STATUS_BEYOND_VDL = 0xC0000432,
        STATUS_ENCOUNTERED_WRITE_IN_PROGRESS = 0xC0000433,
        STATUS_PTE_CHANGED = 0xC0000434,
        STATUS_PURGE_FAILED = 0xC0000435,
        STATUS_CRED_REQUIRES_CONFIRMATION = 0xC0000440,
        STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE = 0xC0000441,
        STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER = 0xC0000442,
        STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE = 0xC0000443,
        STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE = 0xC0000444,
        STATUS_CS_ENCRYPTION_FILE_NOT_CSE = 0xC0000445,
        STATUS_INVALID_LABEL = 0xC0000446,
        STATUS_DRIVER_PROCESS_TERMINATED = 0xC0000450,
        STATUS_AMBIGUOUS_SYSTEM_DEVICE = 0xC0000451,
        STATUS_SYSTEM_DEVICE_NOT_FOUND = 0xC0000452,
        STATUS_RESTART_BOOT_APPLICATION = 0xC0000453,
        STATUS_INSUFFICIENT_NVRAM_RESOURCES = 0xC0000454,
        STATUS_INVALID_SESSION = 0xC0000455,
        STATUS_THREAD_ALREADY_IN_SESSION = 0xC0000456,
        STATUS_THREAD_NOT_IN_SESSION = 0xC0000457,
        STATUS_INVALID_WEIGHT = 0xC0000458,
        STATUS_REQUEST_PAUSED = 0xC0000459,
        STATUS_NO_RANGES_PROCESSED = 0xC0000460,
        STATUS_DISK_RESOURCES_EXHAUSTED = 0xC0000461,
        STATUS_NEEDS_REMEDIATION = 0xC0000462,
        STATUS_DEVICE_FEATURE_NOT_SUPPORTED = 0xC0000463,
        STATUS_DEVICE_UNREACHABLE = 0xC0000464,
        STATUS_INVALID_TOKEN = 0xC0000465,
        STATUS_SERVER_UNAVAILABLE = 0xC0000466,
        STATUS_FILE_NOT_AVAILABLE = 0xC0000467,
        STATUS_DEVICE_INSUFFICIENT_RESOURCES = 0xC0000468,
        STATUS_PACKAGE_UPDATING = 0xC0000469,
        STATUS_NOT_READ_FROM_COPY = 0xC000046A,
        STATUS_FT_WRITE_FAILURE = 0xC000046B,
        STATUS_FT_DI_SCAN_REQUIRED = 0xC000046C,
        STATUS_OBJECT_NOT_EXTERNALLY_BACKED = 0xC000046D,
        STATUS_EXTERNAL_BACKING_PROVIDER_UNKNOWN = 0xC000046E,
        STATUS_COMPRESSION_NOT_BENEFICIAL = 0xC000046F,
        STATUS_DATA_CHECKSUM_ERROR = 0xC0000470,
        STATUS_INTERMIXED_KERNEL_EA_OPERATION = 0xC0000471,
        STATUS_TRIM_READ_ZERO_NOT_SUPPORTED = 0xC0000472,
        STATUS_TOO_MANY_SEGMENT_DESCRIPTORS = 0xC0000473,
        STATUS_INVALID_OFFSET_ALIGNMENT = 0xC0000474,
        STATUS_INVALID_FIELD_IN_PARAMETER_LIST = 0xC0000475,
        STATUS_OPERATION_IN_PROGRESS = 0xC0000476,
        STATUS_INVALID_INITIATOR_TARGET_PATH = 0xC0000477,
        STATUS_SCRUB_DATA_DISABLED = 0xC0000478,
        STATUS_NOT_REDUNDANT_STORAGE = 0xC0000479,
        STATUS_RESIDENT_FILE_NOT_SUPPORTED = 0xC000047A,
        STATUS_COMPRESSED_FILE_NOT_SUPPORTED = 0xC000047B,
        STATUS_DIRECTORY_NOT_SUPPORTED = 0xC000047C,
        STATUS_IO_OPERATION_TIMEOUT = 0xC000047D,
        STATUS_SYSTEM_NEEDS_REMEDIATION = 0xC000047E,
        STATUS_APPX_INTEGRITY_FAILURE_CLR_NGEN = 0xC000047F,
        STATUS_SHARE_UNAVAILABLE = 0xC0000480,
        STATUS_APISET_NOT_HOSTED = 0xC0000481,
        STATUS_APISET_NOT_PRESENT = 0xC0000482,
        STATUS_DEVICE_HARDWARE_ERROR = 0xC0000483,
        STATUS_FIRMWARE_SLOT_INVALID = 0xC0000484,
        STATUS_FIRMWARE_IMAGE_INVALID = 0xC0000485,
        STATUS_STORAGE_TOPOLOGY_ID_MISMATCH = 0xC0000486,
        STATUS_WIM_NOT_BOOTABLE = 0xC0000487,
        STATUS_BLOCKED_BY_PARENTAL_CONTROLS = 0xC0000488,
        STATUS_NEEDS_REGISTRATION = 0xC0000489,
        STATUS_QUOTA_ACTIVITY = 0xC000048A,
        STATUS_CALLBACK_INVOKE_INLINE = 0xC000048B,
        STATUS_BLOCK_TOO_MANY_REFERENCES = 0xC000048C,
        STATUS_MARKED_TO_DISALLOW_WRITES = 0xC000048D,
        STATUS_NETWORK_ACCESS_DENIED_EDP = 0xC000048E,
        STATUS_ENCLAVE_FAILURE = 0xC000048F,
        STATUS_PNP_NO_COMPAT_DRIVERS = 0xC0000490,
        STATUS_PNP_DRIVER_PACKAGE_NOT_FOUND = 0xC0000491,
        STATUS_PNP_DRIVER_CONFIGURATION_NOT_FOUND = 0xC0000492,
        STATUS_PNP_DRIVER_CONFIGURATION_INCOMPLETE = 0xC0000493,
        STATUS_PNP_FUNCTION_DRIVER_REQUIRED = 0xC0000494,
        STATUS_PNP_DEVICE_CONFIGURATION_PENDING = 0xC0000495,
        STATUS_DEVICE_HINT_NAME_BUFFER_TOO_SMALL = 0xC0000496,
        STATUS_PACKAGE_NOT_AVAILABLE = 0xC0000497,
        STATUS_DEVICE_IN_MAINTENANCE = 0xC0000499,
        STATUS_NOT_SUPPORTED_ON_DAX = 0xC000049A,
        STATUS_FREE_SPACE_TOO_FRAGMENTED = 0xC000049B,
        STATUS_DAX_MAPPING_EXISTS = 0xC000049C,
        STATUS_CHILD_PROCESS_BLOCKED = 0xC000049D,
        STATUS_STORAGE_LOST_DATA_PERSISTENCE = 0xC000049E,
        STATUS_VRF_CFG_ENABLED = 0xC000049F,
        STATUS_PARTITION_TERMINATING = 0xC00004A0,
        STATUS_EXTERNAL_SYSKEY_NOT_SUPPORTED = 0xC00004A1,
        STATUS_ENCLAVE_VIOLATION = 0xC00004A2,
        STATUS_FILE_PROTECTED_UNDER_DPL = 0xC00004A3,
        STATUS_VOLUME_NOT_CLUSTER_ALIGNED = 0xC00004A4,
        STATUS_NO_PHYSICALLY_ALIGNED_FREE_SPACE_FOUND = 0xC00004A5,
        STATUS_APPX_FILE_NOT_ENCRYPTED = 0xC00004A6,
        STATUS_RWRAW_ENCRYPTED_FILE_NOT_ENCRYPTED = 0xC00004A7,
        STATUS_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILEOFFSET = 0xC00004A8,
        STATUS_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILERANGE = 0xC00004A9,
        STATUS_RWRAW_ENCRYPTED_INVALID_EDATAINFO_PARAMETER = 0xC00004AA,
        STATUS_FT_READ_FAILURE = 0xC00004AB,
        STATUS_PATCH_CONFLICT = 0xC00004AC,
        STATUS_STORAGE_RESERVE_ID_INVALID = 0xC00004AD,
        STATUS_STORAGE_RESERVE_DOES_NOT_EXIST = 0xC00004AE,
        STATUS_STORAGE_RESERVE_ALREADY_EXISTS = 0xC00004AF,
        STATUS_STORAGE_RESERVE_NOT_EMPTY = 0xC00004B0,
        STATUS_NOT_A_DAX_VOLUME = 0xC00004B1,
        STATUS_NOT_DAX_MAPPABLE = 0xC00004B2,
        STATUS_CASE_DIFFERING_NAMES_IN_DIR = 0xC00004B3,
        STATUS_INVALID_TASK_NAME = 0xC0000500,
        STATUS_INVALID_TASK_INDEX = 0xC0000501,
        STATUS_THREAD_ALREADY_IN_TASK = 0xC0000502,
        STATUS_CALLBACK_BYPASS = 0xC0000503,
        STATUS_UNDEFINED_SCOPE = 0xC0000504,
        STATUS_INVALID_CAP = 0xC0000505,
        STATUS_NOT_GUI_PROCESS = 0xC0000506,
        STATUS_DEVICE_HUNG = 0xC0000507,
        STATUS_CONTAINER_ASSIGNED = 0xC0000508,
        STATUS_JOB_NO_CONTAINER = 0xC0000509,
        STATUS_DEVICE_UNRESPONSIVE = 0xC000050A,
        STATUS_REPARSE_POINT_ENCOUNTERED = 0xC000050B,
        STATUS_ATTRIBUTE_NOT_PRESENT = 0xC000050C,
        STATUS_NOT_A_TIERED_VOLUME = 0xC000050D,
        STATUS_ALREADY_HAS_STREAM_ID = 0xC000050E,
        STATUS_JOB_NOT_EMPTY = 0xC000050F,
        STATUS_ALREADY_INITIALIZED = 0xC0000510,
        STATUS_ENCLAVE_NOT_TERMINATED = 0xC0000511,
        STATUS_ENCLAVE_IS_TERMINATING = 0xC0000512,
        STATUS_SMB1_NOT_AVAILABLE = 0xC0000513,
        STATUS_SMR_GARBAGE_COLLECTION_REQUIRED = 0xC0000514,
        STATUS_FAIL_FAST_EXCEPTION = 0xC0000602,
        STATUS_IMAGE_CERT_REVOKED = 0xC0000603,
        STATUS_DYNAMIC_CODE_BLOCKED = 0xC0000604,
        STATUS_IMAGE_CERT_EXPIRED = 0xC0000605,
        STATUS_STRICT_CFG_VIOLATION = 0xC0000606,
        STATUS_SET_CONTEXT_DENIED = 0xC000060A,
        STATUS_CROSS_PARTITION_VIOLATION = 0xC000060B,
        STATUS_PORT_CLOSED = 0xC0000700,
        STATUS_MESSAGE_LOST = 0xC0000701,
        STATUS_INVALID_MESSAGE = 0xC0000702,
        STATUS_REQUEST_CANCELED = 0xC0000703,
        STATUS_RECURSIVE_DISPATCH = 0xC0000704,
        STATUS_LPC_RECEIVE_BUFFER_EXPECTED = 0xC0000705,
        STATUS_LPC_INVALID_CONNECTION_USAGE = 0xC0000706,
        STATUS_LPC_REQUESTS_NOT_ALLOWED = 0xC0000707,
        STATUS_RESOURCE_IN_USE = 0xC0000708,
        STATUS_HARDWARE_MEMORY_ERROR = 0xC0000709,
        STATUS_THREADPOOL_HANDLE_EXCEPTION = 0xC000070A,
        STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED = 0xC000070B,
        STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED = 0xC000070C,
        STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED = 0xC000070D,
        STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED = 0xC000070E,
        STATUS_THREADPOOL_RELEASED_DURING_OPERATION = 0xC000070F,
        STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING = 0xC0000710,
        STATUS_APC_RETURNED_WHILE_IMPERSONATING = 0xC0000711,
        STATUS_PROCESS_IS_PROTECTED = 0xC0000712,
        STATUS_MCA_EXCEPTION = 0xC0000713,
        STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE = 0xC0000714,
        STATUS_SYMLINK_CLASS_DISABLED = 0xC0000715,
        STATUS_INVALID_IDN_NORMALIZATION = 0xC0000716,
        STATUS_NO_UNICODE_TRANSLATION = 0xC0000717,
        STATUS_ALREADY_REGISTERED = 0xC0000718,
        STATUS_CONTEXT_MISMATCH = 0xC0000719,
        STATUS_PORT_ALREADY_HAS_COMPLETION_LIST = 0xC000071A,
        STATUS_CALLBACK_RETURNED_THREAD_PRIORITY = 0xC000071B,
        STATUS_INVALID_THREAD = 0xC000071C,
        STATUS_CALLBACK_RETURNED_TRANSACTION = 0xC000071D,
        STATUS_CALLBACK_RETURNED_LDR_LOCK = 0xC000071E,
        STATUS_CALLBACK_RETURNED_LANG = 0xC000071F,
        STATUS_CALLBACK_RETURNED_PRI_BACK = 0xC0000720,
        STATUS_CALLBACK_RETURNED_THREAD_AFFINITY = 0xC0000721,
        STATUS_LPC_HANDLE_COUNT_EXCEEDED = 0xC0000722,
        STATUS_EXECUTABLE_MEMORY_WRITE = 0xC0000723,
        STATUS_KERNEL_EXECUTABLE_MEMORY_WRITE = 0xC0000724,
        STATUS_ATTACHED_EXECUTABLE_MEMORY_WRITE = 0xC0000725,
        STATUS_TRIGGERED_EXECUTABLE_MEMORY_WRITE = 0xC0000726,
        STATUS_DISK_REPAIR_DISABLED = 0xC0000800,
        STATUS_DS_DOMAIN_RENAME_IN_PROGRESS = 0xC0000801,
        STATUS_DISK_QUOTA_EXCEEDED = 0xC0000802,
        STATUS_DATA_LOST_REPAIR = 0x80000803,
        STATUS_CONTENT_BLOCKED = 0xC0000804,
        STATUS_BAD_CLUSTERS = 0xC0000805,
        STATUS_VOLUME_DIRTY = 0xC0000806,
        STATUS_DISK_REPAIR_REDIRECTED = 0x40000807,
        STATUS_DISK_REPAIR_UNSUCCESSFUL = 0xC0000808,
        STATUS_CORRUPT_LOG_OVERFULL = 0xC0000809,
        STATUS_CORRUPT_LOG_CORRUPTED = 0xC000080A,
        STATUS_CORRUPT_LOG_UNAVAILABLE = 0xC000080B,
        STATUS_CORRUPT_LOG_DELETED_FULL = 0xC000080C,
        STATUS_CORRUPT_LOG_CLEARED = 0xC000080D,
        STATUS_ORPHAN_NAME_EXHAUSTED = 0xC000080E,
        STATUS_PROACTIVE_SCAN_IN_PROGRESS = 0xC000080F,
        STATUS_ENCRYPTED_IO_NOT_POSSIBLE = 0xC0000810,
        STATUS_CORRUPT_LOG_UPLEVEL_RECORDS = 0xC0000811,
        STATUS_FILE_CHECKED_OUT = 0xC0000901,
        STATUS_CHECKOUT_REQUIRED = 0xC0000902,
        STATUS_BAD_FILE_TYPE = 0xC0000903,
        STATUS_FILE_TOO_LARGE = 0xC0000904,
        STATUS_FORMS_AUTH_REQUIRED = 0xC0000905,
        STATUS_VIRUS_INFECTED = 0xC0000906,
        STATUS_VIRUS_DELETED = 0xC0000907,
        STATUS_BAD_MCFG_TABLE = 0xC0000908,
        STATUS_CANNOT_BREAK_OPLOCK = 0xC0000909,
        STATUS_BAD_KEY = 0xC000090A,
        STATUS_BAD_DATA = 0xC000090B,
        STATUS_NO_KEY = 0xC000090C,
        STATUS_FILE_HANDLE_REVOKED = 0xC0000910,
        STATUS_WOW_ASSERTION = 0xC0009898,
        STATUS_INVALID_SIGNATURE = 0xC000A000,
        STATUS_HMAC_NOT_SUPPORTED = 0xC000A001,
        STATUS_AUTH_TAG_MISMATCH = 0xC000A002,
        STATUS_INVALID_STATE_TRANSITION = 0xC000A003,
        STATUS_INVALID_KERNEL_INFO_VERSION = 0xC000A004,
        STATUS_INVALID_PEP_INFO_VERSION = 0xC000A005,
        STATUS_HANDLE_REVOKED = 0xC000A006,
        STATUS_EOF_ON_GHOSTED_RANGE = 0xC000A007,
        STATUS_IPSEC_QUEUE_OVERFLOW = 0xC000A010,
        STATUS_ND_QUEUE_OVERFLOW = 0xC000A011,
        STATUS_HOPLIMIT_EXCEEDED = 0xC000A012,
        STATUS_PROTOCOL_NOT_SUPPORTED = 0xC000A013,
        STATUS_FASTPATH_REJECTED = 0xC000A014,
        STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED = 0xC000A080,
        STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR = 0xC000A081,
        STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR = 0xC000A082,
        STATUS_XML_PARSE_ERROR = 0xC000A083,
        STATUS_XMLDSIG_ERROR = 0xC000A084,
        STATUS_WRONG_COMPARTMENT = 0xC000A085,
        STATUS_AUTHIP_FAILURE = 0xC000A086,
        STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS = 0xC000A087,
        STATUS_DS_OID_NOT_FOUND = 0xC000A088,
        STATUS_INCORRECT_ACCOUNT_TYPE = 0xC000A089,
        STATUS_HASH_NOT_SUPPORTED = 0xC000A100,
        STATUS_HASH_NOT_PRESENT = 0xC000A101,
        STATUS_SECONDARY_IC_PROVIDER_NOT_REGISTERED = 0xC000A121,
        STATUS_GPIO_CLIENT_INFORMATION_INVALID = 0xC000A122,
        STATUS_GPIO_VERSION_NOT_SUPPORTED = 0xC000A123,
        STATUS_GPIO_INVALID_REGISTRATION_PACKET = 0xC000A124,
        STATUS_GPIO_OPERATION_DENIED = 0xC000A125,
        STATUS_GPIO_INCOMPATIBLE_CONNECT_MODE = 0xC000A126,
        STATUS_GPIO_INTERRUPT_ALREADY_UNMASKED = 0x8000A127,
        STATUS_CANNOT_SWITCH_RUNLEVEL = 0xC000A141,
        STATUS_INVALID_RUNLEVEL_SETTING = 0xC000A142,
        STATUS_RUNLEVEL_SWITCH_TIMEOUT = 0xC000A143,
        STATUS_SERVICES_FAILED_AUTOSTART = 0x4000A144,
        STATUS_RUNLEVEL_SWITCH_AGENT_TIMEOUT = 0xC000A145,
        STATUS_RUNLEVEL_SWITCH_IN_PROGRESS = 0xC000A146,
        STATUS_NOT_APPCONTAINER = 0xC000A200,
        STATUS_NOT_SUPPORTED_IN_APPCONTAINER = 0xC000A201,
        STATUS_INVALID_PACKAGE_SID_LENGTH = 0xC000A202,
        STATUS_LPAC_ACCESS_DENIED = 0xC000A203,
        STATUS_ADMINLESS_ACCESS_DENIED = 0xC000A204,
        STATUS_APP_DATA_NOT_FOUND = 0xC000A281,
        STATUS_APP_DATA_EXPIRED = 0xC000A282,
        STATUS_APP_DATA_CORRUPT = 0xC000A283,
        STATUS_APP_DATA_LIMIT_EXCEEDED = 0xC000A284,
        STATUS_APP_DATA_REBOOT_REQUIRED = 0xC000A285,
        STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED = 0xC000A2A1,
        STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED = 0xC000A2A2,
        STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED = 0xC000A2A3,
        STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED = 0xC000A2A4,
        STATUS_WOF_WIM_HEADER_CORRUPT = 0xC000A2A5,
        STATUS_WOF_WIM_RESOURCE_TABLE_CORRUPT = 0xC000A2A6,
        STATUS_WOF_FILE_RESOURCE_TABLE_CORRUPT = 0xC000A2A7,
        STATUS_FILE_SYSTEM_VIRTUALIZATION_UNAVAILABLE = 0xC000CE01,
        STATUS_FILE_SYSTEM_VIRTUALIZATION_METADATA_CORRUPT = 0xC000CE02,
        STATUS_FILE_SYSTEM_VIRTUALIZATION_BUSY = 0xC000CE03,
        STATUS_FILE_SYSTEM_VIRTUALIZATION_PROVIDER_UNKNOWN = 0xC000CE04,
        STATUS_FILE_SYSTEM_VIRTUALIZATION_INVALID_OPERATION = 0xC000CE05,
        STATUS_CLOUD_FILE_SYNC_ROOT_METADATA_CORRUPT = 0xC000CF00,
        STATUS_CLOUD_FILE_PROVIDER_NOT_RUNNING = 0xC000CF01,
        STATUS_CLOUD_FILE_METADATA_CORRUPT = 0xC000CF02,
        STATUS_CLOUD_FILE_METADATA_TOO_LARGE = 0xC000CF03,
        STATUS_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE = 0x8000CF04,
        STATUS_CLOUD_FILE_TOO_MANY_PROPERTY_BLOBS = 0x8000CF05,
        STATUS_CLOUD_FILE_PROPERTY_VERSION_NOT_SUPPORTED = 0xC000CF06,
        STATUS_NOT_A_CLOUD_FILE = 0xC000CF07,
        STATUS_CLOUD_FILE_NOT_IN_SYNC = 0xC000CF08,
        STATUS_CLOUD_FILE_ALREADY_CONNECTED = 0xC000CF09,
        STATUS_CLOUD_FILE_NOT_SUPPORTED = 0xC000CF0A,
        STATUS_CLOUD_FILE_INVALID_REQUEST = 0xC000CF0B,
        STATUS_CLOUD_FILE_READ_ONLY_VOLUME = 0xC000CF0C,
        STATUS_CLOUD_FILE_CONNECTED_PROVIDER_ONLY = 0xC000CF0D,
        STATUS_CLOUD_FILE_VALIDATION_FAILED = 0xC000CF0E,
        STATUS_CLOUD_FILE_AUTHENTICATION_FAILED = 0xC000CF0F,
        STATUS_CLOUD_FILE_INSUFFICIENT_RESOURCES = 0xC000CF10,
        STATUS_CLOUD_FILE_NETWORK_UNAVAILABLE = 0xC000CF11,
        STATUS_CLOUD_FILE_UNSUCCESSFUL = 0xC000CF12,
        STATUS_CLOUD_FILE_NOT_UNDER_SYNC_ROOT = 0xC000CF13,
        STATUS_CLOUD_FILE_IN_USE = 0xC000CF14,
        STATUS_CLOUD_FILE_PINNED = 0xC000CF15,
        STATUS_CLOUD_FILE_REQUEST_ABORTED = 0xC000CF16,
        STATUS_CLOUD_FILE_PROPERTY_CORRUPT = 0xC000CF17,
        STATUS_CLOUD_FILE_ACCESS_DENIED = 0xC000CF18,
        STATUS_CLOUD_FILE_INCOMPATIBLE_HARDLINKS = 0xC000CF19,
        STATUS_CLOUD_FILE_PROPERTY_LOCK_CONFLICT = 0xC000CF1A,
        STATUS_CLOUD_FILE_REQUEST_CANCELED = 0xC000CF1B,
        STATUS_CLOUD_FILE_PROVIDER_TERMINATED = 0xC000CF1D,
        STATUS_NOT_A_CLOUD_SYNC_ROOT = 0xC000CF1E,
        DBG_NO_STATE_CHANGE = 0xC0010001,
        DBG_APP_NOT_IDLE = 0xC0010002,
        RPC_NT_INVALID_STRING_BINDING = 0xC0020001,
        RPC_NT_WRONG_KIND_OF_BINDING = 0xC0020002,
        RPC_NT_INVALID_BINDING = 0xC0020003,
        RPC_NT_PROTSEQ_NOT_SUPPORTED = 0xC0020004,
        RPC_NT_INVALID_RPC_PROTSEQ = 0xC0020005,
        RPC_NT_INVALID_STRING_UUID = 0xC0020006,
        RPC_NT_INVALID_ENDPOINT_FORMAT = 0xC0020007,
        RPC_NT_INVALID_NET_ADDR = 0xC0020008,
        RPC_NT_NO_ENDPOINT_FOUND = 0xC0020009,
        RPC_NT_INVALID_TIMEOUT = 0xC002000A,
        RPC_NT_OBJECT_NOT_FOUND = 0xC002000B,
        RPC_NT_ALREADY_REGISTERED = 0xC002000C,
        RPC_NT_TYPE_ALREADY_REGISTERED = 0xC002000D,
        RPC_NT_ALREADY_LISTENING = 0xC002000E,
        RPC_NT_NO_PROTSEQS_REGISTERED = 0xC002000F,
        RPC_NT_NOT_LISTENING = 0xC0020010,
        RPC_NT_UNKNOWN_MGR_TYPE = 0xC0020011,
        RPC_NT_UNKNOWN_IF = 0xC0020012,
        RPC_NT_NO_BINDINGS = 0xC0020013,
        RPC_NT_NO_PROTSEQS = 0xC0020014,
        RPC_NT_CANT_CREATE_ENDPOINT = 0xC0020015,
        RPC_NT_OUT_OF_RESOURCES = 0xC0020016,
        RPC_NT_SERVER_UNAVAILABLE = 0xC0020017,
        RPC_NT_SERVER_TOO_BUSY = 0xC0020018,
        RPC_NT_INVALID_NETWORK_OPTIONS = 0xC0020019,
        RPC_NT_NO_CALL_ACTIVE = 0xC002001A,
        RPC_NT_CALL_FAILED = 0xC002001B,
        RPC_NT_CALL_FAILED_DNE = 0xC002001C,
        RPC_NT_PROTOCOL_ERROR = 0xC002001D,
        RPC_NT_UNSUPPORTED_TRANS_SYN = 0xC002001F,
        RPC_NT_UNSUPPORTED_TYPE = 0xC0020021,
        RPC_NT_INVALID_TAG = 0xC0020022,
        RPC_NT_INVALID_BOUND = 0xC0020023,
        RPC_NT_NO_ENTRY_NAME = 0xC0020024,
        RPC_NT_INVALID_NAME_SYNTAX = 0xC0020025,
        RPC_NT_UNSUPPORTED_NAME_SYNTAX = 0xC0020026,
        RPC_NT_UUID_NO_ADDRESS = 0xC0020028,
        RPC_NT_DUPLICATE_ENDPOINT = 0xC0020029,
        RPC_NT_UNKNOWN_AUTHN_TYPE = 0xC002002A,
        RPC_NT_MAX_CALLS_TOO_SMALL = 0xC002002B,
        RPC_NT_STRING_TOO_LONG = 0xC002002C,
        RPC_NT_PROTSEQ_NOT_FOUND = 0xC002002D,
        RPC_NT_PROCNUM_OUT_OF_RANGE = 0xC002002E,
        RPC_NT_BINDING_HAS_NO_AUTH = 0xC002002F,
        RPC_NT_UNKNOWN_AUTHN_SERVICE = 0xC0020030,
        RPC_NT_UNKNOWN_AUTHN_LEVEL = 0xC0020031,
        RPC_NT_INVALID_AUTH_IDENTITY = 0xC0020032,
        RPC_NT_UNKNOWN_AUTHZ_SERVICE = 0xC0020033,
        EPT_NT_INVALID_ENTRY = 0xC0020034,
        EPT_NT_CANT_PERFORM_OP = 0xC0020035,
        EPT_NT_NOT_REGISTERED = 0xC0020036,
        RPC_NT_NOTHING_TO_EXPORT = 0xC0020037,
        RPC_NT_INCOMPLETE_NAME = 0xC0020038,
        RPC_NT_INVALID_VERS_OPTION = 0xC0020039,
        RPC_NT_NO_MORE_MEMBERS = 0xC002003A,
        RPC_NT_NOT_ALL_OBJS_UNEXPORTED = 0xC002003B,
        RPC_NT_INTERFACE_NOT_FOUND = 0xC002003C,
        RPC_NT_ENTRY_ALREADY_EXISTS = 0xC002003D,
        RPC_NT_ENTRY_NOT_FOUND = 0xC002003E,
        RPC_NT_NAME_SERVICE_UNAVAILABLE = 0xC002003F,
        RPC_NT_INVALID_NAF_ID = 0xC0020040,
        RPC_NT_CANNOT_SUPPORT = 0xC0020041,
        RPC_NT_NO_CONTEXT_AVAILABLE = 0xC0020042,
        RPC_NT_INTERNAL_ERROR = 0xC0020043,
        RPC_NT_ZERO_DIVIDE = 0xC0020044,
        RPC_NT_ADDRESS_ERROR = 0xC0020045,
        RPC_NT_FP_DIV_ZERO = 0xC0020046,
        RPC_NT_FP_UNDERFLOW = 0xC0020047,
        RPC_NT_FP_OVERFLOW = 0xC0020048,
        RPC_NT_NO_MORE_ENTRIES = 0xC0030001,
        RPC_NT_SS_CHAR_TRANS_OPEN_FAIL = 0xC0030002,
        RPC_NT_SS_CHAR_TRANS_SHORT_FILE = 0xC0030003,
        RPC_NT_SS_IN_NULL_CONTEXT = 0xC0030004,
        RPC_NT_SS_CONTEXT_MISMATCH = 0xC0030005,
        RPC_NT_SS_CONTEXT_DAMAGED = 0xC0030006,
        RPC_NT_SS_HANDLES_MISMATCH = 0xC0030007,
        RPC_NT_SS_CANNOT_GET_CALL_HANDLE = 0xC0030008,
        RPC_NT_NULL_REF_POINTER = 0xC0030009,
        RPC_NT_ENUM_VALUE_OUT_OF_RANGE = 0xC003000A,
        RPC_NT_BYTE_COUNT_TOO_SMALL = 0xC003000B,
        RPC_NT_BAD_STUB_DATA = 0xC003000C,
        RPC_NT_CALL_IN_PROGRESS = 0xC0020049,
        RPC_NT_NO_MORE_BINDINGS = 0xC002004A,
        RPC_NT_GROUP_MEMBER_NOT_FOUND = 0xC002004B,
        EPT_NT_CANT_CREATE = 0xC002004C,
        RPC_NT_INVALID_OBJECT = 0xC002004D,
        RPC_NT_NO_INTERFACES = 0xC002004F,
        RPC_NT_CALL_CANCELLED = 0xC0020050,
        RPC_NT_BINDING_INCOMPLETE = 0xC0020051,
        RPC_NT_COMM_FAILURE = 0xC0020052,
        RPC_NT_UNSUPPORTED_AUTHN_LEVEL = 0xC0020053,
        RPC_NT_NO_PRINC_NAME = 0xC0020054,
        RPC_NT_NOT_RPC_ERROR = 0xC0020055,
        RPC_NT_UUID_LOCAL_ONLY = 0x40020056,
        RPC_NT_SEC_PKG_ERROR = 0xC0020057,
        RPC_NT_NOT_CANCELLED = 0xC0020058,
        RPC_NT_INVALID_ES_ACTION = 0xC0030059,
        RPC_NT_WRONG_ES_VERSION = 0xC003005A,
        RPC_NT_WRONG_STUB_VERSION = 0xC003005B,
        RPC_NT_INVALID_PIPE_OBJECT = 0xC003005C,
        RPC_NT_INVALID_PIPE_OPERATION = 0xC003005D,
        RPC_NT_WRONG_PIPE_VERSION = 0xC003005E,
        RPC_NT_PIPE_CLOSED = 0xC003005F,
        RPC_NT_PIPE_DISCIPLINE_ERROR = 0xC0030060,
        RPC_NT_PIPE_EMPTY = 0xC0030061,
        RPC_NT_INVALID_ASYNC_HANDLE = 0xC0020062,
        RPC_NT_INVALID_ASYNC_CALL = 0xC0020063,
        RPC_NT_PROXY_ACCESS_DENIED = 0xC0020064,
        RPC_NT_COOKIE_AUTH_FAILED = 0xC0020065,
        RPC_NT_SEND_INCOMPLETE = 0x400200AF,
        STATUS_ACPI_INVALID_OPCODE = 0xC0140001,
        STATUS_ACPI_STACK_OVERFLOW = 0xC0140002,
        STATUS_ACPI_ASSERT_FAILED = 0xC0140003,
        STATUS_ACPI_INVALID_INDEX = 0xC0140004,
        STATUS_ACPI_INVALID_ARGUMENT = 0xC0140005,
        STATUS_ACPI_FATAL = 0xC0140006,
        STATUS_ACPI_INVALID_SUPERNAME = 0xC0140007,
        STATUS_ACPI_INVALID_ARGTYPE = 0xC0140008,
        STATUS_ACPI_INVALID_OBJTYPE = 0xC0140009,
        STATUS_ACPI_INVALID_TARGETTYPE = 0xC014000A,
        STATUS_ACPI_INCORRECT_ARGUMENT_COUNT = 0xC014000B,
        STATUS_ACPI_ADDRESS_NOT_MAPPED = 0xC014000C,
        STATUS_ACPI_INVALID_EVENTTYPE = 0xC014000D,
        STATUS_ACPI_HANDLER_COLLISION = 0xC014000E,
        STATUS_ACPI_INVALID_DATA = 0xC014000F,
        STATUS_ACPI_INVALID_REGION = 0xC0140010,
        STATUS_ACPI_INVALID_ACCESS_SIZE = 0xC0140011,
        STATUS_ACPI_ACQUIRE_GLOBAL_LOCK = 0xC0140012,
        STATUS_ACPI_ALREADY_INITIALIZED = 0xC0140013,
        STATUS_ACPI_NOT_INITIALIZED = 0xC0140014,
        STATUS_ACPI_INVALID_MUTEX_LEVEL = 0xC0140015,
        STATUS_ACPI_MUTEX_NOT_OWNED = 0xC0140016,
        STATUS_ACPI_MUTEX_NOT_OWNER = 0xC0140017,
        STATUS_ACPI_RS_ACCESS = 0xC0140018,
        STATUS_ACPI_INVALID_TABLE = 0xC0140019,
        STATUS_ACPI_REG_HANDLER_FAILED = 0xC0140020,
        STATUS_ACPI_POWER_REQUEST_FAILED = 0xC0140021,
        STATUS_CTX_WINSTATION_NAME_INVALID = 0xC00A0001,
        STATUS_CTX_INVALID_PD = 0xC00A0002,
        STATUS_CTX_PD_NOT_FOUND = 0xC00A0003,
        STATUS_CTX_CDM_CONNECT = 0x400A0004,
        STATUS_CTX_CDM_DISCONNECT = 0x400A0005,
        STATUS_CTX_CLOSE_PENDING = 0xC00A0006,
        STATUS_CTX_NO_OUTBUF = 0xC00A0007,
        STATUS_CTX_MODEM_INF_NOT_FOUND = 0xC00A0008,
        STATUS_CTX_INVALID_MODEMNAME = 0xC00A0009,
        STATUS_CTX_RESPONSE_ERROR = 0xC00A000A,
        STATUS_CTX_MODEM_RESPONSE_TIMEOUT = 0xC00A000B,
        STATUS_CTX_MODEM_RESPONSE_NO_CARRIER = 0xC00A000C,
        STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE = 0xC00A000D,
        STATUS_CTX_MODEM_RESPONSE_BUSY = 0xC00A000E,
        STATUS_CTX_MODEM_RESPONSE_VOICE = 0xC00A000F,
        STATUS_CTX_TD_ERROR = 0xC00A0010,
        STATUS_CTX_LICENSE_CLIENT_INVALID = 0xC00A0012,
        STATUS_CTX_LICENSE_NOT_AVAILABLE = 0xC00A0013,
        STATUS_CTX_LICENSE_EXPIRED = 0xC00A0014,
        STATUS_CTX_WINSTATION_NOT_FOUND = 0xC00A0015,
        STATUS_CTX_WINSTATION_NAME_COLLISION = 0xC00A0016,
        STATUS_CTX_WINSTATION_BUSY = 0xC00A0017,
        STATUS_CTX_BAD_VIDEO_MODE = 0xC00A0018,
        STATUS_CTX_GRAPHICS_INVALID = 0xC00A0022,
        STATUS_CTX_NOT_CONSOLE = 0xC00A0024,
        STATUS_CTX_CLIENT_QUERY_TIMEOUT = 0xC00A0026,
        STATUS_CTX_CONSOLE_DISCONNECT = 0xC00A0027,
        STATUS_CTX_CONSOLE_CONNECT = 0xC00A0028,
        STATUS_CTX_SHADOW_DENIED = 0xC00A002A,
        STATUS_CTX_WINSTATION_ACCESS_DENIED = 0xC00A002B,
        STATUS_CTX_INVALID_WD = 0xC00A002E,
        STATUS_CTX_WD_NOT_FOUND = 0xC00A002F,
        STATUS_CTX_SHADOW_INVALID = 0xC00A0030,
        STATUS_CTX_SHADOW_DISABLED = 0xC00A0031,
        STATUS_RDP_PROTOCOL_ERROR = 0xC00A0032,
        STATUS_CTX_CLIENT_LICENSE_NOT_SET = 0xC00A0033,
        STATUS_CTX_CLIENT_LICENSE_IN_USE = 0xC00A0034,
        STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE = 0xC00A0035,
        STATUS_CTX_SHADOW_NOT_RUNNING = 0xC00A0036,
        STATUS_CTX_LOGON_DISABLED = 0xC00A0037,
        STATUS_CTX_SECURITY_LAYER_ERROR = 0xC00A0038,
        STATUS_TS_INCOMPATIBLE_SESSIONS = 0xC00A0039,
        STATUS_TS_VIDEO_SUBSYSTEM_ERROR = 0xC00A003A,
        STATUS_PNP_BAD_MPS_TABLE = 0xC0040035,
        STATUS_PNP_TRANSLATION_FAILED = 0xC0040036,
        STATUS_PNP_IRQ_TRANSLATION_FAILED = 0xC0040037,
        STATUS_PNP_INVALID_ID = 0xC0040038,
        STATUS_IO_REISSUE_AS_CACHED = 0xC0040039,
        STATUS_MUI_FILE_NOT_FOUND = 0xC00B0001,
        STATUS_MUI_INVALID_FILE = 0xC00B0002,
        STATUS_MUI_INVALID_RC_CONFIG = 0xC00B0003,
        STATUS_MUI_INVALID_LOCALE_NAME = 0xC00B0004,
        STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME = 0xC00B0005,
        STATUS_MUI_FILE_NOT_LOADED = 0xC00B0006,
        STATUS_RESOURCE_ENUM_USER_STOP = 0xC00B0007,
        STATUS_FLT_NO_HANDLER_DEFINED = 0xC01C0001,
        STATUS_FLT_CONTEXT_ALREADY_DEFINED = 0xC01C0002,
        STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST = 0xC01C0003,
        STATUS_FLT_DISALLOW_FAST_IO = 0xC01C0004,
        STATUS_FLT_INVALID_NAME_REQUEST = 0xC01C0005,
        STATUS_FLT_NOT_SAFE_TO_POST_OPERATION = 0xC01C0006,
        STATUS_FLT_NOT_INITIALIZED = 0xC01C0007,
        STATUS_FLT_FILTER_NOT_READY = 0xC01C0008,
        STATUS_FLT_POST_OPERATION_CLEANUP = 0xC01C0009,
        STATUS_FLT_INTERNAL_ERROR = 0xC01C000A,
        STATUS_FLT_DELETING_OBJECT = 0xC01C000B,
        STATUS_FLT_MUST_BE_NONPAGED_POOL = 0xC01C000C,
        STATUS_FLT_DUPLICATE_ENTRY = 0xC01C000D,
        STATUS_FLT_CBDQ_DISABLED = 0xC01C000E,
        STATUS_FLT_DO_NOT_ATTACH = 0xC01C000F,
        STATUS_FLT_DO_NOT_DETACH = 0xC01C0010,
        STATUS_FLT_INSTANCE_ALTITUDE_COLLISION = 0xC01C0011,
        STATUS_FLT_INSTANCE_NAME_COLLISION = 0xC01C0012,
        STATUS_FLT_FILTER_NOT_FOUND = 0xC01C0013,
        STATUS_FLT_VOLUME_NOT_FOUND = 0xC01C0014,
        STATUS_FLT_INSTANCE_NOT_FOUND = 0xC01C0015,
        STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND = 0xC01C0016,
        STATUS_FLT_INVALID_CONTEXT_REGISTRATION = 0xC01C0017,
        STATUS_FLT_NAME_CACHE_MISS = 0xC01C0018,
        STATUS_FLT_NO_DEVICE_OBJECT = 0xC01C0019,
        STATUS_FLT_VOLUME_ALREADY_MOUNTED = 0xC01C001A,
        STATUS_FLT_ALREADY_ENLISTED = 0xC01C001B,
        STATUS_FLT_CONTEXT_ALREADY_LINKED = 0xC01C001C,
        STATUS_FLT_NO_WAITER_FOR_REPLY = 0xC01C0020,
        STATUS_FLT_REGISTRATION_BUSY = 0xC01C0023,
        STATUS_SXS_SECTION_NOT_FOUND = 0xC0150001,
        STATUS_SXS_CANT_GEN_ACTCTX = 0xC0150002,
        STATUS_SXS_INVALID_ACTCTXDATA_FORMAT = 0xC0150003,
        STATUS_SXS_ASSEMBLY_NOT_FOUND = 0xC0150004,
        STATUS_SXS_MANIFEST_FORMAT_ERROR = 0xC0150005,
        STATUS_SXS_MANIFEST_PARSE_ERROR = 0xC0150006,
        STATUS_SXS_ACTIVATION_CONTEXT_DISABLED = 0xC0150007,
        STATUS_SXS_KEY_NOT_FOUND = 0xC0150008,
        STATUS_SXS_VERSION_CONFLICT = 0xC0150009,
        STATUS_SXS_WRONG_SECTION_TYPE = 0xC015000A,
        STATUS_SXS_THREAD_QUERIES_DISABLED = 0xC015000B,
        STATUS_SXS_ASSEMBLY_MISSING = 0xC015000C,
        STATUS_SXS_RELEASE_ACTIVATION_CONTEXT = 0x4015000D,
        STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET = 0xC015000E,
        STATUS_SXS_EARLY_DEACTIVATION = 0xC015000F,
        STATUS_SXS_INVALID_DEACTIVATION = 0xC0150010,
        STATUS_SXS_MULTIPLE_DEACTIVATION = 0xC0150011,
        STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY = 0xC0150012,
        STATUS_SXS_PROCESS_TERMINATION_REQUESTED = 0xC0150013,
        STATUS_SXS_CORRUPT_ACTIVATION_STACK = 0xC0150014,
        STATUS_SXS_CORRUPTION = 0xC0150015,
        STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE = 0xC0150016,
        STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME = 0xC0150017,
        STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE = 0xC0150018,
        STATUS_SXS_IDENTITY_PARSE_ERROR = 0xC0150019,
        STATUS_SXS_COMPONENT_STORE_CORRUPT = 0xC015001A,
        STATUS_SXS_FILE_HASH_MISMATCH = 0xC015001B,
        STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT = 0xC015001C,
        STATUS_SXS_IDENTITIES_DIFFERENT = 0xC015001D,
        STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT = 0xC015001E,
        STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY = 0xC015001F,
        STATUS_ADVANCED_INSTALLER_FAILED = 0xC0150020,
        STATUS_XML_ENCODING_MISMATCH = 0xC0150021,
        STATUS_SXS_MANIFEST_TOO_BIG = 0xC0150022,
        STATUS_SXS_SETTING_NOT_REGISTERED = 0xC0150023,
        STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE = 0xC0150024,
        STATUS_SMI_PRIMITIVE_INSTALLER_FAILED = 0xC0150025,
        STATUS_GENERIC_COMMAND_FAILED = 0xC0150026,
        STATUS_SXS_FILE_HASH_MISSING = 0xC0150027,
        STATUS_CLUSTER_INVALID_NODE = 0xC0130001,
        STATUS_CLUSTER_NODE_EXISTS = 0xC0130002,
        STATUS_CLUSTER_JOIN_IN_PROGRESS = 0xC0130003,
        STATUS_CLUSTER_NODE_NOT_FOUND = 0xC0130004,
        STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND = 0xC0130005,
        STATUS_CLUSTER_NETWORK_EXISTS = 0xC0130006,
        STATUS_CLUSTER_NETWORK_NOT_FOUND = 0xC0130007,
        STATUS_CLUSTER_NETINTERFACE_EXISTS = 0xC0130008,
        STATUS_CLUSTER_NETINTERFACE_NOT_FOUND = 0xC0130009,
        STATUS_CLUSTER_INVALID_REQUEST = 0xC013000A,
        STATUS_CLUSTER_INVALID_NETWORK_PROVIDER = 0xC013000B,
        STATUS_CLUSTER_NODE_DOWN = 0xC013000C,
        STATUS_CLUSTER_NODE_UNREACHABLE = 0xC013000D,
        STATUS_CLUSTER_NODE_NOT_MEMBER = 0xC013000E,
        STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS = 0xC013000F,
        STATUS_CLUSTER_INVALID_NETWORK = 0xC0130010,
        STATUS_CLUSTER_NO_NET_ADAPTERS = 0xC0130011,
        STATUS_CLUSTER_NODE_UP = 0xC0130012,
        STATUS_CLUSTER_NODE_PAUSED = 0xC0130013,
        STATUS_CLUSTER_NODE_NOT_PAUSED = 0xC0130014,
        STATUS_CLUSTER_NO_SECURITY_CONTEXT = 0xC0130015,
        STATUS_CLUSTER_NETWORK_NOT_INTERNAL = 0xC0130016,
        STATUS_CLUSTER_POISONED = 0xC0130017,
        STATUS_CLUSTER_NON_CSV_PATH = 0xC0130018,
        STATUS_CLUSTER_CSV_VOLUME_NOT_LOCAL = 0xC0130019,
        STATUS_CLUSTER_CSV_READ_OPLOCK_BREAK_IN_PROGRESS = 0xC0130020,
        STATUS_CLUSTER_CSV_AUTO_PAUSE_ERROR = 0xC0130021,
        STATUS_CLUSTER_CSV_REDIRECTED = 0xC0130022,
        STATUS_CLUSTER_CSV_NOT_REDIRECTED = 0xC0130023,
        STATUS_CLUSTER_CSV_VOLUME_DRAINING = 0xC0130024,
        STATUS_CLUSTER_CSV_SNAPSHOT_CREATION_IN_PROGRESS = 0xC0130025,
        STATUS_CLUSTER_CSV_VOLUME_DRAINING_SUCCEEDED_DOWNLEVEL = 0xC0130026,
        STATUS_CLUSTER_CSV_NO_SNAPSHOTS = 0xC0130027,
        STATUS_CSV_IO_PAUSE_TIMEOUT = 0xC0130028,
        STATUS_CLUSTER_CSV_INVALID_HANDLE = 0xC0130029,
        STATUS_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR = 0xC0130030,
        STATUS_CLUSTER_CAM_TICKET_REPLAY_DETECTED = 0xC0130031,
        STATUS_TRANSACTIONAL_CONFLICT = 0xC0190001,
        STATUS_INVALID_TRANSACTION = 0xC0190002,
        STATUS_TRANSACTION_NOT_ACTIVE = 0xC0190003,
        STATUS_TM_INITIALIZATION_FAILED = 0xC0190004,
        STATUS_RM_NOT_ACTIVE = 0xC0190005,
        STATUS_RM_METADATA_CORRUPT = 0xC0190006,
        STATUS_TRANSACTION_NOT_JOINED = 0xC0190007,
        STATUS_DIRECTORY_NOT_RM = 0xC0190008,
        STATUS_COULD_NOT_RESIZE_LOG = 0x80190009,
        STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE = 0xC019000A,
        STATUS_LOG_RESIZE_INVALID_SIZE = 0xC019000B,
        STATUS_REMOTE_FILE_VERSION_MISMATCH = 0xC019000C,
        STATUS_CRM_PROTOCOL_ALREADY_EXISTS = 0xC019000F,
        STATUS_TRANSACTION_PROPAGATION_FAILED = 0xC0190010,
        STATUS_CRM_PROTOCOL_NOT_FOUND = 0xC0190011,
        STATUS_TRANSACTION_SUPERIOR_EXISTS = 0xC0190012,
        STATUS_TRANSACTION_REQUEST_NOT_VALID = 0xC0190013,
        STATUS_TRANSACTION_NOT_REQUESTED = 0xC0190014,
        STATUS_TRANSACTION_ALREADY_ABORTED = 0xC0190015,
        STATUS_TRANSACTION_ALREADY_COMMITTED = 0xC0190016,
        STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER = 0xC0190017,
        STATUS_CURRENT_TRANSACTION_NOT_VALID = 0xC0190018,
        STATUS_LOG_GROWTH_FAILED = 0xC0190019,
        STATUS_OBJECT_NO_LONGER_EXISTS = 0xC0190021,
        STATUS_STREAM_MINIVERSION_NOT_FOUND = 0xC0190022,
        STATUS_STREAM_MINIVERSION_NOT_VALID = 0xC0190023,
        STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION = 0xC0190024,
        STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT = 0xC0190025,
        STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS = 0xC0190026,
        STATUS_HANDLE_NO_LONGER_VALID = 0xC0190028,
        STATUS_NO_TXF_METADATA = 0x80190029,
        STATUS_LOG_CORRUPTION_DETECTED = 0xC0190030,
        STATUS_CANT_RECOVER_WITH_HANDLE_OPEN = 0x80190031,
        STATUS_RM_DISCONNECTED = 0xC0190032,
        STATUS_ENLISTMENT_NOT_SUPERIOR = 0xC0190033,
        STATUS_RECOVERY_NOT_NEEDED = 0x40190034,
        STATUS_RM_ALREADY_STARTED = 0x40190035,
        STATUS_FILE_IDENTITY_NOT_PERSISTENT = 0xC0190036,
        STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY = 0xC0190037,
        STATUS_CANT_CROSS_RM_BOUNDARY = 0xC0190038,
        STATUS_TXF_DIR_NOT_EMPTY = 0xC0190039,
        STATUS_INDOUBT_TRANSACTIONS_EXIST = 0xC019003A,
        STATUS_TM_VOLATILE = 0xC019003B,
        STATUS_ROLLBACK_TIMER_EXPIRED = 0xC019003C,
        STATUS_TXF_ATTRIBUTE_CORRUPT = 0xC019003D,
        STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION = 0xC019003E,
        STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED = 0xC019003F,
        STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE = 0xC0190040,
        STATUS_TXF_METADATA_ALREADY_PRESENT = 0x80190041,
        STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET = 0x80190042,
        STATUS_TRANSACTION_REQUIRED_PROMOTION = 0xC0190043,
        STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION = 0xC0190044,
        STATUS_TRANSACTIONS_NOT_FROZEN = 0xC0190045,
        STATUS_TRANSACTION_FREEZE_IN_PROGRESS = 0xC0190046,
        STATUS_NOT_SNAPSHOT_VOLUME = 0xC0190047,
        STATUS_NO_SAVEPOINT_WITH_OPEN_FILES = 0xC0190048,
        STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION = 0xC0190049,
        STATUS_TM_IDENTITY_MISMATCH = 0xC019004A,
        STATUS_FLOATED_SECTION = 0xC019004B,
        STATUS_CANNOT_ACCEPT_TRANSACTED_WORK = 0xC019004C,
        STATUS_CANNOT_ABORT_TRANSACTIONS = 0xC019004D,
        STATUS_TRANSACTION_NOT_FOUND = 0xC019004E,
        STATUS_RESOURCEMANAGER_NOT_FOUND = 0xC019004F,
        STATUS_ENLISTMENT_NOT_FOUND = 0xC0190050,
        STATUS_TRANSACTIONMANAGER_NOT_FOUND = 0xC0190051,
        STATUS_TRANSACTIONMANAGER_NOT_ONLINE = 0xC0190052,
        STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION = 0xC0190053,
        STATUS_TRANSACTION_NOT_ROOT = 0xC0190054,
        STATUS_TRANSACTION_OBJECT_EXPIRED = 0xC0190055,
        STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION = 0xC0190056,
        STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED = 0xC0190057,
        STATUS_TRANSACTION_RECORD_TOO_LONG = 0xC0190058,
        STATUS_NO_LINK_TRACKING_IN_TRANSACTION = 0xC0190059,
        STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION = 0xC019005A,
        STATUS_TRANSACTION_INTEGRITY_VIOLATED = 0xC019005B,
        STATUS_TRANSACTIONMANAGER_IDENTITY_MISMATCH = 0xC019005C,
        STATUS_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT = 0xC019005D,
        STATUS_TRANSACTION_MUST_WRITETHROUGH = 0xC019005E,
        STATUS_TRANSACTION_NO_SUPERIOR = 0xC019005F,
        STATUS_EXPIRED_HANDLE = 0xC0190060,
        STATUS_TRANSACTION_NOT_ENLISTED = 0xC0190061,
        STATUS_LOG_SECTOR_INVALID = 0xC01A0001,
        STATUS_LOG_SECTOR_PARITY_INVALID = 0xC01A0002,
        STATUS_LOG_SECTOR_REMAPPED = 0xC01A0003,
        STATUS_LOG_BLOCK_INCOMPLETE = 0xC01A0004,
        STATUS_LOG_INVALID_RANGE = 0xC01A0005,
        STATUS_LOG_BLOCKS_EXHAUSTED = 0xC01A0006,
        STATUS_LOG_READ_CONTEXT_INVALID = 0xC01A0007,
        STATUS_LOG_RESTART_INVALID = 0xC01A0008,
        STATUS_LOG_BLOCK_VERSION = 0xC01A0009,
        STATUS_LOG_BLOCK_INVALID = 0xC01A000A,
        STATUS_LOG_READ_MODE_INVALID = 0xC01A000B,
        STATUS_LOG_NO_RESTART = 0x401A000C,
        STATUS_LOG_METADATA_CORRUPT = 0xC01A000D,
        STATUS_LOG_METADATA_INVALID = 0xC01A000E,
        STATUS_LOG_METADATA_INCONSISTENT = 0xC01A000F,
        STATUS_LOG_RESERVATION_INVALID = 0xC01A0010,
        STATUS_LOG_CANT_DELETE = 0xC01A0011,
        STATUS_LOG_CONTAINER_LIMIT_EXCEEDED = 0xC01A0012,
        STATUS_LOG_START_OF_LOG = 0xC01A0013,
        STATUS_LOG_POLICY_ALREADY_INSTALLED = 0xC01A0014,
        STATUS_LOG_POLICY_NOT_INSTALLED = 0xC01A0015,
        STATUS_LOG_POLICY_INVALID = 0xC01A0016,
        STATUS_LOG_POLICY_CONFLICT = 0xC01A0017,
        STATUS_LOG_PINNED_ARCHIVE_TAIL = 0xC01A0018,
        STATUS_LOG_RECORD_NONEXISTENT = 0xC01A0019,
        STATUS_LOG_RECORDS_RESERVED_INVALID = 0xC01A001A,
        STATUS_LOG_SPACE_RESERVED_INVALID = 0xC01A001B,
        STATUS_LOG_TAIL_INVALID = 0xC01A001C,
        STATUS_LOG_FULL = 0xC01A001D,
        STATUS_LOG_MULTIPLEXED = 0xC01A001E,
        STATUS_LOG_DEDICATED = 0xC01A001F,
        STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS = 0xC01A0020,
        STATUS_LOG_ARCHIVE_IN_PROGRESS = 0xC01A0021,
        STATUS_LOG_EPHEMERAL = 0xC01A0022,
        STATUS_LOG_NOT_ENOUGH_CONTAINERS = 0xC01A0023,
        STATUS_LOG_CLIENT_ALREADY_REGISTERED = 0xC01A0024,
        STATUS_LOG_CLIENT_NOT_REGISTERED = 0xC01A0025,
        STATUS_LOG_FULL_HANDLER_IN_PROGRESS = 0xC01A0026,
        STATUS_LOG_CONTAINER_READ_FAILED = 0xC01A0027,
        STATUS_LOG_CONTAINER_WRITE_FAILED = 0xC01A0028,
        STATUS_LOG_CONTAINER_OPEN_FAILED = 0xC01A0029,
        STATUS_LOG_CONTAINER_STATE_INVALID = 0xC01A002A,
        STATUS_LOG_STATE_INVALID = 0xC01A002B,
        STATUS_LOG_PINNED = 0xC01A002C,
        STATUS_LOG_METADATA_FLUSH_FAILED = 0xC01A002D,
        STATUS_LOG_INCONSISTENT_SECURITY = 0xC01A002E,
        STATUS_LOG_APPENDED_FLUSH_FAILED = 0xC01A002F,
        STATUS_LOG_PINNED_RESERVATION = 0xC01A0030,
        STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD = 0xC01B00EA,
        STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED = 0x801B00EB,
        STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST = 0x401B00EC,
        STATUS_MONITOR_NO_DESCRIPTOR = 0xC01D0001,
        STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT = 0xC01D0002,
        STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM = 0xC01D0003,
        STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK = 0xC01D0004,
        STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED = 0xC01D0005,
        STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK = 0xC01D0006,
        STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK = 0xC01D0007,
        STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA = 0xC01D0008,
        STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK = 0xC01D0009,
        STATUS_MONITOR_INVALID_MANUFACTURE_DATE = 0xC01D000A,
        STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER = 0xC01E0000,
        STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER = 0xC01E0001,
        STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER = 0xC01E0002,
        STATUS_GRAPHICS_ADAPTER_WAS_RESET = 0xC01E0003,
        STATUS_GRAPHICS_INVALID_DRIVER_MODEL = 0xC01E0004,
        STATUS_GRAPHICS_PRESENT_MODE_CHANGED = 0xC01E0005,
        STATUS_GRAPHICS_PRESENT_OCCLUDED = 0xC01E0006,
        STATUS_GRAPHICS_PRESENT_DENIED = 0xC01E0007,
        STATUS_GRAPHICS_CANNOTCOLORCONVERT = 0xC01E0008,
        STATUS_GRAPHICS_DRIVER_MISMATCH = 0xC01E0009,
        STATUS_GRAPHICS_PARTIAL_DATA_POPULATED = 0x401E000A,
        STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED = 0xC01E000B,
        STATUS_GRAPHICS_PRESENT_UNOCCLUDED = 0xC01E000C,
        STATUS_GRAPHICS_WINDOWDC_NOT_AVAILABLE = 0xC01E000D,
        STATUS_GRAPHICS_WINDOWLESS_PRESENT_DISABLED = 0xC01E000E,
        STATUS_GRAPHICS_PRESENT_INVALID_WINDOW = 0xC01E000F,
        STATUS_GRAPHICS_PRESENT_BUFFER_NOT_BOUND = 0xC01E0010,
        STATUS_GRAPHICS_VAIL_STATE_CHANGED = 0xC01E0011,
        STATUS_GRAPHICS_NO_VIDEO_MEMORY = 0xC01E0100,
        STATUS_GRAPHICS_CANT_LOCK_MEMORY = 0xC01E0101,
        STATUS_GRAPHICS_ALLOCATION_BUSY = 0xC01E0102,
        STATUS_GRAPHICS_TOO_MANY_REFERENCES = 0xC01E0103,
        STATUS_GRAPHICS_TRY_AGAIN_LATER = 0xC01E0104,
        STATUS_GRAPHICS_TRY_AGAIN_NOW = 0xC01E0105,
        STATUS_GRAPHICS_ALLOCATION_INVALID = 0xC01E0106,
        STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE = 0xC01E0107,
        STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED = 0xC01E0108,
        STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION = 0xC01E0109,
        STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE = 0xC01E0110,
        STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION = 0xC01E0111,
        STATUS_GRAPHICS_ALLOCATION_CLOSED = 0xC01E0112,
        STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE = 0xC01E0113,
        STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE = 0xC01E0114,
        STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE = 0xC01E0115,
        STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST = 0xC01E0116,
        STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE = 0xC01E0200,
        STATUS_GRAPHICS_SKIP_ALLOCATION_PREPARATION = 0x401E0201,
        STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY = 0xC01E0300,
        STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED = 0xC01E0301,
        STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED = 0xC01E0302,
        STATUS_GRAPHICS_INVALID_VIDPN = 0xC01E0303,
        STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE = 0xC01E0304,
        STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET = 0xC01E0305,
        STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED = 0xC01E0306,
        STATUS_GRAPHICS_MODE_NOT_PINNED = 0x401E0307,
        STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET = 0xC01E0308,
        STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET = 0xC01E0309,
        STATUS_GRAPHICS_INVALID_FREQUENCY = 0xC01E030A,
        STATUS_GRAPHICS_INVALID_ACTIVE_REGION = 0xC01E030B,
        STATUS_GRAPHICS_INVALID_TOTAL_REGION = 0xC01E030C,
        STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE = 0xC01E0310,
        STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE = 0xC01E0311,
        STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET = 0xC01E0312,
        STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY = 0xC01E0313,
        STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET = 0xC01E0314,
        STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET = 0xC01E0315,
        STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET = 0xC01E0316,
        STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET = 0xC01E0317,
        STATUS_GRAPHICS_TARGET_ALREADY_IN_SET = 0xC01E0318,
        STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH = 0xC01E0319,
        STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY = 0xC01E031A,
        STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET = 0xC01E031B,
        STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE = 0xC01E031C,
        STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET = 0xC01E031D,
        STATUS_GRAPHICS_NO_PREFERRED_MODE = 0x401E031E,
        STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET = 0xC01E031F,
        STATUS_GRAPHICS_STALE_MODESET = 0xC01E0320,
        STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET = 0xC01E0321,
        STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE = 0xC01E0322,
        STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN = 0xC01E0323,
        STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE = 0xC01E0324,
        STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION = 0xC01E0325,
        STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES = 0xC01E0326,
        STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY = 0xC01E0327,
        STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE = 0xC01E0328,
        STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET = 0xC01E0329,
        STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET = 0xC01E032A,
        STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR = 0xC01E032B,
        STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET = 0xC01E032C,
        STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET = 0xC01E032D,
        STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE = 0xC01E032E,
        STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE = 0xC01E032F,
        STATUS_GRAPHICS_RESOURCES_NOT_RELATED = 0xC01E0330,
        STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE = 0xC01E0331,
        STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE = 0xC01E0332,
        STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET = 0xC01E0333,
        STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER = 0xC01E0334,
        STATUS_GRAPHICS_NO_VIDPNMGR = 0xC01E0335,
        STATUS_GRAPHICS_NO_ACTIVE_VIDPN = 0xC01E0336,
        STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY = 0xC01E0337,
        STATUS_GRAPHICS_MONITOR_NOT_CONNECTED = 0xC01E0338,
        STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY = 0xC01E0339,
        STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE = 0xC01E033A,
        STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE = 0xC01E033B,
        STATUS_GRAPHICS_INVALID_STRIDE = 0xC01E033C,
        STATUS_GRAPHICS_INVALID_PIXELFORMAT = 0xC01E033D,
        STATUS_GRAPHICS_INVALID_COLORBASIS = 0xC01E033E,
        STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE = 0xC01E033F,
        STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY = 0xC01E0340,
        STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT = 0xC01E0341,
        STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE = 0xC01E0342,
        STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN = 0xC01E0343,
        STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL = 0xC01E0344,
        STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION = 0xC01E0345,
        STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED = 0xC01E0346,
        STATUS_GRAPHICS_INVALID_GAMMA_RAMP = 0xC01E0347,
        STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED = 0xC01E0348,
        STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED = 0xC01E0349,
        STATUS_GRAPHICS_MODE_NOT_IN_MODESET = 0xC01E034A,
        STATUS_GRAPHICS_DATASET_IS_EMPTY = 0x401E034B,
        STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET = 0x401E034C,
        STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON = 0xC01E034D,
        STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE = 0xC01E034E,
        STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE = 0xC01E034F,
        STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS = 0xC01E0350,
        STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED = 0x401E0351,
        STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING = 0xC01E0352,
        STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED = 0xC01E0353,
        STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS = 0xC01E0354,
        STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT = 0xC01E0355,
        STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM = 0xC01E0356,
        STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN = 0xC01E0357,
        STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT = 0xC01E0358,
        STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED = 0xC01E0359,
        STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION = 0xC01E035A,
        STATUS_GRAPHICS_INVALID_CLIENT_TYPE = 0xC01E035B,
        STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET = 0xC01E035C,
        STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED = 0xC01E0400,
        STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED = 0xC01E0401,
        STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS = 0x401E042F,
        STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER = 0xC01E0430,
        STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED = 0xC01E0431,
        STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED = 0xC01E0432,
        STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY = 0xC01E0433,
        STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED = 0xC01E0434,
        STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON = 0xC01E0435,
        STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE = 0xC01E0436,
        STATUS_GRAPHICS_LEADLINK_START_DEFERRED = 0x401E0437,
        STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER = 0xC01E0438,
        STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY = 0x401E0439,
        STATUS_GRAPHICS_START_DEFERRED = 0x401E043A,
        STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED = 0xC01E043B,
        STATUS_GRAPHICS_DEPENDABLE_CHILD_STATUS = 0x401E043C,
        STATUS_GRAPHICS_OPM_NOT_SUPPORTED = 0xC01E0500,
        STATUS_GRAPHICS_COPP_NOT_SUPPORTED = 0xC01E0501,
        STATUS_GRAPHICS_UAB_NOT_SUPPORTED = 0xC01E0502,
        STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS = 0xC01E0503,
        STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST = 0xC01E0505,
        STATUS_GRAPHICS_OPM_INTERNAL_ERROR = 0xC01E050B,
        STATUS_GRAPHICS_OPM_INVALID_HANDLE = 0xC01E050C,
        STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH = 0xC01E050E,
        STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED = 0xC01E050F,
        STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED = 0xC01E0510,
        STATUS_GRAPHICS_PVP_HFS_FAILED = 0xC01E0511,
        STATUS_GRAPHICS_OPM_INVALID_SRM = 0xC01E0512,
        STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP = 0xC01E0513,
        STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP = 0xC01E0514,
        STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA = 0xC01E0515,
        STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET = 0xC01E0516,
        STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH = 0xC01E0517,
        STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE = 0xC01E0518,
        STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS = 0xC01E051A,
        STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS = 0xC01E051C,
        STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST = 0xC01E051D,
        STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR = 0xC01E051E,
        STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS = 0xC01E051F,
        STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED = 0xC01E0520,
        STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST = 0xC01E0521,
        STATUS_GRAPHICS_I2C_NOT_SUPPORTED = 0xC01E0580,
        STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST = 0xC01E0581,
        STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA = 0xC01E0582,
        STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA = 0xC01E0583,
        STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED = 0xC01E0584,
        STATUS_GRAPHICS_DDCCI_INVALID_DATA = 0xC01E0585,
        STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE = 0xC01E0586,
        STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING = 0xC01E0587,
        STATUS_GRAPHICS_MCA_INTERNAL_ERROR = 0xC01E0588,
        STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND = 0xC01E0589,
        STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH = 0xC01E058A,
        STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM = 0xC01E058B,
        STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE = 0xC01E058C,
        STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS = 0xC01E058D,
        STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED = 0xC01E05E0,
        STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME = 0xC01E05E1,
        STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP = 0xC01E05E2,
        STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED = 0xC01E05E3,
        STATUS_GRAPHICS_INVALID_POINTER = 0xC01E05E4,
        STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE = 0xC01E05E5,
        STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL = 0xC01E05E6,
        STATUS_GRAPHICS_INTERNAL_ERROR = 0xC01E05E7,
        STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS = 0xC01E05E8,
        STATUS_FVE_LOCKED_VOLUME = 0xC0210000,
        STATUS_FVE_NOT_ENCRYPTED = 0xC0210001,
        STATUS_FVE_BAD_INFORMATION = 0xC0210002,
        STATUS_FVE_TOO_SMALL = 0xC0210003,
        STATUS_FVE_FAILED_WRONG_FS = 0xC0210004,
        STATUS_FVE_BAD_PARTITION_SIZE = 0xC0210005,
        STATUS_FVE_FS_NOT_EXTENDED = 0xC0210006,
        STATUS_FVE_FS_MOUNTED = 0xC0210007,
        STATUS_FVE_NO_LICENSE = 0xC0210008,
        STATUS_FVE_ACTION_NOT_ALLOWED = 0xC0210009,
        STATUS_FVE_BAD_DATA = 0xC021000A,
        STATUS_FVE_VOLUME_NOT_BOUND = 0xC021000B,
        STATUS_FVE_NOT_DATA_VOLUME = 0xC021000C,
        STATUS_FVE_CONV_READ_ERROR = 0xC021000D,
        STATUS_FVE_CONV_WRITE_ERROR = 0xC021000E,
        STATUS_FVE_OVERLAPPED_UPDATE = 0xC021000F,
        STATUS_FVE_FAILED_SECTOR_SIZE = 0xC0210010,
        STATUS_FVE_FAILED_AUTHENTICATION = 0xC0210011,
        STATUS_FVE_NOT_OS_VOLUME = 0xC0210012,
        STATUS_FVE_KEYFILE_NOT_FOUND = 0xC0210013,
        STATUS_FVE_KEYFILE_INVALID = 0xC0210014,
        STATUS_FVE_KEYFILE_NO_VMK = 0xC0210015,
        STATUS_FVE_TPM_DISABLED = 0xC0210016,
        STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO = 0xC0210017,
        STATUS_FVE_TPM_INVALID_PCR = 0xC0210018,
        STATUS_FVE_TPM_NO_VMK = 0xC0210019,
        STATUS_FVE_PIN_INVALID = 0xC021001A,
        STATUS_FVE_AUTH_INVALID_APPLICATION = 0xC021001B,
        STATUS_FVE_AUTH_INVALID_CONFIG = 0xC021001C,
        STATUS_FVE_DEBUGGER_ENABLED = 0xC021001D,
        STATUS_FVE_DRY_RUN_FAILED = 0xC021001E,
        STATUS_FVE_BAD_METADATA_POINTER = 0xC021001F,
        STATUS_FVE_OLD_METADATA_COPY = 0xC0210020,
        STATUS_FVE_REBOOT_REQUIRED = 0xC0210021,
        STATUS_FVE_RAW_ACCESS = 0xC0210022,
        STATUS_FVE_RAW_BLOCKED = 0xC0210023,
        STATUS_FVE_NO_AUTOUNLOCK_MASTER_KEY = 0xC0210024,
        STATUS_FVE_MOR_FAILED = 0xC0210025,
        STATUS_FVE_NO_FEATURE_LICENSE = 0xC0210026,
        STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED = 0xC0210027,
        STATUS_FVE_CONV_RECOVERY_FAILED = 0xC0210028,
        STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG = 0xC0210029,
        STATUS_FVE_INVALID_DATUM_TYPE = 0xC021002A,
        STATUS_FVE_VOLUME_TOO_SMALL = 0xC0210030,
        STATUS_FVE_ENH_PIN_INVALID = 0xC0210031,
        STATUS_FVE_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE = 0xC0210032,
        STATUS_FVE_WIPE_NOT_ALLOWED_ON_TP_STORAGE = 0xC0210033,
        STATUS_FVE_NOT_ALLOWED_ON_CSV_STACK = 0xC0210034,
        STATUS_FVE_NOT_ALLOWED_ON_CLUSTER = 0xC0210035,
        STATUS_FVE_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING = 0xC0210036,
        STATUS_FVE_WIPE_CANCEL_NOT_APPLICABLE = 0xC0210037,
        STATUS_FVE_EDRIVE_DRY_RUN_FAILED = 0xC0210038,
        STATUS_FVE_SECUREBOOT_DISABLED = 0xC0210039,
        STATUS_FVE_SECUREBOOT_CONFIG_CHANGE = 0xC021003A,
        STATUS_FVE_DEVICE_LOCKEDOUT = 0xC021003B,
        STATUS_FVE_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT = 0xC021003C,
        STATUS_FVE_NOT_DE_VOLUME = 0xC021003D,
        STATUS_FVE_PROTECTION_DISABLED = 0xC021003E,
        STATUS_FVE_PROTECTION_CANNOT_BE_DISABLED = 0xC021003F,
        STATUS_FVE_OSV_KSR_NOT_ALLOWED = 0xC0210040,
        STATUS_FWP_CALLOUT_NOT_FOUND = 0xC0220001,
        STATUS_FWP_CONDITION_NOT_FOUND = 0xC0220002,
        STATUS_FWP_FILTER_NOT_FOUND = 0xC0220003,
        STATUS_FWP_LAYER_NOT_FOUND = 0xC0220004,
        STATUS_FWP_PROVIDER_NOT_FOUND = 0xC0220005,
        STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND = 0xC0220006,
        STATUS_FWP_SUBLAYER_NOT_FOUND = 0xC0220007,
        STATUS_FWP_NOT_FOUND = 0xC0220008,
        STATUS_FWP_ALREADY_EXISTS = 0xC0220009,
        STATUS_FWP_IN_USE = 0xC022000A,
        STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS = 0xC022000B,
        STATUS_FWP_WRONG_SESSION = 0xC022000C,
        STATUS_FWP_NO_TXN_IN_PROGRESS = 0xC022000D,
        STATUS_FWP_TXN_IN_PROGRESS = 0xC022000E,
        STATUS_FWP_TXN_ABORTED = 0xC022000F,
        STATUS_FWP_SESSION_ABORTED = 0xC0220010,
        STATUS_FWP_INCOMPATIBLE_TXN = 0xC0220011,
        STATUS_FWP_TIMEOUT = 0xC0220012,
        STATUS_FWP_NET_EVENTS_DISABLED = 0xC0220013,
        STATUS_FWP_INCOMPATIBLE_LAYER = 0xC0220014,
        STATUS_FWP_KM_CLIENTS_ONLY = 0xC0220015,
        STATUS_FWP_LIFETIME_MISMATCH = 0xC0220016,
        STATUS_FWP_BUILTIN_OBJECT = 0xC0220017,
        STATUS_FWP_TOO_MANY_CALLOUTS = 0xC0220018,
        STATUS_FWP_NOTIFICATION_DROPPED = 0xC0220019,
        STATUS_FWP_TRAFFIC_MISMATCH = 0xC022001A,
        STATUS_FWP_INCOMPATIBLE_SA_STATE = 0xC022001B,
        STATUS_FWP_NULL_POINTER = 0xC022001C,
        STATUS_FWP_INVALID_ENUMERATOR = 0xC022001D,
        STATUS_FWP_INVALID_FLAGS = 0xC022001E,
        STATUS_FWP_INVALID_NET_MASK = 0xC022001F,
        STATUS_FWP_INVALID_RANGE = 0xC0220020,
        STATUS_FWP_INVALID_INTERVAL = 0xC0220021,
        STATUS_FWP_ZERO_LENGTH_ARRAY = 0xC0220022,
        STATUS_FWP_NULL_DISPLAY_NAME = 0xC0220023,
        STATUS_FWP_INVALID_ACTION_TYPE = 0xC0220024,
        STATUS_FWP_INVALID_WEIGHT = 0xC0220025,
        STATUS_FWP_MATCH_TYPE_MISMATCH = 0xC0220026,
        STATUS_FWP_TYPE_MISMATCH = 0xC0220027,
        STATUS_FWP_OUT_OF_BOUNDS = 0xC0220028,
        STATUS_FWP_RESERVED = 0xC0220029,
        STATUS_FWP_DUPLICATE_CONDITION = 0xC022002A,
        STATUS_FWP_DUPLICATE_KEYMOD = 0xC022002B,
        STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER = 0xC022002C,
        STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER = 0xC022002D,
        STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER = 0xC022002E,
        STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT = 0xC022002F,
        STATUS_FWP_INCOMPATIBLE_AUTH_METHOD = 0xC0220030,
        STATUS_FWP_INCOMPATIBLE_DH_GROUP = 0xC0220031,
        STATUS_FWP_EM_NOT_SUPPORTED = 0xC0220032,
        STATUS_FWP_NEVER_MATCH = 0xC0220033,
        STATUS_FWP_PROVIDER_CONTEXT_MISMATCH = 0xC0220034,
        STATUS_FWP_INVALID_PARAMETER = 0xC0220035,
        STATUS_FWP_TOO_MANY_SUBLAYERS = 0xC0220036,
        STATUS_FWP_CALLOUT_NOTIFICATION_FAILED = 0xC0220037,
        STATUS_FWP_INVALID_AUTH_TRANSFORM = 0xC0220038,
        STATUS_FWP_INVALID_CIPHER_TRANSFORM = 0xC0220039,
        STATUS_FWP_INCOMPATIBLE_CIPHER_TRANSFORM = 0xC022003A,
        STATUS_FWP_INVALID_TRANSFORM_COMBINATION = 0xC022003B,
        STATUS_FWP_DUPLICATE_AUTH_METHOD = 0xC022003C,
        STATUS_FWP_INVALID_TUNNEL_ENDPOINT = 0xC022003D,
        STATUS_FWP_L2_DRIVER_NOT_READY = 0xC022003E,
        STATUS_FWP_KEY_DICTATOR_ALREADY_REGISTERED = 0xC022003F,
        STATUS_FWP_KEY_DICTATION_INVALID_KEYING_MATERIAL = 0xC0220040,
        STATUS_FWP_CONNECTIONS_DISABLED = 0xC0220041,
        STATUS_FWP_INVALID_DNS_NAME = 0xC0220042,
        STATUS_FWP_STILL_ON = 0xC0220043,
        STATUS_FWP_IKEEXT_NOT_RUNNING = 0xC0220044,
        STATUS_FWP_TCPIP_NOT_READY = 0xC0220100,
        STATUS_FWP_INJECT_HANDLE_CLOSING = 0xC0220101,
        STATUS_FWP_INJECT_HANDLE_STALE = 0xC0220102,
        STATUS_FWP_CANNOT_PEND = 0xC0220103,
        STATUS_FWP_DROP_NOICMP = 0xC0220104,
        STATUS_NDIS_CLOSING = 0xC0230002,
        STATUS_NDIS_BAD_VERSION = 0xC0230004,
        STATUS_NDIS_BAD_CHARACTERISTICS = 0xC0230005,
        STATUS_NDIS_ADAPTER_NOT_FOUND = 0xC0230006,
        STATUS_NDIS_OPEN_FAILED = 0xC0230007,
        STATUS_NDIS_DEVICE_FAILED = 0xC0230008,
        STATUS_NDIS_MULTICAST_FULL = 0xC0230009,
        STATUS_NDIS_MULTICAST_EXISTS = 0xC023000A,
        STATUS_NDIS_MULTICAST_NOT_FOUND = 0xC023000B,
        STATUS_NDIS_REQUEST_ABORTED = 0xC023000C,
        STATUS_NDIS_RESET_IN_PROGRESS = 0xC023000D,
        STATUS_NDIS_NOT_SUPPORTED = 0xC02300BB,
        STATUS_NDIS_INVALID_PACKET = 0xC023000F,
        STATUS_NDIS_ADAPTER_NOT_READY = 0xC0230011,
        STATUS_NDIS_INVALID_LENGTH = 0xC0230014,
        STATUS_NDIS_INVALID_DATA = 0xC0230015,
        STATUS_NDIS_BUFFER_TOO_SHORT = 0xC0230016,
        STATUS_NDIS_INVALID_OID = 0xC0230017,
        STATUS_NDIS_ADAPTER_REMOVED = 0xC0230018,
        STATUS_NDIS_UNSUPPORTED_MEDIA = 0xC0230019,
        STATUS_NDIS_GROUP_ADDRESS_IN_USE = 0xC023001A,
        STATUS_NDIS_FILE_NOT_FOUND = 0xC023001B,
        STATUS_NDIS_ERROR_READING_FILE = 0xC023001C,
        STATUS_NDIS_ALREADY_MAPPED = 0xC023001D,
        STATUS_NDIS_RESOURCE_CONFLICT = 0xC023001E,
        STATUS_NDIS_MEDIA_DISCONNECTED = 0xC023001F,
        STATUS_NDIS_INVALID_ADDRESS = 0xC0230022,
        STATUS_NDIS_INVALID_DEVICE_REQUEST = 0xC0230010,
        STATUS_NDIS_PAUSED = 0xC023002A,
        STATUS_NDIS_INTERFACE_NOT_FOUND = 0xC023002B,
        STATUS_NDIS_UNSUPPORTED_REVISION = 0xC023002C,
        STATUS_NDIS_INVALID_PORT = 0xC023002D,
        STATUS_NDIS_INVALID_PORT_STATE = 0xC023002E,
        STATUS_NDIS_LOW_POWER_STATE = 0xC023002F,
        STATUS_NDIS_REINIT_REQUIRED = 0xC0230030,
        STATUS_NDIS_NO_QUEUES = 0xC0230031,
        STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED = 0xC0232000,
        STATUS_NDIS_DOT11_MEDIA_IN_USE = 0xC0232001,
        STATUS_NDIS_DOT11_POWER_STATE_INVALID = 0xC0232002,
        STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL = 0xC0232003,
        STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL = 0xC0232004,
        STATUS_NDIS_DOT11_AP_CHANNEL_CURRENTLY_NOT_AVAILABLE = 0xC0232005,
        STATUS_NDIS_DOT11_AP_BAND_CURRENTLY_NOT_AVAILABLE = 0xC0232006,
        STATUS_NDIS_DOT11_AP_CHANNEL_NOT_ALLOWED = 0xC0232007,
        STATUS_NDIS_DOT11_AP_BAND_NOT_ALLOWED = 0xC0232008,
        STATUS_NDIS_INDICATION_REQUIRED = 0x40230001,
        STATUS_NDIS_OFFLOAD_POLICY = 0xC023100F,
        STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED = 0xC0231012,
        STATUS_NDIS_OFFLOAD_PATH_REJECTED = 0xC0231013,
        STATUS_TPM_ERROR_MASK = 0xC0290000,
        STATUS_TPM_AUTHFAIL = 0xC0290001,
        STATUS_TPM_BADINDEX = 0xC0290002,
        STATUS_TPM_BAD_PARAMETER = 0xC0290003,
        STATUS_TPM_AUDITFAILURE = 0xC0290004,
        STATUS_TPM_CLEAR_DISABLED = 0xC0290005,
        STATUS_TPM_DEACTIVATED = 0xC0290006,
        STATUS_TPM_DISABLED = 0xC0290007,
        STATUS_TPM_DISABLED_CMD = 0xC0290008,
        STATUS_TPM_FAIL = 0xC0290009,
        STATUS_TPM_BAD_ORDINAL = 0xC029000A,
        STATUS_TPM_INSTALL_DISABLED = 0xC029000B,
        STATUS_TPM_INVALID_KEYHANDLE = 0xC029000C,
        STATUS_TPM_KEYNOTFOUND = 0xC029000D,
        STATUS_TPM_INAPPROPRIATE_ENC = 0xC029000E,
        STATUS_TPM_MIGRATEFAIL = 0xC029000F,
        STATUS_TPM_INVALID_PCR_INFO = 0xC0290010,
        STATUS_TPM_NOSPACE = 0xC0290011,
        STATUS_TPM_NOSRK = 0xC0290012,
        STATUS_TPM_NOTSEALED_BLOB = 0xC0290013,
        STATUS_TPM_OWNER_SET = 0xC0290014,
        STATUS_TPM_RESOURCES = 0xC0290015,
        STATUS_TPM_SHORTRANDOM = 0xC0290016,
        STATUS_TPM_SIZE = 0xC0290017,
        STATUS_TPM_WRONGPCRVAL = 0xC0290018,
        STATUS_TPM_BAD_PARAM_SIZE = 0xC0290019,
        STATUS_TPM_SHA_THREAD = 0xC029001A,
        STATUS_TPM_SHA_ERROR = 0xC029001B,
        STATUS_TPM_FAILEDSELFTEST = 0xC029001C,
        STATUS_TPM_AUTH2FAIL = 0xC029001D,
        STATUS_TPM_BADTAG = 0xC029001E,
        STATUS_TPM_IOERROR = 0xC029001F,
        STATUS_TPM_ENCRYPT_ERROR = 0xC0290020,
        STATUS_TPM_DECRYPT_ERROR = 0xC0290021,
        STATUS_TPM_INVALID_AUTHHANDLE = 0xC0290022,
        STATUS_TPM_NO_ENDORSEMENT = 0xC0290023,
        STATUS_TPM_INVALID_KEYUSAGE = 0xC0290024,
        STATUS_TPM_WRONG_ENTITYTYPE = 0xC0290025,
        STATUS_TPM_INVALID_POSTINIT = 0xC0290026,
        STATUS_TPM_INAPPROPRIATE_SIG = 0xC0290027,
        STATUS_TPM_BAD_KEY_PROPERTY = 0xC0290028,
        STATUS_TPM_BAD_MIGRATION = 0xC0290029,
        STATUS_TPM_BAD_SCHEME = 0xC029002A,
        STATUS_TPM_BAD_DATASIZE = 0xC029002B,
        STATUS_TPM_BAD_MODE = 0xC029002C,
        STATUS_TPM_BAD_PRESENCE = 0xC029002D,
        STATUS_TPM_BAD_VERSION = 0xC029002E,
        STATUS_TPM_NO_WRAP_TRANSPORT = 0xC029002F,
        STATUS_TPM_AUDITFAIL_UNSUCCESSFUL = 0xC0290030,
        STATUS_TPM_AUDITFAIL_SUCCESSFUL = 0xC0290031,
        STATUS_TPM_NOTRESETABLE = 0xC0290032,
        STATUS_TPM_NOTLOCAL = 0xC0290033,
        STATUS_TPM_BAD_TYPE = 0xC0290034,
        STATUS_TPM_INVALID_RESOURCE = 0xC0290035,
        STATUS_TPM_NOTFIPS = 0xC0290036,
        STATUS_TPM_INVALID_FAMILY = 0xC0290037,
        STATUS_TPM_NO_NV_PERMISSION = 0xC0290038,
        STATUS_TPM_REQUIRES_SIGN = 0xC0290039,
        STATUS_TPM_KEY_NOTSUPPORTED = 0xC029003A,
        STATUS_TPM_AUTH_CONFLICT = 0xC029003B,
        STATUS_TPM_AREA_LOCKED = 0xC029003C,
        STATUS_TPM_BAD_LOCALITY = 0xC029003D,
        STATUS_TPM_READ_ONLY = 0xC029003E,
        STATUS_TPM_PER_NOWRITE = 0xC029003F,
        STATUS_TPM_FAMILYCOUNT = 0xC0290040,
        STATUS_TPM_WRITE_LOCKED = 0xC0290041,
        STATUS_TPM_BAD_ATTRIBUTES = 0xC0290042,
        STATUS_TPM_INVALID_STRUCTURE = 0xC0290043,
        STATUS_TPM_KEY_OWNER_CONTROL = 0xC0290044,
        STATUS_TPM_BAD_COUNTER = 0xC0290045,
        STATUS_TPM_NOT_FULLWRITE = 0xC0290046,
        STATUS_TPM_CONTEXT_GAP = 0xC0290047,
        STATUS_TPM_MAXNVWRITES = 0xC0290048,
        STATUS_TPM_NOOPERATOR = 0xC0290049,
        STATUS_TPM_RESOURCEMISSING = 0xC029004A,
        STATUS_TPM_DELEGATE_LOCK = 0xC029004B,
        STATUS_TPM_DELEGATE_FAMILY = 0xC029004C,
        STATUS_TPM_DELEGATE_ADMIN = 0xC029004D,
        STATUS_TPM_TRANSPORT_NOTEXCLUSIVE = 0xC029004E,
        STATUS_TPM_OWNER_CONTROL = 0xC029004F,
        STATUS_TPM_DAA_RESOURCES = 0xC0290050,
        STATUS_TPM_DAA_INPUT_DATA0 = 0xC0290051,
        STATUS_TPM_DAA_INPUT_DATA1 = 0xC0290052,
        STATUS_TPM_DAA_ISSUER_SETTINGS = 0xC0290053,
        STATUS_TPM_DAA_TPM_SETTINGS = 0xC0290054,
        STATUS_TPM_DAA_STAGE = 0xC0290055,
        STATUS_TPM_DAA_ISSUER_VALIDITY = 0xC0290056,
        STATUS_TPM_DAA_WRONG_W = 0xC0290057,
        STATUS_TPM_BAD_HANDLE = 0xC0290058,
        STATUS_TPM_BAD_DELEGATE = 0xC0290059,
        STATUS_TPM_BADCONTEXT = 0xC029005A,
        STATUS_TPM_TOOMANYCONTEXTS = 0xC029005B,
        STATUS_TPM_MA_TICKET_SIGNATURE = 0xC029005C,
        STATUS_TPM_MA_DESTINATION = 0xC029005D,
        STATUS_TPM_MA_SOURCE = 0xC029005E,
        STATUS_TPM_MA_AUTHORITY = 0xC029005F,
        STATUS_TPM_PERMANENTEK = 0xC0290061,
        STATUS_TPM_BAD_SIGNATURE = 0xC0290062,
        STATUS_TPM_NOCONTEXTSPACE = 0xC0290063,
        STATUS_TPM_20_E_ASYMMETRIC = 0xC0290081,
        STATUS_TPM_20_E_ATTRIBUTES = 0xC0290082,
        STATUS_TPM_20_E_HASH = 0xC0290083,
        STATUS_TPM_20_E_VALUE = 0xC0290084,
        STATUS_TPM_20_E_HIERARCHY = 0xC0290085,
        STATUS_TPM_20_E_KEY_SIZE = 0xC0290087,
        STATUS_TPM_20_E_MGF = 0xC0290088,
        STATUS_TPM_20_E_MODE = 0xC0290089,
        STATUS_TPM_20_E_TYPE = 0xC029008A,
        STATUS_TPM_20_E_HANDLE = 0xC029008B,
        STATUS_TPM_20_E_KDF = 0xC029008C,
        STATUS_TPM_20_E_RANGE = 0xC029008D,
        STATUS_TPM_20_E_AUTH_FAIL = 0xC029008E,
        STATUS_TPM_20_E_NONCE = 0xC029008F,
        STATUS_TPM_20_E_PP = 0xC0290090,
        STATUS_TPM_20_E_SCHEME = 0xC0290092,
        STATUS_TPM_20_E_SIZE = 0xC0290095,
        STATUS_TPM_20_E_SYMMETRIC = 0xC0290096,
        STATUS_TPM_20_E_TAG = 0xC0290097,
        STATUS_TPM_20_E_SELECTOR = 0xC0290098,
        STATUS_TPM_20_E_INSUFFICIENT = 0xC029009A,
        STATUS_TPM_20_E_SIGNATURE = 0xC029009B,
        STATUS_TPM_20_E_KEY = 0xC029009C,
        STATUS_TPM_20_E_POLICY_FAIL = 0xC029009D,
        STATUS_TPM_20_E_INTEGRITY = 0xC029009F,
        STATUS_TPM_20_E_TICKET = 0xC02900A0,
        STATUS_TPM_20_E_RESERVED_BITS = 0xC02900A1,
        STATUS_TPM_20_E_BAD_AUTH = 0xC02900A2,
        STATUS_TPM_20_E_EXPIRED = 0xC02900A3,
        STATUS_TPM_20_E_POLICY_CC = 0xC02900A4,
        STATUS_TPM_20_E_BINDING = 0xC02900A5,
        STATUS_TPM_20_E_CURVE = 0xC02900A6,
        STATUS_TPM_20_E_ECC_POINT = 0xC02900A7,
        STATUS_TPM_20_E_INITIALIZE = 0xC0290100,
        STATUS_TPM_20_E_FAILURE = 0xC0290101,
        STATUS_TPM_20_E_SEQUENCE = 0xC0290103,
        STATUS_TPM_20_E_PRIVATE = 0xC029010B,
        STATUS_TPM_20_E_HMAC = 0xC0290119,
        STATUS_TPM_20_E_DISABLED = 0xC0290120,
        STATUS_TPM_20_E_EXCLUSIVE = 0xC0290121,
        STATUS_TPM_20_E_ECC_CURVE = 0xC0290123,
        STATUS_TPM_20_E_AUTH_TYPE = 0xC0290124,
        STATUS_TPM_20_E_AUTH_MISSING = 0xC0290125,
        STATUS_TPM_20_E_POLICY = 0xC0290126,
        STATUS_TPM_20_E_PCR = 0xC0290127,
        STATUS_TPM_20_E_PCR_CHANGED = 0xC0290128,
        STATUS_TPM_20_E_UPGRADE = 0xC029012D,
        STATUS_TPM_20_E_TOO_MANY_CONTEXTS = 0xC029012E,
        STATUS_TPM_20_E_AUTH_UNAVAILABLE = 0xC029012F,
        STATUS_TPM_20_E_REBOOT = 0xC0290130,
        STATUS_TPM_20_E_UNBALANCED = 0xC0290131,
        STATUS_TPM_20_E_COMMAND_SIZE = 0xC0290142,
        STATUS_TPM_20_E_COMMAND_CODE = 0xC0290143,
        STATUS_TPM_20_E_AUTHSIZE = 0xC0290144,
        STATUS_TPM_20_E_AUTH_CONTEXT = 0xC0290145,
        STATUS_TPM_20_E_NV_RANGE = 0xC0290146,
        STATUS_TPM_20_E_NV_SIZE = 0xC0290147,
        STATUS_TPM_20_E_NV_LOCKED = 0xC0290148,
        STATUS_TPM_20_E_NV_AUTHORIZATION = 0xC0290149,
        STATUS_TPM_20_E_NV_UNINITIALIZED = 0xC029014A,
        STATUS_TPM_20_E_NV_SPACE = 0xC029014B,
        STATUS_TPM_20_E_NV_DEFINED = 0xC029014C,
        STATUS_TPM_20_E_BAD_CONTEXT = 0xC0290150,
        STATUS_TPM_20_E_CPHASH = 0xC0290151,
        STATUS_TPM_20_E_PARENT = 0xC0290152,
        STATUS_TPM_20_E_NEEDS_TEST = 0xC0290153,
        STATUS_TPM_20_E_NO_RESULT = 0xC0290154,
        STATUS_TPM_20_E_SENSITIVE = 0xC0290155,
        STATUS_TPM_COMMAND_BLOCKED = 0xC0290400,
        STATUS_TPM_INVALID_HANDLE = 0xC0290401,
        STATUS_TPM_DUPLICATE_VHANDLE = 0xC0290402,
        STATUS_TPM_EMBEDDED_COMMAND_BLOCKED = 0xC0290403,
        STATUS_TPM_EMBEDDED_COMMAND_UNSUPPORTED = 0xC0290404,
        STATUS_TPM_RETRY = 0xC0290800,
        STATUS_TPM_NEEDS_SELFTEST = 0xC0290801,
        STATUS_TPM_DOING_SELFTEST = 0xC0290802,
        STATUS_TPM_DEFEND_LOCK_RUNNING = 0xC0290803,
        STATUS_TPM_COMMAND_CANCELED = 0xC0291001,
        STATUS_TPM_TOO_MANY_CONTEXTS = 0xC0291002,
        STATUS_TPM_NOT_FOUND = 0xC0291003,
        STATUS_TPM_ACCESS_DENIED = 0xC0291004,
        STATUS_TPM_INSUFFICIENT_BUFFER = 0xC0291005,
        STATUS_TPM_PPI_FUNCTION_UNSUPPORTED = 0xC0291006,
        STATUS_PCP_ERROR_MASK = 0xC0292000,
        STATUS_PCP_DEVICE_NOT_READY = 0xC0292001,
        STATUS_PCP_INVALID_HANDLE = 0xC0292002,
        STATUS_PCP_INVALID_PARAMETER = 0xC0292003,
        STATUS_PCP_FLAG_NOT_SUPPORTED = 0xC0292004,
        STATUS_PCP_NOT_SUPPORTED = 0xC0292005,
        STATUS_PCP_BUFFER_TOO_SMALL = 0xC0292006,
        STATUS_PCP_INTERNAL_ERROR = 0xC0292007,
        STATUS_PCP_AUTHENTICATION_FAILED = 0xC0292008,
        STATUS_PCP_AUTHENTICATION_IGNORED = 0xC0292009,
        STATUS_PCP_POLICY_NOT_FOUND = 0xC029200A,
        STATUS_PCP_PROFILE_NOT_FOUND = 0xC029200B,
        STATUS_PCP_VALIDATION_FAILED = 0xC029200C,
        STATUS_PCP_DEVICE_NOT_FOUND = 0xC029200D,
        STATUS_PCP_WRONG_PARENT = 0xC029200E,
        STATUS_PCP_KEY_NOT_LOADED = 0xC029200F,
        STATUS_PCP_NO_KEY_CERTIFICATION = 0xC0292010,
        STATUS_PCP_KEY_NOT_FINALIZED = 0xC0292011,
        STATUS_PCP_ATTESTATION_CHALLENGE_NOT_SET = 0xC0292012,
        STATUS_PCP_NOT_PCR_BOUND = 0xC0292013,
        STATUS_PCP_KEY_ALREADY_FINALIZED = 0xC0292014,
        STATUS_PCP_KEY_USAGE_POLICY_NOT_SUPPORTED = 0xC0292015,
        STATUS_PCP_KEY_USAGE_POLICY_INVALID = 0xC0292016,
        STATUS_PCP_SOFT_KEY_ERROR = 0xC0292017,
        STATUS_PCP_KEY_NOT_AUTHENTICATED = 0xC0292018,
        STATUS_PCP_KEY_NOT_AIK = 0xC0292019,
        STATUS_PCP_KEY_NOT_SIGNING_KEY = 0xC029201A,
        STATUS_PCP_LOCKED_OUT = 0xC029201B,
        STATUS_PCP_CLAIM_TYPE_NOT_SUPPORTED = 0xC029201C,
        STATUS_PCP_TPM_VERSION_NOT_SUPPORTED = 0xC029201D,
        STATUS_PCP_BUFFER_LENGTH_MISMATCH = 0xC029201E,
        STATUS_PCP_IFX_RSA_KEY_CREATION_BLOCKED = 0xC029201F,
        STATUS_PCP_TICKET_MISSING = 0xC0292020,
        STATUS_PCP_RAW_POLICY_NOT_SUPPORTED = 0xC0292021,
        STATUS_PCP_KEY_HANDLE_INVALIDATED = 0xC0292022,
        STATUS_PCP_UNSUPPORTED_PSS_SALT = 0x40292023,
        STATUS_RTPM_CONTEXT_CONTINUE = 0x00293000,
        STATUS_RTPM_CONTEXT_COMPLETE = 0x00293001,
        STATUS_RTPM_NO_RESULT = 0xC0293002,
        STATUS_RTPM_PCR_READ_INCOMPLETE = 0xC0293003,
        STATUS_RTPM_INVALID_CONTEXT = 0xC0293004,
        STATUS_RTPM_UNSUPPORTED_CMD = 0xC0293005,
        STATUS_TPM_ZERO_EXHAUST_ENABLED = 0xC0294000,
        STATUS_HV_INVALID_HYPERCALL_CODE = 0xC0350002,
        STATUS_HV_INVALID_HYPERCALL_INPUT = 0xC0350003,
        STATUS_HV_INVALID_ALIGNMENT = 0xC0350004,
        STATUS_HV_INVALID_PARAMETER = 0xC0350005,
        STATUS_HV_ACCESS_DENIED = 0xC0350006,
        STATUS_HV_INVALID_PARTITION_STATE = 0xC0350007,
        STATUS_HV_OPERATION_DENIED = 0xC0350008,
        STATUS_HV_UNKNOWN_PROPERTY = 0xC0350009,
        STATUS_HV_PROPERTY_VALUE_OUT_OF_RANGE = 0xC035000A,
        STATUS_HV_INSUFFICIENT_MEMORY = 0xC035000B,
        STATUS_HV_PARTITION_TOO_DEEP = 0xC035000C,
        STATUS_HV_INVALID_PARTITION_ID = 0xC035000D,
        STATUS_HV_INVALID_VP_INDEX = 0xC035000E,
        STATUS_HV_INVALID_PORT_ID = 0xC0350011,
        STATUS_HV_INVALID_CONNECTION_ID = 0xC0350012,
        STATUS_HV_INSUFFICIENT_BUFFERS = 0xC0350013,
        STATUS_HV_NOT_ACKNOWLEDGED = 0xC0350014,
        STATUS_HV_INVALID_VP_STATE = 0xC0350015,
        STATUS_HV_ACKNOWLEDGED = 0xC0350016,
        STATUS_HV_INVALID_SAVE_RESTORE_STATE = 0xC0350017,
        STATUS_HV_INVALID_SYNIC_STATE = 0xC0350018,
        STATUS_HV_OBJECT_IN_USE = 0xC0350019,
        STATUS_HV_INVALID_PROXIMITY_DOMAIN_INFO = 0xC035001A,
        STATUS_HV_NO_DATA = 0xC035001B,
        STATUS_HV_INACTIVE = 0xC035001C,
        STATUS_HV_NO_RESOURCES = 0xC035001D,
        STATUS_HV_FEATURE_UNAVAILABLE = 0xC035001E,
        STATUS_HV_INSUFFICIENT_BUFFER = 0xC0350033,
        STATUS_HV_INSUFFICIENT_DEVICE_DOMAINS = 0xC0350038,
        STATUS_HV_CPUID_FEATURE_VALIDATION_ERROR = 0xC035003C,
        STATUS_HV_CPUID_XSAVE_FEATURE_VALIDATION_ERROR = 0xC035003D,
        STATUS_HV_PROCESSOR_STARTUP_TIMEOUT = 0xC035003E,
        STATUS_HV_SMX_ENABLED = 0xC035003F,
        STATUS_HV_INVALID_LP_INDEX = 0xC0350041,
        STATUS_HV_INVALID_REGISTER_VALUE = 0xC0350050,
        STATUS_HV_INVALID_VTL_STATE = 0xC0350051,
        STATUS_HV_NX_NOT_DETECTED = 0xC0350055,
        STATUS_HV_INVALID_DEVICE_ID = 0xC0350057,
        STATUS_HV_INVALID_DEVICE_STATE = 0xC0350058,
        STATUS_HV_PENDING_PAGE_REQUESTS = 0x00350059,
        STATUS_HV_PAGE_REQUEST_INVALID = 0xC0350060,
        STATUS_HV_INVALID_CPU_GROUP_ID = 0xC035006F,
        STATUS_HV_INVALID_CPU_GROUP_STATE = 0xC0350070,
        STATUS_HV_OPERATION_FAILED = 0xC0350071,
        STATUS_HV_NOT_ALLOWED_WITH_NESTED_VIRT_ACTIVE = 0xC0350072,
        STATUS_HV_INSUFFICIENT_ROOT_MEMORY = 0xC0350073,
        STATUS_HV_NOT_PRESENT = 0xC0351000,
        STATUS_VID_DUPLICATE_HANDLER = 0xC0370001,
        STATUS_VID_TOO_MANY_HANDLERS = 0xC0370002,
        STATUS_VID_QUEUE_FULL = 0xC0370003,
        STATUS_VID_HANDLER_NOT_PRESENT = 0xC0370004,
        STATUS_VID_INVALID_OBJECT_NAME = 0xC0370005,
        STATUS_VID_PARTITION_NAME_TOO_LONG = 0xC0370006,
        STATUS_VID_MESSAGE_QUEUE_NAME_TOO_LONG = 0xC0370007,
        STATUS_VID_PARTITION_ALREADY_EXISTS = 0xC0370008,
        STATUS_VID_PARTITION_DOES_NOT_EXIST = 0xC0370009,
        STATUS_VID_PARTITION_NAME_NOT_FOUND = 0xC037000A,
        STATUS_VID_MESSAGE_QUEUE_ALREADY_EXISTS = 0xC037000B,
        STATUS_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT = 0xC037000C,
        STATUS_VID_MB_STILL_REFERENCED = 0xC037000D,
        STATUS_VID_CHILD_GPA_PAGE_SET_CORRUPTED = 0xC037000E,
        STATUS_VID_INVALID_NUMA_SETTINGS = 0xC037000F,
        STATUS_VID_INVALID_NUMA_NODE_INDEX = 0xC0370010,
        STATUS_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED = 0xC0370011,
        STATUS_VID_INVALID_MEMORY_BLOCK_HANDLE = 0xC0370012,
        STATUS_VID_PAGE_RANGE_OVERFLOW = 0xC0370013,
        STATUS_VID_INVALID_MESSAGE_QUEUE_HANDLE = 0xC0370014,
        STATUS_VID_INVALID_GPA_RANGE_HANDLE = 0xC0370015,
        STATUS_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE = 0xC0370016,
        STATUS_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED = 0xC0370017,
        STATUS_VID_INVALID_PPM_HANDLE = 0xC0370018,
        STATUS_VID_MBPS_ARE_LOCKED = 0xC0370019,
        STATUS_VID_MESSAGE_QUEUE_CLOSED = 0xC037001A,
        STATUS_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED = 0xC037001B,
        STATUS_VID_STOP_PENDING = 0xC037001C,
        STATUS_VID_INVALID_PROCESSOR_STATE = 0xC037001D,
        STATUS_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT = 0xC037001E,
        STATUS_VID_KM_INTERFACE_ALREADY_INITIALIZED = 0xC037001F,
        STATUS_VID_MB_PROPERTY_ALREADY_SET_RESET = 0xC0370020,
        STATUS_VID_MMIO_RANGE_DESTROYED = 0xC0370021,
        STATUS_VID_INVALID_CHILD_GPA_PAGE_SET = 0xC0370022,
        STATUS_VID_RESERVE_PAGE_SET_IS_BEING_USED = 0xC0370023,
        STATUS_VID_RESERVE_PAGE_SET_TOO_SMALL = 0xC0370024,
        STATUS_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE = 0xC0370025,
        STATUS_VID_MBP_COUNT_EXCEEDED_LIMIT = 0xC0370026,
        STATUS_VID_SAVED_STATE_CORRUPT = 0xC0370027,
        STATUS_VID_SAVED_STATE_UNRECOGNIZED_ITEM = 0xC0370028,
        STATUS_VID_SAVED_STATE_INCOMPATIBLE = 0xC0370029,
        STATUS_VID_VTL_ACCESS_DENIED = 0xC037002A,
        STATUS_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED = 0x80370001,
        STATUS_IPSEC_BAD_SPI = 0xC0360001,
        STATUS_IPSEC_SA_LIFETIME_EXPIRED = 0xC0360002,
        STATUS_IPSEC_WRONG_SA = 0xC0360003,
        STATUS_IPSEC_REPLAY_CHECK_FAILED = 0xC0360004,
        STATUS_IPSEC_INVALID_PACKET = 0xC0360005,
        STATUS_IPSEC_INTEGRITY_CHECK_FAILED = 0xC0360006,
        STATUS_IPSEC_CLEAR_TEXT_DROP = 0xC0360007,
        STATUS_IPSEC_AUTH_FIREWALL_DROP = 0xC0360008,
        STATUS_IPSEC_THROTTLE_DROP = 0xC0360009,
        STATUS_IPSEC_DOSP_BLOCK = 0xC0368000,
        STATUS_IPSEC_DOSP_RECEIVED_MULTICAST = 0xC0368001,
        STATUS_IPSEC_DOSP_INVALID_PACKET = 0xC0368002,
        STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED = 0xC0368003,
        STATUS_IPSEC_DOSP_MAX_ENTRIES = 0xC0368004,
        STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED = 0xC0368005,
        STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES = 0xC0368006,
        STATUS_VOLMGR_INCOMPLETE_REGENERATION = 0x80380001,
        STATUS_VOLMGR_INCOMPLETE_DISK_MIGRATION = 0x80380002,
        STATUS_VOLMGR_DATABASE_FULL = 0xC0380001,
        STATUS_VOLMGR_DISK_CONFIGURATION_CORRUPTED = 0xC0380002,
        STATUS_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC = 0xC0380003,
        STATUS_VOLMGR_PACK_CONFIG_UPDATE_FAILED = 0xC0380004,
        STATUS_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME = 0xC0380005,
        STATUS_VOLMGR_DISK_DUPLICATE = 0xC0380006,
        STATUS_VOLMGR_DISK_DYNAMIC = 0xC0380007,
        STATUS_VOLMGR_DISK_ID_INVALID = 0xC0380008,
        STATUS_VOLMGR_DISK_INVALID = 0xC0380009,
        STATUS_VOLMGR_DISK_LAST_VOTER = 0xC038000A,
        STATUS_VOLMGR_DISK_LAYOUT_INVALID = 0xC038000B,
        STATUS_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS = 0xC038000C,
        STATUS_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED = 0xC038000D,
        STATUS_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL = 0xC038000E,
        STATUS_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS = 0xC038000F,
        STATUS_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS = 0xC0380010,
        STATUS_VOLMGR_DISK_MISSING = 0xC0380011,
        STATUS_VOLMGR_DISK_NOT_EMPTY = 0xC0380012,
        STATUS_VOLMGR_DISK_NOT_ENOUGH_SPACE = 0xC0380013,
        STATUS_VOLMGR_DISK_REVECTORING_FAILED = 0xC0380014,
        STATUS_VOLMGR_DISK_SECTOR_SIZE_INVALID = 0xC0380015,
        STATUS_VOLMGR_DISK_SET_NOT_CONTAINED = 0xC0380016,
        STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS = 0xC0380017,
        STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES = 0xC0380018,
        STATUS_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED = 0xC0380019,
        STATUS_VOLMGR_EXTENT_ALREADY_USED = 0xC038001A,
        STATUS_VOLMGR_EXTENT_NOT_CONTIGUOUS = 0xC038001B,
        STATUS_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION = 0xC038001C,
        STATUS_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED = 0xC038001D,
        STATUS_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION = 0xC038001E,
        STATUS_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH = 0xC038001F,
        STATUS_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED = 0xC0380020,
        STATUS_VOLMGR_INTERLEAVE_LENGTH_INVALID = 0xC0380021,
        STATUS_VOLMGR_MAXIMUM_REGISTERED_USERS = 0xC0380022,
        STATUS_VOLMGR_MEMBER_IN_SYNC = 0xC0380023,
        STATUS_VOLMGR_MEMBER_INDEX_DUPLICATE = 0xC0380024,
        STATUS_VOLMGR_MEMBER_INDEX_INVALID = 0xC0380025,
        STATUS_VOLMGR_MEMBER_MISSING = 0xC0380026,
        STATUS_VOLMGR_MEMBER_NOT_DETACHED = 0xC0380027,
        STATUS_VOLMGR_MEMBER_REGENERATING = 0xC0380028,
        STATUS_VOLMGR_ALL_DISKS_FAILED = 0xC0380029,
        STATUS_VOLMGR_NO_REGISTERED_USERS = 0xC038002A,
        STATUS_VOLMGR_NO_SUCH_USER = 0xC038002B,
        STATUS_VOLMGR_NOTIFICATION_RESET = 0xC038002C,
        STATUS_VOLMGR_NUMBER_OF_MEMBERS_INVALID = 0xC038002D,
        STATUS_VOLMGR_NUMBER_OF_PLEXES_INVALID = 0xC038002E,
        STATUS_VOLMGR_PACK_DUPLICATE = 0xC038002F,
        STATUS_VOLMGR_PACK_ID_INVALID = 0xC0380030,
        STATUS_VOLMGR_PACK_INVALID = 0xC0380031,
        STATUS_VOLMGR_PACK_NAME_INVALID = 0xC0380032,
        STATUS_VOLMGR_PACK_OFFLINE = 0xC0380033,
        STATUS_VOLMGR_PACK_HAS_QUORUM = 0xC0380034,
        STATUS_VOLMGR_PACK_WITHOUT_QUORUM = 0xC0380035,
        STATUS_VOLMGR_PARTITION_STYLE_INVALID = 0xC0380036,
        STATUS_VOLMGR_PARTITION_UPDATE_FAILED = 0xC0380037,
        STATUS_VOLMGR_PLEX_IN_SYNC = 0xC0380038,
        STATUS_VOLMGR_PLEX_INDEX_DUPLICATE = 0xC0380039,
        STATUS_VOLMGR_PLEX_INDEX_INVALID = 0xC038003A,
        STATUS_VOLMGR_PLEX_LAST_ACTIVE = 0xC038003B,
        STATUS_VOLMGR_PLEX_MISSING = 0xC038003C,
        STATUS_VOLMGR_PLEX_REGENERATING = 0xC038003D,
        STATUS_VOLMGR_PLEX_TYPE_INVALID = 0xC038003E,
        STATUS_VOLMGR_PLEX_NOT_RAID5 = 0xC038003F,
        STATUS_VOLMGR_PLEX_NOT_SIMPLE = 0xC0380040,
        STATUS_VOLMGR_STRUCTURE_SIZE_INVALID = 0xC0380041,
        STATUS_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS = 0xC0380042,
        STATUS_VOLMGR_TRANSACTION_IN_PROGRESS = 0xC0380043,
        STATUS_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE = 0xC0380044,
        STATUS_VOLMGR_VOLUME_CONTAINS_MISSING_DISK = 0xC0380045,
        STATUS_VOLMGR_VOLUME_ID_INVALID = 0xC0380046,
        STATUS_VOLMGR_VOLUME_LENGTH_INVALID = 0xC0380047,
        STATUS_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE = 0xC0380048,
        STATUS_VOLMGR_VOLUME_NOT_MIRRORED = 0xC0380049,
        STATUS_VOLMGR_VOLUME_NOT_RETAINED = 0xC038004A,
        STATUS_VOLMGR_VOLUME_OFFLINE = 0xC038004B,
        STATUS_VOLMGR_VOLUME_RETAINED = 0xC038004C,
        STATUS_VOLMGR_NUMBER_OF_EXTENTS_INVALID = 0xC038004D,
        STATUS_VOLMGR_DIFFERENT_SECTOR_SIZE = 0xC038004E,
        STATUS_VOLMGR_BAD_BOOT_DISK = 0xC038004F,
        STATUS_VOLMGR_PACK_CONFIG_OFFLINE = 0xC0380050,
        STATUS_VOLMGR_PACK_CONFIG_ONLINE = 0xC0380051,
        STATUS_VOLMGR_NOT_PRIMARY_PACK = 0xC0380052,
        STATUS_VOLMGR_PACK_LOG_UPDATE_FAILED = 0xC0380053,
        STATUS_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID = 0xC0380054,
        STATUS_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID = 0xC0380055,
        STATUS_VOLMGR_VOLUME_MIRRORED = 0xC0380056,
        STATUS_VOLMGR_PLEX_NOT_SIMPLE_SPANNED = 0xC0380057,
        STATUS_VOLMGR_NO_VALID_LOG_COPIES = 0xC0380058,
        STATUS_VOLMGR_PRIMARY_PACK_PRESENT = 0xC0380059,
        STATUS_VOLMGR_NUMBER_OF_DISKS_INVALID = 0xC038005A,
        STATUS_VOLMGR_MIRROR_NOT_SUPPORTED = 0xC038005B,
        STATUS_VOLMGR_RAID5_NOT_SUPPORTED = 0xC038005C,
        STATUS_BCD_NOT_ALL_ENTRIES_IMPORTED = 0x80390001,
        STATUS_BCD_TOO_MANY_ELEMENTS = 0xC0390002,
        STATUS_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED = 0x80390003,
        STATUS_VHD_DRIVE_FOOTER_MISSING = 0xC03A0001,
        STATUS_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH = 0xC03A0002,
        STATUS_VHD_DRIVE_FOOTER_CORRUPT = 0xC03A0003,
        STATUS_VHD_FORMAT_UNKNOWN = 0xC03A0004,
        STATUS_VHD_FORMAT_UNSUPPORTED_VERSION = 0xC03A0005,
        STATUS_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH = 0xC03A0006,
        STATUS_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION = 0xC03A0007,
        STATUS_VHD_SPARSE_HEADER_CORRUPT = 0xC03A0008,
        STATUS_VHD_BLOCK_ALLOCATION_FAILURE = 0xC03A0009,
        STATUS_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT = 0xC03A000A,
        STATUS_VHD_INVALID_BLOCK_SIZE = 0xC03A000B,
        STATUS_VHD_BITMAP_MISMATCH = 0xC03A000C,
        STATUS_VHD_PARENT_VHD_NOT_FOUND = 0xC03A000D,
        STATUS_VHD_CHILD_PARENT_ID_MISMATCH = 0xC03A000E,
        STATUS_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH = 0xC03A000F,
        STATUS_VHD_METADATA_READ_FAILURE = 0xC03A0010,
        STATUS_VHD_METADATA_WRITE_FAILURE = 0xC03A0011,
        STATUS_VHD_INVALID_SIZE = 0xC03A0012,
        STATUS_VHD_INVALID_FILE_SIZE = 0xC03A0013,
        STATUS_VIRTDISK_PROVIDER_NOT_FOUND = 0xC03A0014,
        STATUS_VIRTDISK_NOT_VIRTUAL_DISK = 0xC03A0015,
        STATUS_VHD_PARENT_VHD_ACCESS_DENIED = 0xC03A0016,
        STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH = 0xC03A0017,
        STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED = 0xC03A0018,
        STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT = 0xC03A0019,
        STATUS_VIRTUAL_DISK_LIMITATION = 0xC03A001A,
        STATUS_VHD_INVALID_TYPE = 0xC03A001B,
        STATUS_VHD_INVALID_STATE = 0xC03A001C,
        STATUS_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE = 0xC03A001D,
        STATUS_VIRTDISK_DISK_ALREADY_OWNED = 0xC03A001E,
        STATUS_VIRTDISK_DISK_ONLINE_AND_WRITABLE = 0xC03A001F,
        STATUS_CTLOG_TRACKING_NOT_INITIALIZED = 0xC03A0020,
        STATUS_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE = 0xC03A0021,
        STATUS_CTLOG_VHD_CHANGED_OFFLINE = 0xC03A0022,
        STATUS_CTLOG_INVALID_TRACKING_STATE = 0xC03A0023,
        STATUS_CTLOG_INCONSISTENT_TRACKING_FILE = 0xC03A0024,
        STATUS_VHD_METADATA_FULL = 0xC03A0028,
        STATUS_VHD_INVALID_CHANGE_TRACKING_ID = 0xC03A0029,
        STATUS_VHD_CHANGE_TRACKING_DISABLED = 0xC03A002A,
        STATUS_VHD_MISSING_CHANGE_TRACKING_INFORMATION = 0xC03A0030,
        STATUS_VHD_RESIZE_WOULD_TRUNCATE_DATA = 0xC03A0031,
        STATUS_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE = 0xC03A0032,
        STATUS_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE = 0xC03A0033,
        STATUS_QUERY_STORAGE_ERROR = 0x803A0001,
        STATUS_GDI_HANDLE_LEAK = 0x803F0001,
        STATUS_RKF_KEY_NOT_FOUND = 0xC0400001,
        STATUS_RKF_DUPLICATE_KEY = 0xC0400002,
        STATUS_RKF_BLOB_FULL = 0xC0400003,
        STATUS_RKF_STORE_FULL = 0xC0400004,
        STATUS_RKF_FILE_BLOCKED = 0xC0400005,
        STATUS_RKF_ACTIVE_KEY = 0xC0400006,
        STATUS_RDBSS_RESTART_OPERATION = 0xC0410001,
        STATUS_RDBSS_CONTINUE_OPERATION = 0xC0410002,
        STATUS_RDBSS_POST_OPERATION = 0xC0410003,
        STATUS_RDBSS_RETRY_LOOKUP = 0xC0410004,
        STATUS_BTH_ATT_INVALID_HANDLE = 0xC0420001,
        STATUS_BTH_ATT_READ_NOT_PERMITTED = 0xC0420002,
        STATUS_BTH_ATT_WRITE_NOT_PERMITTED = 0xC0420003,
        STATUS_BTH_ATT_INVALID_PDU = 0xC0420004,
        STATUS_BTH_ATT_INSUFFICIENT_AUTHENTICATION = 0xC0420005,
        STATUS_BTH_ATT_REQUEST_NOT_SUPPORTED = 0xC0420006,
        STATUS_BTH_ATT_INVALID_OFFSET = 0xC0420007,
        STATUS_BTH_ATT_INSUFFICIENT_AUTHORIZATION = 0xC0420008,
        STATUS_BTH_ATT_PREPARE_QUEUE_FULL = 0xC0420009,
        STATUS_BTH_ATT_ATTRIBUTE_NOT_FOUND = 0xC042000A,
        STATUS_BTH_ATT_ATTRIBUTE_NOT_LONG = 0xC042000B,
        STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE = 0xC042000C,
        STATUS_BTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH = 0xC042000D,
        STATUS_BTH_ATT_UNLIKELY = 0xC042000E,
        STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION = 0xC042000F,
        STATUS_BTH_ATT_UNSUPPORTED_GROUP_TYPE = 0xC0420010,
        STATUS_BTH_ATT_INSUFFICIENT_RESOURCES = 0xC0420011,
        STATUS_BTH_ATT_UNKNOWN_ERROR = 0xC0421000,
        STATUS_SECUREBOOT_ROLLBACK_DETECTED = 0xC0430001,
        STATUS_SECUREBOOT_POLICY_VIOLATION = 0xC0430002,
        STATUS_SECUREBOOT_INVALID_POLICY = 0xC0430003,
        STATUS_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND = 0xC0430004,
        STATUS_SECUREBOOT_POLICY_NOT_SIGNED = 0xC0430005,
        STATUS_SECUREBOOT_NOT_ENABLED = 0x80430006,
        STATUS_SECUREBOOT_FILE_REPLACED = 0xC0430007,
        STATUS_SECUREBOOT_POLICY_NOT_AUTHORIZED = 0xC0430008,
        STATUS_SECUREBOOT_POLICY_UNKNOWN = 0xC0430009,
        STATUS_SECUREBOOT_POLICY_MISSING_ANTIROLLBACKVERSION = 0xC043000A,
        STATUS_SECUREBOOT_PLATFORM_ID_MISMATCH = 0xC043000B,
        STATUS_SECUREBOOT_POLICY_ROLLBACK_DETECTED = 0xC043000C,
        STATUS_SECUREBOOT_POLICY_UPGRADE_MISMATCH = 0xC043000D,
        STATUS_SECUREBOOT_REQUIRED_POLICY_FILE_MISSING = 0xC043000E,
        STATUS_SECUREBOOT_NOT_BASE_POLICY = 0xC043000F,
        STATUS_SECUREBOOT_NOT_SUPPLEMENTAL_POLICY = 0xC0430010,
        STATUS_PLATFORM_MANIFEST_NOT_AUTHORIZED = 0xC0EB0001,
        STATUS_PLATFORM_MANIFEST_INVALID = 0xC0EB0002,
        STATUS_PLATFORM_MANIFEST_FILE_NOT_AUTHORIZED = 0xC0EB0003,
        STATUS_PLATFORM_MANIFEST_CATALOG_NOT_AUTHORIZED = 0xC0EB0004,
        STATUS_PLATFORM_MANIFEST_BINARY_ID_NOT_FOUND = 0xC0EB0005,
        STATUS_PLATFORM_MANIFEST_NOT_ACTIVE = 0xC0EB0006,
        STATUS_PLATFORM_MANIFEST_NOT_SIGNED = 0xC0EB0007,
        STATUS_SYSTEM_INTEGRITY_ROLLBACK_DETECTED = 0xC0E90001,
        STATUS_SYSTEM_INTEGRITY_POLICY_VIOLATION = 0xC0E90002,
        STATUS_SYSTEM_INTEGRITY_INVALID_POLICY = 0xC0E90003,
        STATUS_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED = 0xC0E90004,
        STATUS_NO_APPLICABLE_APP_LICENSES_FOUND = 0xC0EA0001,
        STATUS_CLIP_LICENSE_NOT_FOUND = 0xC0EA0002,
        STATUS_CLIP_DEVICE_LICENSE_MISSING = 0xC0EA0003,
        STATUS_CLIP_LICENSE_INVALID_SIGNATURE = 0xC0EA0004,
        STATUS_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID = 0xC0EA0005,
        STATUS_CLIP_LICENSE_EXPIRED = 0xC0EA0006,
        STATUS_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE = 0xC0EA0007,
        STATUS_CLIP_LICENSE_NOT_SIGNED = 0xC0EA0008,
        STATUS_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE = 0xC0EA0009,
        STATUS_CLIP_LICENSE_DEVICE_ID_MISMATCH = 0xC0EA000A,
        STATUS_AUDIO_ENGINE_NODE_NOT_FOUND = 0xC0440001,
        STATUS_HDAUDIO_EMPTY_CONNECTION_LIST = 0xC0440002,
        STATUS_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED = 0xC0440003,
        STATUS_HDAUDIO_NO_LOGICAL_DEVICES_CREATED = 0xC0440004,
        STATUS_HDAUDIO_NULL_LINKED_LIST_ENTRY = 0xC0440005,
        STATUS_SPACES_REPAIRED = 0x00E70000,
        STATUS_SPACES_PAUSE = 0x00E70001,
        STATUS_SPACES_COMPLETE = 0x00E70002,
        STATUS_SPACES_REDIRECT = 0x00E70003,
        STATUS_SPACES_FAULT_DOMAIN_TYPE_INVALID = 0xC0E70001,
        STATUS_SPACES_RESILIENCY_TYPE_INVALID = 0xC0E70003,
        STATUS_SPACES_DRIVE_SECTOR_SIZE_INVALID = 0xC0E70004,
        STATUS_SPACES_DRIVE_REDUNDANCY_INVALID = 0xC0E70006,
        STATUS_SPACES_NUMBER_OF_DATA_COPIES_INVALID = 0xC0E70007,
        STATUS_SPACES_INTERLEAVE_LENGTH_INVALID = 0xC0E70009,
        STATUS_SPACES_NUMBER_OF_COLUMNS_INVALID = 0xC0E7000A,
        STATUS_SPACES_NOT_ENOUGH_DRIVES = 0xC0E7000B,
        STATUS_SPACES_EXTENDED_ERROR = 0xC0E7000C,
        STATUS_SPACES_PROVISIONING_TYPE_INVALID = 0xC0E7000D,
        STATUS_SPACES_ALLOCATION_SIZE_INVALID = 0xC0E7000E,
        STATUS_SPACES_ENCLOSURE_AWARE_INVALID = 0xC0E7000F,
        STATUS_SPACES_WRITE_CACHE_SIZE_INVALID = 0xC0E70010,
        STATUS_SPACES_NUMBER_OF_GROUPS_INVALID = 0xC0E70011,
        STATUS_SPACES_DRIVE_OPERATIONAL_STATE_INVALID = 0xC0E70012,
        STATUS_SPACES_UPDATE_COLUMN_STATE = 0xC0E70013,
        STATUS_SPACES_MAP_REQUIRED = 0xC0E70014,
        STATUS_SPACES_UNSUPPORTED_VERSION = 0xC0E70015,
        STATUS_SPACES_CORRUPT_METADATA = 0xC0E70016,
        STATUS_SPACES_DRT_FULL = 0xC0E70017,
        STATUS_SPACES_INCONSISTENCY = 0xC0E70018,
        STATUS_SPACES_LOG_NOT_READY = 0xC0E70019,
        STATUS_SPACES_NO_REDUNDANCY = 0xC0E7001A,
        STATUS_SPACES_DRIVE_NOT_READY = 0xC0E7001B,
        STATUS_SPACES_DRIVE_SPLIT = 0xC0E7001C,
        STATUS_SPACES_DRIVE_LOST_DATA = 0xC0E7001D,
        STATUS_SPACES_ENTRY_INCOMPLETE = 0xC0E7001E,
        STATUS_SPACES_ENTRY_INVALID = 0xC0E7001F,
        STATUS_VOLSNAP_BOOTFILE_NOT_VALID = 0xC0500003,
        STATUS_VOLSNAP_ACTIVATION_TIMEOUT = 0xC0500004,
        STATUS_IO_PREEMPTED = 0xC0510001,
        STATUS_SVHDX_ERROR_STORED = 0xC05C0000,
        STATUS_SVHDX_ERROR_NOT_AVAILABLE = 0xC05CFF00,
        STATUS_SVHDX_UNIT_ATTENTION_AVAILABLE = 0xC05CFF01,
        STATUS_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED = 0xC05CFF02,
        STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED = 0xC05CFF03,
        STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED = 0xC05CFF04,
        STATUS_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED = 0xC05CFF05,
        STATUS_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED = 0xC05CFF06,
        STATUS_SVHDX_RESERVATION_CONFLICT = 0xC05CFF07,
        STATUS_SVHDX_WRONG_FILE_TYPE = 0xC05CFF08,
        STATUS_SVHDX_VERSION_MISMATCH = 0xC05CFF09,
        STATUS_VHD_SHARED = 0xC05CFF0A,
        STATUS_SVHDX_NO_INITIATOR = 0xC05CFF0B,
        STATUS_VHDSET_BACKING_STORAGE_NOT_FOUND = 0xC05CFF0C,
        STATUS_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP = 0xC05D0000,
        STATUS_SMB_BAD_CLUSTER_DIALECT = 0xC05D0001,
        STATUS_SMB_GUEST_LOGON_BLOCKED = 0xC05D0002,
        STATUS_SECCORE_INVALID_COMMAND = 0xC0E80000,
        STATUS_VSM_NOT_INITIALIZED = 0xC0450000,
        STATUS_VSM_DMA_PROTECTION_NOT_IN_USE = 0xC0450001,
        STATUS_APPEXEC_CONDITION_NOT_SATISFIED = 0xC0EC0000,
        STATUS_APPEXEC_HANDLE_INVALIDATED = 0xC0EC0001,
        STATUS_APPEXEC_INVALID_HOST_GENERATION = 0xC0EC0002,
        STATUS_APPEXEC_UNEXPECTED_PROCESS_REGISTRATION = 0xC0EC0003,
        STATUS_APPEXEC_INVALID_HOST_STATE = 0xC0EC0004,
        STATUS_APPEXEC_NO_DONOR = 0xC0EC0005,
        STATUS_APPEXEC_HOST_ID_MISMATCH = 0xC0EC0006,
        STATUS_APPEXEC_UNKNOWN_USER = 0xC0EC0007,
    }

    public enum NtStatusFacility
    {
        FACILITY_DEFAULT = 0x0,
        FACILITY_DEBUGGER = 0x1,
        FACILITY_RPC_RUNTIME = 0x2,
        FACILITY_RPC_STUBS = 0x3,
        FACILITY_IO_ERROR_CODE = 0x4,
        FACILITY_CODCLASS_ERROR_CODE = 0x6,
        FACILITY_NTWIN32 = 0x7,
        FACILITY_NTCERT = 0x8,
        FACILITY_NTSSPI = 0x9,
        FACILITY_TERMINAL_SERVER = 0xA,
        FACILTIY_MUI_ERROR_CODE = 0xB,
        FACILITY_USB_ERROR_CODE = 0x10,
        FACILITY_HID_ERROR_CODE = 0x11,
        FACILITY_FIREWIRE_ERROR_CODE = 0x12,
        FACILITY_CLUSTER_ERROR_CODE = 0x13,
        FACILITY_ACPI_ERROR_CODE = 0x14,
        FACILITY_SXS_ERROR_CODE = 0x15,
        FACILITY_TRANSACTION = 0x19,
        FACILITY_COMMONLOG = 0x1A,
        FACILITY_VIDEO = 0x1B,
        FACILITY_FILTER_MANAGER = 0x1C,
        FACILITY_MONITOR = 0x1D,
        FACILITY_GRAPHICS_KERNEL = 0x1E,
        FACILITY_DRIVER_FRAMEWORK = 0x20,
        FACILITY_FVE_ERROR_CODE = 0x21,
        FACILITY_FWP_ERROR_CODE = 0x22,
        FACILITY_NDIS_ERROR_CODE = 0x23,
        FACILITY_TPM = 0x29,
        FACILITY_RTPM = 0x2A,
        FACILITY_HYPERVISOR = 0x35,
        FACILITY_IPSEC = 0x36,
        FACILITY_VIRTUALIZATION = 0x37,
        FACILITY_VOLMGR = 0x38,
        FACILITY_BCD_ERROR_CODE = 0x39,
        FACILITY_WIN32K_NTUSER = 0x3E,
        FACILITY_WIN32K_NTGDI = 0x3F,
        FACILITY_RESUME_KEY_FILTER = 0x40,
        FACILITY_RDBSS = 0x41,
        FACILITY_BTH_ATT = 0x42,
        FACILITY_SECUREBOOT = 0x43,
        FACILITY_AUDIO_KERNEL = 0x44,
        FACILITY_VSM = 0x45,
        FACILITY_VOLSNAP = 0x50,
        FACILITY_SDBUS = 0x51,
        FACILITY_SHARED_VHDX = 0x5C,
        FACILITY_SMB = 0x5D,
        FACILITY_VISUALCPP = 0x6D,
        FACILITY_INTERIX = 0x99,
        FACILITY_SPACES = 0xE7,
        FACILITY_SECURITY_CORE = 0xE8,
        FACILITY_SYSTEM_INTEGRITY = 0xE9,
        FACILITY_LICENSING = 0xEA,
        FACILITY_PLATFORM_MANIFEST = 0xEB,
        FACILITY_APP_EXEC = 0xEC,
    }

    public enum NtStatusSeverity
    {
        STATUS_SEVERITY_SUCCESS = 0x0,
        STATUS_SEVERITY_INFORMATIONAL = 0x1,
        STATUS_SEVERITY_WARNING = 0x2,
        STATUS_SEVERITY_ERROR = 0x3,
    }
}