## How to contribute to Slither.io-bot

To get started, <a href="https://cla-assistant.io/ErmiyaEskandary/Slither.io-bot">sign the Contributor License Agreement</a>.

[![CLA assistant](https://cla-assistant.io/readme/badge/ErmiyaEskandary/Slither.io-bot)](https://cla-assistant.io/ErmiyaEskandary/Slither.io-bot)

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/ErmiyaEskandary/Slither.io-bot/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/ErmiyaEskandary/Slither.io-bot/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

When making your report, be sure to mention:

* Title: Short description of what the issue is. (Clearer the better.)
* **Label: Add the Bug label**
* Your browser. (Firefox, Google Chrome, etc.)
* What version of the bot you are using. (Can be found at the top of the bot's code in Tamper/Greasemonkey.)
* What you think caused this issue. (On your end, you don't need to diagnose our code, tell us what you did that caused it.)
* If you can, suggest a solution. (Again, you don't need to be technical in your description.)

**Pat yourself on the back for being a productive contributor of an open source project.**
#### **Did you write a patch that fixes a bug, want to make a PR or want to change some of the code?**

* Please contribute using Github Flow. Create a branch, add commits, and open a pull request targeting the default branch - do not change to the master branch. **All code needs to be retested there and then merged into master.**

* Please use the already made pull request template to layout your pull request.

* Ensure the PR template is filled in **fully** and required conditions are met.

* Adhere to the current code style. Listen to Hound's comments on your PR and fix them. 

* Your PR will **need** to include **scores of the bot before and after your changes, in at least 30 games**. This is due to checking the **efficiency** of the bot and is **mandatory** _except if you are making changes to the documentation._ For information on how to test, please refer to [the wiki](https://github.com/ErmiyaEskandary/Slither.io-bot/wiki/How-to-test-bot-effectiveness).

* If is all is good, wait for 5 approvals by contributors which decide if your PR will be merged. The repo owner can also merge it in early **if there is good reason to do so**.

*Pull request are made to be discussed, thus collaborators may want you to change things. Don't make a new PR for these changes. Update your existing PR.*

#### **Do you intend to add a new feature or change an existing one?**
Check if it's been suggested already [here](https://github.com/ErmiyaEskandary/Slither.io-bot/issues).

If it has, or something very similar has :
* Check out the discussion on that suggestion.
* If you feel you have more to add, then comment it there. Don't make a brand new issue for something that has already been suggested.

If it hasn't been suggested, suggest your change on [Gitter](https://gitter.im/ErmiyaEskandary/Slither.io-bot) if you need help or just [create an issue](https://github.com/ErmiyaEskandary/Slither.io-bot/issues/new).

Be sure to include in your report:

* Title: A clear, short description of what you suggest. You can always go into detail in the description
* Information about your suggestion. (Does not need to be technical.)
* **Label: Add the Suggestion label.**
* Why you think this would improve the bot if added.
* If you have JavaScript experience, feel free to include snippets of code. (or even refer to a pull request or fork)

**Pat yourself on the back. If your suggestion is added, you will be a productive contributor to an open source passion-powered project.**

#### **Do you have questions about the source code?**

* Ask any question on [Gitter](https://gitter.im/ErmiyaEskandary/Slither.io-bot).


Slither.io bot is a volunteer effort and is a collaborative and fun project. We encourage you to pitch in and [join the team](https://gitter.im/ErmiyaEskandary/Slither.io-bot)!

Thanks!

ErmiyaEskandary, FliiFe and other contributers...
