# Binary Ninja Plugins

| PluginName | Author | Last Updated | License | Type | Description |
|------------|--------|--------------|---------|----------|-------------|
|[6502 Architecture Plugin](https://github.com/Vector35/6502)|[Vector 35 Inc](https://github.com/Vector35)|2020-05-09|MIT|architecture|An architecture plugin for 6502 and binary view for NES roms.|
|[Kaitai UI Plugin](https://github.com/Vector35/kaitai)|[Vector 35 Inc](https://github.com/Vector35)|2020-03-02|MIT|ui|Browse hex with a tree view populated from Kaitai Struct formats.|
|[Snippet UI Plugin](https://github.com/Vector35/snippets)|[Vector 35 Inc](https://github.com/Vector35)|2020-05-13|MIT|ui|Example UI plugin demonstrating how to create a snippet manager that allows for quick one-liners to be bound to hotkeys.|
|[Opaque Predicate Patcher](https://github.com/Vector35/OpaquePredicatePatcher)|[Vector 35 LLC](https://github.com/Vector35)|2019-06-20|MIT|helper|Automatically patch opaque predicates|
|[Sample Plugin](https://github.com/Vector35/sample_plugin)|[Vector 35 LLC](https://github.com/Vector35)|2019-06-20|MIT|architecture, binaryview, core, helper, ui|This is a short description meant to fit on one line.|
|[Z80 Architecture Plugin](https://github.com/Vector35/Z80)|[Vector 35 Inc](https://github.com/Vector35)|2020-02-08|MIT|architecture|Sample Z80 architecture plugin written to accompany the <a href='https://binary.ninja/2020/01/08/guide-to-architecture-plugins-part1.html'>introductory blog post</a>.|
|[Signature Kit Plugin](https://github.com/Vector35/sigkit)|[Vector 35 Inc](https://github.com/Vector35)|2020-03-08|MIT|core, helper, ui|Python tools for working with Signature Libraries|
|[Debugger](https://github.com/Vector35/debugger)|[Vector35](https://github.com/Vector35)|2020-05-19|MIT|helper, ui|Native debugger support|
