#if !defined(_KERN_ECC_H)
#define _KERN_ECC_H

#include <sys/cdefs.h>

__BEGIN_DECLS

/*
 * Copyright (c) 2013 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 * 
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

#define ECC_EVENT_INFO_DATA_ENTRIES	8
struct ecc_event {
	uint8_t 	id;	// ID of memory (e.g. L2C), platform-specific
	uint8_t		count;	// Of uint64_t's used, starting at index 0
	uint64_t	data[ECC_EVENT_INFO_DATA_ENTRIES] __attribute__((aligned(8))); // Event-specific data 
};


#ifdef KERNEL_PRIVATE
extern kern_return_t 	ecc_log_record_event(const struct ecc_event *ev);
#endif 

#ifdef XNU_KERNEL_PRIVATE
extern void 		ecc_log_init(void);
extern kern_return_t 	ecc_log_get_next_event(struct ecc_event *ev);
extern uint32_t 	ecc_log_get_correction_count(void);
#endif 

__END_DECLS

#endif /* !defined(_KERN_ECC_H) */
