/*
 * Copyright (c) 2010 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#include <sys/types.h>
#if defined(__arm__)
#include <arm/arch.h>
#endif

#if defined(__ppc64__) || defined(__i386__) || defined(__x86_64__)
static int64_t __remove_counter = 0;
#else
static int32_t __remove_counter = 0;
#endif

__uint64_t
__get_remove_counter(void) {
#if defined(__arm__) && !defined(_ARM_ARCH_6)
	return __remove_counter;
#else
	return __sync_add_and_fetch(&__remove_counter, 0);
#endif
}

void
__inc_remove_counter(void)
{
#if defined(__arm__) && !defined(_ARM_ARCH_6)
	__remove_counter++;
#else
	__sync_add_and_fetch(&__remove_counter, 1);
#endif
}
