# Contribution Guidelines

**Mission Statement**

We will document examples of excessive force being used by law enforcement officers during the 2020 protests sparked by the death of George Floyd.

Our goal in doing this is to assist journalists, politicians, prosecutors, activists and concerned citizens who can use the evidence accumulated here for political campaigns, news reporting, public education and prosecution of criminal police officers.

* ### [Frequently Asked Questions](#Frequently-Asked-Questions-1)
* ### [Code of Conduct](#Code-of-Conduct-1)
* ### [How to Contribute](#How-to-Contribute-1)
* ### [Incident Report Guidelines](#Incident-Report-Guidelines-1)

## Frequently Asked Questions

### How can I help?

Check out [How to Contribute](#How-to-Contribute-1).

### Where can I find evidence?

Check out the [gather evidence](#1-Gather-evidence) section.

### <a name="make-pr"></a> How do I make a pull request / what is a pull request?

A pull request is a feature of the git version control system which allows you to directly propose an edit to the maintainers of a repository.

For major changes, check out [this tutorial](https://www.freecodecamp.org/news/how-to-make-your-first-pull-request-on-github-3/) to learn how to fork github repositories and make pull requests.

For minor changes and file edits, check the [Submission Guide](#Submission-Guide) to learn how to directly propose edits using Github's text editor.

### How do I report bad information if I don't want to make a PR?

The best way to help is definitely to make a pull request yourself, but if you can't or don't want to, you can [post an issue](https://github.com/2020PB/police-brutality/issues/new) on the repository or [send a message to the moderators of /r/2020PoliceBrutality](https://www.reddit.com/message/compose?to=%2Fr%2F2020PoliceBrutality), but these will be much more difficult for us to parse and respond to than issues posted to the repository.

## Code of Conduct

**1. Do not incite violence or hatred**

However angry we feel about the reactions to the protests, we will not use inflammatory or judgemental language, and will not tolerate such behavior from others.

We wish to remain an objective platform which can not be dismissed out of hand due to biased descriptions of events.


**2. Document and archive the evidence**

Our goal is to document primary and secondary evidence of police brutality towards protesters. As the events are currently ongoing and the evidence is primarily being distributed through social media, it may become unavailable without warning; as such, we will archive this information to keep it available for concerned citizens, journalists and (hopefully) prosecutors.

**3. Spread the word**

Raise awareness of this community and repository so that more obscure evidence which is not going viral will be posted here.

Share the evidence accumulated here with concerned citizens, congress members, attorneys, local government officials, journalists, activist groups and social media.

**4. Use the community as a resource, and be a resource for the community**

If people ask how to contribute, send them tutorials for using Github and provide sources they can use to find new evidence. Send them to this page!

If you see a mistake in the incident reports, [make a Pull Request](#make-pr) to fix it.

If you notice a lack of information from specific locations or need assistance finding information about a particular event, [post an issue](https://github.com/2020PB/police-brutality/issues/new) or use the [subreddit](https://www.reddit.com/r/2020PoliceBrutality).

**5. Be objective**

The purpose of this effort is to share evidence of police brutality, of which hundreds of examples have been created and documented during these protests.

If you are here to bring awareness to what you see as inexcusable behavior by the police, you do not need to mischaracterize, cherry pick or manufacture evidence to do that. Their actions speak for themselves, so simply document what they do.

## How to Contribute

There are many ways you can contribute to this effort.

We need people to identify and research incidents and ensure that the current reports abide by the [code of conduct](#Code-of-Conduct-1) and meet the [content standards](#Content-Standards).

### Adding & Updating Incident Reports

#### 1. Gather evidence

To contribute to the incident reports, you will need to identify events where police used excessive force or abused their power during the George Floyd protests.

People have been regularly posting evidence to the following sources:
- [our subreddit /r/2020PoliceBrutality](https://www.reddit.com/r/2020PoliceBrutality/)
- [/r/Bad_Cop_No_Donut subreddit](https://www.reddit.com/r/Bad_Cop_No_Donut/)
- [/r/PublicFreakout subreddit](https://www.reddit.com/r/PublicFreakout/)
- [#BlackLivesMatter](https://twitter.com/search?q=%23BlackLivesMatter) and [#BLM](https://twitter.com/search?q=%23BLM) on Twitter
- [#JusticeForGeorgeFloyd](https://twitter.com/hashtag/JusticeForGeorgeFloyd) on Twitter
- [#PoliceBrutality](https://twitter.com/hashtag/PoliceBrutality) on Twitter
- [#[CityName]riots](https://twitter.com/hashtag/austinriots) & [#[CityName]protest(s)](https://twitter.com/search?q=%23AtlantaProtests) on Twitter

#### 2. Add it to the repo

Once you identify the state and location for the incident, check if it has already been posted to this repository.

**If the incident has already been reported**

If you find the same incident in this repository, check the following:
- **Is the exact same evidence already posted?**
  - If so, do not add duplicate evidence.
  - If not, add it as a source.
- **Does your post add context or change the interpretation of other evidence?**
  - If so, [update the existing description](#Submission-Guide) with the new information.

**If the incident has not been reported**

If you have identified a new incident, ensure that it meets our [content standards](#Content-Standards) and follow the [Submission Guide](#Submission-Guide) to add it to the repo.

#### 3. Share it!

Share the evidence on Twitter and [our subreddit](https://www.reddit.com/r/2020PoliceBrutality).
Send it to your friends and bring attention to what you find.

### Maintaining the Repository

If you would like to help maintain the repository, please read our [incident report guidelines](#Incident-Report-Guidelines-1) which contain information about editing the repo and content standards.

#### Cleanup misinformation and poorly documented reports

You can ensure this remains a source of quality evidence by looking through the existing reports on this repository and ensuring they meet our standards. If you notice anything which goes against the code of conduct or content guidelines, please make an issue or Pull Request to have it taken down.

#### Contextualize existing reports

You can also help maintain this repository by looking for additional context surrounding the incidents covered by existing reports. Use the research guidelines listed above and include search terms related to the incident in question to find more information.

#### Contribute to this document!

Make guides to help others contribute or update the contribution guidelines.

Find additional quality sources that can be used to find evidence and add them to the [gather evidence](#1-Gather-evidence) section.

#### Make suggestions

If you think we should update this repository, change the guidelines, add new content or really do anything differently, let us know about it! [Post an issue](https://github.com/2020PB/police-brutality/issues/new) with your suggestions!

## Incident Report Guidelines

### Content Standards

**1. Only events related to the 2020 George Floyd protests in the United States.**
  - No old events or events not related to the protests.
  - No events from other countries.

Only add incidents which are related to the 2020 George Floyd protests. While all examples of police abuse are abhorrent, this repository exists for the purpose of documenting the brutal crackdowns on peaceful protests and use of excessive force by police.

**2. Only add clear evidence of police brutality or abuse of power.**
  - No looters getting arrested unless excessive force is used.
  - No random Twitter descriptions of events (reputable source or direct evidence required).
  - No out of context or misleading information.

Only add incidents which have clear evidence of police abuse of power or excessive force. Do not post anything based on rumors and do not post manipulated or out of context information.
Eye-witness accounts for documented events are allowed, as are eye-witness accounts in the absence of video evidence, but only from reputable sources such as congresspeople or reporters from major outlets.

**3. Use objective language.**
    - No "cop beats protester with clear disregard for his humanity" or "pig shoots at person with contempt".
    - No language supporting or denigrating police or activists.

Let police actions speak for themselves; use unbiased descriptions to explain what happened with as much detail as possible and using unemotional language.
Pretend that you're an AI telling a human exactly what the evidence shows and that you'll have your AWS budget reduced if your algorithm is faulty.

**4. Use correct location & date.**
  - Place the incident report under the correct city's section in the file for the correct state.
    - If the location is unknown, place it in the "Unknown Location" file.
  - Place a pipe **|** after the incident title, followed by the date in the format `Month (word form), Day (numeric ordinal form)`, e.g. `May 30th`
    - If the date is unknown, get the best guess based on context and use `(believed to be) Date`
    - If you can't get the date from context, put`Unknown Date`

It is important to keep this repository organized with contextual information, both to assist researchers looking for more information and to provide an accurate record of these historic events.


### Submission Guide

Please make sure you have read the [Content Standards](#Content-Standards) and [Code of Conduct](#Code-of-Conduct) before submitting any edits.

**1. Locate the file for the state the incident occurred in**

Files are named as `State.md`. Identify the correct file or make a new one if you do not already see a file for the right state.

**2. Open the text editor**

Click the edit icon on the top right of the file preview.

![Image of the edit button on a text file](https://i.imgur.com/bwVpyBI.png)

**3. Add your changes**

Add your incident report or edit an existing one, ensuring that you stick to the [Incident Report Format](#Incident-Report-Format).

**4. Summarize your changes**

On the bottom of the editor, write a title and a brief description of your changes.

![Image of the commit summary form](https://i.imgur.com/mkXAeZm.png)

**5. Commit!**

Click "Propose file change" then "Create pull request" and you're done!

#### Incident Report Format

Use the following format for all incident reports.

```
// State.md

## City

### Brief description of a thing that happened | Date

// (If uncertain, use `(believed to be) Date` with best guess based on context)

If possible, give some context to the incident that occurred: during the 2020 George Floyd protests, a number
of users on Reddit became outraged by repeated incidents of police brutality towards protesters.

Then give an objective description of the incident: to draw attention to the abuses by police, those users
created a github repository on June 1st 2020 to compile evidence of police brutality for use by journalists
and concerned citizens. The repository was initialized with a README document explaining how other people
could get involved in the project, providing a meta example of what a good incident report looks like.

**Links**

* [Github repository](https://github.com/2020PB/police-brutality)
* [Subreddit with description of motives in sidebar](https://www.reddit.com/r/2020PoliceBrutality)
```
