# Police Brutality During the 2020 George Floyd Protests

* [Web app](http://www.2020policebrutality.com/) to visually view posts
* [Data API](https://raw.githubusercontent.com/2020PB/police-brutality/data_build/all-locations.json) to build your own front end

[Table of Contents](#Table-of-Contents)

This repository exists to accumulate and contextualize evidence of police brutality during the 2020 George Floyd protests.

Our goal in doing this is to assist journalists, politicians, prosecutors, activists and concerned citizens who can use the evidence accumulated here for political campaigns, news reporting, public education and prosecution of criminal police officers.

This was first started as a megathread on the subreddit [/r/2020PoliceBrutality](https://www.reddit.com/r/2020PoliceBrutality) but after being overwhelmed by people looking to contribute, we decided to make a github repository so that everyone who wants to can easily contribute to the project directly.

If you are here looking for evidence of police brutality, please refer to the table of contents for links to incident reports sorted by state.

If you wish to contribute, please start by reading the [contribution guidelines](./CONTRIBUTING.md).

## Background

On May 25, 2020 an African American man named George Floyd was murdered by police officer Derek Chauvin in Minneapolis, a city with a police department [known for its use of excessive force](https://www.nytimes.com/2020/05/27/us/minneapolis-police.html). George Floyd's murder sparked a wave of protests across the nation as citizens became outraged by another example of police misconduct in the midst of a historic financial and public health crisis caused by the Coronavirus pandemic.

In response to the burgeoning civil unrest, numerous police departments violently cracked down on peaceful demonstrations and drastically escalated confrontations with protesters. As videos of these crack-downs circulated on social media over the following hours and days, the protests escalated nationally and every major city in the country saw mass protests, with some experiencing riots that resulted in mass property destruction and saw buildings burned down.
As these protests have continued, hundreds of incidents have been recorded where police engaged in unprovoked violent assaults, outright police brutality and unprovoked arrests and harassment.

## Table of Contents

* [Contribution Guidelines](./CONTRIBUTING.md)
* [FAQ](./CONTRIBUTING.md#Frequently-Asked-Questions)
* [Raw Video Archive](https://github.com/pb-files/pb-videos)
* **Incident Reports**
  * [Alabama](./reports/Alabama.md)
  * [Arkansas](./reports/Arkansas.md)
  * [California](./reports/California.md)
  * [Colorado](./reports/Colorado.md)
  * [Florida](./reports/Florida.md)
  * [Georgia](./reports/Georgia.md)
  * [Illinois](./reports/Illinois.md)
  * [Indiana](./reports/Indiana.md)
  * [Iowa](./reports/Iowa.md)
  * [Kansas](./reports/Kansas.md)
  * [Kentucky](./reports/Kentucky.md)
  * [Louisiana](./reports/Louisiana.md)
  * [Michigan](./reports/Michigan.md)
  * [Minnesota](./reports/Minnesota.md)
  * [Missouri](./reports/Missouri.md)
  * [Nebraska ](./reports/Nebraska.md)
  * [Nevada](./reports/Nevada.md)
  * [New York](./reports/New%20York.md)
  * [North Carolina](./reports/North%20Carolina.md)
  * [Ohio](./reports/Ohio.md)
  * [Oregon](./reports/Oregon.md)
  * [Pennsylvania](./reports/Pennsylvania.md)
  * [South Carolina](./reports/South%20Carolina.md)
  * [Tennessee](./reports/Tennessee.md)
  * [Texas](./reports/Texas.md)
  * [Utah](./reports/Utah.md)
  * [Virginia](./reports/Virginia.md)
  * [Washington](./reports/Washington.md)
  * [Washington D.C.](./reports/Washington%20DC.md)
  * [Wisconsin](./reports/Wisconsin.md)
  * [Unknown Location](./reports/Unknown%20Location.md)
