[![Build Status](https://travis-ci.org/mimblewimble/grin.svg?branch=master)](https://travis-ci.org/mimblewimble/grin)
[![Gitter chat](https://badges.gitter.im/grin_community/Lobby.png)](https://gitter.im/grin_community/Lobby)
[![Codecov coverage status](https://codecov.io/gh/mimblewimble/grin/branch/master/graph/badge.svg)](https://codecov.io/gh/mimblewimble/grin)

# MimbleWimble

MimbleWimble as an idea was released anonymously. It's a block chain with PoW but [almost nothing else](https://github.com/mimblewimble/docs/wiki/No-this,-no-that).

Grin is an in-progress implementation of the MimbleWimble protocol.
Many characteristics of MimbleWimble and Grin are still undefined.
Please read our [introduction to MimbleWimble and Grin](https://github.com/mimblewimble/grin/blob/master/doc/intro.md)

## What is here in "docs"?

[__The wiki__](https://github.com/mimblewimble/docs/wiki/)

Documents about MimbleWimble, its implementations, and more.

We have:
 - [Introduction material](https://github.com/mimblewimble/grin/blob/master/doc/intro.md)
 - [Technical documentation](https://github.com/mimblewimble/grin/tree/master/doc)
 - The Wiki, open for all to edit and improve! Has things like
   - [Getting started with Grin](https://github.com/mimblewimble/docs/wiki/Getting-Started-With-Grin%3A-Links-and-Resources)
   - [FAQ](https://github.com/mimblewimble/docs/wiki/FAQ)
   - [Grin for programmers](https://github.com/mimblewimble/docs/wiki/Hacking-and-contributing)
   - [Glossary and jargon](https://github.com/mimblewimble/docs/wiki/Jargon-file-and-glossary)
   - [Archive of some design discussions](https://github.com/mimblewimble/docs/wiki/Design-discussions)
   - [and more...](https://github.com/mimblewimble/docs/wiki/)

## Get involved

Please read [how to contribute](https://github.com/mimblewimble/grin/blob/master/CONTRIBUTING.md)
and be aware of our
[code of conduct](https://github.com/mimblewimble/grin/blob/master/CODE_OF_CONDUCT.md).

### Find us:

* Chat: [Gitter](https://gitter.im/grin_community/Lobby).
* Mailing list: [see archives](https://lists.launchpad.net/mimblewimble/) or
join the [~MimbleWimble team](https://launchpad.net/~mimblewimble)
and click there to request to join the mailing list.

## Philosophy

* Grin wants to be a minimal implementation.

* It wants to be inclusive and welcoming for all walks of life, without judgement.

* Grin aims high, to bring improvements for all, without harming others.

* The Grin implementation's maintainers may have strong opinions
to stay lean and simple, without diminishing others.

* We believe in pull requests, data and scientific research.

* We do not take interest in unfounded beliefs.

## Our thanks go out to

Tom Elvis Jedusor for the first formulation of MimbleWimble.

Andrew Poelstra for his related work and improvements.

John Tromp for the Cuckoo Cycle proof of work.

J.K. Rowling for making it despite extraordinary adversity.

## License

Apache License v2.0.
