# 状態とストレージ

*別の言語で読む: [English](state.md), [Korean](state_KR.md), [简体中文](state_ZH-CN.md).*

## Grinの状態

### 構造

Grinのチェーンの全ての情報はこれらによって成り立っている:

1. 全てのUTXOのセット
1. それぞれのアウトプットのレンジプルーフ
1. 全てのトランザクションカーネル
1. 上記に対応するMMR(アウトプットのMMRはUTXOだけでなく、 *全ての* アウトプットのハッシュを含むという例外はある)

加えて、チェーン内の全てのハッシュは最も(PoWの)仕事をしているチェーンにアンカーされている必要がある。
一度それぞれのレンジプルーフをバリデートし、全てのカーネルコミットメントの合計値を計算すれば、もはやレンジプルーフとカーネルはノードにとって必要ないことに注意。

### バリデーション

Grinの全ての状態を知っていれば、これらをバリデートできる:

1. カーネルシグチャがそれぞれのコミットメント(公開鍵)に対して正しいこと。これによりカーネルが正しいと言える。
1. 全てのカーネルコミットメントの合計値が、全てのUTXOコミットメント-全ての共有量と等しいこと。これにより、カーネルとアウトプットコミットメントが全て正しく、予想外のコインが生まれていないことが言える。
1. 全てのUTXO、レンジプルーフ、カーネルのハッシュがそれぞれのMMR内にあり、正しいルートにハッシュされていること。
1. ある時点で与えられているブロックヘッダーの中で最も(PoWの)仕事をしているブロックヘッダーが3つのMMRのルートを含んでいること。これにより、MMRが正しいことと、全ての状態は最も仕事をしているチェーンによって作られたことが検証できる。

### MMRと剪定

それぞれのMMRのリーフノードを生成するためのデータは、それらの位置の情報に加え以下の通り:

* アウトプットMMRはフィーチャーフィールドとジェネシス以降の全てのアウトプットのコミットメントのハッシュ
* レンジプルーフMMRは全てのレンジプルーフのデータのハッシュ
* カーネルMMRは全てのカーネルのフィールド(フィーチャー、手数料、ロックハイト、余剰なコミットメント、余剰な署名)のハッシュ

全てのアウトプット、レンジプルーフ、カーネルに対応するMMRはそれらが発生したブロックのMMRに加えられる(全てのブロックデータはソートされている必要があるのはこのため)。

アウトプットが使用されるように、それぞれのコミットメントとレンジプルーフデータは削除されうる。
加えて、対応するアウトプットとレンジプルーフのMMRは剪定されうる。

## 状態のストレージ

Grinにおけるアウトプット、レンジプルーフ、カーネルのデータストレージはシンプルで、メモリーマップドなデータアクセスができる追記型のプレーンなファイルを使用。
アウトプットが使用されたら、削除ログが削除可能な状態として保持される。
それらの状態は全て同じオーダーとしてインサートされるので、MMRノードの状態と上手いこに一致している。
削除ログが大きくなった場合、時々削除されたものを除いたうえでリライトする。
これにより、対応するファイルがコンパクト化され(ここでも追記のみ)、削除ログは空になる。
MMRのためには少し複雑化が必要。
