# Bitcoiner를 위한 Grin/Mimblewimble

## 프라이버시와 대체가능성(Fungibility)

Grin 트랜잭션에는 트랜잭션을 프라이빗하게 만드는 3 가지 주요 속성이 있습니다.

1. 주소가 없습니다.
1. 금액은 없습니다.
1. 하나는 다른 트랜잭션을 사용하는 2 개의 트랜잭션을 하나의 블록으로 병합하여 모든 중간 정보를 제거 할 수 있습니다.

처음두 가지 속성은 모든 트랜잭션을 서로 구별 할 수 없음을 의미합니다. 거래에 직접 참여하지 않는 한 모든 입력과 출력은 임의의 데이터 조각처럼 보입니다 (말하자면 출력값과 입력값 모두 랜덤한 곡선 위의 점입니다).

또한 블록에 트랜잭션이 없습니다. Grin 블록은 마치 하나의 거대한 트랜잭션처럼 보이고 입력과 출력 사이의 모든 연관성이 사라집니다.

## 확장성(Scalability)

이전 섹션에서 설명한 것처럼 Mimblewimble 트랜잭션과 블록 포맷 때문에 출력이 다른 트랜잭션의 입력에 의해 직접 소비(spent) 될 때 트랜잭션을 합칠 수 있습니다. (예를 들어 - 문맥의 부드러움을 위해 첨가함, 역자 주 )앨리스가 밥에게 돈을 주고 밥이 캐럴에게 돈을 주면 밥은 결코 연관되지 않은것처럼 보이고 실제로 밥의 트랜잭션은 블록체인에서 보이지 않습니다.

더 많은 트랜잭션들을 블록에 밀어 넣으면 대부분의 출력이 다른 입력에 의해 조만간 소비됩니다. 따라서 *모든 소비 출력값을(spent outputs) 안전하게 제거 할 수 있습니다*. 그리고 (bitcoin과 유사한 트랜잭션의 수를 가정 한다면)몇 GB 이하로 전체 블록 체인을 저장하고, 다운로드하고, 완벽하게 검증 할 수 있습니다.

즉, Grin 블록 체인은 트랜잭션 수가 아닌 사용자 수 (사용되지 않은 출력)에 따라 확장됩니다. 그러나 현재 하나 주의하자면 (kernel 이라고 불리는 약 100 바이트의 데이터) 작은 데이터 조각은 각 트랜잭션마다 기다릴 필요가 있습니다. 그러나 이를 최적화하기 위해 노력하고 있습니다.

## 스크립팅(Scripting)

아마도 Mimblewimble은 스크립트(Script)를 지원하지 않는다는 말을 들었을 겁니다. 어떤면에서 이 말은 사실입니다. 그러나 암호화 기법 덕분에 Bitcoin에서 스크립트를 필요로 하는 많은 계약은 Elliptic Curve Cryptography의 속성을 사용하여 Grin으로 작성 할 수 있습니다. 지금까지 아래와 같은 구현을 어떻게 하는지 하는지 알고 있습니다. :

* Multi-signature transactions.
* 아토믹 스왑 (Atomic swap).
* Time-locked transactions and outputs.
* 라이트닝 네트워크 (Lightning Network)

## 블록 생성주기와 블록 보상비율

비트코인(Bitcoin)은 처음에 10분마다 50개의 btc를 제공했고 2100만 비트코인이 유통 될 때까지 4 년마다 블록 보상이 반으로 줄어듭니다. Grin의 블록 보상율은 선형적이며(Linear) 블록 보샹율은 떨어지지 않습니다.( 계속 60GRN/block의 비율을 유지한다는 의미 - 역자 주) Grin의 블록 보상은 현재 60 초마다 블록을 생성하고 블록당 60개의 Grin을 받도록 세팅되어 있습니다. 이는 ​다음과 같은 두가지 이유로 인해 효과가 있습니다. 1) (코인의) 가치저하가 0에 가까우며 2) 매년 무시할 수 없는 양의 동전이 매년 분실되거나 파괴되기 때문입니다 (코인을 계속 사용한다면 코인의 가치저하는 없으며 비트코인처럼 많은 양의 코인이 분실되거나 없어지기 때문에 상기 2가지 이유를 말한것 같음 - 역자 주).

## FAQ

### 잠시만요 뭐라구요? 주소가 없다구요?

네, 주소가 없습니다. Grin의 모든 출력은 유니크 하고 이전 출력과 공통된 데이터가 없습니다. 알려진 주소를 사용하여 돈을 송금하는 대신 두 개 이상의 지갑(주소)이 서로 데이터를 교환하면서 대화식으로 트랜잭션을 만들어야만 합니다. **이 인터렉션에서는 서로 동시에 온라인 상태일 필요는 없습니다**. 실제로 두 프로그램이 프라이빗 하고 안전하게 인터렉션 할 수 있는 방법은 다양합니다. 이 인터렉션은 이메일이나 시그널 (또는 전보 전달 비둘기)을 통해 일어날 수도 있습니다.

### 트랜잭션 정보가 제거된다면 사기는 치거나 코인을 만들어 낼수 있지 않나요?

아니요, Mimblewimble과 Grin의 장점이 돋보이는것이 바로 이런 점 입니다. Confidential transaction은 [동형(homomorphic)암호](https://en.wikipedia.org/wiki/Homomophic_encryption)의 한 형태입니다. 금액을 드러내지 않고 Grin은 모든 거래의 입력값의 합계가 거래의 출력값의 합계 + 수수료를 합한 것과 일치하는지 확인이 가능합니다. 더해서 마이닝으로 만들어진 모든 코인의 합계와 보유하고 있는 총 금액과 비교하여, Grin노드는 코인의 모두 얼마나 공급  되었는지 그 정확성을 확인할 수 있습니다.

### 만약 트랜잭션 릴레이를 받는다면 컷 쓰루 전에는(cut-through) 누구에게 트랜잭션이 속하는지 알 수 없지 않나요?

어떤 거래에 의해서 어떤 출력값을 소비하고 있는지 알 수 있지만 여기서 데이터의 흔적이 멈춥니다. 모든 입력과 출력은 임의의 데이터 조각처럼 보이므로 돈이 전송되었는지, 여전히 같은 사람에게 속해 있는지, 어떤 출력값이 실제로 전송했는지,  어떤것이 변경되었는지 등은 알 수 없습니다. Grin 트랜잭션들은 *식별 할 수있는 정보가 없습니다*.

또한, Grin은 [Dandelion relay](dandelion/dandelion_KR.md)를 활용하여 트랜잭션이 발생한 IP 또는 클라이언트에 대한 추가적인 익명성을 제공하고 트랜잭션을 합칠 수 있습니다.

### 퀀텀 컴퓨타게돈(compute + armageddon) 에 대해서 궁금해요.

모든 Grin 출력값에는 해싱된 퀀텀 세이프 데이터가 포함되어 있습니다. 양자 컴퓨팅이 현실화되더라도, 기존 동전을 해킹하지 못하게 하는 추가 검증을 안전하게 도입 할 수 있습니다.

### 어떻게 이 모든일이 가능한거죠?

이와 관련해서는 [technical introduction](intro_KR.md)문서를 참조하세요.
