# 블록체인의 동기화

최신 노드 상태를 따라 가기 위해 네트워크에 참여할 때 새 노드가 사용하는 여러 가지 방법을 설명합니다.
먼저, 독자에게 다음과 같은 Grin 또는 Mimblewimble의 특성을 먼저 전제 하고 설명하겠습니다.

* 해당 블록 안의 모든 블록 헤더는 체인 안에 사용하지 않는 출력값의 모든 루트해시를 가지고 있습니다.
* 입력 또는 출력은 전체 블록 상태를 무효화하지 않고선 변조되거나 위조 될 수 없습니다

오직 보안 모델에 영향을 줄 수있는 주요 노드 유형과 고급 알고리즘에만 의도적으로 초점을 두고 있습니다. 예를 들어 헤더 우선 같은 몇몇 추가 개선점들을 줄 수 있는 휴리스틱은 유용하지만 이 섹션에서는 언급하지 않을것입니다.

## Full 히스토리 동기화

### 설명

이 모델은 대부분의 메이저 퍼블릭 블록체인 에서 "풀 노드"가 사용하는 모델입니다. 새로운 노드는 제네시스 블록에 대한 사전 정보를 가지고 있습니다. 노드는 네트워크의 다른 피어와 연결되어 피어에게 알려진 최신 블록(호라이즌 블록)에 도달 할 때까지 블록을 요청하기 시작합니다.

보안 모델은 비트 코인과 비슷합니다. 전체 체인, 총 작업, 각 블록의 유효성, 전체 내용 등을 검증 할 수 있습니다. 또한 Mimblewimble 및 전체 UTXO 세트 실행들을 통해 훨씬 더 무결성 검증이 잘 수행될 수 있습니다.

이 모드에서는 저장공간 최적화 또는 대역폭 최적화를 시도하지 않습니다 (예를 들자면 유효성 검증 후 Range proof 가 삭제 될 수 있습니다). 여기서 중요한 것은 기록 아카이브를 제공하고 나중에 확인 및 증명을 하게 하는 것입니다.

### 무엇이 잘못 될 수 있나요?

다른 블록체인과 동일하게 아래와 같은 문제가 생길 수 있습니다.

* 연결된 모든 노드가 부정직하다면 (sybil 공격 또는 그와 비슷한 상태를 말합니다.), 전체 체인 상태에 대해 거짓말을 할 수 있습니다.
* 엄청난 마이닝 파워를 가진 누군가가 전체 블록체인 기록을 다시 쓸 수 있습니다.
* Etc.

## 부분 블록체인 히스토리 동기화

이 모델에서는 보안에 대해서 가능한 한 적게 ​​타협하면서 매우 빠른 동기화를 위힌 최적화를 하려고 합니다. 사실 보안 모델은 다운로드 할 데이터의 양이 훨씬 적음에도 불구하고 풀 노드와 거의 동일합니다.

새로 네트워크에 참여하는 노드는 블록헤드에서 블록 수만큼 떨어진 값인 `Z`로 미리 구성됩니다. ( 원문에서는 horizon `Z` 로 표현되었습니다. 블록헤드 - 블록 = `Z`라고 할 수 있습니다. - 역자 주 ) 예를 들어 `Z = 5000` 이고 헤드가 높이 `H = 23000` 에 있으면, 가장 높은 블록은 가장 긴 체인에서 높이가 `h = 18000`인 블록입니다.

또한 새로운 노드에는 제네시스 블록에 대한 사전 정보가 있습니다. 노드는 다른 피어들과 연결하고 가장 긴 체인의 헤드에 대해 알게 됩니다. 가장 높은 블록의 블록 헤더(horizon block 이라고 원문에 표시되어 있음 - 역자 주 )를 요청하며 다른 피어의 동의가 필요하게 됩니다. 컨센서스가 `h = H - Z`에 이르지 않으면 노드는 `Z`값( horizon Z 라고 원문에 표시되어 있음 - 역자 주 )을 점차 증가시켜 컨센서스가 이루어질 때까지`h`를 뒤로 이동시킵니다. 그런 다음 가장 긴 블록에서의 전체 UTXO 정보를 얻습니다. 이 정보를 통해 다음을 증명할 수 있습니다.

* 모든 블록헤더안에 있는 해당 체인의 전체 난이도
* 예상되는 코인 공급량과 같은 모든 UTXO 실행값의 합.
* 블록헤더에 있는 루트 해시와 매치되는 모든 UTXO의 루트해시

블록의 유효성 검사가 완료되면 피어는 블록 콘텐츠를 `Z`값에서 (from the horizon 이라고 원문에 표시되어 있음 - 역자 주) 헤드까지 다운로드하고 유효성을 검사 할 수 있습니다.

이 알고리즘은 `Z`의 매우 낮은 값 (또는 `Z = 1`인 극단적인 경우에도)에서도 작동합니다. 그러나 어느 블록체인에서도 발생할 수있는 정상적인 포크 때문에 낮은 값이 문제가 될 수 있습니다. 이러한 문제를 방지하고 로컬 검증된 을 늘리려면 최소한 며칠 분량의 `Z`값에서 최대 몇 주간의 `Z`값을 사용하는 것을 권장합니다.

### 무엇이 잘못 될 수 있나요?

이 동기화 모드는 간단하게 설명 할 수 있지만 어떻게 보안을 유지 할 것인가에 대해선 불분명해 보일 수 있습니다.
여기서는 몇몇 가능 할 수 있는 공격 유형과 퇴치 방식 및 기타 가능한 실패 시나리오에 대해 설명합니다.

### 공격자가 가장 긴 블록에서 부터 상태를 위조하려고 할때

이 공격은 노드가 네트워크와 올바르게 동기화되었다고 노드가 인식하도록 하나 실제로 노드가 위조 상태에 있게 합니다.
이에 대해 아래와 같은 여러 전략을 시도 할 수 있습니다.

* 완전히 가짜지만 유효한 최신 블록상태 (horizon state 라고 원문에 표시되 어있음 - 역자 주) 일때 (헤더 및 작업 증명 포함), 최소한 하나의 정직한 피어가 있다고 가정하면, UTXO 세트의 루트 해시와 블록 해시도 다른 피어의 수평 상태와 일치하지 않습니다.
* 유효한 블록 헤더이지만 가짜 UTXO 세트일때, 헤더의 UTXO 세트의 루트 해시는 노드가 수신 한 UTXO 세트 자체에서 계산 한 것과 일치하지 않습니다.
* 가짜 총 난이도를 가진 완전히 유효한 블록으로 노드를 가짜 포크로 유도할 경우, 전체 난이도가 변경되면 블록 해시가 변경되며 어떤 정직한 피어도 해당 해시에 유효한 헤드를 생성하지 않습니다.

### 로컬 UTXO 히스토리 보다 오래된 포크가 발생하려 할때

노드는 최신 블록 높이 (horizon height - 역자 주) 로 설정된 전체 UTXO를 다운로드 했습니다. 만약 수평선 H + delta에 있는 블록에서 포크가 발생하면 UTXO 세트의 유효성을 검사 할 수 없습니다. 이 상황에서 노드는 `Z '= Z + delta`인 새로운 `Z`값 (new horizon - 역자 주) 을 가진 동기화 모드로 돌아 갈 수 밖에 없습니다.

(네트웍에서 받아들여지는) 승리한 포크는 현재의 (우리의) 헤드보다 작업 증명의 총 량이 더 많은 헤드일 뿐이라서 현재의 헤드보다 더 적은 작업 증명인 Z + delta의 다른 포크는 무시 될 수 있습니다. 이 방법을 위해서 모든 블록 헤더에는 해당 블록까지의 총 체인 난이도가 포함됩니다.

#### 체인이 완전히 포크되었을 때

하드포크가 발생하면 네트워크가 분리되고 새로운 노드는 하드포크가 발생했을 때로 자신의 최신 블록 상태(horizon)을 항상 되돌릴 것을 강제합니다. 짧은 기간의 하드포크에는 문제가 되지 않지만 장기 또는 완전한 하드포크에선 문제가 될 수 있습니다. 이러한 상황을 방지하기 위해, 피어는 연결이 될때 하드포크 관련 기능 (피어가 노출하는 피쳐의 bitmask)을 항상 확인해야합니다.

### 몇몇 노드가 가짜 최신블록 (호라이즌 블록)을 지속적으로 줄 때

피어가 만약 h의 헤더에서 컨센서스에 도달 할 수 없으면 서서히 뒤로 돌아갑니다 (블록의 유효성을 확인하기 위해). 뒤로 물러나는 유효성을 확인하는 경우, 사기꾼 피어는 시스템적으로 합의가 이뤄지는것을 막고 가짜 헤더를 보내 줌으로써 모든 새로운 피어가 제네시스 블록까지 (유효성을 확인하기 위해) 뒤로 이동하게 함으로써 항상 풀 노드가 되도록 강제 할 수 있습니다.

상기 얘기한 상태는 유효한 문제이긴 하지만 이래와 같이 몇가지 완화 전략이 있습니다.

* 피어는`Z`값 (Horizon Z)에서 유효한 블록 헤더를 제공해야합니다. 여기에는 작업 증명이 포함됩니다.
* 최신 블록 (Horizon) 주위의 블록 헤더 그룹은 공격 비용을 증가 시키도록 요청받을 수 있습니다.
* 현저하게 낮은 작업 증명을 제공하는 상이한 블록 헤더는 거부 될 수 있습니다.
* 사용자 또는 노드 운영자는 블록 해시를 확인하도록 요청받을 수 있습니다.
* 최후의 수단으로 위의 전략 중 어느 것도 효과적이지 않으면 체크포인트를 사용할 수 있습니다.