# Grin - Build, Configuration, and Running

*Read this in other languages: [Español](build_ES.md), [Korean](build_KR.md), [日本語](build_JP.md), [简体中文](build_ZH-CN.md).*

## Supported Platforms

Longer term, most platforms will likely be supported to some extent.
Grin's programming language `rust` has build targets for most platforms.

What's working so far?

* Linux x86\_64 and macOS [grin + mining + development]
* Not Windows 10 yet [grin kind-of builds. No mining yet. Help wanted!]

## Requirements

* rust: Install using rustup: https://rustup.rs
  * Grin currently does not support a minimum version of Rust, it is recommended to build using the latest version.
  * If rust is already installed, you can update to the latest version by running `rustup update`.
* clang
* ncurses and libs (ncurses, ncursesw5)
* zlib libs (zlib1g-dev or zlib-devel)
* pkg-config
* libssl-dev
* linux-headers (reported needed on Alpine linux)
* llvm

For Debian-based distributions (Debian, Ubuntu, Mint, etc), all in one line (except Rust):

```sh
apt install build-essential cmake git libgit2-dev clang libncurses5-dev libncursesw5-dev zlib1g-dev pkg-config libssl-dev llvm
```

For Mac:

```sh
xcode-select --install
brew install --with-toolchain llvm
brew install pkg-config
brew install openssl
```

## Build steps

```sh
git clone https://github.com/mimblewimble/grin.git
cd grin
cargo build --release
```

Grin can also be built in debug mode (without the `--release` flag, but using the `--debug` or the `--verbose` flag) but this will render fast sync prohibitively slow due to the large overhead of cryptographic operations.

## Build errors

See [Troubleshooting](https://github.com/mimblewimble/docs/wiki/Troubleshooting)

## What was built?

A successful build gets you:

* `target/release/grin` - the main grin binary

All data, configuration and log files created and used by grin are located in the hidden
`~/.grin` directory (under your user home directory) by default. You can modify all configuration
values by editing the file `~/.grin/main/grin-server.toml`.

It is also possible to have grin create its data files in the current directory. To do this, run

```sh
grin server config
```

Which will generate a `grin-server.toml` file in the current directory, pre-configured to use
the current directory for all of its data. Running grin from a directory that contains a
`grin-server.toml` file will use the values in that file instead of the default
`~/.grin/main/grin-server.toml`.

While testing, put the grin binary on your path like this:

```sh
export PATH=`pwd`/target/release:$PATH
```

assuming you are running from the root directory of your Grin installation.

You can then run `grin` directly (try `grin help` for more options).

## Configuration

Grin attempts to run with sensible defaults, and can be further configured via
the `grin-server.toml` file. This file is generated by grin on its first run, and
contains documentation on each available option.

While it's recommended that you perform all grin server configuration via
`grin-server.toml`, it's also possible to supply command line switches to grin that
override any settings in the file.

For help on grin commands and their switches, try:

```sh
grin help
grin server --help
grin client --help
```

## Docker

```sh
docker build -t grin -f etc/Dockerfile .
```
For floonet, use `etc/Dockerfile.floonet` instead

You can bind-mount your grin cache to run inside the container.

```sh
docker run -it -d -v $HOME/.grin:/root/.grin grin
```
If you prefer to use a docker named volume, you can pass `-v dotgrin:/root/.grin` instead.
Using a named volume copies default configurations upon volume creation.

## Cross-platform builds

Rust (cargo) can build grin for many platforms, so in theory running `grin`
as a validating node on your low powered device might be possible.
To cross-compile `grin` on a x86 Linux platform and produce ARM binaries,
say, for a Raspberry Pi.

## Using grin

The wiki page [Wallet User Guide](https://github.com/mimblewimble/docs/wiki/Wallet-User-Guide)
and linked pages have more information on what features we have,
troubleshooting, etc.

## Mining in Grin

Please note that all mining functions for Grin have moved into a separate, standalone package called
[grin-miner](https://github.com/mimblewimble/grin-miner). Once your Grin code node is up and running,
you can start mining by building and running grin-miner against your running Grin node.

For grin-miner to be able to communicate with your grin node, make sure that you have `enable_stratum_server = true`
in your `grin-server.toml` configuration file and you have a wallet listener running (`grin-wallet listen`). 
