// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	[InterfaceVersion("SteamFriends014")]
	public interface ISteamFriends014
	{
		[VTableSlot(0)]
		string GetPersonaName();
		[VTableSlot(1)]
		UInt64 SetPersonaName(string pchPersonaName);
		[VTableSlot(2)]
		EPersonaState GetPersonaState();
		[VTableSlot(3)]
		Int32 GetFriendCount(Int32 iFriendFlags);
		[VTableSlot(4)]
		CSteamID GetFriendByIndex(Int32 iFriend, Int32 iFriendFlags);
		[VTableSlot(5)]
		EFriendRelationship GetFriendRelationship(CSteamID steamIDFriend);
		[VTableSlot(6)]
		EPersonaState GetFriendPersonaState(CSteamID steamIDFriend);
		[VTableSlot(7)]
		string GetFriendPersonaName(CSteamID steamIDFriend);
		[VTableSlot(8)]
		bool GetFriendGamePlayed(CSteamID steamIDFriend, ref FriendGameInfo_t pFriendGameInfo);
		[VTableSlot(9)]
		string GetFriendPersonaNameHistory(CSteamID steamIDFriend, Int32 iPersonaName);
		[VTableSlot(10)]
		string GetPlayerNickname(CSteamID steamIDPlayer);
		[VTableSlot(11)]
		bool HasFriend(CSteamID steamIDFriend, Int32 iFriendFlags);
		[VTableSlot(12)]
		Int32 GetClanCount();
		[VTableSlot(13)]
		CSteamID GetClanByIndex(Int32 iClan);
		[VTableSlot(14)]
		string GetClanName(CSteamID steamIDClan);
		[VTableSlot(15)]
		string GetClanTag(CSteamID steamIDClan);
		[VTableSlot(16)]
		bool GetClanActivityCounts(CSteamID steamID, ref Int32 pnOnline, ref Int32 pnInGame, ref Int32 pnChatting);
		[VTableSlot(17)]
		UInt64 DownloadClanActivityCounts(ref CSteamID groupIDs, Int32 nIds);
		[VTableSlot(18)]
		Int32 GetFriendCountFromSource(CSteamID steamIDSource);
		[VTableSlot(19)]
		CSteamID GetFriendFromSourceByIndex(CSteamID steamIDSource, Int32 iFriend);
		[VTableSlot(20)]
		bool IsUserInSource(CSteamID steamIDUser, CSteamID steamIDSource);
		[VTableSlot(21)]
		void SetInGameVoiceSpeaking(CSteamID steamIDUser, bool bSpeaking);
		[VTableSlot(22)]
		void ActivateGameOverlay(string pchDialog);
		[VTableSlot(23)]
		void ActivateGameOverlayToUser(string pchDialog, CSteamID steamID);
		[VTableSlot(24)]
		void ActivateGameOverlayToWebPage(string pchURL);
		[VTableSlot(25)]
		void ActivateGameOverlayToStore(UInt32 nAppID, EOverlayToStoreFlag eFlag);
		[VTableSlot(26)]
		void SetPlayedWith(CSteamID steamIDUserPlayedWith);
		[VTableSlot(27)]
		void ActivateGameOverlayInviteDialog(CSteamID steamIDLobby);
		[VTableSlot(28)]
		Int32 GetSmallFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(29)]
		Int32 GetMediumFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(30)]
		Int32 GetLargeFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(31)]
		bool RequestUserInformation(CSteamID steamIDUser, bool bRequireNameOnly);
		[VTableSlot(32)]
		UInt64 RequestClanOfficerList(CSteamID steamIDClan);
		[VTableSlot(33)]
		CSteamID GetClanOwner(CSteamID steamIDClan);
		[VTableSlot(34)]
		Int32 GetClanOfficerCount(CSteamID steamIDClan);
		[VTableSlot(35)]
		CSteamID GetClanOfficerByIndex(CSteamID steamIDClan, Int32 iOfficer);
		[VTableSlot(36)]
		EUserRestriction GetUserRestrictions();
		[VTableSlot(37)]
		bool SetRichPresence(string pchKey, string pchValue);
		[VTableSlot(38)]
		void ClearRichPresence();
		[VTableSlot(39)]
		string GetFriendRichPresence(CSteamID steamIDFriend, string pchKey);
		[VTableSlot(40)]
		Int32 GetFriendRichPresenceKeyCount(CSteamID steamIDFriend);
		[VTableSlot(41)]
		string GetFriendRichPresenceKeyByIndex(CSteamID steamIDFriend, Int32 iKey);
		[VTableSlot(42)]
		void RequestFriendRichPresence(CSteamID steamIDFriend);
		[VTableSlot(43)]
		bool InviteUserToGame(CSteamID steamIDFriend, string pchConnectString);
		[VTableSlot(44)]
		Int32 GetCoplayFriendCount();
		[VTableSlot(45)]
		CSteamID GetCoplayFriend(Int32 iCoplayFriend);
		[VTableSlot(46)]
		Int32 GetFriendCoplayTime(CSteamID steamIDFriend);
		[VTableSlot(47)]
		UInt32 GetFriendCoplayGame(CSteamID steamIDFriend);
		[VTableSlot(48)]
		UInt64 JoinClanChatRoom(CSteamID steamIDClan);
		[VTableSlot(49)]
		bool LeaveClanChatRoom(CSteamID steamIDClan);
		[VTableSlot(50)]
		Int32 GetClanChatMemberCount(CSteamID steamIDClan);
		[VTableSlot(51)]
		CSteamID GetChatMemberByIndex(CSteamID steamIDClan, Int32 iUser);
		[VTableSlot(52)]
		bool SendClanChatMessage(CSteamID steamIDClanChat, string pchText);
		[VTableSlot(53)]
		Int32 GetClanChatMessage(CSteamID steamIDClanChat, Int32 iMessage, Byte[] prgchText, Int32 cchTextMax, ref EChatEntryType peChatEntryType, ref CSteamID pSteamIDChatter);
		[VTableSlot(54)]
		bool IsClanChatAdmin(CSteamID steamIDClanChat, CSteamID steamIDUser);
		[VTableSlot(55)]
		bool IsClanChatWindowOpenInSteam(CSteamID steamIDClanChat);
		[VTableSlot(56)]
		bool OpenClanChatWindowInSteam(CSteamID steamIDClanChat);
		[VTableSlot(57)]
		bool CloseClanChatWindowInSteam(CSteamID steamIDClanChat);
		[VTableSlot(58)]
		bool SetListenForFriendsMessages(bool bInterceptEnabled);
		[VTableSlot(59)]
		bool ReplyToFriendMessage(CSteamID steamIDFriend, string pchMsgToSend);
		[VTableSlot(60)]
		Int32 GetFriendMessage(CSteamID steamIDFriend, Int32 iMessageID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType);
		[VTableSlot(61)]
		UInt64 GetFollowerCount(CSteamID steamID);
		[VTableSlot(62)]
		UInt64 IsFollowing(CSteamID steamID);
		[VTableSlot(63)]
		UInt64 EnumerateFollowingList(UInt32 unStartIndex);
	};
}
