// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	[InterfaceVersion("CLIENTUTILS_INTERFACE_VERSION001")]
	public interface IClientUtils
	{
		[VTableSlot(0)]
		string GetInstallPath();
		[VTableSlot(1)]
		string GetUserBaseFolderInstallImage();
		[VTableSlot(2)]
		string GetManagedContentRoot();
		[VTableSlot(3)]
		UInt32 GetSecondsSinceAppActive();
		[VTableSlot(4)]
		UInt32 GetSecondsSinceComputerActive();
		[VTableSlot(5)]
		void SetComputerActive();
		[VTableSlot(6)]
		EUniverse GetConnectedUniverse();
		[VTableSlot(7)]
		UInt32 GetServerRealTime();
		[VTableSlot(8)]
		string GetIPCountry();
		[VTableSlot(9)]
		bool GetImageSize(Int32 iImage, ref UInt32 pnWidth, ref UInt32 pnHeight);
		[VTableSlot(10)]
		bool GetImageRGBA(Int32 iImage, Byte[] pubDest, Int32 nDestBufferSize);
		[VTableSlot(11)]
		bool GetCSERIPPort(ref UInt32 unIP, ref UInt16 usPort);
		[VTableSlot(12)]
		UInt32 GetNumRunningApps();
		[VTableSlot(13)]
		Byte GetCurrentBatteryPower();
		[VTableSlot(14)]
		void SetOfflineMode(bool bOffline);
		[VTableSlot(15)]
		bool GetOfflineMode();
		[VTableSlot(16)]
		UInt32 SetAppIDForCurrentPipe(UInt32 nAppID, bool bTrackProcess);
		[VTableSlot(17)]
		UInt32 GetAppID();
		[VTableSlot(18)]
		void SetAPIDebuggingActive(bool bActive, bool bVerbose);
		[VTableSlot(19)]
		bool IsAPICallCompleted(UInt64 hSteamAPICall, ref bool pbFailed);
		[VTableSlot(20)]
		ESteamAPICallFailure GetAPICallFailureReason(UInt64 hSteamAPICall);
		[VTableSlot(21)]
		bool GetAPICallResult(UInt64 hSteamAPICall, Byte[] pCallback, Int32 cubCallback, Int32 iCallbackExpected, ref bool pbFailed);
		[VTableSlot(22)]
		bool SignalAppsToShutDown();
		[VTableSlot(23)]
		bool TerminateAllAppsMultiStep(UInt32 uUnk);
		[VTableSlot(24)]
		UInt32 GetCellID();
		[VTableSlot(25)]
		bool BIsGlobalInstance();
		[VTableSlot(26)]
		UInt64 CheckFileSignature(string szFileName);
		[VTableSlot(27)]
		UInt64 GetBuildID();
		[VTableSlot(28)]
		void SetCurrentUIMode(EUIMode eUIMode);
		[VTableSlot(29)]
		void SetLauncherType(ELauncherType eLauncherType);
		[VTableSlot(30)]
		ELauncherType GetLauncherType();
		[VTableSlot(31)]
		bool ShowGamepadTextInput(EGamepadTextInputMode eInputMode, EGamepadTextInputLineMode eInputLineMode, string szText, UInt32 uMaxLength, string szUnk);
		[VTableSlot(32)]
		UInt32 GetEnteredGamepadTextLength();
		[VTableSlot(33)]
		bool GetEnteredGamepadTextInput(StringBuilder pchValue, UInt32 cchValueMax);
		[VTableSlot(34)]
		void GamepadTextInputClosed(Int32 hSteamPipe, bool arg1, string arg2);
		[VTableSlot(35)]
		void SetSpew(ESpewGroup eSpewGroup, Int32 iSpewLevel, Int32 iLogLevel);
		[VTableSlot(36)]
		bool BDownloadsDisabled();
		[VTableSlot(37)]
		void SetFocusedWindow(EWindowType eWindowType, CGameID gameID, UInt64 ulUnk);
		[VTableSlot(38)]
		string GetSteamUILanguage();
		[VTableSlot(39)]
		UInt64 CheckSteamReachable();
		[VTableSlot(40)]
		void SetLastGameLaunchMethod(EGameLaunchMethod eGameLaunchMethod);
		[VTableSlot(41)]
		bool IsSteamOS();
		[VTableSlot(42)]
		void SetVideoAdapterInfo(Int32 arg0, Int32 arg1, Int32 arg2, Int32 arg3, Int32 arg4);
		[VTableSlot(43)]
		void SetControllerOVerrideMode(EWindowType eWindowType, CGameID gameID, string szUnk);
		[VTableSlot(44)]
		void SetOverlayWindowFocusForPipe(bool arg0, bool arg1, CGameID gameID);
		[VTableSlot(45)]
		CGameID GetGameOverlayUIInstanceFocusGameID(ref bool pbUnk);
		[VTableSlot(46)]
		bool SetControllerConfigFileForAppID(UInt32 unAppID, string pszControllerConfigFile);
		[VTableSlot(47)]
		bool GetControllerConfigFileForAppID(UInt32 unAppID, string pszControllerConfigFile, UInt32 cubControllerConfigFile);
		[VTableSlot(48)]
		bool IsSteamRunningInVR();
	};
}
