// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	[InterfaceVersion("SteamGameServer011")]
	public interface ISteamGameServer011
	{
		[VTableSlot(0)]
		bool InitGameServer(UInt32 unGameIP, UInt16 unGamePort, UInt16 usQueryPort, UInt32 unServerFlags, UInt32 nAppID, string pchVersion);
		[VTableSlot(1)]
		void SetProduct(string pchProductName);
		[VTableSlot(2)]
		void SetGameDescription(string pchGameDescription);
		[VTableSlot(3)]
		void SetModDir(string pchModDir);
		[VTableSlot(4)]
		void SetDedicatedServer(bool bDedicatedServer);
		[VTableSlot(5)]
		void LogOn(string pszAccountName, string pszPassword);
		[VTableSlot(6)]
		void LogOnAnonymous();
		[VTableSlot(7)]
		void LogOff();
		[VTableSlot(8)]
		bool BLoggedOn();
		[VTableSlot(9)]
		bool BSecure();
		[VTableSlot(10)]
		CSteamID GetSteamID();
		[VTableSlot(11)]
		bool WasRestartRequested();
		[VTableSlot(12)]
		void SetMaxPlayerCount(Int32 cPlayersMax);
		[VTableSlot(13)]
		void SetBotPlayerCount(Int32 cBotPlayers);
		[VTableSlot(14)]
		void SetServerName(string pszServerName);
		[VTableSlot(15)]
		void SetMapName(string pszMapName);
		[VTableSlot(16)]
		void SetPasswordProtected(bool bPasswordProtected);
		[VTableSlot(17)]
		void SetSpectatorPort(UInt16 unSpectatorPort);
		[VTableSlot(18)]
		void SetSpectatorServerName(string pszSpectatorServerName);
		[VTableSlot(19)]
		void ClearAllKeyValues();
		[VTableSlot(20)]
		void SetKeyValue(string pKey, string pValue);
		[VTableSlot(21)]
		void SetGameTags(string pchGameTags);
		[VTableSlot(22)]
		void SetGameData(string pchGameData);
		[VTableSlot(23)]
		void SetRegion(string pchRegionName);
		[VTableSlot(24)]
		Int32 SendUserConnectAndAuthenticate(UInt32 unIPClient, Byte[] pvAuthBlob, UInt32 cubAuthBlobSize, ref CSteamID pSteamIDUser);
		[VTableSlot(25)]
		CSteamID CreateUnauthenticatedUserConnection();
		[VTableSlot(26)]
		void SendUserDisconnect(CSteamID steamIDUser);
		[VTableSlot(27)]
		bool BUpdateUserData(CSteamID steamIDUser, string pchPlayerName, UInt32 uScore);
		[VTableSlot(28)]
		UInt32 GetAuthSessionTicket(Byte[] pTicket, Int32 cbMaxTicket, ref UInt32 pcbTicket);
		[VTableSlot(29)]
		EBeginAuthSessionResult BeginAuthSession(Byte[] pAuthTicket, Int32 cbAuthTicket, CSteamID steamID);
		[VTableSlot(30)]
		void EndAuthSession(CSteamID steamID);
		[VTableSlot(31)]
		void CancelAuthTicket(UInt32 hAuthTicket);
		[VTableSlot(32)]
		EUserHasLicenseForAppResult UserHasLicenseForApp(CSteamID steamID, UInt32 appID);
		[VTableSlot(33)]
		bool RequestUserGroupStatus(CSteamID steamIDUser, CSteamID steamIDGroup);
		[VTableSlot(34)]
		void GetGameplayStats();
		[VTableSlot(35)]
		UInt64 GetServerReputation();
		[VTableSlot(36)]
		UInt32 GetPublicIP();
		[VTableSlot(37)]
		bool HandleIncomingPacket(Byte[] pData, Int32 cbData, UInt32 srcIP, UInt16 srcPort);
		[VTableSlot(38)]
		Int32 GetNextOutgoingPacket(Byte[] pOut, Int32 cbMaxOut, ref UInt32 pNetAdr, ref UInt16 pPort);
		[VTableSlot(39)]
		void EnableHeartbeats(bool bActive);
		[VTableSlot(40)]
		void SetHeartbeatInterval(Int32 iHeartbeatInterval);
		[VTableSlot(41)]
		void ForceHeartbeat();
		[VTableSlot(42)]
		UInt64 AssociateWithClan(CSteamID clanID);
		[VTableSlot(43)]
		UInt64 ComputeNewPlayerCompatibility(CSteamID steamID);
	};
}
