// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	[InterfaceVersion("SteamFriends015")]
	public interface ISteamFriends015
	{
		[VTableSlot(0)]
		string GetPersonaName();
		[VTableSlot(1)]
		UInt64 SetPersonaName(string pchPersonaName);
		[VTableSlot(2)]
		EPersonaState GetPersonaState();
		[VTableSlot(3)]
		Int32 GetFriendCount(Int32 iFriendFlags);
		[VTableSlot(4)]
		CSteamID GetFriendByIndex(Int32 iFriend, Int32 iFriendFlags);
		[VTableSlot(5)]
		EFriendRelationship GetFriendRelationship(CSteamID steamIDFriend);
		[VTableSlot(6)]
		EPersonaState GetFriendPersonaState(CSteamID steamIDFriend);
		[VTableSlot(7)]
		string GetFriendPersonaName(CSteamID steamIDFriend);
		[VTableSlot(8)]
		bool GetFriendGamePlayed(CSteamID steamID, ref FriendGameInfo_t pGamePlayInfo);
		[VTableSlot(9)]
		string GetFriendPersonaNameHistory(CSteamID steamIDFriend, Int32 iPersonaName);
		[VTableSlot(10)]
		Int32 GetFriendSteamLevel(CSteamID steamIDFriend);
		[VTableSlot(11)]
		string GetPlayerNickname(CSteamID steamIDPlayer);
		[VTableSlot(12)]
		Int16 GetFriendsGroupCount();
		[VTableSlot(13)]
		Int16 GetFriendsGroupIDByIndex(Int32 arg0);
		[VTableSlot(14)]
		string GetFriendsGroupName(Int16 arg0);
		[VTableSlot(15)]
		Int32 GetFriendsGroupMembersCount(Int16 arg0);
		[VTableSlot(16)]
		Int32 GetFriendsGroupMembersList(Int16 arg0, ref CSteamID arg1, Int32 arg2);
		[VTableSlot(17)]
		bool HasFriend(CSteamID steamIDFriend, Int32 iFriendFlags);
		[VTableSlot(18)]
		Int32 GetClanCount();
		[VTableSlot(19)]
		CSteamID GetClanByIndex(Int32 iClan);
		[VTableSlot(20)]
		string GetClanName(CSteamID steamIDClan);
		[VTableSlot(21)]
		string GetClanTag(CSteamID steamIDClan);
		[VTableSlot(22)]
		bool GetClanActivityCounts(CSteamID steamID, ref Int32 pnOnline, ref Int32 pnInGame, ref Int32 pnChatting);
		[VTableSlot(23)]
		UInt64 DownloadClanActivityCounts(ref CSteamID groupIDs, Int32 nIds);
		[VTableSlot(24)]
		Int32 GetFriendCountFromSource(CSteamID steamIDSource);
		[VTableSlot(25)]
		CSteamID GetFriendFromSourceByIndex(CSteamID steamIDSource, Int32 iFriend);
		[VTableSlot(26)]
		bool IsUserInSource(CSteamID steamIDUser, CSteamID steamIDSource);
		[VTableSlot(27)]
		void SetInGameVoiceSpeaking(CSteamID steamIDUser, bool bSpeaking);
		[VTableSlot(28)]
		void ActivateGameOverlay(string pchDialog);
		[VTableSlot(29)]
		void ActivateGameOverlayToUser(string pchDialog, CSteamID steamID);
		[VTableSlot(30)]
		void ActivateGameOverlayToWebPage(string pchURL);
		[VTableSlot(31)]
		void ActivateGameOverlayToStore(UInt32 nAppID, EOverlayToStoreFlag eFlag);
		[VTableSlot(32)]
		void SetPlayedWith(CSteamID steamIDUserPlayedWith);
		[VTableSlot(33)]
		void ActivateGameOverlayInviteDialog(CSteamID steamIDLobby);
		[VTableSlot(34)]
		Int32 GetSmallFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(35)]
		Int32 GetMediumFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(36)]
		Int32 GetLargeFriendAvatar(CSteamID steamIDFriend);
		[VTableSlot(37)]
		bool RequestUserInformation(CSteamID steamIDUser, bool bRequireNameOnly);
		[VTableSlot(38)]
		UInt64 RequestClanOfficerList(CSteamID steamIDClan);
		[VTableSlot(39)]
		CSteamID GetClanOwner(CSteamID steamIDClan);
		[VTableSlot(40)]
		Int32 GetClanOfficerCount(CSteamID steamIDClan);
		[VTableSlot(41)]
		CSteamID GetClanOfficerByIndex(CSteamID steamIDClan, Int32 iOfficer);
		[VTableSlot(42)]
		EUserRestriction GetUserRestrictions();
		[VTableSlot(43)]
		bool SetRichPresence(string pchKey, string pchValue);
		[VTableSlot(44)]
		void ClearRichPresence();
		[VTableSlot(45)]
		string GetFriendRichPresence(CSteamID steamIDFriend, string pchKey);
		[VTableSlot(46)]
		Int32 GetFriendRichPresenceKeyCount(CSteamID steamIDFriend);
		[VTableSlot(47)]
		string GetFriendRichPresenceKeyByIndex(CSteamID steamIDFriend, Int32 iKey);
		[VTableSlot(48)]
		void RequestFriendRichPresence(CSteamID steamIDFriend);
		[VTableSlot(49)]
		bool InviteUserToGame(CSteamID steamIDFriend, string pchConnectString);
		[VTableSlot(50)]
		Int32 GetCoplayFriendCount();
		[VTableSlot(51)]
		CSteamID GetCoplayFriend(Int32 iCoplayFriend);
		[VTableSlot(52)]
		Int32 GetFriendCoplayTime(CSteamID steamIDFriend);
		[VTableSlot(53)]
		UInt32 GetFriendCoplayGame(CSteamID steamIDFriend);
		[VTableSlot(54)]
		UInt64 JoinClanChatRoom(CSteamID steamIDClan);
		[VTableSlot(55)]
		bool LeaveClanChatRoom(CSteamID steamIDClan);
		[VTableSlot(56)]
		Int32 GetClanChatMemberCount(CSteamID steamIDClan);
		[VTableSlot(57)]
		CSteamID GetChatMemberByIndex(CSteamID steamIDClan, Int32 iUser);
		[VTableSlot(58)]
		bool SendClanChatMessage(CSteamID steamIDClanChat, string pchText);
		[VTableSlot(59)]
		Int32 GetClanChatMessage(CSteamID steamIDClanChat, Int32 iMessage, Byte[] prgchText, Int32 cchTextMax, ref EChatEntryType peChatEntryType, ref CSteamID pSteamIDChatter);
		[VTableSlot(60)]
		bool IsClanChatAdmin(CSteamID steamIDClanChat, CSteamID steamIDUser);
		[VTableSlot(61)]
		bool IsClanChatWindowOpenInSteam(CSteamID steamIDClanChat);
		[VTableSlot(62)]
		bool OpenClanChatWindowInSteam(CSteamID steamIDClanChat);
		[VTableSlot(63)]
		bool CloseClanChatWindowInSteam(CSteamID steamIDClanChat);
		[VTableSlot(64)]
		bool SetListenForFriendsMessages(bool bInterceptEnabled);
		[VTableSlot(65)]
		bool ReplyToFriendMessage(CSteamID steamIDFriend, string pchMsgToSend);
		[VTableSlot(66)]
		Int32 GetFriendMessage(CSteamID steamIDFriend, Int32 iMessageID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType);
		[VTableSlot(67)]
		UInt64 GetFollowerCount(CSteamID steamID);
		[VTableSlot(68)]
		UInt64 IsFollowing(CSteamID steamID);
		[VTableSlot(69)]
		UInt64 EnumerateFollowingList(UInt32 unStartIndex);
	};
}
