// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	[InterfaceVersion("CLIENTSCREENSHOTS_INTERFACE_VERSION001")]
	public interface IClientScreenshots
	{
		[VTableSlot(0)]
		string GetShortcutDisplayName(CGameID gameID);
		[VTableSlot(1)]
		void SetShortcutDisplayName(CGameID arg0, string cszName);
		[VTableSlot(2)]
		UInt32 WriteScreenshot(CGameID gameID, Byte[] pubRGBData, UInt32 uRGBDataSize, Int32 iWidth, Int32 iHeight);
		[VTableSlot(3)]
		UInt32 AddScreenshotToLibrary(CGameID gameID, string cszScreenshotPath, string cszThumbnailPath, Int32 iWidth, Int32 iHeight);
		[VTableSlot(4)]
		void TriggerScreenshot(CGameID gameID);
		[VTableSlot(5)]
		void RequestScreenshotFromGame(UInt32 nAppId);
		[VTableSlot(6)]
		bool SetLocation(CGameID gameID, UInt32 hScreenshot, string cszLocation);
		[VTableSlot(7)]
		bool TagUser(CGameID gameID, UInt32 hScreenshot, CSteamID userID);
		[VTableSlot(8)]
		bool TagPublishedFile(CGameID gameID, UInt32 hScreenshot, UInt64 unPublishedFileId);
		[VTableSlot(9)]
		bool ResolvePath(CGameID gameID, UInt32 hScreenshot, bool bUnk, StringBuilder szResolvedPath, UInt32 cubResolvedPath);
		[VTableSlot(10)]
		UInt32 GetSizeOnDisk(CGameID gameID, UInt32 hScreenshot);
		[VTableSlot(11)]
		UInt32 GetSizeInCloud(CGameID gameID, UInt32 hScreenshot);
		[VTableSlot(12)]
		bool IsPersisted(CGameID gameID, UInt32 hScreenshot);
		[VTableSlot(13)]
		Int32 GetNumGamesWithLocalScreenshots();
		[VTableSlot(14)]
		CGameID GetGameWithLocalScreenshots(Int32 iGameIndex);
		[VTableSlot(15)]
		Int32 GetLocalScreenshotCount(CGameID gameID);
		[VTableSlot(16)]
		bool GetLocalScreenshot(CGameID gameID, Int32 iScreenshotIndex, ref UInt32 phScreenshot, ref Int32 piWidth, ref Int32 piHeight, ref UInt32 puTimestamp, ref EUCMFilePrivacyState pePrivacy, ref UInt64 pullFileID, StringBuilder pchCaption, UInt32 cubCaption, ref bool pbSpoiler);
		[VTableSlot(17)]
		bool SetLocalScreenshotCaption(CGameID gameID, UInt32 hScreenshot, string cszCaption);
		[VTableSlot(18)]
		bool SetLocalScreenshotPrivacy(CGameID gameID, UInt32 hScreenshot, EUCMFilePrivacyState ePrivacy);
		[VTableSlot(19)]
		bool SetLocalScreenshotSpoiler(CGameID arg0, UInt32 hScreenshot, bool bSpoiler);
		[VTableSlot(20)]
		bool StartBatch(CGameID gameID);
		[VTableSlot(21)]
		bool AddToBatch(UInt32 hScreenshot);
		[VTableSlot(22)]
		UInt64 UploadBatch(EUCMFilePrivacyState ePrivacy);
		[VTableSlot(23)]
		UInt64 DeleteBatch(bool bDeleteFromCloud);
		[VTableSlot(24)]
		bool CancelBatch();
		[VTableSlot(25)]
		void RecoverOldScreenshots();
		[VTableSlot(26)]
		UInt32 GetTaggedUserCount(CGameID gameID, UInt32 hScreenshot);
		[VTableSlot(27)]
		CSteamID GetTaggedUser(CGameID gameID, UInt32 hScreenshot, Int32 iUserIndex);
		[VTableSlot(28)]
		bool GetLocation(CGameID gameID, UInt32 hScreenshot, StringBuilder pchLocation, UInt32 cubLocation);
		[VTableSlot(29)]
		UInt32 GetTaggedPublishedFileCount(CGameID gameID, UInt32 hScreenshot);
		[VTableSlot(30)]
		UInt64 GetTaggedPublishedFile(CGameID gameID, UInt32 hScreenshot, Int32 iPublishedFileIndex);
	};
}
