// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	[InterfaceVersion("CLIENTUSERSTATS_INTERFACE_VERSION002")]
	public interface IClientUserStats
	{
		[VTableSlot(0)]
		UInt32 GetNumStats(CGameID nGameID);
		[VTableSlot(1)]
		string GetStatName(CGameID nGameID, UInt32 iStat);
		[VTableSlot(2)]
		ESteamUserStatType GetStatType(CGameID nGameID, string pchName);
		[VTableSlot(3)]
		UInt32 GetNumAchievements(CGameID nGameID);
		[VTableSlot(4)]
		string GetAchievementName(CGameID nGameID, UInt32 iAchievement);
		[VTableSlot(5)]
		bool RequestCurrentStats(CGameID nGameID);
		[VTableSlot(6)]
		bool GetStat(CGameID nGameID, string pchName, ref float pData);
		[VTableSlot(7)]
		bool GetStat(CGameID nGameID, string pchName, ref Int32 pData);
		[VTableSlot(8)]
		bool SetStat(CGameID nGameID, string pchName, float fData);
		[VTableSlot(9)]
		bool SetStat(CGameID nGameID, string pchName, Int32 nData);
		[VTableSlot(10)]
		bool UpdateAvgRateStat(CGameID nGameID, string pchName, float flCountThisSession, double dSessionLength);
		[VTableSlot(11)]
		bool GetAchievement(CGameID nGameID, string pchName, ref bool pbAchieved, ref UInt32 punUnlockTime);
		[VTableSlot(12)]
		bool SetAchievement(CGameID nGameID, string pchName);
		[VTableSlot(13)]
		bool ClearAchievement(CGameID nGameID, string pchName);
		[VTableSlot(14)]
		bool StoreStats(CGameID nGameID);
		[VTableSlot(15)]
		Int32 GetAchievementIcon(CGameID nGameID, string pchName, EGetAchievementIcon arg2);
		[VTableSlot(16)]
		string GetAchievementDisplayAttribute(CGameID nGameID, string pchName, string pchKey, bool bUseGameLanguage);
		[VTableSlot(17)]
		bool IndicateAchievementProgress(CGameID nGameID, string pchName, UInt32 nCurProgress, UInt32 nMaxProgress);
		[VTableSlot(18)]
		void SetMaxStatsLoaded(UInt32 uMax);
		[VTableSlot(19)]
		UInt64 RequestUserStats(CSteamID steamIDUser, CGameID nGameID);
		[VTableSlot(20)]
		bool GetUserStat(CSteamID steamIDUser, CGameID nGameID, string pchName, ref float pData);
		[VTableSlot(21)]
		bool GetUserStat(CSteamID steamIDUser, CGameID nGameID, string pchName, ref Int32 pData);
		[VTableSlot(22)]
		bool GetUserAchievement(CSteamID steamIDUser, CGameID nGameID, string pchName, ref bool pbAchieved, ref UInt32 punUnlockTime);
		[VTableSlot(23)]
		bool ResetAllStats(CGameID nGameID, bool bAchievementsToo);
		[VTableSlot(24)]
		UInt64 FindOrCreateLeaderboard(string pchLeaderboardName, ELeaderboardSortMethod eLeaderboardSortMethod, ELeaderboardDisplayType eLeaderboardDisplayType);
		[VTableSlot(25)]
		UInt64 FindLeaderboard(string pchLeaderboardName);
		[VTableSlot(26)]
		string GetLeaderboardName(UInt64 hSteamLeaderboard);
		[VTableSlot(27)]
		Int32 GetLeaderboardEntryCount(UInt64 hSteamLeaderboard);
		[VTableSlot(28)]
		ELeaderboardSortMethod GetLeaderboardSortMethod(UInt64 hSteamLeaderboard);
		[VTableSlot(29)]
		ELeaderboardDisplayType GetLeaderboardDisplayType(UInt64 hSteamLeaderboard);
		[VTableSlot(30)]
		UInt64 DownloadLeaderboardEntries(UInt64 hSteamLeaderboard, ELeaderboardDataRequest eLeaderboardDataRequest, Int32 nRangeStart, Int32 nRangeEnd);
		[VTableSlot(31)]
		UInt64 DownloadLeaderboardEntriesForUsers(UInt64 hSteamLeaderboard, ref CSteamID prgUsers, Int32 cUsers);
		[VTableSlot(32)]
		bool GetDownloadedLeaderboardEntry(UInt64 hSteamLeaderboardEntries, Int32 index, ref LeaderboardEntry002_t pLeaderboardEntry, ref Int32 pDetails, Int32 cDetailsMax);
		[VTableSlot(33)]
		UInt64 AttachLeaderboardUGC(UInt64 hSteamLeaderboard, UInt64 hUGC);
		[VTableSlot(34)]
		UInt64 UploadLeaderboardScore(UInt64 hSteamLeaderboard, ELeaderboardUploadScoreMethod eLeaderboardUploadScoreMethod, Int32 nScore, ref Int32 pScoreDetails, Int32 cScoreDetailsCount);
		[VTableSlot(35)]
		UInt64 GetNumberOfCurrentPlayers();
		[VTableSlot(36)]
		UInt32 GetNumAchievedAchievements(CGameID nGameID);
		[VTableSlot(37)]
		string GetLastAchievementUnlocked(CGameID nGameID);
		[VTableSlot(38)]
		UInt64 RequestGlobalAchievementPercentages(CGameID nGameID);
		[VTableSlot(39)]
		Int32 GetMostAchievedAchievementInfo(CGameID nGameID, StringBuilder pchName, UInt32 unNameBufLen, ref float pflPercent, ref bool pbAchieved);
		[VTableSlot(40)]
		Int32 GetNextMostAchievedAchievementInfo(CGameID nGameID, Int32 iIteratorPrevious, StringBuilder pchName, UInt32 unNameBufLen, ref float pflPercent, ref bool pbAchieved);
		[VTableSlot(41)]
		bool GetAchievementAchievedPercent(CGameID nGameID, string pchName, ref float pflPercent);
		[VTableSlot(42)]
		UInt64 RequestGlobalStats(CGameID nGameID, Int32 nHistoryDays);
		[VTableSlot(43)]
		bool GetGlobalStat(CGameID nGameID, string pchName, ref double pData);
		[VTableSlot(44)]
		bool GetGlobalStat(CGameID nGameID, string pchName, ref Int64 pData);
		[VTableSlot(45)]
		Int32 GetGlobalStatHistory(CGameID nGameID, string pchName, ref double pData, UInt32 cubData);
		[VTableSlot(46)]
		Int32 GetGlobalStatHistory(CGameID nGameID, string pchName, ref Int64 pData, UInt32 cubData);
	};
}
