// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;
using Steam4NET.Attributes;

namespace Steam4NET
{

	public enum EGameConnectSteamResponse : int
	{
		k_EGameConnectSteamResponse_WaitingForResponse = 0,
		k_EGameConnectSteamResponse_AuthorizedToPlay = 1,
		k_EGameConnectSteamResponse_Denied = 2,
		k_EGameConnectSteamResponse_ExceededReasonableTime_StillWaiting = 3,
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	public struct ConnectedUserInfo_t
	{
		public Int32 m_cubConnectedUserInfo;
		public Int32 m_nCountOfGuestUsers;
		public SteamID_t m_SteamID;
		public UInt32 m_unIPPublic;
		public UInt32 m_nFrags;
		public double m_flConnectTime;
		public EGameConnectSteamResponse m_eGameConnectSteamResponse;
		public EDenyReason m_eDenyReason;
	};
	
	[InterfaceVersion("CLIENTGAMESERVER_INTERFACE_VERSION001")]
	public interface IClientGameServer
	{
		[VTableSlot(0)]
		Int32 GetHSteamUser();
		[VTableSlot(1)]
		bool InitGameServer(UInt32 unGameIP, UInt16 unGamePort, UInt16 usQueryPort, UInt32 unServerFlags, UInt32 nAppID, string pchVersion);
		[VTableSlot(2)]
		void SetProduct(string pchProductName);
		[VTableSlot(3)]
		void SetGameDescription(string pchGameDescription);
		[VTableSlot(4)]
		void SetModDir(string pchModDir);
		[VTableSlot(5)]
		void SetDedicatedServer(bool bDedicatedServer);
		[VTableSlot(6)]
		void LogOn(string pchToken);
		[VTableSlot(7)]
		void LogOnAnonymous();
		[VTableSlot(8)]
		void LogOff();
		[VTableSlot(9)]
		CSteamID GetSteamID();
		[VTableSlot(10)]
		bool BLoggedOn();
		[VTableSlot(11)]
		bool BSecure();
		[VTableSlot(12)]
		bool WasRestartRequested();
		[VTableSlot(13)]
		void SetMaxPlayerCount(Int32 cPlayersMax);
		[VTableSlot(14)]
		void SetBotPlayerCount(Int32 cBotPlayers);
		[VTableSlot(15)]
		void SetServerName(string pchServerName);
		[VTableSlot(16)]
		void SetMapName(string pchMapName);
		[VTableSlot(17)]
		void SetPasswordProtected(bool bPasswordProtected);
		[VTableSlot(18)]
		void SetSpectatorPort(UInt16 unSpectatorPort);
		[VTableSlot(19)]
		void SetSpectatorServerName(string pchSpectatorServerName);
		[VTableSlot(20)]
		void ClearAllKeyValues();
		[VTableSlot(21)]
		void SetKeyValue(string pKey, string pValue);
		[VTableSlot(22)]
		void SetGameTags(string pchGameTags);
		[VTableSlot(23)]
		void SetGameData(string pchGameData);
		[VTableSlot(24)]
		void SetRegion(string pchRegionName);
		[VTableSlot(25)]
		EUserConnect SendUserConnectAndAuthenticate(UInt32 unIPClient, Byte[] pvAuthBlob, UInt32 cubAuthBlobSize, ref CSteamID pSteamIDUser);
		[VTableSlot(26)]
		CSteamID CreateUnauthenticatedUserConnection();
		[VTableSlot(27)]
		void SendUserDisconnect(CSteamID steamIDUser);
		[VTableSlot(28)]
		bool BUpdateUserData(CSteamID steamIDUser, string pchPlayerName, UInt32 uScore);
		[VTableSlot(29)]
		UInt32 GetAuthSessionTicket(Byte[] pTicket, Int32 cbMaxTicket, ref UInt32 pcbTicket);
		[VTableSlot(30)]
		EBeginAuthSessionResult BeginAuthSession(Byte[] pAuthTicket, Int32 cbAuthTicket, CSteamID steamID);
		[VTableSlot(31)]
		void EndAuthSession(CSteamID steamID);
		[VTableSlot(32)]
		void CancelAuthTicket(UInt32 hAuthTicket);
		[VTableSlot(33)]
		EUserHasLicenseForAppResult IsUserSubscribedAppInTicket(CSteamID steamID, UInt32 appID);
		[VTableSlot(34)]
		bool RequestUserGroupStatus(CSteamID steamIDUser, CSteamID steamIDGroup);
		[VTableSlot(35)]
		void GetGameplayStats();
		[VTableSlot(36)]
		UInt64 GetServerReputation();
		[VTableSlot(37)]
		UInt32 GetPublicIP();
		[VTableSlot(38)]
		bool HandleIncomingPacket(Byte[] pData, Int32 cbData, UInt32 srcIP, UInt16 srcPort);
		[VTableSlot(39)]
		Int32 GetNextOutgoingPacket(Byte[] pOut, Int32 cbMaxOut, ref UInt32 pNetAdr, ref UInt16 pPort);
		[VTableSlot(40)]
		void EnableHeartbeats(bool bEnabled);
		[VTableSlot(41)]
		void SetHeartbeatInterval(Int32 iInterval);
		[VTableSlot(42)]
		void ForceHeartbeat();
		[VTableSlot(43)]
		ELogonState GetLogonState();
		[VTableSlot(44)]
		bool BConnected();
		[VTableSlot(45)]
		Int32 RaiseConnectionPriority(EConnectionPriority eConnectionPriority);
		[VTableSlot(46)]
		void ResetConnectionPriority(Int32 hRaiseConnectionPriorityPrev);
		[VTableSlot(47)]
		void SetCellID(UInt32 cellID);
		[VTableSlot(48)]
		void TrackSteamUsageEvent(ESteamUsageEvent eSteamUsageEvent, Byte[] pubKV, UInt32 cubKV);
		[VTableSlot(49)]
		void SetCountOfSimultaneousGuestUsersPerSteamAccount(Int32 nCount);
		[VTableSlot(50)]
		bool EnumerateConnectedUsers(Int32 iterator, ref ConnectedUserInfo_t pConnectedUserInfo);
		[VTableSlot(51)]
		UInt64 AssociateWithClan(CSteamID clanID);
		[VTableSlot(52)]
		UInt64 ComputeNewPlayerCompatibility(CSteamID steamID);
		[VTableSlot(53)]
		bool _BGetUserAchievementStatus(CSteamID steamID, string pchAchievementName);
		[VTableSlot(54)]
		void _GSSetSpawnCount(UInt32 ucSpawn);
		[VTableSlot(55)]
		bool _GSGetSteam2GetEncryptionKeyToSendToNewClient(Byte[] pvEncryptionKey, ref UInt32 pcbEncryptionKey, UInt32 cbMaxEncryptionKey);
		[VTableSlot(56)]
		bool _GSSendSteam2UserConnect(UInt32 unUserID, Byte[] pvRawKey, UInt32 unKeyLen, UInt32 unIPPublic, UInt16 usPort, Byte[] pvCookie, UInt32 cubCookie);
		[VTableSlot(57)]
		bool _GSSendSteam3UserConnect(CSteamID steamID, UInt32 unIPPublic, Byte[] pvCookie, UInt32 cubCookie);
		[VTableSlot(58)]
		bool _GSSendUserConnect(UInt32 unUserID, UInt32 unIPPublic, UInt16 usPort, Byte[] pvCookie, UInt32 cubCookie);
		[VTableSlot(59)]
		bool _GSRemoveUserConnect(UInt32 unUserID);
		[VTableSlot(60)]
		bool _GSUpdateStatus(Int32 cPlayers, Int32 cPlayersMax, Int32 cBotPlayers, string pchServerName, string pSpectatorServerName, string pchMapName);
		[VTableSlot(61)]
		bool _GSCreateUnauthenticatedUser(ref CSteamID pSteamID);
		[VTableSlot(62)]
		bool _GSSetServerType(Int32 iAppID, UInt32 unServerFlags, UInt32 unGameIP, UInt16 unGamePort, UInt16 unSpectatorPort, UInt16 usQueryPort, string pchGameDir, string pchVersion, bool bLANMode);
		[VTableSlot(63)]
		void _SetBasicServerData(UInt16 nProtocolVersion, bool bDedicatedServer, string pRegionName, string pProductName, UInt16 nMaxReportedClients, bool bPasswordProtected, string pGameDescription);
		[VTableSlot(64)]
		bool _GSSendUserDisconnect(CSteamID arg0, UInt32 unUserID);
	};
}
