// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;

namespace Steam4NET
{

	[StructLayout(LayoutKind.Sequential,Pack=4)]
	public class ISteamGameServer010VTable
	{
		public IntPtr LogOn0;
		public IntPtr LogOff1;
		public IntPtr BLoggedOn2;
		public IntPtr BSecure3;
		public IntPtr GetSteamID4;
		public IntPtr SendUserConnectAndAuthenticate5;
		public IntPtr CreateUnauthenticatedUserConnection6;
		public IntPtr SendUserDisconnect7;
		public IntPtr BUpdateUserData8;
		public IntPtr BSetServerType9;
		public IntPtr UpdateServerStatus10;
		public IntPtr UpdateSpectatorPort11;
		public IntPtr SetGameTags12;
		public IntPtr GetGameplayStats13;
		public IntPtr GetServerReputation14;
		public IntPtr RequestUserGroupStatus15;
		public IntPtr GetPublicIP16;
		public IntPtr SetGameData17;
		public IntPtr UserHasLicenseForApp18;
		public IntPtr GetAuthSessionTicket19;
		public IntPtr BeginAuthSession20;
		public IntPtr EndAuthSession21;
		public IntPtr CancelAuthTicket22;
		private IntPtr DTorISteamGameServer01023;
	};
	
	[InteropHelp.InterfaceVersion("SteamGameServer010")]
	public class ISteamGameServer010 : InteropHelp.NativeWrapper<ISteamGameServer010VTable>
	{
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeLogOn( IntPtr thisptr );
		public void LogOn(  ) 
		{
			this.GetFunction<NativeLogOn>( this.Functions.LogOn0 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeLogOff( IntPtr thisptr );
		public void LogOff(  ) 
		{
			this.GetFunction<NativeLogOff>( this.Functions.LogOff1 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBLoggedOn( IntPtr thisptr );
		public bool BLoggedOn(  ) 
		{
			return this.GetFunction<NativeBLoggedOn>( this.Functions.BLoggedOn2 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBSecure( IntPtr thisptr );
		public bool BSecure(  ) 
		{
			return this.GetFunction<NativeBSecure>( this.Functions.BSecure3 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetSteamID( IntPtr thisptr, ref UInt64 retarg );
		public CSteamID GetSteamID(  ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetSteamID>( this.Functions.GetSteamID4 )( this.ObjectAddress, ref ret ); return new CSteamID(ret);
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSendUserConnectAndAuthenticateUBUC( IntPtr thisptr, UInt32 unIPClient, Byte[] pvAuthBlob, UInt32 cubAuthBlobSize, ref UInt64 pSteamIDUser );
		public bool SendUserConnectAndAuthenticate( UInt32 unIPClient, Byte[] pvAuthBlob, ref CSteamID pSteamIDUser ) 
		{
			UInt64 s0 = 0; var result = this.GetFunction<NativeSendUserConnectAndAuthenticateUBUC>( this.Functions.SendUserConnectAndAuthenticate5 )( this.ObjectAddress, unIPClient, pvAuthBlob, (UInt32) pvAuthBlob.Length, ref s0 ); pSteamIDUser = new CSteamID(s0); return result;
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeCreateUnauthenticatedUserConnection( IntPtr thisptr, ref UInt64 retarg );
		public CSteamID CreateUnauthenticatedUserConnection(  ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeCreateUnauthenticatedUserConnection>( this.Functions.CreateUnauthenticatedUserConnection6 )( this.ObjectAddress, ref ret ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSendUserDisconnectC( IntPtr thisptr, UInt64 steamIDUser );
		public void SendUserDisconnect( CSteamID steamIDUser ) 
		{
			this.GetFunction<NativeSendUserDisconnectC>( this.Functions.SendUserDisconnect7 )( this.ObjectAddress, steamIDUser.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBUpdateUserDataCSU( IntPtr thisptr, UInt64 steamIDUser, string pchPlayerName, UInt32 uScore );
		public bool BUpdateUserData( CSteamID steamIDUser, string pchPlayerName, UInt32 uScore ) 
		{
			return this.GetFunction<NativeBUpdateUserDataCSU>( this.Functions.BUpdateUserData8 )( this.ObjectAddress, steamIDUser.ConvertToUint64(), pchPlayerName, uScore ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBSetServerTypeUUUUUSSB( IntPtr thisptr, UInt32 unServerFlags, UInt32 unGameIP, UInt16 unGamePort, UInt16 unSpectatorPort, UInt16 usQueryPort, string pchGameDir, string pchVersion, [MarshalAs(UnmanagedType.I1)] bool bLANMode );
		public bool BSetServerType( UInt32 unServerFlags, UInt32 unGameIP, UInt16 unGamePort, UInt16 unSpectatorPort, UInt16 usQueryPort, string pchGameDir, string pchVersion, bool bLANMode ) 
		{
			return this.GetFunction<NativeBSetServerTypeUUUUUSSB>( this.Functions.BSetServerType9 )( this.ObjectAddress, unServerFlags, unGameIP, unGamePort, unSpectatorPort, usQueryPort, pchGameDir, pchVersion, bLANMode ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeUpdateServerStatusIIISSS( IntPtr thisptr, Int32 cPlayers, Int32 cPlayersMax, Int32 cBotPlayers, string pchServerName, string pSpectatorServerName, string pchMapName );
		public void UpdateServerStatus( Int32 cPlayers, Int32 cPlayersMax, Int32 cBotPlayers, string pchServerName, string pSpectatorServerName, string pchMapName ) 
		{
			this.GetFunction<NativeUpdateServerStatusIIISSS>( this.Functions.UpdateServerStatus10 )( this.ObjectAddress, cPlayers, cPlayersMax, cBotPlayers, pchServerName, pSpectatorServerName, pchMapName ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeUpdateSpectatorPortU( IntPtr thisptr, UInt16 unSpectatorPort );
		public void UpdateSpectatorPort( UInt16 unSpectatorPort ) 
		{
			this.GetFunction<NativeUpdateSpectatorPortU>( this.Functions.UpdateSpectatorPort11 )( this.ObjectAddress, unSpectatorPort ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetGameTagsS( IntPtr thisptr, string pchGameTags );
		public void SetGameTags( string pchGameTags ) 
		{
			this.GetFunction<NativeSetGameTagsS>( this.Functions.SetGameTags12 )( this.ObjectAddress, pchGameTags ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetGameplayStats( IntPtr thisptr );
		public void GetGameplayStats(  ) 
		{
			this.GetFunction<NativeGetGameplayStats>( this.Functions.GetGameplayStats13 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeGetServerReputation( IntPtr thisptr );
		public UInt64 GetServerReputation(  ) 
		{
			return this.GetFunction<NativeGetServerReputation>( this.Functions.GetServerReputation14 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeRequestUserGroupStatusCC( IntPtr thisptr, UInt64 steamIDUser, UInt64 steamIDGroup );
		public bool RequestUserGroupStatus( CSteamID steamIDUser, CSteamID steamIDGroup ) 
		{
			return this.GetFunction<NativeRequestUserGroupStatusCC>( this.Functions.RequestUserGroupStatus15 )( this.ObjectAddress, steamIDUser.ConvertToUint64(), steamIDGroup.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetPublicIP( IntPtr thisptr );
		public UInt32 GetPublicIP(  ) 
		{
			return this.GetFunction<NativeGetPublicIP>( this.Functions.GetPublicIP16 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetGameDataS( IntPtr thisptr, string pchGameData );
		public void SetGameData( string pchGameData ) 
		{
			this.GetFunction<NativeSetGameDataS>( this.Functions.SetGameData17 )( this.ObjectAddress, pchGameData ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EUserHasLicenseForAppResult NativeUserHasLicenseForAppCU( IntPtr thisptr, UInt64 steamID, UInt32 appID );
		public EUserHasLicenseForAppResult UserHasLicenseForApp( CSteamID steamID, UInt32 appID ) 
		{
			return this.GetFunction<NativeUserHasLicenseForAppCU>( this.Functions.UserHasLicenseForApp18 )( this.ObjectAddress, steamID.ConvertToUint64(), appID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetAuthSessionTicketBIU( IntPtr thisptr, Byte[] pTicket, Int32 cbMaxTicket, ref UInt32 pcbTicket );
		public UInt32 GetAuthSessionTicket( Byte[] pTicket, ref UInt32 pcbTicket ) 
		{
			return this.GetFunction<NativeGetAuthSessionTicketBIU>( this.Functions.GetAuthSessionTicket19 )( this.ObjectAddress, pTicket, (Int32) pTicket.Length, ref pcbTicket ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EBeginAuthSessionResult NativeBeginAuthSessionBIC( IntPtr thisptr, Byte[] pAuthTicket, Int32 cbAuthTicket, UInt64 steamID );
		public EBeginAuthSessionResult BeginAuthSession( Byte[] pAuthTicket, CSteamID steamID ) 
		{
			return this.GetFunction<NativeBeginAuthSessionBIC>( this.Functions.BeginAuthSession20 )( this.ObjectAddress, pAuthTicket, (Int32) pAuthTicket.Length, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeEndAuthSessionC( IntPtr thisptr, UInt64 steamID );
		public void EndAuthSession( CSteamID steamID ) 
		{
			this.GetFunction<NativeEndAuthSessionC>( this.Functions.EndAuthSession21 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeCancelAuthTicketU( IntPtr thisptr, UInt32 hAuthTicket );
		public void CancelAuthTicket( UInt32 hAuthTicket ) 
		{
			this.GetFunction<NativeCancelAuthTicketU>( this.Functions.CancelAuthTicket22 )( this.ObjectAddress, hAuthTicket ); 
		}
		
	};
}
