// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;

namespace Steam4NET
{

	[StructLayout(LayoutKind.Sequential,Pack=4)]
	public class IClientFriendsVTable
	{
		public IntPtr GetPersonaName0;
		public IntPtr SetPersonaName1;
		public IntPtr SetPersonaNameEx2;
		public IntPtr IsPersonaNameSet3;
		public IntPtr GetPersonaState4;
		public IntPtr SetPersonaState5;
		public IntPtr NotifyUIOfMenuChange6;
		public IntPtr GetFriendCount7;
		public IntPtr GetFriendArray8;
		public IntPtr GetFriendByIndex9;
		public IntPtr GetOnlineFriendCount10;
		public IntPtr GetFriendRelationship11;
		public IntPtr GetFriendPersonaState12;
		public IntPtr GetFriendPersonaName13;
		public IntPtr GetSmallFriendAvatar14;
		public IntPtr GetMediumFriendAvatar15;
		public IntPtr GetLargeFriendAvatar16;
		public IntPtr SetFriendRegValue17;
		public IntPtr GetFriendRegValue18;
		public IntPtr DeleteFriendRegValue19;
		public IntPtr GetFriendGamePlayed20;
		public IntPtr GetFriendGamePlayedExtraInfo21;
		public IntPtr GetFriendGameServer22;
		public IntPtr GetFriendPersonaStateFlags23;
		public IntPtr IsFriendGameOnConsole24;
		public IntPtr GetFriendSessionStateInfo25;
		public IntPtr GetFriendRestrictions26;
		public IntPtr GetFriendPersonaNameHistory27;
		public IntPtr GetFriendSteamLevel28;
		public IntPtr RequestPersonaNameHistory29;
		public IntPtr GetFriendPersonaNameHistoryAndDate30;
		public IntPtr AddFriend31;
		public IntPtr RemoveFriend32;
		public IntPtr HasFriend33;
		public IntPtr AddFriendByName34;
		public IntPtr InviteFriendByEmail35;
		public IntPtr RequestUserInformation36;
		public IntPtr SetIgnoreFriend37;
		public IntPtr ReportChatDeclined38;
		public IntPtr CreateFriendsGroup39;
		public IntPtr DeleteFriendsGroup40;
		public IntPtr RenameFriendsGroup41;
		public IntPtr AddFriendToGroup42;
		public IntPtr RemoveFriendFromGroup43;
		public IntPtr IsFriendMemberOfFriendsGroup44;
		public IntPtr GetFriendsGroupCount45;
		public IntPtr GetFriendsGroupIDByIndex46;
		public IntPtr GetFriendsGroupName47;
		public IntPtr GetFriendsGroupMembershipCount48;
		public IntPtr GetFirstFriendsGroupMember49;
		public IntPtr GetNextFriendsGroupMember50;
		public IntPtr GetGroupFriendsMembershipCount51;
		public IntPtr GetFirstGroupFriendsMember52;
		public IntPtr GetNextGroupFriendsMember53;
		public IntPtr GetPlayerNickname54;
		public IntPtr SetPlayerNickname55;
		public IntPtr GetFriendsSteamLevel56;
		public IntPtr GetChatMessagesCount57;
		public IntPtr GetChatMessage58;
		public IntPtr SendMsgToFriend59;
		public IntPtr ClearChatHistory60;
		public IntPtr GetKnownClanCount61;
		public IntPtr GetKnownClanByIndex62;
		public IntPtr GetClanCount63;
		public IntPtr GetClanByIndex64;
		public IntPtr GetClanName65;
		public IntPtr GetClanTag66;
		public IntPtr GetFriendActivityCounts67;
		public IntPtr GetClanActivityCounts68;
		public IntPtr DownloadClanActivityCounts69;
		public IntPtr GetFriendsGroupActivityCounts70;
		public IntPtr IsClanPublic71;
		public IntPtr JoinClanChatRoom72;
		public IntPtr LeaveClanChatRoom73;
		public IntPtr GetClanChatMemberCount74;
		public IntPtr GetChatMemberByIndex75;
		public IntPtr SendClanChatMessage76;
		public IntPtr GetClanChatMessage77;
		public IntPtr IsClanChatAdmin78;
		public IntPtr IsClanChatWindowOpenInSteam79;
		public IntPtr OpenClanChatWindowInSteam80;
		public IntPtr CloseClanChatWindowInSteam81;
		public IntPtr SetListenForFriendsMessages82;
		public IntPtr ReplyToFriendMessage83;
		public IntPtr GetFriendMessage84;
		public IntPtr InviteFriendToClan85;
		public IntPtr AcknowledgeInviteToClan86;
		public IntPtr GetFriendCountFromSource87;
		public IntPtr GetFriendFromSourceByIndex88;
		public IntPtr IsUserInSource89;
		public IntPtr GetCoplayFriendCount90;
		public IntPtr GetCoplayFriend91;
		public IntPtr GetFriendCoplayTime92;
		public IntPtr GetFriendCoplayGame93;
		public IntPtr SetRichPresence94;
		public IntPtr ClearRichPresence95;
		public IntPtr GetFriendRichPresence96;
		public IntPtr GetFriendRichPresenceKeyCount97;
		public IntPtr GetFriendRichPresenceKeyByIndex98;
		public IntPtr RequestFriendRichPresence99;
		public IntPtr JoinChatRoom100;
		public IntPtr LeaveChatRoom101;
		public IntPtr InviteUserToChatRoom102;
		public IntPtr SendChatMsg103;
		public IntPtr GetChatRoomMessagesCount104;
		public IntPtr GetChatRoomEntry105;
		public IntPtr ClearChatRoomHistory106;
		public IntPtr SerializeChatRoomDlg107;
		public IntPtr GetSizeOfSerializedChatRoomDlg108;
		public IntPtr GetSerializedChatRoomDlg109;
		public IntPtr ClearSerializedChatRoomDlg110;
		public IntPtr KickChatMember111;
		public IntPtr BanChatMember112;
		public IntPtr UnBanChatMember113;
		public IntPtr SetChatRoomType114;
		public IntPtr GetChatRoomLockState115;
		public IntPtr GetChatRoomPermissions116;
		public IntPtr SetChatRoomModerated117;
		public IntPtr BChatRoomModerated118;
		public IntPtr NotifyChatRoomDlgsOfUIChange119;
		public IntPtr TerminateChatRoom120;
		public IntPtr GetChatRoomCount121;
		public IntPtr GetChatRoomByIndex122;
		public IntPtr GetChatRoomName123;
		public IntPtr BGetChatRoomMemberDetails124;
		public IntPtr CreateChatRoom125;
		public IntPtr VoiceCallNew126;
		public IntPtr VoiceCall127;
		public IntPtr VoiceHangUp128;
		public IntPtr SetVoiceSpeakerVolume129;
		public IntPtr SetVoiceMicrophoneVolume130;
		public IntPtr SetAutoAnswer131;
		public IntPtr VoiceAnswer132;
		public IntPtr AcceptVoiceCall133;
		public IntPtr VoicePutOnHold134;
		public IntPtr BVoiceIsLocalOnHold135;
		public IntPtr BVoiceIsRemoteOnHold136;
		public IntPtr SetDoNotDisturb137;
		public IntPtr EnableVoiceNotificationSounds138;
		public IntPtr SetPushToTalkEnabled139;
		public IntPtr IsPushToTalkEnabled140;
		public IntPtr SetPushToTalkKey141;
		public IntPtr GetPushToTalkKey142;
		public IntPtr IsPushToTalkKeyDown143;
		public IntPtr EnableVoiceCalibration144;
		public IntPtr IsVoiceCalibrating145;
		public IntPtr GetVoiceCalibrationSamplePeak146;
		public IntPtr SetMicBoost147;
		public IntPtr GetMicBoost148;
		public IntPtr HasHardwareMicBoost149;
		public IntPtr GetMicDeviceName150;
		public IntPtr StartTalking151;
		public IntPtr EndTalking152;
		public IntPtr VoiceIsValid153;
		public IntPtr SetAutoReflectVoice154;
		public IntPtr GetCallState155;
		public IntPtr GetVoiceMicrophoneVolume156;
		public IntPtr GetVoiceSpeakerVolume157;
		public IntPtr TimeSinceLastVoiceDataReceived158;
		public IntPtr TimeSinceLastVoiceDataSend159;
		public IntPtr BCanSend160;
		public IntPtr BCanReceive161;
		public IntPtr GetEstimatedBitsPerSecond162;
		public IntPtr GetPeakSample163;
		public IntPtr SendResumeRequest164;
		public IntPtr OpenChatDialog165;
		public IntPtr StartChatRoomVoiceSpeaking166;
		public IntPtr EndChatRoomVoiceSpeaking167;
		public IntPtr GetFriendLastLogonTime168;
		public IntPtr GetFriendLastLogoffTime169;
		public IntPtr GetChatRoomVoiceTotalSlotCount170;
		public IntPtr GetChatRoomVoiceUsedSlotCount171;
		public IntPtr GetChatRoomVoiceUsedSlot172;
		public IntPtr GetChatRoomVoiceStatus173;
		public IntPtr BChatRoomHasAvailableVoiceSlots174;
		public IntPtr BIsChatRoomVoiceSpeaking175;
		public IntPtr GetChatRoomPeakSample176;
		public IntPtr ChatRoomVoiceRetryConnections177;
		public IntPtr SetPortTypes178;
		public IntPtr ReinitAudio179;
		public IntPtr SetInGameVoiceSpeaking180;
		public IntPtr IsInGameVoiceSpeaking181;
		public IntPtr ActivateGameOverlay182;
		public IntPtr ActivateGameOverlayToUser183;
		public IntPtr ActivateGameOverlayToWebPage184;
		public IntPtr ActivateGameOverlayToStore185;
		public IntPtr ActivateGameOverlayInviteDialog186;
		public IntPtr NotifyGameOverlayStateChanged187;
		public IntPtr NotifyGameServerChangeRequested188;
		public IntPtr NotifyLobbyJoinRequested189;
		public IntPtr NotifyRichPresenceJoinRequested190;
		public IntPtr GetClanRelationship191;
		public IntPtr GetFriendClanRank192;
		public IntPtr VoiceIsAvailable193;
		public IntPtr TestVoiceDisconnect194;
		public IntPtr TestChatRoomPeerDisconnect195;
		public IntPtr TestVoicePacketLoss196;
		public IntPtr FindFriendVoiceChatHandle197;
		public IntPtr RequestFriendsWhoPlayGame198;
		public IntPtr GetCountFriendsWhoPlayGame199;
		public IntPtr GetFriendWhoPlaysGame200;
		public IntPtr SetPlayedWith201;
		public IntPtr RequestClanOfficerList202;
		public IntPtr GetClanOwner203;
		public IntPtr GetClanOfficerCount204;
		public IntPtr GetClanOfficerByIndex205;
		public IntPtr GetUserRestrictions206;
		public IntPtr RequestFriendProfileInfo207;
		public IntPtr GetFriendProfileInfo208;
		public IntPtr InviteUserToGame209;
		public IntPtr GetOnlineConsoleFriendCount210;
		public IntPtr RequestTrade211;
		public IntPtr TradeResponse212;
		public IntPtr CancelTradeRequest213;
		public IntPtr HideFriend214;
		public IntPtr GetFriendFacebookName215;
		public IntPtr GetFriendFacebookID216;
		public IntPtr GetFollowerCount217;
		public IntPtr IsFollowing218;
		public IntPtr EnumerateFollowingList219;
		public IntPtr RequestFriendMessageHistory220;
		public IntPtr RequestFriendMessageHistoryForOfflineMessages221;
		public IntPtr GetCountFriendsWithOfflineMessages222;
		public IntPtr GetFriendWithOfflineMessage223;
		public IntPtr ClearFriendHasOfflineMessage224;
		public IntPtr RequestEmoticonList225;
		public IntPtr GetEmoticonCount226;
		public IntPtr GetEmoticonName227;
		public IntPtr ClientLinkFilterInit228;
		public IntPtr LinkDisposition229;
		private IntPtr DTorIClientFriends230;
	};
	
	[InteropHelp.InterfaceVersion("CLIENTFRIENDS_INTERFACE_VERSION001")]
	public class IClientFriends : InteropHelp.NativeWrapper<IClientFriendsVTable>
	{
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetPersonaName( IntPtr thisptr );
		public string GetPersonaName(  ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetPersonaName>( this.Functions.GetPersonaName0 )( this.ObjectAddress ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetPersonaNameS( IntPtr thisptr, string pchPersonaName );
		public void SetPersonaName( string pchPersonaName ) 
		{
			this.GetFunction<NativeSetPersonaNameS>( this.Functions.SetPersonaName1 )( this.ObjectAddress, pchPersonaName ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeSetPersonaNameExSB( IntPtr thisptr, string pchPersonaName, [MarshalAs(UnmanagedType.I1)] bool bSendCallback );
		public UInt64 SetPersonaNameEx( string pchPersonaName, bool bSendCallback ) 
		{
			return this.GetFunction<NativeSetPersonaNameExSB>( this.Functions.SetPersonaNameEx2 )( this.ObjectAddress, pchPersonaName, bSendCallback ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsPersonaNameSet( IntPtr thisptr );
		public bool IsPersonaNameSet(  ) 
		{
			return this.GetFunction<NativeIsPersonaNameSet>( this.Functions.IsPersonaNameSet3 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EPersonaState NativeGetPersonaState( IntPtr thisptr );
		public EPersonaState GetPersonaState(  ) 
		{
			return this.GetFunction<NativeGetPersonaState>( this.Functions.GetPersonaState4 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetPersonaStateE( IntPtr thisptr, EPersonaState ePersonaState );
		public void SetPersonaState( EPersonaState ePersonaState ) 
		{
			this.GetFunction<NativeSetPersonaStateE>( this.Functions.SetPersonaState5 )( this.ObjectAddress, ePersonaState ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeNotifyUIOfMenuChangeBBBB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bShowAvatars, [MarshalAs(UnmanagedType.I1)] bool bSortByName, [MarshalAs(UnmanagedType.I1)] bool bShowOnlineOnly, [MarshalAs(UnmanagedType.I1)] bool bShowUntaggedFriends );
		public bool NotifyUIOfMenuChange( bool bShowAvatars, bool bSortByName, bool bShowOnlineOnly, bool bShowUntaggedFriends ) 
		{
			return this.GetFunction<NativeNotifyUIOfMenuChangeBBBB>( this.Functions.NotifyUIOfMenuChange6 )( this.ObjectAddress, bShowAvatars, bSortByName, bShowOnlineOnly, bShowUntaggedFriends ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetFriendCountE( IntPtr thisptr, EFriendFlags iFriendFlags );
		public Int32 GetFriendCount( EFriendFlags iFriendFlags ) 
		{
			return this.GetFunction<NativeGetFriendCountE>( this.Functions.GetFriendCount7 )( this.ObjectAddress, iFriendFlags ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendArrayCSII( IntPtr thisptr, ref UInt64 arg0, StringBuilder arg1, Int32 arg2, Int32 arg3 );
		public UInt32 GetFriendArray( ref CSteamID arg0, StringBuilder arg1, Int32 arg2, Int32 arg3 ) 
		{
			UInt64 s0 = 0; var result = this.GetFunction<NativeGetFriendArrayCSII>( this.Functions.GetFriendArray8 )( this.ObjectAddress, ref s0, arg1, arg2, arg3 ); arg0 = new CSteamID(s0); return result;
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetFriendByIndexIE( IntPtr thisptr, ref UInt64 retarg, Int32 iFriend, EFriendFlags iFriendFlags );
		public CSteamID GetFriendByIndex( Int32 iFriend, EFriendFlags iFriendFlags ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetFriendByIndexIE>( this.Functions.GetFriendByIndex9 )( this.ObjectAddress, ref ret, iFriend, iFriendFlags ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetOnlineFriendCount( IntPtr thisptr );
		public Int32 GetOnlineFriendCount(  ) 
		{
			return this.GetFunction<NativeGetOnlineFriendCount>( this.Functions.GetOnlineFriendCount10 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EFriendRelationship NativeGetFriendRelationshipC( IntPtr thisptr, UInt64 steamIDFriend );
		public EFriendRelationship GetFriendRelationship( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendRelationshipC>( this.Functions.GetFriendRelationship11 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EPersonaState NativeGetFriendPersonaStateC( IntPtr thisptr, UInt64 steamIDFriend );
		public EPersonaState GetFriendPersonaState( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendPersonaStateC>( this.Functions.GetFriendPersonaState12 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendPersonaNameC( IntPtr thisptr, UInt64 steamIDFriend );
		public string GetFriendPersonaName( CSteamID steamIDFriend ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendPersonaNameC>( this.Functions.GetFriendPersonaName13 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetSmallFriendAvatarC( IntPtr thisptr, UInt64 steamIDFriend );
		public Int32 GetSmallFriendAvatar( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetSmallFriendAvatarC>( this.Functions.GetSmallFriendAvatar14 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetMediumFriendAvatarC( IntPtr thisptr, UInt64 steamIDFriend );
		public Int32 GetMediumFriendAvatar( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetMediumFriendAvatarC>( this.Functions.GetMediumFriendAvatar15 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetLargeFriendAvatarC( IntPtr thisptr, UInt64 steamIDFriend );
		public Int32 GetLargeFriendAvatar( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetLargeFriendAvatarC>( this.Functions.GetLargeFriendAvatar16 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetFriendRegValueCSS( IntPtr thisptr, UInt64 steamIDFriend, string pchKey, string pchValue );
		public void SetFriendRegValue( CSteamID steamIDFriend, string pchKey, string pchValue ) 
		{
			this.GetFunction<NativeSetFriendRegValueCSS>( this.Functions.SetFriendRegValue17 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), pchKey, pchValue ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendRegValueCS( IntPtr thisptr, UInt64 steamIDFriend, string pchKey );
		public string GetFriendRegValue( CSteamID steamIDFriend, string pchKey ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendRegValueCS>( this.Functions.GetFriendRegValue18 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), pchKey ) ) ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeDeleteFriendRegValueCS( IntPtr thisptr, UInt64 steamID, string pchKey );
		public bool DeleteFriendRegValue( CSteamID steamID, string pchKey ) 
		{
			return this.GetFunction<NativeDeleteFriendRegValueCS>( this.Functions.DeleteFriendRegValue19 )( this.ObjectAddress, steamID.ConvertToUint64(), pchKey ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetFriendGamePlayedCF( IntPtr thisptr, UInt64 steamID, ref FriendGameInfo_t pGamePlayInfo );
		public bool GetFriendGamePlayed( CSteamID steamID, ref FriendGameInfo_t pGamePlayInfo ) 
		{
			return this.GetFunction<NativeGetFriendGamePlayedCF>( this.Functions.GetFriendGamePlayed20 )( this.ObjectAddress, steamID.ConvertToUint64(), ref pGamePlayInfo ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendGamePlayedExtraInfoC( IntPtr thisptr, UInt64 steamIDFriend );
		public string GetFriendGamePlayedExtraInfo( CSteamID steamIDFriend ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendGamePlayedExtraInfoC>( this.Functions.GetFriendGamePlayedExtraInfo21 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetFriendGameServerC( IntPtr thisptr, ref UInt64 retarg, UInt64 steamIDFriend );
		public CSteamID GetFriendGameServer( CSteamID steamIDFriend ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetFriendGameServerC>( this.Functions.GetFriendGameServer22 )( this.ObjectAddress, ref ret, steamIDFriend.ConvertToUint64() ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EPersonaStateFlag NativeGetFriendPersonaStateFlagsC( IntPtr thisptr, UInt64 steamIDFriend );
		public EPersonaStateFlag GetFriendPersonaStateFlags( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendPersonaStateFlagsC>( this.Functions.GetFriendPersonaStateFlags23 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsFriendGameOnConsoleC( IntPtr thisptr, UInt64 steamIDFriend );
		public bool IsFriendGameOnConsole( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeIsFriendGameOnConsoleC>( this.Functions.IsFriendGameOnConsole24 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetFriendSessionStateInfoC( IntPtr thisptr, ref FriendSessionStateInfo_t retarg, UInt64 steamIDFriend );
		public FriendSessionStateInfo_t GetFriendSessionStateInfo( CSteamID steamIDFriend ) 
		{
			FriendSessionStateInfo_t ret = new FriendSessionStateInfo_t();this.GetFunction<NativeGetFriendSessionStateInfoC>( this.Functions.GetFriendSessionStateInfo25 )( this.ObjectAddress, ref ret, steamIDFriend.ConvertToUint64() ); return (FriendSessionStateInfo_t)ret;
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EUserRestriction NativeGetFriendRestrictionsC( IntPtr thisptr, UInt64 steamIDFriend );
		public EUserRestriction GetFriendRestrictions( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendRestrictionsC>( this.Functions.GetFriendRestrictions26 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendPersonaNameHistoryCI( IntPtr thisptr, UInt64 steamIDFriend, Int32 iPersonaName );
		public string GetFriendPersonaNameHistory( CSteamID steamIDFriend, Int32 iPersonaName ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendPersonaNameHistoryCI>( this.Functions.GetFriendPersonaNameHistory27 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), iPersonaName ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendSteamLevelC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt32 GetFriendSteamLevel( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendSteamLevelC>( this.Functions.GetFriendSteamLevel28 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeRequestPersonaNameHistoryC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt64 RequestPersonaNameHistory( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeRequestPersonaNameHistoryC>( this.Functions.RequestPersonaNameHistory29 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendPersonaNameHistoryAndDateCIU( IntPtr thisptr, UInt64 steamIDFriend, Int32 iPersonaName, ref UInt32 puTime );
		public string GetFriendPersonaNameHistoryAndDate( CSteamID steamIDFriend, Int32 iPersonaName, ref UInt32 puTime ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendPersonaNameHistoryAndDateCIU>( this.Functions.GetFriendPersonaNameHistoryAndDate30 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), iPersonaName, ref puTime ) ) ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeAddFriendC( IntPtr thisptr, UInt64 steamID );
		public bool AddFriend( CSteamID steamID ) 
		{
			return this.GetFunction<NativeAddFriendC>( this.Functions.AddFriend31 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeRemoveFriendC( IntPtr thisptr, UInt64 steamID );
		public bool RemoveFriend( CSteamID steamID ) 
		{
			return this.GetFunction<NativeRemoveFriendC>( this.Functions.RemoveFriend32 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeHasFriendCE( IntPtr thisptr, UInt64 steamID, EFriendFlags iFriendFlags );
		public bool HasFriend( CSteamID steamID, EFriendFlags iFriendFlags ) 
		{
			return this.GetFunction<NativeHasFriendCE>( this.Functions.HasFriend33 )( this.ObjectAddress, steamID.ConvertToUint64(), iFriendFlags ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeAddFriendByNameS( IntPtr thisptr, string pchEmailOrAccountName );
		public Int32 AddFriendByName( string pchEmailOrAccountName ) 
		{
			return this.GetFunction<NativeAddFriendByNameS>( this.Functions.AddFriendByName34 )( this.ObjectAddress, pchEmailOrAccountName ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeInviteFriendByEmailS( IntPtr thisptr, string pchEmailAddress );
		public bool InviteFriendByEmail( string pchEmailAddress ) 
		{
			return this.GetFunction<NativeInviteFriendByEmailS>( this.Functions.InviteFriendByEmail35 )( this.ObjectAddress, pchEmailAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeRequestUserInformationCB( IntPtr thisptr, UInt64 steamIDUser, [MarshalAs(UnmanagedType.I1)] bool bRequireNameOnly );
		public bool RequestUserInformation( CSteamID steamIDUser, bool bRequireNameOnly ) 
		{
			return this.GetFunction<NativeRequestUserInformationCB>( this.Functions.RequestUserInformation36 )( this.ObjectAddress, steamIDUser.ConvertToUint64(), bRequireNameOnly ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetIgnoreFriendCB( IntPtr thisptr, UInt64 steamIDFriend, [MarshalAs(UnmanagedType.I1)] bool bIgnore );
		public bool SetIgnoreFriend( CSteamID steamIDFriend, bool bIgnore ) 
		{
			return this.GetFunction<NativeSetIgnoreFriendCB>( this.Functions.SetIgnoreFriend37 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), bIgnore ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeReportChatDeclinedC( IntPtr thisptr, UInt64 steamID );
		public bool ReportChatDeclined( CSteamID steamID ) 
		{
			return this.GetFunction<NativeReportChatDeclinedC>( this.Functions.ReportChatDeclined38 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeCreateFriendsGroupS( IntPtr thisptr, string pchGroupName );
		public bool CreateFriendsGroup( string pchGroupName ) 
		{
			return this.GetFunction<NativeCreateFriendsGroupS>( this.Functions.CreateFriendsGroup39 )( this.ObjectAddress, pchGroupName ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeDeleteFriendsGroupI( IntPtr thisptr, Int16 iGroupID );
		public bool DeleteFriendsGroup( Int16 iGroupID ) 
		{
			return this.GetFunction<NativeDeleteFriendsGroupI>( this.Functions.DeleteFriendsGroup40 )( this.ObjectAddress, iGroupID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeRenameFriendsGroupSI( IntPtr thisptr, string pchNewGroupName, Int16 iGroupID );
		public bool RenameFriendsGroup( string pchNewGroupName, Int16 iGroupID ) 
		{
			return this.GetFunction<NativeRenameFriendsGroupSI>( this.Functions.RenameFriendsGroup41 )( this.ObjectAddress, pchNewGroupName, iGroupID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeAddFriendToGroupCI( IntPtr thisptr, UInt64 steamID, Int16 iGroupID );
		public bool AddFriendToGroup( CSteamID steamID, Int16 iGroupID ) 
		{
			return this.GetFunction<NativeAddFriendToGroupCI>( this.Functions.AddFriendToGroup42 )( this.ObjectAddress, steamID.ConvertToUint64(), iGroupID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeRemoveFriendFromGroupCI( IntPtr thisptr, UInt64 steamID, Int16 iGroupID );
		public bool RemoveFriendFromGroup( CSteamID steamID, Int16 iGroupID ) 
		{
			return this.GetFunction<NativeRemoveFriendFromGroupCI>( this.Functions.RemoveFriendFromGroup43 )( this.ObjectAddress, steamID.ConvertToUint64(), iGroupID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsFriendMemberOfFriendsGroupCI( IntPtr thisptr, UInt64 steamID, Int16 iGroupID );
		public bool IsFriendMemberOfFriendsGroup( CSteamID steamID, Int16 iGroupID ) 
		{
			return this.GetFunction<NativeIsFriendMemberOfFriendsGroupCI>( this.Functions.IsFriendMemberOfFriendsGroup44 )( this.ObjectAddress, steamID.ConvertToUint64(), iGroupID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int16 NativeGetFriendsGroupCount( IntPtr thisptr );
		public Int16 GetFriendsGroupCount(  ) 
		{
			return this.GetFunction<NativeGetFriendsGroupCount>( this.Functions.GetFriendsGroupCount45 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int16 NativeGetFriendsGroupIDByIndexI( IntPtr thisptr, Int16 iGroupIndex );
		public Int16 GetFriendsGroupIDByIndex( Int16 iGroupIndex ) 
		{
			return this.GetFunction<NativeGetFriendsGroupIDByIndexI>( this.Functions.GetFriendsGroupIDByIndex46 )( this.ObjectAddress, iGroupIndex ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendsGroupNameI( IntPtr thisptr, Int16 iGroupID );
		public string GetFriendsGroupName( Int16 iGroupID ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendsGroupNameI>( this.Functions.GetFriendsGroupName47 )( this.ObjectAddress, iGroupID ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int16 NativeGetFriendsGroupMembershipCountI( IntPtr thisptr, Int16 iGroupID );
		public Int16 GetFriendsGroupMembershipCount( Int16 iGroupID ) 
		{
			return this.GetFunction<NativeGetFriendsGroupMembershipCountI>( this.Functions.GetFriendsGroupMembershipCount48 )( this.ObjectAddress, iGroupID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetFirstFriendsGroupMemberI( IntPtr thisptr, ref UInt64 retarg, Int16 iGroupID );
		public CSteamID GetFirstFriendsGroupMember( Int16 iGroupID ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetFirstFriendsGroupMemberI>( this.Functions.GetFirstFriendsGroupMember49 )( this.ObjectAddress, ref ret, iGroupID ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetNextFriendsGroupMemberI( IntPtr thisptr, ref UInt64 retarg, Int16 iGroupID );
		public CSteamID GetNextFriendsGroupMember( Int16 iGroupID ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetNextFriendsGroupMemberI>( this.Functions.GetNextFriendsGroupMember50 )( this.ObjectAddress, ref ret, iGroupID ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int16 NativeGetGroupFriendsMembershipCountC( IntPtr thisptr, UInt64 steamID );
		public Int16 GetGroupFriendsMembershipCount( CSteamID steamID ) 
		{
			return this.GetFunction<NativeGetGroupFriendsMembershipCountC>( this.Functions.GetGroupFriendsMembershipCount51 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int16 NativeGetFirstGroupFriendsMemberC( IntPtr thisptr, UInt64 steamID );
		public Int16 GetFirstGroupFriendsMember( CSteamID steamID ) 
		{
			return this.GetFunction<NativeGetFirstGroupFriendsMemberC>( this.Functions.GetFirstGroupFriendsMember52 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int16 NativeGetNextGroupFriendsMemberC( IntPtr thisptr, UInt64 steamID );
		public Int16 GetNextGroupFriendsMember( CSteamID steamID ) 
		{
			return this.GetFunction<NativeGetNextGroupFriendsMemberC>( this.Functions.GetNextGroupFriendsMember53 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetPlayerNicknameC( IntPtr thisptr, UInt64 playerSteamID );
		public string GetPlayerNickname( CSteamID playerSteamID ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetPlayerNicknameC>( this.Functions.GetPlayerNickname54 )( this.ObjectAddress, playerSteamID.ConvertToUint64() ) ) ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetPlayerNicknameCS( IntPtr thisptr, UInt64 playerSteamID, string cszNickname );
		public bool SetPlayerNickname( CSteamID playerSteamID, string cszNickname ) 
		{
			return this.GetFunction<NativeSetPlayerNicknameCS>( this.Functions.SetPlayerNickname55 )( this.ObjectAddress, playerSteamID.ConvertToUint64(), cszNickname ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendsSteamLevelC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt32 GetFriendsSteamLevel( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendsSteamLevelC>( this.Functions.GetFriendsSteamLevel56 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetChatMessagesCountC( IntPtr thisptr, UInt64 steamIDFriend );
		public Int32 GetChatMessagesCount( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetChatMessagesCountC>( this.Functions.GetChatMessagesCount57 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetChatMessageCIBIECU( IntPtr thisptr, UInt64 steamIDFriend, Int32 iChatID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType, ref UInt64 pSteamIDChatter, ref UInt32 puTime );
		public Int32 GetChatMessage( CSteamID steamIDFriend, Int32 iChatID, Byte[] pvData, ref EChatEntryType peChatEntryType, ref CSteamID pSteamIDChatter, ref UInt32 puTime ) 
		{
			UInt64 s0 = 0; var result = this.GetFunction<NativeGetChatMessageCIBIECU>( this.Functions.GetChatMessage58 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), iChatID, pvData, (Int32) pvData.Length, ref peChatEntryType, ref s0, ref puTime ); pSteamIDChatter = new CSteamID(s0); return result;
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSendMsgToFriendCEBI( IntPtr thisptr, UInt64 steamIDFriend, EChatEntryType eChatEntryType, Byte[] pvMsgBody, Int32 cubMsgBody );
		public bool SendMsgToFriend( CSteamID steamIDFriend, EChatEntryType eChatEntryType, Byte[] pvMsgBody ) 
		{
			return this.GetFunction<NativeSendMsgToFriendCEBI>( this.Functions.SendMsgToFriend59 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), eChatEntryType, pvMsgBody, (Int32) pvMsgBody.Length ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeClearChatHistoryC( IntPtr thisptr, UInt64 steamIDFriend );
		public void ClearChatHistory( CSteamID steamIDFriend ) 
		{
			this.GetFunction<NativeClearChatHistoryC>( this.Functions.ClearChatHistory60 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetKnownClanCount( IntPtr thisptr );
		public Int32 GetKnownClanCount(  ) 
		{
			return this.GetFunction<NativeGetKnownClanCount>( this.Functions.GetKnownClanCount61 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetKnownClanByIndexI( IntPtr thisptr, ref UInt64 retarg, Int32 iClan );
		public CSteamID GetKnownClanByIndex( Int32 iClan ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetKnownClanByIndexI>( this.Functions.GetKnownClanByIndex62 )( this.ObjectAddress, ref ret, iClan ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetClanCount( IntPtr thisptr );
		public Int32 GetClanCount(  ) 
		{
			return this.GetFunction<NativeGetClanCount>( this.Functions.GetClanCount63 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetClanByIndexI( IntPtr thisptr, ref UInt64 retarg, Int32 iClan );
		public CSteamID GetClanByIndex( Int32 iClan ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetClanByIndexI>( this.Functions.GetClanByIndex64 )( this.ObjectAddress, ref ret, iClan ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetClanNameC( IntPtr thisptr, UInt64 steamIDClan );
		public string GetClanName( CSteamID steamIDClan ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetClanNameC>( this.Functions.GetClanName65 )( this.ObjectAddress, steamIDClan.ConvertToUint64() ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetClanTagC( IntPtr thisptr, UInt64 steamIDClan );
		public string GetClanTag( CSteamID steamIDClan ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetClanTagC>( this.Functions.GetClanTag66 )( this.ObjectAddress, steamIDClan.ConvertToUint64() ) ) ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetFriendActivityCountsIIB( IntPtr thisptr, ref Int32 pnOnline, ref Int32 pnInGame, [MarshalAs(UnmanagedType.I1)] bool bExcludeTaggedFriends );
		public bool GetFriendActivityCounts( ref Int32 pnOnline, ref Int32 pnInGame, bool bExcludeTaggedFriends ) 
		{
			return this.GetFunction<NativeGetFriendActivityCountsIIB>( this.Functions.GetFriendActivityCounts67 )( this.ObjectAddress, ref pnOnline, ref pnInGame, bExcludeTaggedFriends ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetClanActivityCountsCIII( IntPtr thisptr, UInt64 steamID, ref Int32 pnOnline, ref Int32 pnInGame, ref Int32 pnChatting );
		public bool GetClanActivityCounts( CSteamID steamID, ref Int32 pnOnline, ref Int32 pnInGame, ref Int32 pnChatting ) 
		{
			return this.GetFunction<NativeGetClanActivityCountsCIII>( this.Functions.GetClanActivityCounts68 )( this.ObjectAddress, steamID.ConvertToUint64(), ref pnOnline, ref pnInGame, ref pnChatting ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeDownloadClanActivityCountsCI( IntPtr thisptr, ref UInt64 groupIDs, Int32 nIds );
		public UInt64 DownloadClanActivityCounts( ref CSteamID groupIDs, Int32 nIds ) 
		{
			UInt64 s0 = 0; var result = this.GetFunction<NativeDownloadClanActivityCountsCI>( this.Functions.DownloadClanActivityCounts69 )( this.ObjectAddress, ref s0, nIds ); groupIDs = new CSteamID(s0); return result;
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetFriendsGroupActivityCountsIII( IntPtr thisptr, Int16 iGroupID, ref Int32 pnOnline, ref Int32 pnInGame );
		public bool GetFriendsGroupActivityCounts( Int16 iGroupID, ref Int32 pnOnline, ref Int32 pnInGame ) 
		{
			return this.GetFunction<NativeGetFriendsGroupActivityCountsIII>( this.Functions.GetFriendsGroupActivityCounts70 )( this.ObjectAddress, iGroupID, ref pnOnline, ref pnInGame ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsClanPublicC( IntPtr thisptr, UInt64 steamID );
		public bool IsClanPublic( CSteamID steamID ) 
		{
			return this.GetFunction<NativeIsClanPublicC>( this.Functions.IsClanPublic71 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeJoinClanChatRoomC( IntPtr thisptr, UInt64 groupID );
		public UInt64 JoinClanChatRoom( CSteamID groupID ) 
		{
			return this.GetFunction<NativeJoinClanChatRoomC>( this.Functions.JoinClanChatRoom72 )( this.ObjectAddress, groupID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeLeaveClanChatRoomC( IntPtr thisptr, UInt64 groupID );
		public bool LeaveClanChatRoom( CSteamID groupID ) 
		{
			return this.GetFunction<NativeLeaveClanChatRoomC>( this.Functions.LeaveClanChatRoom73 )( this.ObjectAddress, groupID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetClanChatMemberCountC( IntPtr thisptr, UInt64 groupID );
		public Int32 GetClanChatMemberCount( CSteamID groupID ) 
		{
			return this.GetFunction<NativeGetClanChatMemberCountC>( this.Functions.GetClanChatMemberCount74 )( this.ObjectAddress, groupID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetChatMemberByIndexCI( IntPtr thisptr, ref UInt64 retarg, UInt64 groupID, Int32 iIndex );
		public CSteamID GetChatMemberByIndex( CSteamID groupID, Int32 iIndex ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetChatMemberByIndexCI>( this.Functions.GetChatMemberByIndex75 )( this.ObjectAddress, ref ret, groupID.ConvertToUint64(), iIndex ); return new CSteamID(ret);
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSendClanChatMessageCS( IntPtr thisptr, UInt64 groupID, string cszMessage );
		public bool SendClanChatMessage( CSteamID groupID, string cszMessage ) 
		{
			return this.GetFunction<NativeSendClanChatMessageCS>( this.Functions.SendClanChatMessage76 )( this.ObjectAddress, groupID.ConvertToUint64(), cszMessage ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetClanChatMessageCIBIEC( IntPtr thisptr, UInt64 groupID, Int32 iChatID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType, ref UInt64 pSteamIDChatter );
		public Int32 GetClanChatMessage( CSteamID groupID, Int32 iChatID, Byte[] pvData, ref EChatEntryType peChatEntryType, ref CSteamID pSteamIDChatter ) 
		{
			UInt64 s0 = 0; var result = this.GetFunction<NativeGetClanChatMessageCIBIEC>( this.Functions.GetClanChatMessage77 )( this.ObjectAddress, groupID.ConvertToUint64(), iChatID, pvData, (Int32) pvData.Length, ref peChatEntryType, ref s0 ); pSteamIDChatter = new CSteamID(s0); return result;
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsClanChatAdminCC( IntPtr thisptr, UInt64 groupID, UInt64 userID );
		public bool IsClanChatAdmin( CSteamID groupID, CSteamID userID ) 
		{
			return this.GetFunction<NativeIsClanChatAdminCC>( this.Functions.IsClanChatAdmin78 )( this.ObjectAddress, groupID.ConvertToUint64(), userID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsClanChatWindowOpenInSteamC( IntPtr thisptr, UInt64 groupID );
		public bool IsClanChatWindowOpenInSteam( CSteamID groupID ) 
		{
			return this.GetFunction<NativeIsClanChatWindowOpenInSteamC>( this.Functions.IsClanChatWindowOpenInSteam79 )( this.ObjectAddress, groupID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeOpenClanChatWindowInSteamC( IntPtr thisptr, UInt64 groupID );
		public bool OpenClanChatWindowInSteam( CSteamID groupID ) 
		{
			return this.GetFunction<NativeOpenClanChatWindowInSteamC>( this.Functions.OpenClanChatWindowInSteam80 )( this.ObjectAddress, groupID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeCloseClanChatWindowInSteamC( IntPtr thisptr, UInt64 groupID );
		public bool CloseClanChatWindowInSteam( CSteamID groupID ) 
		{
			return this.GetFunction<NativeCloseClanChatWindowInSteamC>( this.Functions.CloseClanChatWindowInSteam81 )( this.ObjectAddress, groupID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetListenForFriendsMessagesB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bListen );
		public bool SetListenForFriendsMessages( bool bListen ) 
		{
			return this.GetFunction<NativeSetListenForFriendsMessagesB>( this.Functions.SetListenForFriendsMessages82 )( this.ObjectAddress, bListen ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeReplyToFriendMessageCS( IntPtr thisptr, UInt64 friendID, string cszMessage );
		public bool ReplyToFriendMessage( CSteamID friendID, string cszMessage ) 
		{
			return this.GetFunction<NativeReplyToFriendMessageCS>( this.Functions.ReplyToFriendMessage83 )( this.ObjectAddress, friendID.ConvertToUint64(), cszMessage ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetFriendMessageCIBIE( IntPtr thisptr, UInt64 friendID, Int32 iChatID, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType );
		public Int32 GetFriendMessage( CSteamID friendID, Int32 iChatID, Byte[] pvData, ref EChatEntryType peChatEntryType ) 
		{
			return this.GetFunction<NativeGetFriendMessageCIBIE>( this.Functions.GetFriendMessage84 )( this.ObjectAddress, friendID.ConvertToUint64(), iChatID, pvData, (Int32) pvData.Length, ref peChatEntryType ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeInviteFriendToClanCC( IntPtr thisptr, UInt64 steamIDfriend, UInt64 steamIDclan );
		public bool InviteFriendToClan( CSteamID steamIDfriend, CSteamID steamIDclan ) 
		{
			return this.GetFunction<NativeInviteFriendToClanCC>( this.Functions.InviteFriendToClan85 )( this.ObjectAddress, steamIDfriend.ConvertToUint64(), steamIDclan.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeAcknowledgeInviteToClanCB( IntPtr thisptr, UInt64 steamID, [MarshalAs(UnmanagedType.I1)] bool bAcceptOrDenyClanInvite );
		public bool AcknowledgeInviteToClan( CSteamID steamID, bool bAcceptOrDenyClanInvite ) 
		{
			return this.GetFunction<NativeAcknowledgeInviteToClanCB>( this.Functions.AcknowledgeInviteToClan86 )( this.ObjectAddress, steamID.ConvertToUint64(), bAcceptOrDenyClanInvite ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetFriendCountFromSourceC( IntPtr thisptr, UInt64 steamIDSource );
		public Int32 GetFriendCountFromSource( CSteamID steamIDSource ) 
		{
			return this.GetFunction<NativeGetFriendCountFromSourceC>( this.Functions.GetFriendCountFromSource87 )( this.ObjectAddress, steamIDSource.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetFriendFromSourceByIndexCI( IntPtr thisptr, ref UInt64 retarg, UInt64 steamIDSource, Int32 iFriend );
		public CSteamID GetFriendFromSourceByIndex( CSteamID steamIDSource, Int32 iFriend ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetFriendFromSourceByIndexCI>( this.Functions.GetFriendFromSourceByIndex88 )( this.ObjectAddress, ref ret, steamIDSource.ConvertToUint64(), iFriend ); return new CSteamID(ret);
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsUserInSourceCC( IntPtr thisptr, UInt64 steamIDUser, UInt64 steamIDSource );
		public bool IsUserInSource( CSteamID steamIDUser, CSteamID steamIDSource ) 
		{
			return this.GetFunction<NativeIsUserInSourceCC>( this.Functions.IsUserInSource89 )( this.ObjectAddress, steamIDUser.ConvertToUint64(), steamIDSource.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetCoplayFriendCount( IntPtr thisptr );
		public Int32 GetCoplayFriendCount(  ) 
		{
			return this.GetFunction<NativeGetCoplayFriendCount>( this.Functions.GetCoplayFriendCount90 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetCoplayFriendI( IntPtr thisptr, ref UInt64 retarg, Int32 iCoplayEvent );
		public CSteamID GetCoplayFriend( Int32 iCoplayEvent ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetCoplayFriendI>( this.Functions.GetCoplayFriend91 )( this.ObjectAddress, ref ret, iCoplayEvent ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendCoplayTimeC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt32 GetFriendCoplayTime( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendCoplayTimeC>( this.Functions.GetFriendCoplayTime92 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendCoplayGameC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt32 GetFriendCoplayGame( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendCoplayGameC>( this.Functions.GetFriendCoplayGame93 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetRichPresenceUSS( IntPtr thisptr, UInt32 nAppId, string pchKey, string pchValue );
		public bool SetRichPresence( UInt32 nAppId, string pchKey, string pchValue ) 
		{
			return this.GetFunction<NativeSetRichPresenceUSS>( this.Functions.SetRichPresence94 )( this.ObjectAddress, nAppId, pchKey, pchValue ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeClearRichPresenceU( IntPtr thisptr, UInt32 nAppId );
		public void ClearRichPresence( UInt32 nAppId ) 
		{
			this.GetFunction<NativeClearRichPresenceU>( this.Functions.ClearRichPresence95 )( this.ObjectAddress, nAppId ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendRichPresenceUCS( IntPtr thisptr, UInt32 nAppId, UInt64 steamIDFriend, string pchKey );
		public string GetFriendRichPresence( UInt32 nAppId, CSteamID steamIDFriend, string pchKey ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendRichPresenceUCS>( this.Functions.GetFriendRichPresence96 )( this.ObjectAddress, nAppId, steamIDFriend.ConvertToUint64(), pchKey ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetFriendRichPresenceKeyCountUC( IntPtr thisptr, UInt32 nAppId, UInt64 steamIDFriend );
		public Int32 GetFriendRichPresenceKeyCount( UInt32 nAppId, CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendRichPresenceKeyCountUC>( this.Functions.GetFriendRichPresenceKeyCount97 )( this.ObjectAddress, nAppId, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendRichPresenceKeyByIndexUCI( IntPtr thisptr, UInt32 nAppId, UInt64 steamIDFriend, Int32 iIndex );
		public string GetFriendRichPresenceKeyByIndex( UInt32 nAppId, CSteamID steamIDFriend, Int32 iIndex ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendRichPresenceKeyByIndexUCI>( this.Functions.GetFriendRichPresenceKeyByIndex98 )( this.ObjectAddress, nAppId, steamIDFriend.ConvertToUint64(), iIndex ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeRequestFriendRichPresenceUC( IntPtr thisptr, UInt32 nAppId, UInt64 steamIDFriend );
		public void RequestFriendRichPresence( UInt32 nAppId, CSteamID steamIDFriend ) 
		{
			this.GetFunction<NativeRequestFriendRichPresenceUC>( this.Functions.RequestFriendRichPresence99 )( this.ObjectAddress, nAppId, steamIDFriend.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeJoinChatRoomC( IntPtr thisptr, UInt64 steamIDChat );
		public bool JoinChatRoom( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeJoinChatRoomC>( this.Functions.JoinChatRoom100 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeLeaveChatRoomC( IntPtr thisptr, UInt64 steamIDChat );
		public void LeaveChatRoom( CSteamID steamIDChat ) 
		{
			this.GetFunction<NativeLeaveChatRoomC>( this.Functions.LeaveChatRoom101 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeInviteUserToChatRoomCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDInvitee );
		public bool InviteUserToChatRoom( CSteamID steamIDChat, CSteamID steamIDInvitee ) 
		{
			return this.GetFunction<NativeInviteUserToChatRoomCC>( this.Functions.InviteUserToChatRoom102 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDInvitee.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSendChatMsgCEBI( IntPtr thisptr, UInt64 steamIDChat, EChatEntryType eChatEntryType, Byte[] pvMsgBody, Int32 cubMsgBody );
		public bool SendChatMsg( CSteamID steamIDChat, EChatEntryType eChatEntryType, Byte[] pvMsgBody ) 
		{
			return this.GetFunction<NativeSendChatMsgCEBI>( this.Functions.SendChatMsg103 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), eChatEntryType, pvMsgBody, (Int32) pvMsgBody.Length ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetChatRoomMessagesCountC( IntPtr thisptr, UInt64 steamIDChat );
		public Int32 GetChatRoomMessagesCount( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeGetChatRoomMessagesCountC>( this.Functions.GetChatRoomMessagesCount104 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetChatRoomEntryCICBIE( IntPtr thisptr, UInt64 steamIDChat, Int32 iChatID, ref UInt64 steamIDuser, Byte[] pvData, Int32 cubData, ref EChatEntryType peChatEntryType );
		public Int32 GetChatRoomEntry( CSteamID steamIDChat, Int32 iChatID, ref CSteamID steamIDuser, Byte[] pvData, ref EChatEntryType peChatEntryType ) 
		{
			UInt64 s0 = 0; var result = this.GetFunction<NativeGetChatRoomEntryCICBIE>( this.Functions.GetChatRoomEntry105 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), iChatID, ref s0, pvData, (Int32) pvData.Length, ref peChatEntryType ); steamIDuser = new CSteamID(s0); return result;
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeClearChatRoomHistoryC( IntPtr thisptr, UInt64 steamID );
		public void ClearChatRoomHistory( CSteamID steamID ) 
		{
			this.GetFunction<NativeClearChatRoomHistoryC>( this.Functions.ClearChatRoomHistory106 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSerializeChatRoomDlgCBI( IntPtr thisptr, UInt64 steamIDChat, Byte[] pvHistory, Int32 cubHistory );
		public bool SerializeChatRoomDlg( CSteamID steamIDChat, Byte[] pvHistory ) 
		{
			return this.GetFunction<NativeSerializeChatRoomDlgCBI>( this.Functions.SerializeChatRoomDlg107 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), pvHistory, (Int32) pvHistory.Length ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetSizeOfSerializedChatRoomDlgC( IntPtr thisptr, UInt64 steamIDChat );
		public Int32 GetSizeOfSerializedChatRoomDlg( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeGetSizeOfSerializedChatRoomDlgC>( this.Functions.GetSizeOfSerializedChatRoomDlg108 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetSerializedChatRoomDlgCBII( IntPtr thisptr, UInt64 steamIDChat, Byte[] pvHistory, Int32 cubBuffer, ref Int32 pcubData );
		public bool GetSerializedChatRoomDlg( CSteamID steamIDChat, Byte[] pvHistory, ref Int32 pcubData ) 
		{
			return this.GetFunction<NativeGetSerializedChatRoomDlgCBII>( this.Functions.GetSerializedChatRoomDlg109 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), pvHistory, (Int32) pvHistory.Length, ref pcubData ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeClearSerializedChatRoomDlgC( IntPtr thisptr, UInt64 steamIDChat );
		public bool ClearSerializedChatRoomDlg( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeClearSerializedChatRoomDlgC>( this.Functions.ClearSerializedChatRoomDlg110 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeKickChatMemberCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDUserToActOn );
		public bool KickChatMember( CSteamID steamIDChat, CSteamID steamIDUserToActOn ) 
		{
			return this.GetFunction<NativeKickChatMemberCC>( this.Functions.KickChatMember111 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDUserToActOn.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBanChatMemberCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDUserToActOn );
		public bool BanChatMember( CSteamID steamIDChat, CSteamID steamIDUserToActOn ) 
		{
			return this.GetFunction<NativeBanChatMemberCC>( this.Functions.BanChatMember112 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDUserToActOn.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeUnBanChatMemberCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDUserToActOn );
		public bool UnBanChatMember( CSteamID steamIDChat, CSteamID steamIDUserToActOn ) 
		{
			return this.GetFunction<NativeUnBanChatMemberCC>( this.Functions.UnBanChatMember113 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDUserToActOn.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetChatRoomTypeCE( IntPtr thisptr, UInt64 steamIDChat, ELobbyType eLobbyType );
		public bool SetChatRoomType( CSteamID steamIDChat, ELobbyType eLobbyType ) 
		{
			return this.GetFunction<NativeSetChatRoomTypeCE>( this.Functions.SetChatRoomType114 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), eLobbyType ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetChatRoomLockStateCB( IntPtr thisptr, UInt64 steamIDChat, ref bool pbLocked );
		public bool GetChatRoomLockState( CSteamID steamIDChat, ref bool pbLocked ) 
		{
			return this.GetFunction<NativeGetChatRoomLockStateCB>( this.Functions.GetChatRoomLockState115 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), ref pbLocked ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetChatRoomPermissionsCU( IntPtr thisptr, UInt64 steamIDChat, ref UInt32 prgfChatRoomPermissions );
		public bool GetChatRoomPermissions( CSteamID steamIDChat, ref UInt32 prgfChatRoomPermissions ) 
		{
			return this.GetFunction<NativeGetChatRoomPermissionsCU>( this.Functions.GetChatRoomPermissions116 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), ref prgfChatRoomPermissions ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetChatRoomModeratedCB( IntPtr thisptr, UInt64 steamIDChat, [MarshalAs(UnmanagedType.I1)] bool bModerated );
		public bool SetChatRoomModerated( CSteamID steamIDChat, bool bModerated ) 
		{
			return this.GetFunction<NativeSetChatRoomModeratedCB>( this.Functions.SetChatRoomModerated117 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), bModerated ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBChatRoomModeratedC( IntPtr thisptr, UInt64 steamIDChat );
		public bool BChatRoomModerated( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeBChatRoomModeratedC>( this.Functions.BChatRoomModerated118 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeNotifyChatRoomDlgsOfUIChangeCBBBB( IntPtr thisptr, UInt64 steamIDChat, [MarshalAs(UnmanagedType.I1)] bool bShowAvatars, [MarshalAs(UnmanagedType.I1)] bool bBeepOnNewMsg, [MarshalAs(UnmanagedType.I1)] bool bShowSteamIDs, [MarshalAs(UnmanagedType.I1)] bool bShowTimestampOnNewMsg );
		public bool NotifyChatRoomDlgsOfUIChange( CSteamID steamIDChat, bool bShowAvatars, bool bBeepOnNewMsg, bool bShowSteamIDs, bool bShowTimestampOnNewMsg ) 
		{
			return this.GetFunction<NativeNotifyChatRoomDlgsOfUIChangeCBBBB>( this.Functions.NotifyChatRoomDlgsOfUIChange119 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), bShowAvatars, bBeepOnNewMsg, bShowSteamIDs, bShowTimestampOnNewMsg ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeTerminateChatRoomC( IntPtr thisptr, UInt64 steamIDChat );
		public bool TerminateChatRoom( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeTerminateChatRoomC>( this.Functions.TerminateChatRoom120 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetChatRoomCount( IntPtr thisptr );
		public Int32 GetChatRoomCount(  ) 
		{
			return this.GetFunction<NativeGetChatRoomCount>( this.Functions.GetChatRoomCount121 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetChatRoomByIndexI( IntPtr thisptr, ref UInt64 retarg, Int32 iChatRoom );
		public CSteamID GetChatRoomByIndex( Int32 iChatRoom ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetChatRoomByIndexI>( this.Functions.GetChatRoomByIndex122 )( this.ObjectAddress, ref ret, iChatRoom ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetChatRoomNameC( IntPtr thisptr, UInt64 steamIDChat );
		public string GetChatRoomName( CSteamID steamIDChat ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetChatRoomNameC>( this.Functions.GetChatRoomName123 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ) ) ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBGetChatRoomMemberDetailsCCUU( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDUser, ref UInt32 prgfChatMemberDetails, ref UInt32 prgfChatMemberDetailsLocal );
		public bool BGetChatRoomMemberDetails( CSteamID steamIDChat, CSteamID steamIDUser, ref UInt32 prgfChatMemberDetails, ref UInt32 prgfChatMemberDetailsLocal ) 
		{
			return this.GetFunction<NativeBGetChatRoomMemberDetailsCCUU>( this.Functions.BGetChatRoomMemberDetails124 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDUser.ConvertToUint64(), ref prgfChatMemberDetails, ref prgfChatMemberDetailsLocal ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeCreateChatRoomEUSECCCUUU( IntPtr thisptr, EChatRoomType eType, UInt64 ulGameID, string pchName, ELobbyType eLobbyType, UInt64 steamIDClan, UInt64 steamIDFriendChat, UInt64 steamIDInvited, UInt32 rgfChatPermissionOfficer, UInt32 rgfChatPermissionMember, UInt32 rgfChatPermissionAll );
		public void CreateChatRoom( EChatRoomType eType, UInt64 ulGameID, string pchName, ELobbyType eLobbyType, CSteamID steamIDClan, CSteamID steamIDFriendChat, CSteamID steamIDInvited, UInt32 rgfChatPermissionOfficer, UInt32 rgfChatPermissionMember, UInt32 rgfChatPermissionAll ) 
		{
			this.GetFunction<NativeCreateChatRoomEUSECCCUUU>( this.Functions.CreateChatRoom125 )( this.ObjectAddress, eType, ulGameID, pchName, eLobbyType, steamIDClan.ConvertToUint64(), steamIDFriendChat.ConvertToUint64(), steamIDInvited.ConvertToUint64(), rgfChatPermissionOfficer, rgfChatPermissionMember, rgfChatPermissionAll ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeVoiceCallNewCC( IntPtr thisptr, UInt64 steamIDLocalPeer, UInt64 steamIDRemotePeer );
		public void VoiceCallNew( CSteamID steamIDLocalPeer, CSteamID steamIDRemotePeer ) 
		{
			this.GetFunction<NativeVoiceCallNewCC>( this.Functions.VoiceCallNew126 )( this.ObjectAddress, steamIDLocalPeer.ConvertToUint64(), steamIDRemotePeer.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeVoiceCallCC( IntPtr thisptr, UInt64 steamIDLocalPeer, UInt64 steamIDRemotePeer );
		public void VoiceCall( CSteamID steamIDLocalPeer, CSteamID steamIDRemotePeer ) 
		{
			this.GetFunction<NativeVoiceCallCC>( this.Functions.VoiceCall127 )( this.ObjectAddress, steamIDLocalPeer.ConvertToUint64(), steamIDRemotePeer.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeVoiceHangUpCI( IntPtr thisptr, UInt64 steamIDLocalPeer, Int32 hVoiceCall );
		public void VoiceHangUp( CSteamID steamIDLocalPeer, Int32 hVoiceCall ) 
		{
			this.GetFunction<NativeVoiceHangUpCI>( this.Functions.VoiceHangUp128 )( this.ObjectAddress, steamIDLocalPeer.ConvertToUint64(), hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetVoiceSpeakerVolumeF( IntPtr thisptr, float flVolume );
		public void SetVoiceSpeakerVolume( float flVolume ) 
		{
			this.GetFunction<NativeSetVoiceSpeakerVolumeF>( this.Functions.SetVoiceSpeakerVolume129 )( this.ObjectAddress, flVolume ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetVoiceMicrophoneVolumeF( IntPtr thisptr, float flVolume );
		public void SetVoiceMicrophoneVolume( float flVolume ) 
		{
			this.GetFunction<NativeSetVoiceMicrophoneVolumeF>( this.Functions.SetVoiceMicrophoneVolume130 )( this.ObjectAddress, flVolume ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetAutoAnswerB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bAutoAnswer );
		public void SetAutoAnswer( bool bAutoAnswer ) 
		{
			this.GetFunction<NativeSetAutoAnswerB>( this.Functions.SetAutoAnswer131 )( this.ObjectAddress, bAutoAnswer ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeVoiceAnswerI( IntPtr thisptr, Int32 hVoiceCall );
		public void VoiceAnswer( Int32 hVoiceCall ) 
		{
			this.GetFunction<NativeVoiceAnswerI>( this.Functions.VoiceAnswer132 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeAcceptVoiceCallCC( IntPtr thisptr, UInt64 steamIDLocalPeer, UInt64 steamIDRemotePeer );
		public void AcceptVoiceCall( CSteamID steamIDLocalPeer, CSteamID steamIDRemotePeer ) 
		{
			this.GetFunction<NativeAcceptVoiceCallCC>( this.Functions.AcceptVoiceCall133 )( this.ObjectAddress, steamIDLocalPeer.ConvertToUint64(), steamIDRemotePeer.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeVoicePutOnHoldIB( IntPtr thisptr, Int32 HVoiceCall, [MarshalAs(UnmanagedType.I1)] bool bLocalHold );
		public void VoicePutOnHold( Int32 HVoiceCall, bool bLocalHold ) 
		{
			this.GetFunction<NativeVoicePutOnHoldIB>( this.Functions.VoicePutOnHold134 )( this.ObjectAddress, HVoiceCall, bLocalHold ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBVoiceIsLocalOnHoldI( IntPtr thisptr, Int32 hVoiceCall );
		public bool BVoiceIsLocalOnHold( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeBVoiceIsLocalOnHoldI>( this.Functions.BVoiceIsLocalOnHold135 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBVoiceIsRemoteOnHoldI( IntPtr thisptr, Int32 hVoiceCall );
		public bool BVoiceIsRemoteOnHold( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeBVoiceIsRemoteOnHoldI>( this.Functions.BVoiceIsRemoteOnHold136 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetDoNotDisturbB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bDoNotDisturb );
		public void SetDoNotDisturb( bool bDoNotDisturb ) 
		{
			this.GetFunction<NativeSetDoNotDisturbB>( this.Functions.SetDoNotDisturb137 )( this.ObjectAddress, bDoNotDisturb ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeEnableVoiceNotificationSoundsB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bEnable );
		public void EnableVoiceNotificationSounds( bool bEnable ) 
		{
			this.GetFunction<NativeEnableVoiceNotificationSoundsB>( this.Functions.EnableVoiceNotificationSounds138 )( this.ObjectAddress, bEnable ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetPushToTalkEnabledB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bEnable );
		public void SetPushToTalkEnabled( bool bEnable ) 
		{
			this.GetFunction<NativeSetPushToTalkEnabledB>( this.Functions.SetPushToTalkEnabled139 )( this.ObjectAddress, bEnable ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsPushToTalkEnabled( IntPtr thisptr );
		public bool IsPushToTalkEnabled(  ) 
		{
			return this.GetFunction<NativeIsPushToTalkEnabled>( this.Functions.IsPushToTalkEnabled140 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetPushToTalkKeyI( IntPtr thisptr, Int32 nVirtualKey );
		public void SetPushToTalkKey( Int32 nVirtualKey ) 
		{
			this.GetFunction<NativeSetPushToTalkKeyI>( this.Functions.SetPushToTalkKey141 )( this.ObjectAddress, nVirtualKey ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetPushToTalkKey( IntPtr thisptr );
		public Int32 GetPushToTalkKey(  ) 
		{
			return this.GetFunction<NativeGetPushToTalkKey>( this.Functions.GetPushToTalkKey142 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsPushToTalkKeyDown( IntPtr thisptr );
		public bool IsPushToTalkKeyDown(  ) 
		{
			return this.GetFunction<NativeIsPushToTalkKeyDown>( this.Functions.IsPushToTalkKeyDown143 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeEnableVoiceCalibrationB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bState );
		public void EnableVoiceCalibration( bool bState ) 
		{
			this.GetFunction<NativeEnableVoiceCalibrationB>( this.Functions.EnableVoiceCalibration144 )( this.ObjectAddress, bState ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsVoiceCalibrating( IntPtr thisptr );
		public bool IsVoiceCalibrating(  ) 
		{
			return this.GetFunction<NativeIsVoiceCalibrating>( this.Functions.IsVoiceCalibrating145 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeGetVoiceCalibrationSamplePeak( IntPtr thisptr );
		public float GetVoiceCalibrationSamplePeak(  ) 
		{
			return this.GetFunction<NativeGetVoiceCalibrationSamplePeak>( this.Functions.GetVoiceCalibrationSamplePeak146 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetMicBoostB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bBoost );
		public void SetMicBoost( bool bBoost ) 
		{
			this.GetFunction<NativeSetMicBoostB>( this.Functions.SetMicBoost147 )( this.ObjectAddress, bBoost ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetMicBoost( IntPtr thisptr );
		public bool GetMicBoost(  ) 
		{
			return this.GetFunction<NativeGetMicBoost>( this.Functions.GetMicBoost148 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeHasHardwareMicBoost( IntPtr thisptr );
		public bool HasHardwareMicBoost(  ) 
		{
			return this.GetFunction<NativeHasHardwareMicBoost>( this.Functions.HasHardwareMicBoost149 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetMicDeviceName( IntPtr thisptr );
		public string GetMicDeviceName(  ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetMicDeviceName>( this.Functions.GetMicDeviceName150 )( this.ObjectAddress ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeStartTalkingI( IntPtr thisptr, Int32 hVoiceCall );
		public void StartTalking( Int32 hVoiceCall ) 
		{
			this.GetFunction<NativeStartTalkingI>( this.Functions.StartTalking151 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeEndTalkingI( IntPtr thisptr, Int32 hVoiceCall );
		public void EndTalking( Int32 hVoiceCall ) 
		{
			this.GetFunction<NativeEndTalkingI>( this.Functions.EndTalking152 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeVoiceIsValidI( IntPtr thisptr, Int32 hVoiceCall );
		public bool VoiceIsValid( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeVoiceIsValidI>( this.Functions.VoiceIsValid153 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetAutoReflectVoiceB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bState );
		public void SetAutoReflectVoice( bool bState ) 
		{
			this.GetFunction<NativeSetAutoReflectVoiceB>( this.Functions.SetAutoReflectVoice154 )( this.ObjectAddress, bState ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate ECallState NativeGetCallStateI( IntPtr thisptr, Int32 hVoiceCall );
		public ECallState GetCallState( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeGetCallStateI>( this.Functions.GetCallState155 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeGetVoiceMicrophoneVolume( IntPtr thisptr );
		public float GetVoiceMicrophoneVolume(  ) 
		{
			return this.GetFunction<NativeGetVoiceMicrophoneVolume>( this.Functions.GetVoiceMicrophoneVolume156 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeGetVoiceSpeakerVolume( IntPtr thisptr );
		public float GetVoiceSpeakerVolume(  ) 
		{
			return this.GetFunction<NativeGetVoiceSpeakerVolume>( this.Functions.GetVoiceSpeakerVolume157 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeTimeSinceLastVoiceDataReceivedI( IntPtr thisptr, Int32 hVoiceCall );
		public float TimeSinceLastVoiceDataReceived( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeTimeSinceLastVoiceDataReceivedI>( this.Functions.TimeSinceLastVoiceDataReceived158 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeTimeSinceLastVoiceDataSendI( IntPtr thisptr, Int32 hVoiceCall );
		public float TimeSinceLastVoiceDataSend( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeTimeSinceLastVoiceDataSendI>( this.Functions.TimeSinceLastVoiceDataSend159 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBCanSendI( IntPtr thisptr, Int32 hVoiceCall );
		public bool BCanSend( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeBCanSendI>( this.Functions.BCanSend160 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBCanReceiveI( IntPtr thisptr, Int32 hVoiceCall );
		public bool BCanReceive( Int32 hVoiceCall ) 
		{
			return this.GetFunction<NativeBCanReceiveI>( this.Functions.BCanReceive161 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeGetEstimatedBitsPerSecondIB( IntPtr thisptr, Int32 hVoiceCall, [MarshalAs(UnmanagedType.I1)] bool bIncoming );
		public float GetEstimatedBitsPerSecond( Int32 hVoiceCall, bool bIncoming ) 
		{
			return this.GetFunction<NativeGetEstimatedBitsPerSecondIB>( this.Functions.GetEstimatedBitsPerSecond162 )( this.ObjectAddress, hVoiceCall, bIncoming ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeGetPeakSampleIB( IntPtr thisptr, Int32 hVoiceCall, [MarshalAs(UnmanagedType.I1)] bool bIncoming );
		public float GetPeakSample( Int32 hVoiceCall, bool bIncoming ) 
		{
			return this.GetFunction<NativeGetPeakSampleIB>( this.Functions.GetPeakSample163 )( this.ObjectAddress, hVoiceCall, bIncoming ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSendResumeRequestI( IntPtr thisptr, Int32 hVoiceCall );
		public void SendResumeRequest( Int32 hVoiceCall ) 
		{
			this.GetFunction<NativeSendResumeRequestI>( this.Functions.SendResumeRequest164 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeOpenChatDialogC( IntPtr thisptr, UInt64 steamID );
		public void OpenChatDialog( CSteamID steamID ) 
		{
			this.GetFunction<NativeOpenChatDialogC>( this.Functions.OpenChatDialog165 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeStartChatRoomVoiceSpeakingCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDMember );
		public void StartChatRoomVoiceSpeaking( CSteamID steamIDChat, CSteamID steamIDMember ) 
		{
			this.GetFunction<NativeStartChatRoomVoiceSpeakingCC>( this.Functions.StartChatRoomVoiceSpeaking166 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDMember.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeEndChatRoomVoiceSpeakingCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDMember );
		public void EndChatRoomVoiceSpeaking( CSteamID steamIDChat, CSteamID steamIDMember ) 
		{
			this.GetFunction<NativeEndChatRoomVoiceSpeakingCC>( this.Functions.EndChatRoomVoiceSpeaking167 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDMember.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendLastLogonTimeC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt32 GetFriendLastLogonTime( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendLastLogonTimeC>( this.Functions.GetFriendLastLogonTime168 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendLastLogoffTimeC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt32 GetFriendLastLogoffTime( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendLastLogoffTimeC>( this.Functions.GetFriendLastLogoffTime169 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetChatRoomVoiceTotalSlotCountC( IntPtr thisptr, UInt64 steamIDChat );
		public Int32 GetChatRoomVoiceTotalSlotCount( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeGetChatRoomVoiceTotalSlotCountC>( this.Functions.GetChatRoomVoiceTotalSlotCount170 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetChatRoomVoiceUsedSlotCountC( IntPtr thisptr, UInt64 steamIDChat );
		public Int32 GetChatRoomVoiceUsedSlotCount( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeGetChatRoomVoiceUsedSlotCountC>( this.Functions.GetChatRoomVoiceUsedSlotCount171 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetChatRoomVoiceUsedSlotCI( IntPtr thisptr, ref UInt64 retarg, UInt64 steamIDChat, Int32 iSlot );
		public CSteamID GetChatRoomVoiceUsedSlot( CSteamID steamIDChat, Int32 iSlot ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetChatRoomVoiceUsedSlotCI>( this.Functions.GetChatRoomVoiceUsedSlot172 )( this.ObjectAddress, ref ret, steamIDChat.ConvertToUint64(), iSlot ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EChatRoomVoiceStatus NativeGetChatRoomVoiceStatusCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDSpeaker );
		public EChatRoomVoiceStatus GetChatRoomVoiceStatus( CSteamID steamIDChat, CSteamID steamIDSpeaker ) 
		{
			return this.GetFunction<NativeGetChatRoomVoiceStatusCC>( this.Functions.GetChatRoomVoiceStatus173 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDSpeaker.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBChatRoomHasAvailableVoiceSlotsC( IntPtr thisptr, UInt64 steamIDChat );
		public bool BChatRoomHasAvailableVoiceSlots( CSteamID steamIDChat ) 
		{
			return this.GetFunction<NativeBChatRoomHasAvailableVoiceSlotsC>( this.Functions.BChatRoomHasAvailableVoiceSlots174 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBIsChatRoomVoiceSpeakingCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDSpeaker );
		public bool BIsChatRoomVoiceSpeaking( CSteamID steamIDChat, CSteamID steamIDSpeaker ) 
		{
			return this.GetFunction<NativeBIsChatRoomVoiceSpeakingCC>( this.Functions.BIsChatRoomVoiceSpeaking175 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDSpeaker.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate float NativeGetChatRoomPeakSampleCCB( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDSpeaker, [MarshalAs(UnmanagedType.I1)] bool bIncoming );
		public float GetChatRoomPeakSample( CSteamID steamIDChat, CSteamID steamIDSpeaker, bool bIncoming ) 
		{
			return this.GetFunction<NativeGetChatRoomPeakSampleCCB>( this.Functions.GetChatRoomPeakSample176 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDSpeaker.ConvertToUint64(), bIncoming ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeChatRoomVoiceRetryConnectionsC( IntPtr thisptr, UInt64 steamIDChat );
		public void ChatRoomVoiceRetryConnections( CSteamID steamIDChat ) 
		{
			this.GetFunction<NativeChatRoomVoiceRetryConnectionsC>( this.Functions.ChatRoomVoiceRetryConnections177 )( this.ObjectAddress, steamIDChat.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetPortTypesU( IntPtr thisptr, UInt32 unFlags );
		public void SetPortTypes( UInt32 unFlags ) 
		{
			this.GetFunction<NativeSetPortTypesU>( this.Functions.SetPortTypes178 )( this.ObjectAddress, unFlags ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeReinitAudio( IntPtr thisptr );
		public void ReinitAudio(  ) 
		{
			this.GetFunction<NativeReinitAudio>( this.Functions.ReinitAudio179 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetInGameVoiceSpeakingCB( IntPtr thisptr, UInt64 steamIDUser, [MarshalAs(UnmanagedType.I1)] bool bSpeaking );
		public void SetInGameVoiceSpeaking( CSteamID steamIDUser, bool bSpeaking ) 
		{
			this.GetFunction<NativeSetInGameVoiceSpeakingCB>( this.Functions.SetInGameVoiceSpeaking180 )( this.ObjectAddress, steamIDUser.ConvertToUint64(), bSpeaking ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsInGameVoiceSpeaking( IntPtr thisptr );
		public bool IsInGameVoiceSpeaking(  ) 
		{
			return this.GetFunction<NativeIsInGameVoiceSpeaking>( this.Functions.IsInGameVoiceSpeaking181 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeActivateGameOverlayS( IntPtr thisptr, string pchDialog );
		public void ActivateGameOverlay( string pchDialog ) 
		{
			this.GetFunction<NativeActivateGameOverlayS>( this.Functions.ActivateGameOverlay182 )( this.ObjectAddress, pchDialog ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeActivateGameOverlayToUserSC( IntPtr thisptr, string pchDialog, UInt64 steamID );
		public void ActivateGameOverlayToUser( string pchDialog, CSteamID steamID ) 
		{
			this.GetFunction<NativeActivateGameOverlayToUserSC>( this.Functions.ActivateGameOverlayToUser183 )( this.ObjectAddress, pchDialog, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeActivateGameOverlayToWebPageS( IntPtr thisptr, string pchURL );
		public void ActivateGameOverlayToWebPage( string pchURL ) 
		{
			this.GetFunction<NativeActivateGameOverlayToWebPageS>( this.Functions.ActivateGameOverlayToWebPage184 )( this.ObjectAddress, pchURL ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeActivateGameOverlayToStoreUE( IntPtr thisptr, UInt32 nAppId, EOverlayToStoreFlag eFlag );
		public void ActivateGameOverlayToStore( UInt32 nAppId, EOverlayToStoreFlag eFlag ) 
		{
			this.GetFunction<NativeActivateGameOverlayToStoreUE>( this.Functions.ActivateGameOverlayToStore185 )( this.ObjectAddress, nAppId, eFlag ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeActivateGameOverlayInviteDialogC( IntPtr thisptr, UInt64 steamIDLobby );
		public void ActivateGameOverlayInviteDialog( CSteamID steamIDLobby ) 
		{
			this.GetFunction<NativeActivateGameOverlayInviteDialogC>( this.Functions.ActivateGameOverlayInviteDialog186 )( this.ObjectAddress, steamIDLobby.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeNotifyGameOverlayStateChangedB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bActive );
		public void NotifyGameOverlayStateChanged( bool bActive ) 
		{
			this.GetFunction<NativeNotifyGameOverlayStateChangedB>( this.Functions.NotifyGameOverlayStateChanged187 )( this.ObjectAddress, bActive ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeNotifyGameServerChangeRequestedSS( IntPtr thisptr, string pchServerAddress, string pchPassword );
		public void NotifyGameServerChangeRequested( string pchServerAddress, string pchPassword ) 
		{
			this.GetFunction<NativeNotifyGameServerChangeRequestedSS>( this.Functions.NotifyGameServerChangeRequested188 )( this.ObjectAddress, pchServerAddress, pchPassword ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeNotifyLobbyJoinRequestedUCC( IntPtr thisptr, UInt32 nAppId, UInt64 steamIDLobby, UInt64 steamIDFriend );
		public bool NotifyLobbyJoinRequested( UInt32 nAppId, CSteamID steamIDLobby, CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeNotifyLobbyJoinRequestedUCC>( this.Functions.NotifyLobbyJoinRequested189 )( this.ObjectAddress, nAppId, steamIDLobby.ConvertToUint64(), steamIDFriend.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeNotifyRichPresenceJoinRequestedUCS( IntPtr thisptr, UInt32 nAppId, UInt64 steamIDFriend, string pchConnectString );
		public bool NotifyRichPresenceJoinRequested( UInt32 nAppId, CSteamID steamIDFriend, string pchConnectString ) 
		{
			return this.GetFunction<NativeNotifyRichPresenceJoinRequestedUCS>( this.Functions.NotifyRichPresenceJoinRequested190 )( this.ObjectAddress, nAppId, steamIDFriend.ConvertToUint64(), pchConnectString ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EClanRelationship NativeGetClanRelationshipC( IntPtr thisptr, UInt64 steamIDclan );
		public EClanRelationship GetClanRelationship( CSteamID steamIDclan ) 
		{
			return this.GetFunction<NativeGetClanRelationshipC>( this.Functions.GetClanRelationship191 )( this.ObjectAddress, steamIDclan.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EClanRank NativeGetFriendClanRankCC( IntPtr thisptr, UInt64 steamIDUser, UInt64 steamIDClan );
		public EClanRank GetFriendClanRank( CSteamID steamIDUser, CSteamID steamIDClan ) 
		{
			return this.GetFunction<NativeGetFriendClanRankCC>( this.Functions.GetFriendClanRank192 )( this.ObjectAddress, steamIDUser.ConvertToUint64(), steamIDClan.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeVoiceIsAvailable( IntPtr thisptr );
		public bool VoiceIsAvailable(  ) 
		{
			return this.GetFunction<NativeVoiceIsAvailable>( this.Functions.VoiceIsAvailable193 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeTestVoiceDisconnectI( IntPtr thisptr, Int32 hVoiceCall );
		public void TestVoiceDisconnect( Int32 hVoiceCall ) 
		{
			this.GetFunction<NativeTestVoiceDisconnectI>( this.Functions.TestVoiceDisconnect194 )( this.ObjectAddress, hVoiceCall ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeTestChatRoomPeerDisconnectCC( IntPtr thisptr, UInt64 steamIDChat, UInt64 steamIDSpeaker );
		public void TestChatRoomPeerDisconnect( CSteamID steamIDChat, CSteamID steamIDSpeaker ) 
		{
			this.GetFunction<NativeTestChatRoomPeerDisconnectCC>( this.Functions.TestChatRoomPeerDisconnect195 )( this.ObjectAddress, steamIDChat.ConvertToUint64(), steamIDSpeaker.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeTestVoicePacketLossF( IntPtr thisptr, float flFractionOfIncomingPacketsToDrop );
		public void TestVoicePacketLoss( float flFractionOfIncomingPacketsToDrop ) 
		{
			this.GetFunction<NativeTestVoicePacketLossF>( this.Functions.TestVoicePacketLoss196 )( this.ObjectAddress, flFractionOfIncomingPacketsToDrop ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeFindFriendVoiceChatHandleC( IntPtr thisptr, UInt64 steamIDFriend );
		public Int32 FindFriendVoiceChatHandle( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeFindFriendVoiceChatHandleC>( this.Functions.FindFriendVoiceChatHandle197 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeRequestFriendsWhoPlayGameC( IntPtr thisptr, UInt64 gameID );
		public void RequestFriendsWhoPlayGame( CGameID gameID ) 
		{
			this.GetFunction<NativeRequestFriendsWhoPlayGameC>( this.Functions.RequestFriendsWhoPlayGame198 )( this.ObjectAddress, gameID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetCountFriendsWhoPlayGameC( IntPtr thisptr, UInt64 gameID );
		public UInt32 GetCountFriendsWhoPlayGame( CGameID gameID ) 
		{
			return this.GetFunction<NativeGetCountFriendsWhoPlayGameC>( this.Functions.GetCountFriendsWhoPlayGame199 )( this.ObjectAddress, gameID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetFriendWhoPlaysGameUC( IntPtr thisptr, ref UInt64 retarg, UInt32 iIndex, UInt64 gameID );
		public CSteamID GetFriendWhoPlaysGame( UInt32 iIndex, CGameID gameID ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetFriendWhoPlaysGameUC>( this.Functions.GetFriendWhoPlaysGame200 )( this.ObjectAddress, ref ret, iIndex, gameID.ConvertToUint64() ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetPlayedWithC( IntPtr thisptr, UInt64 steamIDUserPlayedWith );
		public void SetPlayedWith( CSteamID steamIDUserPlayedWith ) 
		{
			this.GetFunction<NativeSetPlayedWithC>( this.Functions.SetPlayedWith201 )( this.ObjectAddress, steamIDUserPlayedWith.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeRequestClanOfficerListC( IntPtr thisptr, UInt64 steamIDClan );
		public UInt64 RequestClanOfficerList( CSteamID steamIDClan ) 
		{
			return this.GetFunction<NativeRequestClanOfficerListC>( this.Functions.RequestClanOfficerList202 )( this.ObjectAddress, steamIDClan.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetClanOwnerC( IntPtr thisptr, ref UInt64 retarg, UInt64 steamIDClan );
		public CSteamID GetClanOwner( CSteamID steamIDClan ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetClanOwnerC>( this.Functions.GetClanOwner203 )( this.ObjectAddress, ref ret, steamIDClan.ConvertToUint64() ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetClanOfficerCountC( IntPtr thisptr, UInt64 steamIDClan );
		public Int32 GetClanOfficerCount( CSteamID steamIDClan ) 
		{
			return this.GetFunction<NativeGetClanOfficerCountC>( this.Functions.GetClanOfficerCount204 )( this.ObjectAddress, steamIDClan.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeGetClanOfficerByIndexCI( IntPtr thisptr, ref UInt64 retarg, UInt64 steamIDClan, Int32 iOfficer );
		public CSteamID GetClanOfficerByIndex( CSteamID steamIDClan, Int32 iOfficer ) 
		{
			UInt64 ret = 0; this.GetFunction<NativeGetClanOfficerByIndexCI>( this.Functions.GetClanOfficerByIndex205 )( this.ObjectAddress, ref ret, steamIDClan.ConvertToUint64(), iOfficer ); return new CSteamID(ret);
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EUserRestriction NativeGetUserRestrictions( IntPtr thisptr );
		public EUserRestriction GetUserRestrictions(  ) 
		{
			return this.GetFunction<NativeGetUserRestrictions>( this.Functions.GetUserRestrictions206 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeRequestFriendProfileInfoC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt64 RequestFriendProfileInfo( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeRequestFriendProfileInfoC>( this.Functions.RequestFriendProfileInfo207 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendProfileInfoCS( IntPtr thisptr, UInt64 steamIDFriend, string pchKey );
		public string GetFriendProfileInfo( CSteamID steamIDFriend, string pchKey ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendProfileInfoCS>( this.Functions.GetFriendProfileInfo208 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), pchKey ) ) ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeInviteUserToGameCS( IntPtr thisptr, UInt64 steamIDFriend, string pchConnectString );
		public bool InviteUserToGame( CSteamID steamIDFriend, string pchConnectString ) 
		{
			return this.GetFunction<NativeInviteUserToGameCS>( this.Functions.InviteUserToGame209 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), pchConnectString ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetOnlineConsoleFriendCount( IntPtr thisptr );
		public Int32 GetOnlineConsoleFriendCount(  ) 
		{
			return this.GetFunction<NativeGetOnlineConsoleFriendCount>( this.Functions.GetOnlineConsoleFriendCount210 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeRequestTradeC( IntPtr thisptr, UInt64 steamIDPartner );
		public UInt64 RequestTrade( CSteamID steamIDPartner ) 
		{
			return this.GetFunction<NativeRequestTradeC>( this.Functions.RequestTrade211 )( this.ObjectAddress, steamIDPartner.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeTradeResponseUB( IntPtr thisptr, UInt32 unTradeRequestID, [MarshalAs(UnmanagedType.I1)] bool bAccept );
		public void TradeResponse( UInt32 unTradeRequestID, bool bAccept ) 
		{
			this.GetFunction<NativeTradeResponseUB>( this.Functions.TradeResponse212 )( this.ObjectAddress, unTradeRequestID, bAccept ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeCancelTradeRequestC( IntPtr thisptr, UInt64 steamIDPartner );
		public void CancelTradeRequest( CSteamID steamIDPartner ) 
		{
			this.GetFunction<NativeCancelTradeRequestC>( this.Functions.CancelTradeRequest213 )( this.ObjectAddress, steamIDPartner.ConvertToUint64() ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeHideFriendCB( IntPtr thisptr, UInt64 steamIDFriend, [MarshalAs(UnmanagedType.I1)] bool bHide );
		public bool HideFriend( CSteamID steamIDFriend, bool bHide ) 
		{
			return this.GetFunction<NativeHideFriendCB>( this.Functions.HideFriend214 )( this.ObjectAddress, steamIDFriend.ConvertToUint64(), bHide ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetFriendFacebookNameC( IntPtr thisptr, UInt64 steamIDFriend );
		public string GetFriendFacebookName( CSteamID steamIDFriend ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetFriendFacebookNameC>( this.Functions.GetFriendFacebookName215 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeGetFriendFacebookIDC( IntPtr thisptr, UInt64 steamIDFriend );
		public UInt64 GetFriendFacebookID( CSteamID steamIDFriend ) 
		{
			return this.GetFunction<NativeGetFriendFacebookIDC>( this.Functions.GetFriendFacebookID216 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeGetFollowerCountC( IntPtr thisptr, UInt64 steamID );
		public UInt64 GetFollowerCount( CSteamID steamID ) 
		{
			return this.GetFunction<NativeGetFollowerCountC>( this.Functions.GetFollowerCount217 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeIsFollowingC( IntPtr thisptr, UInt64 steamID );
		public UInt64 IsFollowing( CSteamID steamID ) 
		{
			return this.GetFunction<NativeIsFollowingC>( this.Functions.IsFollowing218 )( this.ObjectAddress, steamID.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeEnumerateFollowingListU( IntPtr thisptr, UInt32 uStartIndex );
		public UInt64 EnumerateFollowingList( UInt32 uStartIndex ) 
		{
			return this.GetFunction<NativeEnumerateFollowingListU>( this.Functions.EnumerateFollowingList219 )( this.ObjectAddress, uStartIndex ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeRequestFriendMessageHistoryC( IntPtr thisptr, UInt64 steamIDFriend );
		public void RequestFriendMessageHistory( CSteamID steamIDFriend ) 
		{
			this.GetFunction<NativeRequestFriendMessageHistoryC>( this.Functions.RequestFriendMessageHistory220 )( this.ObjectAddress, steamIDFriend.ConvertToUint64() ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeRequestFriendMessageHistoryForOfflineMessages( IntPtr thisptr );
		public void RequestFriendMessageHistoryForOfflineMessages(  ) 
		{
			this.GetFunction<NativeRequestFriendMessageHistoryForOfflineMessages>( this.Functions.RequestFriendMessageHistoryForOfflineMessages221 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetCountFriendsWithOfflineMessages( IntPtr thisptr );
		public Int32 GetCountFriendsWithOfflineMessages(  ) 
		{
			return this.GetFunction<NativeGetCountFriendsWithOfflineMessages>( this.Functions.GetCountFriendsWithOfflineMessages222 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetFriendWithOfflineMessageI( IntPtr thisptr, Int32 iFriend );
		public UInt32 GetFriendWithOfflineMessage( Int32 iFriend ) 
		{
			return this.GetFunction<NativeGetFriendWithOfflineMessageI>( this.Functions.GetFriendWithOfflineMessage223 )( this.ObjectAddress, iFriend ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeClearFriendHasOfflineMessageU( IntPtr thisptr, UInt32 uFriend );
		public void ClearFriendHasOfflineMessage( UInt32 uFriend ) 
		{
			this.GetFunction<NativeClearFriendHasOfflineMessageU>( this.Functions.ClearFriendHasOfflineMessage224 )( this.ObjectAddress, uFriend ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeRequestEmoticonList( IntPtr thisptr );
		public void RequestEmoticonList(  ) 
		{
			this.GetFunction<NativeRequestEmoticonList>( this.Functions.RequestEmoticonList225 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetEmoticonCount( IntPtr thisptr );
		public Int32 GetEmoticonCount(  ) 
		{
			return this.GetFunction<NativeGetEmoticonCount>( this.Functions.GetEmoticonCount226 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetEmoticonNameI( IntPtr thisptr, Int32 iEmoticon );
		public string GetEmoticonName( Int32 iEmoticon ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetEmoticonNameI>( this.Functions.GetEmoticonName227 )( this.ObjectAddress, iEmoticon ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeClientLinkFilterInit( IntPtr thisptr );
		public void ClientLinkFilterInit(  ) 
		{
			this.GetFunction<NativeClientLinkFilterInit>( this.Functions.ClientLinkFilterInit228 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeLinkDispositionS( IntPtr thisptr, string arg0 );
		public UInt32 LinkDisposition( string arg0 ) 
		{
			return this.GetFunction<NativeLinkDispositionS>( this.Functions.LinkDisposition229 )( this.ObjectAddress, arg0 ); 
		}
		
	};
}
