// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;

namespace Steam4NET
{

	[StructLayout(LayoutKind.Sequential,Pack=4)]
	public class IClientAppManagerVTable
	{
		public IntPtr InstallApp0;
		public IntPtr UninstallApp1;
		public IntPtr LaunchApp2;
		public IntPtr ShutdownApp3;
		public IntPtr GetAppInstallState4;
		public IntPtr GetAppBuildID5;
		public IntPtr GetAppSizeOnDisk6;
		public IntPtr GetAppInstallDir7;
		public IntPtr IsAppDlcInstalled8;
		public IntPtr GetNumInstalledApps9;
		public IntPtr GetInstalledApps10;
		public IntPtr GetAppDependency11;
		public IntPtr GetDependentApps12;
		public IntPtr GetUpdateInfo13;
		public IntPtr SetContentLocked14;
		public IntPtr GetAppConfigValue15;
		public IntPtr SetAppConfigValue16;
		public IntPtr BIsAppUpToDate17;
		public IntPtr GetAvailableLaunchOptions18;
		public IntPtr GetAvailableLanguages19;
		public IntPtr StartValidatingApp20;
		public IntPtr CancelValidation21;
		public IntPtr MarkContentCorrupt22;
		public IntPtr GetInstalledDepots23;
		public IntPtr BCacheBetaPassword24;
		public IntPtr BRequestBetaPasswords25;
		public IntPtr BIsCachedBetaPasswordValid26;
		public IntPtr SetDownloadingEnabled27;
		public IntPtr BIsDownloadingEnabled28;
		public IntPtr GetDownloadStats29;
		public IntPtr GetDownloadingAppID30;
		public IntPtr SetAutoUpdateTimeRestriction31;
		public IntPtr GetAutoUpdateTimeRestriction32;
		public IntPtr GetAppAutoUpdateBehavior33;
		public IntPtr SetAppAutoUpdateBehavior34;
		public IntPtr SetAppAllowDownloadsWhileRunningBehavior35;
		public IntPtr GetAppAllowDownloadsWhileRunningBehavior36;
		public IntPtr SetAllowDownloadsWhileAnyAppRunning37;
		public IntPtr BAllowDownloadsWhileAnyAppRunning38;
		public IntPtr ChangeAppDownloadQueuePlacement39;
		public IntPtr GetAppDownloadQueueIndex40;
		public IntPtr BHasLocalContentServer41;
		public IntPtr BuildBackup42;
		public IntPtr BuildInstaller43;
		public IntPtr CancelBackup44;
		public IntPtr RestoreApp45;
		public IntPtr BNeedsFile46;
		public IntPtr BAddFileOnDisk47;
		public IntPtr FinishAddingFiles48;
		public IntPtr GetAppStateInfo49;
		public IntPtr BIsAvailableOnPlatform50;
		public IntPtr GetNumInstallBaseFolders51;
		public IntPtr GetInstallBaseFolder52;
		public IntPtr AddInstallBaseFolder53;
		public IntPtr RemoveInstallBaseFolder54;
		public IntPtr GetFreeDiskSpace55;
		public IntPtr GetAppInstallBaseFolder56;
		public IntPtr ForceInstallDirOverride57;
		public IntPtr SetDownloadThrottleRateKbps58;
		public IntPtr GetDownloadThrottleRateKbps59;
		public IntPtr SuspendDownloadThrottling60;
		public IntPtr GetLaunchQueryParam61;
		public IntPtr BeginLaunchQueryParams62;
		public IntPtr SetLaunchQueryParam63;
		public IntPtr CommitLaunchQueryParams64;
		private IntPtr DTorIClientAppManager65;
	};
	
	[InteropHelp.InterfaceVersion("CLIENTAPPMANAGER_INTERFACE_VERSION001")]
	public class IClientAppManager : InteropHelp.NativeWrapper<IClientAppManagerVTable>
	{
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EAppUpdateError NativeInstallAppUSIB( IntPtr thisptr, UInt32 unAppID, string cszAppDir, Int32 iBaseFolder, [MarshalAs(UnmanagedType.I1)] bool bLegacy );
		public EAppUpdateError InstallApp( UInt32 unAppID, string cszAppDir, Int32 iBaseFolder, bool bLegacy ) 
		{
			return this.GetFunction<NativeInstallAppUSIB>( this.Functions.InstallApp0 )( this.ObjectAddress, unAppID, cszAppDir, iBaseFolder, bLegacy ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EAppUpdateError NativeUninstallAppUB( IntPtr thisptr, UInt32 unAppID, [MarshalAs(UnmanagedType.I1)] bool bComplete );
		public EAppUpdateError UninstallApp( UInt32 unAppID, bool bComplete ) 
		{
			return this.GetFunction<NativeUninstallAppUB>( this.Functions.UninstallApp1 )( this.ObjectAddress, unAppID, bComplete ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EAppUpdateError NativeLaunchAppUUS( IntPtr thisptr, UInt32 unAppID, UInt32 uLaunchOption, string pszUserArgs );
		public EAppUpdateError LaunchApp( UInt32 unAppID, UInt32 uLaunchOption, string pszUserArgs ) 
		{
			return this.GetFunction<NativeLaunchAppUUS>( this.Functions.LaunchApp2 )( this.ObjectAddress, unAppID, uLaunchOption, pszUserArgs ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeShutdownAppUB( IntPtr thisptr, UInt32 unAppID, [MarshalAs(UnmanagedType.I1)] bool bForce );
		public bool ShutdownApp( UInt32 unAppID, bool bForce ) 
		{
			return this.GetFunction<NativeShutdownAppUB>( this.Functions.ShutdownApp3 )( this.ObjectAddress, unAppID, bForce ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EAppState NativeGetAppInstallStateU( IntPtr thisptr, UInt32 unAppID );
		public EAppState GetAppInstallState( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeGetAppInstallStateU>( this.Functions.GetAppInstallState4 )( this.ObjectAddress, unAppID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetAppBuildIDU( IntPtr thisptr, UInt32 unAppID );
		public UInt32 GetAppBuildID( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeGetAppBuildIDU>( this.Functions.GetAppBuildID5 )( this.ObjectAddress, unAppID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetAppSizeOnDiskUUU( IntPtr thisptr, UInt32 unAppID, ref UInt64 pullAppSize, ref UInt64 pullUnk );
		public bool GetAppSizeOnDisk( UInt32 unAppID, ref UInt64 pullAppSize, ref UInt64 pullUnk ) 
		{
			return this.GetFunction<NativeGetAppSizeOnDiskUUU>( this.Functions.GetAppSizeOnDisk6 )( this.ObjectAddress, unAppID, ref pullAppSize, ref pullUnk ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetAppInstallDirUSU( IntPtr thisptr, UInt32 unAppID, StringBuilder pchPath, UInt32 cchPath );
		public UInt32 GetAppInstallDir( UInt32 unAppID, StringBuilder pchPath ) 
		{
			return this.GetFunction<NativeGetAppInstallDirUSU>( this.Functions.GetAppInstallDir7 )( this.ObjectAddress, unAppID, pchPath, (UInt32) pchPath.Capacity ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeIsAppDlcInstalledUU( IntPtr thisptr, UInt32 unAppID, UInt32 unDLCAppID );
		public bool IsAppDlcInstalled( UInt32 unAppID, UInt32 unDLCAppID ) 
		{
			return this.GetFunction<NativeIsAppDlcInstalledUU>( this.Functions.IsAppDlcInstalled8 )( this.ObjectAddress, unAppID, unDLCAppID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetNumInstalledApps( IntPtr thisptr );
		public UInt32 GetNumInstalledApps(  ) 
		{
			return this.GetFunction<NativeGetNumInstalledApps>( this.Functions.GetNumInstalledApps9 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetInstalledAppsUU( IntPtr thisptr, ref UInt32 punAppIDs, UInt32 cAppIDsMax );
		public UInt32 GetInstalledApps( ref UInt32 punAppIDs, UInt32 cAppIDsMax ) 
		{
			return this.GetFunction<NativeGetInstalledAppsUU>( this.Functions.GetInstalledApps10 )( this.ObjectAddress, ref punAppIDs, cAppIDsMax ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetAppDependencyU( IntPtr thisptr, UInt32 unAppID );
		public UInt32 GetAppDependency( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeGetAppDependencyU>( this.Functions.GetAppDependency11 )( this.ObjectAddress, unAppID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetDependentAppsUUI( IntPtr thisptr, UInt32 unAppID, ref UInt32 punAppIDs, Int32 cAppIDsMax );
		public UInt32 GetDependentApps( UInt32 unAppID, ref UInt32 punAppIDs, Int32 cAppIDsMax ) 
		{
			return this.GetFunction<NativeGetDependentAppsUUI>( this.Functions.GetDependentApps12 )( this.ObjectAddress, unAppID, ref punAppIDs, cAppIDsMax ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetUpdateInfoUA( IntPtr thisptr, UInt32 unAppID, ref AppUpdateInfo_s pUpdateInfo );
		public UInt32 GetUpdateInfo( UInt32 unAppID, ref AppUpdateInfo_s pUpdateInfo ) 
		{
			return this.GetFunction<NativeGetUpdateInfoUA>( this.Functions.GetUpdateInfo13 )( this.ObjectAddress, unAppID, ref pUpdateInfo ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetContentLockedUB( IntPtr thisptr, UInt32 unAppID, [MarshalAs(UnmanagedType.I1)] bool bLockContent );
		public bool SetContentLocked( UInt32 unAppID, bool bLockContent ) 
		{
			return this.GetFunction<NativeSetContentLockedUB>( this.Functions.SetContentLocked14 )( this.ObjectAddress, unAppID, bLockContent ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetAppConfigValueUSSI( IntPtr thisptr, UInt32 unAppID, string pchKey, StringBuilder pchValue, Int32 cchValueMax );
		public Int32 GetAppConfigValue( UInt32 unAppID, string pchKey, StringBuilder pchValue ) 
		{
			return this.GetFunction<NativeGetAppConfigValueUSSI>( this.Functions.GetAppConfigValue15 )( this.ObjectAddress, unAppID, pchKey, pchValue, (Int32) pchValue.Capacity ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetAppConfigValueUSS( IntPtr thisptr, UInt32 unAppID, string pchKey, string pchValue );
		public bool SetAppConfigValue( UInt32 unAppID, string pchKey, string pchValue ) 
		{
			return this.GetFunction<NativeSetAppConfigValueUSS>( this.Functions.SetAppConfigValue16 )( this.ObjectAddress, unAppID, pchKey, pchValue ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBIsAppUpToDateU( IntPtr thisptr, UInt32 unAppID );
		public bool BIsAppUpToDate( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeBIsAppUpToDateU>( this.Functions.BIsAppUpToDate17 )( this.ObjectAddress, unAppID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetAvailableLaunchOptionsUUU( IntPtr thisptr, UInt32 unAppID, ref UInt32 puOptions, UInt32 cuOptionsMax );
		public UInt32 GetAvailableLaunchOptions( UInt32 unAppID, ref UInt32 puOptions, UInt32 cuOptionsMax ) 
		{
			return this.GetFunction<NativeGetAvailableLaunchOptionsUUU>( this.Functions.GetAvailableLaunchOptions18 )( this.ObjectAddress, unAppID, ref puOptions, cuOptionsMax ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetAvailableLanguagesUBSU( IntPtr thisptr, UInt32 unAppID, [MarshalAs(UnmanagedType.I1)] bool arg1, StringBuilder pchLanguages, UInt32 cchLanguagesMax );
		public UInt32 GetAvailableLanguages( UInt32 unAppID, bool arg1, StringBuilder pchLanguages ) 
		{
			return this.GetFunction<NativeGetAvailableLanguagesUBSU>( this.Functions.GetAvailableLanguages19 )( this.ObjectAddress, unAppID, arg1, pchLanguages, (UInt32) pchLanguages.Capacity ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeStartValidatingAppU( IntPtr thisptr, UInt32 unAppID );
		public bool StartValidatingApp( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeStartValidatingAppU>( this.Functions.StartValidatingApp20 )( this.ObjectAddress, unAppID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeCancelValidationU( IntPtr thisptr, UInt32 unAppID );
		public bool CancelValidation( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeCancelValidationU>( this.Functions.CancelValidation21 )( this.ObjectAddress, unAppID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeMarkContentCorruptUB( IntPtr thisptr, UInt32 unAppID, [MarshalAs(UnmanagedType.I1)] bool bCorrupt );
		public bool MarkContentCorrupt( UInt32 unAppID, bool bCorrupt ) 
		{
			return this.GetFunction<NativeMarkContentCorruptUB>( this.Functions.MarkContentCorrupt22 )( this.ObjectAddress, unAppID, bCorrupt ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetInstalledDepotsUUU( IntPtr thisptr, UInt32 unAppID, ref UInt32 puDepots, UInt32 cuDepotsMax );
		public UInt32 GetInstalledDepots( UInt32 unAppID, ref UInt32 puDepots, UInt32 cuDepotsMax ) 
		{
			return this.GetFunction<NativeGetInstalledDepotsUUU>( this.Functions.GetInstalledDepots23 )( this.ObjectAddress, unAppID, ref puDepots, cuDepotsMax ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBCacheBetaPasswordUSS( IntPtr thisptr, UInt32 unAppID, string cszBetaKey, string cszBetaPassword );
		public bool BCacheBetaPassword( UInt32 unAppID, string cszBetaKey, string cszBetaPassword ) 
		{
			return this.GetFunction<NativeBCacheBetaPasswordUSS>( this.Functions.BCacheBetaPassword24 )( this.ObjectAddress, unAppID, cszBetaKey, cszBetaPassword ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBRequestBetaPasswordsU( IntPtr thisptr, UInt32 unAppID );
		public bool BRequestBetaPasswords( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeBRequestBetaPasswordsU>( this.Functions.BRequestBetaPasswords25 )( this.ObjectAddress, unAppID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBIsCachedBetaPasswordValidUS( IntPtr thisptr, UInt32 unAppID, string cszBetaKey );
		public bool BIsCachedBetaPasswordValid( UInt32 unAppID, string cszBetaKey ) 
		{
			return this.GetFunction<NativeBIsCachedBetaPasswordValidUS>( this.Functions.BIsCachedBetaPasswordValid26 )( this.ObjectAddress, unAppID, cszBetaKey ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetDownloadingEnabledB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bState );
		public bool SetDownloadingEnabled( bool bState ) 
		{
			return this.GetFunction<NativeSetDownloadingEnabledB>( this.Functions.SetDownloadingEnabled27 )( this.ObjectAddress, bState ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBIsDownloadingEnabled( IntPtr thisptr );
		public bool BIsDownloadingEnabled(  ) 
		{
			return this.GetFunction<NativeBIsDownloadingEnabled>( this.Functions.BIsDownloadingEnabled28 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetDownloadStatsD( IntPtr thisptr, ref DownloadStats_s pDownloadStats );
		public bool GetDownloadStats( ref DownloadStats_s pDownloadStats ) 
		{
			return this.GetFunction<NativeGetDownloadStatsD>( this.Functions.GetDownloadStats29 )( this.ObjectAddress, ref pDownloadStats ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeGetDownloadingAppID( IntPtr thisptr );
		public UInt32 GetDownloadingAppID(  ) 
		{
			return this.GetFunction<NativeGetDownloadingAppID>( this.Functions.GetDownloadingAppID30 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetAutoUpdateTimeRestrictionBII( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bUnk, Int32 iUnk1, Int32 iUnk2 );
		public bool SetAutoUpdateTimeRestriction( bool bUnk, Int32 iUnk1, Int32 iUnk2 ) 
		{
			return this.GetFunction<NativeSetAutoUpdateTimeRestrictionBII>( this.Functions.SetAutoUpdateTimeRestriction31 )( this.ObjectAddress, bUnk, iUnk1, iUnk2 ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetAutoUpdateTimeRestrictionII( IntPtr thisptr, ref Int32 piUnk1, ref Int32 piUnk2 );
		public bool GetAutoUpdateTimeRestriction( ref Int32 piUnk1, ref Int32 piUnk2 ) 
		{
			return this.GetFunction<NativeGetAutoUpdateTimeRestrictionII>( this.Functions.GetAutoUpdateTimeRestriction32 )( this.ObjectAddress, ref piUnk1, ref piUnk2 ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EAppAutoUpdateBehavior NativeGetAppAutoUpdateBehaviorU( IntPtr thisptr, UInt32 unAppID );
		public EAppAutoUpdateBehavior GetAppAutoUpdateBehavior( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeGetAppAutoUpdateBehaviorU>( this.Functions.GetAppAutoUpdateBehavior33 )( this.ObjectAddress, unAppID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetAppAutoUpdateBehaviorUE( IntPtr thisptr, UInt32 unAppID, EAppAutoUpdateBehavior eAppAutoUpdateBehavior );
		public bool SetAppAutoUpdateBehavior( UInt32 unAppID, EAppAutoUpdateBehavior eAppAutoUpdateBehavior ) 
		{
			return this.GetFunction<NativeSetAppAutoUpdateBehaviorUE>( this.Functions.SetAppAutoUpdateBehavior34 )( this.ObjectAddress, unAppID, eAppAutoUpdateBehavior ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetAppAllowDownloadsWhileRunningBehaviorUE( IntPtr thisptr, UInt32 unAppID, EAppAllowDownloadsWhileRunningBehavior eAppAllowDownloadsWhileRunningBehavior );
		public bool SetAppAllowDownloadsWhileRunningBehavior( UInt32 unAppID, EAppAllowDownloadsWhileRunningBehavior eAppAllowDownloadsWhileRunningBehavior ) 
		{
			return this.GetFunction<NativeSetAppAllowDownloadsWhileRunningBehaviorUE>( this.Functions.SetAppAllowDownloadsWhileRunningBehavior35 )( this.ObjectAddress, unAppID, eAppAllowDownloadsWhileRunningBehavior ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EAppAllowDownloadsWhileRunningBehavior NativeGetAppAllowDownloadsWhileRunningBehaviorU( IntPtr thisptr, UInt32 unAppID );
		public EAppAllowDownloadsWhileRunningBehavior GetAppAllowDownloadsWhileRunningBehavior( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeGetAppAllowDownloadsWhileRunningBehaviorU>( this.Functions.GetAppAllowDownloadsWhileRunningBehavior36 )( this.ObjectAddress, unAppID ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetAllowDownloadsWhileAnyAppRunningB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bAllowDownloadsWhileAnyAppRunning );
		public void SetAllowDownloadsWhileAnyAppRunning( bool bAllowDownloadsWhileAnyAppRunning ) 
		{
			this.GetFunction<NativeSetAllowDownloadsWhileAnyAppRunningB>( this.Functions.SetAllowDownloadsWhileAnyAppRunning37 )( this.ObjectAddress, bAllowDownloadsWhileAnyAppRunning ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBAllowDownloadsWhileAnyAppRunning( IntPtr thisptr );
		public bool BAllowDownloadsWhileAnyAppRunning(  ) 
		{
			return this.GetFunction<NativeBAllowDownloadsWhileAnyAppRunning>( this.Functions.BAllowDownloadsWhileAnyAppRunning38 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeChangeAppDownloadQueuePlacementUE( IntPtr thisptr, UInt32 unAppID, EAppDownloadQueuePlacement eAppDownloadQueuePlacement );
		public bool ChangeAppDownloadQueuePlacement( UInt32 unAppID, EAppDownloadQueuePlacement eAppDownloadQueuePlacement ) 
		{
			return this.GetFunction<NativeChangeAppDownloadQueuePlacementUE>( this.Functions.ChangeAppDownloadQueuePlacement39 )( this.ObjectAddress, unAppID, eAppDownloadQueuePlacement ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetAppDownloadQueueIndexU( IntPtr thisptr, UInt32 unAppID );
		public Int32 GetAppDownloadQueueIndex( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeGetAppDownloadQueueIndexU>( this.Functions.GetAppDownloadQueueIndex40 )( this.ObjectAddress, unAppID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBHasLocalContentServer( IntPtr thisptr );
		public bool BHasLocalContentServer(  ) 
		{
			return this.GetFunction<NativeBHasLocalContentServer>( this.Functions.BHasLocalContentServer41 )( this.ObjectAddress ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBuildBackupUUS( IntPtr thisptr, UInt32 unAppID, UInt64 ullMaxFileSize, string cszBackupPath );
		public bool BuildBackup( UInt32 unAppID, UInt64 ullMaxFileSize, string cszBackupPath ) 
		{
			return this.GetFunction<NativeBuildBackupUUS>( this.Functions.BuildBackup42 )( this.ObjectAddress, unAppID, ullMaxFileSize, cszBackupPath ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBuildInstallerSSS( IntPtr thisptr, string cszProjectFile, string cszBackupPath, string arg2 );
		public bool BuildInstaller( string cszProjectFile, string cszBackupPath, string arg2 ) 
		{
			return this.GetFunction<NativeBuildInstallerSSS>( this.Functions.BuildInstaller43 )( this.ObjectAddress, cszProjectFile, cszBackupPath, arg2 ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeCancelBackup( IntPtr thisptr );
		public bool CancelBackup(  ) 
		{
			return this.GetFunction<NativeCancelBackup>( this.Functions.CancelBackup44 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate EAppUpdateError NativeRestoreAppUIS( IntPtr thisptr, UInt32 unAppID, Int32 iBaseFolder, string cszBackupPath );
		public EAppUpdateError RestoreApp( UInt32 unAppID, Int32 iBaseFolder, string cszBackupPath ) 
		{
			return this.GetFunction<NativeRestoreAppUIS>( this.Functions.RestoreApp45 )( this.ObjectAddress, unAppID, iBaseFolder, cszBackupPath ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBNeedsFileUSUU( IntPtr thisptr, UInt32 unAppID, string cszFilePath, UInt64 ullFileSize, UInt32 uUnk );
		public bool BNeedsFile( UInt32 unAppID, string cszFilePath, UInt64 ullFileSize, UInt32 uUnk ) 
		{
			return this.GetFunction<NativeBNeedsFileUSUU>( this.Functions.BNeedsFile46 )( this.ObjectAddress, unAppID, cszFilePath, ullFileSize, uUnk ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBAddFileOnDiskUSUUS( IntPtr thisptr, UInt32 unAppID, string cszFilePath, UInt64 ullFileSize, UInt32 uUnk, SHADigestWrapper_t ubSha1 );
		public bool BAddFileOnDisk( UInt32 unAppID, string cszFilePath, UInt64 ullFileSize, UInt32 uUnk, SHADigestWrapper_t ubSha1 ) 
		{
			return this.GetFunction<NativeBAddFileOnDiskUSUUS>( this.Functions.BAddFileOnDisk47 )( this.ObjectAddress, unAppID, cszFilePath, ullFileSize, uUnk, ubSha1 ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt32 NativeFinishAddingFilesU( IntPtr thisptr, UInt32 unAppID );
		public UInt32 FinishAddingFiles( UInt32 unAppID ) 
		{
			return this.GetFunction<NativeFinishAddingFilesU>( this.Functions.FinishAddingFiles48 )( this.ObjectAddress, unAppID ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeGetAppStateInfoUEEEC( IntPtr thisptr, UInt32 unAppID, ref EAppReleaseState peReleaseState, ref EAppOwnershipFlags peOwnershipFlags, ref EAppState peAppState, ref UInt64 pSteamID );
		public bool GetAppStateInfo( UInt32 unAppID, ref EAppReleaseState peReleaseState, ref EAppOwnershipFlags peOwnershipFlags, ref EAppState peAppState, ref CSteamID pSteamID ) 
		{
			UInt64 s0 = 0; var result = this.GetFunction<NativeGetAppStateInfoUEEEC>( this.Functions.GetAppStateInfo49 )( this.ObjectAddress, unAppID, ref peReleaseState, ref peOwnershipFlags, ref peAppState, ref s0 ); pSteamID = new CSteamID(s0); return result;
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeBIsAvailableOnPlatformUS( IntPtr thisptr, UInt32 uUnk, string pUnk );
		public bool BIsAvailableOnPlatform( UInt32 uUnk, string pUnk ) 
		{
			return this.GetFunction<NativeBIsAvailableOnPlatformUS>( this.Functions.BIsAvailableOnPlatform50 )( this.ObjectAddress, uUnk, pUnk ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetNumInstallBaseFolders( IntPtr thisptr );
		public Int32 GetNumInstallBaseFolders(  ) 
		{
			return this.GetFunction<NativeGetNumInstallBaseFolders>( this.Functions.GetNumInstallBaseFolders51 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetInstallBaseFolderISI( IntPtr thisptr, Int32 iBaseFolder, StringBuilder pchPath, Int32 cbPath );
		public Int32 GetInstallBaseFolder( Int32 iBaseFolder, StringBuilder pchPath ) 
		{
			return this.GetFunction<NativeGetInstallBaseFolderISI>( this.Functions.GetInstallBaseFolder52 )( this.ObjectAddress, iBaseFolder, pchPath, (Int32) pchPath.Capacity ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeAddInstallBaseFolderS( IntPtr thisptr, string szPath );
		public Int32 AddInstallBaseFolder( string szPath ) 
		{
			return this.GetFunction<NativeAddInstallBaseFolderS>( this.Functions.AddInstallBaseFolder53 )( this.ObjectAddress, szPath ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeRemoveInstallBaseFolderI( IntPtr thisptr, Int32 iBaseFolder );
		public bool RemoveInstallBaseFolder( Int32 iBaseFolder ) 
		{
			return this.GetFunction<NativeRemoveInstallBaseFolderI>( this.Functions.RemoveInstallBaseFolder54 )( this.ObjectAddress, iBaseFolder ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate UInt64 NativeGetFreeDiskSpaceI( IntPtr thisptr, Int32 iBaseFolder );
		public UInt64 GetFreeDiskSpace( Int32 iBaseFolder ) 
		{
			return this.GetFunction<NativeGetFreeDiskSpaceI>( this.Functions.GetFreeDiskSpace55 )( this.ObjectAddress, iBaseFolder ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetAppInstallBaseFolderI( IntPtr thisptr, Int32 iBaseFolder );
		public Int32 GetAppInstallBaseFolder( Int32 iBaseFolder ) 
		{
			return this.GetFunction<NativeGetAppInstallBaseFolderI>( this.Functions.GetAppInstallBaseFolder56 )( this.ObjectAddress, iBaseFolder ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeForceInstallDirOverrideS( IntPtr thisptr, string cszPath );
		public void ForceInstallDirOverride( string cszPath ) 
		{
			this.GetFunction<NativeForceInstallDirOverrideS>( this.Functions.ForceInstallDirOverride57 )( this.ObjectAddress, cszPath ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeSetDownloadThrottleRateKbpsI( IntPtr thisptr, Int32 iRate );
		public bool SetDownloadThrottleRateKbps( Int32 iRate ) 
		{
			return this.GetFunction<NativeSetDownloadThrottleRateKbpsI>( this.Functions.SetDownloadThrottleRateKbps58 )( this.ObjectAddress, iRate ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate Int32 NativeGetDownloadThrottleRateKbps( IntPtr thisptr );
		public Int32 GetDownloadThrottleRateKbps(  ) 
		{
			return this.GetFunction<NativeGetDownloadThrottleRateKbps>( this.Functions.GetDownloadThrottleRateKbps59 )( this.ObjectAddress ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSuspendDownloadThrottlingB( IntPtr thisptr, [MarshalAs(UnmanagedType.I1)] bool bSuspend );
		public void SuspendDownloadThrottling( bool bSuspend ) 
		{
			this.GetFunction<NativeSuspendDownloadThrottlingB>( this.Functions.SuspendDownloadThrottling60 )( this.ObjectAddress, bSuspend ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate IntPtr NativeGetLaunchQueryParamUS( IntPtr thisptr, UInt32 unAppID, string pchKey );
		public string GetLaunchQueryParam( UInt32 unAppID, string pchKey ) 
		{
			return InteropHelp.DecodeANSIReturn( Marshal.PtrToStringAnsi( this.GetFunction<NativeGetLaunchQueryParamUS>( this.Functions.GetLaunchQueryParam61 )( this.ObjectAddress, unAppID, pchKey ) ) ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeBeginLaunchQueryParamsU( IntPtr thisptr, UInt32 unAppId );
		public void BeginLaunchQueryParams( UInt32 unAppId ) 
		{
			this.GetFunction<NativeBeginLaunchQueryParamsU>( this.Functions.BeginLaunchQueryParams62 )( this.ObjectAddress, unAppId ); 
		}
		
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate void NativeSetLaunchQueryParamUSS( IntPtr thisptr, UInt32 unAppId, string pchKey, string pchValue );
		public void SetLaunchQueryParam( UInt32 unAppId, string pchKey, string pchValue ) 
		{
			this.GetFunction<NativeSetLaunchQueryParamUSS>( this.Functions.SetLaunchQueryParam63 )( this.ObjectAddress, unAppId, pchKey, pchValue ); 
		}
		
		[return: MarshalAs(UnmanagedType.I1)]
		[UnmanagedFunctionPointer(CallingConvention.ThisCall)] private delegate bool NativeCommitLaunchQueryParamsU( IntPtr thisptr, UInt32 unAppId );
		public bool CommitLaunchQueryParams( UInt32 unAppId ) 
		{
			return this.GetFunction<NativeCommitLaunchQueryParamsU>( this.Functions.CommitLaunchQueryParams64 )( this.ObjectAddress, unAppId ); 
		}
		
	};
}
