// This file is automatically generated.
using System;
using System.Text;
using System.Runtime.InteropServices;

namespace Steam4NET
{

	public enum EAppState : int
	{
		k_EAppStateInvalid = 0,
		k_EAppStateUninstalled = 1,
		k_EAppStateUpdateRequired = 2,
		k_EAppStateFullyInstalled = 4,
		k_EAppStateDataEncrypted = 8,
		k_EAppStateSharedOnly = 64,
		k_EAppStateDataLocked = 16,
		k_EAppStateFilesMissing = 32,
		k_EAppStateFilesCorrupt = 128,
		k_EAppStateAppRunning = 8192,
		k_EAppStateBackupRunning = 4096,
		k_EAppStateUpdateRunning = 256,
		k_EAppStateUpdateStopping = 8388608,
		k_EAppStateUpdatePaused = 512,
		k_EAppStateUpdateStarted = 1024,
		k_EAppStateReconfiguring = 65536,
		k_EAppStateAddingFiles = 262144,
		k_EAppStateDownloading = 1048576,
		k_EAppStateStaging = 2097152,
		k_EAppStateCommitting = 4194304,
		k_EAppStateUninstalling = 2048,
		k_EAppStatePreallocating = 524288,
		k_EAppStateValidating = 131072,
	};
	
	public enum EAppEvent : int
	{
		k_EAppEventDownloadComplete = 2,
	};
	
	public enum EAppInfoSection : int
	{
		k_EAppInfoSectionUnknown = 0,
		k_EAppInfoSectionAll = 1,
		k_EAppInfoSectionCommon = 2,
		k_EAppInfoSectionExtended = 3,
		k_EAppInfoSectionConfig = 4,
		k_EAppInfoSectionStats = 5,
		k_EAppInfoSectionInstall = 6,
		k_EAppInfoSectionDepots = 7,
		k_EAppInfoSectionVac = 8,
		k_EAppInfoSectionDrm = 9,
		k_EAppInfoSectionUfs = 10,
		k_EAppInfoSectionOgg = 11,
		k_EAppInfoSectionItems = 12,
		k_EAppInfoSectionPolicies = 13,
		k_EAppInfoSectionSysreqs = 14,
		k_EAppInfoSectionCommunity = 15,
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	public struct AppUpdateInfo_s
	{
		public UInt32 m_timeUpdateStart;
		public UInt64 m_unBytesToDownload;
		public UInt64 m_unBytesDownloaded;
		public UInt64 m_unBytesToProcess;
		public UInt64 m_unBytesProcessed;
		public UInt32 m_uUnk;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	public struct DownloadStats_s
	{
		public UInt32 m_uIsDownloadEnabled;
		public UInt32 m_unCurrentConnections;
		public UInt32 m_unCurrentBytesPerSec;
		public UInt64 m_unTotalBytesDownload;
		public UInt32 m_unCurrentCell;
	};
	
	public enum EAppDownloadPriority : int
	{
		k_EAppDownloadPriorityNone = 0,
		k_EAppDownloadPriorityFirst = 1,
		k_EAppDownloadPriorityUp = 2,
		k_EAppDownloadPriorityDown = 3,
		k_EAppDownloadPriorityLast = 4,
		k_EAppDownloadPriorityPaused = 5,
	};
	
	public enum EAppUpdateError : int
	{
		k_EAppErrorNone = 0,
		k_EAppErrorUnspecified = 1,
		k_EAppErrorPaused = 2,
		k_EAppErrorCanceled = 3,
		k_EAppErrorSuspended = 4,
		k_EAppErrorNoSubscription = 5,
		k_EAppErrorNoConnection = 6,
		k_EAppErrorTimeout = 7,
		k_EAppErrorMissingKey = 8,
		k_EAppErrorMissingConfig = 9,
		k_EAppErrorDiskReadFailure = 10,
		k_EAppErrorDiskWriteFailure = 11,
		k_EAppErrorCorruptContent = 13,
		k_EAppErrorWaitingForDisk = 14,
		k_EAppErrorInvalidInstallPath = 15,
		k_EAppErrorApplicationRunning = 16,
		k_EAppErrorDependencyFailure = 17,
		k_EAppErrorNotInstalled = 18,
		k_EAppErrorUpdateRequired = 19,
		k_EAppErrorStillBusy = 20,
		k_EAppErrorNoConnectionToContentServers = 21,
		k_EAppErrorInvalidApplicationConfiguration = 22,
		k_EAppErrorInvalidContentConfiguration = 23,
		k_EAppErrorMissingManifest = 24,
		k_EAppErrorNotReleased = 25,
		k_EAppErrorRegionRestricted = 26,
		k_EAppErrorCorruptDepotCache = 27,
		k_EAppErrorMissingExecutable = 28,
		k_EAppErrorInvalidPlatform = 29,
		k_EAppErrorInvalidFileSystem = 30,
		k_EAppErrorCorruptUpdateFiles = 31,
		k_EAppUpdateErrorDownloadCorrupt = 32,
		k_EAppUpdateErrorDownloadDisabled = 33,
		k_EAppUpdateErrorSharedLibraryLocked = 34,
		k_EAppUpdateErrorPurchasePending = 35,
		k_EAppUpdateErrorOtherSessionPlaying = 36,
	};
	
	public enum ERegisterActivactionCodeResult : int
	{
		k_ERegisterActivactionCodeResultOK = 0,
		k_ERegisterActivactionCodeResultFail = 1,
		k_ERegisterActivactionCodeResultAlreadyRegistered = 2,
		k_ERegisterActivactionCodeResultTimeout = 3,
		k_ERegisterActivactionCodeAlreadyOwned = 4,
	};
	
	public enum EAppOwnershipFlags : int
	{
		k_EAppOwnershipFlagsNone = 0,
		k_EAppOwnershipFlagsOwnsLicense = 1,
		k_EAppOwnershipFlagsFreeLicense = 2,
		k_EAppOwnershipFlagsRegionRestricted = 4,
		k_EAppOwnershipFlagsLowViolence = 8,
		k_EAppOwnershipFlagsInvalidPlatform = 16,
		k_EAppOwnershipFlagsSharedLicense = 32,
		k_EAppOwnershipFlagsFreeWeekend = 64,
		k_EAppOwnershipFlagsLockedLicense = 128,
		k_EAppOwnershipFlagsPending = 256,
		k_EAppOwnershipFlagsExpired = 512,
		k_EAppOwnershipFlagsPermanent = 1024,
		k_EAppOwnershipFlagsRecurring = 2048,
	};
	
	public enum EAppReleaseState : int
	{
		k_EAppReleaseStateUnknown = 0,
		k_EAppReleaseStateUnavailable = 1,
		k_EAppReleaseStatePrerelease = 2,
		k_EAppReleaseStatePreloadonly = 3,
		k_EAppReleaseStateReleased = 4,
	};
	
	public enum EAppAutoUpdateBehavior : int
	{
	};
	
	public enum EAppAllowDownloadsWhileRunningBehavior : int
	{
	};
	
	public enum EAppDownloadQueuePlacement : int
	{
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	public struct SHADigestWrapper_t
	{
		public UInt32 A;
		public UInt32 B;
		public UInt32 C;
		public UInt32 D;
		public UInt32 E;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1001)]
	public struct AppDataChanged_t
	{
		public const int k_iCallback = 1001;
		public UInt32 m_nAppID;
		[MarshalAs(UnmanagedType.I1)]
		public bool m_bBySteamUI;
		[MarshalAs(UnmanagedType.I1)]
		public bool m_bCDDBUpdate;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1002)]
	public struct RequestAppCallbacksComplete_t
	{
		public const int k_iCallback = 1002;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1003)]
	public struct AppInfoUpdateComplete_t
	{
		public const int k_iCallback = 1003;
		public EResult m_EResult;
		public UInt32 m_cAppsUpdated;
		[MarshalAs(UnmanagedType.I1)]
		public bool m_bSteam2CDDBChanged;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1004)]
	public struct AppEventTriggered_t
	{
		public const int k_iCallback = 1004;
		public UInt32 m_nAppID;
		public EAppEvent m_eAppEvent;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1005)]
	public struct DlcInstalled_t
	{
		public const int k_iCallback = 1005;
		public UInt32 m_nAppID;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1006)]
	public struct AppEventStateChange_t
	{
		public const int k_iCallback = 1006;
		public UInt32 m_nAppID;
		public UInt32 m_eOldState;
		public UInt32 m_eNewState;
		public EAppUpdateError m_eAppError;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1007)]
	public struct AppValidationComplete_t
	{
		public const int k_iCallback = 1007;
		public UInt32 m_nAppID;
		[MarshalAs(UnmanagedType.I1)]
		public bool m_bFinished;
		public UInt64 m_TotalBytesValidated;
		public UInt64 m_TotalBytesFailed;
		public UInt32 m_TotalFilesValidated;
		public UInt32 m_TotalFilesFailed;
		public UInt32 m_TotalFilesFailedCEGFiles;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1008)]
	public struct RegisterActivationCodeResponse_t
	{
		public const int k_iCallback = 1008;
		public ERegisterActivactionCodeResult m_eResult;
		public UInt32 m_unPackageRegistered;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1009)]
	public struct DownloadScheduleChanged_t
	{
		public const int k_iCallback = 1009;
		[MarshalAs(UnmanagedType.I1)]
		public bool m_bDownloadEnabled;
		public UInt32 m_nTotalAppsScheduled;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
		public UInt32[] m_rgunAppSchedule;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1010)]
	public struct DlcInstallRequest_t
	{
		public const int k_iCallback = 1010;
		public UInt32 m_nAppID;
		[MarshalAs(UnmanagedType.I1)]
		public bool m_bInstall;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1011)]
	public struct AppLaunchTenFootOverlay_t
	{
		public const int k_iCallback = 1011;
		public GameID_t m_GameID;
		public UInt64 m_nPid;
		[MarshalAs(UnmanagedType.I1)]
		public bool m_bCanShareSurfaces;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1012)]
	public struct AppBackupStatus_t
	{
		public const int k_iCallback = 1012;
		public UInt32 m_nAppID;
		public EResult m_eResult;
		public UInt64 m_unBytesToProcess;
		public UInt64 m_unBytesProcessed;
		public UInt64 m_unTotalBytesWritten;
		public UInt64 m_unBytesFailed;
	};
	
	[StructLayout(LayoutKind.Sequential,Pack=8)]
	[InteropHelp.CallbackIdentity(1013)]
	public struct RequestAppProofOfPurchaseKeyResponse_t
	{
		public const int k_iCallback = 1013;
		public EResult m_eResult;
		public UInt32 m_nAppID;
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 64)]
		public string m_rgchKey;
	};
	
}
