# dynamic linking does this all the time
if (CMAKE_CXX_COMPILER_ID MATCHES "Clang")
  option(NO_LIBGCC "use libunwind+compiler-rt instead, must already be installed in mingw-w64 sysroot" OFF)
  add_compile_options(-Wno-unused-command-line-argument -Wno-c++11-narrowing)
  add_compile_options($<$<COMPILE_LANGUAGE:C>:-Wno-bad-function-cast>)
  if (NO_LIBGCC)
    find_library(UNWIND_LIB unwind)
    link_libraries(${UNWIND_LIB})
    find_library(PSAPI_LIB psapi)
    link_libraries(${PSAPI_LIB})
  endif(NO_LIBGCC)
else()
  # found it. this is GNU only
  add_compile_options(-Wno-cast-function-type)
endif()
