<?php require_once('header.inc.php'); ?>

<h2>Downloads</h2>

<h3>Public Key for PGP Signing</h3>
<p>
  Starting from v3.3.4 all source tarballs and binaries are signed.
</p>
<p>
  The key currently used is: <a href="https://pgp.mit.edu/pks/lookup?op=get&amp;search=0x6E4A2D025B7CC9A2" target="_blank"><code>4096R/5B7CC9A2</code></a><br/>
  Fingerprint: <code>D8F3DA77AAC6741053599C136E4A2D025B7CC9A2</code><br/>
  You can also download it from <a href="https://github.com/qbittorrent/qBittorrent/raw/master/5B7CC9A2.asc" target="_blank">here</a>
</p>
<p>
  Previously the following key was used to sign the v3.3.4 source tarballs and v3.3.4 Windows installer <strong>only</strong>: <a href="https://pgp.mit.edu/pks/lookup?op=get&amp;search=0xA1ACCAE4520EC6F6" target="_blank"><code>4096R/520EC6F6</code></a><br/>
  Fingerprint: <code>F4A5FD201B117B1C2AB590E2A1ACCAE4520EC6F6</code>
</p>
<br/>


<h3>Windows 7 / 8 / 10</h3>
<div class="flexbox">
  <div class="box1">
    <img src="img/os/winlogo.png" alt="Windows icon"/>
  </div>
  <div>
    <p>
      Current <strong>stable</strong> version: <strong>qBittorrent v4.2.5</strong>
    </p>
    <p>
      <strong>Download link: <a href="https://www.fosshub.com/qBittorrent.html">32-bit &amp; 64-bit installers</a> / <a href="https://www.fosshub.com/qBittorrent.html">PGP signature</a></strong> (FossHub)<br/>
      <sub>Mirror link: <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent-win32/qbittorrent-4.2.5/qbittorrent_4.2.5_setup.exe/download">32-bit installer</a> / <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent-win32/qbittorrent-4.2.5/qbittorrent_4.2.5_setup.exe.asc/download">PGP signature</a> (SourceForge)</sub><br/>
      <sub>Mirror link: <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent-win32/qbittorrent-4.2.5/qbittorrent_4.2.5_x64_setup.exe/download">64-bit installer</a> / <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent-win32/qbittorrent-4.2.5/qbittorrent_4.2.5_x64_setup.exe.asc/download">PGP signature</a> (SourceForge)</sub>
    </p>
    <table>
      <br/><br/>
      <tbody>
        <tr>
          <td><strong>Checksum</strong></td>
          <td><strong>SHA2-256</strong></td>
        </tr>
        <tr>
          <td>32-bit installer</td>
          <td class="wordBreak"><code>7d5ec6993bde912ad35d98e2bb523c6d6022766b058bef0626bd41c8c00b81ff</code></td>
        </tr>
        <tr>
          <td>64-bit installer</td>
          <td class="wordBreak"><code>62731c7d44c217b79724cb23bef4267570332ed67c1c1feef3f6c803a6f57ef3</code></td>
        </tr>
      </tbody>
      <tbody>
        <tr>
          <td><strong>Library</strong></td>
          <td><strong>Version</strong></td>
        </tr>
        <tr>
          <td class="nobr">libtorrent-rasterbar</td>
          <td>1.2.6+gita9968916ca</td>
        </tr>
        <tr>
          <td>Qt</td>
          <td>
            5.13.2
          </td>
        </tr>
        <tr>
          <td>Boost</td>
          <td>1.72.0</td>
        </tr>
      </tbody>
    </table>
  </div>
</div>
<br/>


<h3>High Sierra / Mojave / Catalina</h3>
<div class="flexbox">
  <div class="box1">
    <img src="img/os/macoslogo.png" alt="macOS icon"/>
  </div>
  <div>
    <p>
      Current <strong>stable</strong> version: <strong>qBittorrent v4.2.5</strong><br/><br/>
      <strong>May work on older macOS versions. If not, recompile with older Qt version.</strong>
    </p>
    <p>
      <strong>Download link: <a href="https://www.fosshub.com/qBittorrent.html">DMG</a> / <a href="https://www.fosshub.com/qBittorrent.html">PGP signature</a></strong> (FossHub)<br/>
      <sub>Mirror link: <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent-mac/qbittorrent-4.2.5/qbittorrent-4.2.5.dmg/download">DMG</a> / <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent-mac/qbittorrent-4.2.5/qbittorrent-4.2.5.dmg.asc/download">PGP signature</a> (SourceForge)</sub>
    </p>
    <table>
      <br/><br/>
      <tbody>
        <tr>
          <td><strong>Checksum</strong></td>
          <td><strong>SHA2-256</strong></td>
        </tr>
        <tr>
          <td>DMG</td>
          <td class="wordBreak"><code>52f86aa8f0e3f5c15013d40ff7789861dc6afdce077dfa461ccff2a56ff0d8f7</code></td>
        </tr>
      </tbody>
      <tbody>
        <tr>
          <td><strong>Library</strong></td>
          <td><strong>Version</strong></td>
        </tr>
        <tr>
          <td class="nobr">libtorrent-rasterbar</td>
          <td>1.2.6+gita9968916ca</td>
        </tr>
        <tr>
          <td>Qt</td>
          <td>5.14.2</td>
        </tr>
        <tr>
          <td>Boost</td>
          <td>1.72.0</td>
        </tr>
      </tbody>
    </table>
  </div>
</div>
<br/>


<h3>Source Tarball</h3>
<div class="flexbox">
  <div class="box1">
    <img src="img/tar-logo.jpg" alt="tarball icon" width="100"/>
  </div>
  <div>
    <p>
      <strong>Current version: qBittorrent v4.2.5</strong>
    </p>
    <p>
      <strong>Download link: <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent/qbittorrent-4.2.5/qbittorrent-4.2.5.tar.gz/download">TAR.GZ</a> / <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent/qbittorrent-4.2.5/qbittorrent-4.2.5.tar.gz.asc/download">PGP signature</a></strong> (SourceForge)<br/>
      <strong>Download link: <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent/qbittorrent-4.2.5/qbittorrent-4.2.5.tar.xz/download">TAR.XZ</a> / <a href="https://sourceforge.net/projects/qbittorrent/files/qbittorrent/qbittorrent-4.2.5/qbittorrent-4.2.5.tar.xz.asc/download">PGP signature</a></strong> (SourceForge)
    </p>
    <p>
      Compile instructions over <a href="https://github.com/qbittorrent/qBittorrent/wiki#compilation" target="_blank">here</a>.
    </p>
    <table>
      <tbody>
        <tr>
          <td><strong>Checksum</strong></td>
          <td><strong>SHA2-256</strong></td>
        </tr>
        <tr>
          <td>TAR.GZ</td>
          <td class="wordBreak"><code>8b45080860f1322bae5e13866fadf132dc1a8b37a7eafac6c7a3021fa2c97976</code></td>
        </tr>
        <tr>
          <td>TAR.XZ</td>
          <td class="wordBreak"><code>4b57c86a22e485e5f19ae94881dfda7b8234aa1f20fb0ec6e04972b477f26a4f</code></td>
        </tr>
      </tbody>
      <tbody>
        <tr>
          <td><strong>Dependency</strong></td>
          <td><strong>Recommended version</strong></td>
        </tr>
        <tr>
          <td class="nobr">libtorrent-rasterbar</td>
          <td>1.2 branch latest release</td>
        </tr>
        <tr>
          <td>Qt</td>
          <td>Latest stable release</td>
        </tr>
        <tr>
          <td>Boost</td>
          <td>Latest stable release</td>
        </tr>
        <tr>
          <td>OpenSSL</td>
          <td>1.1 branch latest release</td>
        </tr>
        <tr>
          <td>zlib</td>
          <td>Latest stable release</td>
        </tr>
        <tr>
          <td>Python (optional, runtime only)</td>
          <td>Versions later than 3.3.0</td>
        </tr>
      </tbody>
    </table>
  </div>
</div>
<br/>

<h3>Other Binary Packages</h3>
<p>
  Select operating system:
  <select id="OSSelect" onchange="showOption(this)">
    <option value="emptyOS" selected>Choose...</option>
    <option value="os2">eComStation (OS/2)</option>
    <option value="freebsd">FreeBSD</option>
    <option value="haiku">Haiku</option>
    <option value="linux">Linux</option>
  </select>
</p>
<div id="linuxDiv" class="invisible">
  <p>
    Select distribution:
    <select id="distroSelect" onchange="showOption(this)">
      <option value="emptyDist" selected>Choose...</option>
      <option value="agilialinux">AgiliaLinux</option>
      <option value="altlinux">Alt Linux</option>
      <option value="archlinux">ArchLinux</option>
      <option value="blackpanther">blackPanther OS</option>
      <option value="debian">Debian</option>
      <option value="fedora">Fedora</option>
      <option value="gentoo">Gentoo</option>
      <option value="mageia">Mageia</option>
      <option value="mandriva">Mandriva</option>
      <option value="opensuse">OpenSuse</option>
      <option value="pardus">Pardus</option>
      <option value="slackware">Slackware</option>
      <option value="ubuntu">Ubuntu</option>
    </select>
  </p>
</div>

<div id="ubuntuDiv" class="invisible">
  <h4>Ubuntu packages</h4>
  <img src="img/os/ubuntulogo.png" alt="Ubuntu" style="float: left; margin-right: 5px;"/>
  <p>qBittorrent is now available in official Ubuntu repositories since v9.04 "Jaunty".
  <p>More up-to-date packages are published on our <a href="https://launchpad.net/~qbittorrent-team/+archive/ubuntu/qbittorrent-stable">stable</a>
    and <a href="https://launchpad.net/~qbittorrent-team/+archive/ubuntu/qbittorrent-unstable">unstable</a> PPAs.
    <br/>The <b>stable</b> PPA supports Ubuntu 14.04 LTS (only the libtorrent-rasterbar package), 16.04 LTS, 17.04, 17.10 and 18.04 LTS.
    <br/>The <b>unstable</b> PPA supports Ubuntu 16.04 LTS, 17.04, 17.10 and 18.04 LTS.
  </p>
  <h5>Quick instructions</h5>
  <p>To use these PPAs please use the following command and make sure your version is supported:</p>
  <div class="codePart" style="width: 500px;">
    <b># qBittorrent Stable</b><br/>
    sudo add-apt-repository ppa:qbittorrent-team/qbittorrent-stable<br/><br/>
    <b># or qBittorrent Unstable</b><br/>
    sudo add-apt-repository ppa:qbittorrent-team/qbittorrent-unstable
  </div>
  <p>Then install qBittorrent by doing this:</p>
  <div class="codePart" style="width: 500px;">
    sudo apt-get update &amp;&amp; sudo apt-get install qbittorrent
  </div>
</div>

<div id="debianDiv" class="invisible">
  <h4>Debian packages</h4>
  <img src="img/os/debianlogo.png" alt="Debian" style="float: left; margin-right: 5px;"/>
  <p>qBittorrent and libtorrent-rasterbar are now officially included in Debian. Packages are maintained by <a href="mailto:cristian.debian@gmail.com">Cristian Greco</a>. See this <a href="https://packages.debian.org/search?keywords=qbittorrent&searchon=names&suite=all&section=all">page</a> for more information.</p>
</div>

<div id="mandrivaDiv" class="invisible">
  <h4>Mandriva Linux packages</h4>
  <img src="img/os/mandrivalogo.png" alt="Mandriva" style="float: left; margin-right: 5px;"/>
  <p>qBittorrent is currently officially included in Mandriva Cooker. You can find more information <a href="http://doc4.mandriva.org/bin/view/d4/component/qbittorrent?d=cooker">here</a>.</p>
</div>

<div id="mageiaDiv" class="invisible">
  <h4>Mageia packages</h4>
  <img src="img/os/mageia.png" alt="Mageia" style="float: left; margin-right: 5px;"/>
  <p>qBittorrent is currently packaged in the Mageia official repositories.
    It is packaged by <a href="mailto:ahmad@mageia.org">Ahmad Samir</a>. To install it, make
    sure the online repositories are configured correctly then install it
    either:
  </p>
  <ul>
    <li>As root from terminal: 'urpmi qbittorrent' OR</li>
    <li>Using rpmdrake (aka "Install &amp; remove software")</li>
  </ul>
</div>

<div id="gentooDiv" class="invisible">
  <h4>Gentoo ebuilds</h4>
  <img src="img/os/gentoo.png" alt="Gentoo" style="float: left; margin-right: 5px;"/>qBittorrent is officially available in portage. You can install it easily on your system using emerge command. These ebuilds are maintained by <a href="mailto:zlogene@gentoo.org">Mikle Kolyada</a>. See <a href="https://packages.gentoo.org/packages/net-p2p/qbittorrent">this page</a> for more information.
</div>

<div id="opensuseDiv" class="invisible">
  <h4>OpenSuse packages</h4>
  <img src="img/os/opensuse.png" alt="openSUSE" style="float:left; margin-right:5px;"/>
  <p>qBittorrent has been in the OpenSuse official repository since v11.3. <br/>
    <br/>
    One-click install <a href="https://software.opensuse.org/package/qbittorrent">here</a>.
  </p>
</div>

<div id="fedoraDiv" class="invisible">
  <h4>Fedora packages</h4>
  <img src="img/os/fedoralogo.png" alt="Fedora" style="float: left; margin-right: 5px; width: 65px;"/>
  <p>qBittorrent is officially packaged on Fedora. RPM packages are maintained by <a href="mailto:leigh123linux@googlemail.com">Leigh Scott</a>.</p>
  <p>See this <a href="https://apps.fedoraproject.org/packages/qbittorrent/">page</a> for more information.</p>
</div>

<div id="slackwareDiv" class="invisible">
  <h4>Slackware scripts</h4>
  <img src="img/os/slackware.png" alt="Slackware" style="float: left; margin-right: 5px; width: 65px;"/>
  <p>qBittorrent is available for Slackware through <a href="https://slackbuilds.org/">slackbuilds.org</a>. The slackbuild script is maintained by <a href="mailto:info@davidwoodfall.co.uk">David Woodfall</a>. See this <a href="https://slackbuilds.org/repository/13.0/network/qbittorrent/">page</a> for more information.</p>
  <p><a href="mailto:alien@slackware.com">Eric Hameleers</a> is also maintaining binary packages for slackware. Those are available <a href="http://slackware.com/~alien/slackbuilds/qbittorrent/">there</a>.</p>
</div>

<div id="archlinuxDiv" class="invisible">
  <h4>ArchLinux packages</h4>
  <img src="img/os/archlinux.png" alt="ArchLinux" style="float: left; margin-right: 5px; width: 65px;"/>
  qBittorrent is officially packaged on <a href="https://www.archlinux.org/">ArchLinux</a>.
  To install, simply type the following commands:
  <div class="codePart" style="width:540px; margin:10px 10px 10px 5px; padding:5px;">
    sudo pacman -Sy qbittorrent
  </div>
  Package information <a href="https://www.archlinux.org/packages/?q=qbittorrent">here</a>.<br/><br/>
  For development, you can get PKGBUILD from Arch User Repository (AUR) and build it yourself:<br/>
  AUR (non-official) information <a href="https://aur.archlinux.org/packages/qbittorrent-git/">here</a>.
</div>

<div id="altlinuxDiv" class="invisible">
  <h4>Alt Linux packages</h4>
  <img src="img/os/altlinux.png" alt="Alt Linux" style="float: left; margin-right: 5px; width: 65px;"/>qBittorrent is officially packaged on <a href="http://www.altlinux.com">Alt Linux</a>. These packages are maintained by <a href="http://sisyphus.ru/en/packager/swi">Alexey Morsov</a>. Packages are available <a href="http://sisyphus.ru/en/srpm/Branch5/qbittorrent/">here</a>. To install, simply type the following commands:
  <div class="codePart" style="width:540px; margin:10px 10px 10px 5px; padding:5px;">
    sudo apt-get update &amp;&amp; sudo apt-get install qbittorrent
  </div>
</div>

<div id="agilialinuxDiv" class="invisible">
  <h4>AgiliaLinux packages</h4>
  <img src="img/os/agilialinux.png" alt="AgiliaLinux" style="float: left; margin-right: 5px; width: 65px;"/>qBittorrent is officially packaged on <a href="http://www.agilialinux.ru/">AgiliaLinux</a>. Packages are available <a href="http://packages.agilialinux.ru/search.php?lname=qbittorrent&version=&arch=&build=&hasfile=&which=&desc=">here</a>. To install, simply type the following command:
  <div class="codePart" style="width:540px; margin:10px 10px 10px 5px; padding:5px;">
    mpkg-install qbittorrent
  </div>
</div>

<div id="blackpantherDiv" class="invisible">
  <h4>blackPanther OS packages</h4>
  <img src="img/os/blackPanther-dark.png" alt="blackPanther OS" style="float: left; margin-right: 5px; width: 65px;"/>
  <p>qBittorrent is officially shipped on <a href="http://www.blackpanther.hu">blackPanther OS</a> CD as the default Bittorrent client. RPM packages are available <a href="ftp://ftp.blackpanther.hu/blackPanther/OS/All/Seeker/qbittorrent/">here</a>.</p>
  <p>These packages are maintained by <a href="mailto:kbarcza@blackpanther.hu">Charles Barcza</a>.</p>
</div>

<div id="freebsdDiv" class="invisible">
  <h4>FreeBSD packages</h4>
  <img src="img/os/freebsd.png" alt="FreeBSD" style="float: left; margin-right: 5px; width: 65px;"/>
  <p>qBittorrent is officially packaged for FreeBSD. <br/>
    More information about the port can he found <a href="http://www.freebsdsoftware.org/net-p2p/qbittorrent.html">here</a>.<br/><br/>
    To install qBittorrent, you should issue the following commands:
  </p>
  <div class="codePart" style="width:540px; margin:10px 10px 10px 5px; padding:5px;">
    export PACKAGESITE="ftp://ftp.freebsd.org/pub/FreeBSD/ports/i386/packages-8.0-release/Latest/"<br/>
    pkg_add -r qbittorrent
  </div>
</div>

<div id="haikuDiv" class="invisible">
  <h4>Haiku port</h4>
  <p><img src="img/os/haiku.png" alt="Haiku" style="float: left; margin-right: 5px;"/>qBittorrent is available in HaikuDepot.</p>
  <p>You can download it from <a href="https://depot.haiku-os.org/qbittorrent_x86">here</a>.</p>
</div>

<div id="pardusDiv" class="invisible">
  <h4>Pardus packages</h4>
  <img src="img/os/pardus.png" alt="Pardus" style="float: left; margin-right: 5px; width: 100px;"/>qBittorrent is officially available on <a href="http://www.pardus.org.tr/eng/">Pardus</a> via the contrib repository. These packages are maintained by <a href="http://packages.pardus.org.tr/info/contrib/2009/stable/packager/H.%20%C4%B0brahim%20G%C3%BCng%C3%B6r.html">H. İbrahim Güngör</a>. Packages are available <a href="http://packages.pardus.org.tr/info/contrib/2009/stable/source/qbittorrent.html">here</a>. <br/>
  <br/>To install, simply type the following command:
  <div class="codePart" style="width:540px; margin:10px 10px 10px 5px; padding:5px;">
    #Ensure the contrib repo is present on your system:<br/>
    sudo pisi ar contrib http://packages.pardus.org.tr/contrib-2009/pisi-index.xml.bz2<br/>
    <br/>
    #Enable the contrib repo if present but disabled:<br/>
    sudo pisi er contrib<br/>
    <br/>
    #Install qBittorrent:<br/>
    sudo pisi it qbittorrent<br/>
  </div>
</div>

<div id="os2Div" class="invisible">
  <img src="img/os/ecs_logo.png" alt="eComStation" style="float: left; margin-right: 5px; width: 100px;"/><br/>
  <p>qBittorrent is available on <a href="http://www.ecomstation.com/">eComStation (OS/2)</a> via this <a href="https://svn.netlabs.org/qtapps/wiki/QT4%20Networking">download</a> page.</p>
  <p>This package is maintained by <a href="mailto:silvan.scherrer@aroa.ch">Silvan Scherrer</a>.</p>
</div>

<hr class="invisible clear"/>
<br/>

<h3>Old Release Archive</h3>
<ul>
  <li><a href="https://www.fosshub.com/qBittorrent-old.html">FossHub</a></li>
  <li><a href="https://sourceforge.net/projects/qbittorrent/files/">SourceForge</a></li>
</ul>
<br/>

<script>
  'use strict';

  OSSelect.value = "emptyOS"
  distroSelect.value = "emptyDist"

  function setIdClassAttr(id, v)
  {
    var docElem = document.getElementById(id);
    if (docElem) docElem.className = v;
  }

  function showOption(elem)
  {
    var resetClassAttr = function(id, v) {
      var opts = document.getElementById(id).options;
      for (var i = 0; i < opts.length; ++i)
        setIdClassAttr(opts[i].value + "Div", v);
    };

    // reset all
    if (elem.id == "OSSelect") {
      resetClassAttr("OSSelect", "invisible");
      distroSelect.value = "emptyDist"
    }
    resetClassAttr("distroSelect", "invisible");

    setIdClassAttr(elem.value + "Div", "");  // display selected element
  }
</script>

<?php require_once('footer.inc.php');
