/*
 * This File is Part Of : 
 *      ___                       ___           ___           ___           ___           ___                 
 *     /  /\        ___          /__/\         /  /\         /__/\         /  /\         /  /\          ___   
 *    /  /::\      /  /\         \  \:\       /  /:/         \  \:\       /  /:/_       /  /::\        /  /\  
 *   /  /:/\:\    /  /:/          \  \:\     /  /:/           \__\:\     /  /:/ /\     /  /:/\:\      /  /:/  
 *  /  /:/~/:/   /__/::\      _____\__\:\   /  /:/  ___   ___ /  /::\   /  /:/ /:/_   /  /:/~/::\    /  /:/   
 * /__/:/ /:/___ \__\/\:\__  /__/::::::::\ /__/:/  /  /\ /__/\  /:/\:\ /__/:/ /:/ /\ /__/:/ /:/\:\  /  /::\   
 * \  \:\/:::::/    \  \:\/\ \  \:\~~\~~\/ \  \:\ /  /:/ \  \:\/:/__\/ \  \:\/:/ /:/ \  \:\/:/__\/ /__/:/\:\  
 *  \  \::/~~~~      \__\::/  \  \:\  ~~~   \  \:\  /:/   \  \::/       \  \::/ /:/   \  \::/      \__\/  \:\ 
 *   \  \:\          /__/:/    \  \:\        \  \:\/:/     \  \:\        \  \:\/:/     \  \:\           \  \:\
 *    \  \:\         \__\/      \  \:\        \  \::/       \  \:\        \  \::/       \  \:\           \__\/
 *     \__\/                     \__\/         \__\/         \__\/         \__\/         \__\/                
 *
 * Copyright (c) Rinnegatamante <rinnegatamante@gmail.com>
 *
 */

#ifndef _MEMORY_H_
#define _MEMORY_H_

extern int results_num;
extern int ram_mode;
extern uint8_t* FREEZE_LIST_OFFS;

#define MAX_FREEZES 1024 // Max number of freezable offsets
#define CHUNK_SIZE 0x80000 // Size of temporary chunks used in MMC mode

int checkHeap();
void scanMemory(uint32_t* cur_matches, void* mem, uint32_t mem_size, uint64_t val, int val_size);
int scanStack(void* stack_ptr, uint32_t stack_size, uint64_t val, int val_size);
int scanHeap(uint64_t val, int val_size);
void scanResults(uint64_t val, int val_size);
void injectValue(uint8_t* offset, uint64_t val, int val_size);
void injectStackFile(void* stack_ptr, int stack_size, char* file);
void injectMemory(uint64_t val, int val_size);
void saveOffsets(char* filename);
void freezeMemory(uint64_t val, int val_size);

#endif