/*
 * This File is Part Of : 
 *      ___                       ___           ___           ___           ___           ___                 
 *     /  /\        ___          /__/\         /  /\         /__/\         /  /\         /  /\          ___   
 *    /  /::\      /  /\         \  \:\       /  /:/         \  \:\       /  /:/_       /  /::\        /  /\  
 *   /  /:/\:\    /  /:/          \  \:\     /  /:/           \__\:\     /  /:/ /\     /  /:/\:\      /  /:/  
 *  /  /:/~/:/   /__/::\      _____\__\:\   /  /:/  ___   ___ /  /::\   /  /:/ /:/_   /  /:/~/::\    /  /:/   
 * /__/:/ /:/___ \__\/\:\__  /__/::::::::\ /__/:/  /  /\ /__/\  /:/\:\ /__/:/ /:/ /\ /__/:/ /:/\:\  /  /::\   
 * \  \:\/:::::/    \  \:\/\ \  \:\~~\~~\/ \  \:\ /  /:/ \  \:\/:/__\/ \  \:\/:/ /:/ \  \:\/:/__\/ /__/:/\:\  
 *  \  \::/~~~~      \__\::/  \  \:\  ~~~   \  \:\  /:/   \  \::/       \  \::/ /:/   \  \::/      \__\/  \:\ 
 *   \  \:\          /__/:/    \  \:\        \  \:\/:/     \  \:\        \  \:\/:/     \  \:\           \  \:\
 *    \  \:\         \__\/      \  \:\        \  \::/       \  \:\        \  \::/       \  \:\           \__\/
 *     \__\/                     \__\/         \__\/         \__\/         \__\/         \__\/                
 *
 * Copyright (c) Rinnegatamante <rinnegatamante@gmail.com>
 *
 */

#ifndef _FILESYSTEM_H_
#define _FILESYSTEM_H_

typedef struct cheatDB{
	char name[128];
	uint32_t offset;
	uint64_t val;
	uint8_t size;
	void* next;
	uint8_t state; // 0 = Disabled, 1 = Enabled, 2 = Freezed
}cheatDB;

typedef struct settings{
	uint16_t cpu_clock;
	uint16_t gpu_clock;
	uint16_t bus_clock;
	uint16_t gpu_xbar_clock;
	uint8_t suspend;
	uint8_t net;
	uint8_t screenshot;
	uint8_t video_quality;
}settings;

extern int numCheats;

cheatDB* loadCheatsDatabase(char* db_file, cheatDB* db);
int loadTitleSettings(char* titleid, settings* cfg);
void saveTitleSettings(char* titleid, settings* cfg);
uint8_t isDirectoryEmpty(char* dir);

#endif