<!--
Copyright (C) 2019 - 2019 ENCRYPTED SUPPORT LP <adrelanos@riseup.net>
See the file COPYING for copying conditions.
-->
<!DOCTYPE html>
<html itemscope itemtype="http://schema.org/WebPage" lang="en">

<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0" />
    <meta name="description" content="Free, Open Source, Kicksecure ™ Security Hardened Linux Distribution, designed for advanced online privacy, Live or Non-Live (Persistent) Mode." />
    <meta name="author" content="Whonix" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="@Whonix" />
    <meta name="twitter:creator" content="@Whonix" />
    <meta name="twitter:image" content="https://www.whonix.org/w/images/0/04/Whonix_Twitter_Social_Share.png" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="https://www.whonix.org"/>
    <meta property="og:title" content="Whonix ™ - Software That Can Anonymize Everything You Do Online" />
    <meta property="og:description" content="Free, Open Source, Kicksecure ™ Security Hardened Linux Distribution, designed for advanced online privacy, Live or Non-Live (Persistent) Mode." />
    <meta property="og:image" content="https://www.whonix.org/w/images/4/47/Whonix_Facebook_Social_Share.png" />
    <meta property="article:publisher" content="https://www.facebook.com/Whonix" />
    <meta property="author" content="https://www.facebook.com/Whonix" />
    <meta property="fb:admins" content="100007482551659" />
    <meta itemprop="name" content="Whonix" />
    <meta itemprop="description" content="Free, Open Source, Kicksecure ™ Security Hardened Linux Distribution, designed for advanced online privacy, Live or Non-Live (Persistent) Mode." />
    <meta itemprop="image" content="https://www.whonix.org/w/images/4/47/Whonix_Facebook_Social_Share.png" />
    <link rel="shortcut icon" href="https://www.whonix.org/w/images/favicon.ico" />
    <link rel="stylesheet" type="text/css" media="all" href="home.css" />
    <title>Whonix ™ - Software That Can Anonymize Everything You Do Online</title>
</head>

<body>
    <header>
        <nav>
            <ul>
                <li><a href="#download">Download</a></li>
                <li><a href="https://www.whonix.org/wiki/Documentation">Wiki</a></li>
                <li><a href="https://www.whonix.org/wiki/FAQ">FAQ</a></li>
                <li><a href="#features">Security Features</a></li>
                <li><a href="https://forums.whonix.org">Forum</a></li>
                <li><a href="https://forums.whonix.org/c/news">News</a></li>
                <li><a href="https://www.whonix.org/wiki/Donate">Donate</a></li>
            </ul>
        </nav>
    </header>

    <section class="section--hero section--stretched">
        <div class="section__detail grid">
            <div class="whole">
                <div id="banner">
                   <a href="https://www.whonix.org/w/images/b/ba/Whonix-vectorized-logo.png" target="_blank" rel="noopener">
                      <img src="https://www.whonix.org/w/images/b/ba/Whonix-vectorized-logo.png" width=500 height=165 alt="Whonix Logo" />
                   </a>
                </div>
                <h4>Software That Can Anonymize Everything You Do Online</h4>
                <h5>
                Learn
                <a href="https://www.whonix.org/wiki/FAQ" target="_blank" rel="noopener">What Is Whonix?</a>
                </h5>
            </div>
            <a href="https://www.whonix.org/w/images/6/6a/Whonix-workstation.jpg" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/6/6a/Whonix-workstation.jpg" alt="Whonix Desktop" width=1000 height=540 id="whonix-dekstop-pic"/>
            </a>
        </div>
    </section>
    <section id="download">
        <div class="grid">
            <div class="two-thirds">
                <h2>Download, Install, Run <a href="https://www.whonix.org/wiki/Why_Whonix_is_Freedom_Software" class="freelink">FREE</a></h2>
                <p>
                    Whonix <a href="https://www.whonix.org/wiki/Whonix_Trademark_Policy" target="_blank" rel="noopener">™</a>
                    isn't a program like most of your applications. It's a full
                    operating system that runs inside your current one. Select which
                    operating system your computer is running.
                </p>
            </div>
        </div>
        <div class="grid">
            <a class="nofocuslink" href="https://www.whonix.org/wiki/Windows_Quick_Start">
                <div class="third" id="win10">
                    <img src="https://www.whonix.org/w/images/e/ee/Windows_logo_-_2012.svg.png" alt="Download for Windows 10" />
                    <h4>Windows</h4>
                </div>
            </a>
            <a class="nofocuslink" href="https://www.whonix.org/wiki/VirtualBox">
                <div class="third">
                    <img src="https://www.whonix.org/w/images/a/af/Tux.png" alt="Download for Linux" />
                    <h4>Linux</h4>
                    <p>Run it with VirtualBox</p>
                </div>
            </a>
            <a class="nofocuslink" href="https://www.whonix.org/wiki/MacOS">
                <div class="third">
                    <img src="https://www.whonix.org/w/images/3/36/Macos_by_ego_no_background.png" alt="Download for Mac" />
                    <h4>macOS</h4>
                    <p>Run it with VirtualBox</p>
                </div>
            </a>
            <a class="nofocuslink" href="https://www.whonix.org/wiki/Qubes">
                <div class="third">
                    <img src="https://www.whonix.org/w/images/9/94/Qubes-logo-blue.png" width=128 height=128 alt="Download for Qubes" />
                    <h4>Qubes</h4>
                </div>
            </a>
            <a class="nofocuslink" href="https://www.whonix.org/wiki/KVM">
                <div class="third">
                    <img src="https://www.whonix.org/w/images/thumb/b/bb/Kvm.png/150px-Kvm.png" alt="Download for KVM" />
                    <h4>KVM</h4>
                    <p>For those who prefer KVM over VirtualBox</p>
                </div>
            </a>
        </div>
    </section>
    <section class="grid" id="the-press">
        <div class="third">
            <a href="https://freedom.press" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/c/ca/Fpf.svg" alt="Freedom of the Press Foundation" />
            </a>
            ”<a href="https://securedrop.org" target="_blank" rel="noopener">SecureDrop</a>
            Journalist Workstation
            <a href="https://github.com/freedomofpress/securedrop-workstation" target="_blank" rel="noopener">
            environment for submission handling</a>
            is based on Qubes-Whonix.”
        </div>
        <div class="third">
            <a href="https://wired.com" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/e/e5/Wired.svg" alt="Wired" />
            </a>
            <a href="https://www.wired.com/2014/06/be-anonymous-online" target="_blank" rel="noopener">
                ”For the even more paranoid, there is a lesser-known Tor-enabled OS
                called Whonix”
            </a>
        </div>
        <div class="third">
            <a href="https://www.theguardian.com/technology/2015/mar/06/tips-tricks-anonymous-privacy" target="_blank"
                rel="noopener">
                <img src="https://www.whonix.org/w/images/7/75/The_Guardian_2018.svg" alt="The Guardian" />
            </a>
            <a href="https://www.theguardian.com/technology/2015/mar/06/tips-tricks-anonymous-privacy" target="_blank" rel="noopener">
                ”Whonix is about as anonymous as an OS can get before it all becomes
                too inconvenient for normal use.”
            </a>
        </div>
        <div class="third">
            <a href="https://theintercept.com/2015/09/16/getting-hacked-doesnt-bad/" target="_blank"
                rel="noopener">
                <img src="https://www.whonix.org/w/images/1/14/The_Intercept_logo.svg" alt="The Intercept" />
            </a>
            <a href="https://theintercept.com/2015/09/16/getting-hacked-doesnt-bad/" target="_blank" rel="noopener">
                ”Whonix, an operating system you can run in a virtual machine to maximize your online anonymity; it’s ideal for maintaining a secret identity.”
            </a>
        </div>
        <div class="third">
            <a href="https://www.techrepublic.com/blog/smb-technologist/whonix-adds-a-layer-of-anonymity-to-your-business-tasks/" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/5/52/TechRepublic-ConvertImage.png" width=352 height=128 alt="TechRepublic" />
            </a>
            <a href="https://www.techrepublic.com/blog/smb-technologist/whonix-adds-a-layer-of-anonymity-to-your-business-tasks/">
                 ”Whonix adds a layer of anonymity to your business tasks.”
            </a>
        </div>
        <div class="third">
            <a href="https://torproject.org" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/thumb/4/44/2880px-Tor-logo-2011-flat.svg.png/470px-2880px-Tor-logo-2011-flat.svg.png" width=212 height=128 alt="The Tor Project Logo" />
            </a>
            <a href="https://blog.torproject.org/tor-heart-whonix" target="_blank" rel="noopener">
                ”Whonix is a privacy ecosystem that utilizes compartmentalization to
                provide a private, leak-resistant environment for many desktop
                computing activities. Whonix helps users use their favorite desktop
                applications anonymously.”
            </a>
            <p>The Tor
            <a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a> Project
            </p>
        </div>
        <div class="third">
            <a href="https://twitter.com/Snowden" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/2/20/Expert-edward-snowden.jpg" width=128 height=128 alt="Edward Snowden" />
            </a>
            <a href="https://twitter.com/Snowden/status/1165607338973130752" target="_blank" rel="noopener">
                ”I use Qubes and a Whonix gateway literally everyday”
            </a>
            <p>
               Edward Snowden, whistleblower, privacy advocate,
               <a href="https://freedom.press/people/edward-snowden/" target="_blank" rel="noopener">president of the Freedom of the Press Foundation board</a>
               <a href="https://twitter.com/Snowden/status/1165607338973130752" target="_blank" rel="noopener">[1]</a>
               <a href="https://twitter.com/Snowden/status/1175435436501667840" target="_blank" rel="noopener">[2]</a>
               <a href="https://twitter.com/Snowden/status/781495273726025728" target="_blank" rel="noopener">[3]</a>
            </p>
        </div>
        <div class="third">
            <a href="https://micahflee.com" target="_blank" rel="noopener">
               <img src="https://www.whonix.org/w/images/f/fb/Expert-micah-lee-ConvertImage.jpg" width=128 height=128 alt="Micah Lee" />
            </a>
            <a href="https://theintercept.com/2015/09/16/getting-hacked-doesnt-bad" target="_blank" rel="noopener">
                “Whonix is great because you can be confident that everything you do
                in the workstation VM is anonymously going through the Tor network.”
            </a>
            <p>Micah Lee, journalist and security engineer</p>
        </div>
    </section>
    <section id="tbb" class="tbb">
        <div class="app-display app-display--horizontal">
            <div class="app-display__description">
                <h2>
                    All activity in a virtual machine, all internet traffic through
                    Tor<a class="nofocuslink" href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a>
                    network
                </h2>
                <p>
                    Whonix is the best way to use Tor<a class="nofocuslink" href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a> and is strongest protection of
                    your IP address.
                </p>
            </div>
            <img class="app-display__image" src="https://www.whonix.org/w/images/1/11/Tor_browser_duckduckgo2.jpg" width=1016 height=555 alt="Tor Browser with duckduckgo" />
        </div>
    </section>
    <section id="applications" class="showcase" style="background-image: url(https://www.whonix.org/w/images/b/bd/6C3FA495.jpg);">
        <div class="showcase-index">
            <div>
                <h2>Applications are reviewed and pre-configured.</h2>
            </div>
            <ul class="showcase-grid">
                <li class=""><a href="https://www.whonix.org/wiki/Tor_Browser" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/3/3a/Torbrowser_icon.png" alt="" />Tor Browser</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/OnionShare" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/d/de/Onionshare_logo.png" alt="" />OnionShare</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Encrypted_Email_with_Thunderbird_and_Enigmail" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/b/b1/Thunderbird256.png" alt="" />Thunderbird</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Passwords" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/5/51/KeePassXC.png" alt="" />KeePassXC</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/HexChat" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/7/7b/Hexchaticon.png" alt="" />HexChat</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Software#Media_Player" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/thumb/c/cd/2000px-VLC_Icon.svg.png/64px-2000px-VLC_Icon.svg.png" alt="" />VLC</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Software#Terminal" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/c/c2/Utilities-terminal.png" alt="" />Terminal</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Electrum" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/6/63/Electrum-appimage.png" width=64 height=58 alt="" />Electrum</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Bitcoin" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/2/29/BC_Logo_.png" alt="" />Bitcoin</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Monero" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/0/05/Monero-symbol-1280.png" alt="" />Monero</a></li>
            </ul>
        </div>
    </section>
    <section id="features" class="features">
        <div class="grid">
            <div class="two-thirds">
                <h2>Fully Featured and Advanced Security Features</h2>
            </div>
        </div>
        <div class="grid">
            <div class="third">
                <a href="https://www.whonix.org/w/images/d/dd/Whonix_concept_refined.jpg" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/d/dd/Whonix_concept_refined.jpg" alt="Leak IP Address" />
                </a>
                <h4>Impossible to leak IP address</h4>
                <p>
                    Connections are forced through Tor<a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a>. DNS leaks are impossible, and
                    even malware with root privileges cannot discover the user's real IP
                    address. Leak tested through <a href="https://github.com/Whonix/corridor" title="Corridor">corridor</a> (Tor<a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a> traffic whitelisting gateway) and other <a href="https://www.whonix.org/wiki/Dev/Leak_Tests">leak tests</a>.
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/w/images/b/bf/Live_boot.png" target="_blank" rel="noopener">
                   <img src="https://www.whonix.org/w/images/0/09/Live_boot_cropped_more.jpeg"  alt="Live Mode" />
                </a>
                <h4>Live Mode</h4>
                <p>
                    Booting into <a href="https://www.whonix.org/wiki/Whonix_Live" target="_blank" rel="noopener">Live Mode</a> is a simple as choosing Live Mode in the boot menu.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/5/52/Hardening-13423213.jpg" alt="Kicksecure" />
                <h4>Based on Kicksecure ™</h4>
                <p>
                    Whonix <a href="https://www.whonix.org/wiki/Whonix_Trademark_Policy" target="_blank" rel="noopener">™</a> is based on <a href="https://www.whonix.org/wiki/Kicksecure" target="_blank" rel="noopener">Kicksecure</a> ™ which is a a security-hardened Linux distribution.
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/w/images/f/fb/Htw2.png" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/f/fb/Htw2.png" alt="Tor" />
                </a>
                <h4>Based on Tor<a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a></h4>
                <p>
                    Whonix <a href="https://www.whonix.org/wiki/Whonix_and_Tor" target="_blank" rel="noopener">utilizes</a> Tor<a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a>, which provides an open and distributed relay network to defend against network surveillance.
                </p>
            </div>
            <div class="third">
                <a href="https://github.com/vmonaco/kloak#try-it-out" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/d/d6/Train-normal_test-kloak.png" width=160 height=160 alt="kloak" />
                </a>
                <h4>Keystroke Anonymization</h4>
                <p>
                     <a href="https://www.whonix.org/wiki/Keystroke_Deanonymization" target="_blank" rel="noopener">Keystrokes</a> can be used to track users. To prevent this, Whonix comes with <a href="https://www.whonix.org/wiki/Keystroke_Deanonymization#Kloak" target="_blank" rel="noopener">kloak</a> installed by default.
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/wiki/Dev/TimeSync" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/0/04/Carriage-clock-797833640.jpg" alt="time" />
                </a>
                <h4>Time Attack Defenses</h4>
                <p>
                    <a href="https://www.whonix.org/wiki/Time_Attacks" target="_blank" rel="noopener">Time attacks</a> are defeated by
                    <a href="https://www.whonix.org/wiki/Boot_Clock_Randomization" target="_blank" rel="noopener">Boot Clock Randomization</a>
                    and secure network time synchronization
                    through <a href="https://www.whonix.org/wiki/sdwdate" target="_blank" rel="noopener">sdwdate</a> (Secure Distributed Web Date).
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/wiki/vanguards" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/thumb/2/2b/Entry_guard111.jpg/593px-Entry_guard111.jpg" width=158 height=160 alt="vanguards" />
                </a>
                <h4>Protect against guard discovery and related traffic analysis attacks</h4>
                <p>
                    <a href="https://www.whonix.org/wiki/vanguards">vanguards</a>
                </p>
            </div>
            <div class="third">
                <a href="https://github.com/Whonix/tirdad" target="_blank" rel="noopener">
                <img src="https://www.whonix.org/w/images/f/f0/Resized_tirdad2.jpg" width=240 height=160 alt="tirdad" />
                </a>
                <h4>TCP ISN CPU Information Leak Protection</h4>
                <p>
                     Prevent <a target="_blank" rel="noreferrer noopener" class="external text" href="https://dl.acm.org/citation.cfm?id=1180410">de-anonymization of Tor onion services</a> through <a target="_blank" rel="noreferrer noopener" class="external text" href="https://github.com/Whonix/tirdad">Tirdad kernel module for random ISN generation</a>.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/f/fb/Random_entropy_background_removed.png" alt="entropy" />
                <h4>Entropy Enhancements</h4>
                <p>
                     Better encryption thanks to <a href="https://www.whonix.org/wiki/Dev/Entropy" target="_blank" rel="noopener">preinstalled</a> random number generators.
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/w/images/f/fc/Stream_isolation.1.0.jpg" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/f/fc/Stream_isolation.1.0.jpg" width=124 height=160 alt="Stream Isolation" />
                </a>
                <h4>Stream Isolation</h4>
                <p>
                    Different applications are routed through different paths through the Tor<a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a> network.
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/wiki/AppArmor" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/thumb/3/3f/2000px-AppArmor_logo.svg.png/705px-2000px-AppArmor_logo.svg.png" alt="AppArmor" />
                </a>
                <h4>AppArmor</h4>
                <p>
                    <a href="https://www.whonix.org/wiki/AppArmor" target="_blank" rel="noopener">AppArmor</a> profiles to restrict the capabilities of commonly used, high-risk applications.
                </p>
            </div>
            <div class="third">
                <a href="https://github.com/Whonix/security-misc" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/7/7b/Overlord59-tux-halo.png" alt="security-misc" />
                </a>
                <h4>Kernel Self Protection Settings</h4>
                <p>
                        Whonix uses <a href="https://github.com/Whonix/security-misc" target="_blank" rel="noopener">Kernel Hardening Settings</a> as recommended by the Kernel Self Protection Project (KSPP).
                </p>
            </div>
            <div class="third">
                <a href="https://github.com/Whonix/security-misc" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/thumb/d/d7/Franck-v-_E1PQXKUkMw-unsplash.jpg/361px-Franck-v-_E1PQXKUkMw-unsplash.jpg" width=241 height=160 alt="" />
                </a>
                <h4>Protect Linux user accounts against brute force attacks</h4>
                <p>
                   <a href="https://github.com/Whonix/security-misc" target="_blank" rel="noopener">By using pam tally2.</a>
                </p>
            </div>
            <div class="third">
                <a href="https://github.com/Whonix/security-misc" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/d/d1/Oshardening34234.jpg" alt="security-misc" />
                </a>
                <h4>Strong Linux User Account Separation</h4>
                <p>
                   <a href="https://github.com/Whonix/security-misc" target="_blank" rel="noopener">security-misc</a>
                </p>
            </div>
            <div class="third">
                <a href="https://github.com/Whonix/anon-apps-config" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/6/61/Preferences_system.png" alt="anon-apps-config" />
                </a>
                <h4>anonymity, privacy and security settings pre-configuration</h4>
                <p>
                   <a href="https://github.com/Whonix/anon-apps-config" target="_blank" rel="noopener">anon-apps-config</a>
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/wiki/Documentation" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/thumb/5/55/Advanceddocumentation213123.jpg/300px-Advanceddocumentation213123.jpg" width=240 height=160 alt="Documentation" />
                </a>
                <h4>Extensive Documentation</h4>
                <p>
                <a href="https://www.whonix.org/wiki/Documentation" target="_blank" rel="noopener">The more you know, the safer you can be.</a>
                </p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/wiki/Anbox" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/1/1f/Anbox.jpg" alt="anbox" />
                </a>
                <h4>Android Support</h4>
                <p>
                    Run Android Application using
                    <a href="https://www.whonix.org/wiki/Anbox" target="_blank" rel="noopener">anbox</a>.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/c/cf/Shield.png" width=160 height=160 alt="Virus Protection" />
                <h4>Virus Protection</h4>
                <p>
                Additional Security Hardening measures and user education through Whonix provide better protection from <a href="https://www.whonix.org/wiki/Malware" target="_blank" rel="noopener">viruses</a>.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/7/74/Console-lockdown.jpg/800px-Console-lockdown.jpg" width=284 height=160 alt="Console Lockdown" />
                <h4>Console Lockdown</h4>
                <p>
                    <a href="https://www.whonix.org/wiki/Dev/Strong_Linux_User_Account_Isolation#Console_Lockdown" target="_blank" rel="noopener">
                        Console Lockdown
                    </a> disables legacy login methods for improved security hardening.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/5/52/Firewall-29940640.jpg" alt="Advanced Firewall" />
                <h4>Advanced Firewall</h4>
                <p>Configured for anonymous Tor<a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a> use.</p>
            </div>
            <div class="third">
                <a href="https://www.whonix.org/w/images/b/b8/Tor_browser_youtube.jpeg" target="_blank" rel="noopener">
                  <img src="https://www.whonix.org/w/images/thumb/b/b8/Tor_browser_youtube.jpeg/470px-Tor_browser_youtube.jpeg" width=293 height=160 alt="YouTube" />
                </a>
                <h4>Tor<a href="https://2019.www.torproject.org/docs/trademark-faq.html.en" target="_blank" rel="noopener">&reg;</a> Browser</h4>
                <p>Visit any website including modern websites such as YouTube.</p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/9/91/Encrypted-156514_1280.png/150px-Encrypted-156514_1280.png" alt="YouTube" />
                <h4>swap-file-creator</h4>
                <p>Running low on RAM isn't a security problem. <a href="https://github.com/Whonix/swap-file-creator" target="_blank" rel="noopener">swap-file-creator</a>
                will create an encrypted swap file.</p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/0/07/Computer_n_screen.png/200px-Computer_n_screen.png" alt="server" />
                <h4>Hosting Location Hidden Servers</h4>
                <p>Whonix is the safest way to <a href="https://www.whonix.org/wiki/Onion_Services" target="_blank" rel="noopener">Onion Services</a>
                .</p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/c/cf/Discourse_logo.svg" alt="Forums and more" />
                <h4>Vibrant Community</h4>
                <p>
                    <a class="read-more" href="https://forums.whonix.org"
                        target="_blank" rel="noopener">
                        Forums </a>
                    <br />
                    <a class="read-more" href="https://t.me/Whonix_Chat"
                        target="_blank" rel="noopener">
                        Telegram </a><br />
                    <a class="read-more" href="https://www.whonix.org/cgi-bin/mailman/listinfo/whonix-newsletter"
                        target="_blank" rel="noopener">
                        Newsletter
                    </a>
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/a/a3/Jon-tyson-FlHdnPO6dlw-unsplash.jpg/187px-Jon-tyson-FlHdnPO6dlw-unsplash.jpg" width=120 height=160 alt="History" />
                <h4>History</h4>
                <p>
                     An eight year <a href="https://www.whonix.org/wiki/History" target="_blank" rel="noopener">history</a>
                     of protecting our users against
                     <a href="https://www.whonix.org/wiki/Security_in_Real_World" target="_blank" rel="noopener">Real World Attacks.</a>
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/4/44/Bho78-4ycp0.jpg/362px-Bho78-4ycp0.jpg" width=241 height=160 alt="Fully Auditable" />
                <h4>Fully auditable</h4>
                <p>
                    You don’t have to trust our word that it respects and protects you.
                    It is independently verifiable by security experts and software
                    developers around the world.
                    <a href="https://www.whonix.org/wiki/Why_Whonix_is_Freedom_Software" target="_blank" rel="noopener">
                        This improves security and privacy for everyone.
                    </a>
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/9/93/Hunters-race-MYbhN8KaaEc-unsplash.jpg/705px-Hunters-race-MYbhN8KaaEc-unsplash.jpg" alt="privacy" />
                <h4>Complete respect for privacy</h4>
                <p>
                  Your data always belongs to you, and only you. We don’t make advertising deals or collect sensitive personal data. We’re funded directly by our users paying what they want. And that’s how it should be.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/2/2c/Zdenek-machacek-OlKkCmToXEs-unsplash.jpg/470px-Zdenek-machacek-OlKkCmToXEs-unsplash.jpg" alt="Canary" />
                <h4>Warrant Canary</h4>
                <p>
                    A <a href="https://www.whonix.org/wiki/Trust#canary" target="_blank" rel="noopener">canary</a>
                    confirms that no warrants have been served on the Whonix project.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/3/30/Debian.png" width=130 height=160 alt="Debian" />
                <h4>Based on Debian</h4>
                <p>
                  In oversimplified terms, Whonix is just a collection of configuration files and scripts. Whonix is not a stripped down version of Debian; anything possible in "vanilla" Debian GNU/Linux can be replicated in Whonix.
                  <a href="https://www.whonix.org/wiki/About" target="_blank" rel="noopener">About Whonix</a>
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/2/28/Neonbrand-lJ6iASrFAnQ-unsplash.jpg/470px-Neonbrand-lJ6iASrFAnQ-unsplash.jpg" alt="Freedom" />
                <h4>Complete user freedom</h4>
                <p>
                  There are no artificial restrictions on how users can reconfigure the system.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/e/e4/Iconfinder_gpg_6334.png" alt="signed" />
                <h4>Digitally signed releases</h4>
                <p>
                 Downloads are <a href="https://www.whonix.org/wiki/Verifying_Software_Signatures" target="_blank" rel="noopener">signed</a> so you can <a href="https://www.whonix.org/wiki/Verify_the_Whonix_images" target="_blank" rel="noopener">verify</a> they are genuine Whonix releases.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/a/a3/Heckert_gnu.big.png" width=164 height=160 alt="GNU" />
                <h4>Freedom Software</h4>
                <p>
                 Whonix is
                 <a href="https://forums.whonix.org/t/lets-call-it-freedom-software-rather-than-free-software-or-open-source/6961" target="_blank" rel="noopener">Freedom Software</a>
                 and contains software developed by the
                 <a href="https://www.fsf.org/" target="_blank" rel="noopener">Free Software Foundation</a>
                 and the
                 <a href="https://www.gnu.org" target="_blank" rel="noopener">GNU Project</a>
                 .
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/0/09/Osi_standard_logo_0.png/470px-Osi_standard_logo_0.png" alt="OpenSource" />
                <h4>Open Source</h4>
                <p>
                 All of <a href="https://github.com/Whonix" target="_blank" rel="noopener">Whonix source code</a> is
                 <a href="https://www.whonix.org/wiki/Whonix:Copyrights#License" target="_blank" rel="noopener">licensed</a>
                 under <a href="https://opensource.org/licenses/" target="_blank" rel="noopener">OSI Approved Licenses</a>. We respect the rights of our users. All of Whonix is available for review, scrutiny, modification, and redistribution by anyone. Which improves security and privacy for everyone.
                </p>
            </div>
            <div class="third">
                <img src="https://www.whonix.org/w/images/thumb/7/7f/Cornues.png/128px-Cornues.png" alt="research" />
                <h4><a href="https://www.whonix.org/wiki/What_we_do" title="Research">Research</a> and Implementation Project </h4>
                <p>
                     Be wary of those confidently calling themselves all-knowing, all-perfect. Whonix is an actively maintained research project making constant improvements -- no <a href="https://www.whonix.org/wiki/Warning" title="Warning">shortcomings</a> are ever hidden from users.
                </p>
            </div>
        </div>
    </section>
    <section id="security" class="security">
        <div class="app-display app-display--overflow">
            <img class="app-display__image" src="https://www.whonix.org/w/images/4/49/Workstationhardening.jpg" width=640 height=556 alt="Security" />
            <div class="app-display__description">
                <h2>Upcoming Security Enhancements</h2>
                <h4>
                    <img src="https://www.whonix.org/w/images/a/a7/P_lkrg2.png" alt="LKRG" />
                    <a href="https://www.whonix.org/wiki/Linux_Kernel_Runtime_Guard_LKRG" target="_blank" rel="noopener">
                        Linux Kernel Runtime Guard (LKRG)
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/7/79/Mandatoryaccesscontrol.jpg/800px-Mandatoryaccesscontrol.jpg" alt="" />
                    <a href="https://github.com/Whonix/apparmor-profile-everything" target="_blank" rel="noopener">
                        Full system Mandatory Access Control (MAC) policy - "AppArmor for everything"
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/5/53/Untrustedrootaccess.jpg/800px-Untrustedrootaccess.jpg" alt="" />
                    <a href="https://forums.whonix.org/t/untrusted-root-does-it-make-sense-to-try-to-improve-security-by-restricting-root/7998" target="_blank" rel="noopener">
                        Untrusted Root User
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/e/e1/Verifykernel.png/411px-Verifykernel.png" alt="" />
                    <a href="https://forums.whonix.org/t/allow-loading-signed-kernel-modules-by-default-disallow-kernel-module-loading-by-default/7880" target="_blank" rel="noopener">
                        enforce kernel module software signature verification
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/d/da/Text_x_patch.png" alt="" />
                    <a href="https://www.whonix.org/wiki/Dev/VirusForget" target="_blank" rel="noopener">
                        deactivate malware after reboot from non-root compromise
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/6/6d/Hardenkernel.jpg/800px-Hardenkernel.jpg" alt="" />
                    <a href="https://github.com/Whonix/hardened-kernel" target="_blank" rel="noopener">
                        Hardened Linux Kernel
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/9/90/Postquantum.jpg/800px-Postquantum.jpg" alt="" />
                    <a href="https://forums.whonix.org/t/use-codecrypt-to-sign-whonix-releases/7844/2" target="_blank" rel="noopener">
                        post-quantum cryptography resistant signing of releases
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/7/7b/Mountoptions.jpg/800px-Mountoptions.jpg" alt="" />
                    <a href="https://forums.whonix.org/t/re-mount-home-and-other-with-noexec-and-nosuid-among-other-useful-mount-options-for-better-security/7707" target="_blank" rel="noopener">
                        Mount Options Hardening
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/e/ed/Disablesuidbinary.jpg/800px-Disablesuidbinary.jpg" alt="" />
                    <a href="https://forums.whonix.org/t/disable-suid-binaries/7706" target="_blank" rel="noopener">
                        Disable SUID Binaries
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/thumb/7/7c/Multipleboot.jpg/800px-Multipleboot.jpg" alt="" />
                    <a href="https://forums.whonix.org/t/multiple-boot-modes-for-better-security-persistent-root-persistent-noroot-live-root-live-noroot/7708" target="_blank" rel="noopener">
                        multiple boot modes for better security: persistent user | live user | persistent admin
                    </a>
                </h4>
                <h4>
                    <img src="https://www.whonix.org/w/images/0/07/Computer_n_screen.png" alt="" />
                    <a href="https://www.whonix.org/wiki/Contribute" target="_blank" rel="noopener">
                        Help welcome!
                    </a>
                </h4>
            </div>
        </div>
    </section>
    <section id="compatibility" class="showcase" style="background-image: url(https://www.whonix.org/w/images/b/bd/6C3FA495.jpg);">
        <div class="showcase-index">
            <div>
                <h2>Compatibility</h2>
            </div>
            <ul class="showcase-grid">
                <li class=""><a href="https://www.whonix.org/wiki/VirtualBox" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/thumb/d/d5/Virtualbox_logo.png/100px-Virtualbox_logo.png" width=64 height=64 alt="" />VirtualBox</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/KVM" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/thumb/b/bb/Kvm.png/150px-Kvm.png" width=64 height=64 alt="" />KVM</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Qubes" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/9/94/Qubes-logo-blue.png" width=64 height=64 alt="" />Qubes OS</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Debian" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/3/30/Debian.png" width=64 height=64 alt="" />Debian</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Ubuntu" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/b/be/Logo-ubuntusvg.png" width=64 height=64 alt="" />Ubuntu&reg;</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/MacOS" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/3/36/Macos_by_ego_no_background.png" width=64 height=64 alt="" />macOS</a></li>
                <li class=""><a href="https://www.whonix.org/wiki/Windows_Quick_Start" target="_blank" rel="noopener"><img src="https://www.whonix.org/w/images/e/ee/Windows_logo_-_2012.svg.png" width=64 height=64 alt="" />Windows</a></li>
            </ul>
        </div>
    </section>
    <section id="newsletter" class="features" style="text-align:center;">
        <div class="app-display app-display--overflow">
            <img class="app-display__image" src="https://www.whonix.org/w/images/8/84/Iconfinder_news_18421.png" alt="Whonix Newsletter" />
            <div class="app-display__description">
                <h2>
                Subscribe to Whonix Newsletter
                </h2>
                  <form method="POST" action="https://www.whonix.org/cgi-bin/mailman/subscribe/whonix-newsletter">
                     Your email address: <input type="text" name="Email">
                     <input type="submit" name="sub" value="Subscribe">
                  </form>
                  <form method="POST" action="https://www.whonix.org/cgi-bin/mailman/options/whonix-newsletter">
                     <input type="submit" name="sub" value="Unsubscribe">
                  </form>
            </div>
        </div>
    </section>
    <section id="investors" class="security">
        <div class="app-display app-display--overflow">
            <img class="app-display__image" src="https://www.whonix.org/w/images/b/b8/Professional12313.jpg" alt="Investors" />
            <div class="app-display__description">
                <h2>Investors</h2>
                <h4>
                    Interested in becoming an investor? See
                    <a href="https://www.whonix.org/wiki/Investors" target="_blank" rel="noopener">
                        Project Metrics
                    </a>.
                </h4>
            </div>
        </div>
    </section>
    <footer>
Want to improve this page? Help is welcome and volunteer contributions are happily considered! Read, understand and agree to
<a href="https://www.whonix.org/wiki/Whonix:Copyrights#Conditions_for_Contributions_to_Whonix_.E2.84.A2" target="_blank" rel="noopener">Conditions for Contributions to Whonix ™</a>
, then edit
<a href="https://github.com/Whonix/Whonix-Website" target="_blank" rel="noopener">whonix.org frontpage wiki source code</a>!<br />
<br />
Whonix <a href="https://www.whonix.org/wiki/Whonix_Trademark_Policy" target="_blank" rel="noopener">™</a> is produced independently from the Tor<a class="read-more" href="https://2019.www.torproject.org/docs/trademark-faq.html.en">&reg;</a> anonymity software and carries no guarantee from <a class="read-more" href="https://www.torproject.org">The Tor Project</a> about quality, suitability or anything else.
        <ul>
            <li id="footer-Imprint">
                <a href="https://www.whonix.org/wiki/Imprint" title="Imprint">Imprint</a>
            </li>
            <li id="footer-Privacy_Policy">
                <a href="https://www.whonix.org/wiki/Privacy_Policy" title="Privacy Policy">Privacy Policy</a>
            </li>
            <li id="footer-Cookie_Policy">
                <a href="https://www.whonix.org/wiki/Cookie_Policy" title="Cookie Policy">Cookie Policy</a>
            </li>
            <li id="footer-Terms_of_Service">
                <a href="https://www.whonix.org/wiki/Terms_of_Service" title="Terms of Service">Terms of Service</a>
            </li>
            <li id="footer-DMCA">
                <a href="https://www.whonix.org/wiki/DMCA" class="mw-redirect" title="DMCA">DMCA</a>
            </li>
            <li id="footer-E_Sign_Consent">
                <a href="https://www.whonix.org/wiki/E-Sign_Consent" title="E-Sign Consent">E-Sign Consent</a>
            </li>
            <li id="footer-Priority_Support">
                <a href="https://www.whonix.org/wiki/Priority_Support" title="Priority Support">Priority Support</a>
            </li>
            <li id="footer-Investors">
                <a href="https://www.whonix.org/wiki/Investors" title="Investors">Investors</a>
            </li>
            <li id="footer-Professional_Support">
                <a href="https://www.whonix.org/wiki/Professional_Support" title="Professional Support">Professional Support</a>
            </li>
        </ul>
    </footer>
</body>
</html>
