# Network Configuration for Kicksecure CLI #

Disables systemd Predictable Network Interface Names.

Configures DNS by shipping a configuration file /etc/resolv.conf for
Kicksecure.

Disables systemd-resolved during boot unless file /etc/dns-enable exists.

Disables systemd-resolved fallback DNS (which by default is set to Google).

Enables DNSCrypt.
## How to install `kicksecure-network-conf` using apt-get ##

1\. Download [Whonix's Signing Key]().

```
wget https://www.whonix.org/patrick.asc
```

Users can [check Whonix Signing Key](https://www.whonix.org/wiki/Whonix_Signing_Key) for better security.

2\. Add Whonix's signing key.

```
sudo apt-key --keyring /etc/apt/trusted.gpg.d/whonix.gpg add ~/patrick.asc
```

3\. Add Whonix's APT repository.

```
echo "deb https://deb.whonix.org buster main contrib non-free" | sudo tee /etc/apt/sources.list.d/whonix.list
```

4\. Update your package lists.

```
sudo apt-get update
```

5\. Install `kicksecure-network-conf`.

```
sudo apt-get install kicksecure-network-conf
```

## How to Build deb Package from Source Code ##

Can be build using standard Debian package build tools such as:

```
dpkg-buildpackage -b
```

See instructions. (Replace `generic-package` with the actual name of this package `kicksecure-network-conf`.)

* **A)** [easy](https://www.whonix.org/wiki/Dev/Build_Documentation/generic-package/easy), _OR_
* **B)** [including verifying software signatures](https://www.whonix.org/wiki/Dev/Build_Documentation/generic-package)

## Contact ##

* [Free Forum Support](https://forums.whonix.org)
* [Professional Support](https://www.whonix.org/wiki/Professional_Support)

## Donate ##

`kicksecure-network-conf` requires [donations](https://www.whonix.org/wiki/Donate) to stay alive!
