#!/usr/bin/env python3
import struct, os, sys, argparse

from libyaz0 import decompress

# TODO automatically find dmadata
FILE_TABLE_OFFSET = 0x1A500 # 0x1C110 for JP1.0, 0x1C050 for JP1.1, 0x24F60 for debug

# TODO stick this in ./tables
FILE_NAMES = {
    0:'makerom',
    1:'boot',
    2:'dmadata',
    3:'Audiobank',
    4:'Audioseq',
    5:'Audiotable',
    6:'jpn_font_static',
    7:'link_animetion', # not a typo
    #8:'',
    #9:'',
    10:'icon_item_field_static',
    11:'icon_item_dungeon_static',
    12:'icon_item_gameover_static',
    #13:'',
    #14:'',
    15:'map_i_static',
    16:'map_grand_static',
    17:'item_name_static',
    18:'map_name_static',
    #19:'',
    #20:'',
    #21:'',
    #22:'',
    #23:'',
    #24:'',
    25:'do_action_static',
    26:'message_static',
    27:'message_texture_static',
    28:'nes_font_static',
    29:'en_message_data_static', # guess from jpn_message_data_static
    30:'staff_message_data_static',
    31:'code',
    32:'ovl_title',
    33:'ovl_select',
    34:'ovl_opening',
    35:'ovl_file_choose',
    36:'ovl_daytelop',
    37:'ovl_kaleido_scope',
    38:'ovl_Player_Actor',
    39:'ovl_En_Test',
    40:'ovl_En_GirlA',
    41:'ovl_En_Part',
    42:'ovl_En_Light',
    43:'ovl_En_Door',
    44:'ovl_En_Box',
    45:'ovl_En_Pametfrog',
    46:'ovl_En_Okuta',
    47:'ovl_En_Bom',
    48:'ovl_En_Wallmas',
    49:'ovl_En_Dodongo',
    50:'ovl_En_Firefly',
    51:'ovl_En_Horse',
    52:'ovl_En_Arrow',
    53:'ovl_En_Elf',
    54:'ovl_En_Niw',
    55:'ovl_En_Tite',
    56:'ovl_En_Peehat',
    57:'ovl_En_Holl',
    58:'ovl_En_Dinofos',
    59:'ovl_En_Hata',
    60:'ovl_En_Zl1',
    61:'ovl_En_Viewer',
    62:'ovl_En_Bubble',
    63:'ovl_Door_Shutter',
    64:'ovl_En_Boom',
    65:'ovl_En_Torch2',
    66:'ovl_En_Minifrog',
    67:'ovl_En_St',
    68:'ovl_Obj_Wturn',
    69:'ovl_En_River_Sound',
    70:'ovl_En_Ossan',
    71:'ovl_En_Famos',
    72:'ovl_En_Bombf',
    73:'ovl_En_Am',
    74:'ovl_En_Dekubaba',
    75:'ovl_En_M_Fire1',
    76:'ovl_En_M_Thunder',
    77:'ovl_Bg_Breakwall',
    78:'ovl_Door_Warp1',
    79:'ovl_Obj_Syokudai',
    80:'ovl_Item_B_Heart',
    81:'ovl_En_Dekunuts',
    82:'ovl_En_Bbfall',
    83:'ovl_Arms_Hook',
    84:'ovl_En_Bb',
    85:'ovl_Bg_Keikoku_Spr',
    86:'ovl_En_Wood02',
    87:'ovl_En_Death',
    88:'ovl_En_Minideath',
    89:'ovl_En_Vm',
    90:'ovl_Demo_Effect',
    91:'ovl_Demo_Kankyo',
    92:'ovl_En_Floormas',
    93:'ovl_En_Rd',
    94:'ovl_Bg_F40_Flift',
    95:'ovl_Obj_Mure',
    96:'ovl_En_Sw',
    97:'ovl_Object_Kankyo',
    98:'ovl_En_Horse_Link_Child',
    99:'ovl_Door_Ana',
    100:'ovl_En_Encount1',
    101:'ovl_Demo_Tre_Lgt',
    102:'ovl_En_Encount2',
    103:'ovl_En_Fire_Rock',
    104:'ovl_Bg_Ctower_Rot',
    105:'ovl_Mir_Ray',
    106:'ovl_En_Sb',
    107:'ovl_En_Bigslime',
    108:'ovl_En_Karebaba',
    109:'ovl_En_In',
    110:'ovl_En_Bom_Chu',
    111:'ovl_En_Horse_Game_Check',
    112:'ovl_En_Rr',
    113:'ovl_En_Fr',
    114:'ovl_En_Fishing',
    115:'ovl_Obj_Oshihiki',
    116:'ovl_Eff_Dust',
    117:'ovl_Bg_Umajump',
    118:'ovl_En_Insect',
    119:'ovl_En_Butte',
    120:'ovl_En_Fish',
    121:'ovl_Item_Etcetera',
    122:'ovl_Arrow_Fire',
    123:'ovl_Arrow_Ice',
    124:'ovl_Arrow_Light',
    125:'ovl_Obj_Kibako',
    126:'ovl_Obj_Tsubo',
    127:'ovl_En_Ik',
    128:'ovl_Demo_Shd',
    129:'ovl_En_Dns',
    130:'ovl_Elf_Msg',
    131:'ovl_En_Honotrap',
    132:'ovl_En_Tubo_Trap',
    133:'ovl_Obj_Ice_Poly',
    134:'ovl_En_Fz',
    135:'ovl_En_Kusa',
    136:'ovl_Obj_Bean',
    137:'ovl_Obj_Bombiwa',
    138:'ovl_Obj_Switch',
    139:'ovl_Obj_Lift',
    140:'ovl_Obj_Hsblock',
    141:'ovl_En_Okarina_Tag',
    142:'ovl_En_Goroiwa',
    143:'ovl_En_Daiku',
    144:'ovl_En_Nwc',
    145:'ovl_Item_Inbox',
    146:'ovl_En_Ge1',
    147:'ovl_Obj_Blockstop',
    148:'ovl_En_Sda',
    149:'ovl_En_Clear_Tag',
    150:'ovl_En_Gm',
    151:'ovl_En_Ms',
    152:'ovl_En_Hs',
    153:'ovl_Bg_Ingate',
    154:'ovl_En_Kanban',
    155:'ovl_En_Attack_Niw',
    156:'ovl_En_Mk',
    157:'ovl_En_Owl',
    158:'ovl_En_Ishi',
    159:'ovl_Obj_Hana',
    160:'ovl_Obj_Lightswitch',
    161:'ovl_Obj_Mure2',
    162:'ovl_En_Fu',
    163:'ovl_En_Stream',
    164:'ovl_En_Mm',
    165:'ovl_En_Weather_Tag',
    166:'ovl_En_Ani',
    167:'ovl_En_Js',
    168:'ovl_En_Okarina_Effect',
    169:'ovl_En_Mag',
    170:'ovl_Elf_Msg2',
    171:'ovl_Bg_F40_Swlift',
    172:'ovl_En_Kakasi',
    173:'ovl_Obj_Makeoshihiki',
    174:'ovl_Oceff_Spot',
    175:'ovl_En_Torch',
    176:'ovl_Shot_Sun',
    177:'ovl_Obj_Roomtimer',
    178:'ovl_En_Ssh',
    179:'ovl_Oceff_Wipe',
    180:'ovl_Effect_Ss_Dust',
    181:'ovl_Effect_Ss_Kirakira',
    182:'ovl_Effect_Ss_Bomb2',
    183:'ovl_Effect_Ss_Blast',
    184:'ovl_Effect_Ss_G_Spk',
    185:'ovl_Effect_Ss_D_Fire',
    186:'ovl_Effect_Ss_Bubble',
    187:'ovl_Effect_Ss_G_Ripple',
    188:'ovl_Effect_Ss_G_Splash',
    189:'ovl_Effect_Ss_G_Fire',
    190:'ovl_Effect_Ss_Lightning',
    191:'ovl_Effect_Ss_Dt_Bubble',
    192:'ovl_Effect_Ss_Hahen',
    193:'ovl_Effect_Ss_Stick',
    194:'ovl_Effect_Ss_Sibuki',
    195:'ovl_Effect_Ss_Stone1',
    196:'ovl_Effect_Ss_Hitmark',
    197:'ovl_Effect_Ss_Fhg_Flash',
    198:'ovl_Effect_Ss_K_Fire',
    199:'ovl_Effect_Ss_Solder_Srch_Ball',
    200:'ovl_Effect_Ss_Kakera',
    201:'ovl_Effect_Ss_Ice_Piece',
    202:'ovl_Effect_Ss_En_Ice',
    203:'ovl_Effect_Ss_Fire_Tail',
    204:'ovl_Effect_Ss_En_Fire',
    205:'ovl_Effect_Ss_Extra',
    206:'ovl_Effect_Ss_Dead_Db',
    207:'ovl_Effect_Ss_Dead_Dd',
    208:'ovl_Effect_Ss_Dead_Ds',
    209:'ovl_Oceff_Storm',
    210:'ovl_Obj_Demo',
    211:'ovl_En_Minislime',
    212:'ovl_En_Nutsball',
    213:'ovl_Oceff_Wipe2',
    214:'ovl_Oceff_Wipe3',
    215:'ovl_En_Dg',
    216:'ovl_En_Si',
    217:'ovl_Obj_Comb',
    218:'ovl_Obj_Kibako2',
    219:'ovl_En_Hs2',
    220:'ovl_Obj_Mure3',
    221:'ovl_En_Tg',
    222:'ovl_En_Wf',
    223:'ovl_En_Skb',
    224:'ovl_En_Gs',
    225:'ovl_Obj_Sound',
    226:'ovl_En_Crow',
    227:'ovl_En_Cow',
    228:'ovl_Oceff_Wipe4',
    229:'ovl_En_Zo',
    230:'ovl_Effect_Ss_Ice_Smoke',
    231:'ovl_Obj_Makekinsuta',
    232:'ovl_En_Ge3',
    233:'ovl_Obj_Hamishi',
    234:'ovl_En_Zl4',
    235:'ovl_En_Mm2',
    236:'ovl_Door_Spiral',
    237:'ovl_Obj_Pzlblock',
    238:'ovl_Obj_Toge',
    239:'ovl_Obj_Armos',
    240:'ovl_Obj_Boyo',
    241:'ovl_En_Grasshopper',
    242:'ovl_Obj_Grass',
    243:'ovl_Obj_Grass_Carry',
    244:'ovl_Obj_Grass_Unit',
    245:'ovl_Bg_Fire_Wall',
    246:'ovl_En_Bu',
    247:'ovl_En_Encount3',
    248:'ovl_En_Jso',
    249:'ovl_Obj_Chikuwa',
    250:'ovl_En_Knight',
    251:'ovl_En_Warp_tag',
    252:'ovl_En_Aob_01',
    253:'ovl_En_Boj_01',
    254:'ovl_En_Boj_02',
    255:'ovl_En_Boj_03',
    256:'ovl_En_Encount4',
    257:'ovl_En_Bom_Bowl_Man',
    258:'ovl_En_Syateki_Man',
    259:'ovl_Bg_Icicle',
    260:'ovl_En_Syateki_Crow',
    261:'ovl_En_Boj_04',
    262:'ovl_En_Cne_01',
    263:'ovl_En_Bba_01',
    264:'ovl_En_Bji_01',
    265:'ovl_Bg_Spdweb',
    266:'ovl_En_Mt_tag',
    267:'ovl_Boss_01',
    268:'ovl_Boss_02',
    269:'ovl_Boss_03',
    270:'ovl_Boss_04',
    271:'ovl_Boss_05',
    272:'ovl_Boss_06',
    273:'ovl_Boss_07',
    274:'ovl_Bg_Dy_Yoseizo',
    275:'ovl_En_Boj_05',
    276:'ovl_En_Sob1',
    277:'ovl_En_Go',
    278:'ovl_En_Raf',
    279:'ovl_Obj_Funen',
    280:'ovl_Obj_Raillift',
    281:'ovl_Bg_Numa_Hana',
    282:'ovl_Obj_Flowerpot',
    283:'ovl_Obj_Spinyroll',
    284:'ovl_Dm_Hina',
    285:'ovl_En_Syateki_Wf',
    286:'ovl_Obj_Skateblock',
    287:'ovl_Effect_En_Ice_Block',
    288:'ovl_Obj_Iceblock',
    289:'ovl_En_Bigpamet',
    290:'ovl_Bg_Dblue_Movebg',
    291:'ovl_En_Syateki_Dekunuts',
    292:'ovl_Elf_Msg3',
    293:'ovl_En_Fg',
    294:'ovl_Dm_Ravine',
    295:'ovl_Dm_Sa',
    296:'ovl_En_Slime',
    297:'ovl_En_Pr',
    298:'ovl_Obj_Toudai',
    299:'ovl_Obj_Entotu',
    300:'ovl_Obj_Bell',
    301:'ovl_En_Syateki_Okuta',
    302:'ovl_Obj_Shutter',
    303:'ovl_Dm_Zl',
    304:'ovl_En_Ru',
    305:'ovl_En_Elfgrp',
    306:'ovl_Dm_Tsg',
    307:'ovl_En_Baguo',
    308:'ovl_Obj_Vspinyroll',
    309:'ovl_Obj_Smork',
    310:'ovl_En_Test2',
    311:'ovl_En_Test3',
    312:'ovl_En_Test4',
    313:'ovl_En_Bat',
    314:'ovl_En_Sekihi',
    315:'ovl_En_Wiz',
    316:'ovl_En_Wiz_Brock',
    317:'ovl_En_Wiz_Fire',
    318:'ovl_Eff_Change',
    319:'ovl_Dm_Statue',
    320:'ovl_Obj_Fireshield',
    321:'ovl_Bg_Ladder',
    322:'ovl_En_Mkk',
    323:'ovl_Demo_Getitem',
    324:'ovl_En_Dnb',
    325:'ovl_En_Dnh',
    326:'ovl_En_Dnk',
    327:'ovl_En_Dnq',
    328:'ovl_Bg_Keikoku_Saku',
    329:'ovl_Obj_Hugebombiwa',
    330:'ovl_En_Firefly2',
    331:'ovl_En_Rat',
    332:'ovl_En_Water_Effect',
    333:'ovl_En_Kusa2',
    334:'ovl_Bg_Spout_Fire',
    335:'ovl_En_Dy_Extra',
    336:'ovl_En_Bal',
    337:'ovl_En_Ginko_Man',
    338:'ovl_En_Warp_Uzu',
    339:'ovl_Obj_Driftice',
    340:'ovl_En_Look_Nuts',
    341:'ovl_En_Mushi2',
    342:'ovl_En_Fall',
    343:'ovl_En_Mm3',
    344:'ovl_Bg_Crace_Movebg',
    345:'ovl_En_Dno',
    346:'ovl_En_Pr2',
    347:'ovl_En_Prz',
    348:'ovl_En_Jso2',
    349:'ovl_Obj_Etcetera',
    350:'ovl_En_Egol',
    351:'ovl_Obj_Mine',
    352:'ovl_Obj_Purify',
    353:'ovl_En_Tru',
    354:'ovl_En_Trt',
    355:'ovl_En_Test5',
    356:'ovl_En_Test6',
    357:'ovl_En_Az',
    358:'ovl_En_Estone',
    359:'ovl_Bg_Hakugin_Post',
    360:'ovl_Dm_Opstage',
    361:'ovl_Dm_Stk',
    362:'ovl_Dm_Char00',
    363:'ovl_Dm_Char01',
    364:'ovl_Dm_Char02',
    365:'ovl_Dm_Char03',
    366:'ovl_Dm_Char04',
    367:'ovl_Dm_Char05',
    368:'ovl_Dm_Char06',
    369:'ovl_Dm_Char07',
    370:'ovl_Dm_Char08',
    371:'ovl_Dm_Char09',
    372:'ovl_Obj_Tokeidai',
    373:'ovl_En_Mnk',
    374:'ovl_En_Egblock',
    375:'ovl_En_Guard_Nuts',
    376:'ovl_Bg_Hakugin_Bombwall',
    377:'ovl_Obj_Tokei_Tobira',
    378:'ovl_Bg_Hakugin_Elvpole',
    379:'ovl_En_Ma4',
    380:'ovl_En_Twig',
    381:'ovl_En_Po_Fusen',
    382:'ovl_En_Door_Etc',
    383:'ovl_En_Bigokuta',
    384:'ovl_Bg_Icefloe',
    #385:'[?]',
    #386:'[?]',
    #387:'[?]',
    #388:'[?]',
    #389:'[?]',
    390:'ovl_Effect_Ss_Sbn',
    391:'ovl_Obj_Ocarinalift',
    392:'ovl_En_Time_Tag',
    393:'ovl_Bg_Open_Shutter',
    394:'ovl_Bg_Open_Spot',
    395:'ovl_Bg_Fu_Kaiten',
    396:'ovl_Obj_Aqua',
    397:'ovl_En_Elforg',
    398:'ovl_En_Elfbub',
    399:'ovl_En_Fu_Mato',
    400:'ovl_En_Fu_Kago',
    401:'ovl_En_Osn',
    402:'ovl_Bg_Ctower_Gear',
    403:'ovl_En_Trt2',
    404:'ovl_Obj_Tokei_Step',
    405:'ovl_Bg_Lotus',
    406:'ovl_En_Kame',
    407:'ovl_Obj_Takaraya_Wall',
    408:'ovl_Bg_Fu_Mizu',
    409:'ovl_En_Sellnuts',
    410:'ovl_Bg_Dkjail_Ivy',
    411:'ovl_Obj_Visiblock',
    412:'ovl_En_Takaraya',
    413:'ovl_En_Tsn',
    414:'ovl_En_Ds2n',
    415:'ovl_En_Fsn',
    416:'ovl_En_Shn',
    417:'ovl_En_Stop_heishi',
    418:'ovl_Obj_Bigicicle',
    419:'ovl_En_Lift_Nuts',
    420:'ovl_En_Tk',
    421:'ovl_Bg_Market_Step',
    422:'ovl_Obj_Lupygamelift',
    423:'ovl_En_Test7',
    424:'ovl_Obj_Lightblock',
    425:'ovl_Mir_Ray2',
    426:'ovl_En_Wdhand',
    427:'ovl_En_Gamelupy',
    428:'ovl_Bg_Danpei_Movebg',
    429:'ovl_En_Snowwd',
    430:'ovl_En_Pm',
    431:'ovl_En_Gakufu',
    432:'ovl_Elf_Msg4',
    433:'ovl_Elf_Msg5',
    434:'ovl_En_Col_Man',
    435:'ovl_En_Talk_Gibud',
    436:'ovl_En_Giant',
    437:'ovl_Obj_Snowball',
    438:'ovl_Boss_Hakugin',
    439:'ovl_En_Gb2',
    440:'ovl_En_Onpuman',
    441:'ovl_Bg_Tobira01',
    442:'ovl_En_Tag_Obj',
    443:'ovl_Obj_Dhouse',
    444:'ovl_Obj_Hakaisi',
    445:'ovl_Bg_Hakugin_Switch',
    446:'ovl_En_Snowman',
    447:'ovl_TG_Sw',
    448:'ovl_En_Po_Sisters',
    449:'ovl_En_Pp',
    450:'ovl_En_Hakurock',
    451:'ovl_En_Hanabi',
    452:'ovl_Obj_Dowsing',
    453:'ovl_Obj_Wind',
    454:'ovl_En_Racedog',
    455:'ovl_En_Kendo_Js',
    456:'ovl_Bg_Botihasira',
    457:'ovl_En_Fish2',
    458:'ovl_En_Pst',
    459:'ovl_En_Poh',
    460:'ovl_Obj_Spidertent',
    461:'ovl_En_Zoraegg',
    462:'ovl_En_Kbt',
    463:'ovl_En_Gg',
    464:'ovl_En_Maruta',
    465:'ovl_Obj_Snowball2',
    466:'ovl_En_Gg2',
    467:'ovl_Obj_Ghaka',
    468:'ovl_En_Dnp',
    469:'ovl_En_Dai',
    470:'ovl_Bg_Goron_Oyu',
    471:'ovl_En_Kgy',
    472:'ovl_En_Invadepoh',
    473:'ovl_En_Gk',
    474:'ovl_En_An',
    475:'ovl_En_Bee',
    476:'ovl_En_Ot',
    477:'ovl_En_Dragon',
    478:'ovl_Obj_Dora',
    479:'ovl_En_Bigpo',
    480:'ovl_Obj_Kendo_Kanban',
    481:'ovl_Obj_Hariko',
    482:'ovl_En_Sth',
    483:'ovl_Bg_Sinkai_Kabe',
    484:'ovl_Bg_Haka_Curtain',
    485:'ovl_Bg_Kin2_Bombwall',
    486:'ovl_Bg_Kin2_Fence',
    487:'ovl_Bg_Kin2_Picture',
    488:'ovl_Bg_Kin2_Shelf',
    489:'ovl_En_Rail_Skb',
    490:'ovl_En_Jg',
    491:'ovl_En_Tru_Mt',
    492:'ovl_Obj_Um',
    493:'ovl_En_Neo_Reeba',
    494:'ovl_Bg_Mbar_Chair',
    495:'ovl_Bg_Ikana_Block',
    496:'ovl_Bg_Ikana_Mirror',
    497:'ovl_Bg_Ikana_Rotaryroom',
    498:'ovl_Bg_Dblue_Balance',
    499:'ovl_Bg_Dblue_Waterfall',
    500:'ovl_En_Kaizoku',
    501:'ovl_En_Ge2',
    502:'ovl_En_Ma_Yts',
    503:'ovl_En_Ma_Yto',
    504:'ovl_Obj_Tokei_Turret',
    505:'ovl_Bg_Dblue_Elevator',
    506:'ovl_Obj_Warpstone',
    507:'ovl_En_Zog',
    508:'ovl_Obj_Rotlift',
    509:'ovl_Obj_Jg_Gakki',
    510:'ovl_Bg_Inibs_Movebg',
    511:'ovl_En_Zot',
    512:'ovl_Obj_Tree',
    513:'ovl_Obj_Y2lift',
    514:'ovl_Obj_Y2shutter',
    515:'ovl_Obj_Boat',
    516:'ovl_Obj_Taru',
    517:'ovl_Obj_Hunsui',
    518:'ovl_En_Jc_Mato',
    519:'ovl_Mir_Ray3',
    520:'ovl_En_Zob',
    521:'ovl_Elf_Msg6',
    522:'ovl_Obj_Nozoki',
    523:'ovl_En_Toto',
    524:'ovl_En_Railgibud',
    525:'ovl_En_Baba',
    526:'ovl_En_Suttari',
    527:'ovl_En_Zod',
    528:'ovl_En_Kujiya',
    529:'ovl_En_Geg',
    530:'ovl_Obj_Kinoko',
    531:'ovl_Obj_Yasi',
    532:'ovl_En_Tanron1',
    533:'ovl_En_Tanron2',
    534:'ovl_En_Tanron3',
    535:'ovl_Obj_Chan',
    536:'ovl_En_Zos',
    537:'ovl_En_S_Goro',
    538:'ovl_En_Nb',
    539:'ovl_En_Ja',
    540:'ovl_Bg_F40_Block',
    541:'ovl_Bg_F40_Switch',
    542:'ovl_En_Po_Composer',
    543:'ovl_En_Guruguru',
    544:'ovl_Oceff_Wipe5',
    545:'ovl_En_Stone_heishi',
    546:'ovl_Oceff_Wipe6',
    547:'ovl_En_Scopenuts',
    548:'ovl_En_Scopecrow',
    549:'ovl_Oceff_Wipe7',
    550:'ovl_Eff_Kamejima_Wave',
    551:'ovl_En_Hg',
    552:'ovl_En_Hgo',
    553:'ovl_En_Zov',
    554:'ovl_En_Ah',
    555:'ovl_Obj_Hgdoor',
    556:'ovl_Bg_Ikana_Bombwall',
    557:'ovl_Bg_Ikana_Ray',
    558:'ovl_Bg_Ikana_Shutter',
    559:'ovl_Bg_Haka_Bombwall',
    560:'ovl_Bg_Haka_Tomb',
    561:'ovl_En_Sc_Ruppe',
    562:'ovl_Bg_Iknv_Doukutu',
    563:'ovl_Bg_Iknv_Obj',
    564:'ovl_En_Pamera',
    565:'ovl_Obj_HsStump',
    566:'ovl_En_Hidden_Nuts',
    567:'ovl_En_Zow',
    568:'ovl_En_Talk',
    569:'ovl_En_Al',
    570:'ovl_En_Tab',
    571:'ovl_En_Nimotsu',
    572:'ovl_En_Hit_Tag',
    573:'ovl_En_Ruppecrow',
    574:'ovl_En_Tanron4',
    575:'ovl_En_Tanron5',
    576:'ovl_En_Tanron6',
    577:'ovl_En_Daiku2',
    578:'ovl_En_Muto',
    579:'ovl_En_Baisen',
    580:'ovl_En_Heishi',
    581:'ovl_En_Demo_heishi',
    582:'ovl_En_Dt',
    583:'ovl_En_Cha',
    584:'ovl_Obj_Dinner',
    585:'ovl_Eff_Lastday',
    586:'ovl_Bg_Ikana_Dharma',
    587:'ovl_En_Akindonuts',
    588:'ovl_Eff_Stk',
    589:'ovl_En_Ig',
    590:'ovl_En_Rg',
    591:'ovl_En_Osk',
    592:'ovl_En_Sth2',
    593:'ovl_En_Yb',
    594:'ovl_En_Rz',
    595:'ovl_En_Scopecoin',
    596:'ovl_En_Bjt',
    597:'ovl_En_Bomjima',
    598:'ovl_En_Bomjimb',
    599:'ovl_En_Bombers',
    600:'ovl_En_Bombers2',
    601:'ovl_En_Bombal',
    602:'ovl_Obj_Moon_Stone',
    603:'ovl_Obj_Mu_Pict',
    604:'ovl_Bg_Ikninside',
    605:'ovl_Eff_Zoraband',
    606:'ovl_Obj_Kepn_Koya',
    607:'ovl_Obj_Usiyane',
    608:'ovl_En_Nnh',
    609:'ovl_Obj_Kzsaku',
    610:'ovl_Obj_Milk_Bin',
    611:'ovl_En_Kitan',
    612:'ovl_Bg_Astr_Bombwall',
    613:'ovl_Bg_Iknin_Susceil',
    614:'ovl_En_Bsb',
    615:'ovl_En_Recepgirl',
    616:'ovl_En_Thiefbird',
    617:'ovl_En_Jgame_Tsn',
    618:'ovl_Obj_Jgame_Light',
    619:'ovl_Obj_Yado',
    620:'ovl_Demo_Syoten',
    621:'ovl_Demo_Moonend',
    622:'ovl_Bg_Lbfshot',
    623:'ovl_Bg_Last_Bwall',
    624:'ovl_En_And',
    625:'ovl_En_Invadepoh_Demo',
    626:'ovl_Obj_Danpeilift',
    627:'ovl_En_Fall2',
    628:'ovl_Dm_Al',
    629:'ovl_Dm_An',
    630:'ovl_Dm_Ah',
    631:'ovl_Dm_Nb',
    632:'ovl_En_Drs',
    633:'ovl_En_Ending_Hero',
    634:'ovl_Dm_Bal',
    635:'ovl_En_Paper',
    636:'ovl_En_Hint_Skb',
    637:'ovl_Dm_Tag',
    638:'ovl_En_Bh',
    639:'ovl_En_Ending_Hero2',
    640:'ovl_En_Ending_Hero3',
    641:'ovl_En_Ending_Hero4',
    642:'ovl_En_Ending_Hero5',
    643:'ovl_En_Ending_Hero6',
    644:'ovl_Dm_Gm',
    645:'ovl_Obj_Swprize',
    646:'ovl_En_Invisible_Ruppe',
    647:'ovl_Obj_Ending',
    648:'ovl_En_Rsn',
    649:'gameplay_keep',
    650:'gameplay_field_keep',
    651:'gameplay_dangeon_keep',
    # 652 not set, gameplay_object_exchange_static?
    653:'object_link_boy',
    654:'object_link_child',
    655:'object_link_goron',
    656:'object_link_zora',
    657:'object_link_nuts',
    658:'object_mask_ki_tan',
    659:'object_mask_rabit',
    660:'object_mask_skj',
    661:'object_mask_truth',
    662:'object_mask_gibudo',
    663:'object_mask_json',
    664:'object_mask_kerfay',
    665:'object_mask_bigelf',
    666:'object_mask_kyojin',
    667:'object_mask_romerny',
    668:'object_mask_posthat',
    669:'object_mask_zacho',
    670:'object_mask_stone',
    671:'object_mask_bree',
    672:'object_mask_gero',
    673:'object_mask_yofukasi',
    674:'object_mask_meoto',
    675:'object_mask_dancer',
    676:'object_mask_bakuretu',
    677:'object_mask_bu_san',
    678:'object_mask_goron',
    679:'object_mask_zora',
    680:'object_mask_nuts',
    681:'object_mask_boy',
    682:'object_box',
    683:'object_okuta',
    684:'object_wallmaster',
    685:'object_dy_obj',
    686:'object_firefly',
    687:'object_dodongo',
    688:'object_niw',
    689:'object_tite',
    690:'object_ph',
    691:'object_dinofos',
    692:'object_zl1',
    693:'object_bubble',
    694:'object_test3',
    695:'object_famos',
    696:'object_st',
    697:'object_thiefbird',
    698:'object_bombf',
    699:'object_am',
    700:'object_dekubaba',
    701:'object_warp1',
    702:'object_b_heart',
    703:'object_dekunuts',
    704:'object_bb',
    705:'object_death',
    706:'object_hata',
    707:'object_wood02',
    708:'object_trap',
    709:'object_vm',
    710:'object_efc_star_field',
    711:'object_rd',
    712:'object_yukimura_obj',
    # skip object_heavy_object (in JP)
    713:'object_horse_link_child',
    714:'object_syokudai',
    715:'object_efc_tw',
    716:'object_gi_key',
    717:'object_mir_ray',
    718:'object_ctower_rot',
    719:'object_bdoor',
    720:'object_sb',
    721:'object_gi_melody',
    722:'object_gi_heart',
    723:'object_gi_compass',
    724:'object_gi_bosskey',
    725:'object_gi_nuts',
    726:'object_gi_hearts',
    727:'object_gi_arrowcase',
    728:'object_gi_bombpouch',
    729:'object_in',
    730:'object_os_anime',
    731:'object_gi_bottle',
    732:'object_gi_stick',
    733:'object_gi_map',
    734:'object_oF1d_map',
    735:'object_ru2',
    736:'object_gi_magicpot',
    737:'object_gi_bomb_1',
    738:'object_ma2',
    739:'object_gi_purse',
    740:'object_rr',
    741:'object_gi_arrow',
    742:'object_gi_bomb_2',
    743:'object_gi_shield_2',
    744:'object_gi_hookshot',
    745:'object_gi_ocarina',
    746:'object_gi_milk',
    747:'object_ma1',
    748:'object_ny',
    749:'object_fr',
    750:'object_gi_bow',
    751:'object_gi_glasses',
    752:'object_gi_liquid',
    753:'object_ani',
    754:'object_gi_shield_3',
    755:'object_gi_bean',
    756:'object_gi_fish',
    757:'object_gi_longsword',
    758:'object_zo',
    759:'object_umajump',
    760:'object_mastergolon',
    761:'object_masterzoora',
    762:'object_aob',
    763:'object_ik',
    764:'object_ahg',
    765:'object_cne',
    766:'object_bji',
    767:'object_bba',
    768:'object_an1',
    769:'object_boj',
    770:'object_fz',
    771:'object_bob',
    772:'object_ge1',
    773:'object_yabusame_point',
    774:'object_d_hsblock',
    775:'object_d_lift',
    776:'object_mamenoki',
    777:'object_goroiwa',
    778:'object_toryo',
    779:'object_daiku',
    780:'object_nwc',
    781:'object_gm',
    782:'object_ms',
    783:'object_hs',
    784:'object_lightswitch',
    785:'object_kusa',
    786:'object_tsubo',
    787:'object_kanban',
    788:'object_owl',
    789:'object_mk',
    790:'object_fu',
    791:'object_gi_ki_tan_mask',
    792:'object_gi_mask18',
    793:'object_gi_rabit_mask',
    794:'object_gi_truth_mask',
    795:'object_stream',
    796:'object_mm',
    797:'object_js',
    798:'object_cs',
    799:'object_gi_soldout',
    800:'object_mag',
    801:'object_gi_golonmask',
    802:'object_gi_zoramask',
    803:'object_ka',
    804:'object_zg',
    805:'object_gi_m_arrow',
    806:'object_ds2',
    807:'object_fish',
    808:'object_gi_sutaru',
    809:'object_ssh',
    810:'object_bigslime',
    811:'object_bg',
    812:'object_bombiwa',
    813:'object_hintnuts',
    814:'object_rs',
    815:'object_gla',
    816:'object_geldb',
    817:'object_dog',
    818:'object_kibako2',
    819:'object_dns',
    820:'object_dnk',
    821:'object_gi_insect',
    822:'object_gi_ghost',
    823:'object_gi_soul',
    824:'object_f40_obj',
    825:'object_gi_rupy',
    826:'object_po_composer',
    827:'object_mu',
    828:'object_wf',
    829:'object_skb',
    830:'object_gs',
    831:'object_ps',
    832:'object_omoya_obj',
    833:'object_crow',
    834:'object_cow',
    835:'object_gi_sword_1',
    836:'object_zl4',
    837:'object_grasshopper',
    838:'object_boyo',
    839:'object_fwall',
    840:'object_jso',
    841:'object_knight',
    842:'object_icicle',
    843:'object_spdweb',
    844:'object_boss01',
    845:'object_boss02',
    846:'object_boss03',
    847:'object_boss04',
    848:'object_boss05',
    849:'object_boss07',
    850:'object_raf',
    851:'object_funen',
    852:'object_raillift',
    853:'object_numa_obj',
    854:'object_flowerpot',
    855:'object_spinyroll',
    856:'object_ice_block',
    857:'object_keikoku_demo',
    858:'object_slime',
    859:'object_pr',
    860:'object_f52_obj',
    861:'object_f53_obj',
    862:'object_kibako',
    863:'object_sek',
    864:'object_gmo',
    865:'object_bat',
    866:'object_sekihil',
    867:'object_sekihig',
    868:'object_sekihin',
    869:'object_sekihiz',
    870:'object_wiz',
    871:'object_ladder',
    872:'object_mkk',
    873:'object_keikoku_obj',
    874:'object_sichitai_obj',
    875:'object_dekucity_ana_obj',
    876:'object_rat',
    877:'object_water_effect',
    878:'object_dblue_object',
    879:'object_bal',
    880:'object_warp_uzu',
    881:'object_driftice',
    882:'object_fall',
    883:'object_hanareyama_obj',
    884:'object_crace_object',
    885:'object_dnq',
    886:'object_obj_tokeidai',
    887:'object_eg',
    888:'object_tru',
    889:'object_trt',
    890:'object_hakugin_obj',
    891:'object_horse_game_check',
    892:'object_stk',
    893:'object_mnk',
    894:'object_gi_bottle_red',
    895:'object_tokei_tobira',
    896:'object_az',
    897:'object_twig',
    898:'object_dekucity_obj',
    899:'object_po_fusen',
    900:'object_racetsubo',
    901:'object_ha',
    902:'object_bigokuta',
    903:'object_open_obj',
    904:'object_fu_kaiten',
    905:'object_fu_mato',
    906:'object_mtoride',
    907:'object_osn',
    908:'object_tokei_step',
    909:'object_lotus',
    910:'object_tl',
    911:'object_dkjail_obj',
    912:'object_visiblock',
    913:'object_tsn',
    914:'object_ds2n',
    915:'object_fsn',
    916:'object_shn',
    917:'object_bigicicle',
    918:'object_gi_bottle_15',
    919:'object_tk',
    920:'object_market_obj',
    921:'object_gi_reserve00',
    922:'object_gi_reserve01',
    923:'object_lightblock',
    924:'object_takaraya_objects',
    925:'object_wdhand',
    926:'object_sdn',
    927:'object_snowwd',
    928:'object_giant',
    929:'object_comb',
    930:'object_hana',
    931:'object_boss_hakugin',
    932:'object_meganeana_obj',
    933:'object_gi_nutsmask',
    934:'object_stk2',
    935:'object_spot11_obj',
    936:'object_danpei_object',
    937:'object_dhouse',
    938:'object_hakaisi',
    939:'object_po',
    940:'object_snowman',
    941:'object_po_sisters',
    942:'object_pp',
    943:'object_goronswitch',
    944:'object_delf',
    945:'object_botihasira',
    946:'object_gi_bigbomb',
    947:'object_pst',
    948:'object_bsmask',
    949:'object_spidertent',
    950:'object_zoraegg',
    951:'object_kbt',
    952:'object_gg',
    953:'object_maruta',
    954:'object_ghaka',
    955:'object_oyu',
    956:'object_dnp',
    957:'object_dai',
    958:'object_kgy',
    959:'object_fb',
    960:'object_taisou',
    961:'object_gk',
    962:'object_haka_obj',
    963:'object_dnt',
    964:'object_yukiyama',
    965:'object_icefloe',
    966:'object_gi_gold_dust',
    967:'object_gi_bottle_16',
    968:'object_gi_bottle_22',
    969:'object_bee',
    970:'object_ot',
    971:'object_utubo',
    972:'object_dora',
    973:'object_gi_loach',
    974:'object_gi_seahorse',
    975:'object_bigpo',
    976:'object_hariko',
    977:'object_dno',
    978:'object_sinkai_kabe',
    979:'object_kin2_obj',
    980:'object_ishi',
    981:'object_hakugin_demo',
    982:'object_jg',
    983:'object_gi_sword_2',
    984:'object_gi_sword_3',
    985:'object_gi_sword_4',
    986:'object_um',
    987:'object_rb',
    988:'object_mbar_obj',
    989:'object_ikana_obj',
    990:'object_kz',
    991:'object_tokei_turret',
    992:'object_zog',
    993:'object_rotlift',
    994:'object_posthouse_obj',
    995:'object_gi_mask09',
    996:'object_gi_mask14',
    997:'object_gi_mask15',
    998:'object_inibs_object',
    999:'object_tree',
    1000:'object_kaizoku_obj',
    1001:'object_gi_reserve_b_00',
    1002:'object_gi_reserve_c_00',
    1003:'object_zob',
    1004:'object_milkbar',
    1005:'object_dmask',
    1006:'object_gi_reserve_c_01',
    1007:'object_zod',
    1008:'object_kumo30',
    1009:'object_obj_yasi',
    1010:'object_tanron1',
    1011:'object_tanron2',
    1012:'object_tanron3',
    1013:'object_gi_magicmushroom',
    1014:'object_obj_chan',
    1015:'object_gi_mask10',
    1016:'object_zos',
    1017:'object_an2',
    1018:'object_an3',
    1019:'object_f40_switch',
    1020:'object_lodmoon',
    1021:'object_tro',
    1022:'object_gi_mask12',
    1023:'object_gi_mask23',
    1024:'object_gi_bottle_21',
    1025:'object_gi_camera',
    1026:'object_kamejima',
    1027:'object_nb',
    1028:'object_harfgibud',
    1029:'object_zov',
    1030:'object_ah',
    1031:'object_hgdoor',
    1032:'object_dor01',
    1033:'object_dor02',
    1034:'object_dor03',
    1035:'object_dor04',
    1036:'object_last_obj',
    1037:'object_redead_obj',
    1038:'object_ikninside_obj',
    1039:'object_iknv_obj',
    1040:'object_pamera',
    1041:'object_hsstump',
    1042:'object_zm',
    1043:'object_al',
    1044:'object_tab',
    1045:'object_secom_obj',
    1046:'object_dt',
    1047:'object_gi_mask03',
    1048:'object_cha',
    1049:'object_obj_dinner',
    1050:'object_gi_reserve_b_01',
    1051:'object_lastday',
    1052:'object_bai',
    1053:'object_ikn_demo',
    1054:'object_gi_fieldmap',
    1055:'object_big_fwall',
    1056:'object_hunsui',
    1057:'object_uch',
    1058:'object_tanron4',
    1059:'object_tanron5',
    1060:'object_in2',
    1061:'object_yb',
    1062:'object_rz',
    1063:'object_bjt',
    1064:'object_taru',
    1065:'object_moonston',
    1066:'object_gi_schedule',
    1067:'object_gi_stonemask',
    1068:'object_zoraband',
    1069:'object_kepn_koya',
    1070:'object_obj_usiyane',
    1071:'object_gi_mask05',
    1072:'object_gi_mask11',
    1073:'object_gi_mask20',
    1074:'object_nnh',
    1075:'object_kzsaku',
    1076:'object_obj_milk_bin',
    1077:'object_random_obj',
    1078:'object_kujiya',
    1079:'object_kitan',
    1080:'object_gi_mask06',
    1081:'object_gi_mask16',
    1082:'object_astr_obj',
    1083:'object_bsb',
    1084:'object_fall2',
    1085:'object_sth',
    1086:'object_gi_mssa',
    1087:'object_smtower',
    1088:'object_gi_mask21',
    1089:'object_yado_obj',
    1090:'object_syoten',
    1091:'object_moonend',
    1092:'object_ob',
    1093:'object_gi_bottle_04',
    1094:'object_and',
    1095:'object_obj_danpeilift',
    1096:'object_drs',
    1097:'object_msmo',
    1098:'object_an4',
    1099:'object_wdor01',
    1100:'object_wdor02',
    1101:'object_wdor03',
    1102:'object_wdor04',
    1103:'object_wdor05',
    1104:'object_stk3',
    1105:'object_kinsta1_obj',
    1106:'object_kinsta2_obj',
    1107:'object_bh',
    1108:'object_gi_mask17',
    1109:'object_gi_mask22',
    1110:'object_lbfshot',
    1111:'object_fusen',
    1112:'object_ending_obj',
    1113:'object_gi_mask13',
    #1114:'1113', Map Textures - Building Interiors I
    #1115:'1114', Map Textures - Building Interiors II
    #1116:'1115', Map Textures - Lost Woods
    #1117:'1116', Map Textures - Mountains
    #1118:'1117', Map Textures - Ocean
    #1119:'1118', Map Textures - Swamp
    #1120:'',
    #1121:'1120', Map Textures - Field
    1122:'nintendo_rogo_static',
    1123:'title_static',
    #1124:'',
    #1125:'1124', Textures - Region Lock Error Messages
    #1126:'',
    #1127:'',
    #1128:'',
    #1129:'',
    #1130:'',
    #1131:'',
    1132:'vr_fine_static',
    1133:'vr_cloud_static',
    1134:'vr_pal_static',
    1135:'elf_message_field',
    1136:'elf_message_ydan',
    1137:'Z2_20SICHITAI2',
    1138:'Z2_20SICHITAI2_room_00',
    1139:'Z2_20SICHITAI2_room_01',
    1140:'Z2_20SICHITAI2_room_02',
    1141:'Z2_WITCH_SHOP',
    1142:'Z2_WITCH_SHOP_room_00',
    1143:'Z2_LAST_BS',
    1144:'Z2_LAST_BS_room_00',
    1145:'Z2_HAKASHITA',
    1146:'Z2_HAKASHITA_room_00',
    1147:'Z2_HAKASHITA_room_01',
    1148:'Z2_HAKASHITA_room_02',
    1149:'Z2_HAKASHITA_room_03',
    1150:'Z2_HAKASHITA_room_04',
    1151:'Z2_AYASHIISHOP',
    1152:'Z2_AYASHIISHOP_room_00',
    1153:'Z2_AYASHIISHOP_room_01',
    1154:'Z2_OMOYA',
    1155:'Z2_OMOYA_room_00',
    1156:'Z2_OMOYA_room_01',
    1157:'Z2_OMOYA_room_02',
    1158:'Z2_BOWLING',
    1159:'Z2_BOWLING_room_00',
    1160:'Z2_SONCHONOIE',
    1161:'Z2_SONCHONOIE_room_00',
    1162:'Z2_SONCHONOIE_room_01',
    1163:'Z2_SONCHONOIE_room_02',
    1164:'Z2_SONCHONOIE_room_03',
    1165:'Z2_IKANA',
    1166:'Z2_IKANA_room_00',
    1167:'Z2_IKANA_room_01',
    1168:'Z2_IKANA_room_02',
    1169:'Z2_IKANA_room_03',
    1170:'Z2_IKANA_room_04',
    1171:'Z2_KAIZOKU',
    1172:'Z2_KAIZOKU_room_00',
    1173:'Z2_MILK_BAR',
    1174:'Z2_MILK_BAR_room_00',
    1175:'Z2_INISIE_N',
    1176:'Z2_INISIE_N_room_00',
    1177:'Z2_INISIE_N_room_01',
    1178:'Z2_INISIE_N_room_02',
    1179:'Z2_INISIE_N_room_03',
    1180:'Z2_INISIE_N_room_04',
    1181:'Z2_INISIE_N_room_05',
    1182:'Z2_INISIE_N_room_06',
    1183:'Z2_INISIE_N_room_07',
    1184:'Z2_INISIE_N_room_08',
    1185:'Z2_INISIE_N_room_09',
    1186:'Z2_INISIE_N_room_10',
    1187:'Z2_INISIE_N_room_11',
    1188:'Z2_TAKARAYA',
    1189:'Z2_TAKARAYA_room_00',
    1190:'Z2_INISIE_R',
    1191:'Z2_INISIE_R_room_00',
    1192:'Z2_INISIE_R_room_01',
    1193:'Z2_INISIE_R_room_02',
    1194:'Z2_INISIE_R_room_03',
    1195:'Z2_INISIE_R_room_04',
    1196:'Z2_INISIE_R_room_05',
    1197:'Z2_INISIE_R_room_06',
    1198:'Z2_INISIE_R_room_07',
    1199:'Z2_INISIE_R_room_08',
    1200:'Z2_INISIE_R_room_09',
    1201:'Z2_INISIE_R_room_10',
    1202:'Z2_INISIE_R_room_11',
    1203:'Z2_OKUJOU',
    1204:'Z2_OKUJOU_room_00',
    1205:'Z2_OPENINGDAN',
    1206:'Z2_OPENINGDAN_room_00',
    1207:'Z2_OPENINGDAN_room_01',
    1208:'Z2_MITURIN',
    1209:'Z2_MITURIN_room_00',
    1210:'Z2_MITURIN_room_01',
    1211:'Z2_MITURIN_room_02',
    1212:'Z2_MITURIN_room_03',
    1213:'Z2_MITURIN_room_04',
    1214:'Z2_MITURIN_room_05',
    1215:'Z2_MITURIN_room_06',
    1216:'Z2_MITURIN_room_07',
    1217:'Z2_MITURIN_room_08',
    1218:'Z2_MITURIN_room_09',
    1219:'Z2_MITURIN_room_10',
    1220:'Z2_MITURIN_room_11',
    1221:'Z2_MITURIN_room_12',
    1222:'Z2_13HUBUKINOMITI',
    1223:'Z2_13HUBUKINOMITI_room_00',
    1224:'Z2_CASTLE',
    1225:'Z2_CASTLE_room_00',
    1226:'Z2_CASTLE_room_01',
    1227:'Z2_CASTLE_room_02',
    1228:'Z2_CASTLE_room_03',
    1229:'Z2_CASTLE_room_04',
    1230:'Z2_CASTLE_room_05',
    1231:'Z2_CASTLE_room_06',
    1232:'Z2_CASTLE_room_07',
    1233:'Z2_CASTLE_room_08',
    1234:'Z2_CASTLE_room_09',
    1235:'Z2_DEKUTES',
    1236:'Z2_DEKUTES_room_00',
    1237:'Z2_MITURIN_BS',
    1238:'Z2_MITURIN_BS_room_00',
    1239:'Z2_SYATEKI_MIZU',
    1240:'Z2_SYATEKI_MIZU_room_00',
    1241:'Z2_HAKUGIN',
    1242:'Z2_HAKUGIN_room_00',
    1243:'Z2_HAKUGIN_room_01',
    1244:'Z2_HAKUGIN_room_02',
    1245:'Z2_HAKUGIN_room_03',
    1246:'Z2_HAKUGIN_room_04',
    1247:'Z2_HAKUGIN_room_05',
    1248:'Z2_HAKUGIN_room_06',
    1249:'Z2_HAKUGIN_room_07',
    1250:'Z2_HAKUGIN_room_08',
    1251:'Z2_HAKUGIN_room_09',
    1252:'Z2_HAKUGIN_room_10',
    1253:'Z2_HAKUGIN_room_11',
    1254:'Z2_HAKUGIN_room_12',
    1255:'Z2_HAKUGIN_room_13',
    1256:'Z2_ROMANYMAE',
    1257:'Z2_ROMANYMAE_room_00',
    1258:'Z2_PIRATE',
    1259:'Z2_PIRATE_room_00',
    1260:'Z2_PIRATE_room_01',
    1261:'Z2_PIRATE_room_02',
    1262:'Z2_PIRATE_room_03',
    1263:'Z2_PIRATE_room_04',
    1264:'Z2_PIRATE_room_05',
    1265:'Z2_PIRATE_room_06',
    1266:'Z2_PIRATE_room_07',
    1267:'Z2_PIRATE_room_08',
    1268:'Z2_PIRATE_room_09',
    1269:'Z2_PIRATE_room_10',
    1270:'Z2_PIRATE_room_11',
    1271:'Z2_PIRATE_room_12',
    1272:'Z2_PIRATE_room_13',
    1273:'Z2_PIRATE_room_14',
    1274:'Z2_SYATEKI_MORI',
    1275:'Z2_SYATEKI_MORI_room_00',
    1276:'Z2_SINKAI',
    1277:'Z2_SINKAI_room_00',
    1278:'Z2_YOUSEI_IZUMI',
    1279:'Z2_YOUSEI_IZUMI_room_00',
    1280:'Z2_YOUSEI_IZUMI_room_01',
    1281:'Z2_YOUSEI_IZUMI_room_02',
    1282:'Z2_YOUSEI_IZUMI_room_03',
    1283:'Z2_YOUSEI_IZUMI_room_04',
    1284:'Z2_KINSTA1',
    1285:'Z2_KINSTA1_room_00',
    1286:'Z2_KINSTA1_room_01',
    1287:'Z2_KINSTA1_room_02',
    1288:'Z2_KINSTA1_room_03',
    1289:'Z2_KINSTA1_room_04',
    1290:'Z2_KINSTA1_room_05',
    1291:'Z2_KINDAN2',
    1292:'Z2_KINDAN2_room_00',
    1293:'Z2_KINDAN2_room_01',
    1294:'Z2_KINDAN2_room_02',
    1295:'Z2_KINDAN2_room_03',
    1296:'Z2_KINDAN2_room_04',
    1297:'Z2_KINDAN2_room_05',
    1298:'Z2_TENMON_DAI',
    1299:'Z2_TENMON_DAI_room_00',
    1300:'Z2_TENMON_DAI_room_01',
    1301:'Z2_LAST_DEKU',
    1302:'Z2_LAST_DEKU_room_00',
    1303:'Z2_LAST_DEKU_room_01',
    1304:'Z2_22DEKUCITY',
    1305:'Z2_22DEKUCITY_room_00',
    1306:'Z2_22DEKUCITY_room_01',
    1307:'Z2_22DEKUCITY_room_02',
    1308:'Z2_KAJIYA',
    1309:'Z2_KAJIYA_room_00',
    1310:'Z2_00KEIKOKU',
    1311:'Z2_00KEIKOKU_room_00',
    1312:'Z2_POSTHOUSE',
    1313:'Z2_POSTHOUSE_room_00',
    1314:'Z2_LABO',
    1315:'Z2_LABO_room_00',
    1316:'Z2_DANPEI2TEST',
    1317:'Z2_DANPEI2TEST_room_00',
    1318:'Z2_DANPEI2TEST_room_01',
    1319:'Z2_16GORON_HOUSE',
    1320:'Z2_16GORON_HOUSE_room_00',
    1321:'Z2_16GORON_HOUSE_room_01',
    1322:'Z2_33ZORACITY',
    1323:'Z2_33ZORACITY_room_00',
    1324:'Z2_8ITEMSHOP',
    1325:'Z2_8ITEMSHOP_room_00',
    1326:'Z2_F01',
    1327:'Z2_F01_room_00',
    1328:'Z2_INISIE_BS',
    1329:'Z2_INISIE_BS_room_00',
    1330:'Z2_30GYOSON',
    1331:'Z2_30GYOSON_room_00',
    1332:'Z2_31MISAKI',
    1333:'Z2_31MISAKI_room_00',
    1334:'Z2_TAKARAKUJI',
    1335:'Z2_TAKARAKUJI_room_00',
    1336:'Z2_TORIDE',
    1337:'Z2_TORIDE_room_00',
    1338:'Z2_FISHERMAN',
    1339:'Z2_FISHERMAN_room_00',
    1340:'Z2_GORONSHOP',
    1341:'Z2_GORONSHOP_room_00',
    1342:'Z2_DEKU_KING',
    1343:'Z2_DEKU_KING_room_00',
    1344:'Z2_LAST_GORON',
    1345:'Z2_LAST_GORON_room_00',
    1346:'Z2_LAST_GORON_room_01',
    1347:'Z2_24KEMONOMITI',
    1348:'Z2_24KEMONOMITI_room_00',
    1349:'Z2_F01_B',
    1350:'Z2_F01_B_room_00',
    1351:'Z2_F01C',
    1352:'Z2_F01C_room_00',
    1353:'Z2_BOTI',
    1354:'Z2_BOTI_room_00',
    1355:'Z2_BOTI_room_01',
    1356:'Z2_HAKUGIN_BS',
    1357:'Z2_HAKUGIN_BS_room_00',
    1358:'Z2_20SICHITAI',
    1359:'Z2_20SICHITAI_room_00',
    1360:'Z2_20SICHITAI_room_01',
    1361:'Z2_20SICHITAI_room_02',
    1362:'Z2_21MITURINMAE',
    1363:'Z2_21MITURINMAE_room_00',
    1364:'Z2_LAST_ZORA',
    1365:'Z2_LAST_ZORA_room_00',
    1366:'Z2_11GORONNOSATO2',
    1367:'Z2_11GORONNOSATO2_room_00',
    1368:'Z2_11GORONNOSATO2_room_01',
    1369:'Z2_SEA',
    1370:'Z2_SEA_room_00',
    1371:'Z2_SEA_room_01',
    1372:'Z2_SEA_room_02',
    1373:'Z2_SEA_room_03',
    1374:'Z2_SEA_room_04',
    1375:'Z2_SEA_room_05',
    1376:'Z2_SEA_room_06',
    1377:'Z2_SEA_room_07',
    1378:'Z2_SEA_room_08',
    1379:'Z2_SEA_room_09',
    1380:'Z2_SEA_room_10',
    1381:'Z2_SEA_room_11',
    1382:'Z2_SEA_room_12',
    1383:'Z2_SEA_room_13',
    1384:'Z2_SEA_room_14',
    1385:'Z2_SEA_room_15',
    1386:'Z2_35TAKI',
    1387:'Z2_35TAKI_room_00',
    1388:'Z2_REDEAD',
    1389:'Z2_REDEAD_room_00',
    1390:'Z2_REDEAD_room_01',
    1391:'Z2_REDEAD_room_02',
    1392:'Z2_REDEAD_room_03',
    1393:'Z2_REDEAD_room_04',
    1394:'Z2_REDEAD_room_05',
    1395:'Z2_REDEAD_room_06',
    1396:'Z2_REDEAD_room_07',
    1397:'Z2_REDEAD_room_08',
    1398:'Z2_REDEAD_room_09',
    1399:'Z2_REDEAD_room_10',
    1400:'Z2_REDEAD_room_11',
    1401:'Z2_REDEAD_room_12',
    1402:'Z2_REDEAD_room_13',
    1403:'Z2_BANDROOM',
    1404:'Z2_BANDROOM_room_00',
    1405:'Z2_BANDROOM_room_01',
    1406:'Z2_BANDROOM_room_02',
    1407:'Z2_BANDROOM_room_03',
    1408:'Z2_BANDROOM_room_04',
    1409:'Z2_11GORONNOSATO',
    1410:'Z2_11GORONNOSATO_room_00',
    1411:'Z2_11GORONNOSATO_room_01',
    1412:'Z2_GORON_HAKA',
    1413:'Z2_GORON_HAKA_room_00',
    1414:'Z2_SECOM',
    1415:'Z2_SECOM_room_00',
    1416:'Z2_SECOM_room_01',
    1417:'Z2_10YUKIYAMANOMURA',
    1418:'Z2_10YUKIYAMANOMURA_room_00',
    1419:'Z2_TOUGITES',
    1420:'Z2_TOUGITES_room_00',
    1421:'Z2_DANPEI',
    1422:'Z2_DANPEI_room_00',
    1423:'Z2_DANPEI_room_01',
    1424:'Z2_DANPEI_room_02',
    1425:'Z2_DANPEI_room_03',
    1426:'Z2_DANPEI_room_04',
    1427:'Z2_DANPEI_room_05',
    1428:'Z2_DANPEI_room_06',
    1429:'Z2_DANPEI_room_07',
    1430:'Z2_DANPEI_room_08',
    1431:'Z2_IKANAMAE',
    1432:'Z2_IKANAMAE_room_00',
    1433:'Z2_DOUJOU',
    1434:'Z2_DOUJOU_room_00',
    1435:'Z2_MUSICHOUSE',
    1436:'Z2_MUSICHOUSE_room_00',
    1437:'Z2_IKNINSIDE',
    1438:'Z2_IKNINSIDE_room_00',
    1439:'Z2_IKNINSIDE_room_01',
    1440:'Z2_MAP_SHOP',
    1441:'Z2_MAP_SHOP_room_00',
    1442:'Z2_F40',
    1443:'Z2_F40_room_00',
    1444:'Z2_F41',
    1445:'Z2_F41_room_00',
    1446:'Z2_10YUKIYAMANOMURA2',
    1447:'Z2_10YUKIYAMANOMURA2_room_00',
    1448:'Z2_10YUKIYAMANOMURA2_room_01',
    1449:'Z2_14YUKIDAMANOMITI',
    1450:'Z2_14YUKIDAMANOMITI_room_00',
    1451:'Z2_12HAKUGINMAE',
    1452:'Z2_12HAKUGINMAE_room_00',
    1453:'Z2_17SETUGEN',
    1454:'Z2_17SETUGEN_room_00',
    1457:'Z2_17SETUGEN2',
    1456:'Z2_17SETUGEN2_room_00',
    1457:'Z2_SEA_BS',
    1458:'Z2_SEA_BS_room_00',
    1459:'Z2_RANDOM',
    1460:'Z2_RANDOM_room_00',
    1461:'Z2_RANDOM_room_01',
    1462:'Z2_RANDOM_room_02',
    1463:'Z2_RANDOM_room_03',
    1464:'Z2_RANDOM_room_04',
    1465:'Z2_RANDOM_room_05',
    1466:'Z2_YADOYA',
    1467:'Z2_YADOYA_room_00',
    1468:'Z2_YADOYA_room_01',
    1469:'Z2_YADOYA_room_02',
    1470:'Z2_YADOYA_room_03',
    1471:'Z2_YADOYA_room_04',
    1472:'Z2_KONPEKI_ENT',
    1473:'Z2_KONPEKI_ENT_room_00',
    1474:'Z2_INSIDETOWER',
    1475:'Z2_INSIDETOWER_room_00',
    1476:'Z2_INSIDETOWER_room_01',
    1477:'Z2_26SARUNOMORI',
    1478:'Z2_26SARUNOMORI_room_00',
    1479:'Z2_26SARUNOMORI_room_01',
    1480:'Z2_26SARUNOMORI_room_02',
    1481:'Z2_26SARUNOMORI_room_03',
    1482:'Z2_26SARUNOMORI_room_04',
    1483:'Z2_26SARUNOMORI_room_05',
    1484:'Z2_26SARUNOMORI_room_06',
    1485:'Z2_26SARUNOMORI_room_07',
    1486:'Z2_26SARUNOMORI_room_08',
    1487:'Z2_LOST_WOODS',
    1488:'Z2_LOST_WOODS_room_00',
    1489:'Z2_LOST_WOODS_room_01',
    1490:'Z2_LOST_WOODS_room_02',
    1491:'Z2_LAST_LINK',
    1492:'Z2_LAST_LINK_room_00',
    1493:'Z2_LAST_LINK_room_01',
    1494:'Z2_LAST_LINK_room_02',
    1495:'Z2_LAST_LINK_room_03',
    1496:'Z2_LAST_LINK_room_04',
    1497:'Z2_LAST_LINK_room_05',
    1498:'Z2_LAST_LINK_room_06',
    1499:'Z2_LAST_LINK_room_07',
    1500:'Z2_SOUGEN',
    1501:'Z2_SOUGEN_room_00',
    1502:'Z2_BOMYA',
    1503:'Z2_BOMYA_room_00',
    1504:'Z2_KYOJINNOMA',
    1505:'Z2_KYOJINNOMA_room_00',
    1506:'Z2_KOEPONARACE',
    1507:'Z2_KOEPONARACE_room_00',
    1508:'Z2_GORONRACE',
    1509:'Z2_GORONRACE_room_00',
    1510:'Z2_TOWN',
    1511:'Z2_TOWN_room_00',
    1512:'Z2_ICHIBA',
    1513:'Z2_ICHIBA_room_00',
    1514:'Z2_BACKTOWN',
    1515:'Z2_BACKTOWN_room_00',
    1516:'Z2_CLOCKTOWER',
    1517:'Z2_CLOCKTOWER_room_00',
    1518:'Z2_ALLEY',
    1519:'Z2_ALLEY_room_00',
    1520:'SPOT00',
    1521:'SPOT00_room_00',
    1522:'KAKUSIANA',
    1523:'KAKUSIANA_room_00',
    1524:'KAKUSIANA_room_01',
    1525:'KAKUSIANA_room_02',
    1526:'KAKUSIANA_room_03',
    1527:'KAKUSIANA_room_04',
    1528:'KAKUSIANA_room_05',
    1529:'KAKUSIANA_room_06',
    1530:'KAKUSIANA_room_07',
    1531:'KAKUSIANA_room_08',
    1532:'KAKUSIANA_room_09',
    1533:'KAKUSIANA_room_10',
    1534:'KAKUSIANA_room_11',
    1535:'KAKUSIANA_room_12',
    1536:'KAKUSIANA_room_13',
    1537:'KAKUSIANA_room_14',
    1538:'bump_texture_static',
    }

def read_uint32_be(offset):
    return struct.unpack('>I', romData[offset:offset+4])[0]

def write_output_file(name, offset, size):
    try:
        with open(name, 'wb') as f:
            f.write(romData[offset:offset+size])
    except IOError:
        print('failed to write file ' + name)

if __name__ == '__main__':
    parser = argparse.ArgumentParser()

    parser.add_argument('input', help='input file')
    args = parser.parse_args()

    try:
        os.mkdir('baserom')
    except:
        pass

    try:
        os.mkdir('decomp')
    except:
        pass

    # read baserom data
    try:
        with open(args.input, 'rb') as f:
            romData = f.read()
    except IOError:
        print('failed to read file ' + args.input)
        sys.exit(1)

    dmadata_size = read_uint32_be(FILE_TABLE_OFFSET + 16 * 2 + 4) - read_uint32_be(FILE_TABLE_OFFSET + 16 * 2 + 0)
    file_count = dmadata_size // 0x10

    # extract files
    for i in range(0, file_count):
        entryOffset = FILE_TABLE_OFFSET + 16 * i

        virtStart = read_uint32_be(entryOffset + 0)
        virtEnd   = read_uint32_be(entryOffset + 4)
        physStart = read_uint32_be(entryOffset + 8)
        physEnd   = read_uint32_be(entryOffset + 12)

        if i in FILE_NAMES:
            filename = FILE_NAMES[i]
        else:
            filename = '%03d_0x%08x' % (i, physStart)

        if physEnd == 0:  # uncompressed
            compressed = False
            size = virtEnd - virtStart
        else:             # compressed
            compressed = True
            size = physEnd - physStart

        if physStart == 0xFFFFFFFF: # file is in table but not on cart?
            continue

        if virtStart == 0 and virtEnd == 0: # there are several entries at the end like this...
            continue

        print('extracting ' + filename + ' (0x%08X, 0x%08X, 0x%08X)' % (virtStart, virtEnd, size))

        if compressed:
            #print('decompressing ' + filename)

            decompressed_data = decompress(romData[physStart:physStart+size])

            writefile = open('decomp/' + filename, 'wb')
            writefile.write(decompressed_data)
            writefile.close()
        else:
            write_output_file('baserom/' + filename, physStart, size)
