//
// Mr. Blonde's Revenge
//

#include "stagesetup.h"

// Characters
#define CHR_CHIEF 0x21
#define CHR_CASS  0x22

// Objects
#define OBJ_LIGHTSWITCH     0x14
#define OBJ_CHIEF_LIFT      0x4e
#define OBJ_BLONDE_LIFT     0x4f
#define OBJ_SHUTTLE1        0x51
#define OBJ_BOND_BOMB       0x52
#define OBJ_COOP_BOMB       0x53
#define OBJ_PLANTED_BOMB    0x54
#define OBJ_LOBBYDOOR_LEFT  0x5f
#define OBJ_LOBBYDOOR_RIGHT 0x60
#define OBJ_SHUTTLE2        0x63

// Stage flags
#define STAGEFLAG_LIGHTS_OFF       0x00000100
#define STAGEFLAG_CASS_DEAD        0x00000200
#define STAGEFLAG_CASS_CAPTURED    0x00000400
#define STAGEFLAG_CHIEF_DEAD       0x00000800
#define STAGEFLAG_BOMB_PLANTED     0x00001000
#define STAGEFLAG_BOMB_EXPIRED     0x00002000
#define STAGEFLAG_BOMB_UNPLANTABLE 0x00004000
#define STAGEFLAG_TRIGGER_YWSM     0x00008000
#define STAGEFLAG_CASS_SAID_YWSM   0x00010000 // "You won't shoot me"

// AI Lists
#define AILIST_INIT_HOVERCAR        0x0401
#define AILIST_INIT_60HP_GUARD      0x040e
#define AILIST_INIT_40HP_GUARD      0x040f
#define AILIST_INIT_SEARCHING_GUARD 0x0410
#define AILIST_CASS_IN_OFFICE       0x0411
#define AILIST_INIT_CASS            0x0412
#define AILIST_CASS_RUNNING         0x0413
#define AILIST_INIT_CHIEF           0x0414
#define AILIST_CHIEF                0x0415
#define AILIST_OUTRO                0x0417

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x4a01)
	briefing(1, 0x4a00)
	briefing(2, 0x4a02)
	briefing(3, 0x4a03)

	beginobjective(0, L_WAX(5), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Plant explosive device in lab lift"
		complete_flags(STAGEFLAG_BOMB_PLANTED)
		fail_flags(STAGEFLAG_BOMB_EXPIRED)
		fail_flags(STAGEFLAG_BOMB_UNPLANTABLE)
	endobjective

	beginobjective(1, L_WAX(6), (DIFFBIT_PA | DIFFBIT_PD)) // "Eliminate dataDyne Captain"
		complete_flags(STAGEFLAG_CHIEF_DEAD)
	endobjective

	beginobjective(2, L_WAX(4), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Locate and escort Cassandra to helipad"
		complete_flags(STAGEFLAG_CASS_CAPTURED)
		fail_flags(STAGEFLAG_CASS_DEAD)
	endobjective

	tag(0x3d, 1)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0095, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0096, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0097, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0098, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANWALL, 0x0099, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000222, 0x00000000, 0x00000002, 0x01000000)
	tag(0x2e, 1)
	door(0x0100, MODEL_DOOR4A_G5, 0x022b, 0x00000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001200, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR4B_G5, 0x022c, 0x00000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2f, -1)
	door(0x0100, MODEL_DD_DECODOOR, 0x0226, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DECODOOR, 0x0227, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(OBJ_LOBBYDOOR_LEFT, 1)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0229, 0x04000400, 0x20000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x022a, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(OBJ_LOBBYDOOR_RIGHT, -1)
	tag(0x61, 1)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0229, 0x04000400, 0x20000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x022a, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x62, -1)
	tag(0x33, 1)
	door(0x0100, MODEL_DD_SECRETDOOR, 0x0228, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x02140000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SECRETDOOR, 0x00bc, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x02140000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a0, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a1, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a2, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b2, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00aa, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ab, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ac, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ad, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ae, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b1, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0e, 2)
	tag(0x0f, 2)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00af, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b0, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b6, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x40, 1)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00bb, 0x10000400, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00b8, 0x14000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00b9, 0xb4000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00ba, 0x94000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x57, 8)
	tag(0x58, 8)
	tag(0x59, 8)
	tag(0x5a, 8)
	tag(0x55, 3)
	tag(0x50, 3)
	tag(OBJ_CHIEF_LIFT, 1)
	lift(0x0100, MODEL_DD_LIFTR, 0x0256, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0256, 0x012e, 0x012fffff, 0x00000001, 0x00000003, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0224, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009c, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009b, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009a, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 2)
	link_objects(-4, -7, 0, 1)
	tag(0x5b, 7)
	tag(0x5c, 7)
	tag(0x5d, 7)
	tag(0x5e, 7)
	tag(0x56, 2)
	tag(OBJ_BLONDE_LIFT, 1)
	lift(0x0100, MODEL_DD_LIFTR, 0x012d, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012d, 0x0255, 0xffffffff, 0x00000001, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009d, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009e, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009f, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0225, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-2, -6, 0, 1)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00bd, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00be, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00bf, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c0, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c1, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c2, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c3, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c4, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c5, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c6, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c7, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c8, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00ca, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cb, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cc, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cd, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00ce, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cf, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0235, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0236, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0237, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0238, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0239, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023a, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011b, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011c, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00df, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e0, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e1, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e2, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e3, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e4, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e5, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e6, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e7, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0123, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0124, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0125, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0126, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0127, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0128, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0129, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x012a, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e8, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e9, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ea, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00eb, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ec, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ed, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ee, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ef, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f0, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f1, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f2, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f3, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f4, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f5, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f6, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f7, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f8, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f9, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fa, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fb, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fc, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fd, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fe, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ff, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0100, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0101, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0102, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0103, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0104, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0105, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0106, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0107, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0108, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0109, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010a, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010b, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010c, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010d, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010e, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010f, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0110, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0111, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0112, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0113, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0114, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0117, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0118, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0119, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011a, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0248, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0249, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024a, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024b, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024c, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024d, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024e, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024f, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0250, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW_FOYER, 0x0251, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW_FOYER, 0x0252, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00d3, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00d4, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d5, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d2, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x37, 1)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d7, 0x000205e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d8, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x38, 1)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d9, 0x000205e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00d6, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x00da, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x0253, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x0254, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3b, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a4, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a3, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x01a2, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3c, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a5, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a6, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x01a7, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3a, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a8, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a9, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x01aa, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x39, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01ab, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01ac, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x01ad, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01b0, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01af, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x01ae, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b1, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0d, 1)
	stdobject(0x0100, MODEL_LIGHTSWITCH2, 0x013e, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01b3, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b4, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x01b5, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b2, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0c, 1)
	stdobject(0x0100, MODEL_PC1, 0x01b6, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00db, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x36, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01b7, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b8, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x01b9, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x35, 1)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00dc, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00dd, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x022d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x022e, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0232, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0231, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x0230, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x0233, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x0234, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	chr(0x00000200, 0x01, 0x01e9, BODY_FEM_GUARD, HEAD_RANDOM, 0x040b, -1, -1, 1000, 100, 0xc000a701, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x14, 0x020f, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, -1, -1, 500, 100, 0xe0102000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x020e, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, -1, -1, 500, 100, 0xc0002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x0210, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, -1, -1, 500, 100, 0xc0002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x02, 0x01eb, BODY_FEM_GUARD, HEAD_RANDOM, 0x040c, -1, -1, 1000, 100, 0xc000a701, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0f, 0x021e, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, -1, -1, 500, 100, 0xe098a000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)

	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)

	chr(0x00000200, 0x10, 0x021f, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, -1, -1, 500, 100, 0xc0882000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x11, 0x0220, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, -1, -1, 500, 100, 0xc0882000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x13, 0x0222, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, -1, -1, 500, 100, 0xc0882000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x0e, 0x01fe, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_SEARCHING_GUARD, 0x0218, -1, 1000, 100, 0xc088c080, 0x10000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x12, 0x01fc, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_SEARCHING_GUARD, 0x0218, -1, 1000, 100, 0xc088c080, 0x10000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x03, 0x021c, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, 0x0218, -1, 1000, 100, 0xc08cc080, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x04, 0x021d, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_40HP_GUARD, 0x0218, -1, 1000, 100, 0xc08cc080, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x00, 0x007d, BODY_FEM_GUARD, HEAD_RANDOM, 0x0402, -1, -1, 100, 100, 0xcc080000, 0x02000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x0b, 0x008e, BODY_FEM_GUARD, HEAD_RANDOM, 0x0403, -1, -1, 100, 100, 0xc8080000, 0x02000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x09, 0x0081, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 100, 100, 0xe8980000, 0x02000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x1e, 0x01ce, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xe8102000, 0x00000100, TEAM_ENEMY, SQUADRON_05, 0x39, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x1f, 0x01cf, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xe8000000, 0x00000100, TEAM_ENEMY, SQUADRON_05, 0x3a, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x20, 0x01d0, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xe8182000, 0x00000100, TEAM_ENEMY, SQUADRON_05, 0x3b, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x07, 0x0058, BODY_FEM_GUARD, HEAD_RANDOM, 0x0404, -1, -1, 100, 100, 0xc008a000, 0x02000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x0a, 0x0057, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 100, 100, 0xe088a000, 0x02000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x0c, 0x0060, BODY_FEM_GUARD, HEAD_RANDOM, 0x0405, -1, -1, 100, 100, 0xc008a000, 0x02000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x18, 0x01c7, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xc0002000, 0x00000100, TEAM_ENEMY, SQUADRON_07, 0x35, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x19, 0x01c8, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xc0002400, 0x00000100, TEAM_ENEMY, SQUADRON_07, 0x36, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004200, 0x1a, 0x01c9, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xe0102400, 0x00000100, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x1b, 0x01ca, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xc0002000, 0x00000100, TEAM_ENEMY, SQUADRON_08, 0x37, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x1c, 0x01cb, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xc0002000, 0x00000100, TEAM_ENEMY, SQUADRON_08, 0x38, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00004200, 0x1d, 0x01cc, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_60HP_GUARD, -1, -1, 1000, 100, 0xe0102000, 0x00000100, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x08, 0x0028, BODY_DDSHOCK, HEAD_DDSHOCK, 0x0408, -1, -1, 500, 100, 0x4808aa80, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x0d, 0x006f, BODY_DDSHOCK, HEAD_DDSHOCK, 0x0409, -1, -1, 100, 100, 0x4808a880, 0x00002000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)

	chr(0x00004200, 0x17, 0x01c6, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_40HP_GUARD, -1, -1, 2000, 100, 0x4000ac00, 0x00002100, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRDY357, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x06, 0x0011, BODY_DDSHOCK, HEAD_DDSHOCK, 0x0407, 0x001d, -1, 1000, 9, 0x4000ae08, 0x0000a080, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x05, 0x01c0, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_40HP_GUARD, 0x001e, -1, 1000, 100, 0x4820ae88, 0x00002000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)

	chr(0x00010400, CHR_CASS, 0x0133, BODY_CASSANDRA, HEAD_CASSANDRA, AILIST_INIT_CASS, -1, -1, 1000, 100, 0x8000c400, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	chr(0x00004000, CHR_CHIEF, 0x0223, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_CHIEF, -1, -1, 1000, 100, 0xc008a000, 0x00000100, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRFALCON2, CHR_CHIEF, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRFALCON2, CHR_CHIEF, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2, 0x00ffffff, 0x00000000)

	link_collectibles(-1, -2)
	tag(0x1f, 1)
	hovercar(0x004c, MODEL_DD_HOVCOP, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x20, 1)
	hovercar(0x004c, MODEL_DD_HOVCOP, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x21, 1)
	hovercar(0x004c, MODEL_DD_HOVCAR, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x22, 1)
	hovercar(0x004c, MODEL_DD_HOVCAR, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x23, 1)
	hovercar(0x004c, MODEL_DD_HOVMOTO, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x24, 1)
	hovercar(0x004c, MODEL_DD_HOVMOTO, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x25, 1)
	hovercar(0x004c, MODEL_DD_HOVTRUCK, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x26, 1)
	hovercar(0x004c, MODEL_DD_HOVTRUCK, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x27, 1)
	hovercar(0x004c, MODEL_DD_HOVCAB, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x28, 1)
	hovercar(0x004c, MODEL_DD_HOVCAB, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_DD_AC_UNEXP, 0x019f, 0x13500d00, 0x20304300, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_DD_AC_EXP, 0x01a1, 0x031204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_DD_ACBOT_UNEXP, 0x019e, 0x13500d00, 0x20304300, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_DD_ACBOT_EXP, 0x01a0, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0140, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0141, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0142, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0143, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_STONEDESK, 0x0134, 0x000205e1, 0x00204000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_PC1, 0x0132, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	camera(0x0100, MODEL_CCTV_PD, 0x0136, 0x00000002, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00110000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x0100, MODEL_CCTV_PD, 0x0137, 0x00000002, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x0100, MODEL_CCTV_PD, 0x0138, 0x00000002, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00190000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x0100, MODEL_CCTV_PD, 0x0139, 0x00000002, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x001d0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000)
	camera(0x0100, MODEL_CCTV_PD, 0x013a, 0x00000002, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00670000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x0100, MODEL_CCTV_PD, 0x013b, 0x00000002, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00760000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000)
	camera2(0x0000, 0xfffd05c6, 0xfff25662, 0x000013f6, 0x005a0000, 0x00063f8f, 0x00000219)
	tag(0x09, -1)
	camera2(0x0000, 0xffff51d2, 0xfffd0422, 0x00000c58, 0x00060000, 0x0005f5c2, 0x00000219)
	tag(0x15, -1)
	camera2(0x0000, 0xffff67da, 0xfffd8eec, 0xfffe7c44, 0x0004a147, 0x0005f851, 0x00000219)
	tag(0x16, -1)
	tag(0x04, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x025c, 0x00000002, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x03, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x013c, 0x00000002, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(OBJ_LIGHTSWITCH, 1)
	stdobject(0x0100, MODEL_LIGHTSWITCH, 0x013d, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x10, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x0258, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030000)
	tag(0x11, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x0259, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030000)
	tag(0x12, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x025a, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030000)
	tag(0x13, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x025b, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030000)
	tag(0x19, 2)
	tag(0x1a, 2)
	stdobject(0x0100, MODEL_DD_BANNER, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_BANNER, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x17, 1)
	stdobject(0x0100, MODEL_DDJUMPSHIP, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1b, 1)
	stdobject(0x0024, MODEL_DDJUMPSHIP, 0xffff, 0x00020001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x18, 1)
	stdobject(0x0100, MODEL_ROPE, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1c, 1)
	stdobject(0x0051, MODEL_TAXICAB, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1e, 1)
	stdobject(0x0024, MODEL_TAXICAB, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1d, 1)
	stdobject(0x0051, MODEL_POLICECAR, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x30, 1)
	stdobject(0x0024, MODEL_POLICECAR, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x29, 1)
	stdobject(0x0019, MODEL_DD_HOVCOP, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2a, 1)
	stdobject(0x0019, MODEL_DD_HOVCAR, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2b, 1)
	stdobject(0x0019, MODEL_DD_HOVMOTO, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2c, 1)
	stdobject(0x0019, MODEL_DD_HOVCAB, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2d, 1)
	stdobject(0x0019, MODEL_DD_HOVTRUCK, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x00de, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(OBJ_SHUTTLE1, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00421508, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(OBJ_SHUTTLE2, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00421508, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0121, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0122, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011f, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0120, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tag(0x52, 1)
	stdobject(0x0100, MODEL_SKEDARBOMB, 0x0011, 0x013004e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x3c, L_WAX(17), L_WAX(18), L_WAX(19), L_WAX(20), L_WAX(21), 0x0000, 0x0000) // ""
	tag(0x53, 1)
	stdobject(0x0100, MODEL_SKEDARBOMB, 0x0011, 0x013004e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x3c, L_WAX(17), L_WAX(18), L_WAX(19), L_WAX(20), L_WAX(21), 0x0000, 0x0000) // ""
	tag(0x54, 1)
	stdobject(0x0100, MODEL_SKEDARBOMB, 0x0257, 0x000200e3, 0x00080001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x41, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x000a, 0x00004001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x42, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x025f, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x43, 1)
	weapon(0x0100, MODEL_CHRPCGUN, 0x01d2, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	tag(0x44, 1)
	weapon(0x0100, MODEL_CHRFALCON2, 0x01d5, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2, 0x00ffffff, 0x00000000)
	tag(0x45, 1)
	weapon(0x0100, MODEL_CHRFALCON2, 0x01d4, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2, 0x00ffffff, 0x00000000)
	tag(0x46, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d6, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_SMG)
	tag(0x47, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d7, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x48, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d8, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x49, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d9, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4a, 1)
	ammocrate(0x0100, MODEL_CHRFALCON2, 0x01da, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4a, 1)
	ammocrate(0x0100, MODEL_CHRFALCON2, 0x01da, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4b, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01db, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4c, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0x025d, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	tag(0x4d, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0x025e, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	endprops
};

s32 intro[] = {
	intro_weapon(WEAPON_MAULER, -1)
	ammo(AMMOTYPE_PISTOL, 100)
	intro_weapon(WEAPON_CAMSPY, -1)
	outfit(OUTFIT_MRBLONDE)
	intro_weapon(WEAPON_CLOAKINGDEVICE, -1)
#if VERSION == VERSION_PAL_FINAL
	ammo(AMMOTYPE_CLOAK, 1500) // 25 seconds
#else
	ammo(AMMOTYPE_CLOAK, 1800) // 30 seconds
#endif
	ammo(AMMOTYPE_PISTOL, 100)
	spawn(0x01f8)
	endintro
};

s32 path00[] = {
	0x0144,
	0x0145,
	-1,
};

s32 path01[] = {
	0x0146,
	0x0147,
	0x0148,
	-1,
};

s32 path02[] = {
	0x0149,
	0x014a,
	0x014b,
	0x014c,
	0x014d,
	0x014e,
	-1,
};

s32 path03[] = {
	0x0152,
	0x0151,
	0x0150,
	0x014f,
	-1,
};

s32 path04[] = {
	0x0154,
	0x0157,
	0x0156,
	0x0153,
	0x0155,
	-1,
};

s32 path05[] = {
	0x0159,
	0x015a,
	0x015d,
	0x015b,
	0x015c,
	0x0158,
	-1,
};

s32 path06[] = {
	0x015e,
	0x015f,
	0x0160,
	0x0161,
	0x0162,
	0x0163,
	-1,
};

s32 path07[] = {
	0x0167,
	0x0166,
	0x0165,
	0x0168,
	0x0169,
	0x0164,
	-1,
};

s32 path08[] = {
	0x016a,
	0x016b,
	0x016c,
	0x016d,
	-1,
};

s32 path09[] = {
	0x016e,
	0x016f,
	0x0170,
	0x0171,
	0x0172,
	0x0173,
	-1,
};

s32 path10[] = {
	0x0174,
	0x0175,
	0x0176,
	0x0177,
	-1,
};

s32 path11[] = {
	0x0178,
	0x0179,
	0x017a,
	0x017b,
	0x017c,
	0x017d,
	0x017e,
	0x017f,
	-1,
};

s32 path12[] = {
	0x0180,
	0x0181,
	0x0182,
	-1,
};

s32 path13[] = {
	0x0183,
	0x0184,
	0x0185,
	-1,
};

s32 path14[] = {
	0x0186,
	0x0191,
	-1,
};

s32 path15[] = {
	0x0187,
	0x0190,
	-1,
};

s32 path16[] = {
	0x0188,
	0x018f,
	-1,
};

s32 path17[] = {
	0x0189,
	0x018e,
	-1,
};

s32 path18[] = {
	0x018c,
	0x018b,
	-1,
};

s32 path19[] = {
	0x018d,
	0x018a,
	-1,
};

s32 path20[] = {
	0x0192,
	0x019d,
	-1,
};

s32 path21[] = {
	0x0193,
	0x019c,
	-1,
};

s32 path22[] = {
	0x0194,
	0x019b,
	-1,
};

s32 path23[] = {
	0x0195,
	0x019a,
	-1,
};

s32 path24[] = {
	0x0197,
	0x0198,
	-1,
};

s32 path25[] = {
	0x0196,
	0x0199,
	-1,
};

s32 path26[] = {
	0x007d,
	0x007c,
	0x0077,
	0x0076,
	0x008d,
	0x008c,
	0x008b,
	0x0088,
	0x008b,
	0x008c,
	-1,
};

s32 path27[] = {
	0x008e,
	0x008d,
	0x008c,
	0x008b,
	0x0088,
	-1,
};

s32 path30[] = {
	0x000c,
	0x000b,
	0x000f,
	0x0010,
	0x0013,
	0x0011,
	0x0012,
	0x0011,
	0x0010,
	0x000f,
	0x000b,
	-1,
};

s32 path32[] = {
	0x0028,
	0x0029,
	0x002f,
	0x0030,
	0x002b,
	0x002a,
	0x002d,
	0x002c,
	0x002e,
	0x0031,
	0x0032,
	0x003b,
	0x003a,
	0x0039,
	-1,
};

s32 path33[] = {
	0x0032,
	0x003b,
	0x003a,
	0x0039,
	0x0074,
	0x006e,
	0x006d,
	0x0072,
	0x0073,
	0x0070,
	0x0071,
	0x006f,
	-1,
};

s32 path34[] = {
	0x01f6,
	0x01f5,
	0x01f4,
	0x01f3,
	0x01f2,
	0x01f0,
	0x01ef,
	0x01ee,
	0x01ec,
	0x01e8,
	0x01e6,
	0x01e5,
	0x01dd,
	0x01e4,
	0x01e3,
	0x01e2,
	0x01e1,
	-1,
};

s32 path35[] = {
	0x01ea,
	0x01eb,
	0x01ef,
	0x01f1,
	0x01f2,
	0x01f3,
	0x01f4,
	0x01f6,
	0x01e2,
	0x01dd,
	0x01e5,
	0x01e6,
	-1,
};

s32 path36[] = {
	0x01e6,
	0x01e5,
	0x01dd,
	0x01e2,
	0x01f6,
	0x01f4,
	0x01f3,
	0x01f2,
	0x01f1,
	0x01ef,
	0x01eb,
	0x01ea,
	-1,
};

s32 path37[] = {
	0x007c,
	0x0078,
	0x0077,
	0x0076,
	0x008e,
	0x008d,
	0x008c,
	0x008b,
	0x008a,
	0x0089,
	0x0088,
	0x0090,
	0x0075,
	0x006f,
	0x0071,
	0x0070,
	0x0073,
	0x0066,
	0x0058,
	0x0059,
	0x005a,
	0x0067,
	0x0068,
	0x005b,
	0x005c,
	0x005d,
	0x005e,
	0x0061,
	-1,
};

s32 path31[] = {
	0x0011,
	0x0013,
	0x0014,
	0x0015,
	0x0016,
	0x0017,
	-1,
};

s32 path28[] = {
	0x0058,
	0x0067,
	0x0068,
	0x005b,
	0x005d,
	-1,
};

s32 path29[] = {
	0x0060,
	0x005f,
	0x0056,
	0x0055,
	0x0051,
	0x0052,
	0x0053,
	-1,
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_FLYING },
	{ path02, 2, PATHTYPE_FLYING },
	{ path03, 3, PATHTYPE_FLYING },
	{ path04, 4, PATHTYPE_FLYING },
	{ path05, 5, PATHTYPE_FLYING },
	{ path06, 6, PATHTYPE_FLYING },
	{ path07, 7, PATHTYPE_FLYING },
	{ path08, 8, PATHTYPE_FLYING },
	{ path09, 9, PATHTYPE_FLYING },
	{ path10, 10, PATHTYPE_FLYING },
	{ path11, 11, PATHTYPE_FLYING },
	{ path12, 12, PATHTYPE_FLYING },
	{ path13, 13, PATHTYPE_FLYING },
	{ path14, 14, PATHTYPE_FLYING },
	{ path15, 15, PATHTYPE_FLYING },
	{ path16, 16, PATHTYPE_FLYING },
	{ path17, 17, PATHTYPE_FLYING },
	{ path18, 18, PATHTYPE_FLYING },
	{ path19, 19, PATHTYPE_FLYING },
	{ path20, 20, PATHTYPE_FLYING },
	{ path21, 21, PATHTYPE_FLYING },
	{ path22, 22, PATHTYPE_FLYING },
	{ path23, 23, PATHTYPE_FLYING },
	{ path24, 24, PATHTYPE_FLYING },
	{ path25, 25, PATHTYPE_FLYING },
	{ path26, 26, PATHTYPE_CIRCULAR },
	{ path27, 27, PATHTYPE_BACKANDFORTH },
	{ path28, 28, PATHTYPE_BACKANDFORTH },
	{ path29, 29, PATHTYPE_BACKANDFORTH },
	{ path30, 30, PATHTYPE_CIRCULAR },
	{ path31, 31, PATHTYPE_BACKANDFORTH },
	{ path32, 32, PATHTYPE_BACKANDFORTH },
	{ path33, 33, PATHTYPE_BACKANDFORTH },
	{ path34, 34, PATHTYPE_CIRCULAR },
	{ path35, 35, PATHTYPE_CIRCULAR },
	{ path36, 36, PATHTYPE_CIRCULAR },
	{ path37, 37, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

u8 func0401_init_hovercar[] = {
	dprint 'h','o','v','\n',0,
	begin_hovercar_path(0x00)
	set_vehicle_speed(0x0c00, 120)

	beginloop(0x04)
	endloop(0x04)

	// Everything below here in this function is unreachable
	label(0x08)
	set_vehicle_speed(0x0600, 120)
	goto_first(0x04)

	label(0x09)
	set_vehicle_speed(0x0700, 120)
	goto_first(0x04)

	label(0x0a)
	set_vehicle_speed(0x0800, 120)
	goto_first(0x04)

	label(0x0b)
	set_vehicle_speed(0x0900, 120)
	goto_first(0x04)

	label(0x0c)
	set_vehicle_speed(0x0a00, 120)
	goto_first(0x04)

	label(0x0d)
	set_vehicle_speed(0x0b00, 120)
	goto_first(0x04)

	label(0x0e)
	set_vehicle_speed(0x0d00, 120)
	goto_first(0x04)

	endlist
};

u8 func0402_start_path26[] = {
	assign_path(26)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0403_start_path27[] = {
	assign_path(27)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0404_start_path28[] = {
	assign_path(28)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0405_start_path29[] = {
	assign_path(29)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0406_start_path30[] = {
	assign_path(30)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0407_start_path31[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_returnlist(CHR_SELF, 0x0407)
	assign_path(31)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0408_start_path32[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(32)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0409_start_path33[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(33)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040a_start_path34[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(34)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040b_start_path35[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(35)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040c_start_path36[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(36)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040d_start_path37[] = {
	assign_path(37)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func1002_lightswitch[] = {
	// Wait until switch activated
	beginloop(0x04)
		if_chr_activated_object(CHR_ANY, OBJ_LIGHTSWITCH, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		play_sound(0x00ba, -1)
		if_stage_flag_eq(STAGEFLAG_LIGHTS_OFF, TRUE, /*goto*/ 0x06)

		// Turning lights off
		set_stage_flag(STAGEFLAG_LIGHTS_OFF)
		set_lights_state(0x0044, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x0039, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x003c, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x003d, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x003e, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x003b, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x0042, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x003f, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x003a, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x0041, 0x01, 0x00, 0x00, 0x00)
		set_lights_state(0x0040, 0x01, 0x00, 0x00, 0x00)
		reloop(0x04)

		// Turning lights on
		label(0x06)
		unset_stage_flag(STAGEFLAG_LIGHTS_OFF)
		set_lights_state(0x0044, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x0039, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x003c, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x003d, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x003e, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x003b, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x0042, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x003f, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x003a, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x0041, 0x01, 0x64, 0x00, 0x00)
		set_lights_state(0x0040, 0x01, 0x64, 0x00, 0x00)
	endloop(0x04)

	endlist
};

u8 func1001_objectives_failed_msg[] = {
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1000_setup_counterop[] = {
	noop016c
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	give_object_to_chr(OBJ_BOND_BOMB, CHR_BOND)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2c)
	give_object_to_chr(OBJ_COOP_BOMB, CHR_COOP)
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func040e_init_60hp_guard[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func040f_init_40hp_guard[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0410_init_searching_guard[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_returnlist(CHR_SELF, GAILIST_SEARCH_FOR_PLAYER)
	set_ailist(CHR_SELF, GAILIST_SEARCH_FOR_PLAYER)
	endlist
};

u8 func0412_init_cass[] = {
	set_chr_maxdamage(CHR_SELF, 40)
	set_self_chrflag(CHRCFLAG_01000000)
	set_ailist(CHR_SELF, AILIST_CASS_IN_OFFICE)
	endlist
};

u8 func0411_cass_in_office[] = {
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	// Dying
	label(0x2c)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Not dying
	label(0x06)
	if_has_gun(CHR_SELF, /*goto*/ 0x2c)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_stage_flag(STAGEFLAG_TRIGGER_YWSM)
	set_shotlist(AILIST_CASS_RUNNING)
	restart_timer
	speak(CHR_TARGET, L_WAX(8), 0x0d23, CHANNEL_6, COLOR_06_WHITE) // "Go to the helipad if you want to live."
	chr_do_animation(0x0226, -1, -1, 0x10, 0x10, CHR_SELF, 2)
	yield

	// Wait 3 seconds
	beginloop(0x08)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, AILIST_CASS_RUNNING)

	// Waiting for player to enter office
	label(0x2c)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x5a)
	set_shotlist(AILIST_CASS_IN_OFFICE)
	set_self_chrflag(CHRCFLAG_00040000)
	if_chr_dying(CHR_CASS, /*goto*/ 0x06)
	if_chr_unloaded(CHR_CASS, /*goto*/ 0x06)
	goto_next(0x2c)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2c)
	chr_do_animation(0x00a0, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x54)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x55)
	endloop(0x54)

	// Player has entered
	label(0x55)
	stop_chr
	yield
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x56)

	beginloop(0x56)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x57)
		if_jo_ccw_direction_gt(246, /*goto*/ 0x57)
	endloop(0x56)

	// Draw weapon
	label(0x57)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	chr_do_animation(0x0245, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	try_equip_weapon(MODEL_CHRFALCON2, WEAPON_FALCON2, 0x00000000, /*goto*/ 0x2c)
	label(0x2c)
	speak(CHR_TARGET, L_WAX(7), 0x81a3, CHANNEL_6, COLOR_04_ORANGE) // "Get the hell out of my office..."

	beginloop(0x58)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x58)

	label(0x2c)
	set_chr_flag_bankx(0x1e, CHRFLAG0_CAN_HEAR_ALARMS, BANK_0)
	set_chr_flag_bankx(0x20, CHRFLAG0_CAN_HEAR_ALARMS, BANK_0)
	set_chr_flag_bankx(0x1a, CHRFLAG0_CAN_HEAR_ALARMS, BANK_0)
	yield
	activate_alarm

	// Wait until player in disarm range
	beginloop(0x5a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_in_disarm_range(/*goto*/ 0x83)
		reloop(0x5a)

		label(0x83)
		try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x2c)
		label(0x2c)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x82)

		// Wait until shooting animation finished
		beginloop(0x82)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x82)

		label(0x06)
	endloop(0x5a)

	endlist
};

u8 func0413_cass_running[] = {
	remove_cass_necklace(CHR_CASS)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_shotlist(AILIST_CASS_RUNNING)
	if_chr_dying(CHR_CASS, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_CASS, /*goto*/ 0x06)
	if_chr_unloaded(CHR_CASS, /*goto*/ 0x06)
	goto_next(0x2c)

	// Dying
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Not dying
	label(0x2c)
	if_just_injured(CHR_SELF, /*goto*/ 0xb5)
	goto_next(0xb1)

	// Shot/hurt - wait until animation finished
	beginloop(0xb5)
		if_chr_stopped(/*goto*/ 0xb1)
	endloop(0xb5)

	// Wait until Blonde's speech has finished ("go to the helipad")
	beginloop(0xb1)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x03)
	endloop(0xb1)

	label(0x03)
		// Jog to roof. Keep looping until roof is reached or player has stopped
		// looking at Cass.
		restart_timer
		jog_to_pad(0x0000)

		beginloop(0x08)
			if_chr_sees_player(/*goto*/ 0x2c)
			if_chr_stopped(/*goto*/ 0x0d)
			goto_next(0x06)
			label(0x2c)
		endloop(0x08)

		// Player looked away from Cass.
		// While still running to pad, wait 2 seconds...
		label(0x06)
		restart_timer

		beginloop(0x0a)
			if_timer_gt(120, /*goto*/ 0x2c)
		endloop(0x0a)

		// Then stop and wait until in sight of player
		label(0x2c)
		stop_chr

		beginloop(0x09)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_chr_sees_player(/*goto*/ 0x2c)
		endloop(0x09)

		// Consider saying something
		label(0x2c)
		do_preset_animation(-1)
		restart_timer
		if_stage_flag_eq(STAGEFLAG_CASS_SAID_YWSM, FALSE, /*goto*/ 0x06)
		say_quip(CHR_TARGET, 0x2b, 0xff, 0x00, 0xff, BANK_1, 0x0a, 0x04)

		// And wait 2 seconds for the speech to finish
		beginloop(0x0b)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0b)

		// Return to jogging to the roof
		label(0x06)
		reloop(0x03)

		// At roof, or stopped for some other reason (eg. dead or maybe injured).
		// Check distance to pad repeatedly.
		label(0x0d)
		stop_chr

		beginloop(0x0e)
			if_chr_distance_to_pad_gt(CHR_SELF, 200, 0x0000, /*goto*/ 0x2c)
		endloop(0x0e)

		// Continue jogging
		label(0x2c)
	goto_first(0x03)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_check_cass_dead[] = {
	// Wait until Cass dead
	beginloop(0x03)
		if_chr_dying(CHR_CASS, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_CASS, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CASS, /*goto*/ 0x2c)
	endloop(0x03)

	label(0x2c)
	show_hudmsg(CHR_BOND, L_WAX(14)) // "Cassandra has been immobilized."
	set_stage_flag(STAGEFLAG_CASS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_check_cass_captured[] = {
	// Wait until Cass at helipad
	beginloop(0x03)
		if_chr_death_animation_finished(CHR_CASS, /*goto*/ 0x0d)
		if_chr_dying(CHR_CASS, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_CASS, /*goto*/ 0x0d)
		if_chr_y(CHR_CASS, 0, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_WAX(15)) // "Cassandra has been captured successfully."
		set_stage_flag(STAGEFLAG_CASS_CAPTURED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Cass is not at helipad
		label(0x2c)
	endloop(0x03)

	// Died
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1006_lift_disabling[] = {
	// If not PA, return
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)
	goto_next(0x2c)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Disable chief's lift
	label(0x2c)
	lock_door(0x50, 0x40)
	set_object_flag(OBJ_CHIEF_LIFT, OBJFLAG_DEACTIVATED)

	// Wait until player Y above -4300
	beginloop(0x03)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, -4300, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x06)
		label(0x2c)
	endloop(0x03)

	// Disable player's lift
	label(0x06)
	set_lights_state(0x0082, 0x02, 0x00, 0x78, 0x00)
	play_sound(0x8147, -1)
	set_object_flag(OBJ_BLONDE_LIFT, OBJFLAG_DEACTIVATED)
	unlock_door(0x50, 0x40)
	unset_object_flag(OBJ_CHIEF_LIFT, OBJFLAG_DEACTIVATED)
	unset_chr_chrflag(CHR_CHIEF, CHRCFLAG_HIDDEN)
	set_ailist(CHR_CHIEF, AILIST_CHIEF)
	show_hudmsg(CHR_BOND, L_WAX(25)) // "Lift has been disabled."

	// Wait until chief dead
	beginloop(0x08)
		if_chr_death_animation_finished(CHR_CHIEF, /*goto*/ 0x2c)
		if_chr_dying(CHR_CHIEF, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CHIEF, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	show_hudmsg(CHR_BOND, L_WAX(16)) // "Security chief has been eliminated."
	set_stage_flag(STAGEFLAG_CHIEF_DEAD)
	restart_timer

	// Wait 2 seconds
	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0x09)

	// Activate lifts and exit
	label(0x2c)
	unset_object_flag(OBJ_CHIEF_LIFT, OBJFLAG_DEACTIVATED)
	unset_object_flag(OBJ_BLONDE_LIFT, OBJFLAG_DEACTIVATED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0414_init_chief[] = {
	set_accuracy(40)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_morale(0)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0415_chief[] = {
	set_shotlist(AILIST_CHIEF)

	// Check if dying
	if_chr_dying(CHR_CHIEF, /*goto*/ 0x2c)
	if_chr_death_animation_finished(CHR_CHIEF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_CHIEF, /*goto*/ 0x2c)
	goto_next(0x03)
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Wait until player in sight
	beginloop(0x03)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x06)
		if_target_in_sight(/*goto*/ 0x2c)
		label(0x06)
		reloop(0x03)

		// Attack while in sight
		label(0x2c)
		try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x2c)
		label(0x2c)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x82)

		beginloop(0x82)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x82)

		label(0x06)
	endloop(0x03)

	endlist
};

u8 func100f_disable_chiefs_lift[] = {
	// If not PA, return
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0d)

	// Wait until player above -4400
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, -4400, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x06)
		label(0x2c)
		reloop(0x04)

		// Wait until chief above -4600
		label(0x06)
		if_chr_y(CHR_CHIEF, -4600, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x06)
		label(0x2c)
	endloop(0x04)

	// Wait half a second
	label(0x06)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x0a)

	// Disable chief's lift
	label(0x06)
	set_object_flag(OBJ_CHIEF_LIFT, OBJFLAG_DEACTIVATED)

	// A or SA - return
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_bomb_logic[] = {
	// Wait until in lab elevator and has bomb equipped
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x002b, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_SKEDARBOMB, /*goto*/ 0x2c)
	endloop(0x04)

	// Plant bomb
	label(0x2c)
	show_hudmsg(CHR_BOND, L_WAX(22)) // "Skedar bomb has been placed successfully."
	remove_weapon_from_inventory(WEAPON_SKEDARBOMB)
	set_stage_flag(STAGEFLAG_BOMB_PLANTED)
	hide_object(OBJ_BOND_BOMB)
	hide_object(OBJ_COOP_BOMB)
	assign_sound(0x8144, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_PLANTED_BOMB, 0x0258, 0x04b0)
	unset_object_flag2(OBJ_PLANTED_BOMB, OBJFLAG2_INVISIBLE)
	set_object_image(OBJ_PLANTED_BOMB, 0x00, 0x0f)
	unset_object_flag(OBJ_PLANTED_BOMB, OBJFLAG_INVINCIBLE)

	// Start 4 minute timer
	set_countdown_timer(240)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x08)
		if_countdown_timer_gt(0, /*goto*/ 0x2d)
		goto_next(0x2c)
		label(0x2d)
		if_object_in_good_condition(OBJ_PLANTED_BOMB, /*goto*/ 0x06)
		goto_next(0xb2)
		label(0x06)
	endloop(0x08)

	// Timer expired
	// @bug: This stage flag should be set when the bomb is exploding. It is not
	// set when the bomb is damaged.
	label(0x2c)
	set_countdown_timer(0)
	stop_countdown_timer
	set_stage_flag(STAGEFLAG_BOMB_EXPIRED)
	show_hudmsg(CHR_BOND, L_WAX(23)) // "Skedar bomb has detonated."

	// Wait 2 seconds
	restart_timer
	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0x09)

	// Bomb exploding
	label(0xb2)
	label(0x2c)
	explosions_around_chr(CHR_BOND)

	// Wait 2 seconds for player to die
	restart_timer

	beginloop(0xb4)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0xb4)

	label(0x2c)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_check_bomb_unplantable[] = {
	// If Agent, return
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)

	// Wait until bomb planted or alarm active
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_BOMB_PLANTED, TRUE, /*goto*/ 0x06)
		if_alarm_active(/*goto*/ 0x2c)
		reloop(0x04)

		// Bomb planted - return
		label(0x06)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Alarm active - lock door and wait for door to be closed or bomb planted
		label(0x2c)
		lock_door(0x2e, 0x40)
		lock_door(0x2f, 0x40)

		beginloop(0xb1)
			if_stage_flag_eq(STAGEFLAG_BOMB_PLANTED, TRUE, /*goto*/ 0x0d)
			if_door_state(0x2e, DOORSTATE_CLOSED, /*goto*/ 0xb2)
			reloop(0xb1)

			// Door is closed
			label(0xb2)
			yield
			chr_toggle_p1p2(CHR_SELF)
			if_stage_flag_eq(STAGEFLAG_BOMB_PLANTED, TRUE, /*goto*/ 0x0d)
			if_chr_in_room(CHR_BOND, 0x00, 0x002b, /*goto*/ 0x06)
			if_chr_in_room(CHR_COOP, 0x00, 0x002b, /*goto*/ 0x06)
			goto_next(0x2c)
			label(0x06)
		endloop(0xb1)

		// Fail mission
		label(0x2c)
		show_hudmsg(CHR_BOND, L_WAX(24)) // "Lift doors locked - bomb cannot be placed."
		set_stage_flag(STAGEFLAG_BOMB_UNPLANTABLE)

		// Difficulty is agent or bomb has been planted - return
		label(0x0d)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2c)
	endloop(0x04)

	endlist
};

u8 func1009_toggle_top_guards[] = {
	hide_chr(0x00)
	hide_chr(0x0b)
	hide_chr(0x09)
	hide_chr(0x1e)
	hide_chr(0x1f)
	hide_chr(0x20)
	hide_chr(0x07)
	hide_chr(0x0a)
	hide_chr(0x0c)
	hide_chr(0x18)
	hide_chr(0x19)
	hide_chr(0x1a)
	hide_chr(0x1b)
	hide_chr(0x1c)
	hide_chr(0x1d)
	hide_chr(0x08)
	hide_chr(0x0d)
	hide_chr(0x17)
	hide_chr(0x06)
	hide_chr(0x05)

	// Wait until player above -4100
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, -4100, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x06)
		label(0x2c)
	endloop(0x04)

	// Show chrs
	label(0x06)
	show_chr(0x00)
	yield
	show_chr(0x0b)
	yield
	show_chr(0x09)
	yield
	show_chr(0x1e)
	yield
	show_chr(0x1f)
	yield
	show_chr(0x20)
	yield
	show_chr(0x07)
	yield
	show_chr(0x0a)
	yield
	show_chr(0x0c)
	yield
	show_chr(0x18)
	yield
	show_chr(0x19)
	yield
	show_chr(0x1a)
	yield
	show_chr(0x1b)
	yield
	show_chr(0x1c)
	yield
	show_chr(0x1d)
	yield
	show_chr(0x08)
	yield
	show_chr(0x0d)
	yield
	show_chr(0x17)
	yield
	show_chr(0x06)
	yield
	show_chr(0x05)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100a_check_for_completion[] = {
	// Wait until all objectives complete
	beginloop(0x04)
		if_all_objectives_complete(/*goto*/ 0x2c)
		reloop(0x04)

		// Wait until player at helipad
		label(0x2c)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, 0, OPERATOR_LESS_THAN, /*goto*/ 0x2d)

		// Wait 1 second
		restart_timer

		beginloop(0x08)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x08)

		// If either player is alive
		label(0x06)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2c)
		if_chr_dying(CHR_BOND, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_BOND, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2c)
		if_chr_dying(CHR_COOP, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_COOP, /*goto*/ 0x2c)
		goto_next(0x06)

		// Both players dead
		label(0x2c)
		end_level
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// At least one player is alive
		label(0x06)
		set_ailist(CHR_SELF, AILIST_OUTRO)
		end_level

		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Player not at helipad
		label(0x2d)
	endloop(0x04)

	endlist
};

u8 func100b_start_lifts[] = {
	activate_lift(2, 0x55)
	activate_lift(1, 0x56)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_lift_doors[] = {
	// Wait until player activated a lift door
	beginloop(0xc1)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x57, /*goto*/ 0xb1)
		if_chr_activated_object(CHR_P1P2, 0x58, /*goto*/ 0xb1)
		if_chr_activated_object(CHR_P1P2, 0x59, /*goto*/ 0xb1)
		if_chr_activated_object(CHR_P1P2, 0x5a, /*goto*/ 0x2d)
		if_chr_activated_object(CHR_P1P2, 0x5b, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x5e, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x5c, /*goto*/ 0x2d)
		if_chr_activated_object(CHR_P1P2, 0x5d, /*goto*/ 0x2d)
		reloop(0xc1)

		label(0xb1)
		if_door_locked(0x50, 0x40, /*goto*/ 0x2d)
		goto_next(0x2c)

		label(0x2c)
		play_sound(0x81b0, -1)
		goto_next(0x06)

		// Door locked
		label(0x2d)
		play_sound(0x05dd, -1)

		// Wait 2 seconds
		label(0x06)
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
	endloop(0xc1)

	endlist
};

u8 func0416_intro[] = {
	set_object_flag2(0x61, OBJFLAG2_INVISIBLE)
	set_object_flag2(0x62, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x61, OBJFLAG_00000100)
	unset_object_flag(0x62, OBJFLAG_00000100)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_G5_INTRO)
	camera_movement(0x0472)
	cmd0175(60)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0473, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 110)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_MAULER, WEAPON_NONE)
	open_door(OBJ_LOBBYDOOR_LEFT)
	open_door(OBJ_LOBBYDOOR_RIGHT)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0xba) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
 \
		label(0x06)



	wait_until(106, 0xb1)
	play_sound(0x0162, CHANNEL_10)
	play_sound(0x047a, CHANNEL_10)

	wait_until(107, 0xb3)
	open_door(OBJ_LOBBYDOOR_LEFT)
	open_door(OBJ_LOBBYDOOR_RIGHT)

	wait_until(170, 0xb2)
	play_sound(0x0163, CHANNEL_10)

	wait_until(246, 0xb6)
	play_sound(0x0161, CHANNEL_10)

	wait_until(280, 0xb7)
	close_door(OBJ_LOBBYDOOR_LEFT)
	close_door(OBJ_LOBBYDOOR_RIGHT)

	wait_until(290, 0xb9)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0xba)
		label(0x2c)
		if_controller_button_pressed(/*goto*/ 0xba)
		label(0x2c)
	endloop(0x08)

	// Controller button pressed or cutscene finished
	label(0xba)
	hide_object(OBJ_LOBBYDOOR_LEFT)
	hide_object(OBJ_LOBBYDOOR_RIGHT)
	unset_object_flag2(0x61, OBJFLAG2_INVISIBLE)
	unset_object_flag2(0x62, OBJFLAG2_INVISIBLE)
	set_object_flag(0x61, OBJFLAG_00000100)
	set_object_flag(0x62, OBJFLAG_00000100)
	mute_channel(CHANNEL_10)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0473, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	restart_default_music
	reset_ambience
	enter_firstperson
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0417_outro[] = {
	set_invincible(CHR_BOND)
	hide_object(OBJ_SHUTTLE1)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_G5_OUTRO)
	camera_movement(0x0474)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	show_object(OBJ_SHUTTLE2)
	set_object_flag2(OBJ_SHUTTLE2, OBJFLAG2_04000000)
	set_object_flag3(OBJ_SHUTTLE2, OBJFLAG3_00000010)
	object_do_animation(0x0475, OBJ_SHUTTLE2, 0x04, 0xffff)
	show_nonessential_chrs(FALSE)
	restart_timer
	set_object_part_visible(OBJ_SHUTTLE2, FALSE)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0xba)
		label(0x2c)
		if_controller_button_pressed(/*goto*/ 0xba)
		label(0x2c)
	endloop(0x08)

	label(0xba)
	hide_object(OBJ_SHUTTLE2)

	label(0x06)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_cass_speech[] = {
	// Wait until trigger
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_YWSM, TRUE, /*goto*/ 0x2c)
	endloop(0x04)

	// Wait until channel empty
	label(0x2c)
	yield

	beginloop(0xb1)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0xb1)

	// Speak
	label(0x2c)
	restart_timer
	speak(CHR_CASS, L_WAX(13), 0x6af5, CHANNEL_6, COLOR_04_ORANGE) // "You won't shoot me!"
	chr_do_animation(0x00a0, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x09)
		if_timer_gt(80, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	set_stage_flag(STAGEFLAG_CASS_SAID_YWSM)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_init_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x01)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x00)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x0002, 0x05, 0x01)
	misc_command(0x0002, 0x06, 0x01)
	misc_command(0x0003, 0x05, 0x01)
	misc_command(0x0003, 0x06, 0x01)
	misc_command(0x0004, 0x05, 0x01)
	misc_command(0x0004, 0x06, 0x01)
	misc_command(0x0005, 0x06, 0x01)
	misc_command(0x0006, 0x06, 0x01)
	misc_command(0x0007, 0x06, 0x01)
	misc_command(0x0008, 0x06, 0x01)
	misc_command(0x0009, 0x06, 0x01)
	misc_command(0x000a, 0x06, 0x01)
	misc_command(0x000b, 0x06, 0x01)
	misc_command(0x000c, 0x06, 0x01)
	misc_command(0x000d, 0x06, 0x01)
	misc_command(0x000e, 0x06, 0x01)
	misc_command(0x000f, 0x06, 0x01)
	misc_command(0x0010, 0x06, 0x01)
	misc_command(0x0011, 0x06, 0x01)
	misc_command(0x0012, 0x06, 0x01)
	misc_command(0x0013, 0x06, 0x01)
	misc_command(0x0014, 0x06, 0x01)
	misc_command(0x003a, 0x05, 0x01)
	misc_command(0x00a2, 0x06, 0x01)
	misc_command(0x00a4, 0x06, 0x01)
	misc_command(0x00a5, 0x06, 0x01)
	misc_command(0x00a7, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_shuttle_animation[] = {
	yield
	show_object(OBJ_SHUTTLE1)
	set_object_flag3(OBJ_SHUTTLE1, OBJFLAG3_00000010)
	set_object_part_visible(OBJ_SHUTTLE1, FALSE)
	label(0x09)
	restart_timer

	// Some kind of animation on repeat
	beginloop(0x08)
		object_do_animation(0x0489, OBJ_SHUTTLE1, 0x08, 0xffff)
	endloop(0x08)

	// Unreachable
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1012_chief_lift[] = {
	yield

	// If A or SA, return
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0d)

	// Wait until chief dead
	beginloop(0x04)
		if_objective_complete(1, /*goto*/ 0x2c)
	endloop(0x04)

	// Wait 3 seconds
	label(0xc1)
	label(0x2c)
	restart_timer

	beginloop(0xb1)
		if_timer_gt(180, /*goto*/ 0x2c)
	endloop(0xb1)

	// Activate chief's lift
	label(0x2c)
	unset_object_flag(OBJ_CHIEF_LIFT, OBJFLAG_DEACTIVATED)

	// The goto first here means that the lift continues to be activated every
	// 3 seconds, but it is never deactivated so this is a no op.
	goto_first(0xc1)

	// A or SA - return
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_init_hovercar,          0x0401 },
	{ func0402_start_path26,           0x0402 },
	{ func0403_start_path27,           0x0403 },
	{ func0404_start_path28,           0x0404 },
	{ func0405_start_path29,           0x0405 },
	{ func0406_start_path30,           0x0406 },
	{ func0407_start_path31,           0x0407 },
	{ func0408_start_path32,           0x0408 },
	{ func0409_start_path33,           0x0409 },
	{ func040a_start_path34,           0x040a },
	{ func040b_start_path35,           0x040b },
	{ func040c_start_path36,           0x040c },
	{ func040d_start_path37,           0x040d },
	{ func040e_init_60hp_guard,        0x040e },
	{ func040f_init_40hp_guard,        0x040f },
	{ func0410_init_searching_guard,   0x0410 },
	{ func0411_cass_in_office,         0x0411 },
	{ func0412_init_cass,              0x0412 },
	{ func0413_cass_running,           0x0413 },
	{ func0414_init_chief,             0x0414 },
	{ func0415_chief,                  0x0415 },
	{ func0416_intro,                  0x0416 },
	{ func0417_outro,                  0x0417 },
	{ func1000_setup_counterop,        0x1000 },
	{ func1001_objectives_failed_msg,  0x1001 },
	{ func1002_lightswitch,            0x1002 },
	{ func0416_intro,                  0x1003 },
	{ func1004_check_cass_dead,        0x1004 },
	{ func1005_check_cass_captured,    0x1005 },
	{ func1006_lift_disabling,         0x1006 },
	{ func1007_bomb_logic,             0x1007 },
	{ func1008_check_bomb_unplantable, 0x1008 },
	{ func1009_toggle_top_guards,      0x1009 },
	{ func100a_check_for_completion,   0x100a },
	{ func100b_start_lifts,            0x100b },
	{ func100c_lift_doors,             0x100c },
	{ func100e_cass_speech,            0x100e },
	{ func100f_disable_chiefs_lift,    0x100f },
	{ func1010_init_lighting,          0x1010 },
	{ func1011_shuttle_animation,      0x1011 },
	{ func1012_chief_lift,             0x1012 },

	{ func0416_intro, 0x0c00 },
	{ func0417_outro, 0x0c01 },
	{ NULL, 0 },
};

