//
// Escape
//

#include "stagesetup.h"

// Characters
#define CHR_JONATHAN 0x21
#define CHR_ELVIS    0x22

// Objects
#define OBJ_HOVERBED       0x00 // with Elvis on it
#define OBJ_MEDPACK_BOND   0x01
#define OBJ_TERMINAL1      0x03
#define OBJ_TERMINAL2      0x04
#define OBJ_WALLMINE       0x02
#define OBJ_MEDPACK_SWITCH 0x14
#define OBJ_UFO1           0x1f
#define OBJ_UFO2           0x22
#define OBJ_MEDPACK_COOP   0x20
#define OBJ_WALLOBJECT     0x21
#define OBJ_MEDPACK_GLASS  0x2a
#define OBJ_HOVERBIKE      0x35
#define OBJ_WALLDOOR       0x38
#define OBJ_FALCON2SCOPE1  0x39
#define OBJ_FALCON2SCOPE2  0x3a
#define OBJ_REMOTEMINES    0x3b

// Stage flags
#define STAGEFLAG_INTRO_DONE                   0x00000001
#define STAGEFLAG_TRIGGER_MEDPACK_FINISH       0x00000002
#define STAGEFLAG_JON_SAID_MAINT_HATCH         0x00000004
#define STAGEFLAG_TRIGGER_JETBIKE_MESSAGE      0x00000008
#define STAGEFLAG_UFO_LEAVING                  0x00000010
#define STAGEFLAG_GAS_ON                       0x00000020
#define STAGEFLAG_JON_SHOT_WHILE_PLANTING      0x00000040
#define STAGEFLAG_MEDPACK_SWITCH_DESTROYED     0x00000080
#define STAGEFLAG_COLLECTED_MEDPACK            0x00000100
#define STAGEFLAG_00000200                     0x00000200 // never set
#define STAGEFLAG_MET_JON                      0x00000400
#define STAGEFLAG_ELVIS_REVIVED                0x00000800
#define STAGEFLAG_ELVIS_DEAD                   0x00001000
#define STAGEFLAG_ENTERED_HANGAR               0x00002000
#define STAGEFLAG_ESCAPED                      0x00004000
#define STAGEFLAG_ELVIS_STASHED                0x00008000
#define STAGEFLAG_JON_ENTERED_MINE_ROOM        0x00010000
#define STAGEFLAG_JON_PLANTING_EXPLOSIVES      0x00020000
#define STAGEFLAG_JON_FINISHED_EXPLOSIVES      0x00040000
#define STAGEFLAG_JON_DEAD                     0x00080000
#define STAGEFLAG_WALL_EXPLODED                0x00100000
#define STAGEFLAG_HANGAR_TERMINAL_DESTROYED    0x00200000
#define STAGEFLAG_INNER_DOOR_OPENING           0x00400000
#define STAGEFLAG_OUTER_DOOR_OPENING           0x00800000
#define STAGEFLAG_STARTED_OUTRO                0x01000000
#define STAGEFLAG_JON_WAITING_AT_UFO           0x02000000
#define STAGEFLAG_HANGAR_CONVERSATION_FINISHED 0x04000000
#define STAGEFLAG_HANGAR_X_MUSIC_STARTED       0x08000000
#define STAGEFLAG_JO_DOING_TERMINALS           0x10000000
#define STAGEFLAG_JO_ESCAPE_STARTED            0x20000000
#define STAGEFLAG_MEDPACK_STARTED              0x40000000
#define STAGEFLAG_BOTH_HANGAR_DOORS_OPEN       0x80000000

// AI Lists
#define AILIST_GAS_DAMAGE                   0x0401
#define AILIST_JONATHAN_WAITING_FOR_MEETUP  0x0402
#define AILIST_INIT_JONATHAN                0x0403
#define AILIST_JONATHAN_FOLLOWING_AND_MINE  0x0404
#define AILIST_JONATHAN_SHOT_WHILE_PLANTING 0x0405
#define AILIST_SPAWNGROUP1_GUARD            0x0407
#define AILIST_SPAWNGROUP2_GUARD            0x0408
#define AILIST_SPAWNGROUP3_GUARD            0x0409
#define AILIST_SPAWNGROUP4_GUARD            0x040a
#define AILIST_ELVIS_FOLLOW                 0x040b
#define AILIST_HIDDEN_GUARDTYPE1            0x040c
#define AILIST_HIDDEN_GUARDTYPE2            0x040d
#define AILIST_HIDDEN_BIOTECH               0x040e
#define AILIST_INIT_ELVIS                   0x0412
#define AILIST_JONATHAN_HANGAR              0x0413
#define AILIST_OUTRO                        0x0414
#define AILIST_UFO_EXIT                     0x0415
#define AILIST_SPAWN_DURING_FOLLOW          0x0416
#define AILIST_INIT_FOLLOWER_CLONE          0x0417
#define AILIST_FOLLOWER_CLONE               0x0418
#define AILIST_INIT_BIOTECH                 0x0419
#define AILIST_INIT_SUPERDRAGON_GUARD       0x041a
#define AILIST_JONATHAN_AFTER_TERMINALS     0x041b
#define AILIST_ELVIS_GO_TO_UFO              0x041c

// Other
#define SPAWNGROUP1 0x09
#define SPAWNGROUP2 0x0a
#define SPAWNGROUP3 0x0b
#define SPAWNGROUP4 0x0d

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x4801)
	briefing(1, 0x4800)
	briefing(2, 0x4802)
	briefing(3, 0x4803)

	beginobjective(0, L_TRA(9), (DIFFBIT_PA | DIFFBIT_PD)) // "Locate alien tech medpack"
		complete_flags(STAGEFLAG_COLLECTED_MEDPACK)
		fail_flags(STAGEFLAG_00000200)
		fail_flags(STAGEFLAG_MEDPACK_SWITCH_DESTROYED)
	endobjective

	beginobjective(1, L_TRA(10), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Rendezvous with CI spy"
		complete_flags(STAGEFLAG_MET_JON)
		fail_flags(STAGEFLAG_JON_DEAD)
	endobjective

	beginobjective(2, L_TRA(12), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Locate secret hangar"
		complete_flags(STAGEFLAG_ENTERED_HANGAR)
	endobjective

	beginobjective(3, L_TRA(11), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Revive Maian Bodyguard"
		complete_flags(STAGEFLAG_ELVIS_REVIVED)
	endobjective

	beginobjective(4, L_TRA(13), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Escape from Area 51"
		complete_flags(STAGEFLAG_ESCAPED)
		fail_flags(STAGEFLAG_HANGAR_TERMINAL_DESTROYED)
		fail_flags(STAGEFLAG_ELVIS_DEAD)
	endobjective

	chr(0x00000400, 0x23, 0x03be, BODY_BIOTECH, HEAD_DUNCAN2, GAILIST_IDLE, -1, -1, 1000, 100, 0x40004600, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	chr(0x00000400, 0x24, 0x012e, BODY_BIOTECH, HEAD_JAMIE, GAILIST_IDLE, -1, -1, 1000, 100, 0x4000c000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	chr(0x00000200, 0x00, 0x03e0, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x01, 0x03e1, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0001, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x02, 0x03e2, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x03df, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0003, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x03e3, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x03e4, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0005, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x06, 0x03e5, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x03e6, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4000000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0007, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x08, 0x03e7, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_INIT_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x09, 0x03e9, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SPAWN_DURING_FOLLOW, -1, -1, 1000, 100, 0xc4002000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0009, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x0a, 0x03ea, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SPAWN_DURING_FOLLOW, -1, -1, 1000, 100, 0xc4002000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x0b, 0x03eb, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SPAWN_DURING_FOLLOW, -1, -1, 1000, 100, 0xc4002000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x000b, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x0c, 0x03ec, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SPAWN_DURING_FOLLOW, -1, -1, 1000, 100, 0xc4002000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x03e6, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1000, 100, 0xe4010000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x000d, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0e, 0x03e5, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1000, 100, 0xe4010000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x0f, 0x03fa, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1000, 100, 0xe4010000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x000f, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x10, 0x03f1, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1, 8, 0xc4010000, 0x00000200, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x03f2, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1, 8, 0xc4010000, 0x00000200, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0011, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x12, 0x03f3, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1, 8, 0xc4010000, 0x00000200, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x13, 0x03f4, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1, 8, 0xc4010000, 0x00000200, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0013, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x14, 0x016a, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x03f7, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0015, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x03f8, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE1, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x21, 0x03f9, BODY_A51AIRMAN, HEAD_JONATHAN, AILIST_INIT_JONATHAN, -1, -1, 1000, 100, 0x0c000000, 0x80100000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0021, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x22, 0x010a, BODY_ELVIS1, HEAD_ELVIS, GAILIST_IDLE, -1, -1, 1000, 100, 0x84000000, 0x00000000, TEAM_ALLY, SQUADRON_03, -1, 0, 0x00000000)
	chr(0x00000000, 0x17, 0x0119, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0017, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x18, 0x0111, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x19, 0x010c, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0019, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1a, 0x00ed, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1b, 0x00e1, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001b, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1c, 0x00db, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x00b7, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001d, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1e, 0x00a8, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1f, 0x00a1, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001f, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x20, 0x00a0, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_HIDDEN_GUARDTYPE2, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x25, 0x013a, BODY_BIOTECH, HEAD_BIOTECH, AILIST_HIDDEN_BIOTECH, -1, -1, 1000, 100, 0xc4090000, 0x10000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0025, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x26, 0x013c, BODY_BIOTECH, HEAD_BIOTECH, AILIST_HIDDEN_BIOTECH, -1, -1, 1000, 100, 0xc4090000, 0x10000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x27, 0x013a, BODY_BIOTECH, HEAD_BIOTECH, AILIST_HIDDEN_BIOTECH, -1, -1, 1000, 100, 0xc4090000, 0x10000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0027, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x28, 0x0134, BODY_BIOTECH, HEAD_BIOTECH, AILIST_HIDDEN_BIOTECH, -1, -1, 1000, 100, 0xc4090000, 0x10000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x29, 0x0118, BODY_BIOTECH, HEAD_BIOTECH, AILIST_INIT_BIOTECH, -1, -1, 1000, 6, 0xc4090000, 0x10000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0029, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2a, 0x0115, BODY_BIOTECH, HEAD_BIOTECH, AILIST_INIT_BIOTECH, -1, -1, 1000, 6, 0xc4090000, 0x10000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2b, 0x03bc, BODY_AREA51GUARD, HEAD_BEAU1, AILIST_HIDDEN_BIOTECH, -1, -1, 1000, 100, 0xc4010000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	tag(0x00, 1)
	hover_prop(0x0100, MODEL_HOVERBED, 0x03bd, 0x05120101, 0x00304300, 0x00110003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x11, 1)
	hover_prop(0x0100, MODEL_A51TROLLEY, 0x0120, 0x05120101, 0x00304300, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	hover_prop(0x0100, MODEL_HOVERBED, 0x0122, 0x05120101, 0x00304300, 0x00100003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x35, 1)
	hoverbike(0x0100, MODEL_HOVBIKE, 0x03fb, 0x05120101, 0x00304300, 0x02000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x01010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	hover_prop(0x0100, MODEL_HOVERCRATE1, 0x011d, 0x31120101, 0x00304300, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x02010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x17, 2)
	tag(0x18, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027f, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027e, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x15, 2)
	tag(0x16, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027a, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027b, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0278, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0279, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0277, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0276, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x19, 2)
	tag(0x1a, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0274, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0275, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0273, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0272, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0270, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0271, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x026f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x026e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x026c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x026d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x026b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x026a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3c, 2)
	tag(0x3d, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0268, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0269, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1b, 2)
	tag(0x1c, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0266, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0267, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1d, 2)
	tag(0x1e, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0280, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0281, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02b7, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02b8, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02b9, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ba, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02bb, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02bc, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x06, 2)
	tag(0x07, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0283, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0282, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0284, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0285, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x028b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x028a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_GL, 0x0286, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00020004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x01f407d0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0287, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x33, 2)
	tag(0x34, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_GL, 0x0289, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00020004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x01f407d0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0288, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02a4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x32, 1)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02a5, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0c, 1)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02a6, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00001999, 0x00000004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0b, 1)
	door(0x0100, MODEL_A51_HORIZ_DOOR_SECRET, 0x028e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0a, 1)
	door(0x0100, MODEL_A51_HORIZ_DOOR_SECRET, 0x02c5, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000002, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x0292, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x0293, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x0294, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x0295, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0d, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02ae, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x0299, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x0298, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_GL, 0x02a8, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00020004, 0x00000040, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x01f407d0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02a7, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000040, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x029a, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x029b, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x31, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x029c, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x029d, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000000, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x30, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x029e, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x029f, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000000, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0e, 2)
	tag(0x0f, 2)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x02a1, 0x10000010, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x02a0, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x10, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0290, 0x10000000, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x05, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0291, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x08, 2)
	tag(0x09, 2)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02a2, 0x10000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000a666, 0x0000a666, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02a3, 0x10000000, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000a666, 0x0000a666, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02e5, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02e6, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02e7, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02e8, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02e9, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02ea, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02eb, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02ec, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02ed, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02ee, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02ef, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02f0, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f1, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02f2, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02f3, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f4, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02f5, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02f6, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f7, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x38, 4)
	tag(0x21, 4)
	link_paths(0x00000002, 0x0173013f, 0x00000000)
	link_scenery(1, 2, 3)
	door(0x0100, MODEL_A51_UNEXP2, 0x0424, 0x13520d00, 0x20304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_A51_UNEXP3, 0x0425, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_EXP2, 0x0423, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b3, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b4, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x02af, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x02b0, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0321, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0327, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0322, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0328, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02b2, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000080, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02b1, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02bd, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02be, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02bf, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c0, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02c1, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c2, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02c3, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c4, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x02, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x013f, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x03, 1)
	singlemonitor(0x0100, MODEL_SINISTERSTATION, 0x048e, 0x000005e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x04, 1)
	singlemonitor(0x0033, MODEL_SINISTERSTATION, 0x03fd, 0x000005e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	glass(0x0100, MODEL_MEDLABWIN1, 0x0436, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x0437, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x0438, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN1, 0x0439, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x043a, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x043b, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x1f, 1)
	stdobject(0x0100, MODEL_ELVIS_SAUCER, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x22, 1)
	stdobject(0x0100, MODEL_ELVIS_SAUCER, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0461, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0462, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0463, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0464, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0465, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0466, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0467, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0468, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0469, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046a, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046b, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046c, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046d, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046e, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046f, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0470, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0471, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0472, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0473, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0474, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0476, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0477, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0479, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047c, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047e, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047f, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0480, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0481, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0482, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0483, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0484, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0485, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0486, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0487, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0488, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0489, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0491, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0492, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0493, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0494, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0495, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0496, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0497, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0498, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0499, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049c, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049e, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049f, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a0, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a1, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a2, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a3, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a4, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a5, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a6, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a7, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a8, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a9, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04aa, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04ab, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04ac, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x031a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x23, 7)
	tag(0x24, 7)
	tag(0x25, 7)
	tag(0x26, 7)
	tag(0x27, 7)
	tag(0x28, 7)
	tag(0x29, 7)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x04b7, 0x000005e1, 0x00000000, 0x00800001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x04b8, 0x000005e1, 0x00000000, 0x00800001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x04b9, 0x000005e1, 0x00000000, 0x00800001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x04ba, 0x000005e1, 0x00000000, 0x00800001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x04bb, 0x000005e1, 0x00000000, 0x00800001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x04bc, 0x000005e1, 0x00000000, 0x00800001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x04be, 0x000005e1, 0x00000000, 0x00800001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2a, 1)
	glass(0x0100, MODEL_MEDLABWIN2, 0x043c, 0x04000b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x12, 2)
	tag(0x13, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_GL, 0x0264, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00020004, 0x00000040, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x01f407d0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0265, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000040, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x14, 1)
	stdobject(0x0100, MODEL_A51DESKENT, 0x048a, 0x000005e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x048b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x048c, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_CONTAINER, 0x048d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 1)
	weapon(0x0100, MODEL_CHRBRIEFCASE, 0x037f, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AUTOSURGEON, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x3a, L_TRA(20), L_TRA(21), L_TRA(22), L_TRA(23), L_TRA(24), 0x0000, 0x0000) // "Obtain alien medpack."
	tag(0x20, 1)
	weapon(0x0100, MODEL_CHRBRIEFCASE, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AUTOSURGEON, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x3a, L_TRA(20), L_TRA(21), L_TRA(22), L_TRA(23), L_TRA(24), 0x0000, 0x0000) // "Obtain alien medpack."
	stdobject(0x0100, MODEL_A51TABLE, 0x04d0, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x04d1, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x04d2, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x04d3, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04d8, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04d9, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04da, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04db, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04dc, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04dd, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04de, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04df, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e0, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e1, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2b, 1)
	stdobject(0x0100, MODEL_A51TABLE, 0x0129, 0x000004e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2c, 2)
	tag(0x2d, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02dc, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x0000028f, 0x00000004, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02dd, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x0000028f, 0x00000004, 0x00000000, 0x9ffffff6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2e, 2)
	tag(0x2f, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02de, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x0000028f, 0x00000004, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02df, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x0000028f, 0x00000004, 0x00000000, 0x9ffffff6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x46, 2)
	tag(0x3e, 2)
	lift(0x0100, MODEL_CHAMBER, 0x033c, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x033c, 0x033d, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045c, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x48, 2)
	tag(0x40, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0340, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0340, 0x0341, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0459, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x4a, 2)
	tag(0x42, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0344, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0344, 0x0345, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045a, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x4c, 2)
	tag(0x44, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0348, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0348, 0x0349, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045b, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x47, 2)
	tag(0x3f, 2)
	lift(0x0100, MODEL_CHAMBER, 0x033f, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x033f, 0x033e, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045e, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x49, 2)
	tag(0x41, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0343, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0343, 0x0342, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045f, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x4b, 2)
	tag(0x43, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0347, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0347, 0x0346, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0460, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x4d, 2)
	tag(0x45, 2)
	lift(0x0100, MODEL_CHAMBER, 0x034b, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x034b, 0x034a, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045d, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	stdobject(0x0100, MODEL_A51_EXP1, 0x0421, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51GRATE, 0x0443, 0x000215e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51GRATE, 0x0444, 0x000215e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4e, 1)
	lift(0x0100, MODEL_A51_LIFT_THINWALL, 0x0336, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0336, 0x0337, 0xffffffff, 0x00000001, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x20000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51LIFTDOOR, 0x02e4, 0x04000400, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000888, 0x00000888, 0x00000147, 0x00080000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51LIFTDOOR, 0x02e3, 0x04000400, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000888, 0x00000888, 0x00000147, 0x00080000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 1)
	stdobject(0x0100, MODEL_A51GRATE, 0x0449, 0x000215e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4f, 4)
	tag(0x50, 4)
	tag(0x51, 4)
	tag(0x52, 4)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02aa, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ab, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02ac, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ad, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x53, 2)
	tag(0x54, 2)
	door(0x0100, MODEL_A51GATE_L, 0x02b5, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000ccc, 0x00014000, 0x00000111, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51GATE_R, 0x02b6, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000ccc, 0x00014000, 0x00000111, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x36, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0028, 0x00004001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x37, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x037f, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x39, 2)
	tag(0x3a, 2)
	weapon(0x0100, MODEL_CHRFALCON2SCOPE, 0x0023, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SCOPE, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRFALCON2SCOPE, 0x0024, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SCOPE, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	tag(0x3b, 1)
	weapon(0x0100, MODEL_MULTI_AMMO_CRATE, 0x0567, 0x00120001, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	pad_effect(0x00000001, 0x00000129)
	endprops
};

s32 intro[] = {
	spawn(0x012f)
	intro_weapon(WEAPON_FALCON2_SCOPE, -1)
	ammo(AMMOTYPE_PISTOL, 100)
	ammo(AMMOTYPE_REMOTE_MINE, 2)
	outfit(OUTFIT_LAB)
	endintro
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1022_gas_damage_bond[] = {
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_GAS_DAMAGE)
	endlist
};

u8 func1023_gas_damage_coop[] = {
	set_target_chr(CHR_COOP)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x32)
	set_ailist(CHR_SELF, AILIST_GAS_DAMAGE)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0401_gas_damage[] = {
	beginloop(0x12)
		if_stage_flag_eq(STAGEFLAG_INTRO_DONE, TRUE, /*goto*/ 0x32)
	endloop(0x12)

	label(0x32)
	restart_timer

	beginloop(0x04)
		if_chr_in_room(CHR_TARGET, 0x00, 0x009a, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0099, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x008f, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0090, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0092, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0093, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0094, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0095, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0096, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0097, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0098, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0099, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x009a, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		restart_timer

		// @bug: Only Jo gets motion blur?
		label(0x08)
		yield
		call_rng
		if_rand_gt(50, /*goto*/ 0x32)
		add_motion_blur(CHR_BOND, 7, TRUE)
		label(0x32)
		if_timer_lt(460, /*goto*/ 0x32)
		restart_timer
		damage_chr2(CHR_TARGET, 514)
		label(0x32)
		if_chr_in_room(CHR_TARGET, 0x00, 0x009a, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0099, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x008f, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0090, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0092, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0093, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0094, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0095, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0096, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0097, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0098, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0099, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x009a, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	goto_first(0x08)

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_jon_msgs_gravedanger[] = {
	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_INTRO_DONE, TRUE, /*goto*/ 0x32)
	endloop(0x0d)

	label(0x32)
	restart_timer

	beginloop(0x04)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(14), 0x814f, CHANNEL_4, COLOR_03_RED) // "Joanna - this is Jonathan. You're in grave danger."

	beginloop(0x08)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(15), 0x8150, CHANNEL_4, COLOR_03_RED) // "They've flooded the area with nerve gas."

	beginloop(0x09)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(16), 0x8151, CHANNEL_4, COLOR_03_RED) // "Get our friend to the containment lab. There's a h..."

	beginloop(0x0a)
		if_timer_gt(270, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(17), 0x8152, CHANNEL_4, COLOR_03_RED) // "I'll contact you when you get there - good luck!"

	beginloop(0x0c)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_jon_msgs_meetup[] = {
	beginloop(0x04)
		if_object_in_room(OBJ_HOVERBED, 0x00df, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_ELVIS_STASHED)
	mute_channel(CHANNEL_0)
	unset_object_flag2(0x0d, OBJFLAG2_LOCKEDFRONT)
	set_object_flag2(0x0d, OBJFLAG2_LOCKEDBACK)
	unlock_door(0x0d, 0x20)
	release_grabbed_object(CHR_BOND)
	yield
	unset_object_flag3(OBJ_HOVERBED, OBJFLAG3_GRABBABLE)
	unset_object_flag3(OBJ_HOVERBED, OBJFLAG3_PUSHABLE)
	restart_timer
	speak(CHR_BOND, L_TRA(18), 0x8153, CHANNEL_4, COLOR_03_RED) // "Good work, Jo. We need to meet up. They're getting..."

	beginloop(0x08)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(19), 0x8154, CHANNEL_4, COLOR_03_RED) // "Use the maintenance hatch I've opened in one of th..."

	beginloop(0x09)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	set_stage_flag(STAGEFLAG_JON_SAID_MAINT_HATCH)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_check_medpack_collected[] = {
	beginloop(0x04)
		if_chr_has_object(CHR_BOND, OBJ_MEDPACK_BOND, /*goto*/ 0x06)
		if_chr_has_object(CHR_COOP, OBJ_MEDPACK_BOND, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_COLLECTED_MEDPACK)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0403_init_jonathan[] = {
	set_self_chrflag(CHRCFLAG_01000000)
	set_self_chrflag(CHRCFLAG_NOAUTOAIM)
	if_difficulty_gt(DIFF_A, /*goto*/ 0x32)

	// Agent only
	beginloop(0x0d)
		chr_move_to_pad(CHR_JONATHAN, 0x0398, 0x00, /*goto*/ 0x32)
	endloop(0x0d)

	// All difficulties
	label(0x32)
	add_health_or_armor(1200)
	set_alertness(150)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_JONATHAN_WAITING_FOR_MEETUP)
	endlist
};

u8 func0402_jonathan_waiting_for_meetup[] = {
	set_shotlist(AILIST_JONATHAN_WAITING_FOR_MEETUP)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x32)
	if_chr_dying(CHR_SELF, /*goto*/ 0x32)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x32)
	goto_next(0x67)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x67)
	set_self_flag_bankx(CHRFLAG0_10000000, BANK_0)
	set_self_chrflag(CHRCFLAG_00080000)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	lock_door(0x0d, 0x20)
	lock_door(0x33, 0x20)
	lock_door(0x34, 0x20)
	speak(CHR_P1P2, L_TRA(25), 0x12b3, CHANNEL_4, COLOR_03_RED) // "Joanna - over here."
	label(0x08)
	restart_timer
	do_preset_animation(3)

	beginloop(0x09)
		if_player_looking_at_something_maybe(0x0a, 0x01, 0x00, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0a)

	beginloop(0x0a)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x32)
		reloop(0x0a)

		label(0x32)
		if_timer_lt(150, /*goto*/ 0x32)
		if_distance_to_target_lt(300, /*goto*/ 0x06)
		label(0x32)
	endloop(0x0a)

	label(0x06)
	speak(CHR_P1P2, L_TRA(26), 0x12b4, CHANNEL_4, COLOR_03_RED) // "We need to get back to our friend."
	set_stage_flag(STAGEFLAG_MET_JON)
	do_preset_animation(-1)
	restart_timer

	beginloop(0x0c)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	stop_chr
	set_ailist(CHR_SELF, AILIST_JONATHAN_FOLLOWING_AND_MINE)
	endlist
};

u8 func0404_jonathan_following_and_mine[] = {
#define LABEL_FOLLOW 0x5a

	set_chr_team(CHR_SELF, TEAM_ALLY)
	yield
	rebuild_teams
	rebuild_squadrons
	set_returnlist(CHR_SELF, AILIST_JONATHAN_FOLLOWING_AND_MINE)
	set_shotlist(AILIST_JONATHAN_FOLLOWING_AND_MINE)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x32)
	if_chr_dying(CHR_SELF, /*goto*/ 0x32)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x32)
	goto_next(0x06)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	if_stage_flag_eq(STAGEFLAG_JON_FINISHED_EXPLOSIVES, TRUE, /*goto*/ 0x32)
	if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x0d)
	label(0x32)
	goto_next(0x63)

	// Alive
	label(0x06)
	restart_timer

	beginloop(0x64)
		if_chr_stopped(/*goto*/ 0x63)
	endloop(0x64)

	label(0x63)
	if_stage_flag_eq(STAGEFLAG_JON_SHOT_WHILE_PLANTING, TRUE, /*goto*/ 0x0e)
	set_target_chr(CHR_P1P2)
	dprint 'J','O','N','A',' ','F','O','L','L','O','W','\n',0,

	label(LABEL_FOLLOW)
	if_distance_to_target_gt(200, /*goto*/ 0x5c)

	// distance <= 200 (waiting)
	stop_chr
	restart_timer

	beginloop(0x5b)
		label(0x32)
		if_chr_sees_player(/*goto*/ 0x06)
		goto_next(0x5c)

		label(0x06)
		if_distance_to_target_gt(200, /*goto*/ 0x5c)
	endloop(0x5b)

	// distance > 200
	label(0x5c)
	restart_timer
	if_distance_to_target_lt(300, /*goto*/ 0x32)

	// distance >= 300
	try_run_to_target(/*goto*/ 0x5d)

	// distance > 200 and distance < 300
	label(0x32)
	try_walk_to_target(/*goto*/ 0x5d)

	// Moving towards Jo
	label(0x5d)
		restart_timer
		yield

		label(0x06)
		if_enemy_distance_lt_and_los(1500, /*goto*/ 0x09)

		// distance >= 1500 and no line of sight
		// Note the timer check is pointless here because it is restarted in
		// each loop iteration.
		label(0x32)
		set_target_chr(CHR_P1P2)
		if_distance_to_target_lt(200, /*goto*/ 0x5e)
		if_timer_gt(120, /*goto*/ 0x5e)
		if_chr_stopped(/*goto*/ 0x5e)
	goto_first(0x5d)

	label(0x5e)
	if_stage_flag_eq(STAGEFLAG_WALL_EXPLODED, TRUE, /*goto*/ 0x32)
	if_stage_flag_eq(STAGEFLAG_JON_ENTERED_MINE_ROOM, TRUE, /*goto*/ 0x32)
	if_chr_in_room(CHR_JONATHAN, 0x00, 0x00dc, /*goto*/ 0x0a)
	if_chr_in_room(CHR_JONATHAN, 0x00, 0x00dd, /*goto*/ 0x0a)
	goto_first(LABEL_FOLLOW)

	// Unreachable
	if_chr_in_room(CHR_P1P2, 0x00, 0x00dc, /*goto*/ 0x0a)
	if_chr_in_room(CHR_P1P2, 0x00, 0x00dd, /*goto*/ 0x0a)

	label(0x32)
	goto_first(LABEL_FOLLOW)

	// Saw enemy
	label(0x09)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	// In mine room
	label(0x0a)
	unset_self_chrflag(CHRCFLAG_01000000)
	set_stage_flag(STAGEFLAG_JON_ENTERED_MINE_ROOM)
	speak(CHR_P1P2, L_TRA(27), 0x12b5, CHANNEL_4, COLOR_03_RED) // "Right, we're near. Cover me, Jo..."
	set_shotlist(AILIST_JONATHAN_SHOT_WHILE_PLANTING)
	label(0x0b)
	jog_to_pad(0x038b)

	beginloop(0x0c)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	play_x_music(CHANNEL_10, 30)
	restart_timer
	try_face_entity(ENTITYTYPE_PAD, 0x0173, /*goto*/ 0xc4)

	beginloop(0xc4)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0xc4)

	label(0x06)
	restart_timer
	set_stage_flag(STAGEFLAG_JON_PLANTING_EXPLOSIVES)

	label(0xc2)
	call_rng
	if_rand_lt(86, /*goto*/ 0x6a)
	if_rand_lt(172, /*goto*/ 0x6b)
	chr_do_animation(ANIM_OPERATE_0204, -1, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x0e)

	label(0x6a)
	chr_do_animation(ANIM_OPERATE_0205, -1, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x0e)

	label(0x6b)
	chr_do_animation(ANIM_OPERATE_0206, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	label(0x0e)
	set_shotlist(AILIST_JONATHAN_SHOT_WHILE_PLANTING)
	resume_timer
	unset_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)

	// Mine planting loop (33.3 seconds)
	beginloop(0x0d)
		if_timer_gt(2000, /*goto*/ 0x06)
		if_chr_idle(/*goto*/ 0x32)
		goto_first(0xc2)

		label(0x32)
	endloop(0x0d)

	label(0x06)
	set_shotlist(AILIST_JONATHAN_FOLLOWING_AND_MINE)
	set_stage_flag(STAGEFLAG_JON_FINISHED_EXPLOSIVES)
	unset_stage_flag(STAGEFLAG_JON_SHOT_WHILE_PLANTING)
	set_self_chrflag(CHRCFLAG_01000000)
	speak(CHR_P1P2, L_TRA(28), 0x12b6, CHANNEL_4, COLOR_03_RED) // "Okay - stand back."
	run_to_pad(0x0140)

	beginloop(0x0f)
		if_chr_stopped(/*goto*/ 0x12)
	endloop(0x0f)

	label(0x12)
	stop_chr

	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_WALL_EXPLODED, TRUE, /*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	unlock_door(0x0a, 0x02)
	speak(CHR_P1P2, L_TRA(32), 0x12b7, CHANNEL_4, COLOR_03_RED) // "Okay, Jo - let's go."
	restart_timer

	beginloop(0x11)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x11)

	label(0x06)
	goto_first(LABEL_FOLLOW)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0413_jonathan_hangar[] = {
	set_returnlist(CHR_SELF, AILIST_JONATHAN_HANGAR)
	set_shotlist(AILIST_JONATHAN_HANGAR)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x32)
	if_chr_dying(CHR_SELF, /*goto*/ 0x32)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x32)
	goto_next(0x06)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x32)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x63)

	// Injured
	label(0x06)
	restart_timer

	beginloop(0x64)
		if_chr_stopped(/*goto*/ 0x63)
	endloop(0x64)

	// Attack enemy (jumped to from further below)
	label(0x09)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	// Alive and well
	label(0x63)
	set_target_chr(CHR_P1P2)
	label(0x12)
	jog_to_pad(0x015f)

	beginloop(0x13)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x32)
		if_chr_distance_to_pad_lt(CHR_SELF, 3510, 0x001e, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x13)

	label(0x32)
	goto_first(0x09)

	// Waiting at pad
	label(0x06)
	set_stage_flag(STAGEFLAG_JON_WAITING_AT_UFO)
	stop_chr
	set_target_chr(CHR_P1P2)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x14)

	// Wait until both Joanna and Elvis within 400 units
	beginloop(0x14)
		set_target_chr(CHR_ELVIS)
		if_distance_to_target_gt(400, /*goto*/ 0x32)
		set_target_chr(CHR_P1P2)
		if_distance_to_target_gt(400, /*goto*/ 0x32)
		if_target_in_sight(/*goto*/ 0x06)
		label(0x32)
	endloop(0x14)

	// Start conversation
	label(0x06)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
	restart_timer
	chr_do_animation(0x0232, -1, 200, 0x02, 0x00, CHR_ELVIS, 2)
	speak(CHR_P1P2, L_TRA(59), 0x1a9a, CHANNEL_5, COLOR_06_WHITE) // "Oh, no! We have a problem. It's a single seater!"

	beginloop(0x7d)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		reloop(0x7d)

		label(0x32)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x7d)

	label(0x06)
	restart_timer
	chr_do_animation(0x0233, -1, 200, 0x02, 0x00, CHR_ELVIS, 2)
	speak(CHR_P1P2, L_TRA(60), 0x1a9b, CHANNEL_5, COLOR_06_WHITE) // "Two can get in but no more."

	beginloop(0x7e)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		reloop(0x7e)

		label(0x32)
		if_timer_gt(200, /*goto*/ 0x06)
	endloop(0x7e)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(41), 0x72a7, CHANNEL_5, COLOR_09_BLUE) // "It's the only way out of here."

	beginloop(0x15)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		reloop(0x15)

		label(0x32)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x15)

	label(0x06)
	restart_timer
	chr_do_animation(0x0232, -1, 200, 0x02, 0x00, CHR_ELVIS, 2)
	speak(CHR_P1P2, L_TRA(61), 0x1a9c, CHANNEL_5, COLOR_06_WHITE) // "Plus, it's got no style, you know what I'm saying?"

	beginloop(0x7f)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		reloop(0x7f)

		label(0x32)
		if_timer_gt(200, /*goto*/ 0x06)
	endloop(0x7f)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(42), 0x72a8, CHANNEL_5, COLOR_09_BLUE) // "You're the only one who can fly it, Elvis, so get ..."

	beginloop(0x17)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		endloop(0x17)

		label(0x32)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x17)

	label(0x06)
	restart_timer
	chr_do_animation(0x0231, -1, 200, 0x02, 0x00, CHR_JONATHAN, 2)
	speak(CHR_P1P2, L_TRA(45), 0x12b9, CHANNEL_5, COLOR_03_RED) // "One of us will have to stay behind and open the ha..."

	beginloop(0x1a)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		reloop(0x1a)

		label(0x32)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x1a)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(43), 0x72a9, CHANNEL_5, COLOR_09_BLUE) // "But we can't leave you behind."

	beginloop(0x18)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		reloop(0x18)

		label(0x32)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x18)

	label(0x06)
	restart_timer
	speak(CHR_BOND, L_TRA(44), 0x72aa, CHANNEL_5, COLOR_09_BLUE) // "There must be a way out of here."

	beginloop(0x19)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0xc3)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0xc3)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x32)
		reloop(0x19)

		label(0x32)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x19)

	label(0x06)
	restart_timer
	chr_do_animation(0x0232, -1, 200, 0x02, 0x00, CHR_JONATHAN, 2)
	speak(CHR_P1P2, L_TRA(46), 0x12ba, CHANNEL_5, COLOR_03_RED) // "I'll get out on that hoverbike. Cover me while I o..."

	beginloop(0x1b)
		if_timer_gt(120, /*goto*/ 0x66)
	reloop(0x1b)

	label(0x66)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x06)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x06)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x06)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_GO_TO_UFO)

	label(0x06)
	set_stage_flag(STAGEFLAG_HANGAR_CONVERSATION_FINISHED)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	restart_timer
	jog_to_pad(0x016f)

	// Once Jon starts jogging, 4 seconds will pass before he starts checking
	// other things. One of these is a Y check, where the X music will start
	// once he's a certain way up the ramp. The other is a distance to Jo check
	// where she'll take over.
	beginloop(0x1c)
		if_timer_lt(240, /*goto*/ 0x32)
		if_stage_flag_eq(STAGEFLAG_HANGAR_X_MUSIC_STARTED, TRUE, /*goto*/ 0x32)
		if_chr_y(CHR_SELF, -600, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		set_target_chr(CHR_P1P2)
		if_distance_to_target_lt(300, /*goto*/ 0x59)
		label(0x32)
		if_chr_stopped(/*goto*/ 0x06)
		reloop(0x1c)

		// Jon is up the ramp
		label(0x33)
		set_stage_flag(STAGEFLAG_HANGAR_X_MUSIC_STARTED)
		play_x_music(CHANNEL_10, 90)
		run_to_pad(0x016f)
		set_stage_flag(STAGEFLAG_HANGAR_X_MUSIC_STARTED)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x1c)

	// At first terminal
	label(0x06)
	chr_do_animation(ANIM_OPERATE_0204, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x1d)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x1d)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_HANGAR_TERMINAL_DESTROYED, TRUE, /*goto*/ 0x32)
	set_stage_flag(STAGEFLAG_INNER_DOOR_OPENING)
	open_door(0x2c)
	open_door(0x2d)
	set_object_flag(0x2c, OBJFLAG_40000000)
	set_object_flag(0x2d, OBJFLAG_40000000)
	show_hudmsg(CHR_P1P2, L_TRA(39)) // "Inner hangar door is opening."

	label(0x32)
	set_self_flag_bankx(CHRFLAG0_00004000, BANK_0)
	run_to_pad(0x0171)

	beginloop(0x1e)
		if_chr_distance_to_pad_lt(CHR_SELF, 3690, 0x0014, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x1e)

	// At second terminal
	label(0x06)
	chr_do_animation(ANIM_OPERATE_0204, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x1f)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x1f)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_HANGAR_TERMINAL_DESTROYED, TRUE, /*goto*/ 0x20)
	set_stage_flag(STAGEFLAG_OUTER_DOOR_OPENING)
	open_door(0x2e)
	open_door(0x2f)
	set_object_flag(0x2e, OBJFLAG_40000000)
	set_object_flag(0x2f, OBJFLAG_40000000)
	show_hudmsg(CHR_P1P2, L_TRA(37)) // "Outer hangar door is opening."

	beginloop(0x20)
		set_ailist(CHR_SELF, AILIST_JONATHAN_AFTER_TERMINALS)
	endloop(0x20)

	// Jo taking over
	label(0x59)
	speak(CHR_BOND, L_TRA(47), 0x72ac, CHANNEL_5, COLOR_09_BLUE) // "Jonathan, go with Elvis. I'll see to the consoles."
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x46)

	beginloop(0x46)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x46)

	label(0x06)
	restart_timer

	beginloop(0x4a)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x4a)

	label(0x06)
	set_stage_flag(STAGEFLAG_JO_DOING_TERMINALS)
	set_stage_flag(STAGEFLAG_HANGAR_X_MUSIC_STARTED)
	play_x_music(CHANNEL_10, 90)
	set_ailist(CHR_SELF, AILIST_JONATHAN_AFTER_TERMINALS)

	// Elvis dead
	label(0xc3)
	set_returnlist(CHR_SELF, AILIST_JONATHAN_AFTER_TERMINALS)
	set_ailist(CHR_SELF, AILIST_JONATHAN_AFTER_TERMINALS)
	endlist
};

u8 func041c_elvis_go_to_ufo[] = {
	set_returnlist(CHR_SELF, AILIST_ELVIS_GO_TO_UFO)
	set_shotlist(AILIST_ELVIS_GO_TO_UFO)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x32)
	if_chr_dying(CHR_SELF, /*goto*/ 0x32)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x32)
	goto_next(0x06)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	run_to_pad(0x03fe)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	stop_chr

	beginloop(0x6a)
	endloop(0x6a)

	endlist
};

u8 func041b_jonathan_after_terminals[] = {
	set_returnlist(CHR_SELF, AILIST_JONATHAN_AFTER_TERMINALS)
	set_shotlist(AILIST_JONATHAN_AFTER_TERMINALS)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x32)
	if_chr_dying(CHR_SELF, /*goto*/ 0x32)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x32)
	goto_next(0x06)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	run_to_pad(0x015f) // conversation corner

	beginloop(0x4b)
		if_chr_distance_to_pad_lt(CHR_SELF, 3510, 0x0014, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x4b)

	label(0x06)
	jog_to_pad(0x0168) // corner near ramp

	beginloop(0x4c)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x09)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x4c)

	label(0x06)
	stop_chr

	beginloop(0x4d)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x09)
	endloop(0x4d)

	label(0x09)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func0405_jonathan_shot_while_planting[] = {
	set_stage_flag(STAGEFLAG_JON_SHOT_WHILE_PLANTING)
	label(0x04)
	pause_timer
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x63)

	// Injured
	label(0x06)
	restart_timer

	beginloop(0x64)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)
		speak(CHR_P1P2, L_TRA(51), 0x8155, CHANNEL_5, COLOR_03_RED) // "Damn it, Joanna... cover me!"
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x63)
	endloop(0x64)

	// Not injured, or recovered
	label(0x63)
	label(0x0b)
	walk_to_pad(0x038b)

	beginloop(0x0c)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	try_face_entity(ENTITYTYPE_PAD, 0x0173, /*goto*/ 0xc4)

	beginloop(0xc4)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0xc4)

	label(0x06)
	set_shotlist(AILIST_JONATHAN_FOLLOWING_AND_MINE)
	set_ailist(CHR_SELF, AILIST_JONATHAN_FOLLOWING_AND_MINE)
	endlist
};

/**
 * @unused
 */
u8 func0406_unused_0406[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MET_JON, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_alertness(100)
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * Waits until the meetup with Jon is done and the player is in the hallway.
 * Spawns 15 guards total, maximum 4 alive at any time. Every 60 seconds, checks
 * to see whether it should spawn more. Stops once 15 have been spawned or Jon
 * has finished planting the explosives.
 */
u8 func1008_spawngroup1[] = {
	// Wait until meeting done and player in the T-junction corridor
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_MET_JON, TRUE, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x003f, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_morale(15)

	beginloop(0x5f)
		// Keep doing this until explosives finished, or 15 guards spawned
		if_stage_flag_eq(STAGEFLAG_JON_FINISHED_EXPLOSIVES, TRUE, /*goto*/ 0x06)
		if_morale_lt(1, /*goto*/ 0x06)
		try_spawn_chr_at_pad(BODY_AREA51GUARD, HEAD_RANDOM, 0x00c7, AILIST_SPAWNGROUP1_GUARD, 0x00000200, /*goto*/ 0x60)
		reloop(0x5f)

		// Spawned a guard
		label(0x60)
		yield
		if_stage_flag_eq(STAGEFLAG_JON_FINISHED_EXPLOSIVES, TRUE, /*goto*/ 0x06)
		subtract_morale(1)
		if_num_chrs_in_squadron_gt(3, SPAWNGROUP1, /*goto*/ 0x32)
		reloop(0x5f)

		label(0x32)
		restart_timer

		beginloop(0x08)
			if_timer_gt(3600, /*goto*/ 0x32)
		endloop(0x08)

		label(0x32)
	endloop(0x5f)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_spawngroup1_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(40)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	try_equip_weapon(MODEL_CHRSUPERDRAGON, WEAPON_SUPERDRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_AIVSAI, BANK_0)
	set_squadron(SPAWNGROUP1)
	run_to_pad(0x013e)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_CHOOSE_TARGET)
	endlist
};

/**
 * Spawns 12 guards while Jon is planing the explosives. Maximum 4 alive at any
 * time. No delay between them; once one dies another is immediately spawned.
 * Location is spawned guard is one of 2 places, 50% chance of each. Spawning
 * stops when wall explodes.
 */
u8 func1013_spawngroup2[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_JON_PLANTING_EXPLOSIVES, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_morale(12)

	beginloop(0x5f)
		if_morale_lt(1, /*goto*/ 0x06)
		call_rng
		if_rand_gt(128, /*goto*/ 0x32)
		try_spawn_chr_at_pad(BODY_AREA51GUARD, HEAD_RANDOM, 0x0144, AILIST_SPAWNGROUP2_GUARD, 0x00000200, /*goto*/ 0x60)
		goto_next(0x06)

		label(0x32)
		try_spawn_chr_at_pad(BODY_AREA51GUARD, HEAD_RANDOM, 0x0138, AILIST_SPAWNGROUP2_GUARD, 0x00000200, /*goto*/ 0x60)
		goto_next(0x06)

		label(0x60)
		yield
		if_stage_flag_eq(STAGEFLAG_WALL_EXPLODED, TRUE, /*goto*/ 0x06)
		subtract_morale(1)
		rebuild_teams
		rebuild_squadrons
		label(0x08)
		yield
		if_stage_flag_eq(STAGEFLAG_WALL_EXPLODED, TRUE, /*goto*/ 0x06)
		if_num_chrs_in_squadron_gt(4, SPAWNGROUP2, /*goto*/ 0x32)
		call_rng
		if_rand_gt(5, /*goto*/ 0x32)
	endloop(0x5f)

	label(0x32)
	goto_first(0x08)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_spawngroup2_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(40)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	try_equip_weapon(MODEL_CHRSUPERDRAGON, WEAPON_SUPERDRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_AIVSAI, BANK_0)
	set_squadron(SPAWNGROUP2)
	rebuild_teams
	rebuild_squadrons
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * SA/PA only. Waits until medpack is started, then spawns 4 guards.
 *
 * The intended behavior is to spawn them all pretty much immediately with a
 * random delay in between, then wait for them all to be dead, then complete the
 * medpack. But an error makes this not work as intended.
 *
 * The error is that if any spawn fails (eg. due to blocked pad) then the
 * function jumps straight to the end where it waits for the group to be dead.
 * The pad can be blocked if the guard hasn't moved off it fast enough, keeping
 * in mind that the next spawn occurs after a random amount of frames.
 */
u8 func1014_spawngroup3[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x32)
	goto_next(0x04)

	// Agent - do nothing
	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA nad PA
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MEDPACK_STARTED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_morale(4)

	beginloop(0x5f)
		if_morale_lt(1, /*goto*/ 0x06)
		call_rng
		if_rand_gt(128, /*goto*/ 0x32)

		// @bug: If either of these fail to spawn, the function jumps straight
		// to the end rather than attempting to respawn them.
		try_spawn_chr_at_pad(BODY_AREA51GUARD, HEAD_RANDOM, 0x0117, AILIST_SPAWNGROUP3_GUARD, 0x00000200, /*goto*/ 0x60)
		goto_next(0x06)

		label(0x32)
		try_spawn_chr_at_pad(BODY_AREA51GUARD, HEAD_RANDOM, 0x013e, AILIST_SPAWNGROUP3_GUARD, 0x00000200, /*goto*/ 0x60)
		goto_next(0x06)

		// Spawned a guard
		label(0x60)
		yield
		if_stage_flag_eq(STAGEFLAG_ELVIS_REVIVED, TRUE, /*goto*/ 0x06)
		subtract_morale(1)
		rebuild_teams
		rebuild_squadrons

		// Wait for Elvis to be revived, for someone to die, or 5 in 256 chance
		// of spawning another guard anyway.
		label(0x08)
		yield
		if_stage_flag_eq(STAGEFLAG_ELVIS_REVIVED, TRUE, /*goto*/ 0x06)
		if_num_chrs_in_squadron_gt(6, SPAWNGROUP3, /*goto*/ 0x32)
		call_rng
		if_rand_gt(5, /*goto*/ 0x32)
	endloop(0x5f)

	label(0x32)
	goto_first(0x08)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons

	beginloop(0x0d)
		if_all_chrs_in_squadron_are_dead(SPAWNGROUP3, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_MEDPACK_FINISH)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_spawngroup3_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(40)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	try_equip_weapon(MODEL_CHRSUPERDRAGON, WEAPON_SUPERDRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_AIVSAI, BANK_0)
	set_squadron(SPAWNGROUP3)
	rebuild_teams
	rebuild_squadrons
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * Start spawning guards when the hangar X music starts. Stop spawning when 12
 * reached, or when both hangar doors are open.
 */
u8 func1015_spawngroup4[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_HANGAR_X_MUSIC_STARTED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	label(0x06)
	set_morale(12)

	beginloop(0x5f)
		call_rng
		if_rand_gt(128, /*goto*/ 0x32)

		// @bug: This is spawning guards using the same function as the previous
		// spawn group. This causes the guards to set their group to spawngroup3
		// which causes the if_num_chrs_in_squadron_gt check further below to
		// never pass.
		try_spawn_chr_at_pad(BODY_AREA51GUARD, HEAD_RANDOM, 0x0140, AILIST_SPAWNGROUP3_GUARD, 0x00000200, /*goto*/ 0x60)
		goto_next(0x06)

		label(0x32)
		try_spawn_chr_at_pad(BODY_AREA51GUARD, HEAD_RANDOM, 0x0117, AILIST_SPAWNGROUP3_GUARD, 0x00000200, /*goto*/ 0x60)
		goto_next(0x06)

		label(0x60)
		yield
		if_stage_flag_eq(STAGEFLAG_BOTH_HANGAR_DOORS_OPEN, TRUE, /*goto*/ 0x06)
		subtract_morale(1)
		rebuild_teams
		rebuild_squadrons

		label(0x08)
		yield
		if_morale_lt(1, /*goto*/ 0x06)
		if_num_chrs_in_squadron_gt(6, SPAWNGROUP4, /*goto*/ 0x32)
		call_rng
		if_rand_gt(2, /*goto*/ 0x32)
	endloop(0x5f)

	label(0x32)
	goto_first(0x08)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func1015_spawngroup4_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(40)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	try_equip_weapon(MODEL_CHRSUPERDRAGON, WEAPON_SUPERDRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_AIVSAI, BANK_0)
	set_squadron(SPAWNGROUP4)
	rebuild_teams
	rebuild_squadrons
	run_to_pad(0x0168)
	set_ailist(CHR_SELF, GAILIST_CHOOSE_TARGET)
	endlist
};

u8 func1009_blow_up_wall[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_JON_FINISHED_EXPLOSIVES, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	restart_timer

	beginloop(0x08)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	unset_object_flag(OBJ_WALLMINE, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_WALLMINE, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_WALLOBJECT, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_WALLDOOR, OBJFLAG_INVINCIBLE)
	yield
	yield
	destroy_object(OBJ_WALLMINE)
	set_stage_flag(STAGEFLAG_WALL_EXPLODED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100a_check_hangar_accessed[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00e7, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_ENTERED_HANGAR)
	show_hudmsg(CHR_P1P2, L_TRA(31)) // "The secret hangar has been located."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_check_jonathan_dead[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x32)
	goto_next(0x04)

	// A and SA
	label(0x32)
	give_object_to_chr(OBJ_MEDPACK_BOND, CHR_BOND)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x32)
	give_object_to_chr(OBJ_MEDPACK_COOP, CHR_COOP)
	goto_next(0x04)

	label(0x32)
	hide_object(OBJ_MEDPACK_COOP)

	// All difficulties
	beginloop(0x04)
		if_chr_dying(CHR_JONATHAN, /*goto*/ 0x06)
		if_chr_death_animation_finished(CHR_JONATHAN, /*goto*/ 0x06)
		if_chr_unloaded(CHR_JONATHAN, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_STARTED_OUTRO, TRUE, /*goto*/ 0x32)
	show_hudmsg(CHR_BOND, L_TRA(29)) // "Jonathan has been killed."
	set_stage_flag(STAGEFLAG_JON_DEAD)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_medpack_activation[] = {
	beginloop(0x67)
		if_stage_flag_eq(STAGEFLAG_ENTERED_HANGAR, TRUE, /*goto*/ 0x04)
	endloop(0x67)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x0c)
		if_chr_activated_object(CHR_P1P2, OBJ_HOVERBED, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_AUTOSURGEON, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)
	set_stage_flag(STAGEFLAG_MEDPACK_STARTED)
	show_hudmsg(CHR_P1P2, L_TRA(33)) // "Alien medpack activated."
	assign_sound(0x814c, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_HOVERBED, TRUE)
	restart_timer

	beginloop(0x12)
		if_timer_gt(120, /*goto*/ 0x32)
	endloop(0x12)

	label(0x32)
	assign_sound(0x814d, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_HOVERBED, TRUE)
	restart_timer

	beginloop(0x08)
		if_timer_gt(2000, /*goto*/ 0x09)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MEDPACK_FINISH, TRUE, /*goto*/ 0x09)
	endloop(0x08)

	label(0x09)
	mute_channel(CHANNEL_7)
	assign_sound(0x814e, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, 0x00, TRUE)
	show_hudmsg(CHR_P1P2, L_TRA(35)) // "Alien medpack has been administered."
	yield

	beginloop(0x0c)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00df, /*goto*/ 0x32)
	endloop(0x0c)

	label(0x32)
	if_chr_death_animation_finished(CHR_JONATHAN, /*goto*/ 0x32)
	if_chr_dying(CHR_JONATHAN, /*goto*/ 0x32)
	if_chr_unloaded(CHR_JONATHAN, /*goto*/ 0x32)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x33)
	if_chr_dying(CHR_BOND, /*goto*/ 0x33)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x33)
	goto_next(0x06)

	// Joanna is dead
	label(0x33)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x32)
	if_chr_dying(CHR_COOP, /*goto*/ 0x32)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x32)
	goto_next(0x06)

	// Everyone is alive
	label(0x06)
	set_ailist(CHR_JONATHAN, GAILIST_IDLE)
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	set_ailist(CHR_SELF, 0x0411)

	// Jonathan is dead
	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_init_elvis[] = {
	dprint 'E','L','V','I','S',' ','W','O','K','E','\n',0,
	stop_chr
	set_self_chrflag(CHRCFLAG_01000000)
	set_stage_flag(STAGEFLAG_ELVIS_REVIVED)
	label(0x0a)
	label(0x06)
	add_health_or_armor(200)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040b_elvis_follow[] = {
	dprint 'E','L','V','I','S',' ','F','O','L','L','O','W','\n',0,
	set_target_chr(CHR_JONATHAN)

	label(0x5a)
		restart_timer

		beginloop(0x5b)
			if_chr_distance_to_pad_lt(CHR_SELF, 3510, 0x001e, /*goto*/ 0x08)
			if_chr_sees_player(/*goto*/ 0x06)
			goto_next(0x5c)

			label(0x06)
			if_distance_to_target_gt(200, /*goto*/ 0x5c)
		endloop(0x5b)

		label(0x5c)
		restart_timer
		try_run_to_target(/*goto*/ 0x5d)

		label(0x5d)
			restart_timer
			yield
			label(0x06)
			if_chr_distance_to_pad_lt(CHR_SELF, 300, 0x015f, /*goto*/ 0x08)
			label(0x32)
			set_target_chr(CHR_JONATHAN)
			if_distance_to_target_lt(200, /*goto*/ 0x5e)
			if_timer_gt(120, /*goto*/ 0x5e)
			if_chr_stopped(/*goto*/ 0x5e)
		goto_first(0x5d)

		label(0x5e)
	goto_first(0x5a)

	label(0x08)
	stop_chr

	beginloop(0x09)
	endloop(0x09)

	endlist
};

u8 func100f_terminals[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_TERMINAL1, /*goto*/ 0x08)
		if_chr_activated_object(CHR_P1P2, OBJ_TERMINAL2, /*goto*/ 0x0a)
		reloop(0x04)

		// Terminal 1
		label(0x08)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_TERMINAL1, TRUE)
		if_stage_flag_eq(STAGEFLAG_HANGAR_X_MUSIC_STARTED, TRUE, /*goto*/ 0x32)
		show_hudmsg(CHR_P1P2, L_TRA(80)) // "Console is not active."
		goto_next(0x0f)

		// Terminal 1 active
		label(0x32)
		if_stage_flag_eq(STAGEFLAG_INNER_DOOR_OPENING, TRUE, /*goto*/ 0x0f)
		show_hudmsg(CHR_P1P2, L_TRA(39)) // "Inner hangar door is opening."
		if_stage_flag_eq(STAGEFLAG_HANGAR_X_MUSIC_STARTED, FALSE, /*goto*/ 0x32)
		set_stage_flag(STAGEFLAG_INNER_DOOR_OPENING)
		label(0x32)
		open_door(0x2c)
		open_door(0x2d)
		set_object_flag(0x2c, OBJFLAG_40000000)
		set_object_flag(0x2d, OBJFLAG_40000000)
		reloop(0x04)

		// Terminal 2
		label(0x0a)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_TERMINAL2, TRUE)
		if_stage_flag_eq(STAGEFLAG_HANGAR_X_MUSIC_STARTED, TRUE, /*goto*/ 0x32)
		show_hudmsg(CHR_P1P2, L_TRA(80)) // "Console is not active."
		goto_next(0x0f)

		// Terminal 2 active
		label(0x32)
		if_stage_flag_eq(STAGEFLAG_OUTER_DOOR_OPENING, TRUE, /*goto*/ 0x0f)
		show_hudmsg(CHR_P1P2, L_TRA(37)) // "Outer hangar door is opening."
		if_stage_flag_eq(STAGEFLAG_HANGAR_X_MUSIC_STARTED, FALSE, /*goto*/ 0x32)
		set_stage_flag(STAGEFLAG_OUTER_DOOR_OPENING)
		label(0x32)
		open_door(0x2e)
		open_door(0x2f)
		set_object_flag(0x2e, OBJFLAG_40000000)
		set_object_flag(0x2f, OBJFLAG_40000000)
		reloop(0x04)

		// Wait 2 seconds
		label(0x0f)
		restart_timer

		beginloop(0x10)
			if_timer_gt(120, /*goto*/ 0x32)
		endloop(0x10)

		label(0x32)
	endloop(0x04)

	endlist
};

u8 func100d_check_terminals_destroyed[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_INNER_DOOR_OPENING, TRUE, /*goto*/ 0x06)
		if_object_in_good_condition(OBJ_TERMINAL1, /*goto*/ 0x06)
		if_door_state(0x2c, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x06)
		goto_next(0x08)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_OUTER_DOOR_OPENING, TRUE, /*goto*/ 0x06)
		if_object_in_good_condition(OBJ_TERMINAL2, /*goto*/ 0x06)
		if_door_state(0x2e, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x06)
		goto_first(0x08)

		label(0x06)
	endloop(0x04)

	label(0x08)
	show_hudmsg(CHR_BOND, L_TRA(36)) // "Mission critical object destroyed."
	set_stage_flag(STAGEFLAG_HANGAR_TERMINAL_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_check_elvis_dead[] = {
	beginloop(0x04)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x06)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x06)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_STARTED_OUTRO, TRUE, /*goto*/ 0x32)
	set_stage_flag(STAGEFLAG_ELVIS_DEAD)
	show_hudmsg(CHR_BOND, L_TRA(30)) // "Elvis has been killed."
	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_check_end_level[] = {
	beginloop(0x04)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x32)
		if_objective_complete(0, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		if_objective_complete(1, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x32)
		if_objective_complete(3, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		if_objective_complete(2, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		if_stage_flag_eq(STAGEFLAG_HANGAR_TERMINAL_DESTROYED, FALSE, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		if_stage_flag_eq(STAGEFLAG_INNER_DOOR_OPENING, TRUE, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		dprint '5','\n',0,
		if_stage_flag_eq(STAGEFLAG_OUTER_DOOR_OPENING, TRUE, /*goto*/ 0x32)
	reloop(0x04)

	label(0x32)
	dprint '6','\n',0,
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x0f)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x0f)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x0f)

	if_chr_death_animation_finished(CHR_JONATHAN, /*goto*/ 0x0f)
	if_chr_dying(CHR_JONATHAN, /*goto*/ 0x0f)
	if_chr_unloaded(CHR_JONATHAN, /*goto*/ 0x0f)

	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x32)
	if_chr_dying(CHR_BOND, /*goto*/ 0x32)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x32)
	goto_next(0x06)

	// Joanna is dead
	label(0x32)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x33)
	if_chr_dying(CHR_COOP, /*goto*/ 0x33)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x33)
	goto_next(0x06)

	// Both Joanna and Velvet are dead
	label(0x33)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x06)
	if_stage_flag_eq(STAGEFLAG_JO_DOING_TERMINALS, FALSE, /*goto*/ 0x32)
	set_ailist(CHR_SELF, AILIST_UFO_EXIT)

	label(0x32)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)

	// Jonathan and/or Elvis are dead
	label(0x0f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_unlock_doors_when_jo_escaping[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_JO_ESCAPE_STARTED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	unlock_door(0x06, 0x40)
	unlock_door(0x07, 0x40)
	unlock_door(0x08, 0x04)
	unlock_door(0x09, 0x04)
	unlock_door(0x1d, 0x40)
	unlock_door(0x1e, 0x40)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1012_hoverbike_auto_doors[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_JO_ESCAPE_STARTED, TRUE, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_chr_distance_to_pad_lt(CHR_P1P2, 500, 0x0176, /*goto*/ 0x08)
		if_chr_distance_to_pad_lt(CHR_P1P2, 500, 0x0158, /*goto*/ 0x09)
		if_chr_distance_to_pad_lt(CHR_P1P2, 500, 0x00db, /*goto*/ 0x0a)
		if_chr_distance_to_pad_lt(CHR_P1P2, 500, 0x00a1, /*goto*/ 0x0c)
		if_chr_distance_to_pad_lt(CHR_P1P2, 500, 0x009e, /*goto*/ 0x0d)
		reloop(0x04)

		// Pad/door 1
		label(0x08)
		if_door_state(0x0a, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		set_object_flag(0x0a, OBJFLAG_40000000)
		open_door(0x0a)
		reloop(0x04)

		// Pad/door 2
		label(0x09)
		if_door_state(0x0b, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		set_object_flag(0x0b, OBJFLAG_40000000)
		open_door(0x0b)
		reloop(0x04)

		// Pad/door 3
		label(0x0a)
		if_door_state(0x08, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		set_object_flag(0x08, OBJFLAG_40000000)
		set_object_flag(0x09, OBJFLAG_40000000)
		open_door(0x08)
		open_door(0x09)
		reloop(0x04)

		// Pad/door 4
		label(0x0c)
		if_door_state(0x0c, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		set_object_flag(0x0c, OBJFLAG_40000000)
		open_door(0x0c)
		reloop(0x04)

		// Pad/door 5
		label(0x0d)
		if_door_state(0x05, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		set_object_flag(0x05, OBJFLAG_40000000)
		open_door(0x05)
	endloop(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_hidden_guardtype1[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_enable_guards_after_meetup[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MET_JON, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	show_chr(0x0d)
	show_chr(0x0e)
	show_chr(0x0f)
	show_chr(0x10)
	show_chr(0x11)
	show_chr(0x12)
	show_chr(0x13)
	show_chr(0x14)
	show_chr(0x15)
	show_chr(0x16)
	unset_chr_chrflag(0x0d, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0d, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x0d, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x0e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x0e, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x0f, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0f, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x0f, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x10, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x10, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x10, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x11, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x11, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x11, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x12, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x12, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x12, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x13, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x13, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x13, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x14, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x14, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x14, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x15, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x15, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x15, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x16, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x16, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x16, AILIST_INIT_SUPERDRAGON_GUARD)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_check_both_hangar_doors_open[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_INNER_DOOR_OPENING, TRUE, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		if_stage_flag_eq(STAGEFLAG_OUTER_DOOR_OPENING, TRUE, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)
	show_hudmsg(CHR_BOND, L_TRA(53)) // "The hangar doors are now open."
	set_stage_flag(STAGEFLAG_BOTH_HANGAR_DOORS_OPEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_hidden_guardtype2[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_unhide_guards_when_jo_escaping[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_JO_ESCAPE_STARTED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	unset_chr_chrflag(0x16, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x16, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x16, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x17, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x17, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x17, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x18, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x18, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x18, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x19, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x19, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x19, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x1a, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1a, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x1a, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x1b, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1b, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x1b, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x1c, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1c, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x1c, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x1d, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1d, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x1d, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x1e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x1e, AILIST_INIT_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x1f, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1f, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x1f, AILIST_INIT_SUPERDRAGON_GUARD)
	unlock_door(0x0c, 0x40)
	unlock_door(0x15, 0x40)
	unlock_door(0x16, 0x40)
	unlock_door(0x17, 0x40)
	unlock_door(0x18, 0x40)
	unlock_door(0x19, 0x40)
	unlock_door(0x1a, 0x40)
	unlock_door(0x1b, 0x40)
	unlock_door(0x1c, 0x40)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040e_hidden_biotech[] = {
	label(0x04)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1019_enable_biotechs_after_stash[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ELVIS_STASHED, TRUE, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)
	unset_chr_chrflag(0x25, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x25, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x25, AILIST_INIT_BIOTECH)
	unset_chr_chrflag(0x26, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x26, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x26, AILIST_INIT_BIOTECH)
	unset_chr_chrflag(0x27, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x27, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x27, AILIST_INIT_BIOTECH)
	unset_chr_chrflag(0x28, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x28, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x28, AILIST_INIT_BIOTECH)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_ESCAPE_INTRO)
	camera_movement(0x019c)
	cmd0175(60)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x019d, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	set_chr_chrflag(0x23, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x23, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x23, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x23, CHRHFLAG_00020000)
	chr_do_animation(0x019e, -1, -1, 0x06, 0x00, 0x23, 4)

	set_chr_chrflag(0x24, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x24, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x24, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x24, CHRHFLAG_00020000)
	chr_do_animation(0x019f, -1, -1, 0x06, 0x00, 0x24, 4)

	set_object_flag2(0x00, OBJFLAG2_04000000)
	set_object_flag3(0x00, OBJFLAG3_00000010)
	object_do_animation(0x01a0, 0x00, 0x04, 0xffff)
	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SCOPE, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x68) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_until(2, 0xc5)
	speak(CHR_BOND, L_TRA(81), 0x81ba, CHANNEL_7, COLOR_02_WHITE) // "What the hell do you think you're doing? This is s..."

	wait_until(60, 0x6a)
	play_sound(0x0161, CHANNEL_6)

	wait_until(115, 0x6b)
	play_sound(0x0162, CHANNEL_6)

	wait_until(156, 0x6c)
	play_sound(0x0163, CHANNEL_5)

	wait_until(205, 0x6d)
	play_sound(0x0164, CHANNEL_6)

	wait_until(260, 0x6e)
	play_sound(0x0161, CHANNEL_5)

	wait_until(341, 0x6f)
	play_sound(0x0162, CHANNEL_6)
	open_door(0x0e)
	open_door(0x0f)

	wait_until(444, 0x70)
	play_sound(0x0163, CHANNEL_5)

	wait_until(468, 0x71)
	play_sound(0x0161, CHANNEL_6)

	wait_until(490, 0x72)
	play_sound(0x0164, CHANNEL_5)

	wait_until(528, 0x73)
	play_sound(0x0161, CHANNEL_6)

	wait_until(545, 0x8a)
	speak(CHR_BOND, L_TRA(84), 0x7758, CHANNEL_7, COLOR_09_BLUE) // "I don't care much for procedures!"

	wait_until(588, 0x74)
	play_sound(0x0162, CHANNEL_5)

	wait_until(632, 0x75)
	play_sound(0x0163, CHANNEL_6)

	wait_until(698, 0x76)
	play_sound(0x0164, CHANNEL_6)

	wait_until(706, 0x77)

	wait_until(770, 0xc6)
	speak(CHR_BOND, L_TRA(82), 0x7436, CHANNEL_7, COLOR_02_WHITE) // "Director Easton will hear about this, young lady."

	wait_until(810, 0xbe)
	close_door(0x0e)
	close_door(0x0f)

	wait_until(830, 0x78)
	play_sound(0x0161, CHANNEL_6)

	wait_until(872, 0x79)
	play_sound(0x0162, CHANNEL_4)

	wait_until(998, 0xc7)
	speak(CHR_BOND, L_TRA(83), 0x7437, CHANNEL_7, COLOR_02_WHITE) // "You can't take that! It's government property! Thi..."

	wait_until(1032, 0x7b)
	play_sound(0x0161, CHANNEL_5)

	wait_until(1224, 0x7c)
	play_sound(0x0164, CHANNEL_6)

	wait_until(1260, 0x7d)
	play_sound(0x0163, CHANNEL_4)

	wait_until(1286, 0x7e)
	play_sound(0x0161, CHANNEL_6)

	wait_until(1325, 0x7f)
	play_sound(0x01b9, CHANNEL_6)

	wait_until(1334, 0x80)
	play_sound(0x00fb, CHANNEL_10)

	wait_until(1342, 0x81)
	play_sound(0x00fb, CHANNEL_10)

	wait_until(1353, 0x82)
	play_sound(0x00f9, CHANNEL_10)

	wait_until(1362, 0x83)

	wait_until(1372, 0x84)
	play_sound(0x00fa, CHANNEL_10)

	wait_until(1388, 0x85)
	play_sound(0x01ba, CHANNEL_5)

	wait_until(1396, 0x86)
	play_sound(0x00fc, CHANNEL_10)

	wait_until(1432, 0xbf)
	open_door(0x10)

	wait_until(1510, 0x8f)
	play_sound(0x0162, CHANNEL_4)

	wait_until(1544, 0x90)
	play_sound(0x0163, CHANNEL_6)

	wait_until(1590, 0x91)
	play_sound(0x0164, CHANNEL_4)

	wait_until(1624, 0x92)
	play_sound(0x0161, CHANNEL_6)

	wait_until(1662, 0x93)
	play_sound(0x0162, CHANNEL_4)

	wait_until(1716, 0x94)
	play_sound(0x01b9, CHANNEL_6)

	wait_until(1730, 0x95)
	play_sound(0x00fe, CHANNEL_10)
	play_sound(0x00fa, CHANNEL_10)

	wait_until(1736, 0x96)
	speak(CHR_BOND, L_TRA(63), 0x7438, CHANNEL_7, COLOR_02_WHITE) // "Let's see how that overconfident thief deals with ..."
	set_stage_flag(STAGEFLAG_GAS_ON)

	wait_until(1773, 0x9a)
	play_sound(0x01bb, CHANNEL_5)

	wait_until(1822, 0xc0)
	close_door(0x10)

	wait_until(1826, 0x9f)
	play_sound(0x00fd, CHANNEL_10)

	wait_until(1834, 0xa0)
	play_sound(0x00fd, CHANNEL_10)

	wait_until(1850, 0xa1)
	play_sound(0x00fa, CHANNEL_10)

	wait_until(1926, 0xa4)
	play_sound(0x0163, CHANNEL_5)

	wait_until(2146, 0xa5)
	play_sound(0x0164, CHANNEL_6)

	wait_until(2180, 0xa6)
	play_sound(0x0507, CHANNEL_5)

	wait_until(2202, 0xa7)
	play_sound(0x0161, CHANNEL_6)

	wait_until(2218, 0xa8)
	speak(CHR_BOND, L_TRA(64), 0x7439, CHANNEL_7, COLOR_09_BLUE) // "What's that noise? Can't be... Gas!"

	wait_until(2271, 0xa9)
	play_sound(0x0162, CHANNEL_6)

	wait_until(2300, 0xaa)
	play_sound(0x0163, CHANNEL_5)

	wait_until(2362, 0xab)
	play_sound(0x0164, CHANNEL_6)

	wait_until(2384, 0xac)
	play_sound(0x0162, CHANNEL_6)

	wait_until(2428, 0xad)
	play_sound(0x0164, CHANNEL_6)

	wait_until(2458, 0xae)
	play_sound(0x0161, CHANNEL_6)

	wait_until(2582, 0xaf)
	speak(CHR_BOND, L_TRA(65), 0x743a, CHANNEL_7, COLOR_02_WHITE) // "Noooo, that wasn't meant to happen!"

	wait_until(2725, 0xb1)
	play_sound(0x0429, CHANNEL_10)

	wait_until(2748, 0xb2)
	play_sound(0x0429, CHANNEL_10)

	wait_until(2768, 0x97)
	play_sound(0x0429, CHANNEL_10)

	wait_until(2810, 0x98)
	play_sound(0x0429, CHANNEL_10)
	play_sound(0x0429, CHANNEL_10)

	wait_until(2877, 0x99)
	play_sound(0x0429, CHANNEL_10)
	play_sound(0x0429, CHANNEL_10)

	wait_until(2904, 0xb3)
	play_sound(0x0429, CHANNEL_10)
	play_sound(0x0429, CHANNEL_10)

	wait_until(2924, 0xb5)
	play_sound(0x0429, CHANNEL_10)
	play_sound(0x0429, CHANNEL_10)

	wait_until(2930, 0xb4)
	play_sound(0x05af, CHANNEL_10)

	wait_until(3024, 0x89)
	play_sound(0x00fa, CHANNEL_10)
	play_sound(0x00f9, CHANNEL_10)

	wait_until(3060, 0xb0)
	play_sound(0x05b0, CHANNEL_10)

	wait_until(3178, 0xb6)
	play_sound(0x007d, CHANNEL_6)

	wait_until(3242, 0xb7)
	play_sound(0x01dc, CHANNEL_6)
	play_sound(0x00fc, CHANNEL_10)

	wait_until(3290, 0xb8)
	play_sound(0x01dc, CHANNEL_6)
	play_sound(0x00fd, CHANNEL_10)

	wait_until(3334, 0xb9)
	play_sound(0x00fa, CHANNEL_10)

	wait_until(3894, 0xba)
	speak(CHR_BOND, L_TRA(67), 0x743b, CHANNEL_7, COLOR_09_BLUE) // "You idiot! We'd better get out of here."

	wait_until(4146, 0xbb)
	play_sound(0x0162, CHANNEL_6)

	wait_until(4316, 0xbc)
	play_sound(0x0164, CHANNEL_6)

	wait_until(4336, 0xbd)
	play_sound(0x0163, CHANNEL_5)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x32)
		goto_next(0x68)

		label(0x32)
		if_controller_button_pressed(/*goto*/ 0x68)
		label(0x32)
	endloop(0x08)

	label(0x68)
	set_stage_flag(STAGEFLAG_INTRO_DONE)
	set_stage_flag(STAGEFLAG_GAS_ON)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_10)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x019d, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	unset_chr_chrflag(0x23, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(0x23, CHRHFLAG_00020000)
	chr_do_animation(0x019e, -2, -1, 0x06, 0x00, 0x23, 2)

	unset_chr_chrflag(0x24, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(0x24, CHRHFLAG_00020000)
	chr_do_animation(0x019f, -2, -1, 0x06, 0x00, 0x24, 2)

	unset_object_flag2(OBJ_HOVERBED, OBJFLAG2_04000000)
	set_object_flag3(OBJ_HOVERBED, OBJFLAG3_00000010)
	object_do_animation(0x01a0, OBJ_HOVERBED, 0x04, 0xfffe)

	drop_concealed_items(0x23)
	drop_concealed_items(0x24)
	restart_default_music
	reset_ambience
	enter_firstperson
	revoke_control(CHR_BOND, 0)
	yield
	grab_object(CHR_BOND, OBJ_HOVERBED)
	grant_control(CHR_BOND)
	yield
	kill(0x23)
	kill(0x24)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c01_midcutscene[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_ESCAPE_MIDCUTSCENE)
	camera_movement(0x01cb)
	cmd0175(60)
	hide_object(OBJ_HOVERBED)
	set_target_chr(CHR_BOND)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x33)
	if_chr_dying(CHR_BOND, /*goto*/ 0x33)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x33)
	goto_next(0x06)

	label(0x33)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x06)
	if_chr_dying(CHR_COOP, /*goto*/ 0x06)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x06)
	set_target_chr(CHR_COOP)

	label(0x06)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_JONATHAN, GAILIST_IDLE)

	set_chr_chrflag(CHR_TARGET, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TARGET, CHRHFLAG_00020000)
	chr_do_animation(0x01ce, -1, -1, 0x06, 0x00, CHR_TARGET, 4)

	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x01cc, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)

	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_JONATHAN, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_JONATHAN, CHRHFLAG_00020000)
	chr_do_animation(0x01cd, -1, -1, 0x06, 0x00, CHR_JONATHAN, 4)

	set_object_flag2(0x11, OBJFLAG2_04000000)
	set_object_flag3(0x11, OBJFLAG3_00000010)
	object_do_animation(0x01cf, 0x11, 0x04, 0xffff)

	show_nonessential_chrs(FALSE)
	if_object_in_room(OBJ_HOVERBIKE, 0x00df, /*goto*/ 0x06)
	goto_next(0x32)

	label(0x06)
	move_object_to_pad(OBJ_HOVERBIKE, 0x038a)
	label(0x32)
	restart_timer
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)

	wait_until(83, 0x6a)
	speak(CHR_TARGET, L_TRA(69), 0x743c, CHANNEL_7, COLOR_06_WHITE) // "***aahh...! aahaa...! aaaaahhh! aha. ahh.***"

	wait_until(116, 0x6b)
	play_sound(0x80c4, CHANNEL_6)

	wait_until(124, 0x6c)
	play_sound(0x80c5, CHANNEL_4)

	wait_until(142, 0x6d)
	play_sound(0x80c6, CHANNEL_6)

	wait_until(148, 0x6e)
	play_sound(0x80c7, CHANNEL_4)

	wait_until(172, 0x6f)
	play_sound(0x80c4, CHANNEL_6)

	wait_until(176, 0x70)
	play_sound(0x80c7, CHANNEL_4)

	wait_until(214, 0x71)
	play_sound(0x80c5, CHANNEL_6)

	wait_until(690, 0x72)
	speak(CHR_TARGET, L_TRA(70), 0x743d, CHANNEL_7, COLOR_06_WHITE) // "I'm alive. I thought I'd be chopped up like the ot..."

	wait_until(1392, 0x73)
	speak(CHR_TARGET, L_TRA(71), 0x743e, CHANNEL_7, COLOR_09_BLUE) // "You... You speak our language?"

	wait_until(1400, 0x74)
	play_sound(0x80c4, CHANNEL_6)

	wait_until(1554, 0x75)
	speak(CHR_TARGET, L_TRA(72), 0x743f, CHANNEL_7, COLOR_03_RED) // "Watch her... she's sharp."

	wait_until(1688, 0x76)
	speak(CHR_TARGET, L_TRA(73), 0x7440, CHANNEL_7, COLOR_06_WHITE) // "Earrggghh...eerggh..."

	wait_until(1962, 0x77)
	speak(CHR_TARGET, L_TRA(74), 0x7441, CHANNEL_7, COLOR_09_BLUE) // "What's wrong?"

	wait_until(1988, 0x78)
	play_sound(0x80c5, CHANNEL_6)

	wait_until(2014, 0x79)
	play_sound(0x80c4, CHANNEL_4)

	wait_until(2113, 0x7a)
	speak(CHR_TARGET, L_TRA(75), 0x7442, CHANNEL_7, COLOR_06_WHITE) // "I have a headache. And with a head this big, that'..."

	wait_until(2470, 0x7b)
	speak(CHR_TARGET, L_TRA(76), 0x7443, CHANNEL_7, COLOR_09_BLUE) // "Can you walk? We must leave before they get organi..."

	wait_until(2480, 0x7c)
	play_sound(0x80c5, CHANNEL_6)

	wait_until(2526, 0x7d)
	play_sound(0x80c6, CHANNEL_6)

	wait_until(2624, 0x7e)
	play_sound(0x80c4, CHANNEL_6)

	wait_until(2642, 0x7f)
	play_sound(0x80c6, CHANNEL_4)

	wait_until(2678, 0x80)
	play_sound(0x80c7, CHANNEL_6)

	wait_until(2712, 0x81)
	play_sound(0x80c4, CHANNEL_4)

	wait_until(2726, 0x82)
	play_sound(0x80c5, CHANNEL_6)

	wait_until(2728, 0x83)
	play_sound(0x80c7, CHANNEL_7)

	wait_until(2806, 0x84)
	play_sound(0x80c4, CHANNEL_6)

	wait_until(2824, 0x85)
	play_sound(0x80c5, CHANNEL_4)

	wait_until(2842, 0x86)
	speak(CHR_TARGET, L_TRA(77), 0x7444, CHANNEL_7, COLOR_06_WHITE) // "I think so. What's your name?"

	wait_until(3024, 0x87)
	speak(CHR_TARGET, L_TRA(78), 0x7445, CHANNEL_7, COLOR_09_BLUE) // "I'm Agent Dark. Or Joanna, if you prefer."

	wait_until(3270, 0x88)
	speak(CHR_TARGET, L_TRA(79), 0x7446, CHANNEL_7, COLOR_06_WHITE) // "Well, Joanna, I'm Protector One. But you can call ..."

	wait_until(3308, 0x89)
	play_sound(0x80c6, CHANNEL_6)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x32)
		goto_next(0x68)

		label(0x32)
		if_controller_button_pressed(/*goto*/ 0x68)
		label(0x32)
	endloop(0x08)

	label(0x68)
	set_stage_flag(STAGEFLAG_INTRO_DONE)
	mute_channel(CHANNEL_7)
	restart_default_music
	reset_ambience
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_TARGET, CHRHFLAG_00020000)
	chr_do_animation(0x01ce, -2, -1, 0x06, 0x00, CHR_TARGET, 2)

	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x01cc, -2, -1, 0x06, 0x00, CHR_ELVIS, 2)

	unset_chr_chrflag(CHR_JONATHAN, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_JONATHAN, CHRHFLAG_00020000)
	chr_do_animation(0x01cd, -2, -1, 0x06, 0x00, CHR_JONATHAN, 2)

	unset_object_flag2(0x11, OBJFLAG2_04000000)
	set_object_flag3(0x11, OBJFLAG3_00000010)
	object_do_animation(0x01cf, 0x11, 0x04, 0xfffe)

	unset_object_flag2(0x0a, OBJFLAG2_AICANNOTUSE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_JONATHAN, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_JONATHAN, AILIST_JONATHAN_HANGAR)
	set_ailist(CHR_ELVIS, AILIST_INIT_ELVIS)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x32)
	chr_move_to_pad(CHR_COOP, 0x0156, 0x01, /*goto*/ 0x32)
	label(0x32)
	show_nonessential_chrs(TRUE)
	set_ailist(CHR_SELF, GAILIST_END_CINEMA)
	endlist
};

u8 func101b_gas_sound[] = {
	beginloop(0x67)
		if_stage_flag_eq(STAGEFLAG_GAS_ON, TRUE, /*goto*/ 0x04)
	endloop(0x67)

	label(0x04)
	yield
	assign_sound(0x816a, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, 0x2b, 0x1f40, 0x0bb8)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c02_outro[] = {
	open_door(0x2c)
	open_door(0x2e)
	set_object_flag(0x2c, OBJFLAG_40000000)
	set_object_flag(0x2d, OBJFLAG_40000000)
	label(0x32)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_ESCAPE_OUTRO_LONG)
	camera_movement(0x02d2)
	label(0x32)
	hide_object(OBJ_UFO2)

	show_object(OBJ_UFO1)
	set_object_flag2(OBJ_UFO1, OBJFLAG2_04000000)
	set_object_flag3(OBJ_UFO1, OBJFLAG3_00000010)
	object_do_animation(0x02d3, OBJ_UFO1, 0x04, 0xffff)

	set_stage_flag(STAGEFLAG_STARTED_OUTRO)
	remove_chr(CHR_ELVIS)
	remove_chr(CHR_JONATHAN)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_HIDDEN)
	show_nonessential_chrs(FALSE)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x32)
		goto_next(0x68)

		label(0x32)
		if_controller_button_pressed(/*goto*/ 0x68)
		label(0x32)
	endloop(0x08)

	label(0x68)
	label(0x32)
	camera_movement(0x02d4)

	show_object(OBJ_UFO1)
	set_object_flag2(OBJ_UFO1, OBJFLAG2_04000000)
	set_object_flag3(OBJ_UFO1, OBJFLAG3_00000010)
	object_do_animation(0x02d5, OBJ_UFO1, 0x04, 0xffff)

	set_chr_chrflag(0x2b, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2b, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x2b, CHRHFLAG_00020000)
	chr_do_animation(0x0304, -1, -1, 0x06, 0x00, 0x2b, 4)

	open_door(0x2c)
	open_door(0x2e)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x32)
		goto_next(0x69)

		label(0x32)
		if_controller_button_pressed(/*goto*/ 0x69)
		label(0x32)
	endloop(0x09)

	label(0x69)
	label(0x06)
	hide_object(OBJ_UFO2)
	if_stage_flag_eq(STAGEFLAG_JO_DOING_TERMINALS, FALSE, /*goto*/ 0x32)
	restart_default_music
	reset_ambience

	label(0x32)
	goto_next(0x06)

	// Unreachable
	label(0x09)
	set_stage_flag(STAGEFLAG_UFO_LEAVING)
	set_ailist(CHR_SELF, GAILIST_END_CINEMA)

	label(0x06)
	set_stage_flag(STAGEFLAG_ESCAPED)
	yield
	yield
	set_invincible(CHR_BOND)
	revoke_control(CHR_BOND, 4)
	hide_countdown_timer
	stop_countdown_timer
	unset_savefile_flag(SAVEFILEFLAG_DEFENSE_JON)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Makes the UFO exit, when Jo is doing terminals and has to escape via
 * hoverbike.
 */
u8 func0415_ufo_exit[] = {
	misc_command(0x0000, 0x0e, 0x05)
	hide_object(OBJ_UFO2)
	show_object(OBJ_UFO1)
	set_object_flag2(OBJ_UFO1, OBJFLAG2_04000000)
	set_object_flag3(OBJ_UFO1, OBJFLAG3_00000010)
	object_do_animation(0x02d3, OBJ_UFO1, 0x04, 0xffff)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNEXPLODABLE)
	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_UNEXPLODABLE)
	set_stage_flag(STAGEFLAG_UFO_LEAVING)
	restart_timer

	beginloop(0x08)
		if_timer_gt(600, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	misc_command(0x0000, 0x0f, 0x00)
	reset_ambience
	hide_object(OBJ_UFO1)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1021_jo_escaping[] = {
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_UFO_LEAVING, TRUE, /*goto*/ 0x32)
	endloop(0x08)

	label(0x32)
	set_stage_flag(STAGEFLAG_JO_ESCAPE_STARTED)
	restart_timer

	beginloop(0x0f)
		if_timer_gt(180, /*goto*/ 0x32)
	endloop(0x0f)

	label(0x32)
	set_stage_flag(STAGEFLAG_TRIGGER_JETBIKE_MESSAGE)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0014, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	set_stage_flag(STAGEFLAG_ESCAPED)
	yield
	yield
	set_invincible(CHR_BOND)
	revoke_control(CHR_BOND, 4)
	hide_countdown_timer
	stop_countdown_timer
	label(0x62)
	set_savefile_flag(SAVEFILEFLAG_DEFENSE_JON)
	set_music_track(MUSIC_ESCAPE_OUTRO_LONG)
	camera_movement(0x02d4)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)

	show_object(OBJ_UFO1)
	set_object_flag2(OBJ_UFO1, OBJFLAG2_04000000)
	set_object_flag3(OBJ_UFO1, OBJFLAG3_00000010)
	object_do_animation(0x02d5, OBJ_UFO1, 0x04, 0xffff)

	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x0304, -1, -1, 0x06, 0x00, CHR_P1P2, 4)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x32)
		goto_next(0x69)

		label(0x32)
		if_controller_button_pressed(/*goto*/ 0x69)
		label(0x32)
	endloop(0x09)

	label(0x69)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	end_level
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This is most likely a hidden guard. Spawns clones after meeting Jon until he
 * enters the mine room.
 *
 * There are 4 of these guards, and each one will have one clone alive at a
 * time.
 */
u8 func0416_spawn_during_follow[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(40)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x04)
		if_chr_sees_player(/*goto*/ 0x32)
		if_stage_flag_eq(STAGEFLAG_MET_JON, TRUE, /*goto*/ 0x06)
		label(0x32)
		reloop(0x04)

		// Met Jon
		label(0x06)
		label(0x54)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x54)
		reloop(0x04)

		label(0x54)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_FOLLOWER_CLONE, 0x00000000, /*goto*/ 0x32)
		reloop(0x04)

		// Spawned
		label(0x32)
		restart_timer

		beginloop(0x08)
			if_stage_flag_eq(STAGEFLAG_JON_ENTERED_MINE_ROOM, TRUE, /*goto*/ 0x32)
			if_timer_gt(1800, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
	endloop(0x04)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0417_init_follower_clone[] = {
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	label(0x04)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x09, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_FOLLOWER_CLONE)
	endlist
};

u8 func0418_follower_clone[] = {
	call_rng
	if_rand_lt(128, /*goto*/ 0x32)
	set_target_chr(CHR_COOP)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x32)
	goto_next(0x06)

	label(0x32)
	set_target_chr(CHR_BOND)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func0419_init_biotech[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(20)
	set_reaction_speed(40)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_returnlist(CHR_SELF, GAILIST_SEARCH_FOR_PLAYER)
	set_ailist(CHR_SELF, GAILIST_SEARCH_FOR_PLAYER)
	endlist
};

u8 func041a_init_superdragon_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(40)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func101a_medpack_switch[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_object_in_good_condition(OBJ_MEDPACK_SWITCH, /*goto*/ 0x32)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)
		set_stage_flag(STAGEFLAG_MEDPACK_SWITCH_DESTROYED)
		show_hudmsg(CHR_BOND, L_TRA(36)) // "Mission critical object destroyed."
		label(0x06)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x32)
		if_chr_activated_object(CHR_P1P2, OBJ_MEDPACK_SWITCH, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_MEDPACK_SWITCH, TRUE)
	show_hudmsg(CHR_P1P2, L_TRA(54)) // "Medical containment doors unlocked."
	unlock_door(0x12, 0x40)
	unlock_door(0x13, 0x40)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Warps Jon to the catwalk outside the mine room.
 */
u8 unregistered_function1[] = {
	// Wait until met Jon
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MET_JON, TRUE, /*goto*/ 0x08)
	endloop(0x04)

	// Wait until player in mine room
	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00dc, /*goto*/ 0x32)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00dd, /*goto*/ 0x32)
	endloop(0x08)

	label(0x32)
	set_ailist(CHR_JONATHAN, 0x040f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func040f_warp_jon_to_catwalk[] = {
	set_target_chr(CHR_BOND)
	if_chr_sees_player(/*goto*/ 0x06)
	set_target_chr(CHR_COOP)
	if_chr_sees_player(/*goto*/ 0x06)
	stop_chr
	yield
	chr_move_to_pad(CHR_JONATHAN, 0x0152, 0x00, /*goto*/ 0x32)
	label(0x32)
	yield
	set_ailist(CHR_JONATHAN, AILIST_JONATHAN_FOLLOWING_AND_MINE)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_msg_medpackaroundhere[] = {
	beginloop(0x04)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00d2, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)

	beginloop(0x6a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x32)
	endloop(0x6a)

	label(0x32)
	speak(CHR_P1P2, L_TRA(55), 0x73c0, CHANNEL_6, COLOR_09_BLUE) // "The medpack's got to be somewhere around here."
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101e_msg_hookup[] = {
	restart_timer
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_JON_SAID_MAINT_HATCH, TRUE, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)

	beginloop(0x6a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x32)
	endloop(0x6a)

	label(0x32)
	speak(CHR_BOND, L_TRA(56), 0x73c1, CHANNEL_6, COLOR_09_BLUE) // "Time to hook up with Jonathan, before he gets into..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_msg_oil[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_JON_SAID_MAINT_HATCH, TRUE, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00dc, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)
	yield
	yield
	yield

	beginloop(0x6a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x32)
	endloop(0x6a)

	label(0x32)
	speak(CHR_P1P2, L_TRA(57), 0x73c2, CHANNEL_6, COLOR_09_BLUE) // "That smell... oil... I smelt that in the other han..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1020_msg_jetbike[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_JETBIKE_MESSAGE, TRUE, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)

	beginloop(0x6a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x32)
	endloop(0x6a)

	label(0x32)
	speak(CHR_BOND, L_TRA(58), 0x73c3, CHANNEL_6, COLOR_09_BLUE) // "The jetbike should get me out before they lock the..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1024_wall_immune_to_explosives[] = {
	set_object_flag(OBJ_WALLOBJECT, OBJFLAG_INVINCIBLE)
	set_object_flag(OBJ_WALLDOOR, OBJFLAG_INVINCIBLE)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_JON_FINISHED_EXPLOSIVES, TRUE, /*goto*/ 0x32)
	endloop(0x04)

	label(0x32)
	unset_object_flag(OBJ_WALLOBJECT, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_WALLDOOR, OBJFLAG_INVINCIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Wait until barrel destroyed then unset immune to explosives on the medpack
 * glass. This wouldn't have worked as intended, as destroying any one barrel
 * would cause the glass to become suscepitble to explosives.
 */
#define glass_explosives_thing(barrel) \
	beginloop(0x04) \
		if_object_in_good_condition(barrel, /*goto*/ 0x32) \
		unset_object_flag(OBJ_MEDPACK_GLASS, OBJFLAG_INVINCIBLE) \
		restart_timer \
 \
		beginloop(0x08) \
			if_timer_gt(60, /*goto*/ 0x06) \
		endloop(0x08) \
 \
		label(0x06) \
		set_object_flag(OBJ_MEDPACK_GLASS, OBJFLAG_INVINCIBLE) \
		set_ailist(CHR_SELF, GAILIST_IDLE) \
		label(0x32) \
	endloop(0x04) \
 \
	set_ailist(CHR_SELF, GAILIST_IDLE)



u8 unregistered_function2[] = {
	set_object_flag(OBJ_MEDPACK_GLASS, OBJFLAG_INVINCIBLE)
	glass_explosives_thing(0x23)
	endlist
};

u8 unregistered_function3[] = {
	glass_explosives_thing(0x24)
	endlist
};

u8 unregistered_function4[] = {
	glass_explosives_thing(0x25)
	endlist
};

u8 unregistered_function5[] = {
	glass_explosives_thing(0x26)
	endlist
};

u8 unregistered_function6[] = {
	glass_explosives_thing(0x27)
	endlist
};

u8 unregistered_function7[] = {
	glass_explosives_thing(0x28)
	endlist
};

u8 unregistered_function8[] = {
	glass_explosives_thing(0x29)
	endlist
};

u8 func1026_ufo_spinning[] = {
	show_object(OBJ_UFO2)
	set_object_flag2(OBJ_UFO2, OBJFLAG2_04000000)
	set_object_flag3(OBJ_UFO2, OBJFLAG3_00000010)

	label(0x03)
		object_do_animation(0x0459, OBJ_UFO2, 0x04, 0xffff)
		restart_timer

		beginloop(0x08)
			if_timer_gt(184, /*goto*/ 0x32)
		endloop(0x08)

		label(0x32)
	goto_first(0x03)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102e_keep_hangar_doors_open[] = {
	beginloop(0x67)
		if_stage_flag_eq(STAGEFLAG_HANGAR_TERMINAL_DESTROYED, TRUE, /*goto*/ 0x0f)
		if_stage_flag_eq(STAGEFLAG_HANGAR_X_MUSIC_STARTED, TRUE, /*goto*/ 0x04)
	endloop(0x67)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_HANGAR_TERMINAL_DESTROYED, TRUE, /*goto*/ 0x0f)
		if_door_state(0x2c, DOORSTATE_CLOSING, /*goto*/ 0x08)
		if_door_state(0x2e, DOORSTATE_CLOSING, /*goto*/ 0x09)
		reloop(0x04)

		// Door 1 closing
		label(0x08)
		if_stage_flag_eq(STAGEFLAG_INNER_DOOR_OPENING, TRUE, /*goto*/ 0x32)
		if_door_state(0x2c, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x09)
		reloop(0x04)

		label(0x32)
		open_door(0x2c)
		open_door(0x2d)
		set_object_flag(0x2c, OBJFLAG_40000000)
		set_object_flag(0x2d, OBJFLAG_40000000)
		reloop(0x04)

		// Door 2 closing
		label(0x09)
		if_stage_flag_eq(STAGEFLAG_OUTER_DOOR_OPENING, TRUE, /*goto*/ 0x32)
		reloop(0x04)

		label(0x32)
		open_door(0x2e)
		open_door(0x2f)
		set_object_flag(0x2e, OBJFLAG_40000000)
		set_object_flag(0x2f, OBJFLAG_40000000)
	endloop(0x04)

	// Terminal destroyed
	label(0x0f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102f_toggle_remotemines[] = {
	restart_timer
	beginloop(0x08)
		if_timer_gt(2400, /*goto*/ 0x32)
		if_stage_flag_eq(STAGEFLAG_ELVIS_STASHED, TRUE, /*goto*/ 0x06)
	endloop(0x08)

	label(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	unset_object_flag(OBJ_REMOTEMINES, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_REMOTEMINES, OBJFLAG2_INVISIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1030_setup_medpack_glass[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x32)
	unset_object_flag(OBJ_MEDPACK_GLASS, OBJFLAG_INVINCIBLE)
	destroy_object(OBJ_MEDPACK_GLASS)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA and PA
	label(0x32)
	unlock_door(0x3c, 0x40)
	unlock_door(0x3d, 0x40)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1031_disable_chambers[] = {
	set_object_flag(0x46, OBJFLAG_DEACTIVATED)
	set_object_flag(0x47, OBJFLAG_DEACTIVATED)
	set_object_flag(0x48, OBJFLAG_DEACTIVATED)
	set_object_flag(0x49, OBJFLAG_DEACTIVATED)
	set_object_flag(0x4a, OBJFLAG_DEACTIVATED)
	set_object_flag(0x4b, OBJFLAG_DEACTIVATED)
	set_object_flag(0x4c, OBJFLAG_DEACTIVATED)
	set_object_flag(0x4d, OBJFLAG_DEACTIVATED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1032_unlock_door_after_hangar[] = {
	// Wait for locate hangar objective complete
	beginloop(0x04)
		if_objective_complete(2, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	unlock_door(0x0a, 0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This is the lift near the wall you blow up in Rescue.
 */
u8 func1433_start_lift[] = {
	activate_lift(1, 0x4e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_FALCON2SCOPE1, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_FALCON2SCOPE2, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_REMOTEMINES, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1434_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x00)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x00)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x00d3, 0x06, 0x01)
	misc_command(0x00d4, 0x06, 0x01)
	misc_command(0x00d5, 0x06, 0x01)
	misc_command(0x00d6, 0x06, 0x01)
	misc_command(0x00d7, 0x06, 0x01)
	misc_command(0x00d8, 0x06, 0x01)
	misc_command(0x00d9, 0x06, 0x01)
	misc_command(0x00da, 0x06, 0x01)
	misc_command(0x00db, 0x06, 0x01)
	misc_command(0x0024, 0x05, 0x01)
	misc_command(0x0025, 0x05, 0x01)
	misc_command(0x0026, 0x05, 0x01)
	misc_command(0x0027, 0x05, 0x01)
	misc_command(0x0028, 0x05, 0x01)
	misc_command(0x0029, 0x05, 0x01)
	misc_command(0x002a, 0x05, 0x01)
	misc_command(0x002b, 0x05, 0x01)
	misc_command(0x002c, 0x05, 0x01)
	misc_command(0x002d, 0x05, 0x01)
	misc_command(0x002e, 0x05, 0x01)
	misc_command(0x002f, 0x05, 0x01)
	misc_command(0x0030, 0x05, 0x01)
	misc_command(0x0032, 0x05, 0x01)
	misc_command(0x0033, 0x05, 0x01)
	misc_command(0x0034, 0x05, 0x01)
	misc_command(0x0035, 0x05, 0x01)
	misc_command(0x0036, 0x05, 0x01)
	misc_command(0x0037, 0x05, 0x01)
	misc_command(0x0038, 0x05, 0x01)
	misc_command(0x0039, 0x05, 0x01)
	misc_command(0x003a, 0x05, 0x01)
	misc_command(0x003b, 0x05, 0x01)
	misc_command(0x003c, 0x05, 0x01)
	misc_command(0x003d, 0x05, 0x01)
	misc_command(0x003e, 0x05, 0x01)
	misc_command(0x003f, 0x05, 0x01)
	misc_command(0x005b, 0x05, 0x01)
	misc_command(0x005d, 0x05, 0x01)
	misc_command(0x0079, 0x05, 0x01)
	misc_command(0x007a, 0x05, 0x01)
	misc_command(0x007b, 0x05, 0x01)
	misc_command(0x007c, 0x05, 0x01)
	misc_command(0x007d, 0x05, 0x01)
	misc_command(0x007e, 0x05, 0x01)
	misc_command(0x007f, 0x05, 0x01)
	misc_command(0x0080, 0x05, 0x01)
	misc_command(0x0081, 0x05, 0x01)
	misc_command(0x0082, 0x05, 0x01)
	misc_command(0x008b, 0x05, 0x01)
	misc_command(0x008c, 0x05, 0x01)
	misc_command(0x008d, 0x05, 0x01)
	misc_command(0x008e, 0x05, 0x01)
	misc_command(0x008f, 0x05, 0x01)
	misc_command(0x0090, 0x05, 0x01)
	misc_command(0x0091, 0x05, 0x01)
	misc_command(0x0092, 0x05, 0x01)
	misc_command(0x0093, 0x05, 0x01)
	misc_command(0x0094, 0x05, 0x01)
	misc_command(0x0095, 0x05, 0x01)
	misc_command(0x0096, 0x05, 0x01)
	misc_command(0x0097, 0x05, 0x01)
	misc_command(0x0098, 0x05, 0x01)
	misc_command(0x0099, 0x05, 0x01)
	misc_command(0x009a, 0x05, 0x01)
	misc_command(0x009b, 0x05, 0x01)
	misc_command(0x00a5, 0x05, 0x01)
	misc_command(0x00a6, 0x05, 0x01)
	misc_command(0x00a7, 0x05, 0x01)
	misc_command(0x00a8, 0x05, 0x01)
	misc_command(0x00a9, 0x05, 0x01)
	misc_command(0x00aa, 0x05, 0x01)
	misc_command(0x00ab, 0x05, 0x01)
	misc_command(0x00ac, 0x05, 0x01)
	misc_command(0x00ad, 0x05, 0x01)
	misc_command(0x00ae, 0x05, 0x01)
	misc_command(0x00af, 0x05, 0x01)
	misc_command(0x00b0, 0x05, 0x01)
	misc_command(0x00b1, 0x05, 0x01)
	misc_command(0x00b2, 0x05, 0x01)
	misc_command(0x00b3, 0x05, 0x01)
	misc_command(0x00b4, 0x05, 0x01)
	misc_command(0x00b5, 0x05, 0x01)
	misc_command(0x00b6, 0x05, 0x01)
	misc_command(0x00b7, 0x05, 0x01)
	misc_command(0x00b8, 0x05, 0x01)
	misc_command(0x00b9, 0x05, 0x01)
	misc_command(0x00ba, 0x05, 0x01)
	misc_command(0x00bb, 0x05, 0x01)
	misc_command(0x00bc, 0x05, 0x01)
	misc_command(0x00be, 0x05, 0x01)
	misc_command(0x00bf, 0x05, 0x01)
	misc_command(0x00c0, 0x05, 0x01)
	misc_command(0x00c1, 0x05, 0x01)
	misc_command(0x00c2, 0x05, 0x01)
	misc_command(0x00c3, 0x05, 0x01)
	misc_command(0x00c4, 0x05, 0x01)
	misc_command(0x00c5, 0x05, 0x01)
	misc_command(0x00c6, 0x05, 0x01)
	misc_command(0x00c7, 0x05, 0x01)
	misc_command(0x00c8, 0x05, 0x01)
	misc_command(0x00c9, 0x05, 0x01)
	misc_command(0x00ca, 0x05, 0x01)
	misc_command(0x00cc, 0x05, 0x01)
	misc_command(0x00cd, 0x05, 0x01)
	misc_command(0x00ce, 0x05, 0x01)
	misc_command(0x00cf, 0x05, 0x01)
	misc_command(0x00d0, 0x05, 0x01)
	misc_command(0x00d1, 0x05, 0x01)
	misc_command(0x00d2, 0x05, 0x01)
	misc_command(0x00dc, 0x05, 0x01)
	misc_command(0x00dd, 0x05, 0x01)
	misc_command(0x00de, 0x05, 0x01)
	misc_command(0x00df, 0x05, 0x01)
	misc_command(0x00e0, 0x05, 0x01)
	misc_command(0x00e1, 0x05, 0x01)
	misc_command(0x00e2, 0x05, 0x01)
	misc_command(0x00e3, 0x05, 0x01)
	misc_command(0x00e4, 0x05, 0x01)
	misc_command(0x00e5, 0x05, 0x01)
	misc_command(0x00e6, 0x05, 0x01)
	misc_command(0x00f2, 0x05, 0x01)
	misc_command(0x00fa, 0x05, 0x01)
	misc_command(0x00fb, 0x05, 0x01)
	misc_command(0x00fc, 0x05, 0x01)
	misc_command(0x00fd, 0x05, 0x01)
	misc_command(0x00fe, 0x05, 0x01)
	misc_command(0x00ff, 0x05, 0x01)
	misc_command(0x0100, 0x05, 0x01)
	misc_command(0x0101, 0x05, 0x01)
	misc_command(0x0102, 0x05, 0x01)
	misc_command(0x0103, 0x05, 0x01)
	misc_command(0x0104, 0x05, 0x01)
	misc_command(0x0105, 0x05, 0x01)
	misc_command(0x0106, 0x05, 0x01)
	misc_command(0x0107, 0x05, 0x01)
	misc_command(0x0108, 0x05, 0x01)
	misc_command(0x0109, 0x05, 0x01)
	misc_command(0x010a, 0x05, 0x01)
	misc_command(0x010b, 0x05, 0x01)
	misc_command(0x010c, 0x05, 0x01)
	misc_command(0x010d, 0x05, 0x01)
	misc_command(0x010e, 0x05, 0x01)
	misc_command(0x00cb, 0x05, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func1400_setup_counterop,                0x1400 },
	{ func1001_objectives_failed_msg,          0x1001 },
	{ func1002_intro,                          0x1002 },
	{ func1004_jon_msgs_gravedanger,           0x1004 },
	{ func1005_jon_msgs_meetup,                0x1005 },
	{ func1007_check_medpack_collected,        0x1007 },
	{ func1008_spawngroup1,                    0x1008 },
	{ func1009_blow_up_wall,                   0x1009 },
	{ func100a_check_hangar_accessed,          0x100a },
	{ func100b_check_jonathan_dead,            0x100b },
	{ func100c_medpack_activation,             0x100c },
	{ func100d_check_terminals_destroyed,      0x100d },
	{ func100e_check_elvis_dead,               0x100e },
	{ func100f_terminals,                      0x100f },
	{ func1010_check_end_level,                0x1010 },
	{ func1011_unlock_doors_when_jo_escaping,  0x1011 },
	{ func1012_hoverbike_auto_doors,           0x1012 },
	{ func1013_spawngroup2,                    0x1013 },
	{ func1014_spawngroup3,                    0x1014 },
	{ func1015_spawngroup4,                    0x1015 },
	{ func1016_enable_guards_after_meetup,     0x1016 },
	{ func1017_check_both_hangar_doors_open,   0x1017 },
	{ func1018_unhide_guards_when_jo_escaping, 0x1018 },
	{ func1019_enable_biotechs_after_stash,    0x1019 },
	{ func101a_medpack_switch,                 0x101a },
	{ func101b_gas_sound,                      0x101b },
	{ func101c_setup_rtracker,                 0x101c },
	{ func101d_msg_medpackaroundhere,          0x101d },
	{ func101e_msg_hookup,                     0x101e },
	{ func101f_msg_oil,                        0x101f },
	{ func1020_msg_jetbike,                    0x1020 },
	{ func1021_jo_escaping,                    0x1021 },
	{ func1022_gas_damage_bond,                0x1022 },
	{ func1023_gas_damage_coop,                0x1023 },
	{ func1024_wall_immune_to_explosives,      0x1024 },
	{ func1026_ufo_spinning,                   0x1026 },
	{ func102e_keep_hangar_doors_open,         0x102e },
	{ func102f_toggle_remotemines,             0x102f },
	{ func1030_setup_medpack_glass,            0x1030 },
	{ func1031_disable_chambers,               0x1031 },
	{ func1032_unlock_door_after_hangar,       0x1032 },
	{ func1433_start_lift,                     0x1433 },
	{ func1434_setup_lighting,                 0x1434 },
	{ func1002_intro,                          0x0c00 },
	{ func0c01_midcutscene,                    0x0c01 },
	{ func0c02_outro,                          0x0c02 },
	{ func0401_gas_damage,                     0x0401 },
	{ func0402_jonathan_waiting_for_meetup,    0x0402 },
	{ func0403_init_jonathan,                  0x0403 },
	{ func0404_jonathan_following_and_mine,    0x0404 },
	{ func0405_jonathan_shot_while_planting,   0x0405 },
	{ func0406_unused_0406,                    0x0406 },
	{ func1008_spawngroup1_guard,              0x0407 },
	{ func1013_spawngroup2_guard,              0x0408 },
	{ func1014_spawngroup3_guard,              0x0409 },
	{ func1015_spawngroup4_guard,              0x040a },
	{ func040b_elvis_follow,                   0x040b },
	{ func040c_hidden_guardtype1,              0x040c },
	{ func0413_jonathan_hangar,                0x0413 },
	{ func040d_hidden_guardtype2,              0x040d },
	{ func040e_hidden_biotech,                 0x040e },
	{ func040f_warp_jon_to_catwalk,            0x040f },
	{ func1002_intro,                          0x0410 },
	{ func0c01_midcutscene,                    0x0411 },
	{ func0412_init_elvis,                     0x0412 },
	{ func0c02_outro,                          0x0414 },
	{ func0415_ufo_exit,                       0x0415 },
	{ func0416_spawn_during_follow,            0x0416 },
	{ func0417_init_follower_clone,            0x0417 },
	{ func0418_follower_clone,                 0x0418 },
	{ func0419_init_biotech,                   0x0419 },
	{ func041a_init_superdragon_guard,         0x041a },
	{ func041b_jonathan_after_terminals,       0x041b },
	{ func041c_elvis_go_to_ufo,                0x041c },
	{ NULL, 0 },
};

struct path paths[] = {
	{ NULL, 0, 0 },
};

