//
// WAR!
//

#include "stagesetup.h"

// Characters
#define CHR_MAIAN_LEADER    0x3d
#define CHR_MAIAN_TEMPLATE  0x3e
#define CHR_SKEDAR_TEMPLATE 0x3f
#define CHR_KING1           0x40
#define CHR_KING2           0x41
#define CHR_KING3           0x42
#define CHR_BLONDE          0x43
#define CHR_MAIAN1          0x44
#define CHR_MAIAN2          0x45
#define CHR_MAIAN3          0x46
#define CHR_MAIAN4          0x47
#define CHR_MAIAN5          0x48

// Objects
#define OBJ_BRIDGE 0x05
#define OBJ_MINE1  0x2f
#define OBJ_MINE2  0x30
#define OBJ_MINE3  0x31
#define OBJ_MINE4  0x32
#define OBJ_MINE5  0x33
#define OBJ_MINE6  0x40

// Stage flags
#define STAGEFLAG_LEADER_DEAD 0x00000100
#define STAGEFLAG_KING1_DEAD  0x00000200
#define STAGEFLAG_KING2_DEAD  0x00000400
#define STAGEFLAG_KING3_DEAD  0x00000800

// AI Lists
#define AILIST_DEFEND       0x0401
#define AILIST_INIT_KING    0x0402
#define AILIST_INIT_LEADER  0x0403
#define AILIST_MAIAN        0x0404
#define AILIST_INIT_MAIAN   0x0405
#define AILIST_SKEDAR       0x0406
#define AILIST_KING1_SKEDAR 0x0407
#define AILIST_KING2_SKEDAR 0x0408
#define AILIST_KING3_SKEDAR 0x0409
#define AILIST_INTRO        0x040a
#define AILIST_OUTRO        0x040b
#define AILIST_HIDE         0x040c
#define AILIST_BLOW_MINES   0x040d

// Other
#define GROUP_MAIANS       1
#define GROUP_KING1_SKEDAR 2
#define GROUP_KING2_SKEDAR 3
#define GROUP_KING3_SKEDAR 4

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x4601)
	briefing(1, 0x4600)
	briefing(2, 0x4602)
	briefing(3, 0x4603)

	beginobjective(0, L_STAT(4), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Kill Skedar King."
		complete_flags(STAGEFLAG_KING1_DEAD)
		fail_flags(STAGEFLAG_LEADER_DEAD)
	endobjective

	beginobjective(1, L_STAT(5), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Kill Skedar King 2."
		complete_flags(STAGEFLAG_KING2_DEAD)
	endobjective

	beginobjective(2, L_STAT(6), (DIFFBIT_PA | DIFFBIT_PD)) // "Kill Skedar King 3."
		complete_flags(STAGEFLAG_KING3_DEAD)
	endobjective

	chr(0x00000000, CHR_MAIAN_LEADER, 0x004f, BODY_ELVIS1, HEAD_MAIAN_S, AILIST_INIT_LEADER, 0x004e, -1, 1000, 200, 0x00002000, 0xc0304000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x003d, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_MAIAN_TEMPLATE, 0x0045, BODY_CISOLDIER, HEAD_RANDOM, AILIST_HIDE, -1, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x003e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_KING1, 0x007c, BODY_SKEDARKING, HEAD_RANDOM, AILIST_INIT_KING, 0x007c, -1, 1000, 200, 0x00002000, 0xc0304008, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x0040, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)

	chr(0x000000c0, CHR_KING2, 0x0110, BODY_SKEDARKING, HEAD_RANDOM, AILIST_INIT_KING, 0x0091, -1, 1000, 200, 0x00002000, 0xc0304000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKROCKET, 0x0041, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SLAYER, 0x00ffffff, 0x00000000)

	chr(0x00000080, CHR_KING3, 0x0094, BODY_SKEDARKING, HEAD_RANDOM, AILIST_INIT_KING, 0x0094, -1, 1000, 200, 0x00002000, 0xc0304000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_KINGSCEPTRE, 0x0042, 0x10006000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ROCKETLAUNCHER_34, 0x00ffffff, 0x00000000)

	chr(0x00000300, CHR_BLONDE, 0x0077, BODY_SKEDAR, HEAD_MRBLONDE, AILIST_KING1_SKEDAR, 0x0022, -1, 1000, 200, 0x00002000, 0xc0304000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0043, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_SKEDAR_TEMPLATE, 0x007d, BODY_CISOLDIER, HEAD_RANDOM, AILIST_HIDE, -1, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x003f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_MAIAN1, 0x0009, BODY_ELVIS1, HEAD_MAIAN_S, GAILIST_IDLE, -1, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x0044, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_MAIAN2, 0x00a4, BODY_ELVIS1, HEAD_MAIAN_S, GAILIST_IDLE, -1, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x0045, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_MAIAN3, 0x0008, BODY_ELVIS1, HEAD_MAIAN_S, AILIST_HIDE, -1, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_01, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x0046, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_MAIAN4, 0x000c, BODY_ELVIS1, HEAD_MAIAN_S, AILIST_HIDE, -1, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_01, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x0047, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)

	chr(0x00000000, CHR_MAIAN5, 0x000d, BODY_ELVIS1, HEAD_MAIAN_S, AILIST_HIDE, -1, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_01, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x0048, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)

	link_scenery(1, 0, 2)
	debris(0x0100, MODEL_SKCREV_UNEXP1, 0x00e5, 0x035005e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	debris(0x0100, MODEL_SKCREV_EXP1, 0x00e6, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_SKTNL_UNEXP1, 0x00e7, 0x13500d00, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	debris(0x0100, MODEL_SKTNL_EXP1, 0x00e8, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1e, 5)
	tag(0x1f, 5)
	tag(0x20, 5)
	tag(0x21, 5)
	tag(0x22, 5)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_ML, 0x014b, 0x035004e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_MR, 0x014c, 0x035004e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_BL, 0x014d, 0x035004e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_BR, 0x014e, 0x035004e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_T, 0x014a, 0x035004e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 3)
	tag(0x2a, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN4, 0x0111, 0x035005e8, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x02, 3)
	tag(0x2b, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN2, 0x010a, 0x035005e8, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x03, 3)
	tag(0x2c, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN3, 0x010b, 0x035005e8, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2d, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN2, 0x010c, 0x035005e1, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2e, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN3, 0x010d, 0x035005e1, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x27, 1)
	tag(0x28, 1)
	tag(0x29, 1)
	tag(0x2f, 5)
	tag(0x30, 5)
	tag(0x31, 5)
	tag(0x32, 5)
	tag(0x33, 5)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x00d5, 0x012004e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010a, 0x012004e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010b, 0x012004e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010c, 0x012004e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010d, 0x012004e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3d, 1)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x003b, 0x012004e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_SUNNOSHAD1, 0x014f, 0x035004e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_SUNNOSHAD2, 0x0150, 0x035004e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_SK_DOOR1, 0x00eb, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00ec, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00ed, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00ee, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3e, 2)
	tag(0x3f, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00ef, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f0, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x09, 2)
	tag(0x0a, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f1, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f2, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0d, 2)
	tag(0x0e, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f3, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f4, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f5, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f6, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0f, 2)
	tag(0x10, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f7, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f8, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x11, 2)
	tag(0x12, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f9, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00fa, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0c, 1)
	vent_fan(0x0100, MODEL_SK_UNDER_GENERATOR, 0x0126, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_SK_UNDER_TRANS, 0x0127, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_SK_UNDER_TRANS, 0x0128, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	tag(0x04, 1)
	stdobject(0x0080, MODEL_SKPUZZLEOBJECT, 0x00d4, 0x000201e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x05, 1)
	lift(0x0100, MODEL_SKEDARBRIDGE, 0x0136, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0136, 0x0136, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0b, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0137, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x23, 1)
	stdobject(0x0019, MODEL_RUBBLE1, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x24, 1)
	stdobject(0x0019, MODEL_RUBBLE2, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x25, 1)
	stdobject(0x0019, MODEL_RUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x26, 1)
	stdobject(0x0019, MODEL_RUBBLE4, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x37, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x38, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE4, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x39, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE5, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3a, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE6, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3b, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3c, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x36, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x00fc, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x00fb, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x00fd, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x00fe, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0100, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x00ff, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0101, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0102, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0104, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0103, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0106, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0105, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0107, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0108, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x40, 1)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x003b, 0x012004e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	pad_effect(PADEFFECT_SPARKS, 0x0112)
	pad_effect(PADEFFECT_SPARKS, 0x0117)
	pad_effect(PADEFFECT_SPARKS, 0x0113)
	pad_effect(PADEFFECT_SPARKS, 0x0114)
	pad_effect(PADEFFECT_SPARKS, 0x0115)
	pad_effect(PADEFFECT_SPARKS, 0x0116)
	pad_effect(PADEFFECT_SPARKS, 0x0118)
	pad_effect(PADEFFECT_SPARKS, 0x0119)
	pad_effect(PADEFFECT_SPARKS, 0x011a)
	pad_effect(PADEFFECT_SPARKS, 0x011b)
	pad_effect(PADEFFECT_SPARKS, 0x011c)
	pad_effect(PADEFFECT_SPARKS, 0x011d)
	pad_effect(PADEFFECT_SPARKS, 0x011e)
	pad_effect(PADEFFECT_SPARKS, 0x011f)
	pad_effect(PADEFFECT_SPARKS, 0x0120)
	pad_effect(PADEFFECT_SPARKS, 0x0121)
	pad_effect(PADEFFECT_SPARKS, 0x0122)
	pad_effect(PADEFFECT_SPARKS, 0x0123)
	pad_effect(PADEFFECT_SPARKS, 0x0124)
	pad_effect(PADEFFECT_SPARKS, 0x0125)
	endprops
};

s32 intro[] = {
	outfit(OUTFIT_MAIAN)
	intro_weapon(WEAPON_PHOENIX, -1)
	ammo(AMMOTYPE_PISTOL, 300)
	ammo(AMMOTYPE_ROCKET, 3)
	ammo(AMMOTYPE_SMG, 100)
	spawn(0x00d7)
	endintro
};

struct path paths[] = {
	{ NULL, 0, 0 },
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1000_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func0403_init_maian_leader[] = {
	stop_chr
	yield
	set_alertness(100)
	set_accuracy(100)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(300)
	set_recovery_speed(100)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_DEFEND)
	endlist
};

u8 func0402_init_king[] = {
	set_self_chrflag(CHRCFLAG_00000020)
	set_alertness(100)
	set_accuracy(100)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(300)
	set_recovery_speed(100)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, AILIST_DEFEND)
	endlist
};

u8 func0401_defend[] = {
	set_shotlist(AILIST_DEFEND)
	set_self_chrflag(CHRCFLAG_NOAUTOAIM)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2d)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	// Dying
	label(0x2d)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Not dying - go to pad
	label(0x06)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x06)

	label(0x03)
		restart_timer
		if_chr_distance_to_pad_gt(CHR_SELF, 500, PAD_PRESET, /*goto*/ 0x06)
		go_to_target_pad(SPEED_JOG)

		label(0x06)
		go_to_target_pad(SPEED_RUN)

		// Wait until at pad or 1 second has passed
		beginloop(0x04)
			dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
			if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
			if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x06)
			if_timer_gt(60, /*goto*/ 0x2d)
		endloop(0x04)

		// Timer expired - loop again
		label(0x2d)
		goto_first(0x03)

		// At pad
		label(0x06)
		stop_chr

		// Wait for enemy to come into sight, or to be pushed away from pad
		beginloop(0x09)
			if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
			if_chr_distance_to_pad_gt(CHR_SELF, 300, PAD_PRESET, /*goto*/ 0x06)
		endloop(0x09)

		// Pushed away from pad - return to it
		label(0x06)
		goto_first(0x03)

		// Line of sight to enemy
		label(0x08)
		if_self_flag_bankx_eq(CHRFLAG1_00000008, TRUE, BANK_1, /*goto*/ 0x2d)
		restart_timer

		beginloop(0x8f)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x8f)

		label(0x2d)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x2d)
		dprint 'D','E','T','E','C','T','E','D','\n',0,
		set_returnlist(CHR_SELF, AILIST_DEFEND)
		set_shotlist(AILIST_DEFEND)
		set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

		label(0x2d)
	goto_first(0x03)

	endlist
};

u8 func1003_spawn_maians[] = {
	yield

	// Wait for intro to finish
	beginloop(0x58)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x2e)
		label(0x2d)
	endloop(0x58)

	label(0x2e)
	yield
	yield
	yield
	yield
	yield
	label(0x04)
	yield
	label(0x06)
	set_morale(50)

	// Loop until a Maian is able to be spawned or counter depleted
	beginloop(0x8d)
		if_morale_lt(1, /*goto*/ 0x06)
		try_spawn_chr_at_pad(BODY_ELVIS1, HEAD_MAIAN_S, 0x0053, AILIST_INIT_MAIAN, 0x00000000, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_ELVIS1, HEAD_MAIAN_S, 0x0050, AILIST_INIT_MAIAN, 0x00000000, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_ELVIS1, HEAD_MAIAN_S, 0x004d, AILIST_INIT_MAIAN, 0x00000000, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_ELVIS1, HEAD_MAIAN_S, 0x004c, AILIST_INIT_MAIAN, 0x00000000, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_ELVIS1, HEAD_MAIAN_S, 0x004e, AILIST_INIT_MAIAN, 0x00000000, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_ELVIS1, HEAD_MAIAN_S, 0x004a, AILIST_INIT_MAIAN, 0x00000000, /*goto*/ 0x8e)
		reloop(0x8d)

		// Successful spawn
		label(0x8e)
		dprint 'C','R','E','A','T','E','D',' ','1','\n',0,
		yield
		subtract_morale(1)
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		rebuild_teams
		rebuild_squadrons
		if_num_chrs_in_squadron_gt(7, GROUP_MAIANS, /*goto*/ 0x2d)
		reloop(0x8d)

		// Wait 5 seconds
		label(0x2d)
		restart_timer

		beginloop(0x08)
			dprint 'S','Q','U','A','D',' ','F','U','L','L','\n',0,
			if_timer_gt(300, /*goto*/ 0x2d)
		endloop(0x08)

		// If a spot has freed up, go back to the spawning part to spawn another
		label(0x2d)
		if_num_chrs_in_squadron_gt(7, GROUP_MAIANS, /*goto*/ 0x2d)
	endloop(0x8d)

	// Still no free spot, so go back to the 5 second wait
	label(0x2d)
	goto_first(0x08)

	// Counter depleted
	label(0x06)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0405_init_maian[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_00080000)
	set_chr_team(CHR_SELF, TEAM_ALLY)
	set_squadron(GROUP_MAIANS)
	rebuild_teams
	rebuild_squadrons
	try_equip_weapon(MODEL_CHRMAIANSMG, WEAPON_CALLISTONTG, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	try_inherit_properties(CHR_MAIAN_TEMPLATE, /*goto*/ 0x2d)
	label(0x2d)
	set_accuracy(100)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 200)
	add_health_or_armor(0)
	set_recovery_speed(100)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_MAIAN)
	endlist
};

u8 func0404_maian[] = {
	set_returnlist(CHR_SELF, AILIST_MAIAN)
	set_shotlist(AILIST_MAIAN)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)

	label(0x03)
		set_target_chr(CHR_KING1)
		if_chr_dying(CHR_KING1, /*goto*/ 0x8f)
		if_chr_death_animation_finished(CHR_KING1, /*goto*/ 0x8f)
		if_chr_unloaded(CHR_KING1, /*goto*/ 0x8f)
		goto_next(0x2d)

		// King 1 dead
		label(0x8f)
		set_target_chr(CHR_KING2)
		if_chr_dying(CHR_KING2, /*goto*/ 0x90)
		if_chr_death_animation_finished(CHR_KING2, /*goto*/ 0x90)
		if_chr_unloaded(CHR_KING2, /*goto*/ 0x90)
		goto_next(0x2d)

		// King 2 dead
		label(0x90)
		set_target_chr(CHR_KING3)
		run_to_pad(0x0094)
		goto_next(0x04)

		// Go to king
		label(0x2d)
		try_run_to_target(/*goto*/ 0x04)

		beginloop(0x04)
			dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
			if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
			if_chr_dying(CHR_TARGET, /*goto*/ 0x06)
			if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x06)
			if_chr_unloaded(CHR_TARGET, /*goto*/ 0x06)
		endloop(0x04)

		// King died while running to him
		label(0x06)
		goto_first(0x03)

		// Maian has line of sight to king
		label(0x08)
		dprint 'D','E','T','E','C','T','E','D','\n',0,
		if_chr_dying(CHR_TARGET, /*goto*/ 0x06)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x06)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x06)
		set_returnlist(CHR_SELF, AILIST_MAIAN)
		set_shotlist(AILIST_MAIAN)
		set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

		// King died while fighting
		label(0x06)
	goto_first(0x03)

	endlist
};

u8 func1004_spawn_king1_skedar[] = {
	// Wait for intro to finish
	beginloop(0x58)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x2e)
		label(0x2d)
	endloop(0x58)

	label(0x2e)
	yield
	yield
	yield
	yield
	yield
	label(0x04)
	yield
	label(0x06)
	set_morale(65)

	// Loop until a Skedar is able to be spawned or counter depleted
	beginloop(0x8d)
		if_stage_flag_eq(STAGEFLAG_KING1_DEAD, TRUE, /*goto*/ 0x0e)
		if_morale_lt(1, /*goto*/ 0x06)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0079, AILIST_KING1_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x007d, AILIST_KING1_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0083, AILIST_KING1_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0085, AILIST_KING1_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		reloop(0x8d)

		// Successful spawn
		label(0x8e)
		dprint 'C','R','E','A','T','E','D',' ','1','\n',0,
		yield
		subtract_morale(1)
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		rebuild_teams
		rebuild_squadrons
		if_num_chrs_in_squadron_gt(5, 0x02, /*goto*/ 0x2d)
		reloop(0x8d)

		// Wait for 10 seconds if Maian squad is somewhat full,
		// or wait 1 second if Maian squad is somewhat empty.
		label(0x2d)
		restart_timer

		beginloop(0x08)
			if_stage_flag_eq(STAGEFLAG_KING1_DEAD, TRUE, /*goto*/ 0x0e)
			dprint 'S','Q','U','A','D',' ','F','U','L','L','\n',0,
			if_num_chrs_in_squadron_gt(3, GROUP_MAIANS, /*goto*/ 0x2e)
			if_timer_gt(60, /*goto*/ 0x2d)
			label(0x2e)
			if_timer_gt(600, /*goto*/ 0x2d)
		endloop(0x08)

		// If squad is still full, wait another 1 or 10 seconds
		label(0x2d)
		if_num_chrs_in_squadron_gt(5, GROUP_KING1_SKEDAR, /*goto*/ 0x2d)
	goto_first(0x8d)

	// Spawn more
	label(0x2d)
	goto_first(0x08)

	// Counter depleted
	label(0x06)

	// King 1 dead
	label(0x0e)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_spawn_king2_skedar[] = {
	// Wait for intro to finish
	beginloop(0x58)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x2e)
		label(0x2d)
	endloop(0x58)

	// Wait for king 1 to die
	label(0x2e)
	yield

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_KING1_DEAD, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	// Loop until a Skedar is able to be spawned or counter depleted
	label(0x06)
	set_morale(50)

	beginloop(0x8d)
		if_stage_flag_eq(STAGEFLAG_KING2_DEAD, TRUE, /*goto*/ 0x0e)
		if_morale_lt(1, /*goto*/ 0x06)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x008e, AILIST_KING2_SKEDAR, 0x00000210, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0090, AILIST_KING2_SKEDAR, 0x00000210, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x008f, AILIST_KING2_SKEDAR, 0x00000210, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0091, AILIST_KING2_SKEDAR, 0x00000210, /*goto*/ 0x8e)
		reloop(0x8d)

		// Successful spawn
		label(0x8e)
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		subtract_morale(1)
		rebuild_teams
		rebuild_squadrons
		if_num_chrs_in_squadron_gt(3, GROUP_KING2_SKEDAR, /*goto*/ 0x2d)
		reloop(0x8d)

		// Wait 15 seconds or until king 2 dead
		label(0x2d)
		restart_timer

		beginloop(0x08)
			if_stage_flag_eq(STAGEFLAG_KING2_DEAD, TRUE, /*goto*/ 0x0e)
			if_timer_gt(900, /*goto*/ 0x2d)
		endloop(0x08)

		// If squad still full, wait another 15 seconds, otherwise loop back to
		// the spawning code.
		label(0x2d)
		if_num_chrs_in_squadron_gt(3, GROUP_KING2_SKEDAR, /*goto*/ 0x2d)
	endloop(0x8d)

	label(0x2d)
	goto_first(0x08)

	// Counter depleted
	label(0x06)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_spawn_king3_skedar[] = {
	// Wait for intro to finish
	beginloop(0x58)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x2e)
		label(0x2d)
	endloop(0x58)

	// Wait for king 2 to die
	label(0x2e)
	yield

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_KING2_DEAD, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	// Loop until a Skedar is able to be spawned or counter depleted
	label(0x06)
	set_morale(50)

	beginloop(0x8d)
		if_stage_flag_eq(STAGEFLAG_KING3_DEAD, TRUE, /*goto*/ 0x0e)
		if_morale_lt(1, /*goto*/ 0x06)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0095, AILIST_KING3_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0096, AILIST_KING3_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x012e, AILIST_KING3_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		try_spawn_chr_at_pad(BODY_SKEDAR, HEAD_RANDOM, 0x0132, AILIST_KING3_SKEDAR, 0x00000200, /*goto*/ 0x8e)
		reloop(0x8d)

		// Successful spawn
		label(0x8e)
		yield
		subtract_morale(1)
		rebuild_teams
		rebuild_squadrons
		if_num_chrs_in_squadron_gt(5, 0x04, /*goto*/ 0x2d)
		reloop(0x8d)

		// Squad full - wait 15 seconds or for king 3 to die
		label(0x2d)
		restart_timer

		beginloop(0x08)
			if_stage_flag_eq(STAGEFLAG_KING3_DEAD, TRUE, /*goto*/ 0x0e)
			if_timer_gt(900, /*goto*/ 0x2d)
		endloop(0x08)

		// Spawn more or wait another 15 seconds
		label(0x2d)
		if_num_chrs_in_squadron_gt(5, GROUP_KING3_SKEDAR, /*goto*/ 0x2d)
	endloop(0x8d)

	label(0x2d)
	goto_first(0x08)

	// Countdown depleted
	label(0x06)
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0407_king1_skedar[] = {
	try_equip_weapon(MODEL_CHRMAULER, WEAPON_MAULER, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	try_inherit_properties(CHR_SKEDAR_TEMPLATE, /*goto*/ 0x2d)
	label(0x2d)
	set_squadron(GROUP_KING1_SKEDAR)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000)
	set_accuracy(10)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 150)
	add_health_or_armor(80)
	set_recovery_speed(100)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_SKEDAR)
	endlist
};

u8 func0408_king2_skedar[] = {
	try_equip_weapon(MODEL_CHRMAULER, WEAPON_MAULER, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	try_inherit_properties(CHR_SKEDAR_TEMPLATE, /*goto*/ 0x2d)
	label(0x2d)
	set_squadron(GROUP_KING2_SKEDAR)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000)
	set_accuracy(10)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 150)
	add_health_or_armor(80)
	set_recovery_speed(100)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_SKEDAR)
	endlist
};

u8 func0409_king3_skedar[] = {
	try_equip_weapon(MODEL_CHRMAULER, WEAPON_MAULER, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	try_inherit_properties(CHR_SKEDAR_TEMPLATE, /*goto*/ 0x2d)
	label(0x2d)
	set_squadron(GROUP_KING3_SKEDAR)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000)
	set_accuracy(10)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 150)
	add_health_or_armor(80)
	set_recovery_speed(100)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_SKEDAR)
	endlist
};

u8 func0406_skedar[] = {
	set_shotlist(AILIST_SKEDAR)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	label(0x03)

	// Go to Maian leader
	set_target_chr(CHR_MAIAN_LEADER)
	try_run_to_target(/*goto*/ 0x04)

	beginloop(0x04)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	endloop(0x04)

	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_returnlist(CHR_SELF, AILIST_SKEDAR)
	set_shotlist(AILIST_SKEDAR)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func1005_check_leader_dead[] = {
	beginloop(0x03)
		if_chr_death_animation_finished(CHR_MAIAN_LEADER, /*goto*/ 0x2d)
		if_chr_dying(CHR_MAIAN_LEADER, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_MAIAN_LEADER, /*goto*/ 0x2d)
	endloop(0x03)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_STAT(7)) // "Maian leader has been killed."
	set_stage_flag(STAGEFLAG_LEADER_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_check_king1_dead[] = {
	set_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)

	beginloop(0x03)
		if_chr_death_animation_finished(CHR_KING1, /*goto*/ 0x2d)
		if_chr_dying(CHR_KING1, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_KING1, /*goto*/ 0x2d)
	endloop(0x03)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_STAT(8)) // "Skedar King has been killed."
	set_stage_flag(STAGEFLAG_KING1_DEAD)
	unlock_door(0x3e, 0x40)
	unlock_door(0x3f, 0x40)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100a_check_king2_dead[] = {
	set_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0e)

	beginloop(0x03)
		if_chr_death_animation_finished(CHR_KING2, /*goto*/ 0x2d)
		if_chr_dying(CHR_KING2, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_KING2, /*goto*/ 0x2d)
	endloop(0x03)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_STAT(8)) // "Skedar King has been killed."
	set_stage_flag(STAGEFLAG_KING2_DEAD)
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_check_king3_dead[] = {
	set_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0e)

	beginloop(0x03)
		if_chr_death_animation_finished(CHR_KING3, /*goto*/ 0x2d)
		if_chr_dying(CHR_KING3, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_KING3, /*goto*/ 0x2d)
	endloop(0x03)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_STAT(8)) // "Skedar King has been killed."
	set_stage_flag(STAGEFLAG_KING3_DEAD)
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_check_end_level[] = {
	// Wait for all objectives complete
	beginloop(0x03)
		if_all_objectives_complete(/*goto*/ 0x2d)
	endloop(0x03)

	// Wait 2 seconds
	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x08)

	// Check Jo not dead
	label(0x2d)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2d)
	goto_next(0x06)

	// Check Velvet not dead
	label(0x2d)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2d)
	goto_next(0x06)

	// Mission failed
	label(0x2d)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x06)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_hide[] = {
	label(0x03)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100d_king1_invincible[] = {
	beginloop(0x03)
		if_chr_in_room(CHR_BOND, 0x00, 0x0070, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0071, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0072, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0073, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0074, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0075, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0076, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0077, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0078, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0079, /*goto*/ 0x2d)
		set_chr_chrflag(CHR_KING1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
		reloop(0x03)

		label(0x2d)
		unset_chr_chrflag(CHR_KING1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	endloop(0x03)

	endlist
};

u8 unregistered_function[] = {
	yield

	// Wait for intro to finish
	beginloop(0x58)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x2e)
		label(0x2d)
	endloop(0x58)

	label(0x2e)
	yield
	yield
	yield
	yield
	yield

	// Remove Blonde if counterop doesn't exist
	label(0x03)
	if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2d)
	remove_chr(CHR_BLONDE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_G5_INTRO)
	set_chr_hiddenflag(CHR_ANTI, CHRHFLAG_00020000)
	set_chr_hiddenflag(CHR_BLONDE, CHRHFLAG_00020000)
	camera_movement(0x047c)
	cmd0175(60)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x047d, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	unset_chr_chrflag(CHR_MAIAN1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_MAIAN1, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_MAIAN1, CHRHFLAG_00020000)
	chr_do_animation(0x047e, -1, -1, 0x06, 0x00, CHR_MAIAN1, 4)

	unset_chr_chrflag(CHR_MAIAN2, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_MAIAN2, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_MAIAN2, CHRHFLAG_00020000)
	chr_do_animation(0x047f, -1, -1, 0x06, 0x00, CHR_MAIAN2, 4)

	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 110)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_PHOENIX, WEAPON_NONE)

	// Wait 200 frames (3.3 secs) or until button pressed
	beginloop(0x96)
		if_controller_button_pressed(/*goto*/ 0x82)
		if_timer_gt(200, /*goto*/ 0x06)
	endloop(0x96)

	// Timer expired - play a sound (explosion?)
	label(0x06)
	play_sound(0x05e2, CHANNEL_10)

	// Wait for camera to finish or button to be pressed
	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x82)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x82)
		label(0x2d)
	endloop(0x08)

	// Outro done
	label(0x82)
	mute_channel(CHANNEL_10)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ANTI, CHRHFLAG_00020000)

	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x047d, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	unset_chr_chrflag(CHR_MAIAN3, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_MAIAN3, CHRHFLAG_00020000)
	chr_do_animation(0x047e, -2, -1, 0x06, 0x00, CHR_MAIAN3, 2)

	unset_chr_chrflag(CHR_MAIAN4, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_MAIAN4, CHRHFLAG_00020000)
	chr_do_animation(0x047f, -2, -1, 0x06, 0x00, CHR_MAIAN4, 2)

	set_ailist(CHR_MAIAN1, AILIST_INIT_MAIAN)
	set_ailist(CHR_MAIAN2, AILIST_INIT_MAIAN)
	restart_default_music
	reset_ambience
	enter_firstperson
	yield
	label(0x2d)
	set_ailist(CHR_SELF, AILIST_BLOW_MINES)
	endlist
};

u8 func040b_outro[] = {
	set_invincible(CHR_BOND)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_G5_OUTRO)
	camera_movement(0x0480)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)

	unset_chr_chrflag(CHR_MAIAN3, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_MAIAN3, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_MAIAN3, CHRHFLAG_00020000)
	chr_do_animation(0x0481, -1, -1, 0x06, 0x00, CHR_MAIAN3, 4)

	unset_chr_chrflag(CHR_MAIAN4, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_MAIAN4, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_MAIAN4, CHRHFLAG_00020000)
	chr_do_animation(0x0482, -1, -1, 0x06, 0x00, CHR_MAIAN4, 4)

	unset_chr_chrflag(CHR_MAIAN5, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_MAIAN5, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_MAIAN5, CHRHFLAG_00020000)
	chr_do_animation(0x0483, -1, -1, 0x06, 0x00, CHR_MAIAN5, 4)

	show_nonessential_chrs(FALSE)

	// Wait 10 frames or for button press
	restart_timer

	beginloop(0x96)
		if_controller_button_pressed(/*goto*/ 0x82)
		if_timer_gt(10, /*goto*/ 0x06)
	endloop(0x96)

	// Play sound
	label(0x06)
	play_sound(0x05e3, CHANNEL_10)

	// Wait 70 frames or for button press
	beginloop(0x97)
		if_controller_button_pressed(/*goto*/ 0x82)
		if_timer_gt(70, /*goto*/ 0x06)
	endloop(0x97)

	// Play sound
	label(0x06)
	play_sound(0x05e5, CHANNEL_10)

	// Wait 180 frames or for button press
	beginloop(0x98)
		if_controller_button_pressed(/*goto*/ 0x82)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x98)

	// Play sound
	label(0x06)
	play_sound(0x05e7, CHANNEL_10)

	// Wait for outro to finish
	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x82)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x82)
		label(0x2d)
	endloop(0x08)

	label(0x82)
	label(0x06)
	mute_channel(CHANNEL_10)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_blow_mines[] = {
	yield

	#define wait(loopid) \
		restart_timer \
 \
		beginloop(loopid) \
			if_timer_gt(120, /*goto*/ 0x2d) \
		endloop(loopid) \
 \
		label(0x2d)



	wait(0x94)
	destroy_object(OBJ_MINE6)
	wait(0x95)
	destroy_object(OBJ_MINE1)
	wait(0x8f)
	destroy_object(OBJ_MINE2)
	wait(0x90)
	destroy_object(OBJ_MINE3)
	wait(0x91)
	destroy_object(OBJ_MINE4)
	wait(0x92)
	destroy_object(OBJ_MINE5)
	wait(0x93)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_init_lighting[] = {
	yield
	misc_command(0x0004, 0x05, 0x01)
	misc_command(0x0004, 0x06, 0x01)
	misc_command(0x0005, 0x05, 0x01)
	misc_command(0x0005, 0x06, 0x01)
	misc_command(0x0006, 0x05, 0x01)
	misc_command(0x0006, 0x06, 0x01)
	misc_command(0x0007, 0x05, 0x01)
	misc_command(0x0007, 0x06, 0x01)
	misc_command(0x0008, 0x05, 0x01)
	misc_command(0x0008, 0x06, 0x01)
	misc_command(0x0009, 0x05, 0x01)
	misc_command(0x0009, 0x06, 0x01)
	misc_command(0x000a, 0x05, 0x01)
	misc_command(0x000a, 0x06, 0x01)
	misc_command(0x000b, 0x05, 0x01)
	misc_command(0x000b, 0x06, 0x01)
	misc_command(0x000c, 0x05, 0x01)
	misc_command(0x000c, 0x06, 0x01)
	misc_command(0x000d, 0x05, 0x01)
	misc_command(0x000d, 0x06, 0x01)
	misc_command(0x000e, 0x05, 0x01)
	misc_command(0x000e, 0x06, 0x01)
	misc_command(0x000f, 0x05, 0x01)
	misc_command(0x000f, 0x06, 0x01)
	misc_command(0x0010, 0x05, 0x01)
	misc_command(0x0010, 0x06, 0x01)
	misc_command(0x0011, 0x05, 0x01)
	misc_command(0x0011, 0x06, 0x01)
	misc_command(0x0012, 0x05, 0x01)
	misc_command(0x0012, 0x06, 0x01)
	misc_command(0x0013, 0x05, 0x01)
	misc_command(0x0013, 0x06, 0x01)
	misc_command(0x0014, 0x05, 0x01)
	misc_command(0x0014, 0x06, 0x01)
	misc_command(0x0015, 0x05, 0x01)
	misc_command(0x0015, 0x06, 0x01)
	misc_command(0x0016, 0x05, 0x01)
	misc_command(0x0016, 0x06, 0x01)
	misc_command(0x0017, 0x05, 0x01)
	misc_command(0x0017, 0x06, 0x01)
	misc_command(0x0018, 0x05, 0x01)
	misc_command(0x0018, 0x06, 0x01)
	misc_command(0x0019, 0x05, 0x01)
	misc_command(0x0019, 0x06, 0x01)
	misc_command(0x001a, 0x05, 0x01)
	misc_command(0x001b, 0x05, 0x01)
	misc_command(0x001b, 0x06, 0x01)
	misc_command(0x001d, 0x05, 0x01)
	misc_command(0x001d, 0x06, 0x01)
	misc_command(0x001e, 0x05, 0x01)
	misc_command(0x001e, 0x06, 0x01)
	misc_command(0x001f, 0x05, 0x01)
	misc_command(0x001f, 0x06, 0x01)
	misc_command(0x0020, 0x05, 0x01)
	misc_command(0x0020, 0x06, 0x01)
	misc_command(0x0021, 0x05, 0x01)
	misc_command(0x0021, 0x06, 0x01)
	misc_command(0x0022, 0x05, 0x01)
	misc_command(0x0022, 0x06, 0x01)
	misc_command(0x0023, 0x05, 0x01)
	misc_command(0x0023, 0x06, 0x01)
	misc_command(0x0024, 0x05, 0x01)
	misc_command(0x0024, 0x06, 0x01)
	misc_command(0x0025, 0x05, 0x01)
	misc_command(0x0025, 0x06, 0x01)
	misc_command(0x0026, 0x05, 0x01)
	misc_command(0x0026, 0x06, 0x01)
	misc_command(0x0027, 0x05, 0x01)
	misc_command(0x0027, 0x06, 0x01)
	misc_command(0x0028, 0x05, 0x01)
	misc_command(0x0028, 0x06, 0x01)
	misc_command(0x0029, 0x05, 0x01)
	misc_command(0x0029, 0x06, 0x01)
	misc_command(0x002a, 0x05, 0x01)
	misc_command(0x002a, 0x06, 0x01)
	misc_command(0x002b, 0x05, 0x01)
	misc_command(0x002b, 0x06, 0x01)
	misc_command(0x002c, 0x05, 0x01)
	misc_command(0x002c, 0x06, 0x01)
	misc_command(0x002d, 0x05, 0x01)
	misc_command(0x002d, 0x06, 0x01)
	misc_command(0x002e, 0x05, 0x01)
	misc_command(0x002e, 0x06, 0x01)
	misc_command(0x002f, 0x05, 0x01)
	misc_command(0x002f, 0x06, 0x01)
	misc_command(0x0030, 0x05, 0x01)
	misc_command(0x0030, 0x06, 0x01)
	misc_command(0x0031, 0x05, 0x01)
	misc_command(0x0031, 0x06, 0x01)
	misc_command(0x003b, 0x05, 0x01)
	misc_command(0x003b, 0x06, 0x01)
	misc_command(0x003c, 0x05, 0x01)
	misc_command(0x003c, 0x06, 0x01)
	misc_command(0x003d, 0x05, 0x01)
	misc_command(0x003d, 0x06, 0x01)
	misc_command(0x003e, 0x05, 0x01)
	misc_command(0x003e, 0x06, 0x01)
	misc_command(0x003f, 0x05, 0x01)
	misc_command(0x003f, 0x06, 0x01)
	misc_command(0x0040, 0x05, 0x01)
	misc_command(0x0040, 0x06, 0x01)
	misc_command(0x0041, 0x05, 0x01)
	misc_command(0x0041, 0x06, 0x01)
	misc_command(0x0042, 0x05, 0x01)
	misc_command(0x0042, 0x06, 0x01)
	misc_command(0x0043, 0x05, 0x01)
	misc_command(0x0043, 0x06, 0x01)
	misc_command(0x0044, 0x05, 0x01)
	misc_command(0x0044, 0x06, 0x01)
	misc_command(0x0045, 0x05, 0x01)
	misc_command(0x0046, 0x05, 0x01)
	misc_command(0x0047, 0x05, 0x01)
	misc_command(0x0047, 0x06, 0x01)
	misc_command(0x0049, 0x05, 0x01)
	misc_command(0x0049, 0x06, 0x01)
	misc_command(0x004a, 0x05, 0x01)
	misc_command(0x004a, 0x06, 0x01)
	misc_command(0x004b, 0x06, 0x01)
	misc_command(0x0048, 0x06, 0x01)
	misc_command(0x004f, 0x05, 0x01)
	misc_command(0x0058, 0x05, 0x01)
	misc_command(0x0059, 0x05, 0x01)
	misc_command(0x0059, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func1000_counterop,             0x1000 },
	{ func1001_objectives_failed_msg, 0x1001 },
	{ func1002_intro,                 0x1002 },
	{ func1003_spawn_maians,          0x1003 },
	{ func1004_spawn_king1_skedar,    0x1004 },
	{ func1005_check_leader_dead,     0x1005 },
	{ func1007_check_end_level,       0x1007 },
	{ func1008_spawn_king2_skedar,    0x1008 },
	{ func1009_check_king1_dead,      0x1009 },
	{ func100a_check_king2_dead,      0x100a },
	{ func100b_check_king3_dead,      0x100b },
	{ func100c_spawn_king3_skedar,    0x100c },
	{ func100d_king1_invincible,      0x100d },
	{ func100f_blow_mines,            0x100f },
	{ func1010_init_lighting,         0x1010 },
	{ func100f_blow_mines,            0x040d },
	{ func040c_hide,                  0x040c },
	{ func0401_defend,                0x0401 },
	{ func0402_init_king,             0x0402 },
	{ func0403_init_maian_leader,     0x0403 },
	{ func0404_maian,                 0x0404 },
	{ func0405_init_maian,            0x0405 },
	{ func0406_skedar,                0x0406 },
	{ func0407_king1_skedar,          0x0407 },
	{ func0408_king2_skedar,          0x0408 },
	{ func0409_king3_skedar,          0x0409 },
	{ func1002_intro,                 0x040a },
	{ func040b_outro,                 0x040b },
	{ func1002_intro,                 0x0c00 },
	{ func040b_outro,                 0x0c01 },
	{ NULL, 0 },
};

