//
// Deep Sea
//

#include "stagesetup.h"

// Characters
#define CHR_ELVIS    0x00
#define CHR_BLONDE1  0x22
#define CHR_BLONDE2  0x23
#define CHR_DRCAROLL 0x24

// Objects
#define OBJ_POWERNODE1 0x00
#define OBJ_POWERNODE2 0x01
#define OBJ_POWERNODE3 0x02
#define OBJ_BACKUPDISK 0x74
#define OBJ_PROXYMINES 0xb0

// Stage flags
#define STAGEFLAG_DRCAROLL_RESTORED               0x00000001
#define STAGEFLAG_ELVIS_SAID_SABOTAGE             0x00000002
#define STAGEFLAG_DONE_FIRST_TELEPORT             0x00000004
#define STAGEFLAG_PURPLE_GUARD_SHOT_JO_OR_ELVIS   0x00000010
#define STAGEFLAG_TELEPORT_DONE                   0x00000020
#define STAGEFLAG_ELVIS_FOLLOWING_COOP            0x00000080
#define STAGEFLAG_TELEPORTALS_ACTIVATED           0x00000100
#define STAGEFLAG_MIDCUTSCENE_FINISHED            0x00000200
#define STAGEFLAG_ESCAPED                         0x00000400
#define STAGEFLAG_ALLY_DEAD                       0x00000800
#define STAGEFLAG_FARSIGHT_AMMO_WASTED            0x00001000
#define STAGEFLAG_TIMER_EXPIRED                   0x00002000
#define STAGEFLAG_AGENT_MEGAWEAPON_DISABLED       0x00004000
#define STAGEFLAG_BLONDES_DEAD                    0x00008000
#define STAGEFLAG_SA_EXIT_TELEPORT_DISABLED       0x00010000
#define STAGEFLAG_MEGAWEAPON_DISABLED             0x00020000
#define STAGEFLAG_TRIGGER_MINISKEDAR_SPAWNING     0x00040000
#define STAGEFLAG_ELVIS_STARTED_SA_MEGAWEAPON     0x00080000
#define STAGEFLAG_PA_EARLYDOORCYLINDER1_DESTROYED 0x00100000
#define STAGEFLAG_PA_EARLYDOORCYLINDER2_DESTROYED 0x00200000
#define STAGEFLAG_PA_EARLYDOORCYLINDER3_DESTROYED 0x00400000
#define STAGEFLAG_PA_EARLYDOORCYLINDER4_DESTROYED 0x00800000
#define STAGEFLAG_PA_EARLYDOORCYLINDER5_DESTROYED 0x01000000
#define STAGEFLAG_PA_LATEDOORCYLINDER1_DESTROYED  0x02000000
#define STAGEFLAG_PA_LATEDOORCYLINDER2_DESTROYED  0x04000000
#define STAGEFLAG_PA_LATEDOORCYLINDER3_DESTROYED  0x08000000
#define STAGEFLAG_PA_LATEDOORCYLINDER4_DESTROYED  0x10000000
#define STAGEFLAG_PA_CANISTER1_DESTROYED          0x20000000
#define STAGEFLAG_PA_CANISDER2_DESTROYED          0x40000000
#define STAGEFLAG_PA_MIDDOORCYLINDER_DESTROYED    0x80000000

// AI Lists
#define AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS 0x0402
#define AILIST_ELVIS_GIVE_FARSIGHT                     0x0403
#define AILIST_ELVIS_FOLLOW_AND_DO_AGENT_MEGAWEAPON    0x0404
#define AILIST_ELVIS_FOLLOW_AND_DO_SA_MEGAWEAPON       0x0406
#define AILIST_ELVIS_GO_TO_SA_TELEPORT                 0x0407
#define AILIST_INIT_ELVIS                              0x040b
#define AILIST_BLONDE                                  0x040c
#define AILIST_MINISKEDAR_SEND_CLONES                  0x040d
#define AILIST_INIT_MINISKEDAR                         0x040e
#define AILIST_MINISKEDAR                              0x040f
#define AILIST_OUTRO                                   0x0410
#define AILIST_HIDE                                    0x0411
#define AILIST_CLOAK_AND_HIDE                          0x0413
#define AILIST_TELEPORT_BOND_TO_SAPA                   0x0414
#define AILIST_TELEPORT_BOND_TO_DRCAROLL               0x0415
#define AILIST_TELEPORT_BOND_TO_A_PA_DRCAROLL          0x0416
#define AILIST_TELEPORT_COOP_TO_SAPA                   0x0417
#define AILIST_TELEPORT_COOP_TO_DRCAROLL               0x0418
#define AILIST_TELEPORT_COOP_TO_A_PA_DRCAROLL          0x0419
#define AILIST_INIT_SNIPER                             0x041a
#define AILIST_SNIPER_WAIT_FOR_DETECTION               0x041b
#define AILIST_TELEPORT_ACTIVATION_RESPONDER           0x041c
#define AILIST_SNIPER                                  0x041d
#define AILIST_INIT_SA_MEGAWEAPON_MINISKEDAR           0x041e
#define AILIST_INIT_PA_CIRCLEROOM_MINISKEDAR           0x041f
#define AILIST_INIT_PA_DEADENDROOM_MINISKEDAR          0x0420
#define AILIST_MIDCUTSCENE                             0x042a
#define AILIST_RUN_TO_EXIT                             0x042b
#define AILIST_ELVIS_STOP                              0x042c
#define AILIST_ELVIS_WARP_TO_OUTSIDE_DRCAROLL          0x042d
#define AILIST_ELVIS_RUN_TO_EXIT                       0x042e
#define AILIST_INIT_PELAGIC_GUARD                      0x042f
#define AILIST_MINISKEDAR_UNALERTED                    0x0431
#define AILIST_DEAD_SKEDAR                             0x0432

// Pads
#define PAD_STARTAREA_TELEPORT 0x0116
#define PAD_AGENTAREA_ENTRY    0x01a2
#define PAD_AGENTAREA_TELEPORT 0x01fd
#define PAD_SAPAAREA_ENTRY     0x01b6
#define PAD_SAPAAREA_TELEPORT  0x01f9
#define PAD_PAAREA_ENTRY       0x01a5
#define PAD_PAAREA_TELEPORT    0x0200
#define PAD_DRCAROLLROOM_ENTRY 0x01cb

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x3001)
	briefing(1, 0x3000)
	briefing(2, 0x3002)
	briefing(3, 0x3003)

	beginobjective(0, L_PAM(5), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Reactivate teleportals"
		complete_flags(STAGEFLAG_TELEPORTALS_ACTIVATED)
	endobjective

	beginobjective(1, L_PAM(6), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Disable Cetan megaweapon"
		complete_flags(STAGEFLAG_MEGAWEAPON_DISABLED)
		fail_flags(STAGEFLAG_FARSIGHT_AMMO_WASTED)
	endobjective

	beginobjective(2, L_PAM(7), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Secure control room"
		complete_flags(STAGEFLAG_BLONDES_DEAD)
	endobjective

	beginobjective(3, L_PAM(8), (DIFFBIT_PA | DIFFBIT_PD)) // "Restore Dr. Caroll's personality"
		complete_flags(STAGEFLAG_DRCAROLL_RESTORED)
	endobjective

	beginobjective(4, L_PAM(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Escape from Cetan ship"
		complete_flags(STAGEFLAG_ESCAPED)
		fail_flags(STAGEFLAG_ALLY_DEAD)
		fail_flags(STAGEFLAG_TIMER_EXPIRED)
	endobjective

	chr(0x00000400, 0x40, 0x01b3, BODY_DDSNIPER, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 200, 0x00002000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0040, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)

#if VERSION >= VERSION_PAL_FINAL
	// ....... v
	chr(0x00010400, 0x00, 0x002e, BODY_THEKING, HEAD_ELVIS, GAILIST_IDLE, -1, -1, 1000, 200, 0x00002000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
#else
	chr(0x00010000, 0x00, 0x002e, BODY_THEKING, HEAD_ELVIS, GAILIST_IDLE, -1, -1, 1000, 200, 0x00002000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
#endif
	weapon(0x0100, MODEL_CHRZ2020, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FARSIGHTXR20, 0x00ffffff, 0x00000000)

	tag(0x73, -1)
	chr(0x00000200, 0x01, 0x018d, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 30, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x02, 0x019a, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x019b, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x0006, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x019c, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x06, 0x0190, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x0191, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x08, 0x0008, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x09, 0x000a, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 100, 100, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0a, 0x019d, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0421, -1, -1, 1000, 100, 0xc0008601, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x019e, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_INIT_PELAGIC_GUARD, -1, -1, 1000, 100, 0xc8080000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x009a, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_INIT_PELAGIC_GUARD, -1, -1, 1000, 100, 0xc8080000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x001e, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0422, -1, -1, 1000, 100, 0xe8080000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0e, 0x001b, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0423, -1, -1, 1000, 100, 0xe8080000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0f, 0x0022, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0425, -1, -1, 1000, 100, 0xe8080000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x10, 0x0021, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0424, -1, -1, 1000, 100, 0xe8080000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x002c, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_UNALERTED, 0x0027, -1, 3000, 10, 0x80028004, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x12, 0x0029, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, 0x0024, -1, 3000, 100, 0x80028204, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x13, 0x002b, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, 0x0026, -1, 3000, 100, 0x80028204, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x14, 0x01b3, BODY_DDSNIPER, HEAD_RANDOM, AILIST_CLOAK_AND_HIDE, 0x01b3, -1, 1000, 100, 0x80028004, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x01b4, BODY_DDSNIPER, HEAD_RANDOM, AILIST_CLOAK_AND_HIDE, 0x01b4, -1, 1000, 100, 0x80028004, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x01b5, BODY_DDSNIPER, HEAD_RANDOM, AILIST_CLOAK_AND_HIDE, 0x01b5, -1, 1000, 100, 0x80028004, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x25, 0x0064, BODY_MINISKEDAR, 0x00, AILIST_HIDE, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x26, 0x0079, BODY_MINISKEDAR, 0x00, AILIST_HIDE, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x27, 0x0067, BODY_MINISKEDAR, 0x00, AILIST_HIDE, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x28, 0x0075, BODY_MINISKEDAR, 0x00, AILIST_HIDE, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x29, 0x0080, BODY_MINISKEDAR, 0x00, AILIST_HIDE, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x2a, 0x0085, BODY_MINISKEDAR, 0x00, AILIST_HIDE, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x2b, 0x007c, BODY_MINISKEDAR, 0x00, AILIST_HIDE, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x000002c0, 0x17, 0x00c5, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0426, -1, -1, 100, 100, 0xc8090000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x18, 0x00c7, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0427, -1, -1, 100, 100, 0xc8090000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x19, 0x00cb, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0428, -1, -1, 100, 100, 0xc8090000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x1a, 0x01b8, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, -1, -1, 100, 100, 0xc8090000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x1b, 0x01b7, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, -1, -1, 100, 100, 0xc8090000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x1c, 0x00be, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0429, -1, -1, 100, 100, 0xc8090000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x1d, 0x01b9, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, -1, -1, 100, 100, 0xc0012000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x1e, 0x01ba, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, -1, -1, 100, 100, 0xc0012000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x1f, 0x01bb, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, -1, -1, 100, 100, 0xc0012000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000002c0, 0x20, 0x01bc, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, -1, -1, 100, 100, 0xc0012000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x22, 0x0192, BODY_MRBLONDE, HEAD_MRBLONDE, AILIST_BLONDE, -1, -1, 100, 100, 0xc8082000, 0x00000000, TEAM_ALLY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00010500, 0x24, 0x0193, BODY_DRCAROLL, 0x00, GAILIST_IDLE, -1, -1, 100, 100, 0xc8080000, 0x00000000, TEAM_ALLY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x23, 0x0194, BODY_MRBLONDE, HEAD_MRBLONDE, AILIST_BLONDE, -1, -1, 100, 100, 0xc8082000, 0x00000000, TEAM_ALLY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0023, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x2f, 0x01a6, BODY_MINISKEDAR, 0x00, AILIST_MINISKEDAR_UNALERTED, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000100, 0x30, 0x01a7, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000100, 0x31, 0x01a8, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000100, 0x32, 0x01a9, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000100, 0x33, 0x01aa, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000100, 0x34, 0x01ab, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000100, 0x35, 0x01ac, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x36, 0x01ad, BODY_MINISKEDAR, 0x00, AILIST_MINISKEDAR_UNALERTED, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x37, 0x01ae, BODY_MINISKEDAR, 0x00, AILIST_MINISKEDAR_UNALERTED, -1, -1, 1000, 12, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x38, 0x01af, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 11, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x39, 0x01b0, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 11, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x3a, 0x01b1, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 11, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x3b, 0x01b2, BODY_MINISKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 11, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x3c, 0x01c0, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 5, 0xe8080000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3d, 0x01c1, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 5, 0xe8080000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3e, 0x01c2, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 5, 0xe8080000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x3f, 0x0012, BODY_PELAGIC_GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 100, 30, 0x48080000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x003f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00004400, 0x21, 0x0117, BODY_SKEDAR, HEAD_RANDOM, AILIST_DEAD_SKEDAR, -1, -1, 100, 100, 0xc8090000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	tag(0x75, 1)
	door(0x0100, MODEL_CETANDOOR, 0x0157, 0x10000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00007333, 0x00006666, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xae, 1)
	door(0x0100, MODEL_CETANDOOR, 0x0156, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00007333, 0x00006666, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xab, 1)
	door(0x0100, MODEL_CETANDOOR, 0x015c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00007333, 0x00006666, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0158, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00007333, 0x00006666, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xb3, 2)
	tag(0xb4, 2)
	door(0x0100, MODEL_AL_AIRLOCK, 0x014b, 0x10000000, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00006666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AL_AIRLOCK, 0x014c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00006666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xb5, 2)
	tag(0xb6, 2)
	door(0x0100, MODEL_AL_AIRLOCK, 0x014d, 0x10000000, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00006666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AL_AIRLOCK, 0x014e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00006666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AL_AIRLOCK, 0x014f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000570a, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AL_AIRLOCK, 0x0150, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000570a, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AL_AIRLOCK, 0x0151, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00005c28, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AL_AIRLOCK, 0x0152, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00005c28, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x03, 3)
	tag(0x04, 3)
	tag(0x05, 3)
	door(0x0100, MODEL_CETANSMALLDOOR, 0x0153, 0x02000400, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000001, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANSMALLDOOR, 0x0155, 0x02000400, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000001, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANSMALLDOOR, 0x0154, 0x02000400, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000001, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x016f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x016e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOORSIDE, 0x0174, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000b333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOORSIDE, 0x0175, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000b333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xb7, 2)
	tag(0xb8, 2)
	door(0x0100, MODEL_CETANDOORSIDE, 0x0177, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000b333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOORSIDE, 0x0176, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000b333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOORSIDE, 0x0179, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000b333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOORSIDE, 0x0178, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000b333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0169, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x016a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x016b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xb1, 1)
	door(0x0100, MODEL_CETANDOOR, 0x016c, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x016d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x09, 1)
	door(0x0100, MODEL_CETANDOOR, 0x0159, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00009999, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x015a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00009999, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x015d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00009999, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x015b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00009999, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0b, 1)
	door(0x0100, MODEL_CETANDOOR, 0x015e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x015f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0160, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0161, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0162, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0163, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0164, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0165, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0d, 1)
	door(0x0100, MODEL_CETANDOOR, 0x0166, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CETANDOOR, 0x0167, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0f, 1)
	door(0x0100, MODEL_CETANDOOR, 0x0168, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000c000, 0x00035555, 0x00035555, 0x00000222, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001700, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x07, 1)
	lift(0x0100, MODEL_AL_DOCKLIFT, 0x0185, 0x03520508, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0185, 0x0186, 0x01870186, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x00085555, 0x15000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x00, 3)
	tag(0x01, 3)
	tag(0x02, 3)
	stdobject(0x00e6, MODEL_POWERNODE, 0x028d, 0x004005e1, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_POWERNODE, 0x028e, 0x004005e1, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_POWERNODE, 0x028f, 0x004005e1, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x08, 1)
	weapon(0x0180, MODEL_CHRBUG, 0xffff, 0x00000001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FARSIGHTXR20, 0x00ffffff, 0x00000000)
	tag(0x11, 4)
	tag(0x12, 4)
	tag(0x13, 4)
	tag(0x9c, 4)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0203, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0204, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0205, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0291, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x14, 4)
	tag(0x15, 4)
	tag(0x16, 4)
	tag(0x9d, 4)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0206, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0207, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0208, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0290, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x17, 4)
	tag(0x18, 4)
	tag(0x19, 4)
	tag(0x9e, 4)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0209, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x020a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x020b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0292, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1a, 4)
	tag(0x1b, 4)
	tag(0x1c, 4)
	tag(0x9f, 4)
	glass(0x0100, MODEL_CETANWINDOW1, 0x020c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x020d, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x020e, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0293, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1d, 4)
	tag(0x1e, 4)
	tag(0x1f, 4)
	tag(0xa0, 4)
	glass(0x0100, MODEL_CETANWINDOW1, 0x020f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0210, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW1, 0x0211, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0294, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x20, 12)
	tag(0x21, 12)
	tag(0x22, 12)
	tag(0x23, 12)
	tag(0x24, 12)
	tag(0x25, 12)
	tag(0x26, 12)
	tag(0x27, 12)
	tag(0x28, 12)
	tag(0x29, 12)
	tag(0x2a, 12)
	tag(0x2b, 12)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0212, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0213, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0214, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0215, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0216, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0217, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0218, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0219, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x021a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x021b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x021c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x021d, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0295, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xa1, -1)
	tag(0x2c, 12)
	tag(0x2d, 12)
	tag(0x2e, 12)
	tag(0x2f, 12)
	tag(0x30, 12)
	tag(0x31, 12)
	tag(0x32, 12)
	tag(0x33, 12)
	tag(0x34, 12)
	tag(0x35, 12)
	tag(0x36, 12)
	tag(0x37, 12)
	glass(0x0100, MODEL_CETANWINDOW2, 0x021e, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x021f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0220, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0221, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0222, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0223, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0224, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0225, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0226, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0227, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0228, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0229, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0296, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xa2, -1)
	tag(0x38, 12)
	tag(0x39, 12)
	tag(0x3a, 12)
	tag(0x3b, 12)
	tag(0x3c, 12)
	tag(0x3d, 12)
	tag(0x3e, 12)
	tag(0x3f, 12)
	tag(0x40, 12)
	tag(0x41, 12)
	tag(0x42, 12)
	tag(0x43, 12)
	glass(0x0100, MODEL_CETANWINDOW2, 0x022a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x022b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x022c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x022d, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x022e, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x022f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0230, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0231, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0232, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0233, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0234, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0235, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0297, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xa3, -1)
	tag(0x44, 12)
	tag(0x45, 12)
	tag(0x46, 12)
	tag(0x47, 12)
	tag(0x48, 12)
	tag(0x49, 12)
	tag(0x4a, 12)
	tag(0x4b, 12)
	tag(0x4c, 12)
	tag(0x4d, 12)
	tag(0x4e, 12)
	tag(0x4f, 12)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0236, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0237, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0238, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0239, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x023a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x023b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x023c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x023d, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x023e, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x023f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0240, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0241, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0298, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xa4, -1)
	tag(0x50, 12)
	tag(0x51, 12)
	tag(0x52, 12)
	tag(0x52, 12)
	tag(0x53, 12)
	tag(0x54, 12)
	tag(0x55, 12)
	tag(0x56, 12)
	tag(0x57, 12)
	tag(0x58, 12)
	tag(0x59, 12)
	tag(0x5a, 12)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0242, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0243, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0244, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0245, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0246, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0247, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0248, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0249, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x024a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x024b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x024c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x024d, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0299, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xa5, -1)
	chr(0x00000100, 0x41, 0x024e, BODY_MINISKEDAR, HEAD_MRBLONDE, GAILIST_IDLE, -1, -1, 100, 100, 0xc8082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0F, -1, 0, 0x00000000)
	chr(0x00000100, 0x42, 0x025a, BODY_MINISKEDAR, HEAD_MRBLONDE, GAILIST_IDLE, -1, -1, 100, 100, 0xc8082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0F, -1, 0, 0x00000000)
	tag(0x5b, 12)
	tag(0x5c, 12)
	tag(0x5d, 12)
	tag(0x5e, 12)
	tag(0x5f, 12)
	tag(0x60, 12)
	tag(0x61, 12)
	tag(0x62, 12)
	tag(0x63, 12)
	tag(0x64, 12)
	tag(0x65, 12)
	tag(0x66, 12)
	glass(0x0100, MODEL_CETANWINDOW2, 0x024e, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x024f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0250, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0251, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0252, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0253, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0254, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0255, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0256, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0257, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0258, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0259, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x029a, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xa6, -1)
	tag(0x67, 12)
	tag(0x68, 12)
	tag(0x69, 12)
	tag(0x6a, 12)
	tag(0x6b, 12)
	tag(0x6c, 12)
	tag(0x6d, 12)
	tag(0x6e, 12)
	tag(0x6f, 12)
	tag(0x70, 12)
	tag(0x71, 12)
	tag(0x72, 12)
	glass(0x0100, MODEL_CETANWINDOW2, 0x025a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x025b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x025c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x025d, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x025e, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x025f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0260, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0261, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0262, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0263, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW2, 0x0264, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_CETANWINDOW3, 0x0265, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x029b, 0x012404e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xa7, -1)
	tag(0xa8, 1)
	autogun(0x0100, MODEL_CETROOFGUN, 0x0188, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00e40000, 0x00000000, 0x00020000, 0xfffe0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00640000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xa9, 1)
	autogun(0x0100, MODEL_CETROOFGUN, 0x0189, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00f80000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00640000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0xaa, 1)
	autogun(0x0100, MODEL_CETROOFGUN, 0x018a, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00e40000, 0x00000000, 0x00008000, 0xffff8000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00640000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0266, 0x14020b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0xbb, 1)
	stdobject(0x0040, MODEL_ZIGGYCARD, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x74, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_BACKUPDISK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x44, L_PAM(23), L_PAM(24), L_PAM(25), L_PAM(26), L_PAM(27), 0x0000, 0x0000) // ""
	tag(0x76, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x77, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x78, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x79, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x7a, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x7b, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x7c, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x7d, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x7e, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x7f, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x80, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x81, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x82, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x83, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x84, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x85, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x86, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x87, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x88, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x89, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8a, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8b, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8c, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8d, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8e, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8f, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x90, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x91, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x92, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x93, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x94, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x95, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x96, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x97, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x98, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x99, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x9a, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x9b, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0xac, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0012, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0xad, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x001a, 0x00004001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0xb0, 1)
	weapon(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0008, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PROXIMITYMINE, 0x00ffffff, 0x00000000)
	endprops
};

s32 intro[] = {
	intro_weapon(WEAPON_FALCON2_SCOPE, -1)
	ammo(AMMOTYPE_PISTOL, 50)
	ammo(AMMOTYPE_PROXY_MINE, 2)
	intro_weapon(WEAPON_SHOTGUN, -1)
	ammo(AMMOTYPE_SHOTGUN, 100)
	ammo(AMMOTYPE_FARSIGHT, 50)
	intro_weapon(WEAPON_IRSCANNER, -1)
	spawn(0x018b)
	outfit(OUTFIT_DEEPSEA)
	endintro
};

s32 path02[] = {
	0x0099,
	0x0098,
	0x000e,
	0x000d,
	0x000c,
	-1,
};

s32 path03[] = {
	0x001e,
	0x0096,
	0x0095,
	-1,
};

s32 path04[] = {
	0x001b,
	0x001a,
	0x001c,
	0x001d,
	-1,
};

s32 path05[] = {
	0x0021,
	0x0020,
	0x001f,
	-1,
};

s32 path06[] = {
	0x0022,
	0x001a,
	0x001c,
	-1,
};

s32 path07[] = {
	0x00c4,
	0x00c5,
	0x00c6,
	0x00c7,
	-1,
};

s32 path08[] = {
	0x00c7,
	0x00c8,
	-1,
};

s32 path09[] = {
	0x00cb,
	0x00cc,
	-1,
};

s32 path10[] = {
	0x00be,
	0x00bf,
	0x00c1,
	-1,
};

u8 func0401_unused[] = {
	dprint 'h','o','v','\n',0,
	begin_hovercar_path(0x00)
	set_vehicle_speed(384, 120)

	beginloop(0x04)
	endloop(0x04)

	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func040b_init_elvis[] = {
	set_self_chrflag(CHRCFLAG_00080000)
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_01000000)
	set_accuracy(100)
	set_reaction_speed(100)
	set_alertness(100)
	set_chr_maxdamage(CHR_SELF, 1)
	add_health_or_armor(900)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	endlist
};

u8 func0402_elvis_follow_and_reactive_teleportals[] = {
	dprint 'B','A','C','K',' ','T','O',' ','E','L','V','I','S','\n',0,
	set_returnlist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	set_shotlist(AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Injured
	label(0x2e)
	if_sound_finished(CHANNEL_6, /*goto*/ 0x2f)
	goto_next(0x12)

	label(0x2f)
	say_quip(CHR_BOND, 0x29, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x12)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x12)

	// Not injured
	label(0x06)
	if_self_flag_bankx_eq(CHRFLAG1_00000001, TRUE, BANK_1, /*goto*/ 0x2e)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	goto_next(0x06)

	// Has flag
	label(0x2e)
	if_enemy_distance_lt_and_los(100, /*goto*/ 0x08)

	// No enemy nearby
	label(0x06)
	set_target_chr(CHR_PRESET)
	if_distance_to_target_lt(200, /*goto*/ 0x06)

	// Jo distance >= 200
	label(0x03)
	dprint 'G','O','T','O','W','\n',0,
	set_target_chr(CHR_PRESET)
	restart_timer
	if_distance_to_target_gt(300, /*goto*/ 0x06)
	try_jog_to_target(/*goto*/ 0x04)

	// Jo distance < 200 or distance > 300
	label(0x06)
	try_run_to_target(/*goto*/ 0x04)

	beginloop(0x04)
		if_self_flag_bankx_eq(CHRFLAG1_00000001, TRUE, BANK_1, /*goto*/ 0x2e)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		goto_next(0x06)
		label(0x2e)
		if_enemy_distance_lt_and_los(100, /*goto*/ 0x08)
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_TELEPORTALS_ACTIVATED, TRUE, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x003c, /*goto*/ 0x5f)
		label(0x2e)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_lt(200, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	goto_first(0x03)

	// Waiting next to Jo?
	label(0x06)
	stop_chr

	beginloop(0x09)
		if_self_flag_bankx_eq(CHRFLAG1_00000001, TRUE, BANK_1, /*goto*/ 0x2e)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		goto_next(0x06)
		label(0x2e)
		if_enemy_distance_lt_and_los(100, /*goto*/ 0x08)
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_TELEPORTALS_ACTIVATED, TRUE, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x003c, /*goto*/ 0x5f)
		label(0x2e)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_gt(300, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x03)

	// Enemy detected
	label(0x08)
	yield
	if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	goto_next(0x2e)
	label(0x06)
	call_rng
	if_rand_lt(85, /*goto*/ 0x63)
	if_rand_lt(170, /*goto*/ 0x64)

	say_quip(CHR_BOND, 0x26, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)

	label(0x63)
	say_quip(CHR_BOND, 0x27, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)

	label(0x64)
	say_quip(CHR_BOND, 0x28, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	label(0x2e)
	set_shotlist(AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	set_returnlist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	// In teleport control room
	label(0x5f)
	stop_chr
	speak(CHR_TARGET, L_PAM(29), 0x14eb, CHANNEL_6, COLOR_04_ORANGE) // "Time to reactivate those teleportals."
	jog_to_pad(0x01c3)

	beginloop(0x0f)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x0f)

	label(0x6f)
	label(0x2e)
	unset_self_chrflag(CHRCFLAG_01000000)
	chr_do_animation(ANIM_OPERATE_0204, -1, -1, 0x02, 0x10, CHR_SELF, 2)

	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	say_quip(CHR_BOND, 0x2c, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	show_hudmsg(CHR_BOND, L_PAM(30)) // "Teleportals have been reactivated."
	set_stage_flag(STAGEFLAG_TELEPORTALS_ACTIVATED)
	set_self_chrflag(CHRCFLAG_01000000)
	play_sound(0x8148, -1)
	set_lights_state(0x003c, 0x04, 0x00, 0xff, 0xb4)
	set_chr_chrflag(0x14, CHRCFLAG_00040000)
	set_chr_chrflag(0x15, CHRCFLAG_00040000)
	set_chr_chrflag(0x16, CHRCFLAG_00040000)
	unset_chr_chrflag(0x14, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x15, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x16, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x14, AILIST_TELEPORT_ACTIVATION_RESPONDER)
	set_ailist(0x15, AILIST_TELEPORT_ACTIVATION_RESPONDER)
	set_ailist(0x16, AILIST_TELEPORT_ACTIVATION_RESPONDER)
	goto_first(0x03)

	label(0x60)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	endlist
};

u8 func0433_unused[] = {
	beginloop(0x04)
		set_target_chr(CHR_BOND)
		if_within_units_of_sight(30, /*goto*/ 0x06)
		set_target_chr(CHR_COOP)
		if_within_units_of_sight(30, /*goto*/ 0x06)
		set_target_chr(CHR_ANTI)
		if_within_units_of_sight(30, /*goto*/ 0x06)
		goto_next(0x2e)

		label(0x06)
	endloop(0x04)

	label(0x2e)
	unset_self_flag_bankx(CHRFLAG0_UNSURPRISABLE, BANK_0)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * This is also assigned to Elvis on PA, but in that case it's a general follow
 * function because he can't enter the agent megaweapon room on PA.
 */
u8 func0404_elvis_follow_and_do_agent_megaweapon[] = {
	set_self_chrflag(CHRCFLAG_00080000)
	unset_self_flag_bankx(CHRFLAG1_00200000, BANK_1)
	set_shotlist(AILIST_ELVIS_FOLLOW_AND_DO_AGENT_MEGAWEAPON)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Injured
	label(0x2e)
	say_quip(CHR_BOND, 0x29, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x12)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x12)

	// Healthy
	label(0x06)
	if_stage_flag_eq(STAGEFLAG_AGENT_MEGAWEAPON_DISABLED, TRUE, /*goto*/ 0x2e)
	if_stage_flag_eq(STAGEFLAG_ELVIS_SAID_SABOTAGE, TRUE, /*goto*/ 0x5f)
	label(0x2e)
	if_enemy_distance_lt_and_los(2000, /*goto*/ 0x08)
	set_target_chr(CHR_PRESET)
	if_distance_to_target_lt(200, /*goto*/ 0x06)
	label(0x03)
	set_target_chr(CHR_PRESET)
	restart_timer
	if_distance_to_target_gt(300, /*goto*/ 0x06)
	try_jog_to_target(/*goto*/ 0x04)
	label(0x06)
	try_run_to_target(/*goto*/ 0x04)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_AGENT_MEGAWEAPON_DISABLED, TRUE, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x006c, /*goto*/ 0x1d)
		label(0x2e)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2000, /*goto*/ 0x08)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_lt(200, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	goto_first(0x03)

	label(0x06)
	stop_chr

	beginloop(0x09)
		dprint 'B','4',' ','P','A','D','\n',0,
		if_stage_flag_eq(STAGEFLAG_AGENT_MEGAWEAPON_DISABLED, TRUE, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x006c, /*goto*/ 0x1d)
		label(0x2e)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2000, /*goto*/ 0x08)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_gt(300, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x03)

	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	call_rng
	if_rand_lt(85, /*goto*/ 0x63)
	if_rand_lt(170, /*goto*/ 0x64)

	say_quip(CHR_BOND, 0x26, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)

	label(0x63)
	say_quip(CHR_BOND, 0x27, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)

	label(0x64)
	say_quip(CHR_BOND, 0x28, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)

	label(0x2e)
	set_shotlist(AILIST_ELVIS_FOLLOW_AND_DO_AGENT_MEGAWEAPON)
	set_returnlist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_DO_AGENT_MEGAWEAPON)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	// In Agent megaweapon room
	label(0x1d)
	speak(CHR_TARGET, L_PAM(28), 0x14ec, CHANNEL_6, COLOR_04_ORANGE) // "It looks like this could benefit from a little bit..."
	label(0x5f)
	set_stage_flag(STAGEFLAG_ELVIS_SAID_SABOTAGE)
	stop_chr
	jog_to_pad(0x005f)

	beginloop(0x0f)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x0f)

	label(0x6f)
	label(0x2e)
	unset_self_chrflag(CHRCFLAG_01000000)
	restart_timer
	chr_do_animation(ANIM_OPERATE_0205, -1, -1, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	say_quip(CHR_BOND, 0x2c, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	set_self_chrflag(CHRCFLAG_01000000)
	show_hudmsg(CHR_BOND, L_PAM(20)) // "Cetan megaweapon has been disabled."
	set_stage_flag(STAGEFLAG_AGENT_MEGAWEAPON_DISABLED)
	set_stage_flag(STAGEFLAG_MEGAWEAPON_DISABLED)
	set_lights_state(0x006c, 0x03, 0x64, 0xff, 0x78)
	assign_sound(0x8148, CHANNEL_7)
	play_sound_from_entity(CHANNEL_7, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	unlock_door(0xb7, 0x02)
	unlock_door(0xb8, 0x02)
	goto_first(0x03)

	label(0x60)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_DO_AGENT_MEGAWEAPON)
	endlist
};

/**
 * Seems to be a general follow function for Elvis.
 * He does not engage in combat.
 *
 * @unused
 */
u8 func0405_elvis_follow_nocombat[] = {
	set_self_chrflag(CHRCFLAG_00080000)
	unset_self_flag_bankx(CHRFLAG1_00200000, BANK_1)
	set_shotlist(0x0405)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Injured
	label(0x2e)
	say_quip(CHR_BOND, 0x29, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x12)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x12)

	label(0x06)
	if_enemy_distance_lt_and_los(300, /*goto*/ 0x08)
	set_target_chr(CHR_PRESET)
	if_distance_to_target_lt(200, /*goto*/ 0x06)
	label(0x03)
	set_target_chr(CHR_PRESET)
	restart_timer
	if_distance_to_target_gt(300, /*goto*/ 0x06)
	try_jog_to_target(/*goto*/ 0x04)
	label(0x06)
	try_run_to_target(/*goto*/ 0x04)

	beginloop(0x04)
		label(0x2e)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(300, /*goto*/ 0x08)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_lt(200, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	goto_first(0x03)

	label(0x06)
	stop_chr

	beginloop(0x09)
		dprint 'B','4',' ','P','A','D','\n',0,
		label(0x2e)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2000, /*goto*/ 0x08)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_gt(300, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x03)

	// Detected enemy
	label(0x08)
	restart_timer
	say_quip(CHR_BOND, 0x29, 0xff, 0x14, 0xff, BANK_1, 0x00, 0x00)
	retreat(SPEED_RUN, 1)

	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x2e)
	endloop(0x09)

	label(0x2e)
	goto_first(0x03)

	endlist
};

u8 func0406_elvis_follow_and_do_sa_megaweapon[] = {
	set_shotlist(AILIST_ELVIS_FOLLOW_AND_DO_SA_MEGAWEAPON)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x5f)

	// Injured
	label(0x2e)
	say_quip(CHR_BOND, 0x29, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x12)
		if_chr_stopped(/*goto*/ 0x5f)
	endloop(0x12)

	label(0x5f)
	if_stage_flag_eq(STAGEFLAG_ELVIS_STARTED_SA_MEGAWEAPON, TRUE, /*goto*/ 0x1b)
	restart_timer
	if_distance_to_target_lt(400, /*goto*/ 0x2e)
	jog_to_pad(0x00b4)
	goto_next(0x0f)

	label(0x2e)
	label(0x1c)
	run_to_pad(0x00b4)

	beginloop(0x0f)
		if_timer_gt(300, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x0f)

	label(0x06)
	goto_first(0x5f)

	label(0x2e)
	restart_timer
	try_face_entity(0x0008, 0x0115, /*goto*/ 0x97)

	beginloop(0x97)
		if_timer_gt(60, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x97)

	label(0x06)
	restart_timer

	label(0x1b)
	set_stage_flag(STAGEFLAG_ELVIS_STARTED_SA_MEGAWEAPON)
	unset_self_chrflag(CHRCFLAG_01000000)
	call_rng
	if_rand_lt(86, /*goto*/ 0x63)
	if_rand_lt(172, /*goto*/ 0x64)

	chr_do_animation(ANIM_OPERATE_0204, -1, -1, 0x02, 0x10, CHR_SELF, 2)
	goto_next(0x11)

	label(0x63)
	chr_do_animation(ANIM_OPERATE_0205, -1, -1, 0x02, 0x10, CHR_SELF, 2)
	goto_next(0x11)

	label(0x64)
	chr_do_animation(ANIM_OPERATE_0206, -1, -1, 0x02, 0x10, CHR_SELF, 2)
	goto_next(0x11)

	beginloop(0x11)
		if_chr_idle(/*goto*/ 0x2e)
		goto_next(0x06)

		label(0x2e)
		if_timer_gt(3600, /*goto*/ 0x2e)
	endloop(0x11)

	label(0x06)
	goto_first(0x1b)

	label(0x2e)
	say_quip(CHR_BOND, 0x2c, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	set_self_chrflag(CHRCFLAG_01000000)
	show_hudmsg(CHR_BOND, L_PAM(20)) // "Cetan megaweapon has been disabled."
	set_stage_flag(STAGEFLAG_MEGAWEAPON_DISABLED)
	try_equip_weapon(MODEL_CHRMAIANPISTOL, WEAPON_PHOENIX, 0x00000000, /*goto*/ 0x04)
	label(0x04)
	set_ailist(CHR_SELF, AILIST_ELVIS_GO_TO_SA_TELEPORT)
	goto_first(0x03)

	label(0x60)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_DO_SA_MEGAWEAPON)
	endlist
};

u8 func0407_elvis_go_to_sa_teleport[] = {
	set_shotlist(AILIST_ELVIS_GO_TO_SA_TELEPORT)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x5f)

	// Injured
	label(0x2e)
	say_quip(CHR_BOND, 0x29, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x12)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x12)

	label(0x06)
	set_target_chr(CHR_PRESET)
	label(0x5f)
	restart_timer
	if_distance_to_target_lt(1400, /*goto*/ 0x2e)
	jog_to_pad(0x00c0)
	goto_next(0x0f)

	label(0x2e)
	run_to_pad(0x00c0)

	beginloop(0x0f)
		if_enemy_distance_lt_and_los(800, /*goto*/ 0x08)
		if_timer_gt(300, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x0f)

	label(0x06)
	goto_first(0x5f)

	label(0x2e)
	stop_chr

	beginloop(0x10)
		if_enemy_distance_lt_and_los(800, /*goto*/ 0x08)
	endloop(0x10)

	label(0x06)
	restart_timer
	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	call_rng
	if_rand_lt(85, /*goto*/ 0x63)
	if_rand_lt(170, /*goto*/ 0x64)
	say_quip(CHR_BOND, 0x26, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)

	label(0x63)
	say_quip(CHR_BOND, 0x27, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)

	label(0x64)
	say_quip(CHR_BOND, 0x28, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	label(0x2e)
	set_shotlist(AILIST_ELVIS_GO_TO_SA_TELEPORT)
	set_returnlist(CHR_SELF, AILIST_ELVIS_GO_TO_SA_TELEPORT)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func0403_elvis_give_farsight[] = {
	set_shotlist(AILIST_ELVIS_GIVE_FARSIGHT)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Injured
	label(0x2e)
	say_quip(CHR_BOND, 0x29, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x12)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x12)

	// Healthy
	label(0x06)
	set_target_chr(CHR_PRESET)
	if_distance_to_target_lt(200, /*goto*/ 0x06)

	label(0x03)
	set_target_chr(CHR_PRESET)
	restart_timer
	if_distance_to_target_gt(300, /*goto*/ 0x06)
	try_jog_to_target(/*goto*/ 0x04)
	label(0x06)
	try_run_to_target(/*goto*/ 0x04)

	beginloop(0x04)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		set_target_chr(CHR_PRESET)
		if_distance_to_target_lt(200, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	goto_first(0x03)

	label(0x06)
	stop_chr
	label(0x09)
	do_preset_animation(5)
	speak(CHR_TARGET, L_PAM(18), 0x12ea, CHANNEL_6, COLOR_04_ORANGE) // "Here, take this gun and keep those Skedar off my b..."
	give_object_to_chr(0x73, CHR_TARGET)
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_MINISKEDAR_SPAWNING)

	beginloop(0x0a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)

	// PA
	unset_self_flag_bankx(CHRFLAG1_00200000, BANK_1)
	yield
	try_equip_weapon(MODEL_CHRMAIANPISTOL, WEAPON_PHOENIX, 0x00000000, /*goto*/ 0x2f)
	label(0x2f)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_DO_AGENT_MEGAWEAPON)

	// SA
	label(0x06)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_DO_SA_MEGAWEAPON)

	// Agent
	label(0x2e)
	yield
	try_equip_weapon(MODEL_CHRMAIANPISTOL, WEAPON_PHOENIX, 0x00000000, /*goto*/ 0x2e)
	label(0x2e)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW_AND_DO_AGENT_MEGAWEAPON)
	endlist
};

u8 func1003_powernode1[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_POWERNODE1, /*goto*/ 0x2e)
		if_door_state(0x03, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		open_door(0x03)
	endloop(0x04)

	label(0x2e)
	if_object_health_lt(OBJ_POWERNODE1, 250, /*goto*/ 0x2e)
	set_object_health(OBJ_POWERNODE1, 0)
	set_object_flag(OBJ_POWERNODE1, OBJFLAG_INVINCIBLE)
	open_door(0x03)
	set_object_flag(0x03, OBJFLAG_40000000)
	goto_first(0x04)

	label(0x2e)
	goto_first(0x04)
	endlist
};

u8 func1004_powernode2[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_POWERNODE2, /*goto*/ 0x2e)
		if_door_state(0x04, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		open_door(0x04)
	endloop(0x04)

	label(0x2e)
	if_object_health_lt(OBJ_POWERNODE2, 250, /*goto*/ 0x2e)
	set_object_health(OBJ_POWERNODE2, 0)
	set_object_flag(OBJ_POWERNODE2, OBJFLAG_INVINCIBLE)
	open_door(0x04)
	set_object_flag(0x04, OBJFLAG_40000000)
	goto_first(0x04)

	label(0x2e)
	goto_first(0x04)
	endlist
};

u8 func1005_powernode3[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_POWERNODE3, /*goto*/ 0x2e)
		if_door_state(0x05, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		open_door(0x05)
	endloop(0x04)

	label(0x2e)
	if_object_health_lt(OBJ_POWERNODE3, 250, /*goto*/ 0x2e)
	set_object_flag(OBJ_POWERNODE3, OBJFLAG_INVINCIBLE)
	set_object_health(OBJ_POWERNODE3, 0)
	open_door(0x05)
	set_object_flag(0x05, OBJFLAG_40000000)
	goto_first(0x04)

	label(0x2e)
	goto_first(0x04)
	endlist
};

u8 func0c01_midcutscene[] = {
	remove_weapon_from_inventory(WEAPON_BACKUPDISK)
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 15)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	set_music_track(MUSIC_DEEPSEA_MIDCUTSCENE)
	camera_movement(0x01d4)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x01d5, -1, -1, 0x06, 0x00, CHR_P1P2, 4)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x01d6, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)
	set_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_DRCAROLL, CHRHFLAG_00020000)
	chr_do_animation(0x01d7, -1, -1, 0x06, 0x00, CHR_DRCAROLL, 4)
	show_object(0xbb)
	set_object_flag2(0xbb, OBJFLAG2_04000000)
	set_object_flag3(0xbb, OBJFLAG3_00000010)
	object_do_animation(0x01d8, 0xbb, 0x04, 0xffff)
	restart_timer
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	show_nonessential_chrs(FALSE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x57) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	#define wait_until_with_images(time, loopid, image1, image2) \
		beginloop(loopid) \
			set_drcaroll_images(CHR_DRCAROLL, image1, image2) \
			if_controller_button_pressed(/*goto*/ 0x57) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_until(114, 0x63)
	speak(CHR_BOND, L_PAM(35), 0x746d, CHANNEL_10, COLOR_09_BLUE) // "Here goes. I just hope dataDyne haven't done anyth..."

	wait_until(300, 0x64)
	play_sound(0x0171, CHANNEL_2)

	wait_until(378, 0x65)
	play_sound(0x04fc, CHANNEL_3)

	wait_until(408, 0x6a)
	play_sound(0x0423, CHANNEL_5)

	wait_until(440, 0x1a)
	play_sound(0x04f7, CHANNEL_10)

	wait_until(490, 0x6b)
	speak(CHR_BOND, L_PAM(36), 0x746e, CHANNEL_10, COLOR_04_ORANGE) // "Virus detected."

	wait_until(570, 0x69)

	label(0x6c)
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESFROWNING, DRCAROLLIMAGE_X)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_X, DRCAROLLIMAGE_EYESFROWNING)
	yield
	if_controller_button_pressed(/*goto*/ 0x57)
	if_timer_gt(600, /*goto*/ 0x06)
	goto_first(0x6c)

	label(0x06)
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESFROWNING, DRCAROLLIMAGE_EYESFROWNING)
	speak(CHR_BOND, L_PAM(37), 0x746f, CHANNEL_10, COLOR_09_BLUE) // "Me and my big mouth."

	wait_until(700, 0x6d)
	play_sound(0x0172, CHANNEL_6)

	wait_until(712, 0x6f)
	play_sound(0x04f8, CHANNEL_2)

	wait_until(716, 0x70)
	play_sound(0x0127, CHANNEL_3)

	label(0x71)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_RANDOM25, DRCAROLLIMAGE_RANDOM25)
	if_controller_button_pressed(/*goto*/ 0x57)
	if_timer_gt(742, /*goto*/ 0x06)
	goto_first(0x71)

	label(0x06)
	speak(CHR_BOND, L_PAM(38), 0x7470, CHANNEL_10, COLOR_04_ORANGE) // "Commencing countermeasures. Commenc..... *** ooOOo..."

	wait_until_with_images(746, 0x73, DRCAROLLIMAGE_EYESFROWNING, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0128, CHANNEL_5)

	wait_until_with_images(760, 0x75, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(764, 0x76, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESFROWNING)
	play_sound(0x0173, CHANNEL_2)

	wait_until_with_images(784, 0x79, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0174, CHANNEL_5)

	wait_until_with_images(808, 0x7c, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESFROWNING)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(872, 0x81, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	play_sound(0x04fa, CHANNEL_7)

	wait_until_with_images(886, 0x83, 0x00, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0129, CHANNEL_3)

	wait_until_with_images(894, 0x85, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESFROWNING)
	play_sound(0x012a, CHANNEL_5)
	label(0x86)

	wait_until_with_images(914, 0x87, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(980, 0x8b, 0x00, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(992, 0x8e, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x04f9, CHANNEL_2)

	wait_until_with_images(1012, 0x90, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	play_sound(0x012b, CHANNEL_4)

	wait_until_with_images(1018, 0x91, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1026, 0x93, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0129, CHANNEL_7)

	wait_until_with_images(1034, 0x94, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x0176, CHANNEL_2)
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_EYESDEFAULT)

	wait_until_with_images(1036, 0x95, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1068, 0x98, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x0177, CHANNEL_6)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1074, 0x99, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1090, 0xfc, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1112, 0x9e, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0127, CHANNEL_6)

	wait_until_with_images(1124, 0xa0, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x04f7, CHANNEL_2)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1130, 0xa1, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	play_sound(0x04ff, CHANNEL_3)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1188, 0xa7, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1238, 0xaa, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x04f7, CHANNEL_6)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1304, 0xb2, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0129, CHANNEL_2)

	wait_until_with_images(1308, 0xb3, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0178, CHANNEL_3)

	wait_until_with_images(1354, 0xba, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x04f7, CHANNEL_4)

	wait_until_with_images(1406, 0xc5, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1468, 0xcd, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	play_sound(0x012b, CHANNEL_5)

	wait_until_with_images(1480, 0xcf, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	play_sound(0x0173, CHANNEL_6)

	wait_until_with_images(1487, 0xd0, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x04f9, CHANNEL_2)
	emit_sparks(CHR_DRCAROLL)

	wait_until_with_images(1494, 0xd1, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	play_sound(0x0171, CHANNEL_3)

	wait_until_with_images(1500, 0xd4, DRCAROLLIMAGE_RANDOM, DRCAROLLIMAGE_EYESDEFAULT)
	speak(CHR_BOND, L_PAM(39), 0x7471, CHANNEL_10, COLOR_09_BLUE) // "Dr. Caroll? Are you in control again? Can you stop..."
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_EYESDEFAULT)

	wait_until(1534, 0xd6)
	play_sound(0x04f9, CHANNEL_6)

	wait_until(1564, 0xda)
	play_sound(0x0178, CHANNEL_5)

	wait_until(1630, 0xe0)
	play_sound(0x0175, CHANNEL_5)

	wait_until(1810, 0xe3)
	speak(CHR_BOND, L_PAM(40), 0x7472, CHANNEL_10, COLOR_04_ORANGE) // "Yes, I'm back again, my dear. But the program has ..."

	wait_until(1810, 0xe5)
	play_sound(0x0177, CHANNEL_3)

	wait_until(1886, 0xe7)
	play_sound(0x0175, CHANNEL_5)

	wait_until(2378, 0xe9)
	mute_channel(CHANNEL_7)
	speak(CHR_BOND, L_PAM(41), 0x7473, CHANNEL_10, COLOR_09_BLUE) // "What do you mean?"

	wait_until(2510, 0xea)
	speak(CHR_BOND, L_PAM(42), 0x7474, CHANNEL_10, COLOR_04_ORANGE) // "When the program has run, I will have control of a..."

	wait_until(3126, 0xf5)
	play_sound(0x012b, CHANNEL_5)

	wait_until(3156, 0xf6)
	emit_sparks(CHR_DRCAROLL)

	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_EYESDEFAULT)

	wait_until(3266, 0xf7)
	emit_sparks(CHR_DRCAROLL)

	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_EYESDEFAULT)

	wait_until(3556, 0xf8)

	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_EYESDEFAULT)
	emit_sparks(CHR_DRCAROLL)

	wait_until(3606, 0xf9)
	emit_sparks(CHR_DRCAROLL)

	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_EYESDEFAULT)

	wait_until(3985, 0x10)
	play_sound(0x0424, CHANNEL_1)

	wait_until(4046, 0xfa)
	emit_sparks(CHR_DRCAROLL)

	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_RANDOM)
	yield
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESDEFAULT, DRCAROLLIMAGE_EYESDEFAULT)

	wait_until(4106, 0xfb)
	emit_sparks(CHR_DRCAROLL)

	label(0x11)
	yield
	if_controller_button_pressed(/*goto*/ 0x57)
	if_timer_gt(4250, /*goto*/ 0x06)
	mute_channel(CHANNEL_1)
	goto_first(0x11)

	label(0x06)
	fade_to_color(0x000000ff, 250)

	wait_until(4500, 0x12)
	play_sound(0x012b, CHANNEL_5)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x57)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x57)
		label(0x2e)
	endloop(0x08)

	label(0x57)
	mute_channel(CHANNEL_10)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_4)
	mute_channel(CHANNEL_3)
	mute_channel(CHANNEL_2)
	mute_channel(CHANNEL_1)
	mute_channel(CHANNEL_0)
	fade_to_color(0xffffffff, 0)
	fade_to_color(0x00000000, 15)
	hide_object(0xbb)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x01d5, -2, -1, 0x06, 0x00, CHR_P1P2, 2)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x01d6, -2, -1, 0x06, 0x00, CHR_ELVIS, 2)
	unset_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_DRCAROLL, CHRHFLAG_00020000)
	chr_do_animation(0x01d7, -2, -1, 0x06, 0x00, CHR_DRCAROLL, 2)
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_ELVIS, WEAPON_PHOENIX, WEAPON_NONE)
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	yield
	chr_move_to_pad(CHR_ELVIS, 0x0013, 0x01, /*goto*/ 0x2e)
	label(0x2e)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_move_to_pad(CHR_BOND, 0x019f, 0x01, /*goto*/ 0x2e)
	label(0x2e)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	restart_default_music
	reset_ambience
	play_x_music(CHANNEL_10, 60)
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	chr_move_to_pad(CHR_ELVIS, 0x0017, 0x01, /*goto*/ 0x2e)
	label(0x2e)
	remove_weapon_from_inventory(WEAPON_BACKUPDISK)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_WARP_TO_OUTSIDE_DRCAROLL)
	show_nonessential_chrs(TRUE)
	set_stage_flag(STAGEFLAG_MIDCUTSCENE_FINISHED)
	set_ailist(CHR_SELF, GAILIST_END_CINEMA)
	endlist
};

u8 func042d_elvis_warp_to_outside_drcaroll[] = {
	stop_chr

	beginloop(0x04)
		dprint 'T','E','L','E','P','O','R','T',' ','F','A','I','L','E','D','\n',0,
		chr_move_to_pad(CHR_ELVIS, 0x0017, 0x01, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	dprint 'T','E','L','E','P','O','R','T',' ','G','O','O','D','\n',0,
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	stop_chr
	set_ailist(CHR_SELF, AILIST_ELVIS_RUN_TO_EXIT)
	endlist
};

u8 func0c02_outro[] = {
	show_nonessential_chrs(FALSE)
	hide_countdown_timer
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_DEEPSEA_OUTRO)
	camera_movement(0x02d7)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	restart_timer

	// @bug: Missing button checks makes the outro unskippable until a certain
	// point.
	#define blow_mine1(time, loopid, msg, mine, pad) \
		beginloop(loopid) \
			if_timer_gt(time, /*goto*/ 0x2e) \
		endloop(loopid) \
		label(0x2e) \
		dprint msg, '\n', 0, \
		show_object(mine) \
		yield \
		move_object_to_pad(mine, pad) \
		yield \
		destroy_object(mine)

	#define blow_mine2(time, loopid, msg1, msg2, mine, pad) \
		beginloop(loopid) \
			if_timer_gt(time, /*goto*/ 0x2e) \
		endloop(loopid) \
		label(0x2e) \
		dprint msg1, msg2, '\n', 0, \
		show_object(mine) \
		yield \
		move_object_to_pad(mine, pad) \
		yield \
		destroy_object(mine)

	blow_mine1(40,  0x63, '1', 0x76, 0x028c)
	blow_mine1(72,  0x64, '2', 0x77, 0x028b)
	blow_mine1(155, 0x65, '3', 0x78, 0x028a)
	blow_mine1(176, 0x66, '4', 0x79, 0x0289)
	blow_mine1(194, 0x6a, '5', 0x7a, 0x0288)
	blow_mine1(252, 0x6b, '6', 0x7b, 0x0287)
	blow_mine1(300, 0x6c, '7', 0x7c, 0x0286)
	blow_mine1(331, 0x6d, '8', 0x7d, 0x0285)
	blow_mine1(355, 0x6e, '9', 0x7e, 0x0284)
	blow_mine2(411, 0x6f, '1','0', 0x7f, 0x0283)
	blow_mine2(441, 0x70, '1','1', 0x80, 0x0282)
	blow_mine2(485, 0x71, '1','2', 0x81, 0x0281)
	blow_mine2(543, 0x72, '1','3', 0x82, 0x0280)
	blow_mine2(594, 0x73, '1','4', 0x83, 0x027f)
	blow_mine2(607, 0x74, '1','5', 0x84, 0x027e)
	blow_mine2(629, 0x75, '1','6', 0x85, 0x027d)
	blow_mine2(671, 0x76, '1','7', 0x86, 0x027c)
	blow_mine2(720, 0x77, '1','8', 0x87, 0x027b)
	blow_mine2(776, 0x78, '1','9', 0x88, 0x027a)
	blow_mine2(865, 0x79, '2','0', 0x89, 0x0279)
	blow_mine2(914, 0x7a, '2','1', 0x8a, 0x0278)
	blow_mine2(991, 0x7b, '2','2', 0x8b, 0x0277)

	beginloop(0x7c)
		if_timer_gt(1011, /*goto*/ 0x2e)
	endloop(0x7c)

	label(0x2e)
	dprint '2','3','\n',0,

	blow_mine2(1038, 0x7d, '2','4', 0x8d, 0x0275)
	blow_mine2(1071, 0x7e, '2','5', 0x8e, 0x0274)
	blow_mine2(1090, 0x7f, '2','6', 0x8f, 0x0273)
	blow_mine2(1110, 0x80, '2','7', 0x90, 0x0272)
	blow_mine2(1137, 0x81, '2','8', 0x91, 0x0271)

	wait_until(1150, 0x8e)
	open_door(0xb3)
	open_door(0xb4)
	open_door(0xb5)
	open_door(0xb6)

	blow_mine2(1191, 0x82, '2','9', 0x92, 0x0270)
	blow_mine2(1214, 0x83, '3','0', 0x93, 0x026f)
	blow_mine2(1266, 0x84, '3','1', 0x94, 0x026e)
	blow_mine2(1285, 0x85, '3','2', 0x95, 0x026d)
	blow_mine2(1296, 0x86, '3','3', 0x96, 0x026c)
	blow_mine2(1320, 0x87, '3','4', 0x97, 0x026b)

	wait_until(1355, 0x8f)
	close_door(0xb5)
	close_door(0xb6)

	blow_mine2(1360, 0x88, '3','5', 0x98, 0x026a)
	blow_mine2(1390, 0x89, '3','6', 0x99, 0x0269)
	blow_mine2(1412, 0x8a, '3','7', 0x9a, 0x0268)

	wait_until(1416, 0x90)
	close_door(0xb3)
	close_door(0xb4)

	blow_mine2(1424, 0x8b, '3','8', 0x9b, 0x0267)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x57)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x57)
		label(0x2e)
	endloop(0x08)

	label(0x57)
	if_all_objectives_complete(/*goto*/ 0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	explosions_around_chr(CHR_BOND)
	label(0x2e)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	enter_firstperson
	grant_control(CHR_BOND)
	restart_timer

	beginloop(0x0d)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x0d)

	label(0x2f)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	explosions_around_chr(CHR_COOP)
	label(0x2e)

	beginloop(0x0e)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2e)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_intro[] = {
	set_drcaroll_images(CHR_DRCAROLL, DRCAROLLIMAGE_EYESFROWNING, DRCAROLLIMAGE_EYESFROWNING)
	chr_draw_weapon_in_cutscene(CHR_BOND, WEAPON_FALCON2_SCOPE)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_DEEPSEA_INTRO)
	camera_movement(0x01ef)
	cmd0175(60)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01f0, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x01f1, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)
	set_object_flag(0x07, OBJFLAG_DEACTIVATED)
	set_object_flag2(0x07, OBJFLAG2_04000000)
	set_object_flag3(0x07, OBJFLAG3_00000010)
	object_do_animation(0x01f2, 0x07, 0x04, 0xffff)
	set_chr_chrflag(0x40, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x40, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x40, CHRHFLAG_00020000)
	chr_do_animation(0x0471, -1, -1, 0x06, 0x00, 0x40, 4)
	restart_timer
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SCOPE, WEAPON_NONE)

	wait_until(0, 0x63)
	play_sound_from_object2(CHANNEL_5, 0x07, 0x81aa, 0x00, 0x00)

	wait_until(260, 0x8a)
	play_sound(0x80d5, CHANNEL_10)

	wait_until(280, 0x8b)
	play_sound(0x80d4, CHANNEL_10)

	wait_until(300, 0x89)
	play_sound(0x005b, CHANNEL_7)
	set_chr_hiddenflag(0x40, CHRHFLAG_CLOAKED)
	play_sound(0x80d7, CHANNEL_10)

	wait_until(320, 0x8c)
	play_sound(0x80d6, CHANNEL_10)

	wait_until(852, 0x64)
	play_sound(0x0171, CHANNEL_7)

	wait_until(1210, 0x65)
	speak(CHR_BOND, L_PAM(31), 0x7469, CHANNEL_10, COLOR_04_ORANGE) // "This doesn't seem normal. No one's around."

	wait_until(1266, 0x66)
	play_sound(0x0172, CHANNEL_7)

	wait_until(1300, 0x6a)
	play_sound(0x0171, CHANNEL_7)

	wait_until(1430, 0x6b)
	mute_channel(CHANNEL_5)
	play_sound_from_object2(CHANNEL_5, 0x07, 0x81a9, 0x00, 0x00)

	wait_until(1522, 0x6c)
	speak(CHR_BOND, L_PAM(32), 0x746a, CHANNEL_10, COLOR_09_BLUE) // "No signs of conflict. No spent ammo cases or bulle..."

	wait_until(1548, 0x6d)
	play_sound(0x0174, CHANNEL_7)

	wait_until(1594, 0x6e)
	play_sound(0x0175, CHANNEL_7)

	wait_until(1662, 0x6f)
	play_sound(0x0176, CHANNEL_7)

	wait_until(1762, 0x70)
	play_sound(0x0177, CHANNEL_7)

	wait_until(1945, 0x71)
	speak(CHR_BOND, L_PAM(33), 0x746b, CHANNEL_10, COLOR_04_ORANGE) // "But there ought to be a rear guard at least. It ma..."

	wait_until(1958, 0x72)
	play_sound(0x0178, CHANNEL_7)

	wait_until(2066, 0x73)
	play_sound(0x0171, CHANNEL_7)

	wait_until(2118, 0x74)
	play_sound(0x0172, CHANNEL_7)

	wait_until(2167, 0x75)
	play_sound(0x0173, CHANNEL_7)

	wait_until(2213, 0x76)
	play_sound(0x0174, CHANNEL_7)

	wait_until(2346, 0x77)
	play_sound(0x0175, CHANNEL_7)

	wait_until(2362, 0x78)
	play_sound(0x0176, CHANNEL_7)

	wait_until(2376, 0x79)
	play_sound(0x0177, CHANNEL_7)

	wait_until(2390, 0x7a)
	play_sound(0x0178, CHANNEL_7)

	wait_until(2420, 0x7b)
	speak(CHR_BOND, L_PAM(34), 0x746c, CHANNEL_10, COLOR_09_BLUE) // "There has to be someone farther inside. Cover me."

	wait_until(2426, 0x7c)
	play_sound(0x0171, CHANNEL_7)

	wait_until(2470, 0x7d)
	play_sound(0x0172, CHANNEL_7)

	wait_until(2485, 0x7e)
	play_sound(0x0173, CHANNEL_7)

	wait_until(2520, 0x7f)
	play_sound(0x0174, CHANNEL_7)

	wait_until(2545, 0x80)
	play_sound(0x0175, CHANNEL_7)

	wait_until(2582, 0x81)
	play_sound(0x0171, CHANNEL_7)

	wait_until(2585, 0x82)
	play_sound(0x0176, CHANNEL_6)

	wait_until(2720, 0x83)
	play_sound(0x0172, CHANNEL_7)

	wait_until(2842, 0x84)
	play_sound(0x0173, CHANNEL_7)

	wait_until(2880, 0x85)
	play_sound(0x0174, CHANNEL_7)

	wait_until(2898, 0x86)
	play_sound(0x0175, CHANNEL_7)

	wait_until(3040, 0x87)
	play_sound(0x0176, CHANNEL_7)

	wait_until(3042, 0x88)
	play_sound(0x0177, CHANNEL_6)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x57)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x57)
		label(0x2e)
	endloop(0x08)

	label(0x57)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_4)
	mute_channel(CHANNEL_10)
	remove_chr(0x40)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01f0, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x01f1, -2, -1, 0x06, 0x00, CHR_ELVIS, 2)
	if_coop_mode(/*goto*/ 0x45)
	unset_object_flag(0x07, OBJFLAG_DEACTIVATED)
	unset_object_flag2(0x07, OBJFLAG2_04000000)
	set_object_flag3(0x07, OBJFLAG3_00000010)
	object_do_animation(0x01f2, 0x07, 0x01, 0xfffe)
	goto_next(0x46)

	label(0x45)
	hide_object(0x07)
	label(0x46)
	restart_default_music
	reset_ambience
	label(0x0d)
	enter_firstperson
	yield
	set_ailist(CHR_ELVIS, AILIST_INIT_ELVIS)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042f_init_pelagic_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(20)
	set_reaction_speed(65)
	set_chr_maxdamage(CHR_SELF, 70)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0430_unused[] = {
	set_accuracy(20)
	set_reaction_speed(65)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(70)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1006_msg_thiswillhelpus[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x0d)
		if_objective_complete(0, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	restart_timer

	beginloop(0x08)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x0d)
		if_timer_gt(180, /*goto*/ 0x2e)
	endloop(0x08)

	label(0x2e)
	speak(CHR_P1P2, L_PAM(10), 0x73d4, CHANNEL_6, COLOR_04_ORANGE) // "This will help us to get round the ship quicker."
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_msg_antibodymasking[] = {
	restart_timer

	beginloop(0x04)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x0d)
	endloop(0x04)

	// Unreachable
	label(0x2e)
	speak(CHR_BOND, L_PAM(11), 0x73d5, CHANNEL_6, COLOR_09_BLUE) // "This antibody masking will protect us from the aut..."

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_msg_theresdrcaroll[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x0d)

		if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x0d)
		if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x0d)

		if_door_state(0xae, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x004c, /*goto*/ 0x2e)
		goto_next(0x0d)

		label(0x2e)
		if_chr_propsoundcount_zero(CHR_ELVIS, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	speak(CHR_BOND, L_PAM(12), 0x73d6, CHANNEL_6, COLOR_04_ORANGE) // "There's Dr. Caroll. Let's see if we can reverse wh..."

	// Elvis dead, Dr Caroll dead, or Elvis didn't get teleported
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_msg_getoutofhere[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MIDCUTSCENE_FINISHED, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	restart_timer

	beginloop(0x08)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x0d)
		if_timer_gt(120, /*goto*/ 0x2e)
	endloop(0x08)

	label(0x2e)
	speak(CHR_BOND, L_PAM(13), 0x73d7, CHANNEL_6, COLOR_04_ORANGE) // "We have to get out of here!"

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Entry point for all of Joanna's teleports.
 *
 * Map of how these ailists call each other:
 *
 * 100a func100a_bond_teleports
 * - calls 0414 teleport_bond_to_sapa
 * - calls 0416 teleport_bond_to_a_pa_drcaroll
 *   - calls 0415 teleport_bond_to_drcaroll
 * - calls 0415 teleport_bond_to_drcaroll
 */
u8 func100a_bond_teleports[] = {
	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_TELEPORTALS_ACTIVATED, TRUE, /*goto*/ 0x04)
	endloop(0x1f)

	beginloop(0x04)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, PAD_STARTAREA_TELEPORT, /*goto*/ 0x59)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, PAD_SAPAAREA_TELEPORT, /*goto*/ 0x09)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, PAD_AGENTAREA_TELEPORT, /*goto*/ 0x08)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, PAD_PAAREA_TELEPORT, /*goto*/ 0x08)
		if_stage_flag_eq(STAGEFLAG_DONE_FIRST_TELEPORT, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	// Done first teleport
	label(0x2e)
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2e)
	goto_first(0x04)

	label(0x2e)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)
	goto_first(0x04)

	// Done first teleport and difficulty is SA
	label(0x2e)
	set_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
	if_objective_complete(1, /*goto*/ 0x2e)
	goto_first(0x04)

	// Done first teleport, difficult is SA and megaweapon is disabled
	label(0x2e)
	unset_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
	goto_first(0x04)

	//
	// At start area teleport
	//
	label(0x59)
	set_stage_flag(STAGEFLAG_DONE_FIRST_TELEPORT)
	revoke_control(CHR_BOND, 0)
	teleport_to_pad(PAD_STARTAREA_TELEPORT, CHR_BOND)

	label(0x5b)
	if_teleport_full_white(/*goto*/ 0x5e, CHR_BOND)
	yield
	goto_first(0x5b)

	label(0x5e)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)

	label(0x2e)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x64)
	set_ailist(CHR_BOND, AILIST_TELEPORT_BOND_TO_SAPA)
	unset_stage_flag(STAGEFLAG_TELEPORT_DONE)

	beginloop(0x31)
		if_stage_flag_eq(STAGEFLAG_TELEPORT_DONE, TRUE, /*goto*/ 0x2e)
	endloop(0x31)

	label(0x2e)
	grant_control(CHR_BOND)
	teleport_to_pad(0x0000, CHR_BOND)
	goto_first(0x04)

	//
	// At SA/PA area teleport
	//
	beginloop(0x09)
		if_difficulty_gt(DIFF_SA, /*goto*/ 0x2e)
		set_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
		if_objective_complete(1, /*goto*/ 0x2e)
		reloop(0x09)

		// Teleport is active
		label(0x2e)
		unset_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, PAD_SAPAAREA_TELEPORT, /*goto*/ 0x59)
	endloop(0x09)

	label(0x59)
	teleport_to_pad(0x00c0, CHR_BOND)
	revoke_control(CHR_BOND, 0)

	label(0x5c)
	if_teleport_full_white(/*goto*/ 0x5e, CHR_BOND)
	yield
	goto_first(0x5c)

	label(0x5e)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x64)
	goto_next(0x2e)

	//
	// At start area teleport on Agent, or SA/PA area teleport on SA
	//
	label(0x64)
	goto_next(0x2e)

	label(0x2e)
	set_ailist(CHR_BOND, AILIST_TELEPORT_BOND_TO_A_PA_DRCAROLL)
	unset_stage_flag(STAGEFLAG_TELEPORT_DONE)

	beginloop(0x32)
		if_stage_flag_eq(STAGEFLAG_TELEPORT_DONE, TRUE, /*goto*/ 0x2e)
	endloop(0x32)

	label(0x2e)
	grant_control(CHR_BOND)
	teleport_to_pad(0x0000, CHR_BOND)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)
	label(0x06)
	goto_first(0x04)

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	//
	// At Agent or PA teleport
	//
	beginloop(0x08)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, PAD_AGENTAREA_TELEPORT, /*goto*/ 0x59)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, PAD_PAAREA_TELEPORT, /*goto*/ 0x5a)
	endloop(0x08)

	// Agent teleport
	label(0x59)
	revoke_control(CHR_BOND, 0)
	teleport_to_pad(0x0054, CHR_BOND)
	goto_next(0x5d)

	// PA teleport
	label(0x5a)
	revoke_control(CHR_BOND, 0)
	teleport_to_pad(0x0111, CHR_BOND)

	label(0x5d)
	if_teleport_full_white(/*goto*/ 0x5e, CHR_BOND)
	yield
	goto_first(0x5d)

	label(0x5e)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	set_ailist(CHR_BOND, AILIST_TELEPORT_BOND_TO_DRCAROLL)
	unset_stage_flag(STAGEFLAG_TELEPORT_DONE)

	beginloop(0x33)
		if_stage_flag_eq(STAGEFLAG_TELEPORT_DONE, TRUE, /*goto*/ 0x2e)
	endloop(0x33)

	label(0x2e)
	grant_control(CHR_BOND)
	teleport_to_pad(0x0000, CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0414_teleport_bond_to_sapa[] = {
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)

	label(0x08)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x06)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x06)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x06)

	beginloop(0x63)
		chr_move_to_pad(CHR_ELVIS, 0x01c6, 0x01, /*goto*/ 0x06)
	endloop(0x63)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	label(0x62)

	beginloop(0x64)
		chr_move_to_pad(CHR_SELF, PAD_SAPAAREA_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x64)

	label(0x06)
	yield
	stop_chr
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)
	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_GIVE_FARSIGHT)
	label(0x62)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0415_teleport_bond_to_drcaroll[] = {
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x07)

	beginloop(0x65)
		chr_move_to_pad(CHR_ELVIS, 0x01bf, 0x01, /*goto*/ 0x06)
	endloop(0x65)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	goto_next(0x63)
	label(0x07)
	show_hudmsg(CHR_BOND, L_PAM(14)) // "Elvis has been killed."

	label(0x62)

	beginloop(0x63)
		chr_move_to_pad(CHR_SELF, PAD_DRCAROLLROOM_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x63)

	label(0x06)
	stop_chr
	yield
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)

	label(0x62)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * If Agent: Warp to Agent area
 * If SA: Warp to Dr Caroll Area
 * If PA: Warp to PA area
 */
u8 func0416_teleport_bond_to_a_pa_drcaroll[] = {
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)

	label(0x62)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x09)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x08)

	// PA
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x07)

	beginloop(0x66)
		chr_move_to_pad(CHR_ELVIS, 0x01be, 0x01, /*goto*/ 0x06)
	endloop(0x66)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	label(0x62)
	label(0x07)

	beginloop(0x67)
		chr_move_to_pad(CHR_SELF, PAD_PAAREA_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x67)

	label(0x06)
	label(0x2e)
	stop_chr
	yield
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)

	label(0x62)
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA
	label(0x08)
	set_ailist(CHR_SELF, AILIST_TELEPORT_BOND_TO_DRCAROLL)

	// Agent
	label(0x09)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x07)

	beginloop(0x6b)
		chr_move_to_pad(CHR_ELVIS, 0x0040, 0x01, /*goto*/ 0x06)
	endloop(0x6b)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	label(0x62)
	label(0x07)

	beginloop(0x68)
		chr_move_to_pad(CHR_SELF, PAD_AGENTAREA_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x68)

	label(0x06)
	label(0x2e)
	stop_chr
	yield
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, FALSE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x61)
	if_chr_dying(CHR_COOP, /*goto*/ 0x61)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_GIVE_FARSIGHT)
	label(0x62)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Entry point for all of Velvet's teleports.
 *
 * Map of how these ailists call each other:
 *
 * 100b func100b_coop_teleports
 * - calls 0417 teleport_coop_to_sapa
 * - calls 0419 teleport_coop_to_a_pa_drcaroll
 *   - calls 0418 teleport_coop_to_drcaroll
 * - calls 0418 teleport_coop_to_drcaroll
 */
u8 func100b_coop_teleports[] = {
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	goto_next(0x1f)

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_TELEPORTALS_ACTIVATED, TRUE, /*goto*/ 0x04)
	endloop(0x1f)

	beginloop(0x04)
		if_chr_distance_to_pad_lt(CHR_COOP, 250, PAD_STARTAREA_TELEPORT, /*goto*/ 0x59)
		if_chr_distance_to_pad_lt(CHR_COOP, 250, PAD_SAPAAREA_TELEPORT, /*goto*/ 0x09)
		if_chr_distance_to_pad_lt(CHR_COOP, 250, PAD_AGENTAREA_TELEPORT, /*goto*/ 0x08)
		if_chr_distance_to_pad_lt(CHR_COOP, 250, PAD_PAAREA_TELEPORT, /*goto*/ 0x08)
	endloop(0x04)

	//
	// At start area teleport
	//
	label(0x59)
	revoke_control(CHR_COOP, 0)
	teleport_to_pad(PAD_STARTAREA_TELEPORT, CHR_COOP)

	label(0x5b)
	if_teleport_full_white(/*goto*/ 0x5e, CHR_COOP)
	yield
	goto_first(0x5b)

	label(0x5e)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	label(0x62)
	label(0x2e)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x64)
	set_ailist(CHR_COOP, AILIST_TELEPORT_COOP_TO_SAPA)
	unset_stage_flag(STAGEFLAG_TELEPORT_DONE)

	beginloop(0x31)
		if_stage_flag_eq(STAGEFLAG_TELEPORT_DONE, TRUE, /*goto*/ 0x2e)
	endloop(0x31)

	label(0x2e)
	grant_control(CHR_COOP)
	teleport_to_pad(0x0000, CHR_COOP)
	goto_first(0x04)

	//
	// At SA/PA area teleport
	//
	beginloop(0x09)
		if_difficulty_gt(DIFF_SA, /*goto*/ 0x2e)
		set_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
		if_objective_complete(1, /*goto*/ 0x2e)
		reloop(0x09)

		label(0x2e)
		unset_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
		if_chr_distance_to_pad_lt(CHR_COOP, 250, PAD_SAPAAREA_TELEPORT, /*goto*/ 0x59)
	endloop(0x09)

	label(0x59)
	teleport_to_pad(0x00c0, CHR_COOP)
	revoke_control(CHR_COOP, 0)

	label(0x5c)
	if_teleport_full_white(/*goto*/ 0x5e, CHR_COOP)
	yield
	goto_first(0x5c)

	label(0x5e)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	label(0x62)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x64)
	goto_next(0x2e)

	label(0x64)
	goto_next(0x2e)

	label(0x2e)
	set_ailist(CHR_COOP, AILIST_TELEPORT_COOP_TO_A_PA_DRCAROLL)
	unset_stage_flag(STAGEFLAG_TELEPORT_DONE)

	beginloop(0x32)
		if_stage_flag_eq(STAGEFLAG_TELEPORT_DONE, TRUE, /*goto*/ 0x2e)
	endloop(0x32)

	label(0x2e)
	grant_control(CHR_COOP)
	teleport_to_pad(0x0000, CHR_COOP)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)
	label(0x06)
	goto_first(0x04)

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	//
	// At Agent or PA area teleport
	//
	beginloop(0x08)
		if_chr_distance_to_pad_lt(CHR_COOP, 250, PAD_AGENTAREA_TELEPORT, /*goto*/ 0x59)
		if_chr_distance_to_pad_lt(CHR_COOP, 250, PAD_PAAREA_TELEPORT, /*goto*/ 0x5a)
	endloop(0x08)

	// Agent teleport
	label(0x59)
	revoke_control(CHR_COOP, 0)
	teleport_to_pad(0x0054, CHR_COOP)
	goto_next(0x5d)

	// PA teleport
	label(0x5a)
	revoke_control(CHR_COOP, 0)
	teleport_to_pad(0x0111, CHR_COOP)

	label(0x5d)
	if_teleport_full_white(/*goto*/ 0x5e, CHR_COOP)
	yield
	goto_first(0x5d)

	label(0x5e)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	label(0x62)
	set_ailist(CHR_COOP, AILIST_TELEPORT_COOP_TO_DRCAROLL)
	unset_stage_flag(STAGEFLAG_TELEPORT_DONE)

	beginloop(0x33)
		if_stage_flag_eq(STAGEFLAG_TELEPORT_DONE, TRUE, /*goto*/ 0x2e)
	endloop(0x33)

	label(0x2e)
	grant_control(CHR_COOP)
	teleport_to_pad(0x0000, CHR_COOP)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0417_teleport_coop_to_sapa[] = {
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)

	label(0x08)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x06)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x06)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x06)

	beginloop(0x63)
		chr_move_to_pad(CHR_ELVIS, 0x01c6, 0x01, /*goto*/ 0x06)
	endloop(0x63)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	label(0x62)

	beginloop(0x64)
		chr_move_to_pad(CHR_SELF, PAD_SAPAAREA_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x64)

	label(0x06)
	yield
	stop_chr
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_GIVE_FARSIGHT)

	label(0x62)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0418_teleport_coop_to_drcaroll[] = {
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x07)

	beginloop(0x65)
		chr_move_to_pad(CHR_ELVIS, 0x01bf, 0x01, /*goto*/ 0x06)
	endloop(0x65)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	goto_next(0x63)

	label(0x07)
	show_hudmsg(CHR_BOND, L_PAM(14)) // "Elvis has been killed."
	label(0x62)

	beginloop(0x63)
		chr_move_to_pad(CHR_SELF, PAD_DRCAROLLROOM_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x63)

	label(0x06)
	stop_chr
	yield
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	label(0x62)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * If Agent: Warp to Agent area
 * If SA: Warp to Dr Caroll Area
 * If PA: Warp to PA area
 */
u8 func0419_teleport_coop_to_a_pa_drcaroll[] = {
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_STOP)
	label(0x62)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x09)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x08)

	// PA
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x07)

	beginloop(0x66)
		chr_move_to_pad(CHR_ELVIS, 0x01be, 0x01, /*goto*/ 0x06)
	endloop(0x66)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	label(0x62)
	label(0x07)

	beginloop(0x67)
		chr_move_to_pad(CHR_SELF, PAD_PAAREA_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x67)

	label(0x06)
	label(0x2e)
	stop_chr
	yield
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	label(0x62)
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA
	label(0x08)
	set_ailist(CHR_SELF, AILIST_TELEPORT_COOP_TO_DRCAROLL)

	// Agent
	label(0x09)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)
	label(0x61)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x07)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x07)

	beginloop(0x6b)
		chr_move_to_pad(CHR_ELVIS, 0x0040, 0x01, /*goto*/ 0x06)
	endloop(0x6b)

	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	label(0x62)
	label(0x07)

	beginloop(0x68)
		chr_move_to_pad(CHR_SELF, PAD_AGENTAREA_ENTRY, 0x01, /*goto*/ 0x06)
	endloop(0x68)

	label(0x06)
	label(0x2e)
	stop_chr
	yield
	set_stage_flag(STAGEFLAG_TELEPORT_DONE)
	if_stage_flag_eq(STAGEFLAG_ELVIS_FOLLOWING_COOP, TRUE, /*goto*/ 0x61)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x61)
	if_chr_dying(CHR_BOND, /*goto*/ 0x61)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x61)
	goto_next(0x62)

	label(0x61)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_GIVE_FARSIGHT)
	label(0x62)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Wait until not in sight of player (usually immediately), then unhide.
 *
 * Once the teleportals are activated, this is assigned to 3 guards at the
 * entrance to the grotto thing.
 */
u8 func041c_teleport_activation_responder[] = {
	beginloop(0x04)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x2e)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x2e)
		unset_self_chrflag(CHRCFLAG_HIDDEN)
		set_ailist(CHR_SELF, AILIST_INIT_SNIPER)
		label(0x2e)
	endloop(0x04)

	endlist
};

u8 func041a_init_sniper[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)

	// SA and PA
	set_accuracy(30)
	set_reaction_speed(65)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(70)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_SNIPER_WAIT_FOR_DETECTION)

	// Agent
	label(0x2e)
	set_accuracy(20)
	set_reaction_speed(65)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(70)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_SNIPER_WAIT_FOR_DETECTION)
	endlist
};

u8 func041b_sniper_wait_for_detection[] = {
	unset_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	yield
	set_shotlist(AILIST_SNIPER)
	label(0x06)
	set_reaction_speed(100)
	set_shotlist(AILIST_SNIPER)
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x2e)
		if_enemy_distance_lt_and_los(1000, /*goto*/ 0x2e)
		if_saw_death(0x00, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_distance_to_target_lt(400, /*goto*/ 0x06)
		if_jo_front_direction_lt(30, /*goto*/ 0x06)
		if_chr_in_view(/*goto*/ 0x06)
		if_saw_death(0x00, /*goto*/ 0x06)
		if_alertness(100, OPERATOR_GREATER_THAN, /*goto*/ 0x06)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
		if_timer_gt(180, /*goto*/ 0x06)
		label(0x2e)
	endloop(0x04)

	label(0x06)
	increase_squadron_alertness(100)
	set_self_chrflag(CHRCFLAG_00040000)
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)
	set_ailist(CHR_SELF, AILIST_SNIPER)
	endlist
};

u8 func041d_sniper[] = {
	set_self_chrflag(CHRCFLAG_00000040)
	set_shotlist(AILIST_SNIPER)
	set_chr_cloaked(CHR_SELF, TRUE, FALSE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x03)

	// Dying
	label(0x06)
	goto_next(0x10)

	// Alive
	label(0x03)
	restart_timer
	cmd0139(70, 0x02, TRUE)

	beginloop(0x63)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_sees_player(/*goto*/ 0x2e)
		dprint 'N','O',' ','P','L','A','Y','E','R',' ','T','A','R','G','E','T','\n',0,
		if_enemy_distance_lt_and_los(1000, /*goto*/ 0x2f)
		dprint 'N','O',' ','O','P','P','\n',0,
		goto_next(0x2f)

		label(0x2e)
		set_target_chr(CHR_P1P2)
		label(0x2f)
		if_target_is_player(/*goto*/ 0x2f)
		goto_next(0x2e)

		label(0x2f)
		dprint 'T','H','E',' ','P','L','A','Y','E','R',' ','i','s',' ','i','t','\n',0,
		if_timer_gt(180, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x63)

	label(0x06)
	dprint '1','\n',0,
	stop_chr
	call_rng
	if_rand_gt(128, /*goto*/ 0x06)
	restart_timer

	beginloop(0x0e)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	dprint '2','\n',0,
	set_chrpreset(CHR_TARGET)
	goto_next(0x06)

	// Unreachable
	if_target_is_player(/*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	dprint 'C','H','E','C','K',' ','P','L','A','Y','E','R',' ','D','I','R','\n',0,
	if_player_looking_at_something_maybe(0x14, 0x01, 0x00, /*goto*/ 0x0d)
	dprint '3','\n',0,
	label(0x06)
	if_chr_sees_player(/*goto*/ 0x2e)
	dprint '4','\n',0,
	goto_next(0x0d)

	label(0x2e)
	restart_timer
	dprint '5','\n',0,
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	label(0x0a)
	label(0x2e)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x2e)
	label(0x2e)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x0b)

	beginloop(0x0b)
		if_chr_stopped(/*goto*/ 0x0c)
	endloop(0x0b)

	label(0x0c)
	if_target_is_player(/*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	if_chr_injured_target(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	set_stage_flag(STAGEFLAG_PURPLE_GUARD_SHOT_JO_OR_ELVIS)
	label(0x06)
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)
	label(0x0d)
	set_target_chr(CHR_PRESET)
	goto_first(0x03)

	label(0x10)
	if_chr_has_hiddenflag(CHR_SELF, CHRHFLAG_CLOAKED, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_blonde[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004c, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	unset_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	set_shotlist(GAILIST_ALERTED)

	beginloop(0x08)
		if_saw_injury(0x00, /*goto*/ 0x06)
		if_saw_death(0x00, /*goto*/ 0x06)
		if_chr_sees_player(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_returnlist(CHR_SELF, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func100c_countdown_timer[] = {
	beginloop(0x03)
		if_stage_flag_eq(STAGEFLAG_MIDCUTSCENE_FINISHED, TRUE, /*goto*/ 0x2e)
	endloop(0x03)

	label(0x2e)
	set_countdown_timer(60)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_countdown_timer_lt(1, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x000c, /*goto*/ 0x2e)
	endloop(0x04)

	// Timer expired
	label(0x06)
	set_stage_flag(STAGEFLAG_TIMER_EXPIRED)
	yield
	set_ailist(CHR_SELF, AILIST_OUTRO)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Player escaped
	label(0x2e)
	show_hudmsg(CHR_P1P2, L_PAM(16)) // "Cetan ship evacuation successful."
	set_stage_flag(STAGEFLAG_ESCAPED)
	restart_timer
	stop_countdown_timer
	hide_countdown_timer

	label(0x09)
	yield
	label(0x2e)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2e)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2e)
	goto_next(0x06)

	// Both players dead
	label(0x2e)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x06)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_check_elvis_dead[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x2e)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	show_hudmsg(CHR_BOND, L_PAM(14)) // "Elvis has been killed."
	set_stage_flag(STAGEFLAG_ALLY_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_check_drcaroll_dead[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x2e)
		if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	show_hudmsg(CHR_BOND, L_PAM(15)) // "Dr. Caroll has been killed."
	set_stage_flag(STAGEFLAG_ALLY_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040f_miniskedar_send_clones[] = {
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x04)
		goto_next(0x52)
		reloop(0x04)

		label(0x52)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x52)
		reloop(0x04)

		label(0x52)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_MINISKEDAR, 0x00000010, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		yield
	endloop(0x04)

	endlist
};

u8 func040e_init_miniskedar[] = {
	set_self_chrflag(CHRCFLAG_00080000)
	set_self_chrflag(CHRCFLAG_00020000)
	set_accuracy(0)
	set_reaction_speed(65)
	set_chr_maxdamage(CHR_SELF, 20)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00080000)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_MINISKEDAR)
	endlist
};

u8 func040f_miniskedar[] = {
	set_shotlist(AILIST_MINISKEDAR)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	yield
	restart_timer

	beginloop(0x10)
		if_timer_gt(30, /*goto*/ 0x2e)
	endloop(0x10)

	label(0x2e)
	say_quip(CHR_BOND, 0x05, 0xff, 0x00, 0xff, BANK_0, 0x00, 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)

	beginloop(0x03)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2e)
		label(0x2e)
		if_chr_sees_player(/*goto*/ 0x2e)
		goto_next(0x1e)

		label(0x2e)
		if_distance_to_target_lt(400, /*goto*/ 0x30)
		label(0x1e)
		restart_timer

		label(0x09)
		restart_timer
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x06)
		label(0x06)
		try_run_to_target(/*goto*/ 0x0a)

		beginloop(0x0a)
			if_chr_sees_player(/*goto*/ 0x2e)
			goto_next(0x06)

			label(0x2e)
			if_distance_to_target_lt(400, /*goto*/ 0x30)
			label(0x06)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x0a)

		label(0x06)
		goto_first(0x09)

		label(0x30)
		restart_timer
		dprint 'F','A','C','E',' ','T','A','R','G','E','T','\n',0,
		stop_chr
		try_face_entity(0x0200, 0x0000, /*goto*/ 0x0b)

		beginloop(0x0b)
			if_timer_gt(30, /*goto*/ 0x06)
			reloop(0x0b)

			label(0x2e)
			if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
			if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
		say_quip(CHR_BOND, 0x04, 0xff, 0x00, 0xff, BANK_0, 0x00, 0x00)
		if_distance_to_target_lt(200, /*goto*/ 0x2f)
		miniskedar_try_pounce(0x04, 0x000e, /*goto*/ 0x34)
		reloop(0x03)

		beginloop(0x34)
			if_chr_stopped(/*goto*/ 0x2e)
		endloop(0x34)

		label(0x2e)
		restart_timer
		if_chr_injured_target(CHR_SELF, /*goto*/ 0x2e)
		goto_next(0x06)

		label(0x2e)
		label(0x2f)
		retreat(SPEED_RUN, 1)

		beginloop(0x0c)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0c)

		label(0x06)
	endloop(0x03)

	endlist
};

u8 func1010_agent_hallway_spawner[] = {
	// This flag is also set when Elvis gives you the Farsight, so perhaps that
	// used to be the trigger for miniskedar spawning but was changed so they
	// spawn immediately.
	set_stage_flag(STAGEFLAG_TRIGGER_MINISKEDAR_SPAWNING)

	beginloop(0x03)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MINISKEDAR_SPAWNING, TRUE, /*goto*/ 0x2e)
	endloop(0x03)

	label(0x2e)
	set_ailist(0x25, AILIST_MINISKEDAR_SEND_CLONES)
	set_ailist(0x26, AILIST_MINISKEDAR_SEND_CLONES)

	// Wait until player in a certain room
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0054, /*goto*/ 0x2e)
	endloop(0x04)

	// Activate a different set of miniskedar
	label(0x2e)
	remove_chr(0x25)
	remove_chr(0x26)
	set_ailist(0x27, AILIST_MINISKEDAR_SEND_CLONES)
	set_ailist(0x28, AILIST_MINISKEDAR_SEND_CLONES)

	// Wait until player in a certain room
	beginloop(0x08)
		chr_toggle_p1p2(CHR_P1P2)
		if_chr_in_room(CHR_P1P2, 0x00, 0x005a, /*goto*/ 0x2e)
	endloop(0x08)

	// Activate a different set of miniskedar
	label(0x2e)
	remove_chr(0x27)
	remove_chr(0x28)
	set_ailist(0x2b, AILIST_MINISKEDAR_SEND_CLONES)
	set_ailist(0x2a, AILIST_MINISKEDAR_SEND_CLONES)

	// Wait until player in a certain room
	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0067, /*goto*/ 0x2e)
	endloop(0x09)

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0411_hide[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_unused[] = {
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_CLOAKED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Assigned to 3 guards who appear after teleports activated.
 */
u8 func0413_cloak_and_hide[] = {
	set_chr_cloaked(CHR_SELF, TRUE, FALSE)
	stop_chr
	yield
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1012_sa_megaweapon_spawner[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ELVIS_STARTED_SA_MEGAWEAPON, TRUE, /*goto*/ 0x1f)
	endloop(0x04)

	label(0x1f)
	restart_timer

	beginloop(0x20)
		dprint 'T','I','M','E','\n',0,
		if_stage_flag_eq(STAGEFLAG_MEGAWEAPON_DISABLED, TRUE, /*goto*/ 0x06)

		// Megaweapon not disabled yet - spawn every 8 seconds
		if_timer_lt(480, /*goto*/ 0x21)
		goto_next(0x2e)

		// Megaweapon disabled - spawn every 48 seconds
		label(0x06)
		if_timer_lt(2880, /*goto*/ 0x21)

		// Consider spawn
		label(0x2e)
		dprint 'S','Q','U','A','D','\n',0,
		if_num_chrs_in_squadron_gt(5, 0x0e, /*goto*/ 0x21)
		call_rng
		if_rand_gt(86, /*goto*/ 0x63)
		if_rand_gt(172, /*goto*/ 0x64)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x01f4, AILIST_INIT_SA_MEGAWEAPON_MINISKEDAR, 0x00000010, /*goto*/ 0x22)
		goto_next(0x21)

		label(0x63)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x01f5, AILIST_INIT_SA_MEGAWEAPON_MINISKEDAR, 0x00000010, /*goto*/ 0x22)
		goto_next(0x21)

		label(0x64)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x01f6, AILIST_INIT_SA_MEGAWEAPON_MINISKEDAR, 0x00000010, /*goto*/ 0x22)
		goto_next(0x21)

		label(0x21)
	endloop(0x20)

	label(0x22)
	yield
	rebuild_teams
	rebuild_squadrons
	goto_first(0x1f)

	endlist
};

// SA megaweapon miniskedar
u8 func041e_init_sa_megaweapon_miniskedar[] = {
	set_squadron(SQUADRON_0E)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_INIT_MINISKEDAR)
	endlist
};

/**
 * On PA, in the room with 5 cylinders that must be destroyed to open the door.
 */
#define doorcylinder_logic(glass1, glass2, glass3, mine, stageflag) \
	beginloop(0x04) \
		if_object_in_good_condition(glass1, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass2, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass3, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
	endloop(0x04) \
 \
	label(0x06) \
	assign_sound(0x8147, CHANNEL_7) \
	control_sound_from_object(CHANNEL_7, mine, TRUE) \
	yield \
	destroy_object(mine) \
	destroy_object(glass1) \
	destroy_object(glass2) \
	destroy_object(glass3) \
	set_stage_flag(stageflag) \
	set_ailist(CHR_SELF, 0x0408)



u8 func1013_pa_doorcylinder1[] = {
	set_lights_state(0x00a1, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00a9, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00ac, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00b4, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00b7, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00bf, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00c0, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00c1, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00c2, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x00c3, 0x04, 0x00, 0xff, 0xb4)
	set_lights_state(0x006c, 0x04, 0x00, 0xff, 0xf0)

	doorcylinder_logic(0x11, 0x12, 0x13, 0x9c, STAGEFLAG_PA_EARLYDOORCYLINDER1_DESTROYED)
	endlist
};

u8 func1014_pa_doorcylinder2[] = {
	doorcylinder_logic(0x14, 0x15, 0x16, 0x9d, STAGEFLAG_PA_EARLYDOORCYLINDER2_DESTROYED)
	endlist
};

u8 func1015_pa_doorcylinder3[] = {
	doorcylinder_logic(0x17, 0x18, 0x19, 0x9e, STAGEFLAG_PA_EARLYDOORCYLINDER3_DESTROYED)
	endlist
};

u8 func1016_pa_doorcylinder4[] = {
	doorcylinder_logic(0x1a, 0x1b, 0x1c, 0x9f, STAGEFLAG_PA_EARLYDOORCYLINDER4_DESTROYED)
	endlist
};

u8 func1017_pa_doorcylinder5[] = {
	doorcylinder_logic(0x1d, 0x1e, 0x1f, 0xa0, STAGEFLAG_PA_EARLYDOORCYLINDER5_DESTROYED)
	endlist
};

u8 func0408_check_pa_earlydoorcylinders_destroyed[] = {
	label(0x04)
	yield
	if_stage_flag_eq(STAGEFLAG_PA_EARLYDOORCYLINDER1_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_EARLYDOORCYLINDER2_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_EARLYDOORCYLINDER3_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_EARLYDOORCYLINDER4_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_EARLYDOORCYLINDER5_DESTROYED, TRUE, /*goto*/ 0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x08)
		if_door_state(0x09, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_lights_state(0x008b, 0x03, 0xff, 0x0a, 0x78)
	set_lights_state(0x00bf, 0x03, 0xff, 0x0a, 0x78)
	set_lights_state(0x00c0, 0x03, 0xff, 0x0a, 0x78)
	set_lights_state(0x00c1, 0x03, 0xff, 0x0a, 0x78)
	set_lights_state(0x00c2, 0x03, 0xff, 0x0a, 0x78)
	set_lights_state(0x00c3, 0x03, 0xff, 0x0a, 0x78)
	open_door(0x09)
	open_door(0x0a)
	goto_first(0x08)

	endlist
};

#define pa_cylinder(glass, mine) \
	/* Wait until any object destroyed */ \
	beginloop(0x04) \
		if_object_in_good_condition(glass, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 1, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 2, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 3, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 4, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 5, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 6, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 7, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 8, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 9, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 10, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
		if_object_in_good_condition(glass + 11, /*goto*/ 0x2e) \
		goto_next(0x06) \
		label(0x2e) \
	endloop(0x04) \
 \
	label(0x06) \
	destroy_object(mine) \
	destroy_object(glass) \
	destroy_object(glass + 1) \
	destroy_object(glass + 2) \
	destroy_object(glass + 3) \
	destroy_object(glass + 4) \
	destroy_object(glass + 5) \
	destroy_object(glass + 6) \
	destroy_object(glass + 7) \
	destroy_object(glass + 8) \
	destroy_object(glass + 9) \
	destroy_object(glass + 10) \
	destroy_object(glass + 11)



u8 func1018_pa_door1[] = {
	pa_cylinder(0x20, 0xa1)
	set_stage_flag(STAGEFLAG_PA_MIDDOORCYLINDER_DESTROYED)
	set_lights_state(0x00a1, 0x03, 0xff, 0x0a, 0x78)

	beginloop(0x08)
		if_door_state(0x0b, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
		reloop(0x08)

		label(0x06)
		open_door(0x0b)
		open_door(0x0c)
	endloop(0x08)

	endlist
};

/**
 * The 4 cylinders in the tunnels that must be destroyed before the door to the
 * final room opens.
 */
u8 func0409_check_pa_latedoorcylinders_destroyed[] = {
	label(0x04)
	yield
	if_stage_flag_eq(STAGEFLAG_PA_LATEDOORCYLINDER1_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_LATEDOORCYLINDER2_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_LATEDOORCYLINDER3_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_LATEDOORCYLINDER4_DESTROYED, TRUE, /*goto*/ 0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x08)
		if_door_state(0x0d, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	open_door(0x0d)
	open_door(0x0e)
	goto_first(0x08)

	endlist
};

u8 func1019_pa_door2[] = {
	pa_cylinder(0x2c, 0xa2)
	set_lights_state(0x00a9, 0x03, 0xff, 0x0a, 0x78)
	label(0x08)
	set_stage_flag(STAGEFLAG_PA_LATEDOORCYLINDER1_DESTROYED)
	set_ailist(CHR_SELF, 0x0409)
	endlist
};

u8 func101a_pa_door3[] = {
	pa_cylinder(0x38, 0xa3)
	set_lights_state(0x00ac, 0x03, 0xff, 0x0a, 0x78)
	label(0x08)
	set_stage_flag(STAGEFLAG_PA_LATEDOORCYLINDER2_DESTROYED)
	set_ailist(CHR_SELF, 0x0409)
	endlist
};

u8 func101b_pa_door4[] = {
	pa_cylinder(0x44, 0xa4)
	set_lights_state(0x00b4, 0x03, 0xff, 0x0a, 0x78)
	label(0x08)
	set_stage_flag(STAGEFLAG_PA_LATEDOORCYLINDER3_DESTROYED)
	set_ailist(CHR_SELF, 0x0409)
	endlist
};

u8 func101c_pa_door5[] = {
	// @bug: One of the PA door glasses is checked twice, and one is not
	// checked at all, hence why this doesn't use the pa_cylindar macro.

	// Wait until any object destroyed
	beginloop(0x04)
		if_object_in_good_condition(0x50, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x51, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x52, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x52, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x53, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x54, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x55, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x56, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x57, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x58, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x59, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
		if_object_in_good_condition(0x5a, /*goto*/ 0x2e)
		goto_next(0x06)
		label(0x2e)
	endloop(0x04)

	label(0x06)
	destroy_object(0xa5)
	destroy_object(0x50)
	destroy_object(0x51)
	destroy_object(0x52)
	destroy_object(0x52)
	destroy_object(0x53)
	destroy_object(0x54)
	destroy_object(0x55)
	destroy_object(0x56)
	destroy_object(0x57)
	destroy_object(0x58)
	destroy_object(0x59)
	destroy_object(0x5a)

	set_lights_state(0x00b7, 0x03, 0xff, 0x0a, 0x78)
	label(0x08)
	set_stage_flag(STAGEFLAG_PA_LATEDOORCYLINDER4_DESTROYED)
	set_ailist(CHR_SELF, 0x0409)
	endlist
};

u8 func101d_pa_canister1[] = {
	pa_cylinder(0x5b, 0xa6)
	label(0x08)
	set_stage_flag(STAGEFLAG_PA_CANISTER1_DESTROYED)
	set_ailist(CHR_SELF, 0x040a)
	endlist
};

u8 func101e_pa_canister2[] = {
	pa_cylinder(0x67, 0xa7)
	label(0x08)
	set_stage_flag(STAGEFLAG_PA_CANISDER2_DESTROYED)
	set_ailist(CHR_SELF, 0x040a)
	endlist
};

u8 func040a_check_pa_canisters_destroyed[] = {
	label(0x04)
	yield
	if_stage_flag_eq(STAGEFLAG_PA_CANISTER1_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PA_CANISDER2_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Both canisters destroyed
	label(0x2e)
	set_object_flag(0x0f, OBJFLAG_40000000)
	set_lights_state(0x00bc, 0x03, 0xff, 0x0a, 0x78)

	beginloop(0x08)
		if_door_state(0x0f, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_MEGAWEAPON_DISABLED, TRUE, /*goto*/ 0x2e)
	show_hudmsg(CHR_BOND, L_PAM(43)) // "Cetan megaweapon has been disabled."
	set_stage_flag(STAGEFLAG_MEGAWEAPON_DISABLED)
	label(0x2e)
	open_door(0x0f)
	open_door(0x10)
	goto_first(0x08)

	endlist
};

/**
 * The room with 5 cylinders that open a door.
 */
u8 func101f_pa_circleroom_spawner[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_door_state(0x09, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x008b, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	restart_timer

	beginloop(0x0d)
		if_door_state(0x09, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x1f)
		if_timer_gt(300, /*goto*/ 0x1f)
	endloop(0x0d)

	label(0x1f)
	restart_timer

	beginloop(0x20)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x008c, /*goto*/ 0x58)
		dprint 'T','I','M','E','\n',0,
		if_timer_lt(300, /*goto*/ 0x21)
		label(0x2e)
		dprint 'S','Q','U','A','D','\n',0,
		if_num_chrs_in_squadron_gt(3, 0x0d, /*goto*/ 0x21)
		call_rng
		if_rand_gt(128, /*goto*/ 0x63)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x00dd, AILIST_INIT_PA_CIRCLEROOM_MINISKEDAR, 0x00000000, /*goto*/ 0x22)
		goto_next(0x21)
		label(0x63)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x00dd, AILIST_INIT_PA_CIRCLEROOM_MINISKEDAR, 0x00000000, /*goto*/ 0x22)
		goto_next(0x21)
		label(0x21)
	endloop(0x20)

	label(0x22)
	yield
	rebuild_teams
	rebuild_squadrons
	goto_first(0x1f)

	label(0x58)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func041f_init_pa_circleroom_miniskedar[] = {
	set_squadron(SQUADRON_0D)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_INIT_MINISKEDAR)
	endlist
};

u8 func1020_pa_deadendroom_spawner[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b4, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b8, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_ailist(0x38, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR)
	set_ailist(0x39, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR)
	set_ailist(0x3a, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR)
	set_ailist(0x3b, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR)
	label(0x1f)
	restart_timer

	beginloop(0x20)
		dprint 'T','I','M','E','\n',0,
		if_timer_lt(300, /*goto*/ 0x21)
		label(0x2e)
		dprint 'S','Q','U','A','D','\n',0,
		if_num_chrs_in_squadron_gt(3, 0x0b, /*goto*/ 0x21)
		call_rng
		if_rand_gt(64, /*goto*/ 0x63)
		if_rand_gt(128, /*goto*/ 0x64)
		if_rand_gt(196, /*goto*/ 0x65)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x01af, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR, 0x00000000, /*goto*/ 0x22)
		goto_next(0x21)
		label(0x63)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x01b0, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR, 0x00000000, /*goto*/ 0x22)
		goto_next(0x21)
		label(0x64)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x01b1, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR, 0x00000000, /*goto*/ 0x22)
		goto_next(0x21)
		label(0x65)
		try_spawn_chr_at_pad(BODY_MINISKEDAR, HEAD_RANDOM, 0x01b2, AILIST_INIT_PA_DEADENDROOM_MINISKEDAR, 0x00000000, /*goto*/ 0x22)
		goto_next(0x21)
		label(0x21)
	endloop(0x20)

	label(0x22)
	yield
	rebuild_teams
	rebuild_squadrons
	goto_first(0x1f)

	endlist
};

u8 func0420_init_pa_deadendroom_miniskedar[] = {
	set_squadron(SQUADRON_0B)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_INIT_MINISKEDAR)
	endlist
};

u8 func1021_c6c4[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_PA_MIDDOORCYLINDER_DESTROYED, TRUE, /*goto*/ 0x2e)
		if_chr_dying(0x30, /*goto*/ 0x2e)
		if_chr_dying(0x31, /*goto*/ 0x2e)
		if_chr_dying(0x32, /*goto*/ 0x2e)
		if_chr_dying(0x33, /*goto*/ 0x2e)
		if_chr_dying(0x34, /*goto*/ 0x2e)
		if_chr_dying(0x35, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_ailist(0x30, AILIST_INIT_MINISKEDAR)
	set_ailist(0x31, AILIST_INIT_MINISKEDAR)
	set_ailist(0x32, AILIST_INIT_MINISKEDAR)
	set_ailist(0x33, AILIST_INIT_MINISKEDAR)
	set_ailist(0x34, AILIST_INIT_MINISKEDAR)
	set_ailist(0x35, AILIST_INIT_MINISKEDAR)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_path(pathid, function) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(20) \
	set_reaction_speed(65) \
	set_chr_maxdamage(CHR_SELF, 70) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0) \
	set_returnlist(CHR_SELF, function) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)



u8 func0421_start_path02[] = {
	init_path(2, 0x0421)
	endlist
};

u8 func0422_start_path03[] = {
	init_path(3, 0x0422)
	endlist
};

u8 func0423_start_path04[] = {
	init_path(4, 0x0423)
	endlist
};

u8 func0424_start_path05[] = {
	init_path(5, 0x0424)
	endlist
};

u8 func0425_start_path06[] = {
	init_path(6, 0x0425)
	endlist
};

u8 func0426_start_path07[] = {
	init_path(7, 0x0426)
	endlist
};

u8 func0427_start_path08[] = {
	init_path(8, 0x0427)
	endlist
};

u8 func0428_start_path09[] = {
	init_path(9, 0x0428)
	endlist
};

u8 func0429_start_path10[] = {
	init_path(10, 0x0429)
	endlist
};

u8 func1022_control_room[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
	goto_next(0x04)

	// Agent
	label(0x2e)
	remove_chr(CHR_BLONDE1)
	remove_chr(CHR_BLONDE2)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA and PA
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004c, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	if_chr_dying(CHR_BLONDE1, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_BLONDE1, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_BLONDE1, /*goto*/ 0x2e)
	goto_first(0x04)

	label(0x2e)
	if_chr_dying(CHR_BLONDE2, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_BLONDE2, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_BLONDE2, /*goto*/ 0x2e)
	goto_first(0x04)

	label(0x2e)
	show_hudmsg(CHR_P1P2, L_PAM(21)) // "Control Room has been secured."
	set_stage_flag(STAGEFLAG_BLONDES_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1023_check_drcaroll_restored[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x04)
	yield
	give_object_to_chr(OBJ_BACKUPDISK, CHR_BOND)

	beginloop(0x04)
		if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x0d)
		if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x0d)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x0d)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x0d)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_distance_to_pad_lt(CHR_P1P2, 200, 0x0193, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x08)
		if_stage_flag_eq(STAGEFLAG_BLONDES_DEAD, TRUE, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x08)
		if_chr_distance_to_pad_lt(CHR_P1P2, 200, 0x0193, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_BACKUPDISK, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_stage_flag(STAGEFLAG_DRCAROLL_RESTORED)
	label(0x08)
	set_ailist(CHR_SELF, AILIST_MIDCUTSCENE)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1024_update_elvis_target_chr[] = {
	beginloop(0x04)
		if_chr_dying(CHR_BOND, /*goto*/ 0x08)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x08)
		if_chr_unloaded(CHR_BOND, /*goto*/ 0x08)
		set_chr_target_chr(CHR_ELVIS, CHR_BOND)
		unset_stage_flag(STAGEFLAG_ELVIS_FOLLOWING_COOP)
	endloop(0x04)

	beginloop(0x08)
		if_chr_dying(CHR_COOP, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_COOP, /*goto*/ 0x2e)
		set_chr_target_chr(CHR_ELVIS, CHR_COOP)
		set_stage_flag(STAGEFLAG_ELVIS_FOLLOWING_COOP)
	endloop(0x08)

	label(0x2e)
	goto_first(0x04)

	endlist
};

u8 unregistered_function1[] = {
	label(0x04)
	chr_move_to_pad(CHR_ELVIS, 0x01bf, 0x01, /*goto*/ 0x06)
	label(0x06)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_FOLLOW_AND_REACTIVATE_TELEPORTALS)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1026_setup_autoguns[] = {
	yield
	set_autoturret_type(0xa8, 0x12)
	set_autoturret_type(0xa9, 0x12)
	set_autoturret_type(0xaa, 0x12)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042e_elvis_run_to_exit[] = {
	set_self_chrflag(CHRCFLAG_00080000)
	set_shotlist(AILIST_ELVIS_RUN_TO_EXIT)
	set_returnlist(CHR_SELF, AILIST_ELVIS_RUN_TO_EXIT)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	// Dying
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x5f)

	// Injured
	label(0x2e)
	say_quip(CHR_BOND, 0x29, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x12)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x12)

	// Healthy
	label(0x1f)
	label(0x06)
	set_target_chr(CHR_PRESET)
	label(0x5f)
	restart_timer
	if_distance_to_target_lt(1400, /*goto*/ 0x2e)
	jog_to_pad(0x0004)
	goto_next(0x0f)

	label(0x2e)
	run_to_pad(0x0004)

	beginloop(0x0f)
		if_enemy_distance_lt_and_los(800, /*goto*/ 0x08)
		if_timer_gt(300, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x0f)

	label(0x06)
	goto_first(0x5f)

	label(0x2e)
	stop_chr
	goto_first(0x1f)

	label(0x06)
	restart_timer
	label(0x08)
	if_target_is_player(/*goto*/ 0x06)
	goto_next(0x2e)
	label(0x06)
	goto_first(0x1f)

	label(0x2e)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	call_rng
	if_rand_lt(85, /*goto*/ 0x63)
	if_rand_lt(170, /*goto*/ 0x64)
	say_quip(CHR_BOND, 0x26, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)
	label(0x63)
	say_quip(CHR_BOND, 0x27, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2e)
	label(0x64)
	say_quip(CHR_BOND, 0x28, 0xff, 0x0f, 0xff, BANK_1, 0x00, 0x00)
	label(0x2e)
	set_shotlist(AILIST_ELVIS_RUN_TO_EXIT)
	set_returnlist(CHR_SELF, AILIST_ELVIS_RUN_TO_EXIT)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func1027_powernode_illumination[] = {
	beginloop(0x04)
		if_door_state(0x03, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		unset_object_flag(OBJ_POWERNODE1, OBJFLAG_ILLUMINATED)
		goto_next(0x06)
		label(0x2e)
		set_object_flag(OBJ_POWERNODE1, OBJFLAG_ILLUMINATED)

		label(0x06)
		if_door_state(0x04, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		unset_object_flag(OBJ_POWERNODE2, OBJFLAG_ILLUMINATED)
		goto_next(0x06)
		label(0x2e)
		set_object_flag(OBJ_POWERNODE2, OBJFLAG_ILLUMINATED)

		label(0x06)
		if_door_state(0x05, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		unset_object_flag(OBJ_POWERNODE3, OBJFLAG_ILLUMINATED)
		goto_next(0x06)
		label(0x2e)
		set_object_flag(OBJ_POWERNODE3, OBJFLAG_ILLUMINATED)
		label(0x06)
	endloop(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Enables 3 guards near the grotto entrace during the escape timer.
 */
u8 func1028_enable_last_3_guards[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MIDCUTSCENE_FINISHED, TRUE, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_door_state(0xab, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	unset_chr_chrflag(0x3c, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x3d, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x3e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x3c, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x3d, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x3e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x3c, AILIST_RUN_TO_EXIT)
	set_ailist(0x3d, AILIST_RUN_TO_EXIT)
	set_ailist(0x3e, AILIST_RUN_TO_EXIT)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042b_run_to_exit[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(40)
	set_reaction_speed(65)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(70)
	set_recovery_speed(0)
	set_shield(0)
	label(0x04)
	run_to_pad(0x0000)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1429_start_lift[] = {
	if_coop_mode(/*goto*/ 0x45)
	activate_lift(1, 0x07)
	label(0x45)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102a_kill_pelagic_guard[] = {
	yield
	damage_chr(0x3f, 18)
	yield
	damage_chr(0x3f, 18)
	yield
	damage_chr(0x3f, 18)
	yield
	damage_chr(0x3f, 18)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102b_proxymines[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(0x08, /*goto*/ 0x06)
		if_chr_dying(0x08, /*goto*/ 0x06)
		if_chr_unloaded(0x08, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_PURPLE_GUARD_SHOT_JO_OR_ELVIS, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_object_flag(OBJ_PROXYMINES, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(OBJ_PROXYMINES, OBJFLAG2_INVISIBLE)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102c_lock_doors[] = {
	label(0x04)
	yield
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)

	// PA
	lock_door(0xb1, 0x80)
	lock_door(0xb2, 0x80)
	set_object_flag2(0xb1, OBJFLAG2_AICANNOTUSE)
	set_object_flag2(0xb2, OBJFLAG2_AICANNOTUSE)

	// A and SA
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040f_miniskedar_unalerted[] = {
	set_shotlist(AILIST_MINISKEDAR)
	set_self_chrflag(CHRCFLAG_00080000)
	set_self_chrflag(CHRCFLAG_00020000)
	set_accuracy(0)
	set_reaction_speed(65)
	set_chr_maxdamage(CHR_SELF, 20)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00080000)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_ailist(CHR_SELF, AILIST_MINISKEDAR)
	endlist
};

u8 func0432_dead_skedar[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	label(0x08)
	yield
	chr_do_animation(ANIM_SKEDAR_COLLAPSE, -1, -1, 0x06, 0x00, 0x21, 2)
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function2[] = {
	set_lights_state(0x0009, 0x04, 0x00, 0xff, 0xfa)

	beginloop(0x08)
	endloop(0x08)

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102e_open_powernode_doors_on_agent[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Agent
	label(0x08)
	open_door(0x03)
	set_object_flag(0x03, OBJFLAG_40000000)
	open_door(0x04)
	set_object_flag(0x04, OBJFLAG_40000000)
	open_door(0x05)
	set_object_flag(0x05, OBJFLAG_40000000)
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Stop whatever Elvis is doing in preparation for teleporting.
 */
u8 func042c_elvis_stop[] = {
	label(0x08)
	stop_chr

	// @bug: This needs to set the onshot function to GAILIST_IDLE too, otherwise
	// his function will be reassigned if he takes damage between here and the
	// teleport. This causes him to not teleport.
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102f_unlock_drcaroll_door[] = {
	// Wait until player in Dr Caroll room
	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004c, /*goto*/ 0x2e)
	endloop(0x08)

	// Unlock exit door
	label(0x2e)
	unlock_door(0x75, 0x02)
	unlock_door(0x76, 0x02)
	unset_object_flag2(0x75, OBJFLAG2_AICANNOTUSE)
	unset_object_flag2(0x76, OBJFLAG2_AICANNOTUSE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1030_unlock_agent_teleport_door[] = {
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_MEGAWEAPON_DISABLED, TRUE, /*goto*/ 0x2e)
	endloop(0x08)

	// Agent area, near megaweapon. Door that leads to exit teleport.
	label(0x2e)
	unlock_door(0xb7, 0x02)
	unlock_door(0xb8, 0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Wait until Jo has the trigger buddy warp flag set, then unset it 30 seconds
 * later.
 */
u8 func1031_unset_trigger_buddy_warp[] = {
	beginloop(0x08)
		if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP, /*goto*/ 0x2e)
		reloop(0x08)

		label(0x2e)
		restart_timer

		beginloop(0x09)
			if_timer_gt(1800, /*goto*/ 0x2e)
		endloop(0x09)

		label(0x2e)
		unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	endloop(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Toggle a stage flag every 5 seconds.
 *
 * There's a good chance that this flag had a different meaning back when this
 * was working.
 */
u8 unregistered_function3[] = {
	label(0x1f)
	restart_timer

	beginloop(0x08)
		if_timer_gt(300, /*goto*/ 0x2e)
	endloop(0x08)

	label(0x2e)
	unset_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
	restart_timer

	beginloop(0x09)
		if_timer_gt(300, /*goto*/ 0x2e)
	endloop(0x09)

	label(0x2e)
	set_stage_flag(STAGEFLAG_SA_EXIT_TELEPORT_DISABLED)
	goto_first(0x1f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1032_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_PROXYMINES, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1433_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x09, 0x01)
	misc_command(0x0002, 0x05, 0x00)
	misc_command(0x0003, 0x05, 0x00)
	misc_command(0x0004, 0x05, 0x00)
	misc_command(0x0006, 0x05, 0x00)
	misc_command(0x0007, 0x05, 0x00)
	misc_command(0x0008, 0x05, 0x00)
	misc_command(0x000c, 0x05, 0x00)
	misc_command(0x000d, 0x05, 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1034_enable_blondes[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)
	yield
	hide_chr(CHR_BLONDE1)
	hide_chr(CHR_BLONDE2)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004c, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	show_chr(CHR_BLONDE1)
	show_chr(CHR_BLONDE2)
	set_ailist(CHR_BLONDE1, AILIST_BLONDE)
	set_ailist(CHR_BLONDE2, AILIST_BLONDE)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102d_check_farsight_ammo_wasted[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0d)

	// Probable @bug: Looks like the objective will fail if one buddy uses all
	// their ammo but the other is still stocked.
	beginloop(0x1f)
		if_chr_weapon_equipped(CHR_BOND, WEAPON_FARSIGHTXR20, /*goto*/ 0x2e)
		if_chr_weapon_equipped(CHR_COOP, WEAPON_FARSIGHTXR20, /*goto*/ 0x2f)
	endloop(0x1f)

	label(0x2e)
	set_target_chr(CHR_BOND)
	goto_next(0x63)

	label(0x2f)
	set_target_chr(CHR_COOP)

	beginloop(0x63)
		if_objective_complete(1, /*goto*/ 0x0d)
		if_ammo_quantity_lt(CHR_TARGET, AMMOTYPE_FARSIGHT, 1, /*goto*/ 0x2e)
	endloop(0x63)

	label(0x2e)
	show_hudmsg(CHR_BOND, L_PAM(44)) // "Ammo wasted - unable to disable megaweapon."
	set_stage_flag(STAGEFLAG_FARSIGHT_AMMO_WASTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function4[] = {
	mp_init_simulants
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_unused,                                0x0401 },
	{ func1400_setup_counterop,                       0x1400 },
	{ func1001_objectives_failed_msg,                 0x1001 },
	{ func1002_intro,                                 0x1002 },
	{ func1003_powernode1,                            0x1003 },
	{ func1004_powernode2,                            0x1004 },
	{ func1005_powernode3,                            0x1005 },
	{ func1006_msg_thiswillhelpus,                    0x1006 },
	{ func1007_msg_antibodymasking,                   0x1007 },
	{ func1008_msg_theresdrcaroll,                    0x1008 },
	{ func1009_msg_getoutofhere,                      0x1009 },
	{ func100a_bond_teleports,                        0x100a },
	{ func100b_coop_teleports,                        0x100b },
	{ func100c_countdown_timer,                       0x100c },
	{ func100e_check_elvis_dead,                      0x100e },
	{ func100f_check_drcaroll_dead,                   0x100f },
	{ func1010_agent_hallway_spawner,                 0x1010 },
	{ func1012_sa_megaweapon_spawner,                 0x1012 },
	{ func1013_pa_doorcylinder1,                      0x1013 },
	{ func1014_pa_doorcylinder2,                      0x1014 },
	{ func1015_pa_doorcylinder3,                      0x1015 },
	{ func1016_pa_doorcylinder4,                      0x1016 },
	{ func1017_pa_doorcylinder5,                      0x1017 },
	{ func1018_pa_door1,                              0x1018 },
	{ func1019_pa_door2,                              0x1019 },
	{ func101a_pa_door3,                              0x101a },
	{ func101b_pa_door4,                              0x101b },
	{ func101c_pa_door5,                              0x101c },
	{ func101d_pa_canister1,                          0x101d },
	{ func101e_pa_canister2,                          0x101e },
	{ func101f_pa_circleroom_spawner,                 0x101f },
	{ func1020_pa_deadendroom_spawner,                0x1020 },
	{ func1021_c6c4,                                  0x1021 },
	{ func1022_control_room,                          0x1022 },
	{ func1023_check_drcaroll_restored,               0x1023 },
	{ func1024_update_elvis_target_chr,               0x1024 },
	{ func1026_setup_autoguns,                        0x1026 },
	{ func1027_powernode_illumination,                0x1027 },
	{ func1028_enable_last_3_guards,                  0x1028 },
	{ func1429_start_lift,                            0x1429 },
	{ func102a_kill_pelagic_guard,                    0x102a },
	{ func102b_proxymines,                            0x102b },
	{ func102c_lock_doors,                            0x102c },
	{ func102d_check_farsight_ammo_wasted,            0x102d },
	{ func102e_open_powernode_doors_on_agent,         0x102e },
	{ func102f_unlock_drcaroll_door,                  0x102f },
	{ func1030_unlock_agent_teleport_door,            0x1030 },
	{ func1031_unset_trigger_buddy_warp,              0x1031 },
	{ func1032_setup_rtracker,                        0x1032 },
	{ func1433_setup_lighting,                        0x1433 },
	{ func1034_enable_blondes,                        0x1034 },
	{ func1002_intro,                                 0x0c00 },
	{ func0c01_midcutscene,                           0x0c01 },
	{ func0c02_outro,                                 0x0c02 },
	{ func0411_hide,                                  0x0411 },
	{ func0412_unused,                                0x0412 },
	{ func040e_init_miniskedar,                       0x040e },
	{ func040f_miniskedar,                            0x040f },
	{ func0c02_outro,                                 0x0410 },
	{ func040f_miniskedar_send_clones,                0x040d },
	{ func040c_blonde,                                0x040c },
	{ func040b_init_elvis,                            0x040b },
	{ func0402_elvis_follow_and_reactive_teleportals, 0x0402 },
	{ func0403_elvis_give_farsight,                   0x0403 },
	{ func0404_elvis_follow_and_do_agent_megaweapon,  0x0404 },
	{ func0405_elvis_follow_nocombat,                 0x0405 },
	{ func0406_elvis_follow_and_do_sa_megaweapon,     0x0406 },
	{ func0407_elvis_go_to_sa_teleport,               0x0407 },
	{ func0408_check_pa_earlydoorcylinders_destroyed, 0x0408 },
	{ func0409_check_pa_latedoorcylinders_destroyed,  0x0409 },
	{ func040a_check_pa_canisters_destroyed,          0x040a },
	{ func0414_teleport_bond_to_sapa,                 0x0414 },
	{ func0415_teleport_bond_to_drcaroll,             0x0415 },
	{ func0416_teleport_bond_to_a_pa_drcaroll,        0x0416 },
	{ func0417_teleport_coop_to_sapa,                 0x0417 },
	{ func0418_teleport_coop_to_drcaroll,             0x0418 },
	{ func0419_teleport_coop_to_a_pa_drcaroll,        0x0419 },
	{ func041a_init_sniper,                           0x041a },
	{ func041b_sniper_wait_for_detection,             0x041b },
	{ func041c_teleport_activation_responder,         0x041c },
	{ func041d_sniper,                                0x041d },
	{ func041e_init_sa_megaweapon_miniskedar,         0x041e },
	{ func041f_init_pa_circleroom_miniskedar,         0x041f },
	{ func0420_init_pa_deadendroom_miniskedar,        0x0420 },
	{ func0421_start_path02,                          0x0421 },
	{ func0422_start_path03,                          0x0422 },
	{ func0423_start_path04,                          0x0423 },
	{ func0424_start_path05,                          0x0424 },
	{ func0425_start_path06,                          0x0425 },
	{ func0426_start_path07,                          0x0426 },
	{ func0427_start_path08,                          0x0427 },
	{ func0428_start_path09,                          0x0428 },
	{ func0429_start_path10,                          0x0429 },
	{ func042b_run_to_exit,                           0x042b },
	{ func042d_elvis_warp_to_outside_drcaroll,        0x042d },
	{ func042e_elvis_run_to_exit,                     0x042e },
	{ func0c01_midcutscene,                           0x042a },
	{ func0413_cloak_and_hide,                        0x0413 },
	{ func042f_init_pelagic_guard,                    0x042f },
	{ func0430_unused,                                0x0430 },
	{ func040f_miniskedar_unalerted,                  0x0431 },
	{ func0432_dead_skedar,                           0x0432 },
	{ func0433_unused,                                0x0433 },
	{ func042c_elvis_stop,                            0x042c },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ path03, 3, PATHTYPE_BACKANDFORTH },
	{ path04, 4, PATHTYPE_BACKANDFORTH },
	{ path05, 5, PATHTYPE_BACKANDFORTH },
	{ path06, 6, PATHTYPE_BACKANDFORTH },
	{ path07, 7, PATHTYPE_BACKANDFORTH },
	{ path08, 8, PATHTYPE_BACKANDFORTH },
	{ path09, 9, PATHTYPE_BACKANDFORTH },
	{ path10, 10, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

