//
// Attack Ship
//

#include "stagesetup.h"

// Characters
#define CHR_ELVIS            0x00
#define CHR_KNIFEABLE_SKEDAR 0x01
#define CHR_SUSPENDEDANIM1   0x0d
#define CHR_SUSPENDEDANIM2   0x0e
#define CHR_SUSPENDEDANIM3   0x0f
#define CHR_SUSPENDEDANIM4   0x10
#define CHR_BRIDGE1          0x25
#define CHR_BRIDGE2          0x26
#define CHR_BRIDGE3          0x2d
#define CHR_MAIAN1           0x2e
#define CHR_MAIAN2           0x2f
#define CHR_MAIAN3           0x30
#define CHR_BRIDGESPAWNER1   0x31
#define CHR_BRIDGESPAWNER2   0x32
#define CHR_CASS             0x33
#define CHR_INTRO_SKEDAR     0x34
#define CHR_SHY_SKEDAR       0x35 // hides behind the lift at the start

// Objects
#define OBJ_HANGARDOOR1       0x00
#define OBJ_HANGARDOOR2       0x01
#define OBJ_HANGARDOOR3       0x02
#define OBJ_HANGARDOOR4       0x03
#define OBJ_SHIELDCONSOLE1    0x04
#define OBJ_SHIELDCONSOLE2    0x05
#define OBJ_SHIELDCONSOLE3    0x06
#define OBJ_HANGARDOORCONSOLE 0x09
#define OBJ_HANGARLIFT_ELVIS  0x0c
#define OBJ_HANGARLIFT_JO     0x0e
#define OBJ_AR34              0x18
#define OBJ_ENGINE1           0x19
#define OBJ_ENGINE2           0x1a
#define OBJ_PREBRIDGELIFT     0x22
#define OBJ_BRIDGELIFT        0x23
#define OBJ_HANGAR_SHUTTLE    0x2c
#define OBJ_MAULER1           0x43
#define OBJ_MAULER2           0x44
#define OBJ_OUTRO_SHUTTLE     0x45
#define OBJ_NECKLACE          0x4a

// Stage flags
#define STAGEFLAG_ENTERED_BRIDGELIFT              0x00000001
#define STAGEFLAG_SAID_LOOKOUT                    0x00000002
#define STAGEFLAG_SHIELDS_DISABLED                0x00000100
#define STAGEFLAG_HANGAR_DOORS_OPEN               0x00000200
#define STAGEFLAG_NAVIGATION_ROOM_DONE            0x00000400
#define STAGEFLAG_ELVIS_DEAD                      0x00000800
#define STAGEFLAG_ENTERED_SLAYER_AREA             0x00001000
#define STAGEFLAG_TRIGGER_HANGAR_MAIANS           0x00002000
#define STAGEFLAG_HANGAR_ALARM_ACTIVATED          0x00004000
#define STAGEFLAG_HANGAR_KILLS_DONE               0x00008000
#define STAGEFLAG_ENGINES_DESTROYED               0x00010000
#define STAGEFLAG_ENTERED_BRIDGE                  0x00020000
#define STAGEFLAG_ELVIS_COMING_TO_BRIDGE          0x00040000
#define STAGEFLAG_TRIGGER_BRIDGE_SPAWNING         0x00080000
#define STAGEFLAG_BRIDGE_CAPTURED                 0x00100000
#define STAGEFLAG_SAID_GETSHIELDSDOWN             0x00200000
#define STAGEFLAG_INTRO_FINISHED                  0x00400000
#define STAGEFLAG_CASS_AT_PAD                     0x00800000
#define STAGEFLAG_SHY_SKEDAR_READY                0x01000000
#define STAGEFLAG_02000000                        0x02000000
#define STAGEFLAG_SAID_GO_ON_AHEAD                0x04000000
#define STAGEFLAG_HANGAR_DOOR_CONSOLE_DESTROYED   0x08000000
#define STAGEFLAG_MET_ELVIS                       0x10000000
#define STAGEFLAG_AMMO_WASTED                     0x20000000
#define STAGEFLAG_CASS_SCREAMING                  0x40000000
#define STAGEFLAG_BRIDGE_DOORS_UNLOCKED           0x80000000

// AI Lists
#define AILIST_INIT_KNIFEABLE_SKEDAR            0x0407
#define AILIST_KNIFEABLE_SKEDAR                 0x0408
#define AILIST_ELVIS_FOLLOW                     0x0409
#define AILIST_ELVIS_GO_TO_HANGAR_LIFT          0x040a
#define AILIST_INIT_CASS                        0x040b
#define AILIST_ELVIS_RUN_FROM_ENGINEROOM        0x040c
#define AILIST_ELVIS_WAIT_FOR_HANGAR_ENTRY      0x040d
#define AILIST_ELVIS_GIVE_AR34                  0x040e
#define AILIST_INIT_SKEDAR                      0x040f
#define AILIST_WAKE_SUSPENDEDANIM_SKEDAR        0x0410
#define AILIST_HANGARSPAWNER                    0x0412
#define AILIST_INIT_HANGARCLONE                 0x0413
#define AILIST_HANGARCLONE                      0x0414
#define AILIST_INIT_BRIDGECLONE                 0x0416
#define AILIST_INIT_BRIDGESPAWNER_REVEAL        0x0417
#define AILIST_INIT_HANGAR_MAIAN                0x0418
#define AILIST_HANGAR_MAIAN                     0x0419
#define AILIST_BRIDGECLONE                      0x041a
#define AILIST_ELVIS_AT_BRIDGE                  0x041b
#define AILIST_ELVIS_OUTSIDE_PREBRIDGELIFT      0x041c
#define AILIST_INIT_ELVIS_OUTSIDE_PREBRIDGELIFT 0x041d
#define AILIST_INIT_BRIDGE1AND2                 0x041e
#define AILIST_CLOAK_AND_REMOVE                 0x041f
#define AILIST_INIT_BRIDGE3                     0x0420
#define AILIST_BRIDGE_SKEDAR                    0x0421
#define AILIST_CASS                             0x0422
#define AILIST_SHY_SKEDAR                       0x0423
#define AILIST_SHY_SKEDAR_WAIT                  0x0424
#define AILIST_INIT_SHY_SKEDAR                  0x0425
#define AILIST_OUTRO                            0x0426
#define AILIST_SET_CLOAKED                      0x0427
#define AILIST_SET_UNCLOAKED                    0x0428

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x2601)
	briefing(1, 0x2600)
	briefing(2, 0x2602)
	briefing(3, 0x2603)

	beginobjective(0, L_LEE(5), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Disable shield system"
		complete_flags(STAGEFLAG_SHIELDS_DISABLED)
		fail_flags(STAGEFLAG_AMMO_WASTED)
	endobjective

	beginobjective(1, L_LEE(6), (DIFFBIT_PA | DIFFBIT_PD)) // "Open hangar doors"
		complete_flags(STAGEFLAG_HANGAR_DOORS_OPEN)
		fail_flags(STAGEFLAG_HANGAR_DOOR_CONSOLE_DESTROYED)
	endobjective

	beginobjective(2, L_LEE(7), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Access navigational systems"
		complete_flags(STAGEFLAG_NAVIGATION_ROOM_DONE)
		fail_flags(STAGEFLAG_ELVIS_DEAD)
	endobjective

	beginobjective(3, L_LEE(8), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Sabotage engine systems"
		complete_flags(STAGEFLAG_ENGINES_DESTROYED)
	endobjective

	beginobjective(4, L_LEE(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Gain control of bridge"
		complete_flags(STAGEFLAG_BRIDGE_CAPTURED)
	endobjective

	tag(0x2f, 5)
	tag(0x30, 5)
	tag(0x25, 2)
	tag(0x23, 1)
	lift(0x0100, MODEL_SK_LIFT, 0x018c, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x018c, 0x018d, 0xffffffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x000a0000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0180, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0181, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 0)
	chr(0x00000200, 0x01, 0x01cf, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_KNIFEABLE_SKEDAR, -1, -1, 1000, 8, 0x00000000, 0x00000080, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x35, 0x00e8, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SHY_SKEDAR, -1, -1, 1000, 6, 0x00002000, 0x00000080, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0035, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x01cd, BODY_SKEDAR, HEAD_RANDOM, 0x0401, -1, -1, 100, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000400)
	weapon(0x0100, MODEL_CHRMAULER, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x06, 0x01ce, BODY_SKEDAR, HEAD_RANDOM, 0x0402, -1, -1, 100, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000400)
	weapon(0x0100, MODEL_CHRMAULER, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x07, 0x00b1, BODY_SKEDAR, HEAD_RANDOM, AILIST_HANGARSPAWNER, -1, -1, 1000, 200, 0x40012000, 0x00004000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x08, 0x00ae, BODY_SKEDAR, HEAD_RANDOM, AILIST_HANGARSPAWNER, -1, -1, 1000, 200, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x09, 0x01d0, BODY_SKEDAR, HEAD_RANDOM, AILIST_HANGARSPAWNER, -1, -1, 1000, 200, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0a, 0x010d, BODY_SKEDAR, HEAD_RANDOM, AILIST_HANGARSPAWNER, -1, -1, 1000, 200, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00010000, 0x2e, 0x01d8, BODY_ELVIS1, HEAD_MAIAN_S, AILIST_INIT_HANGAR_MAIAN, 0x00b4, -1, 1000, 200, 0x00002000, 0x40304000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x002e, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)
	chr(0x00010000, 0x2f, 0x01d9, BODY_ELVIS1, HEAD_MAIAN_S, AILIST_INIT_HANGAR_MAIAN, 0x00b4, -1, 1000, 200, 0x00002000, 0x40304000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x002f, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)
	chr(0x00010100, 0x30, 0x01f5, BODY_ELVIS1, HEAD_MAIAN_S, GAILIST_IDLE, 0x00b4, -1, 1000, 200, 0x00002000, 0x40304000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00010400, 0x00, 0x00fe, BODY_ELVISWAISTCOAT, HEAD_ELVIS, AILIST_ELVIS_WAIT_FOR_HANGAR_ENTRY, -1, -1, 1000, 200, 0x00002000, 0x80304000, TEAM_NONCOMBAT, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANPISTOL, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PHOENIX, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANPISTOL, 0x0000, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PHOENIX, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	weapon(0x0100, MODEL_CHRPCGUN, 0x001d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	tag(0x18, -1)
	chr(0x00000080, 0x02, 0x00d6, BODY_SKEDAR, HEAD_RANDOM, GAILIST_IDLE_0009, -1, -1, 1000, 200, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000080, 0x37, 0x00d0, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0037, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x0020, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x001f, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0d, 0x004b, BODY_SKEDAR, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0e, 0x004c, BODY_SKEDAR, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0f, 0x004d, BODY_SKEDAR, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x10, 0x004e, BODY_SKEDAR, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x0028, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x12, 0x0044, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x13, 0x0039, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x14, 0x0035, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x0036, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x0052, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x17, 0x0051, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x18, 0x0053, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x0054, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1a, 0x01db, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1b, 0x005e, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1c, 0x0059, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x0056, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1e, 0x005f, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1f, 0x0055, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x20, 0x0060, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x21, 0x0068, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x22, 0x0069, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x25, 0x0089, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_BRIDGE1AND2, -1, -1, 1000, 200, 0x50012000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0025, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x26, 0x0088, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_BRIDGE1AND2, -1, -1, 1000, 200, 0x50012000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x2d, 0x00a4, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_BRIDGE3, -1, -1, 1000, 200, 0x50012000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002d, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	tag(0x43, -3)
	tag(0x44, -3)
	chr(0x00000000, 0x31, 0x0095, BODY_SKEDAR, HEAD_RANDOM, 0x0415, -1, -1, 1000, 200, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x32, 0x0096, BODY_SKEDAR, HEAD_RANDOM, 0x0415, -1, -1, 1000, 200, 0x00002004, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x33, 0x00db, BODY_CASSANDRA, HEAD_CASSANDRA, AILIST_INIT_CASS, -1, -1, 1000, 200, 0x50012000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00004000, 0x34, 0x00e3, BODY_SKEDAR, 0x00, GAILIST_IDLE, -1, -1, 1000, 200, 0x50012000, 0x00000080, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x27, 0x0002, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0027, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x28, 0x0006, BODY_SKEDAR, HEAD_RANDOM, 0x0403, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x29, 0x0008, BODY_SKEDAR, HEAD_RANDOM, 0x0406, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0029, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2a, 0x0005, BODY_SKEDAR, HEAD_RANDOM, 0x0404, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2b, 0x000d, BODY_SKEDAR, HEAD_RANDOM, 0x0405, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2c, 0x006b, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_SKEDAR, -1, -1, 1000, 200, 0x40012000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	tag(0x4a, 1)
	key(0x0100, MODEL_CHRCHAIN, 0x0033, 0x01244000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000008)
	rename_object(-1, 0x50, L_LEE(50), L_LEE(51), L_LEE(52), L_LEE(53), L_LEE(54), 0x0000, 0x0000) // "Obtain De Vries' necklace."
	tag(0x3f, 2)
	tag(0x40, 2)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x016a, 0x10000400, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00320000, 0x0001aaaa, 0x00008000, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x016b, 0x10000400, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00320000, 0x0001aaaa, 0x00008000, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x016c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x016d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x016e, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x016f, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0174, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0175, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0176, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0177, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x41, 2)
	tag(0x42, 2)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0178, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0179, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x017a, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x017b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x017c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x017d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0189, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0188, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0186, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0187, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x48, 2)
	tag(0x49, 2)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0185, 0x10000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0184, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x46, 2)
	tag(0x47, 2)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x018a, 0x10000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x018b, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000040, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0114, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0115, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0116, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0117, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0118, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0119, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x011a, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x011b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x011c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x011d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x011e, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x011f, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0120, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0121, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0122, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0123, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0124, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0125, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0126, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0127, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0128, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x0129, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x012a, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x012b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x012c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x012d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x012e, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x012f, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR1, 0x0134, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR2, 0x0135, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR3, 0x0136, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000bd1f, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR4, 0x0137, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000bd1f, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR1, 0x0138, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR2, 0x0139, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR3, 0x013a, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000bd1f, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR4, 0x013b, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000bd1f, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR1, 0x013c, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR2, 0x013d, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR3, 0x013e, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000bd1f, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR4, 0x013f, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000bd1f, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0f, 2)
	tag(0x10, 2)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0144, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0145, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x11, 2)
	tag(0x12, 2)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0146, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0147, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x13, 2)
	tag(0x14, 2)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0148, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0149, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x15, 2)
	tag(0x16, 2)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x014a, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x014b, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_BOT, 0x014d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001e00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_TOP, 0x014c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_BOT, 0x014e, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001e00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_TOP, 0x014f, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_BOT, 0x0150, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001e00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_TOP, 0x0151, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_BOT, 0x0152, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001e00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_TOP, 0x0153, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x24, 1)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0154, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0155, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x17, 1)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0156, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000003c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0157, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000003c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0158, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000004, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0159, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000004, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x015a, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000004, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x015b, 0x10000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000004, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x31, 6)
	tag(0x32, 6)
	tag(0x33, 8)
	tag(0x34, 8)
	tag(0x2a, 1)
	lift(0x0100, MODEL_SK_LIFT, 0x0194, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0194, 0x0195, 0xffffffff, 0x00000001, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030000, 0x00050000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x015c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00320000, 0x0001aaaa, 0x00008000, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR1, 0x015d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00320000, 0x0001aaaa, 0x00008000, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 0)
	door(0x0100, MODEL_SK_HANGARDOOR_BOT, 0x015e, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_TOP, 0x015f, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -7, 0, 1)
	link_objects(-2, -8, 0, 1)
	tag(0x35, 6)
	tag(0x36, 6)
	tag(0x37, 8)
	tag(0x38, 8)
	tag(0x2b, 1)
	lift(0x0100, MODEL_SK_LIFT, 0x0196, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0196, 0x0197, 0xffffffff, 0x00000001, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030000, 0x00050000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0160, 0x10000400, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x000a0000, 0x00005555, 0x00001999, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0161, 0x10000400, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x000a0000, 0x00005555, 0x00001999, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 0)
	door(0x0100, MODEL_SK_HANGARDOOR_BOT, 0x0162, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOOR_TOP, 0x0163, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -7, 0, 1)
	link_objects(-2, -8, 0, 1)
	tag(0x39, 5)
	tag(0x3a, 5)
	tag(0x29, 2)
	tag(0x0e, 1)
	lift(0x0100, MODEL_SK_LIFT, 0x0193, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0193, 0x0192, 0xffffffff, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x00050000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOORB_BOT, 0x0166, 0x12000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOORB_TOP, 0x0167, 0x12000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 1)
	link_objects(-2, -4, 0, 1)
	tag(0x3b, 5)
	tag(0x3c, 5)
	tag(0x28, 2)
	tag(0x0c, 1)
	lift(0x0100, MODEL_SK_LIFT, 0x0190, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0190, 0x0191, 0xffffffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x00050000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOORB_BOT, 0x0164, 0x12000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_HANGARDOORB_TOP, 0x0165, 0x12000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x000a0000, 0x000a0000, 0x00008000, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 0)
	tag(0x3d, 5)
	tag(0x3e, 5)
	tag(0x26, 2)
	tag(0x22, 1)
	lift(0x0100, MODEL_SK_LIFT, 0x018e, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x018e, 0x018f, 0xffffffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00028000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0182, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_DOOR2, 0x0183, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 0)
	vent_fan(0x0100, MODEL_SK_SHIP_HOLO1, 0x0110, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000222, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_SK_SHIP_HOLO2, 0x0112, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000222, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_SK_SHIP_HOLO2, 0x0113, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000222, 0x00000000, 0x00000002, 0x01000000)
	tag(0x00, 4)
	tag(0x01, 4)
	tag(0x02, 4)
	tag(0x03, 4)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR1, 0x0140, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR2, 0x0141, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x0000000a, 0x00000000, 0x0000ea60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR3, 0x0142, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_SHIP_HULLDOOR4, 0x0143, 0x10000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x0000bd1f, 0x00050000, 0x00002aaa, 0x00000ccc, 0x00000000, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00001d00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x09, 1)
	multimonitor(0x00cc, MODEL_SK_CONSOLE2, 0x01f1, 0x00000101, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15141400)
	multimonitor(0x00cc, MODEL_SK_CONSOLE2, 0x01f2, 0x00000101, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15141400)
	weapon(0x0100, MODEL_CHRSKROCKET, 0x01d2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SLAYER, 0x00ffffff, 0x00000000)
	tag(0x04, 3)
	tag(0x05, 3)
	tag(0x06, 3)
	multimonitor(0x00cc, MODEL_SK_CONSOLE2, 0x01f0, 0x00000101, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15141400)
	multimonitor(0x00cc, MODEL_SK_CONSOLE2, 0x01ef, 0x00000101, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15141400)
	multimonitor(0x00cc, MODEL_SK_CONSOLE2, 0x01ee, 0x00000101, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15141400)
	tinted_glass(0x0100, MODEL_SK_WINDOW1, 0x01ca, 0x14020f62, 0x00304100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00c801f4, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_SK_WINDOW1, 0x01cb, 0x14020f62, 0x00304100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00c801f4, 0x0000ffff, 0x00000000)
	tag(0x19, 2)
	tag(0x1a, 2)
	stdobject(0x0100, MODEL_ENGINEPART, 0x01ea, 0x000001e8, 0x00202000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_ENGINEPART, 0x01e9, 0x000001e8, 0x00202000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1b, 6)
	tag(0x1c, 6)
	tag(0x1d, 6)
	tag(0x1e, 6)
	tag(0x1f, 6)
	tag(0x20, 6)
	glass(0x0100, MODEL_DD_WINDOW, 0x019d, 0x14020f62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x019e, 0x14020f62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x019f, 0x14020f62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01a0, 0x14020f62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01a1, 0x14020f62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01a2, 0x14020f62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x21, 1)
	stdobject(0x0002, MODEL_SK_SHUTTLE, 0x01dc, 0x012604e1, 0x80086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2c, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00021501, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x45, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00021501, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2d, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x01f3, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x2e, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0030, 0x00004001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	endprops
};

s32 intro[] = {
#if VERSION >= VERSION_JAP_FINAL
	ammo(AMMOTYPE_PISTOL, 10)
	intro_weapon(WEAPON_FALCON2, -1)
	ammo(AMMOTYPE_PISTOL, 20)
	ammo(AMMOTYPE_KNIFE, 1)
	ammo(AMMOTYPE_ROCKET, 2)
	ammo(AMMOTYPE_RIFLE, 400)
#else
	intro_weapon(WEAPON_COMBATKNIFE, -1)
	ammo(AMMOTYPE_KNIFE, 1)
	ammo(AMMOTYPE_ROCKET, 2)
	ammo(AMMOTYPE_RIFLE, 400)
	ammo(AMMOTYPE_PISTOL, 10)
#endif
	outfit(OUTFIT_FROCK_RIPPED)
	spawn(0x00d9)
	endintro
};

s32 path00[] = {
	0x01d5,
	0x01d4,
	-1,
};

s32 path01[] = {
	0x01d7,
	0x01d6,
	-1,
};

s32 path02[] = {
	0x0006,
	0x0000,
	-1,
};

s32 path03[] = {
	0x0005,
	0x000d,
	-1,
};

s32 path04[] = {
	0x01de,
	0x000c,
	-1,
};

s32 path05[] = {
	0x0008,
	0x005c,
	-1,
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1400_setup_counterop[] = {
	set_object_flag(OBJ_HANGARLIFT_ELVIS, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_HANGARLIFT_JO, OBJFLAG_DEACTIVATED)
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1019_check_shields_lowered[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_SHIELDCONSOLE1, /*goto*/ 0x06)
		if_object_in_good_condition(OBJ_SHIELDCONSOLE2, /*goto*/ 0x06)
		if_object_in_good_condition(OBJ_SHIELDCONSOLE3, /*goto*/ 0x06)
		show_hudmsg(CHR_BOND, L_LEE(10)) // "Ship's shields have been lowered."
		set_stage_flag(STAGEFLAG_SHIELDS_DISABLED)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x09)
		restart_timer

		beginloop(0x08)
			if_chr_in_room(CHR_BOND, 0x00, 0x0002, /*goto*/ 0x2c)
		endloop(0x08)

		label(0x2c)
		speak(CHR_BOND, L_LEE(17), 0x81a1, CHANNEL_6, COLOR_04_ORANGE) // "You've got to open the hangar doors so we can dock..."
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x06)
	endloop(0x04)

	label(0x09)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_check_hangar_doors_opened[] = {
	yield
	set_object_flag(OBJ_HANGARDOOR1, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(OBJ_HANGARDOOR2, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(OBJ_HANGARDOOR3, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(OBJ_HANGARDOOR4, OBJFLAG_CANNOT_ACTIVATE)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_HANGARDOORCONSOLE, /*goto*/ 0x06)
		if_object_in_good_condition(OBJ_HANGARDOORCONSOLE, /*goto*/ 0x2d)

		// Console destroyed
		show_hudmsg(CHR_BOND, L_LEE(48)) // "Critical mission object destroyed."
		set_stage_flag(STAGEFLAG_HANGAR_DOOR_CONSOLE_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Console healthy
		label(0x2d)
		reloop(0x04)

		// A and SA
		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_SHIELDS_DISABLED, TRUE, /*goto*/ 0x03)
		reloop(0x04)

		// Console activated
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_SHIELDS_DISABLED, TRUE, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_LEE(47)) // "Hangar doors locked - shields still active."
		restart_timer

		beginloop(0x65)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x65)

		label(0x06)
	endloop(0x04)

	// PA - console activated after shields disabled
	label(0x2c)
	show_hudmsg(CHR_P1P2, L_LEE(11)) // "Hangar doors have been opened."
	set_stage_flag(STAGEFLAG_HANGAR_DOORS_OPEN)

	// A and SA once shields disabled, or follow through from above
	label(0x03)
	open_door(OBJ_HANGARDOOR1)
	open_door(OBJ_HANGARDOOR2)
	open_door(OBJ_HANGARDOOR3)
	open_door(OBJ_HANGARDOOR4)
	set_object_flag(OBJ_HANGARDOOR1, OBJFLAG_40000000)
	set_object_flag(OBJ_HANGARDOOR2, OBJFLAG_40000000)
	set_object_flag(OBJ_HANGARDOOR3, OBJFLAG_40000000)
	set_object_flag(OBJ_HANGARDOOR4, OBJFLAG_40000000)
	restart_timer

	beginloop(0x09)
		if_timer_gt(600, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_HANGAR_MAIANS)

	label(0x08)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_elvis_wait_for_hangar_entry[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	set_accuracy(100)
	set_reaction_speed(100)
	add_health_or_armor(200)
	set_alertness(100)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00080000)
	set_self_chrflag(CHRCFLAG_NOAUTOAIM)

	beginloop(0x04)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_HANGAR_DOORS_OPEN, TRUE, /*goto*/ 0x06)
		reloop(0x04)

		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_SHIELDS_DISABLED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)

	beginloop(0x65)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x2c)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x2c)
		set_target_chr(CHR_ANTI)
		if_chr_sees_player(/*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
	endloop(0x65)

	label(0x06)
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	yield
	yield
	yield
	yield
	set_ailist(CHR_SELF, AILIST_ELVIS_GIVE_AR34)
	endlist
};

u8 func040e_elvis_give_ar34[] = {
	set_shotlist(AILIST_ELVIS_GIVE_AR34)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	stop_chr

	// Wait until player in sight
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		set_chrpreset(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)

	beginloop(0x08)
		if_chr_sees_player(/*goto*/ 0x2c)
	endloop(0x08)

	// Run towards player
	label(0x0a)
	restart_timer
	try_run_to_target(/*goto*/ 0x09)

	beginloop(0x09)
		set_target_chr(CHR_PRESET)
		if_timer_gt(60, /*goto*/ 0x2c)
		if_distance_to_target_lt(200, /*goto*/ 0x06)
		reloop(0x09)

		label(0x06)
		if_chr_sees_player(/*goto*/ 0x06)
	endloop(0x09)

	label(0x2c)
	goto_first(0x0a)

	// Talk
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	set_stage_flag(STAGEFLAG_MET_ELVIS)
	speak(CHR_P1P2, L_LEE(19), 0x12e1, CHANNEL_6, COLOR_04_ORANGE) // "Good to see you, Joanna."
	chr_do_animation(ANIM_TALKING_0231, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x0c)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	speak(CHR_P1P2, L_LEE(20), 0x12e2, CHANNEL_6, COLOR_04_ORANGE) // "Take this - you should find it useful..."
	give_object_to_chr(OBJ_AR34, CHR_PRESET)
	show_hudmsg(CHR_PRESET, L_LEE(21)) // "Received AR34 assault rifle."
	restart_timer

	beginloop(0x0d)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	set_stage_flag(STAGEFLAG_HANGAR_ALARM_ACTIVATED)
	activate_alarm
	restart_timer

	beginloop(0x0e)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	label(0x0f)
	yield
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW)
	endlist
};

/**
 * Follow player.
 * If entered nav room, do that objective.
 * If arrived at prebridge lift, assign another function.
 */
u8 func0409_elvis_follow[] = {
	set_self_chrflag(CHRCFLAG_00000040)
	set_shotlist(AILIST_ELVIS_FOLLOW)
	set_returnlist(CHR_SELF, AILIST_ELVIS_FOLLOW)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	// Dying
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	// Injured
	label(0x2c)
	restart_timer
	say_quip(CHR_BOND, 0x29, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	dprint 'I','N','J','U','R','E','D','\n',0,

	beginloop(0xc1)
		if_timer_gt(180, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0xc1)

	// Healthy
	label(0x06)
	dprint 'I','N','J','U','R','E','D','F','I','N','\n',0,
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	set_target_chr(CHR_PRESET)
	if_distance_to_target_lt(200, /*goto*/ 0x06)

	label(0x03)
	set_target_chr(CHR_PRESET)
	restart_timer
	if_distance_to_target_gt(500, /*goto*/ 0x06)
	try_jog_to_target(/*goto*/ 0x04)

	// Distance < 200 or distance > 500
	label(0x06)
	try_run_to_target(/*goto*/ 0x04)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_NAVIGATION_ROOM_DONE, TRUE, /*goto*/ 0x2c)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x003e, /*goto*/ 0xb5)
		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_SAID_GO_ON_AHEAD, TRUE, /*goto*/ 0x2c)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x006c, /*goto*/ 0xc4)
		label(0x2c)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_lt(200, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2c)
	endloop(0x04)

	// Running for 1 second - do distance checks again
	label(0x2c)
	goto_first(0x03)

	// At player
	label(0x06)
	stop_chr

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_NAVIGATION_ROOM_DONE, TRUE, /*goto*/ 0x2c)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x003e, /*goto*/ 0xb5)
		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_SAID_GO_ON_AHEAD, TRUE, /*goto*/ 0x2c)
		if_chr_in_room(CHR_ELVIS, 0x00, 0x006c, /*goto*/ 0xc4)
		label(0x2c)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		set_target_chr(CHR_PRESET)
		if_distance_to_target_gt(300, /*goto*/ 0x06)
	endloop(0x09)

	// Player moved away - do distance checks and start following
	label(0x06)
	goto_first(0x03)

	// Enemy detected
	label(0x08)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2c)
	if_chr_dying(CHR_TARGET, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_TARGET, /*goto*/ 0x2c)
	if_chrpresets_target_is_different(/*goto*/ 0x06)
	label(0x2c)
	goto_first(0x03)

	label(0x06)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	call_rng
	if_rand_lt(85, /*goto*/ 0x65)
	if_rand_lt(170, /*goto*/ 0x66)
	say_quip(CHR_BOND, 0x26, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2c)
	label(0x65)
	say_quip(CHR_BOND, 0x27, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x2c)
	label(0x66)
	say_quip(CHR_BOND, 0x28, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	label(0x2c)
	set_returnlist(CHR_SELF, AILIST_ELVIS_FOLLOW)
	set_shotlist(AILIST_ELVIS_FOLLOW)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	// Elvis in nav room
	label(0xb5)
	jog_to_pad(0x0034)

	beginloop(0x0f)
		if_chr_stopped(/*goto*/ 0x2c)
	endloop(0x0f)

	label(0x2c)
	restart_timer
	chr_do_animation(ANIM_OPERATE_0221, 0, -1, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0x10)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	do_preset_animation(-1)
	show_hudmsg(CHR_BOND, L_LEE(13)) // "Navigational information has been retrieved."
	speak(CHR_PRESET, L_LEE(31), 0x12e4, CHANNEL_6, COLOR_04_ORANGE) // "Time to head upwards..."
	restart_timer
	set_stage_flag(STAGEFLAG_NAVIGATION_ROOM_DONE)

	beginloop(0x79)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x79)

	label(0x06)
	mute_channel(CHANNEL_6)
	goto_first(0x03)

	// Elvis outside prebridgelift
	label(0xc4)
	set_ailist(CHR_SELF, AILIST_INIT_ELVIS_OUTSIDE_PREBRIDGELIFT)
	endlist
};

u8 func041d_init_elvis_outside_prebridgelift[] = {
	set_shotlist(AILIST_ELVIS_OUTSIDE_PREBRIDGELIFT)
	add_health_or_armor(600)
	set_ailist(CHR_SELF, AILIST_ELVIS_OUTSIDE_PREBRIDGELIFT)
	endlist
};

u8 func041c_elvis_outside_prebridgelift[] = {
	set_shotlist(AILIST_ELVIS_OUTSIDE_PREBRIDGELIFT)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	// Dying
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	stop_chr
	set_target_chr(CHR_PRESET)
	set_stage_flag(STAGEFLAG_SAID_GO_ON_AHEAD)
	if_stage_flag_eq(STAGEFLAG_ENTERED_BRIDGELIFT, TRUE, /*goto*/ 0x2c)
	speak(CHR_PRESET, L_LEE(26), 0x14dc, CHANNEL_6, COLOR_04_ORANGE) // "You go on ahead, Jo. I'll secure the perimeter. We..."
	label(0x2c)
	run_to_pad(0x0063)

	beginloop(0x09)
		if_chr_stopped(/*goto*/ 0x0b)
	endloop(0x09)

	label(0x0b)
	stop_chr

	beginloop(0x0c)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	endloop(0x0c)

	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_shotlist(AILIST_ELVIS_OUTSIDE_PREBRIDGELIFT)
	set_returnlist(CHR_SELF, AILIST_ELVIS_OUTSIDE_PREBRIDGELIFT)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func040a_elvis_go_to_hangar_lift[] = {
	set_shotlist(AILIST_ELVIS_GO_TO_HANGAR_LIFT)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	// Dying
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)

	label(0x03)
	set_target_chr(CHR_BOND)
	restart_timer
	if_morale_lt(50, /*goto*/ 0x06)
	goto_next(0xc3)

	label(0x06)
	try_run_to_target(/*goto*/ 0x04)

	beginloop(0x04)
		if_timer_gt(60, /*goto*/ 0x2c)
		if_distance_to_target_lt(200, /*goto*/ 0x06)
	endloop(0x04)

	label(0x2c)
	goto_first(0x03)

	// At player
	label(0x06)
	speak(CHR_BOND, L_LEE(22), 0x12e4, CHANNEL_6, COLOR_04_ORANGE) // "Time to head upwards. I'll take this lift; you tak..."
	chr_do_animation(ANIM_TALKING_0231, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	set_morale(50)

	beginloop(0x0c)
		if_timer_gt(180, /*goto*/ 0xc3)
	endloop(0x0c)

	// Done talk
	label(0xc3)
	restart_timer
	run_to_pad(0x00b2)

	beginloop(0x0d)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	stop_chr
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func041b_elvis_at_bridge[] = {
	stop_chr
	set_shotlist(AILIST_ELVIS_AT_BRIDGE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	// Dying
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	label(0x06)
	if_morale_lt(100, /*goto*/ 0x06)
	goto_next(0x2c)

	label(0x06)
	set_morale(100)
	label(0x2c)

	beginloop(0x65)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x65)

	label(0x2c)
	run_to_pad(0x008a)
	restart_timer

	beginloop(0x09)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		if_chr_stopped(/*goto*/ 0x0b)
		if_stage_flag_eq(STAGEFLAG_SAID_LOOKOUT, TRUE, /*goto*/ 0x06)
		if_timer_gt(180, /*goto*/ 0x2c)
		label(0x06)
		reloop(0x09)

		label(0x2c)
		speak(CHR_TARGET, L_LEE(24), 0x12e3, CHANNEL_6, COLOR_04_ORANGE) // "Look out, Joanna! I think we've made them angry..."
		set_stage_flag(STAGEFLAG_SAID_LOOKOUT)
	endloop(0x09)

	// Reached pad
	label(0x0b)
	stop_chr

	beginloop(0x0c)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	endloop(0x0c)

	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_shotlist(AILIST_ELVIS_AT_BRIDGE)
	set_returnlist(CHR_SELF, AILIST_ELVIS_AT_BRIDGE)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func1005_check_elvis_dead[] = {
	beginloop(0x04)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	show_hudmsg(CHR_BOND, L_LEE(12)) // "Elvis has been killed."
	set_stage_flag(STAGEFLAG_ELVIS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040f_init_skedar[] = {
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x0d)
	if_chr_dying(CHR_SELF, /*goto*/ 0x0d)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x0d)

	// Alive
	set_accuracy(20)
	set_reaction_speed(75)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(190)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_RELATED_TO_SPAWNING)

	// Dying or dead
	label(0x0d)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0410_wake_suspendedanim_skedar[] = {
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_accuracy(20)
	set_reaction_speed(75)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(190)
	set_recovery_speed(0)
	set_shield(0)
	set_target_chr(CHR_BOND)
	try_walk_to_target(/*goto*/ 0x2c)

	label(0x2c)
	set_shotlist(GAILIST_RELATED_TO_SPAWNING)
	set_ailist(CHR_SELF, GAILIST_RELATED_TO_SPAWNING)
	endlist
};

u8 func1006_wake_slayer_skedar[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0033, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	// 1
	label(0x06)
	unlock_door(0x0f, 0x02)
	unlock_door(0x10, 0x02)
	open_door(0x0f)
	set_chr_team(CHR_SUSPENDEDANIM1, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SUSPENDEDANIM1, AILIST_WAKE_SUSPENDEDANIM_SKEDAR)
	restart_timer

	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x09)

	// 2
	label(0x06)
	unlock_door(0x13, 0x02)
	unlock_door(0x14, 0x02)
	open_door(0x13)

	if_chr_death_animation_finished(CHR_SUSPENDEDANIM3, /*goto*/ 0x2c)
	if_chr_dying(CHR_SUSPENDEDANIM3, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SUSPENDEDANIM3, /*goto*/ 0x2c)
	set_ailist(CHR_SUSPENDEDANIM3, AILIST_WAKE_SUSPENDEDANIM_SKEDAR)

	set_chr_team(CHR_SUSPENDEDANIM3, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons

	// Wait until player coming back from Slayer area
	label(0x2c)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_ENTERED_SLAYER_AREA, TRUE, /*goto*/ 0x2c)
		reloop(0x0a)

		label(0x2c)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0033, /*goto*/ 0x2c)
	endloop(0x0a)

	// 3
	label(0x2c)
	unlock_door(0x11, 0x02)
	unlock_door(0x12, 0x02)
	unlock_door(0x15, 0x02)
	unlock_door(0x16, 0x02)
	open_door(0x11)
	open_door(0x15)
	set_ailist(CHR_SUSPENDEDANIM2, AILIST_WAKE_SUSPENDEDANIM_SKEDAR)
	set_chr_team(CHR_SUSPENDEDANIM2, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons

	// 4
	set_ailist(CHR_SUSPENDEDANIM4, AILIST_WAKE_SUSPENDEDANIM_SKEDAR)
	set_chr_team(CHR_SUSPENDEDANIM4, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_check_entered_slayer_area[] = {
	beginloop(0x08)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2c)
		if_chr_in_room(CHR_BOND, 0x00, 0x003a, /*goto*/ 0x2c)
		if_chr_in_room(CHR_BOND, 0x00, 0x003b, /*goto*/ 0x2c)
		reloop(0x08)

		label(0x2c)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
		if_chr_in_room(CHR_COOP, 0x00, 0x003a, /*goto*/ 0x06)
		if_chr_in_room(CHR_COOP, 0x00, 0x003b, /*goto*/ 0x06)
	endloop(0x08)

	label(0x2d)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x0d)
	label(0x06)
	set_stage_flag(STAGEFLAG_ENTERED_SLAYER_AREA)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_hangar_lifts[] = {
	set_object_flag(OBJ_HANGARLIFT_ELVIS, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_HANGARLIFT_JO, OBJFLAG_DEACTIVATED)

	// Wait until kills done
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_HANGAR_KILLS_DONE, TRUE, /*goto*/ 0x2c)
	endloop(0x08)

	// Activate Jo's lift so it starts going to bottom
	label(0x2c)
	dprint 'U','N','\n',0,
	unset_object_flag(OBJ_HANGARLIFT_JO, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield

	// Wait until lift stopped at bottom
	beginloop(0x65)
		dprint 'D','A','\n',0,
		if_lift_stationary(OBJ_HANGARLIFT_JO, /*goto*/ 0x66)
	endloop(0x65)

	// Deactivate lift and open door
	label(0x66)
	set_object_flag(0x39, OBJFLAG_40000000)
	set_object_flag(0x3a, OBJFLAG_40000000)
	unset_object_flag(OBJ_HANGARLIFT_JO, OBJFLAG_DEACTIVATED)
	open_door(0x39)
	open_door(0x3a)
	yield
	set_object_flag(OBJ_HANGARLIFT_JO, OBJFLAG_DEACTIVATED)

	beginloop(0x67)
		dprint 'T','R','\n',0,
		chr_toggle_p1p2(CHR_SELF)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2c)
		if_chr_in_room(CHR_BOND, 0x00, 0x0018, /*goto*/ 0x2c)
		if_door_state(0x39, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x2d)
		if_door_state(0x3a, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x2d)
	endloop(0x67)

	// Door closing automatically - reopen it
	label(0x2d)
	dprint 'P','E','\n',0,
	goto_first(0x66)

	// Jo has entered the lift, or Jo dead in co-op
	label(0x2c)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2c)
	if_chr_in_room(CHR_COOP, 0x00, 0x0018, /*goto*/ 0x2c)
	goto_first(0x67)

	// Jo or Velvet is in the lift - activate it
	// Note the lift naturally waits 5 seconds at each stop,
	// hence the 5 second wait if entered as soon as the door opens.
	label(0x2c)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	unset_object_flag(0x39, OBJFLAG_40000000)
	unset_object_flag(0x3a, OBJFLAG_40000000)
	unset_object_flag(OBJ_HANGARLIFT_JO, OBJFLAG_DEACTIVATED)

	// Wait until Y coordinate >= 400
	beginloop(0x09)
		dprint 'P','U','\n',0,
		chr_toggle_p1p2(CHR_SELF)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ 0x2c)
		if_chr_y(CHR_P1P2, 400, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x0a)

		label(0x2c)
	endloop(0x09)

	// Wait until lift stopped at top
	beginloop(0x0a)
		if_lift_stationary(OBJ_HANGARLIFT_JO, /*goto*/ 0x2c)
	endloop(0x0a)

	label(0x2c)
	set_object_flag(OBJ_HANGARLIFT_JO, OBJFLAG_DEACTIVATED)
	unset_object_flag(OBJ_HANGARLIFT_ELVIS, OBJFLAG_DEACTIVATED)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x2c)
	set_ailist(CHR_ELVIS, GAILIST_STOP_AND_IDLE)
	yield
	if_chr_y(CHR_ELVIS, 400, OPERATOR_LESS_THAN, /*goto*/ 0x06)
	goto_next(0x2c)

	// Warp Elvis to his lift
	label(0x06)

	beginloop(0x5c)
		chr_move_to_pad(CHR_ELVIS, 0x00ad, 0x00, /*goto*/ 0x2c)
		chr_move_to_pad(CHR_ELVIS, 0x01e6, 0x00, /*goto*/ 0x2c)
		chr_move_to_pad(CHR_ELVIS, 0x01e7, 0x00, /*goto*/ 0x2c)
	endloop(0x5c)

	// Activate his lift and wait 2 seconds
	label(0x2c)
	unset_object_flag(OBJ_HANGARLIFT_ELVIS, OBJFLAG_DEACTIVATED)
	restart_timer

	beginloop(0x0b)
		if_timer_gt(120, /*goto*/ 0x0c)
	endloop(0x0b)

	// Wait for lift to stop at top
	beginloop(0x0c)
		if_lift_stationary(OBJ_HANGARLIFT_ELVIS, /*goto*/ 0x2c)
	endloop(0x0c)

	label(0x2c)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x2c)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_FOLLOW)
	label(0x2c)

	// Check Elvis actually rode the lift up, and if not then go into a loop
	// attempting to warp him.
	beginloop(0x64)
		set_object_flag(OBJ_HANGARLIFT_ELVIS, OBJFLAG_DEACTIVATED)
		unset_object_flag(0x3b, OBJFLAG_CANNOT_ACTIVATE)
		unset_object_flag(0x3c, OBJFLAG_CANNOT_ACTIVATE)
		unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
		if_chr_y(CHR_ELVIS, 400, OPERATOR_LESS_THAN, /*goto*/ 0x06)
		goto_next(0x68)

		// Handle case where Elvis is still in the hangar for some reason
		label(0x06)
		set_ailist(CHR_ELVIS, AILIST_SET_CLOAKED)

		beginloop(0x6d)
			chr_move_to_pad(CHR_ELVIS, 0x0012, 0x01, /*goto*/ 0x2c)
		endloop(0x6d)

		label(0x2c)
		set_ailist(CHR_ELVIS, AILIST_SET_UNCLOAKED)
	endloop(0x64)

	// Elvis is at top now
	// For buddy or counterop who might still be in the hangar,
	// wait for lift to be called from hangar
	beginloop(0x68)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x3b, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x3c, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_ANTI, 0x3b, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_ANTI, 0x3c, /*goto*/ 0x2c)
	endloop(0x68)

	// Bring Elvis's lift down
	label(0x2c)
	play_sound(0x81a6, -1)
	unset_object_flag(OBJ_HANGARLIFT_ELVIS, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield

	// Wait for it to arrive at bottom
	beginloop(0x69)
		if_lift_stationary(OBJ_HANGARLIFT_ELVIS, /*goto*/ 0x2c)
	endloop(0x69)

	// Wait for lift to be moving again (upwards)
	label(0x2c)

	beginloop(0x6a)
		if_lift_stationary(OBJ_HANGARLIFT_ELVIS, /*goto*/ 0x06)
		goto_next(0x2c)

		label(0x06)
	endloop(0x6a)

	label(0x2c)
	yield
	yield
	yield
	yield

	// Wait for lift stopped at top
	beginloop(0x6b)
		if_lift_stationary(OBJ_HANGARLIFT_ELVIS, /*goto*/ 0x2c)
	endloop(0x6b)

	// Go back to waiting for lift to be called from hangar
	label(0x2c)
	goto_first(0x64)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0407_init_knifeable_skedar[] = {
	add_health_or_armor(160)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	set_self_chrflag(CHRCFLAG_00040000)
	set_ailist(CHR_SELF, AILIST_KNIFEABLE_SKEDAR)
	endlist
};

u8 func0408_knifeable_skedar[] = {
	set_shotlist(AILIST_KNIFEABLE_SKEDAR)
	if_just_injured(CHR_SELF, /*goto*/ 0x0c)
	label(0x08)
	yield
	label(0x2c)
	restart_timer
	set_target_chr(CHR_CASS)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x04)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_CASS_AT_PAD, TRUE, /*goto*/ 0x06)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x0c)
		set_target_chr(CHR_CASS)
		if_just_injured(CHR_SELF, /*goto*/ 0x0c)
	endloop(0x04)

	// Cass at pad - wait 2 seconds
	label(0x06)
	restart_timer

	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0x09)

	// Move to spot where Cass dies
	label(0x2c)
	set_target_chr(CHR_P1P2)
	jog_to_pad(0x00dd)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_stopped(/*goto*/ 0x06)
		if_target_in_sight(/*goto*/ 0x0c)
		if_just_injured(CHR_SELF, /*goto*/ 0x0c)
	endloop(0x0a)

	// Face away from player and wait 10 seconds
	label(0x06)
	restart_timer
	set_target_chr(CHR_CASS)
	try_face_entity(ENTITYTYPE_PAD, 0x00ef, /*goto*/ 0x0b)

	beginloop(0x0b)
		chr_toggle_p1p2(CHR_SELF)
		if_timer_gt(600, /*goto*/ 0x06)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x0c)
		if_just_injured(CHR_SELF, /*goto*/ 0x0c)
		set_target_chr(CHR_CASS)
	endloop(0x0b)

	// Go to holding cell
	label(0x06)
	set_view_distance(100)
	jog_to_pad(0x00d9)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_just_injured(CHR_SELF, /*goto*/ 0x0c)
		dprint 'W','A','I','T','I','N','G',' ','T','W','O','\n',0,
		if_chr_stopped(/*goto*/ 0x0d)
		label(0x06)
		if_target_in_sight(/*goto*/ 0x0c)
		label(0x2c)
	endloop(0x0a)

	// Saw player or got injured
	label(0x0c)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	// Arrived at cell - wait 20 seconds
	label(0x0d)
	restart_timer

	beginloop(0x0e)
		if_timer_gt(1200, /*goto*/ 0x2c)
	endloop(0x0e)

	// Go back to Cass spot
	label(0x2c)
	jog_to_pad(0x00dd)

	beginloop(0x0f)
		if_chr_stopped(/*goto*/ 0x2c)
	endloop(0x0f)

	// Become idle
	label(0x2c)
	stop_chr
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Door is the second door. The one to the main room.
 */
u8 func1009_keep_door_open_in_intro[] = {
	beginloop(0xc2)
		if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x06)
		if_door_state(0x17, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x2c)
		reloop(0xc2)

		// Door closed
		label(0x2c)
		open_door(0x17)
	endloop(0xc2)

	// Intro finished
	label(0x06)
	yield
	yield

	beginloop(0x04)
		if_door_state(0x17, DOORSTATE_CLOSING, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_chr_flag_bankx(CHR_KNIFEABLE_SKEDAR, CHRFLAG0_00002000, BANK_0)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_path(pathid) \
	set_accuracy(20) \
	set_reaction_speed(75) \
	set_chr_maxdamage(CHR_SELF, 10) \
	add_health_or_armor(190) \
	set_recovery_speed(0) \
	set_shield(0) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_RELATED_TO_SPAWNING)



u8 func0401_start_path00[] = {
	init_path(0)
	endlist
};

u8 func0402_start_path01[] = {
	init_path(1)
	endlist
};

u8 func0403_start_path02[] = {
	init_path(2)
	endlist
};

u8 func0404_start_path03[] = {
	init_path(3)
	endlist
};

u8 func0405_start_path04[] = {
	init_path(4)
	endlist
};

u8 func0406_start_path05[] = {
	init_path(5)
	endlist
};

u8 func0412_hangarspawner[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_KILLCOUNTABLE)
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)
	set_morale(0)

	beginloop(0xc2)
		if_stage_flag_eq(STAGEFLAG_HANGAR_ALARM_ACTIVATED, TRUE, /*goto*/ 0x04)
	endloop(0xc2)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_HANGAR_KILLS_DONE, FALSE, /*goto*/ 0x2c)
		yield
		yield
		yield
		yield
		yield
		goto_next(0x08)

		// Still killing
		label(0x2c)
		if_never_been_onscreen(/*goto*/ 0x4d)
		if_chr_sees_player(/*goto*/ 0x08)
		reloop(0x04)

		// Seen player, or kills done
		label(0x08)
		unset_self_chrflag(CHRCFLAG_HIDDEN)
		set_ailist(CHR_SELF, AILIST_HANGARCLONE)

		// chrflag3_00000008 was unset
		label(0x4d)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4d)
		reloop(0x04)

		// Clone dead
		label(0x4d)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_HANGARCLONE, 0x00000000, /*goto*/ 0x2c)
		set_ailist(CHR_SELF, AILIST_HANGARCLONE)
		label(0x2c)
		add_morale(1)
		yield
	endloop(0x04)

	endlist
};

u8 func0413_init_hangarclone[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_KILLCOUNTABLE)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	label(0x04)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x07, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_HANGARCLONE)
	endlist
};

u8 func0414_hangarclone[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_KILLCOUNTABLE)
	run_to_pad(0x00b4)
	set_returnlist(CHR_SELF, AILIST_HANGARCLONE)

	beginloop(0x03)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2c)
	endloop(0x03)

	label(0x2c)
	set_shotlist(AILIST_HANGARCLONE)
	set_returnlist(CHR_SELF, AILIST_HANGARCLONE)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func0419_hangar_maian[] = {
	set_shotlist(AILIST_HANGAR_MAIAN)
	set_self_chrflag(CHRCFLAG_NOAUTOAIM)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)

	// @bug: Shoddy programming here. The jump to label 0x06 is likely supposed
	// to go to the label 0x06 just prior to "AT PAD", but that is not the next
	// label from here. Also, SPEED_RUN will always be used because SPEED_JOG
	// lacks a goto_next 0x04.
	if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x06)

	// Distance to pad >= 200
	label(0x03)
	restart_timer
	if_chr_distance_to_pad_gt(CHR_SELF, 500, PAD_PRESET, /*goto*/ 0x06)
	go_to_target_pad(SPEED_JOG)

	// Intended: Distance to pad > 500
	// Actual: Always executes
	label(0x06)
	go_to_target_pad(SPEED_RUN)

	beginloop(0x04)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	goto_first(0x03)

	// Distance to pad < 200
	label(0x06)
	stop_chr

	// Wait at pad for enemy
	beginloop(0x09)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		if_chr_distance_to_pad_gt(CHR_SELF, 300, PAD_PRESET, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x03)

	// Enemy detected
	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_returnlist(CHR_SELF, AILIST_HANGAR_MAIAN)
	set_shotlist(AILIST_HANGAR_MAIAN)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	// Everything below here is unreachable
	label(0xb5)
	jog_to_pad(0x0034)

	beginloop(0x0f)
		if_chr_stopped(/*goto*/ 0x2c)
	endloop(0x0f)

	label(0x2c)
	restart_timer
	chr_do_animation(ANIM_SNEEZE, 0, 193, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0x10)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	show_hudmsg(CHR_BOND, L_LEE(13)) // "Navigational information has been retrieved."
	set_stage_flag(STAGEFLAG_NAVIGATION_ROOM_DONE)
	goto_first(0x03)

	endlist
};

u8 func0418_init_hangar_maian[] = {
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HANGAR_MAIANS, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	add_health_or_armor(200)
	set_reaction_speed(100)
	set_ailist(CHR_SELF, AILIST_HANGAR_MAIAN)
	endlist
};

u8 func100a_check_hangar_kills_done[] = {
	yield
	beginloop(0xc2)
		if_stage_flag_eq(STAGEFLAG_MET_ELVIS, TRUE, /*goto*/ 0x2c)
	endloop(0xc2)

	label(0x2c)
	restart_timer

	// Wait 2 minutes, or:
	// A = 6 kills
	// SA = 8 kills
	// PA = 10 kills
	beginloop(0x04)
		if_timer_gt(7200, /*goto*/ 0x2c)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x65)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x66)

		// PA
		if_kill_count_gt(9, /*goto*/ 0x2c)
		reloop(0x04)

		// A
		label(0x65)
		if_kill_count_gt(5, /*goto*/ 0x2c)
		reloop(0x04)

		// SA
		label(0x66)
		if_kill_count_gt(7, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	set_stage_flag(STAGEFLAG_HANGAR_KILLS_DONE)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_GO_TO_HANGAR_LIFT)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_msg_getshieldsdown[] = {
	restart_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	restart_timer

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_CASS_SCREAMING, TRUE, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	restart_timer

	beginloop(0xc2)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0xc2)

	label(0x06)
	speak(CHR_BOND, L_LEE(16), 0x81a0, CHANNEL_6, COLOR_04_ORANGE) // "Outside, Joanna. Get the shields down and we can h..."
	set_stage_flag(STAGEFLAG_SAID_GETSHIELDSDOWN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_engineroom[] = {
	set_lights_state(0x0067, 0x04, 0x46, 0xff, 0xfa)

	// Wait until both engines destroyed
	beginloop(0x04)
		if_object_in_good_condition(OBJ_ENGINE1, /*goto*/ 0x2c)
		if_object_in_good_condition(OBJ_ENGINE2, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
	endloop(0x04)

	label(0x06)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x2c)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_RUN_FROM_ENGINEROOM)
	play_x_music(CHANNEL_10, 10)
	speak(CHR_BOND, L_LEE(46), 0x73d7, CHANNEL_6, COLOR_04_ORANGE) // "We have to get out of here!"
	label(0x2c)
	set_countdown_timer(10)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x65)
		if_countdown_timer_lt(1, /*goto*/ 0x2c)
	endloop(0x65)

	// Timer expired
	label(0x2c)
	unset_object_flag(0x1b, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x1c, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x1d, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x1e, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x1f, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x20, OBJFLAG_INVINCIBLE)
	set_object_flag2(0x1b, OBJFLAG2_80000000)
	set_object_flag2(0x1c, OBJFLAG2_80000000)
	set_object_flag2(0x1d, OBJFLAG2_80000000)
	set_object_flag2(0x1e, OBJFLAG2_80000000)
	set_object_flag2(0x1f, OBJFLAG2_80000000)
	set_object_flag2(0x20, OBJFLAG2_80000000)
	label(0x06)
	hide_countdown_timer
	unset_object_flag(0x21, OBJFLAG_INVINCIBLE)
	destroy_object(0x21)
	destroy_object(0x1b)
	destroy_object(0x1c)
	destroy_object(0x1d)
	destroy_object(0x1e)
	destroy_object(0x1f)
	destroy_object(0x20)
	show_hudmsg(CHR_BOND, L_LEE(23)) // "Engines have been disabled."
	set_stage_flag(STAGEFLAG_ENGINES_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This is the lift BEFORE the bridge lift.
 *
 * The lift moves automatically until you ride it up, then it stays at the top
 * unless called from below.
 */
u8 func100d_prebridgelift[] = {
	// Wait until Y >= 2600
	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, 2600, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x0a)

		label(0x2c)
	endloop(0x09)

	// Wait until lift stopped at top
	beginloop(0x0a)
		if_lift_stationary(OBJ_PREBRIDGELIFT, /*goto*/ 0x2c)
	endloop(0x0a)

	// Deactivate lift
	label(0x2c)
	label(0x64)
	set_object_flag(OBJ_PREBRIDGELIFT, OBJFLAG_DEACTIVATED)
	unset_object_flag(0x3d, OBJFLAG_CANNOT_ACTIVATE)
	unset_object_flag(0x3e, OBJFLAG_CANNOT_ACTIVATE)

	// Wait until lift called at bottom by buddy or counterop
	beginloop(0x68)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x3d, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x3e, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_ANTI, 0x3d, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_ANTI, 0x3e, /*goto*/ 0x2c)
	endloop(0x68)

	// Activate lift
	label(0x2c)
	play_sound(0x81a6, -1)
	unset_object_flag(OBJ_PREBRIDGELIFT, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield

	// Wait until stopped at bottom
	beginloop(0x69)
		if_lift_stationary(OBJ_PREBRIDGELIFT, /*goto*/ 0x2c)
	endloop(0x69)

	label(0x2c)

	// Wait until moving (upwards)
	beginloop(0x6a)
		if_lift_stationary(OBJ_PREBRIDGELIFT, /*goto*/ 0x06)
		goto_next(0x2c)

		label(0x06)
	endloop(0x6a)

	label(0x2c)
	yield
	yield
	yield
	yield

	// Wait until stopped at top
	beginloop(0x6b)
		if_lift_stationary(OBJ_PREBRIDGELIFT, /*goto*/ 0x2c)
	endloop(0x6b)

	label(0x2c)
	goto_first(0x64)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_bridgelift[] = {
	// Wait until Y >= 3600
	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, 3600, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x0a)

		label(0x2c)
	endloop(0x09)

	// Wait until lift stopped at top
	beginloop(0x0a)
		if_lift_stationary(OBJ_BRIDGELIFT, /*goto*/ 0x2c)
	endloop(0x0a)

	label(0x2c)
	set_stage_flag(STAGEFLAG_ENTERED_BRIDGE)

	// Deactive lift
	label(0x64)
	set_object_flag(OBJ_BRIDGELIFT, OBJFLAG_DEACTIVATED)
	unset_object_flag(0x2f, OBJFLAG_CANNOT_ACTIVATE)
	unset_object_flag(0x30, OBJFLAG_CANNOT_ACTIVATE)

	// Wait until lift called from below by buddy or counterop
	beginloop(0x68)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x2f, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x30, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_ANTI, 0x2f, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_ANTI, 0x30, /*goto*/ 0x2c)
	endloop(0x68)

	// Activate lift
	label(0x2c)
	play_sound(0x81a6, -1)
	unset_object_flag(OBJ_BRIDGELIFT, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield

	// Wait until lift stopped
	beginloop(0x69)
		if_lift_stationary(OBJ_BRIDGELIFT, /*goto*/ 0x2c)
	endloop(0x69)

	label(0x2c)

	// Wait until lift moving again (upwards)
	beginloop(0x6a)
		if_lift_stationary(OBJ_BRIDGELIFT, /*goto*/ 0x06)
		goto_next(0x2c)

		label(0x06)
	endloop(0x6a)

	label(0x2c)
	yield
	yield
	yield
	yield

	// Wait until lift stopped at top
	beginloop(0x6b)
		if_lift_stationary(OBJ_BRIDGELIFT, /*goto*/ 0x2c)
	endloop(0x6b)

	label(0x2c)
	goto_first(0x64)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Assigned to the two Skedar behind the bridge doors who must be killed to end
 * the level.
 */
u8 func0415_bridgespawner[] = {
	set_accuracy(20)
	set_reaction_speed(75)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(190)
	set_recovery_speed(0)
	set_shield(0)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_KILLCOUNTABLE)
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_chr_cloaked(CHR_SELF, TRUE, FALSE)
	set_self_chrflag(CHRCFLAG_00040000)
	set_morale(0)

	beginloop(0xc2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_BRIDGE_SPAWNING, TRUE, /*goto*/ 0x04)
	endloop(0xc2)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_BRIDGE_DOORS_UNLOCKED, TRUE, /*goto*/ 0x06)
		if_morale_lt(2, /*goto*/ 0x2c)

		// Doors are unlocked (have been spawning for over a minute)
		label(0x06)
		restart_timer

		beginloop(0x65)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x65)

		label(0x06)
		goto_next(0x08)

		// morale is 0 or 1
		label(0x2c)
		if_never_been_onscreen(/*goto*/ 0x4d)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x2c)
		if_chr_dying(CHR_CLONE, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CLONE, /*goto*/ 0x2c)
		label(0x2c)
		if_chr_sees_player(/*goto*/ 0x08)
	endloop(0x04)

	// Been spawning for 61 seconds, or Skedar can see player
	// Unhide and uncloak
	label(0x08)
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	yield
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_ailist(CHR_SELF, AILIST_INIT_BRIDGESPAWNER_REVEAL)

	// chrflag3_00000008 was unset
	// 1 in 256 chance of spawning on any given frame (or script invocation?)
	// or after 5 seconds just spawn one anyway.
	label(0x4d)
	restart_timer

	beginloop(0x10)
		call_rng
		if_timer_gt(300, /*goto*/ 0x2c)
		if_rand_lt(1, /*goto*/ 0x2c)
	endloop(0x10)

	// Check clone is dead
	label(0x2c)
	if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4d)
	if_chr_dying(CHR_CLONE, /*goto*/ 0x4d)
	if_chr_unloaded(CHR_CLONE, /*goto*/ 0x4d)
	goto_first(0x04)

	// Spawn
	label(0x4d)
	try_spawn_clone2(CHR_SELF, AILIST_INIT_BRIDGECLONE, 0x00000000, /*goto*/ 0x2c)
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	yield
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_ailist(CHR_SELF, AILIST_INIT_BRIDGESPAWNER_REVEAL)

	label(0x2c)
	add_morale(1)
	yield
	goto_first(0x04)

	endlist
};

u8 func0416_init_bridgeclone[] = {
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000)
	set_accuracy(20)
	set_reaction_speed(75)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(190)
	set_recovery_speed(0)
	set_shield(0)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_KILLCOUNTABLE)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	label(0x04)
	rebuild_teams
	rebuild_squadrons

	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x2c)
	try_inherit_properties(CHR_BRIDGESPAWNER1, /*goto*/ 0x06)

	label(0x06)
	goto_next(0x06)

	label(0x2c)
	try_inherit_properties(CHR_BRIDGESPAWNER2, /*goto*/ 0x06)

	label(0x06)
	add_health_or_armor(40)
	set_ailist(CHR_SELF, AILIST_BRIDGECLONE)
	endlist
};

/**
 * Assigned to the two bridge spawners when they stop sending clones and reveal
 * themselves. Kill count isn't actually used to check if they're dead, so this
 * function isn't necessary.
 */
u8 func0417_init_spawner_reveal[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_KILLCOUNTABLE)
	set_ailist(CHR_SELF, AILIST_BRIDGECLONE)
	endlist
};

u8 func041a_bridgeclone[] = {
	set_shotlist(AILIST_BRIDGECLONE)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	goto_next(0x06)

	// Dying
	label(0x2c)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00020000)
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x2c)
	set_target_chr(CHR_ELVIS)
	goto_next(0xc2)

	label(0x2c)
	call_rng
	if_rand_gt(128, /*goto*/ 0x2c)
	set_target_chr(CHR_COOP)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2c)
	goto_next(0xc2)

	label(0x2c)
	set_target_chr(CHR_BOND)
	label(0x03)

	beginloop(0xc2)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2c)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
		if_enemy_distance_lt_and_los(1000, /*goto*/ 0x06)
	endloop(0xc2)

	// Has target - walk towards for 2 seconds
	label(0x06)
	if_distance_to_target_lt(150, /*goto*/ 0x2e)
	label(0xc5)
	restart_timer
	try_walk_to_target(/*goto*/ 0x08)

	beginloop(0x08)
		if_chr_dying(CHR_SELF, /*goto*/ 0xb8)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
		if_timer_gt(120, /*goto*/ 0x09)
	endloop(0x08)

	label(0x09)
	restart_timer
	try_run_to_target(/*goto*/ 0x0a)

	// Start running
	beginloop(0x0a)
		if_chr_dying(CHR_SELF, /*goto*/ 0xb8)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
		if_target_moving_away(/*goto*/ 0x2c)
		if_distance_to_target_lt(150, /*goto*/ 0x2e)
		label(0x2c)
		if_distance_to_target_lt(50, /*goto*/ 0x2e)
		if_timer_gt(14, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	goto_first(0x09)

	// Close to target - face them
	label(0x2e)
	restart_timer
	dprint 'F','A','C','E',' ','T','A','R','G','E','T','\n',0,
	if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
	if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
	stop_chr
	try_face_entity(0x0200, 0x0001, /*goto*/ 0x0b)

	beginloop(0x0b)
		if_chr_dying(CHR_SELF, /*goto*/ 0xb8)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x0b)

	// Attempt punch or kick
	label(0x06)
	try_punch_or_kick(/*goto*/ 0x2f)
	goto_first(0x03)

	beginloop(0x2f)
		if_chr_dying(CHR_SELF, /*goto*/ 0xb8)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x2f)

	// Attack finished
	label(0x06)
	goto_first(0x03)

	// Target chr dying
	label(0x10)
	stop_chr

	beginloop(0x0f)
		if_chr_dying(CHR_SELF, /*goto*/ 0xb8)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x06)
	endloop(0x0f)

	label(0x06)
	goto_first(0xc2)

	label(0xb8)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_bridge_entry[] = {
	// Wait until 3 bridge Skedar dead
	beginloop(0x09)
		if_chr_dying(CHR_BRIDGE1, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_BRIDGE1, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_BRIDGE1, /*goto*/ 0x2c)
		reloop(0x09)

		label(0x2c)
		if_chr_dying(CHR_BRIDGE2, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_BRIDGE2, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_BRIDGE2, /*goto*/ 0x2c)
		reloop(0x09)

		label(0x2c)
		if_chr_dying(CHR_BRIDGE3, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_BRIDGE3, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_BRIDGE3, /*goto*/ 0x2c)
	endloop(0x09)

	label(0x2c)
	label(0x2c)
	label(0x06)
	restart_timer

	// Wait 11.66 seconds
	beginloop(0x0a)
		if_timer_gt(700, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	set_stage_flag(STAGEFLAG_ELVIS_COMING_TO_BRIDGE)
	set_ailist(CHR_ELVIS, GAILIST_STOP_AND_IDLE)
	yield
	if_chr_y(CHR_ELVIS, 3500, OPERATOR_LESS_THAN, /*goto*/ 0x65)
	goto_next(0x2c)

	// Elvis is somewhere below - warp him up
	beginloop(0x65)
		chr_move_to_pad(CHR_ELVIS, 0x00a7, 0x01, /*goto*/ 0x2c)
	endloop(0x65)

	label(0x2c)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_AT_BRIDGE)
	restart_timer

	// Wait another 11.66 seconds
	beginloop(0x08)
		if_timer_gt(700, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_BRIDGE_SPAWNING)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_check_bridge_captured[] = {
	beginloop(0xc2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_BRIDGE_SPAWNING, TRUE, /*goto*/ 0x2c)
	endloop(0xc2)

	// Wait for 2 spawner skedar to be killed. If 60 seconds have passed,
	// unlock the bridge doors in case they've gotten stuck or became unalert
	// or something.
	label(0x2c)
	restart_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_BRIDGE_DOORS_UNLOCKED, TRUE, /*goto*/ 0x2c)
		if_timer_gt(3600, /*goto*/ 0x0d)
		label(0x2c)
		if_chr_death_animation_finished(CHR_BRIDGESPAWNER1, /*goto*/ 0x2c)
		if_chr_dying(CHR_BRIDGESPAWNER1, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_BRIDGESPAWNER1, /*goto*/ 0x2c)
		reloop(0x09)

		label(0x2c)
		if_chr_death_animation_finished(CHR_BRIDGESPAWNER2, /*goto*/ 0x2c)
		if_chr_dying(CHR_BRIDGESPAWNER2, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_BRIDGESPAWNER2, /*goto*/ 0x2c)
	endloop(0x09)

	// 60 seconds elapsed
	label(0x0d)
	set_stage_flag(STAGEFLAG_BRIDGE_DOORS_UNLOCKED)
	unlock_door(0x46, 0x40)
	unlock_door(0x47, 0x40)
	unlock_door(0x48, 0x40)
	unlock_door(0x49, 0x40)
	goto_first(0x09)

	label(0x2c)
	show_hudmsg(CHR_BOND, L_LEE(25)) // "Bridge has been captured."
	set_stage_flag(STAGEFLAG_BRIDGE_CAPTURED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_check_end_level[] = {
	beginloop(0x09)
		if_all_objectives_complete(/*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2c)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2c)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2c)
	goto_next(0x06)

	// Both players dead
	label(0x2c)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Either buddy is alive
	label(0x06)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x2c)

	// Mission complete
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)

	// Elvis dead
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1003_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_ATTACKSHIP_INTRO)
	camera_movement(0x01c2)
	cmd0175(60)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01c3, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	set_chr_chrflag(CHR_CASS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_CASS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_CASS, CHRHFLAG_00020000)
	chr_do_animation(0x01c4, -1, -1, 0x06, 0x00, CHR_CASS, 4)

	set_chr_chrflag(CHR_INTRO_SKEDAR, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_INTRO_SKEDAR, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_INTRO_SKEDAR, CHRHFLAG_00020000)
	chr_do_animation(0x01c5, -1, -1, 0x06, 0x00, CHR_INTRO_SKEDAR, 4)

	restart_timer
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0xb0) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_until(60, 0x9a)
	play_sound(0x0171, CHANNEL_10)

	wait_until(120, 0xac)
	play_sound(0x775a, CHANNEL_10)

	wait_until(136, 0x9b)
	play_sound(0x0172, CHANNEL_10)

	wait_until(186, 0x9c)
	play_sound(0x0173, CHANNEL_10)

	wait_until(226, 0x9d)
	play_sound(0x0174, CHANNEL_10)

	wait_until(320, 0x9e)
	speak(CHR_BOND, L_LEE(32), 0x747f, CHANNEL_10, COLOR_09_BLUE) // "Oohhh... I'd better not be where I think I am."

	wait_until(505, 0x9f)
	play_sound(0x0427, CHANNEL_10)

	wait_until(600, 0xa0)
	speak(CHR_BOND, L_LEE(33), 0x7480, CHANNEL_10, COLOR_04_ORANGE) // "And it's worse than that, my dear. Just look who y..."

	wait_until(1000, 0xa1)
	speak(CHR_BOND, L_LEE(34), 0x7481, CHANNEL_10, COLOR_09_BLUE) // "You! I thought you'd managed to escape. We found n..."

	wait_until(1018, 0xa2)
	play_sound(0x0175, CHANNEL_10)

	wait_until(1142, 0xa3)
	play_sound(0x0176, CHANNEL_10)

	wait_until(1168, 0xa4)
	play_sound(0x0177, CHANNEL_10)

	wait_until(1210, 0xa5)
	play_sound(0x0178, CHANNEL_10)

	wait_until(1260, 0xa6)
	play_sound(0x0171, CHANNEL_10)

	wait_until(1298, 0xa7)
	play_sound(0x0172, CHANNEL_10)

	wait_until(1358, 0x65)
	play_sound(0x0173, CHANNEL_10)

	wait_until(1396, 0x66)
	play_sound(0x0172, CHANNEL_10)

	wait_until(1400, 0xa8)
	speak(CHR_BOND, L_LEE(35), 0x7482, CHANNEL_10, COLOR_04_ORANGE) // "You couldn't find me. But there was no hiding from..."

	wait_until(1520, 0x67)
	play_sound(0x0176, CHANNEL_10)

	wait_until(1592, 0x68)
	play_sound(0x0177, CHANNEL_10)

	wait_until(1600, 0x69)
	play_sound(0x0174, CHANNEL_10)

	wait_until(1656, 0x6a)
	play_sound(0x0175, CHANNEL_10)

	wait_until(1728, 0x6b)
	play_sound(0x0178, CHANNEL_10)

	wait_until(1734, 0x6c)
	play_sound(0x0172, CHANNEL_10)

	wait_until(1770, 0x6e)
	play_sound(0x0173, CHANNEL_10)

	wait_until(1810, 0x61)
	open_door(0x17)
	play_sound(0x801e, CHANNEL_10)
	play_sound(0x0530, CHANNEL_10)

	wait_until(1870, 0x6f)
	speak(CHR_BOND, L_LEE(36), 0x7483, CHANNEL_10, COLOR_04_ORANGE) // "This is it. Wait there! I'll make a distraction; i..."

	wait_until(1874, 0x70)
	play_sound(0x0174, CHANNEL_10)

	wait_until(1930, 0x71)
	play_sound(0x0175, CHANNEL_10)

	wait_until(1986, 0x72)
	play_sound(0x05a2, CHANNEL_10)

	wait_until(2040, 0x73)
	play_sound(0x05a3, CHANNEL_10)

	wait_until(2108, 0x74)
	play_sound(0x05a2, CHANNEL_10)

	wait_until(2168, 0x75)
	play_sound(0x05a3, CHANNEL_10)

	wait_until(2226, 0x76)
	play_sound(0x0531, CHANNEL_10)

	wait_until(2232, 0x77)
	play_sound(0x05a2, CHANNEL_10)

	wait_until(2300, 0x62)
	close_door(0x17)

	wait_until(2346, 0x78)

	wait_until(2424, 0x79)
	play_sound(0x05a3, CHANNEL_10)

	wait_until(2468, 0x7a)
	play_sound(0x0530, CHANNEL_10)

	wait_until(2474, 0x7b)
	play_sound(0x05a2, CHANNEL_10)

	wait_until(2560, 0x7c)
	play_sound(0x0176, CHANNEL_10)

	wait_until(2580, 0x7d)
	play_sound(0x0177, CHANNEL_10)

	wait_until(2581, 0x7e)
	speak(CHR_BOND, L_LEE(37), 0x7484, CHANNEL_10, COLOR_09_BLUE) // "Why are you doing this, Cassandra?"

	wait_until(2614, 0x7f)
	play_sound(0x0171, CHANNEL_10)

	wait_until(2648, 0x80)
	play_sound(0x0178, CHANNEL_10)

	wait_until(2670, 0x81)
	play_sound(0x0172, CHANNEL_10)

	wait_until(2708, 0x82)
	play_sound(0x0173, CHANNEL_10)

	wait_until(2736, 0x83)
	play_sound(0x0174, CHANNEL_10)

	wait_until(2780, 0x84)
	play_sound(0x0175, CHANNEL_10)

	wait_until(2790, 0x85)
	speak(CHR_BOND, L_LEE(38), 0x7485, CHANNEL_10, COLOR_04_ORANGE) // "The Skedar used me, Joanna. You are my best chance..."

	wait_until(2792, 0x86)
	play_sound(0x0172, CHANNEL_10)

	wait_until(2834, 0x87)
	play_sound(0x0176, CHANNEL_10)

	wait_until(3016, 0x88)
	play_sound(0x01dc, CHANNEL_10)

	wait_until(3068, 0x89)
	play_sound(0x043a, CHANNEL_10)
	play_sound(0x043d, CHANNEL_10)

	wait_until(3186, 0x63)
	open_door(0x24)

	wait_until(3238, 0x8a)
	play_sound(0x0177, CHANNEL_10)

	wait_until(3258, 0x8b)
	play_sound(0x0172, CHANNEL_10)

	wait_until(3280, 0x8c)
	play_sound(0x0173, CHANNEL_10)
	close_door(0x24)

	wait_until(3313, 0x8d)
	play_sound(0x052a, CHANNEL_10)
	speak(CHR_BOND, L_LEE(39), 0x7c86, CHANNEL_10, COLOR_04_ORANGE) // "Eeeeaaarrrrggghhh!!!"

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0xb0)

		label(0x2c)
		if_controller_button_pressed(/*goto*/ 0xb0)
		label(0x2c)
	endloop(0x08)

	label(0xb0)
	label(0x06)
	set_stage_flag(STAGEFLAG_INTRO_FINISHED)
	open_door(0x17)
	mute_channel(CHANNEL_10)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01c3, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	unset_chr_chrflag(CHR_CASS, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_CASS, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_00000001)
	chr_do_animation(0x01c4, -2, -1, 0x06, 0x00, CHR_CASS, 2)

	unset_chr_chrflag(CHR_INTRO_SKEDAR, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_INTRO_SKEDAR, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_INTRO_SKEDAR, CHRCFLAG_00000001)
	chr_do_animation(0x01c5, -2, -1, 0x06, 0x00, CHR_INTRO_SKEDAR, 2)

	remove_chr(CHR_INTRO_SKEDAR)
	set_ailist(CHR_SHY_SKEDAR, AILIST_SHY_SKEDAR_WAIT)
	enter_firstperson
	yield
	chr_move_to_pad(CHR_CASS, 0x00df, 0x01, /*goto*/ 0x2c)
	label(0x2c)
	set_ailist(CHR_CASS, AILIST_CASS)
	restart_default_music
	reset_ambience
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c01_outro[] = {
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2c)
	set_target_chr(CHR_BOND)
	goto_next(0x06)

	label(0x2c)
	set_target_chr(CHR_COOP)
	label(0x06)
	hide_object(0x2c)
	camera_movement(0x01e1)
	set_music_track(MUSIC_ATTACKSHIP_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)

	set_chr_chrflag(CHR_TARGET, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TARGET, CHRHFLAG_00020000)
	chr_do_animation(0x01e2, -1, -1, 0x06, 0x00, CHR_TARGET, 4)

	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x01e3, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)

	show_object(OBJ_OUTRO_SHUTTLE)
	set_object_flag2(OBJ_OUTRO_SHUTTLE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_OUTRO_SHUTTLE, OBJFLAG3_00000010)
	object_do_animation(0x01e4, OBJ_OUTRO_SHUTTLE, 0x04, 0xffff)
	set_object_part_visible(OBJ_OUTRO_SHUTTLE, FALSE)

	show_nonessential_chrs(FALSE)
	restart_timer
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)

	wait_until(38, 0x65)
	play_sound(0x00f9, CHANNEL_10)

	wait_until(140, 0x66)
	play_sound(0x00fd, CHANNEL_10)

	wait_until(150, 0xa9)
	speak(CHR_BOND, L_LEE(40), 0x7487, CHANNEL_10, COLOR_09_BLUE) // "Wow. That's the first time I've seen another plane..."

	wait_until(368, 0x67)
	play_sound(0x00fa, CHANNEL_10)
	play_sound(0x00fb, CHANNEL_10)

	wait_until(540, 0x69)
	play_sound(0x00fe, CHANNEL_10)

	wait_until(550, 0x6b)
	play_sound(0x00fc, CHANNEL_10)

	wait_until(580, 0x6c)
	play_sound(0x00f9, CHANNEL_10)
	play_sound(0x00fb, CHANNEL_10)

	wait_until(690, 0x6e)
	speak(CHR_BOND, L_LEE(41), 0x7488, CHANNEL_10, COLOR_04_ORANGE) // "Hmmmm?"

	wait_until(850, 0x6f)
	speak(CHR_BOND, L_LEE(42), 0x7489, CHANNEL_10, COLOR_04_ORANGE) // "I don't... I don't believe it!"

	wait_until(963, 0x70)
	play_sound(0x80d4, CHANNEL_10)

	wait_until(972, 0x71)
	play_sound(0x80d8, CHANNEL_10)

	wait_until(988, 0x61)
	play_sound(0x80db, CHANNEL_10)

	wait_until(1000, 0x72)
	speak(CHR_BOND, L_LEE(43), 0x748a, CHANNEL_10, COLOR_09_BLUE) // "Elvis? What is it?"

	wait_until(1030, 0x73)
	play_sound(0x80da, CHANNEL_10)

	wait_until(1045, 0x74)
	play_sound(0x80d8, CHANNEL_10)

	wait_until(1065, 0x75)
	play_sound(0x80d9, CHANNEL_10)

	wait_until(1085, 0x76)
	play_sound(0x80da, CHANNEL_10)

	wait_until(1200, 0x77)
	speak(CHR_BOND, L_LEE(44), 0x748b, CHANNEL_10, COLOR_09_BLUE) // "Where are you going?"

	wait_until(1237, 0x78)
	play_sound(0x80db, CHANNEL_10)

	wait_until(1260, 0x79)
	play_sound(0x80d8, CHANNEL_10)

	wait_until(1280, 0x7a)
	play_sound(0x80d9, CHANNEL_10)

	wait_until(1300, 0x7b)
	play_sound(0x80da, CHANNEL_10)

	wait_until(1301, 0x62)
	speak(CHR_BOND, L_LEE(45), 0x748c, CHANNEL_10, COLOR_04_ORANGE) // "We have to get down to the surface! Follow me!"
	open_door(OBJ_HANGARDOOR1)
	open_door(OBJ_HANGARDOOR2)
	open_door(OBJ_HANGARDOOR3)
	open_door(OBJ_HANGARDOOR4)
	set_object_flag(OBJ_HANGARDOOR1, OBJFLAG_40000000)
	set_object_flag(OBJ_HANGARDOOR2, OBJFLAG_40000000)
	set_object_flag(OBJ_HANGARDOOR3, OBJFLAG_40000000)
	set_object_flag(OBJ_HANGARDOOR4, OBJFLAG_40000000)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0xb0)

		label(0x2c)
		if_controller_button_pressed(/*goto*/ 0xb0)
		label(0x2c)
	endloop(0x08)

	label(0xb0)
	mute_channel(CHANNEL_10)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_skedar(function) \
	set_accuracy(20) \
	set_reaction_speed(75) \
	set_chr_maxdamage(CHR_SELF, 10) \
	add_health_or_armor(190) \
	set_recovery_speed(0) \
	set_shield(0) \
	set_ailist(CHR_SELF, function)



u8 func041e_init_bridge1and2[] = {
	init_skedar(AILIST_BRIDGE_SKEDAR)
	endlist
};

u8 func0425_init_shy_skedar[] = {
	init_skedar(GAILIST_IDLE)
	endlist
};

u8 func0420_init_bridge3[] = {
	init_skedar(AILIST_BRIDGE_SKEDAR)
	endlist
};

/**
 * Assigned to the 3 Skedar on the bridge.
 */
u8 func0421_bridge_skedar[] = {
	set_shotlist(AILIST_BRIDGE_SKEDAR)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2c)

	// Dying
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x53)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x53)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x2c)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x08)

	// Injured
	label(0x06)
	set_view_distance(100)

	// Not injured
	label(0x08)
	set_self_chrflag(CHRCFLAG_00000040)
	label(0xc6)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	set_target_chr(CHR_BOND)
	try_chr_kneel_and_shoot_thing(0x0220, 0x0000, /*goto*/ 0xc7)
	label(0x06)
	kneel

	beginloop(0xc7)
		chr_toggle_p1p2(CHR_SELF)
		label(0x2c)
		set_target_chr(CHR_P1P2)
		if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x06)
		if_target_in_sight(/*goto*/ 0xc8)
		label(0x06)
		if_saw_injury(0x00, /*goto*/ 0xc8)
		if_near_miss(/*goto*/ 0xc9)
		label(0x2c)
		set_target_chr(CHR_P1P2)
		reloop(0xc7)

		label(0x06)
		if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x2c)
		if_target_in_sight(/*goto*/ 0xc8)
		label(0x2c)
		set_target_chr(CHR_BOND)
	endloop(0xc7)

	label(0xc8)
	set_view_distance(100)
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x2c)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	say_quip(CHR_BOND, 0x0b, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00)
	label(0x2c)
	goto_next(0xca)

	// Unreachable
	cmd0184(90, 100)

	// Reachable from below
	beginloop(0xcb)
		if_chr_stopped(/*goto*/ 0xcc)
	endloop(0xcb)

	label(0xcc)
	restart_timer
	stop_chr

	beginloop(0xb4)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0xb4)

	label(0x2c)
	label(0x06)
	goto_first(0xc6)

	// Near miss
	label(0xc9)
	set_view_distance(100)
	restart_timer
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0xcd)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)

	label(0xcd)
	call_rng
	chr_toggle_p1p2(CHR_SELF)
	set_target_chr(CHR_P1P2)
	if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x06)
	if_target_in_sight(/*goto*/ 0xce)
	label(0x06)
	if_timer_gt(60, /*goto*/ 0xcf)
	if_rand_lt(4, /*goto*/ 0xcf)
	goto_first(0xcd)

	label(0xcf)
	if_chr_sees_player(/*goto*/ 0xce)
	goto_first(0xc6)

	label(0xce)
	goto_first(0xc8)

	label(0xd0)
	restart_timer

	beginloop(0xd1)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0xce)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0xd1)

	label(0x06)
	goto_first(0xc6)

	label(0xce)
	goto_first(0xc8)

	label(0xca)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, FALSE, BANK_0, /*goto*/ 0x60)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0xb1)
	label(0xb1)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x06)
	goto_next(0x2c)

	label(0x60)
	cmd0184(40, 60)
	dprint 'F','I','R','E',' ','F','U','L','L','\n',0,
	label(0x06)
	goto_first(0xcb)

	label(0x2c)
	goto_first(0xcc)

	endlist
};

u8 func1013_msg_gottogetshieldsdown[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_SAID_GETSHIELDSDOWN, TRUE, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	restart_timer

	beginloop(0x08)
		if_timer_gt(300, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	speak(CHR_BOND, L_LEE(27), 0x73dc, CHANNEL_6, COLOR_09_BLUE) // "I've got to get those shields down to let Elvis in..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_msg_hangarbaydoors[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x09)
	restart_timer

	beginloop(0x04)
		if_objective_complete(0, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	restart_timer

	beginloop(0x08)
		if_timer_gt(240, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	speak(CHR_BOND, L_LEE(28), 0x73dd, CHANNEL_6, COLOR_09_BLUE) // "Now only the hangar bay doors are in the way."

	label(0x09)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_msg_starmaps[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x003e, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	speak(CHR_P1P2, L_LEE(29), 0x73de, CHANNEL_6, COLOR_09_BLUE) // "This machine contains the Skedar star maps."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_msg_ifwecontrolthebridge[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x006f, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	set_stage_flag(STAGEFLAG_ENTERED_BRIDGELIFT)
	unset_chr_chrflag(CHR_BRIDGE1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_BRIDGE2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_BRIDGE3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	speak(CHR_P1P2, L_LEE(30), 0x73df, CHANNEL_6, COLOR_09_BLUE) // "If we control the bridge, then the ship is ours."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0422_cass[] = {
	set_shotlist(GAILIST_IDLE)
	set_self_chrflag(CHRCFLAG_00040000)
	run_to_pad(0x01dd)

	beginloop(0x08)
		if_chr_distance_to_pad_lt(CHR_SELF, 300, 0x01dd, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	stop_chr
	set_stage_flag(STAGEFLAG_CASS_AT_PAD)

	// @bug: Looks like there's a missing goto_first 0x09 here.
	// With that statement, it would loop waiting for the Skedar to be ready.
	// As it stands, the check is pointless and Cass will do the screams and die
	// even if the Skedar is not ready.
	label(0x09)
	yield
	if_stage_flag_eq(STAGEFLAG_SHY_SKEDAR_READY, TRUE, /*goto*/ 0x2c)

	label(0x2c)
	play_sound(0x7c86, CHANNEL_10)
	set_stage_flag(STAGEFLAG_CASS_SCREAMING)

	beginloop(0xc2)
		damage_chr(CHR_SELF, 18)
		if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2c)
		if_chr_dying(CHR_SELF, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_SELF, /*goto*/ 0x2c)
	endloop(0xc2)

	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0423_shy_skedar[] = {
	set_shotlist(AILIST_INIT_SKEDAR)
	set_self_chrflag(CHRCFLAG_00000040)
	set_self_chrflag(CHRCFLAG_00040000)
	set_target_chr(CHR_CASS)
	goto_next(0x2c)

	if_self_flag_bankx_eq(CHRFLAG0_00008000, TRUE, BANK_0, /*goto*/ 0x03)
	label(0xc2)
	chr_move_to_pad(CHR_SELF, 0x00e0, 0x01, /*goto*/ 0x2c)

	// Warp failed or not available - so run
	label(0x03)
	set_target_chr(CHR_CASS)
	restart_timer
	try_run_to_target(/*goto*/ 0x08)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_SELF, 100, 0x00da, /*goto*/ 0x2d)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x08)

	// Stopped, or running for 1 second
	label(0x06)
	set_target_chr(CHR_CASS)
	goto_first(0x03)

	// Warped to pad 0x00e0 successfully - run rest of the way
	label(0x2c)
	run_to_pad(0x00da)

	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2d)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x00da, /*goto*/ 0x2d)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x09)

	// At pad
	// The first time through this function, STAGEFLAG_SHY_SKEDAR_READY will
	// be set. The second time through this function, stageflag 02000000 will
	// be set.
	label(0x2d)
	if_stage_flag_eq(STAGEFLAG_SHY_SKEDAR_READY, TRUE, /*goto*/ 0x2c)
	set_stage_flag(STAGEFLAG_SHY_SKEDAR_READY)
	goto_next(0x2d)

	label(0x2c)
	set_stage_flag(STAGEFLAG_02000000)

	// Set target chr based on who it can see
	label(0x2d)
	stop_chr
	set_target_chr(CHR_BOND)
	if_chr_sees_player(/*goto*/ 0x2c)
	set_target_chr(CHR_COOP)
	if_chr_sees_player(/*goto*/ 0x2c)
	set_target_chr(CHR_ANTI)
	if_chr_sees_player(/*goto*/ 0x2c)

	label(0x2c)
	stop_chr
	set_shotlist(AILIST_INIT_SKEDAR)
	set_returnlist(CHR_SELF, AILIST_INIT_SKEDAR)
	set_ailist(CHR_SELF, AILIST_INIT_SKEDAR)
	endlist
};

u8 func0423_shy_skedar_wait[] = {
	set_shotlist(AILIST_SHY_SKEDAR)
	set_target_chr(CHR_CASS)
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0)
	restart_timer

	beginloop(0x08)
		if_timer_gt(180, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	set_ailist(CHR_SELF, AILIST_SHY_SKEDAR)
	endlist
};

u8 func141b_setup_lifts[] = {
	activate_lift(1, 0x25)
	activate_lift(2, 0x26)
	activate_lift(4, 0x28)
	activate_lift(5, 0x29)
	activate_lift(6, 0x2a)
	activate_lift(7, 0x2b)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * In PA room where the hangar door console is. Once console is activated, or
 * when hangar alarm is activated, the Skedar behind the door is alerted.
 */
u8 func1017_pa_skedar_alertness[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_HANGAR_DOORS_OPEN, TRUE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_HANGAR_ALARM_ACTIVATED, TRUE, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	restart_timer

	beginloop(0x08)
		if_timer_gt(300, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	set_ailist(0x02, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1012_update_elvis_target_chr[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x09)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x08)
		goto_next(0x09)

		// Unreachable
		reloop(0x04)

		// Jo dead
		label(0x08)
		set_chr_target_chr(CHR_ELVIS, CHR_COOP)
		reloop(0x04)

		// Velvet dead or both alive
		label(0x09)
		set_chr_target_chr(CHR_ELVIS, CHR_BOND)
	endloop(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Note Elvis is still hidden, hence why he doesn't appear until shields are
 * down.
 */
u8 func1018_place_elvis_in_hangar[] = {
	label(0x04)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x03)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// A and SA
	beginloop(0x03)
		chr_move_to_pad(CHR_ELVIS, 0x0103, 0x01, /*goto*/ 0x2c)
	endloop(0x03)

	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_hangar_shuttle[] = {
	yield
	show_object(OBJ_HANGAR_SHUTTLE)
	set_object_flag3(OBJ_HANGAR_SHUTTLE, OBJFLAG3_00000010)
	set_object_part_visible(OBJ_HANGAR_SHUTTLE, FALSE)

	label(0x09)
	restart_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_BRIDGE_CAPTURED, TRUE, /*goto*/ 0x06)
		if_objective_complete(4, /*goto*/ 0x06)
		object_do_animation(0x045c, OBJ_HANGAR_SHUTTLE, 0x08, 0xffff)
	endloop(0x08)

	label(0x2c)
	goto_first(0x09)

	label(0x06)
	hide_object(OBJ_HANGAR_SHUTTLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_kill_maian[] = {
	yield
	damage_chr(CHR_MAIAN3, 18)
	yield
	damage_chr(CHR_MAIAN3, 18)
	yield
	damage_chr(CHR_MAIAN3, 18)
	yield
	damage_chr(CHR_MAIAN3, 18)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_lift_door_sounds[] = {
	beginloop(0xc2)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x2f, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x30, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x31, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x32, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x33, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x34, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x35, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x36, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x37, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x38, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x39, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x3a, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x3d, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, 0x3e, /*goto*/ 0x2c)
	endloop(0xc2)

	label(0x2c)
	dprint 'S','O','U','N','D','\n',0,
	play_sound(0x81a6, -1)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	goto_first(0xc2)

	endlist
};

u8 func101d_unlock_doors[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2c)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)

	// PA - unlock door to console on other side of hangar
	unlock_door(0x35, 0x80)
	unlock_door(0x36, 0x80)

	// SA and PA - unlock door to engine room
	label(0x06)
	unlock_door(0x3f, 0x80)
	unlock_door(0x40, 0x80)

	// All difficulties
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101e_bridge_music[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_BOND, 0x00, 0x006e, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	play_x_music(CHANNEL_10, 60)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_elvis_run_from_engineroom[] = {
	set_shotlist(AILIST_ELVIS_RUN_FROM_ENGINEROOM)
	run_to_pad(0x005c)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_ENGINES_DESTROYED, TRUE, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW)
	endlist
};

u8 func101f_enable_bridge_skedar[] = {
	lock_door(0x41, 0x80)
	lock_door(0x42, 0x80)
	set_object_flag2(0x41, OBJFLAG2_LOCKEDBACK)
	set_object_flag2(0x42, OBJFLAG2_LOCKEDFRONT)
	set_object_flag2(0x41, OBJFLAG2_AICANNOTUSE)
	set_object_flag2(0x42, OBJFLAG2_AICANNOTUSE)

	// Wait until first 4 objectives complete
	beginloop(0x04)
		if_objective_complete(0, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2c)
		if_objective_complete(1, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_objective_complete(2, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2c)
		if_objective_complete(3, /*goto*/ 0x2c)
	reloop(0x04)

	label(0x2c)
	unlock_door(0x41, 0x80)
	unlock_door(0x42, 0x80)
	unset_object_flag2(0x41, OBJFLAG2_LOCKEDBACK)
	unset_object_flag2(0x42, OBJFLAG2_LOCKEDFRONT)
	unset_object_flag2(0x41, OBJFLAG2_AICANNOTUSE)
	unset_object_flag2(0x42, OBJFLAG2_AICANNOTUSE)
	show_chr(0x21)
	show_chr(0x22)
	show_chr(CHR_BRIDGE1)
	show_chr(CHR_BRIDGE2)
	show_chr(CHR_BRIDGE3)
	show_chr(CHR_BRIDGESPAWNER1)
	show_chr(CHR_BRIDGESPAWNER2)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1020_engine_hum_noise[] = {
	yield
	assign_sound(0x81a5, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, 0x1b, 0x07d0, 0x0fa0)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1021_check_ammo_wasted[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_SHIELDS_DISABLED, TRUE, /*goto*/ 0x0d)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_MAULER, /*goto*/ 0x65)
	endloop(0x04)

	// Mauler equipped
	beginloop(0x65)
		if_stage_flag_eq(STAGEFLAG_SHIELDS_DISABLED, TRUE, /*goto*/ 0x0d)
		if_ammo_quantity_lt(CHR_P1P2, AMMOTYPE_PISTOL, 1, /*goto*/ 0x2c)
	endloop(0x65)

	// Ammo wasted
	label(0x2c)
	set_stage_flag(STAGEFLAG_AMMO_WASTED)
	show_hudmsg(CHR_BOND, L_LEE(49)) // "Ammo depleted - consoles can't be destroyed."

	beginloop(0x66)
		if_stage_flag_eq(STAGEFLAG_SHIELDS_DISABLED, TRUE, /*goto*/ 0x2c)
	endloop(0x66)

	label(0x2c)
	unset_stage_flag(STAGEFLAG_AMMO_WASTED)

	// Shields disabled
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_setup_rtracker[] = {
	// @bug: The Slayer is not R-tracked
	yield
	set_object_flag3(OBJ_MAULER1, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_MAULER2, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040b_init_cass[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1024_set_bridge_skedar_invincible[] = {
	set_chr_chrflag(CHR_BRIDGE1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BRIDGE2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BRIDGE3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BRIDGE1, CHRCFLAG_UNEXPLODABLE)
	set_chr_chrflag(CHR_BRIDGE2, CHRCFLAG_UNEXPLODABLE)
	set_chr_chrflag(CHR_BRIDGE3, CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Wait 10 seconds then set a flag on Joanna which enables buddy to warp to her.
 */
u8 unregistered_function1[] = {
	restart_timer

	beginloop(0x04)
		if_timer_gt(600, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1423_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x09, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1025_toggle_chrs[] = {
	yield
	hide_chr(0x0b)
	hide_chr(0x0c)
	hide_chr(CHR_SUSPENDEDANIM1)
	hide_chr(CHR_SUSPENDEDANIM2)
	hide_chr(CHR_SUSPENDEDANIM3)
	hide_chr(CHR_SUSPENDEDANIM4)
	hide_chr(0x11)
	hide_chr(0x12)
	hide_chr(0x13)
	hide_chr(0x14)
	hide_chr(0x15)
	hide_chr(0x16)
	hide_chr(0x17)
	hide_chr(0x18)
	hide_chr(0x19)
	hide_chr(0x1a)
	hide_chr(0x1b)
	hide_chr(0x1c)
	hide_chr(0x1d)
	hide_chr(0x1e)
	hide_chr(0x1f)
	hide_chr(0x20)
	hide_chr(0x27)
	hide_chr(0x28)
	hide_chr(0x29)
	hide_chr(0x2a)
	hide_chr(0x2b)
	hide_chr(0x2c)
	hide_chr(0x21)
	hide_chr(0x22)
	hide_chr(CHR_BRIDGE1)
	hide_chr(CHR_BRIDGE2)
	hide_chr(CHR_BRIDGE3)
	hide_chr(CHR_BRIDGESPAWNER1)
	hide_chr(CHR_BRIDGESPAWNER2)

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, 450, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
	endloop(0x08)

	label(0x06)
	show_chr(0x0b)
	yield
	show_chr(0x0c)
	yield
	show_chr(CHR_SUSPENDEDANIM1)
	yield
	show_chr(CHR_SUSPENDEDANIM2)
	yield
	show_chr(CHR_SUSPENDEDANIM3)
	yield
	show_chr(CHR_SUSPENDEDANIM4)
	yield
	show_chr(0x11)
	yield
	show_chr(0x12)
	yield
	show_chr(0x13)
	yield
	show_chr(0x14)
	yield
	show_chr(0x15)
	yield
	show_chr(0x16)
	yield
	show_chr(0x17)
	yield
	show_chr(0x18)
	yield
	show_chr(0x19)
	yield
	show_chr(0x1a)
	yield
	show_chr(0x1b)
	yield
	show_chr(0x1c)
	yield
	show_chr(0x1d)
	yield
	show_chr(0x1e)
	yield
	show_chr(0x1f)
	yield
	show_chr(0x20)
	yield
	show_chr(0x27)
	yield
	show_chr(0x28)
	yield
	show_chr(0x29)
	yield
	show_chr(0x2a)
	yield
	show_chr(0x2b)
	yield
	show_chr(0x2c)
	yield
	set_ailist(CHR_MAIAN1, AILIST_CLOAK_AND_REMOVE)
	set_ailist(CHR_MAIAN2, AILIST_CLOAK_AND_REMOVE)
	set_ailist(0x07, AILIST_CLOAK_AND_REMOVE)
	set_ailist(0x08, AILIST_CLOAK_AND_REMOVE)
	set_ailist(0x09, AILIST_CLOAK_AND_REMOVE)
	set_ailist(0x0a, AILIST_CLOAK_AND_REMOVE)
	rebuild_teams
	rebuild_squadrons

	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, 550, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
	endloop(0x09)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func041f_cloak_and_remove[] = {
	set_shotlist(AILIST_CLOAK_AND_REMOVE)
	set_chr_cloaked(CHR_SELF, TRUE, FALSE)
	restart_timer

	beginloop(0x04)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1026_hide_necklace[] = {
	yield
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// A and SA
	label(0x2c)
	hide_object(OBJ_NECKLACE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0427_set_cloaked[] = {
	stop_chr
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0428_set_uncloaked[] = {
	stop_chr
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_ailist(CHR_SELF, AILIST_ELVIS_FOLLOW)
	endlist
};

struct ailist ailists[] = {
	{ func1400_setup_counterop,                  0x1400 },
	{ func1001_objectives_failed_msg,            0x1001 },
	{ func1002_hangar_shuttle,                   0x1002 },
	{ func1003_intro,                            0x1003 },
	{ func1004_check_hangar_doors_opened,        0x1004 },
	{ func1005_check_elvis_dead,                 0x1005 },
	{ func1006_wake_slayer_skedar,               0x1006 },
	{ func1007_check_entered_slayer_area,        0x1007 },
	{ func1008_hangar_lifts,                     0x1008 },
	{ func1009_keep_door_open_in_intro,          0x1009 },
	{ func100a_check_hangar_kills_done,          0x100a },
	{ func100b_msg_getshieldsdown,               0x100b },
	{ func100c_engineroom,                       0x100c },
	{ func100d_prebridgelift,                    0x100d },
	{ func100e_bridgelift,                       0x100e },
	{ func100f_bridge_entry,                     0x100f },
	{ func1010_check_bridge_captured,            0x1010 },
	{ func1011_check_end_level,                  0x1011 },
	{ func1012_update_elvis_target_chr,          0x1012 },
	{ func1013_msg_gottogetshieldsdown,          0x1013 },
	{ func1014_msg_hangarbaydoors,               0x1014 },
	{ func1015_msg_starmaps,                     0x1015 },
	{ func1016_msg_ifwecontrolthebridge,         0x1016 },
	{ func1017_pa_skedar_alertness,              0x1017 },
	{ func1018_place_elvis_in_hangar,            0x1018 },
	{ func1002_hangar_shuttle,                   0x1019 },
	{ func1019_check_shields_lowered,            0x1019 },
	{ func101a_kill_maian,                       0x101a },
	{ func141b_setup_lifts,                      0x141b },
	{ func101c_lift_door_sounds,                 0x101c },
	{ func101d_unlock_doors,                     0x101d },
	{ func101e_bridge_music,                     0x101e },
	{ func101f_enable_bridge_skedar,             0x101f },
	{ func1020_engine_hum_noise,                 0x1020 },
	{ func1021_check_ammo_wasted,                0x1021 },
	{ func1022_setup_rtracker,                   0x1022 },
	{ func1423_setup_lighting,                   0x1423 },
	{ func1024_set_bridge_skedar_invincible,     0x1024 },
	{ func1025_toggle_chrs,                      0x1025 },
	{ func1026_hide_necklace,                    0x1026 },
	{ func1003_intro,                            0x0c00 },
	{ func0c01_outro,                            0x0c01 },
	{ func0c01_outro,                            0x0426 },
	{ func040f_init_skedar,                      0x040f },
	{ func0410_wake_suspendedanim_skedar,        0x0410 },
	{ func040d_elvis_wait_for_hangar_entry,      0x040d },
	{ func040e_elvis_give_ar34,                  0x040e },
	{ func0409_elvis_follow,                     0x0409 },
	{ func040a_elvis_go_to_hangar_lift,          0x040a },
	{ func040b_init_cass,                        0x040b },
	{ func040c_elvis_run_from_engineroom,        0x040c },
	{ func0401_start_path00,                     0x0401 },
	{ func0402_start_path01,                     0x0402 },
	{ func0403_start_path02,                     0x0403 },
	{ func0404_start_path03,                     0x0404 },
	{ func0405_start_path04,                     0x0405 },
	{ func0406_start_path05,                     0x0406 },
	{ func0407_init_knifeable_skedar,            0x0407 },
	{ func0408_knifeable_skedar,                 0x0408 },
	{ func0412_hangarspawner,                    0x0412 },
	{ func0413_init_hangarclone,                 0x0413 },
	{ func0414_hangarclone,                      0x0414 },
	{ func0415_bridgespawner,                    0x0415 },
	{ func0416_init_bridgeclone,                 0x0416 },
	{ func0417_init_spawner_reveal,              0x0417 },
	{ func0418_init_hangar_maian,                0x0418 },
	{ func0419_hangar_maian,                     0x0419 },
	{ func0415_bridgespawner,                    0x0415 },
	{ func0416_init_bridgeclone,                 0x0416 },
	{ func0417_init_spawner_reveal,              0x0417 },
	{ func041a_bridgeclone,                      0x041a },
	{ func041b_elvis_at_bridge,                  0x041b },
	{ func041c_elvis_outside_prebridgelift,      0x041c },
	{ func041d_init_elvis_outside_prebridgelift, 0x041d },
	{ func041f_cloak_and_remove,                 0x041f },
	{ func041e_init_bridge1and2,                 0x041e },
	{ func0420_init_bridge3,                     0x0420 },
	{ func0421_bridge_skedar,                    0x0421 },
	{ func0422_cass,                             0x0422 },
	{ func0423_shy_skedar,                       0x0423 },
	{ func0423_shy_skedar_wait,                  0x0424 },
	{ func0425_init_shy_skedar,                  0x0425 },
	{ func0427_set_cloaked,                      0x0427 },
	{ func0428_set_uncloaked,                    0x0428 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ path03, 3, PATHTYPE_BACKANDFORTH },
	{ path04, 4, PATHTYPE_BACKANDFORTH },
	{ path05, 5, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

