//
// Defense
//

#include "stagesetup.h"

// Characters
#define CHR_CARRINGTON       0x00
#define CHR_HOSTAGE_DEVICE_F 0x01 // device room - female
#define CHR_HOSTAGE_FR1      0x02
#define CHR_HOSTAGE_INFO_M   0x03 // info room - male
#define CHR_HOSTAGE_HOLO     0x04 // holo
#define CHR_HANGARGUY        0x05 // wears hostage clothes but isn't a hostage
#define CHR_HOSTAGE_DEVICE_M 0x06 // device room - male
#define CHR_HOSTAGE_FR2      0x07
#define CHR_HOSTAGE_INFO_F   0x08 // info room - female
#define CHR_TAKER_FR1        0x1f
#define CHR_TAKER_FR2        0x20
#define CHR_TAKER_HOLO1      0x21
#define CHR_TAKER_HOLO2      0x22
#define CHR_TAKER_HOLO3      0x23
#define CHR_TAKER_DEVICE_M   0x24
#define CHR_TAKER_DEVICE_F   0x25
#define CHR_TAKER_INFO_F     0x26
#define CHR_TAKER_INFO_M     0x27
#define CHR_BLONDE1          0x28
#define CHR_BLONDE2          0x29
#define CHR_BLONDE3          0x2a
#define CHR_BLONDE4          0x2b
#define CHR_BLONDE5          0x2c
#define CHR_BLONDE6          0x2d
#define CHR_BLONDE7          0x30
#define CHR_SKEDAR1          0x31
#define CHR_SKEDAR2          0x32
#define CHR_SKEDAR3          0x33
#define CHR_SKEDAR4          0x34
#define CHR_HOLOCLONE1       0x35
#define CHR_HOLOCLONE2       0x36
#define CHR_HOLOCLONE3       0x37
#define CHR_JONATHAN         0x38

// Objects
#define OBJ_RCP120          0x05
#define OBJ_AUTOGUN1        0x06
#define OBJ_AUTOGUN2        0x07
#define OBJ_AUTOGUN3        0x08
#define OBJ_SAFEINFO        0x09
#define OBJ_AUTOGUN_SWITCH1 0x0a
#define OBJ_AUTOGUN_SWITCH2 0x0b
#define OBJ_AUTOGUN_SWITCH3 0x0c
#define OBJ_SAFEDOOR        0x39
#define OBJ_SKEDAR_SHUTTLE  0x3c
#define OBJ_RCP120_GLASS    0x3d
#define OBJ_FR_GLASS        0x3e
#define OBJ_DEVASTATOR      0x45
#define OBJ_FR_PC           0x4e
#define OBJ_DATAUPLINK_BOND 0x4f
#define OBJ_DATAUPLINK_COOP 0x50

// Stage flags
#define STAGEFLAG_00000001                         0x00000001 // never set
#define STAGEFLAG_AUTOGUN1_ACTIVE                  0x00000100
#define STAGEFLAG_AUTOGUN2_ACTIVE                  0x00000200
#define STAGEFLAG_AUTOGUN3_ACTIVE                  0x00000400
#define STAGEFLAG_ENOUGH_HOSTAGES_SAVED            0x00000800
#define STAGEFLAG_TOO_MANY_HOSTAGES_KILLED         0x00001000
#define STAGEFLAG_SAFEINFO_DESTROYED               0x00002000
#define STAGEFLAG_BOMB_AIRBORNE                    0x00004000
#define STAGEFLAG_CARRINGTON_DEAD                  0x00010000
#define STAGEFLAG_HOLO_TAKERS_DEAD                 0x00040000
#define STAGEFLAG_DEVICE_TAKERS_DEAD               0x00080000
#define STAGEFLAG_INFO_TAKERS_DEAD                 0x00100000
#define STAGEFLAG_AUTOGUN_SWITCH_DESTROYED         0x00200000
#define STAGEFLAG_BOMB_EXPLODING_ON_GROUND         0x00800000
#define STAGEFLAG_TRIGGER_SHUTTLE_TAKEOFF          0x01000000
#define STAGEFLAG_INTRO_FINISHED                   0x02000000
#define STAGEFLAG_VISITED_HOSTAGES_BEFORE_AUTOGUNS 0x04000000
#define STAGEFLAG_TRIGGER_AUTODEFENSES_MSG         0x08000000
#define STAGEFLAG_TRIGGER_COUNTINGONME_MSG         0x10000000
#define STAGEFLAG_TRIGGER_SPAWNING                 0x20000000
#define STAGEFLAG_DROPPED_DEVASTATOR               0x40000000
#define STAGEFLAG_FR_PC_DESTROYED                  0x80000000

// AI Lists
#define AILIST_SPAWNER1               0x0401
#define AILIST_CLONE1                 0x0402
#define AILIST_INIT_CLONE1            0x0403
#define AILIST_SPAWNER2               0x0404
#define AILIST_CLONE2                 0x0405
#define AILIST_INIT_CLONE2            0x0406
#define AILIST_SPAWNER3               0x0407
#define AILIST_CLONE3                 0x0408
#define AILIST_INIT_CLONE3            0x0409
#define AILIST_SPAWNER4               0x040a
#define AILIST_CLONE4                 0x040b
#define AILIST_INIT_CLONE4            0x040c
#define AILIST_SPAWNER5               0x040d
#define AILIST_CLONE5                 0x040e
#define AILIST_INIT_CLONE5            0x040f
#define AILIST_SPAWNER6               0x0410
#define AILIST_CLONE6                 0x0411
#define AILIST_INIT_CLONE6            0x0412
#define AILIST_DEFEND_PAD             0x0413
#define AILIST_FIRINGRANGE_HOSTAGE    0x0414
#define AILIST_INIT_HOSTAGE_FR1       0x0415
#define AILIST_INIT_HOSTAGE_FR2       0x0416
#define AILIST_INIT_FIRINGRANGE_TAKER 0x0419
#define AILIST_HOSTAGE_HOLO           0x041a
#define AILIST_INIT_HOSTAGE_HOLO      0x041b
#define AILIST_INIT_HOLOCLONE1        0x041c
#define AILIST_INIT_HOLOCLONE2        0x041d
#define AILIST_INIT_HOLOCLONE3        0x041e
#define AILIST_HOLOCLONE              0x041f
#define AILIST_TAKER_HOLO1            0x0420
#define AILIST_TAKER_HOLO2            0x0421
#define AILIST_TAKER_HOLO3            0x0422
#define AILIST_INIT_SHOCK             0x0423
#define AILIST_HOLOCLONE_ONSHOT       0x0424
#define AILIST_HOSTAGE_THANK_AND_RUN  0x0425
#define AILIST_INIT_SAVED_HOSTAGE     0x0426
#define AILIST_DROP_DEVASTATOR        0x0427
#define AILIST_INIT_DROP_DEVASTATOR   0x0428
#define AILIST_SKEDAR4                0x0429
#define AILIST_INIT_JONATHAN          0x042a
#define AILIST_DEVICEROOM_HOSTAGE     0x042b
#define AILIST_INIT_HOSTAGE_DEVICE_F  0x042c
#define AILIST_INIT_HOSTAGE_DEVICE_M  0x042d
#define AILIST_TAKER_DEVICE_M         0x042e
#define AILIST_INIT_TAKER_DEVICE_M    0x042f
#define AILIST_TAKER_DEVICE_F         0x0430
#define AILIST_INIT_TAKER_DEVICE_F    0x0431
#define AILIST_TAKER_ATTACK           0x0432
#define AILIST_INFOROOM_HOSTAGE       0x0433
#define AILIST_INIT_HOSTAGE_INFO_M    0x0434
#define AILIST_INIT_HOSTAGE_INFO_F    0x0435
#define AILIST_TAKER_INFO_M           0x0436
#define AILIST_INIT_TAKER_INFO_M      0x0437
#define AILIST_TAKER_INFO_F           0x0438
#define AILIST_INIT_TAKER_INFO_F      0x0439
#define AILIST_INIT_BLONDE            0x043b
#define AILIST_INIT_CISOLDIER         0x043c
#define AILIST_CARRINGTON             0x043e

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x2201)
	briefing(1, 0x2200)
	briefing(2, 0x2202)
	briefing(3, 0x2203)

	beginobjective(0, L_IMP(5), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Reactivate automatic defenses"
		complete_flags(STAGEFLAG_AUTOGUN1_ACTIVE)
		complete_flags(STAGEFLAG_AUTOGUN2_ACTIVE)
		complete_flags(STAGEFLAG_AUTOGUN3_ACTIVE)
		fail_flags(STAGEFLAG_AUTOGUN_SWITCH_DESTROYED)
		fail_flags(STAGEFLAG_00000001)
	endobjective

	beginobjective(1, L_IMP(6), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Release hostages"
		complete_flags(STAGEFLAG_ENOUGH_HOSTAGES_SAVED)
		fail_flags(STAGEFLAG_TOO_MANY_HOSTAGES_KILLED)
	endobjective

	beginobjective(2, L_IMP(7), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Retrieve experimental weapon"
		require_object_collected(OBJ_RCP120)
		fail_flags(STAGEFLAG_FR_PC_DESTROYED)
	endobjective

	beginobjective(3, L_IMP(8), (DIFFBIT_PA | DIFFBIT_PD)) // "Destroy sensitive information"
		complete_flags(STAGEFLAG_SAFEINFO_DESTROYED)
	endobjective

	beginobjective(4, L_IMP(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Deactivate bomb"
		complete_flags(STAGEFLAG_BOMB_AIRBORNE)
		fail_flags(STAGEFLAG_BOMB_EXPLODING_ON_GROUND)
		fail_flags(STAGEFLAG_CARRINGTON_DEAD)
	endobjective

	tag(0x23, 2)
	tag(0x24, 2)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0156, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0157, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x43, 2)
	tag(0x44, 2)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0158, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0159, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015b, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015c, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x54, 1)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015a, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x19, 1)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015d, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x51, 1)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0166, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0167, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0212, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0213, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0214, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0215, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0216, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0217, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0218, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0219, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	glass(0x0100, MODEL_WINDOW, 0x019f, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x019e, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x019d, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x019c, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a0, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a1, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a4, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a5, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a6, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a7, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c4, 0x04020b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c5, 0x04020b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c6, 0x04020b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c7, 0x04020b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a8, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a9, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01aa, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ab, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ac, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ad, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ae, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01af, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d1, 0x04000362, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x46, 6)
	tag(0x47, 6)
	tag(0x48, 6)
	tag(0x49, 6)
	tag(0x41, 1)
	lift(0x0100, MODEL_CI_LIFT, 0x0193, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0193, 0x0194, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x015e, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x015f, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0160, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0161, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 0)
	link_objects(-4, -7, 0, 1)
	link_objects(-4, -8, 0, 1)
	tag(0x4a, 6)
	tag(0x4b, 6)
	tag(0x4c, 6)
	tag(0x4d, 6)
	tag(0x42, 1)
	lift(0x0100, MODEL_CI_LIFT, 0x0195, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0195, 0x0196, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0164, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0165, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0162, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0163, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 0)
	link_objects(-4, -7, 0, 1)
	link_objects(-4, -8, 0, 1)
	tag(0x00, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x021b, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x021a, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4e, 1)
	stdobject(0x0100, MODEL_GOODPC, 0x021c, 0x000004e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x021f, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x021d, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_GOODPC, 0x021e, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x02, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0220, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0222, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_GOODPC, 0x0221, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	chr(0x00010400, 0x02, 0x00fa, BODY_CILABTECH, HEAD_CHRIST, AILIST_INIT_HOSTAGE_FR1, 0x00b7, -1, 1000, 6, 0x00000000, 0x00300000, TEAM_ALLY, SQUADRON_05, -1, 0, 0x02000000)
	weapon(0x0100, MODEL_CHRFALCON2, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2, 0x00ffffff, 0x00000000)
	chr(0x00014400, 0x07, 0x0013, BODY_CILABTECH, HEAD_BEAU1, AILIST_INIT_HOSTAGE_FR2, 0x00b7, -1, 0, 0, 0x48000000, 0x00300000, TEAM_ALLY, SQUADRON_0D, 0x00, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRFALCON2, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x04, 0x0103, BODY_CIFEMTECH, HEAD_SECRETARY, AILIST_INIT_HOSTAGE_HOLO, -1, -1, 1000, 6, 0x00000000, 0x00200000, TEAM_ALLY, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00010400, 0x01, 0x010b, BODY_CIFEMTECH, HEAD_SECRETARY, AILIST_INIT_HOSTAGE_DEVICE_F, -1, -1, 1000, 6, 0x00000000, 0x00200000, TEAM_ALLY, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00014400, 0x06, 0x00fd, BODY_CILABTECH, HEAD_RUSS, AILIST_INIT_HOSTAGE_DEVICE_M, -1, -1, 0, 0, 0x48000000, 0x00200000, TEAM_ALLY, SQUADRON_0D, 0x01, 0, 0x00020000)
	chr(0x00010400, 0x03, 0x010c, BODY_CILABTECH, HEAD_MARK2, AILIST_INIT_HOSTAGE_INFO_M, -1, -1, 1000, 6, 0x00000000, 0x00200001, TEAM_ALLY, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00014400, 0x08, 0x00f7, BODY_CIFEMTECH, HEAD_SECRETARY, AILIST_INIT_HOSTAGE_INFO_F, -1, -1, 0, 0, 0x00000000, 0x00200001, TEAM_ALLY, SQUADRON_0D, 0x02, 0, 0x00020000)
	chr(0x00000400, 0x05, 0x00fb, BODY_CILABTECH, HEAD_BRIAN, GAILIST_IDLE, 0x00fb, -1, 1000, 6, 0x00012000, 0x00300000, TEAM_ALLY, SQUADRON_05, -1, 0, 0x02000000)
	weapon(0x0100, MODEL_CHRFALCON2, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x00, 0x0142, BODY_CARREVENINGSUIT, HEAD_CARRINGTON, GAILIST_IDLE, 0x0142, -1, 200, 100, 0x00012000, 0x00301000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x0c, 0x0133, BODY_DDSHOCK, HEAD_RANDOM, AILIST_SPAWNER1, -1, -1, 200, 100, 0x80092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000080, 0x0d, 0x0134, BODY_DDSHOCK, HEAD_RANDOM, AILIST_SPAWNER2, -1, -1, 200, 100, 0x80092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0e, 0x0135, BODY_DDSHOCK, HEAD_RANDOM, AILIST_SPAWNER2, -1, -1, 200, 100, 0x80092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x10, 0x0137, BODY_DDSHOCK, HEAD_RANDOM, AILIST_SPAWNER3, -1, -1, 200, 100, 0x80092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x12, 0x0139, BODY_DDSHOCK, HEAD_RANDOM, AILIST_SPAWNER5, -1, -1, 200, 100, 0x80092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x13, 0x003a, BODY_DDSHOCK, HEAD_RANDOM, AILIST_SPAWNER4, -1, -1, 200, 100, 0x80092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x15, 0x013c, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x013c, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x16, 0x013d, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x013d, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x17, 0x013e, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x013e, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x18, 0x013f, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x013f, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1b, 0x0143, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x0143, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1c, 0x0144, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x0144, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1d, 0x0145, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x00b1, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1e, 0x0146, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x0146, -1, 200, 100, 0x80012000, 0x80300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x19, 0x0140, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x0140, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1a, 0x0141, BODY_CISOLDIER, HEAD_RANDOM, GAILIST_IDLE, 0x0141, -1, 200, 100, 0x80012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAR34, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_AR34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1f, 0x014b, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_SHOCK, -1, -1, 200, 100, 0x00092000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x20, 0x014c, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_SHOCK, -1, -1, 200, 100, 0x00092000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x21, 0x014d, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_SHOCK, -1, -1, 200, 100, 0x00092000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x22, 0x014e, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_SHOCK, -1, -1, 200, 100, 0x00092000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x23, 0x014f, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_SHOCK, -1, -1, 200, 100, 0x00092000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0023, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x24, 0x0150, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_TAKER_DEVICE_M, -1, -1, 200, 100, 0x00092000, 0x00300000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x25, 0x0151, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_TAKER_DEVICE_F, -1, -1, 200, 100, 0x00092000, 0x00300000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0025, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x26, 0x0152, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_TAKER_INFO_F, -1, -1, 200, 100, 0x00010000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x27, 0x0153, BODY_DDSHOCK, HEAD_RANDOM, AILIST_INIT_TAKER_INFO_M, -1, -1, 200, 100, 0x00010000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0027, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x14, 0x0053, BODY_DDSHOCK, HEAD_RANDOM, AILIST_SPAWNER6, -1, -1, 200, 100, 0x00010000, 0x00300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x28, 0x0148, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE_0009, -1, -1, 200, 100, 0xc0092000, 0x00300000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x29, 0x0149, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE_0009, -1, -1, 200, 100, 0xc0092000, 0x00300000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0029, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2a, 0x014a, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE_0009, -1, -1, 200, 100, 0xc0092000, 0x00300000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2b, 0x0154, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE_0009, -1, -1, 200, 100, 0xc0092000, 0x00300000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2c, 0x0155, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE_0009, -1, -1, 200, 100, 0xc0092000, 0x00300000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2d, 0x0147, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE_0009, -1, -1, 200, 100, 0xc0092000, 0x00300000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x30, 0x00ff, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE, -1, -1, 200, 100, 0x00092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x31, 0x0100, BODY_SKEDAR, HEAD_RANDOM, GAILIST_INVINCIBLE_AND_IDLE, -1, -1, 200, 100, 0x00092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x32, 0x0101, BODY_SKEDAR, HEAD_RANDOM, GAILIST_INVINCIBLE_AND_IDLE, -1, -1, 200, 100, 0x00092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x33, 0x0102, BODY_SKEDAR, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 200, 100, 0x00092000, 0x00301000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00004100, 0x34, 0x003a, BODY_SKEDAR, HEAD_RANDOM, GAILIST_STOP_AND_IDLE, -1, -1, 200, 100, 0x00092000, 0x40300000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00010100, 0x38, 0x0051, BODY_CISOLDIER, HEAD_JONATHAN, AILIST_INIT_JONATHAN, 0x0051, -1, 200, 100, 0x00012000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0038, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)
	tag(0x06, 1)
	autogun(0x00a6, MODEL_CI_ROOFGUN, 0x0235, 0x00000004, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00750000, 0x00000000, 0x00005555, 0xffffaaab, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000aaa, 0x00320000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x07, 1)
	autogun(0x00a6, MODEL_CI_ROOFGUN, 0x0234, 0x00000004, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x007c0000, 0x00000000, 0x00005555, 0xffffaaab, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000aaa, 0x00320000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x08, 1)
	autogun(0x00a6, MODEL_CI_ROOFGUN, 0x0233, 0x00000004, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00970000, 0x00000000, 0x00005555, 0xffffaaab, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000aaa, 0x00320000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0a, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x0236, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x0b, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x0237, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x0c, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x0238, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x0d, 1)
	stdobject(0x0100, MODEL_DROPSHIP, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0e, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0f, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x10, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x11, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x12, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x13, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x14, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x15, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x16, 1)
	stdobject(0x0300, MODEL_LASERCUT, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x17, 1)
	stdobject(0x0100, MODEL_LASERCUT, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x18, 1)
	stdobject(0x0100, MODEL_LASERCUT, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x52, 1)
	stdobject(0x0019, MODEL_KNOCKKNOCK, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x53, 1)
	stdobject(0x0019, MODEL_KNOCKKNOCK, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x05, 1)
	weapon(0x0180, MODEL_CHRRCP120, 0x011a, 0x00100008, 0x00000000, 0x20400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_RCP120, 0x00ffffff, 0x00000000)
	tag(0x09, 1)
	stdobject(0x0480, MODEL_SENSITIVEINFO, 0x010f, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x4e, L_IMP(10), L_IMP(11), L_IMP(12), L_IMP(13), L_IMP(14), 0x0000, 0x0000) // "Obtain sensitive info."
	tag(0x4f, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x36, L_IMP(57), L_IMP(58), L_IMP(59), L_IMP(60), L_IMP(61), 0x0000, 0x0000) // "Obtain Data Uplink."
	tag(0x50, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x36, L_IMP(57), L_IMP(58), L_IMP(59), L_IMP(60), L_IMP(61), 0x0000, 0x0000) // "Obtain Data Uplink."
	door(0x0100, MODEL_INSTFRONTDOOR, 0x018f, 0x10000600, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_INSTFRONTDOOR, 0x0190, 0x10000600, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0168, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0169, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0170, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0171, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0172, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0173, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0174, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0175, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0176, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0177, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0178, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0179, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0180, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0181, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0182, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0183, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0184, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01b7, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01b8, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01b9, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01ba, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bb, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bc, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bd, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01be, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bf, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01c3, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x39, 1)
	stdobject(0x0100, MODEL_AIRBASE_SAFEDOOR, 0x025b, 0x000205e8, 0x00200002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000007d0, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0252, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0253, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0254, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0255, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0256, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0257, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0258, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0259, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x025a, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01d6, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e1, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e2, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e5, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e6, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e8, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e9, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ea, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01eb, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ec, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ed, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ee, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ef, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f0, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f1, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f3, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f4, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f5, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f6, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f7, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fa, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fb, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fc, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fd, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fe, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0200, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0201, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0202, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0204, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3c, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00021501, 0x00006001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00002ee0, 0x00000000, 0x00000000, 0x0fff0000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01c8, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01c9, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01ca, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cb, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cc, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cd, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x3d, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01ce, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cf, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x3e, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01d0, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	door(0x0100, MODEL_DD_GRATE, 0x0185, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DEVICESECRETDOOR, 0x0186, 0x36000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_GRATE, 0x0187, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CARRINGTONSECRETDOOR, 0x0188, 0x16000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3f, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0288, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x40, 1)
#if VERSION >= VERSION_JAP_FINAL
	// ........................................................ v
	shield(0x0180, MODEL_CHRSHIELD, 0x0092, 0x00000001, 0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
#else
	shield(0x0180, MODEL_CHRSHIELD, 0x0092, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
#endif
	tag(0x45, 1)
	weapon(0x0100, MODEL_CHRDEVASTATOR, 0xffff, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DEVASTATOR, 0x00ffffff, 0x00000000)
	endprops
};

s32 intro[] = {
	outfit(OUTFIT_FROCK)
	intro_weapon(WEAPON_AR34, -1)
	ammo(AMMOTYPE_RIFLE, 200)
	ammo(AMMOTYPE_PISTOL, 300)
	ammo(AMMOTYPE_SMG, 400)
	intro_weapon(WEAPON_COMBATBOOST, -1)
	ammo(AMMOTYPE_BOOST, 2)
	intro_weapon(WEAPON_LASER, -1)
	intro_weapon(WEAPON_LASER, -1)
	spawn(0x0120)
	endintro
};

s32 path00[] = {
	0x0113,
	-1,
};

u8 func1001_objectives_failed_msg[] = {
	yield
	give_object_to_chr(OBJ_DATAUPLINK_BOND, CHR_BOND)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	give_object_to_chr(OBJ_DATAUPLINK_COOP, CHR_COOP)

	label(0x2e)
	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_DEVICE_F, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_FR1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_INFO_M, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_HOLO, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HANGARGUY, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_DEVICE_M, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_FR2, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_INFO_F, CHRCFLAG_04000000)
	set_chr_chrflag(0x09, CHRCFLAG_04000000)
	set_chr_chrflag(0x0a, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_HOSTAGE_FR1, CHRCFLAG_UNEXPLODABLE)
	set_chr_chrflag(CHR_HOSTAGE_FR2, CHRCFLAG_UNEXPLODABLE)
	set_chr_chrflag(CHR_TAKER_FR1, CHRCFLAG_UNEXPLODABLE)
	set_chr_chrflag(CHR_TAKER_FR2, CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

#define spawner_logic(initfunc, clonefunc) \
	set_self_chrflag(CHRCFLAG_00000002) \
	set_self_chrflag(CHRCFLAG_HIDDEN) \
	set_self_chrflag(CHRCFLAG_00040000) \
 \
	beginloop(0x0f) \
		if_stage_flag_eq(STAGEFLAG_TRIGGER_SPAWNING, TRUE, /*goto*/ 0x04) \
	endloop(0x0f) \
 \
	beginloop(0x04) \
		if_never_been_onscreen(/*goto*/ 0x4f) \
		if_chr_sees_player(/*goto*/ 0x0a) \
		reloop(0x04) \
 \
		label(0x0a) \
		set_ailist(CHR_SELF, clonefunc) \
 \
		label(0x4f) \
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f) \
		reloop(0x04) \
 \
		label(0x4f) \
		try_spawn_clone2(CHR_SELF, initfunc, 0x00000000, /*goto*/ 0x2e) \
		set_ailist(CHR_SELF, clonefunc) \
		label(0x2e) \
		yield \
	endloop(0x04)



#define initclone_logic(templatechr, clonefunc) \
	set_chr_dodge_rating(2, 0x00) \
	set_accuracy(20) \
	set_reaction_speed(70) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(90) \
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1) \
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000) \
	label(0x04) \
	try_inherit_properties(templatechr, /*goto*/ 0x08) \
	label(0x08) \
	set_chr_team(CHR_SELF, TEAM_ENEMY) \
	rebuild_teams \
	rebuild_squadrons \
	set_ailist(CHR_SELF, clonefunc)



// Spawn clones in autogun hall dead end room
u8 func0401_spawner1[] = {
	spawner_logic(AILIST_INIT_CLONE1, AILIST_CLONE1)
	endlist
};

u8 func0403_init_clone1[] = {
	initclone_logic(0x0b, AILIST_CLONE1)
	endlist
};

u8 func0402_clone1[] = {
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	run_to_pad(0x00c2)
	set_returnlist(CHR_SELF, AILIST_CLONE1)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

// Spawn clones in vehicle maintenance area - assigned to two spawners
u8 func0404_spawner2[] = {
	spawner_logic(AILIST_INIT_CLONE2, AILIST_CLONE2)
	endlist
};

u8 func0406_init_clone2[] = {
	initclone_logic(0x0d, AILIST_CLONE2)
	endlist
};

u8 func0405_clone2[] = {
	run_to_pad(0x00b1)
	set_returnlist(CHR_SELF, AILIST_CLONE2)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

// Spawn clones in room with pit near autogun switches
u8 func0407_spawner3[] = {
	spawner_logic(AILIST_INIT_CLONE3, AILIST_CLONE3)
	endlist
};

u8 func0409_init_clone3[] = {
	initclone_logic(0x0f, AILIST_CLONE3)
	endlist
};

u8 func0408_clone3[] = {
	run_to_pad(0x00af)
	set_returnlist(CHR_SELF, AILIST_CLONE3)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * Assigned to CI soldiers, Jon and hangar guy
 */
u8 func0413_defend_pad[] = {
	set_shotlist(AILIST_DEFEND_PAD)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0a)
	if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x08)

	// Distance to pad >= 200
	label(0x03)
	jog_to_pad(PAD_PRESET)

	beginloop(0x04)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0a)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x08)
	endloop(0x04)

	// At pad
	label(0x08)
	stop_chr

	beginloop(0x0b)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0a)
		if_chr_distance_to_pad_gt(CHR_SELF, 300, PAD_PRESET, /*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)
	goto_first(0x03)

	// Detected enemy
	label(0x0a)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_shotlist(AILIST_DEFEND_PAD)
	set_returnlist(CHR_SELF, AILIST_DEFEND_PAD)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func100b_setup_autoguns[] = {
	yield
	set_autoturret_type(OBJ_AUTOGUN1, 0xef)
	set_autoturret_type(OBJ_AUTOGUN2, 0xef)
	set_autoturret_type(OBJ_AUTOGUN3, 0xef)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)

	// SA and PA only
	restart_timer

	beginloop(0x71)
		if_timer_gt(120, /*goto*/ 0x2e)
	endloop(0x71)

	label(0x2e)
	set_object_flag(OBJ_AUTOGUN1, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_AUTOGUN2, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_AUTOGUN3, OBJFLAG_DEACTIVATED)

	label(0x2f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_check_hostages_killed[] = {
	set_chr_chrflag(CHR_HOSTAGE_DEVICE_F, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_HOSTAGE_FR1, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_HOSTAGE_INFO_M, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_HOSTAGE_HOLO, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_HOSTAGE_DEVICE_M, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_HOSTAGE_FR2, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_HOSTAGE_INFO_F, CHRCFLAG_KILLCOUNTABLE)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0a)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0b)

	// PA
	beginloop(0x0c)
		if_kill_count_gt(2, /*goto*/ 0x08)
	endloop(0x0c)

	// Agent
	beginloop(0x0a)
		if_kill_count_gt(4, /*goto*/ 0x08)
	endloop(0x0a)

	// SA
	beginloop(0x0b)
		if_kill_count_gt(3, /*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)
	if_stage_flag_eq(STAGEFLAG_ENOUGH_HOSTAGES_SAVED, TRUE, /*goto*/ 0x2e)
	set_stage_flag(STAGEFLAG_TOO_MANY_HOSTAGES_KILLED)
	show_hudmsg(CHR_BOND, L_IMP(16)) // "Too many hostages killed."

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_check_safeinfo_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_SAFEINFO, /*goto*/ 0x2e)
		goto_next(0x08)

		label(0x2e)
	endloop(0x04)

	label(0x08)
	show_hudmsg(CHR_BOND, L_IMP(18)) // "Sensitive information has been destroyed."
	set_stage_flag(STAGEFLAG_SAFEINFO_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define autogun_switch_logic(switch, autogun, stageflag) \
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0e) \
 \
	beginloop(0x04) \
		chr_toggle_p1p2(CHR_SELF) \
		if_object_in_good_condition(switch, /*goto*/ 0x2e) \
		goto_next(0x0b) \
 \
		label(0x2e) \
		if_object_in_good_condition(autogun, /*goto*/ 0x2e) \
		goto_next(0x0b) \
 \
		label(0x2e) \
		if_chr_activated_object(CHR_P1P2, switch, /*goto*/ 0x08) \
	endloop(0x04) \
 \
	/* Switch activated */ \
	label(0x08) \
	play_sound(0x043a, CHANNEL_7) \
	show_hudmsg(CHR_P1P2, 0x220f) /* "Automatic gun activated." */ \
	label(0x0e) \
	unset_object_flag(autogun, OBJFLAG_DEACTIVATED) \
	set_stage_flag(stageflag) \
 \
	beginloop(0x0f) \
		if_object_in_good_condition(autogun, /*goto*/ 0x2e) \
		goto_next(0x0b) \
 \
		label(0x2e) \
	endloop(0x0f) \
 \
	/* Autogun or switch destroyed */ \
	label(0x0b) \
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x11) \
	show_hudmsg(CHR_BOND, 0x2222) /* "Critical mission object has been destroyed." */ \
	set_stage_flag(STAGEFLAG_AUTOGUN_SWITCH_DESTROYED)



u8 func1007_autogun_switch1[] = {
	autogun_switch_logic(OBJ_AUTOGUN_SWITCH1, OBJ_AUTOGUN1, STAGEFLAG_AUTOGUN1_ACTIVE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x11)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_autogun_switch2[] = {
	autogun_switch_logic(OBJ_AUTOGUN_SWITCH2, OBJ_AUTOGUN2, STAGEFLAG_AUTOGUN2_ACTIVE)
	label(0x11)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_autogun_switch3[] = {
	autogun_switch_logic(OBJ_AUTOGUN_SWITCH3, OBJ_AUTOGUN3, STAGEFLAG_AUTOGUN3_ACTIVE)
	label(0x11)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c01_outro[] = {
	camera_movement(0x01a2)
	set_music_track(MUSIC_DEFENSE_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x01a3, -1, -1, 0x06, 0x00, CHR_P1P2, 4)

	#define show_object_with_animation(object, animation) \
		show_object(object) \
		set_object_flag2(object, OBJFLAG2_04000000) \
		set_object_flag3(object, OBJFLAG3_00000010) \
		object_do_animation(animation, object, 0x04, 0xffff)



	show_object_with_animation(0x0e, 0x01a4)
	show_object_with_animation(0x0f, 0x01a5)
	show_object_with_animation(0x10, 0x01a6)
	show_object_with_animation(0x11, 0x01a7)
	show_object_with_animation(0x12, 0x01a8)
	show_object_with_animation(0x13, 0x01a9)
	show_object_with_animation(0x14, 0x01aa)

	show_object(0x0d)
	unset_object_flag(0x0d, OBJFLAG_DEACTIVATED)
	set_object_flag2(0x0d, OBJFLAG2_04000000)
	set_object_flag3(0x0d, OBJFLAG3_00000010)
	object_do_animation(0x01b4, 0x0d, 0x01, 0xffff)

	show_nonessential_chrs(FALSE)
	open_door(0x51)
	restart_timer
	yield
	set_object_flag(0x51, OBJFLAG_40000000)
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_P1P2, WEAPON_AR34, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0xb8) \
			if_timer_gt(time, /*goto*/ 0x08) \
		endloop(loopid) \
		label(0x08)



	wait_until(86, 0x73)
	play_sound(0x0161, CHANNEL_10)

	wait_until(114, 0x74)
	play_sound(0x0162, CHANNEL_10)

	wait_until(140, 0x75)
	play_sound(0x0163, CHANNEL_10)

	wait_until(168, 0x76)
	play_sound(0x0164, CHANNEL_10)

	wait_until(186, 0x77)
	play_sound(0x0161, CHANNEL_10)

	beginloop(0x0a)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0xb8)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0xb8)
		label(0x2e)
	endloop(0x0a)

	label(0xb8)
	mute_channel(CHANNEL_10)
	hide_object(0x0d)
	camera_movement(0x01ac)
	unset_chr_chrflag(CHR_SKEDAR1, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_SKEDAR2, CHRCFLAG_HIDDEN)

	set_chr_chrflag(CHR_SKEDAR1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_SKEDAR1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_SKEDAR1, CHRHFLAG_00020000)
	chr_do_animation(0x01ad, -1, -1, 0x06, 0x00, CHR_SKEDAR1, 4)

	set_chr_chrflag(CHR_SKEDAR2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_SKEDAR2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_SKEDAR2, CHRHFLAG_00020000)
	chr_do_animation(0x01ae, -1, -1, 0x06, 0x00, CHR_SKEDAR2, 4)

	wait_until(16, 0x78)
	play_sound(0x0530, CHANNEL_10)

	wait_until(56, 0x79)
	play_sound(0x052b, CHANNEL_10)

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0xb8)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0xb8)
		label(0x2e)
	endloop(0x0b)

	label(0xb8)
	mute_channel(CHANNEL_10)
	camera_movement(0x0305)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x0306, -1, -1, 0x06, 0x00, CHR_P1P2, 4)

	show_object_with_animation(0x0e, 0x0307)
	show_object_with_animation(0x0f, 0x0308)
	show_object_with_animation(0x10, 0x0309)
	show_object_with_animation(0x11, 0x030a)
	show_object_with_animation(0x12, 0x030b)
	show_object_with_animation(0x13, 0x030c)
	show_object_with_animation(0x14, 0x030d)
	show_object_with_animation(0x0d, 0x030f)

	show_object(0x16)
	set_object_flag2(0x16, OBJFLAG2_04000000)
	set_object_flag3(0x16, OBJFLAG3_00000010)
	object_do_animation(0x01b1, 0x16, 0x02, 0xffff)

	wait_until(372, 0x7a)
	play_sound(0x0506, CHANNEL_10)

	wait_until(382, 0x7b)
	play_sound(0x0048, CHANNEL_10)

	wait_until(390, 0x7c)
	play_sound(0x0506, CHANNEL_10)

	wait_until(400, 0x7d)
	play_sound(0x0049, CHANNEL_10)

	wait_until(432, 0x7e)
	play_sound(0x0506, CHANNEL_10)

	wait_until(442, 0x7f)
	play_sound(0x00d0, CHANNEL_10)

	wait_until(454, 0x80)
	play_sound(0x0506, CHANNEL_10)

	wait_until(464, 0x81)
	play_sound(0x0078, CHANNEL_10)

	wait_until(466, 0x82)
	play_sound(0x0161, CHANNEL_10)

	wait_until(484, 0x83)
	play_sound(0x0162, CHANNEL_10)

	wait_until(502, 0x84)
	play_sound(0x0164, CHANNEL_10)

	wait_until(516, 0x85)
	play_sound(0x0163, CHANNEL_10)

	wait_until(528, 0x86)
	play_sound(0x0162, CHANNEL_10)

	wait_until(570, 0x71)
	speak(CHR_BOND, L_IMP(49), 0x747d, CHANNEL_10, COLOR_09_BLUE) // "Get clear! I'll hold them off... You can come back..."

	wait_until(847, 0x87)
	play_sound(0x0161, CHANNEL_10)

	wait_until(852, 0x88)
	play_sound(0x0162, CHANNEL_10)

	wait_until(865, 0x72)
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, FALSE)

	wait_until(870, 0x89)

	label(0x8a)
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	if_controller_button_pressed(/*goto*/ 0xb8)
	if_timer_gt(960, /*goto*/ 0x08)
	goto_first(0x8a)

	label(0x08)
	set_chr_shooting_in_cutscene(CHR_BOND, FALSE)
	speak(CHR_BOND, L_IMP(50), 0x747e, CHANNEL_10, COLOR_09_BLUE) // "At least, I hope you can."

	wait_until(1018, 0x8c)
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, FALSE)

	wait_until(1065, 0x94)
	play_sound(0x052b, CHANNEL_7)

	label(0x0c)
	yield
	if_camera_animating(/*goto*/ 0x2e)
	goto_next(0xb8)
	label(0x2e)
	if_controller_button_pressed(/*goto*/ 0xb8)
	label(0x2e)
	goto_first(0x0c)

	label(0xb8)
	mute_channel(CHANNEL_10)
	camera_movement(0x0310)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x0311, -1, -1, 0x06, 0x00, CHR_P1P2, 4)

	set_chr_chrflag(CHR_SKEDAR1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_SKEDAR1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_SKEDAR1, CHRHFLAG_00020000)
	chr_do_animation(0x0312, -1, -1, 0x06, 0x00, CHR_SKEDAR1, 4)

	show_object_with_animation(0x0e, 0x0313)
	show_object_with_animation(0x0f, 0x0314)
	show_object_with_animation(0x10, 0x0315)
	show_object_with_animation(0x11, 0x0316)
	show_object_with_animation(0x12, 0x0317)
	show_object_with_animation(0x13, 0x0318)
	show_object_with_animation(0x14, 0x0319)

	wait_until(1090, 0x95)
	play_sound(0x0529, CHANNEL_10)

	wait_until(1100, 0x96)
	play_sound(0x052a, CHANNEL_10)

	wait_until(1264, 0x97)
	play_sound(0x00e3, CHANNEL_10)

	wait_until(1280, 0x98)
	play_sound(0x00e4, CHANNEL_10)

	wait_until(1315, 0x99)
	play_sound(0x77ba, CHANNEL_10)
	play_sound(0x00ee, CHANNEL_10)

	wait_until(1330, 0x9a)
	play_sound(0x00df, CHANNEL_10)

	wait_until(1350, 0x9b)
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, FALSE)
	play_sound(0x77ba, CHANNEL_10)
	play_sound(0x00e4, CHANNEL_10)

	beginloop(0x0d)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0xb8)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0xb8)
		label(0x2e)
	endloop(0x0d)

	label(0xb8)
	mute_channel(CHANNEL_10)
	restart_default_music
	reset_ambience
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_intro[] = {
	set_music_track(MUSIC_DEFENSE_INTRO)
	camera_movement(0x02bc)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_ailist(CHR_CARRINGTON, GAILIST_IDLE)
	set_ailist(0x19, GAILIST_IDLE)
	set_ailist(0x1a, GAILIST_IDLE)
	set_chr_chrflag(0x16, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x02bd, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_CARRINGTON, CHRHFLAG_00020000)
	chr_do_animation(0x02be, -1, -1, 0x06, 0x00, CHR_CARRINGTON, 4)
	set_chr_chrflag(0x19, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x19, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x19, CHRHFLAG_00020000)
	chr_do_animation(0x02bf, -1, -1, 0x06, 0x00, 0x19, 4)
	set_chr_chrflag(0x1a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x1a, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x1a, CHRHFLAG_00020000)
	chr_do_animation(0x02c0, -1, -1, 0x06, 0x00, 0x1a, 4)
	show_object(0x0d)
	set_object_flag2(0x0d, OBJFLAG2_04000000)
	set_object_flag3(0x0d, OBJFLAG3_00000010)
	object_do_animation(0x02c1, 0x0d, 0x04, 0xffff)
	restart_timer
	set_cutscene_weapon(0x1a, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(0x1a, WEAPON_AR34, WEAPON_NONE)

	wait_until(4, 0x71)
	speak(CHR_BOND, L_IMP(41), 0x7475, CHANNEL_10, COLOR_06_WHITE) // "All ready, Joanna? We can't keep the Maian delegat..."

	wait_until(72, 0x72)
	play_sound(0x0161, CHANNEL_10)

	wait_until(104, 0x73)
	play_sound(0x0162, CHANNEL_10)

	wait_until(450, 0x74)
	speak(CHR_BOND, L_IMP(42), 0x7476, CHANNEL_10, COLOR_09_BLUE) // "Am I ready? What do you mean? I was ready half an ..."

	wait_until(688, 0x76)
	play_sound(0x0163, CHANNEL_10)

	wait_until(754, 0x77)
	play_sound(0x0164, CHANNEL_10)

	wait_until(800, 0x75)
	speak(CHR_BOND, L_IMP(43), 0x7477, CHANNEL_10, COLOR_06_WHITE) // "But you know how it is, Joanna... I had to make su..."

	wait_until(822, 0x78)
	play_sound(0x0165, CHANNEL_10)

	wait_until(850, 0x79)
	play_sound(0x0166, CHANNEL_10)

	wait_until(866, 0x7a)
	play_sound(0x0167, CHANNEL_10)

	wait_until(892, 0x7b)
	play_sound(0x0168, CHANNEL_10)

	wait_until(926, 0x7c)
	play_sound(0x0161, CHANNEL_10)

	wait_until(945, 0x7d)
	play_sound(0x0162, CHANNEL_10)

	wait_until(976, 0x7e)
	play_sound(0x0161, CHANNEL_10)

	wait_until(990, 0x7f)
	play_sound(0x0163, CHANNEL_10)

	wait_until(1030, 0x80)
	play_sound(0x0162, CHANNEL_10)

	wait_until(1048, 0x81)
	play_sound(0x0168, CHANNEL_10)

	wait_until(1102, 0x83)
	play_sound(0x0167, CHANNEL_10)

	wait_until(1110, 0x84)
	play_sound(0x0164, CHANNEL_10)

	wait_until(1158, 0x85)
	play_sound(0x0165, CHANNEL_10)

	wait_until(1160, 0x82)
	speak(CHR_BOND, L_IMP(44), 0x7478, CHANNEL_10, COLOR_09_BLUE) // "They should keep you away from mirrors. Nervous?"

	wait_until(1170, 0x86)
	play_sound(0x0166, CHANNEL_10)

	wait_until(1224, 0x87)
	play_sound(0x0167, CHANNEL_10)

	wait_until(1258, 0x88)
	play_sound(0x0168, CHANNEL_10)

	wait_until(1440, 0x89)
	speak(CHR_BOND, L_IMP(45), 0x7479, CHANNEL_10, COLOR_06_WHITE) // "Very. I've waited for this moment for so many year..."

	wait_until(1442, 0x8a)
	play_sound(0x0162, CHANNEL_10)

	wait_until(1450, 0x8b)
	play_sound(0x0161, CHANNEL_10)

	wait_until(1594, 0x8c)
	play_sound(0x0163, CHANNEL_10)

	wait_until(1676, 0x8d)
	play_sound(0x0164, CHANNEL_10)

	wait_until(1741, 0x8e)
	play_sound(0x0165, CHANNEL_10)

	wait_until(2252, 0x8f)
	play_sound(0x0166, CHANNEL_10)

	wait_until(2296, 0x90)
	play_sound(0x0167, CHANNEL_10)

	wait_until(2326, 0x91)
	play_sound(0x0164, CHANNEL_10)

	wait_until(2378, 0x92)
	play_sound(0x0168, CHANNEL_10)

	wait_until(2383, 0x93)
	play_sound(0x00b5, CHANNEL_10)

	wait_until(2410, 0x94)
	speak(CHR_BOND, L_IMP(46), 0x747a, CHANNEL_10, COLOR_06_WHITE) // "Where did that come from?"

	wait_until(2416, 0x95)
	play_sound(0x0165, CHANNEL_10)

	wait_until(2446, 0x96)
	play_sound(0x0166, CHANNEL_10)

	wait_until(2510, 0x97)
	play_sound(0x00ad, CHANNEL_10)

	wait_until(2566, 0x98)
	play_sound(0x0161, CHANNEL_10)

	wait_until(2582, 0x99)
	play_sound(0x00b2, CHANNEL_10)

	wait_until(2628, 0x9b)
	speak(CHR_BOND, L_IMP(47), 0x747b, CHANNEL_10, COLOR_09_BLUE) // "It was up on ground level..."

	wait_until(2804, 0x9c)
	play_sound(0x00b5, CHANNEL_10)

	wait_until(2910, 0x9e)
	play_sound(0x0165, CHANNEL_10)
	set_cutscene_weapon(0x1a, WEAPON_NONE, WEAPON_NONE)
	set_cutscene_weapon(CHR_BOND, WEAPON_AR34, WEAPON_NONE)

	wait_until(2940, 0x9f)
	play_sound(0x03c5, CHANNEL_10)

	wait_until(2965, 0xa0)
	play_sound(0x0168, CHANNEL_10)

	wait_until(2970, 0x9d)
	speak(CHR_BOND, L_IMP(48), 0x747c, CHANNEL_10, COLOR_09_BLUE) // "Looks like someone doesn't know when to quit. We'v..."

	wait_until(2984, 0xa1)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3000, 0xa2)
	play_sound(0x0166, CHANNEL_10)

	wait_until(3106, 0xa3)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3125, 0xa4)
	play_sound(0x0168, CHANNEL_10)

	wait_until(3142, 0xae)
	play_sound(0x0167, CHANNEL_10)
	unset_object_flag2(0x0d, OBJFLAG2_04000000)

	wait_until(3144, 0xa5)
	play_sound(0x0166, CHANNEL_10)

	wait_until(3169, 0xa6)
	play_sound(0x0167, CHANNEL_10)

	wait_until(3180, 0xaf)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3204, 0xb0)
	play_sound(0x0168, CHANNEL_10)

	wait_until(3228, 0xa7)
	play_sound(0x0166, CHANNEL_10)

	wait_until(3246, 0xa8)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3263, 0xa9)
	play_sound(0x0168, CHANNEL_10)

	wait_until(3295, 0xaa)
	play_sound(0x0166, CHANNEL_10)

	wait_until(3317, 0xab)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3342, 0xac)
	play_sound(0x0168, CHANNEL_10)

	wait_until(3355, 0xb1)
	play_sound(0x0166, CHANNEL_10)

	wait_until(3365, 0xad)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3472, 0xb2)
	play_sound(0x0164, CHANNEL_10)

	wait_until(3498, 0xb3)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3520, 0xb4)
	play_sound(0x0166, CHANNEL_10)

	beginloop(0x0a)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0xb8)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0xb8)
		label(0x2e)
	endloop(0x0a)

	label(0xb8)
	mute_channel(CHANNEL_10)
	camera_movement(0x02c2)
	cmd0175(60)
	unset_object_flag2(0x0d, OBJFLAG2_04000000)
	if_controller_button_pressed(/*goto*/ 0xcc)
	unset_chr_chrflag(CHR_SKEDAR4, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SKEDAR4, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_SKEDAR4, CHRHFLAG_00020000)
	chr_do_animation(0x02c3, -1, -1, 0x06, 0x00, CHR_SKEDAR4, 4)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x02c4, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	show_object(0x52)
	set_object_flag2(0x52, OBJFLAG2_04000000)
	set_object_flag3(0x52, OBJFLAG3_00000010)
	object_do_animation(0x02c5, 0x52, 0x04, 0xffff)
	show_object(0x53)
	set_object_flag2(0x53, OBJFLAG2_04000000)
	set_object_flag3(0x53, OBJFLAG3_00000010)
	object_do_animation(0x02c6, 0x53, 0x04, 0xffff)
	restart_timer

	#define wait_until2(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0xcc) \
			if_timer_gt(time, /*goto*/ 0x08) \
		endloop(loopid) \
		label(0x08)



	wait_until2(8, 0x62)
	play_sound(0x052a, CHANNEL_10)

	wait_until2(26, 0x65)
	play_sound(0x05a0, CHANNEL_10)

	wait_until2(38, 0x63)
	play_sound(0x00e3, CHANNEL_10)

	wait_until2(43, 0x64)
	play_sound(0x00e4, CHANNEL_10)

	wait_until2(63, 0x66)
	play_sound(0x05a1, CHANNEL_10)

	wait_until2(160, 0x67)
	play_sound(0x0161, CHANNEL_10)

	wait_until2(202, 0x68)
	play_sound(0x0162, CHANNEL_10)

	wait_until2(238, 0x69)
	play_sound(0x0163, CHANNEL_10)

	wait_until2(255, 0x6a)
	play_sound(0x0164, CHANNEL_10)

	wait_until2(259, 0x6b)
	play_sound(0x0530, CHANNEL_10)

	wait_until2(441, 0x6c)
	play_sound(0x0163, CHANNEL_10)

	wait_until2(454, 0x6d)
	play_sound(0x0164, CHANNEL_10)

	wait_until2(522, 0x6e)
	play_sound(0x05c7, CHANNEL_10)

	wait_until2(546, 0x6f)
	play_sound(0x05c6, CHANNEL_10)

	wait_until2(610, 0x70)
	play_sound(0x05c5, CHANNEL_10)

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0xcc)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0xcc)
		label(0x2e)
	endloop(0x0b)

	label(0xcc)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_10)
	set_cutscene_weapon(CHR_BOND, WEAPON_AR34, WEAPON_NONE)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x02c4, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	unset_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_CARRINGTON, CHRHFLAG_00020000)
	chr_do_animation(0x02be, -2, -1, 0x06, 0x00, CHR_CARRINGTON, 2)
	unset_chr_chrflag(0x19, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(0x19, CHRHFLAG_00020000)
	chr_do_animation(0x02bf, -2, -1, 0x06, 0x00, 0x19, 2)
	unset_chr_chrflag(0x1a, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(0x1a, CHRHFLAG_00020000)
	chr_do_animation(0x02c0, -2, -1, 0x06, 0x00, 0x1a, 2)
	unset_chr_chrflag(CHR_SKEDAR4, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_SKEDAR4, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_SKEDAR4, CHRHFLAG_00020000)
	chr_do_animation(0x02c3, -2, -1, 0x06, 0x00, CHR_SKEDAR4, 2)
	unset_object_flag2(0x0d, OBJFLAG2_04000000)
	set_object_flag(0x0d, OBJFLAG_DEACTIVATED)
	set_object_flag3(0x0d, OBJFLAG3_00000010)
	object_do_animation(0x01b4, 0x0d, 0x01, 0xffff)
	show_object(0x52)
	set_object_flag2(0x52, OBJFLAG2_04000000)
	set_object_flag3(0x52, OBJFLAG3_00000010)
	object_do_animation(0x02c5, 0x52, 0x04, 0xfffe)
	show_object(0x53)
	set_object_flag2(0x53, OBJFLAG2_04000000)
	set_object_flag3(0x53, OBJFLAG3_00000010)
	object_do_animation(0x02c6, 0x53, 0x04, 0xfffe)
	set_stage_flag(STAGEFLAG_INTRO_FINISHED)
	restart_default_music
	reset_ambience
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	remove_chr(0x19)
	remove_chr(0x1a)
	set_ailist(0x19, GAILIST_IDLE)
	set_ailist(0x1a, GAILIST_IDLE)
	unset_chr_chrflag(0x16, CHRCFLAG_HIDDEN)
	enter_firstperson
	yield
	set_ailist(CHR_CARRINGTON, AILIST_CARRINGTON)
	set_ailist(CHR_SKEDAR4, AILIST_SKEDAR4)
	unset_chr_chrflag(CHR_JONATHAN, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1003_hide_blondes_and_skedar[] = {
	label(0x04)
	set_chr_chrflag(CHR_BLONDE7, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SKEDAR1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SKEDAR2, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SKEDAR3, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SKEDAR1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_SKEDAR2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_SKEDAR3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BLONDE1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BLONDE2, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BLONDE3, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BLONDE4, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BLONDE5, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BLONDE6, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BLONDE1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BLONDE2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BLONDE3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BLONDE4, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BLONDE5, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_BLONDE6, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_check_carrington_dead[] = {
	beginloop(0x04)
		if_chr_dying(CHR_CARRINGTON, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	show_hudmsg(CHR_BOND, L_IMP(19)) // "Carrington has been killed."
	set_stage_flag(STAGEFLAG_CARRINGTON_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0415_init_hostage_fr1[] = {
	set_morale(5)
	set_chr_maxdamage(CHR_SELF, 1)
	set_accuracy(0)
	set_ailist(CHR_SELF, AILIST_FIRINGRANGE_HOSTAGE)
	endlist
};

u8 func0416_init_hostage_fr2[] = {
	set_morale(7)
	set_chr_maxdamage(CHR_SELF, 1)
	set_accuracy(0)
	set_ailist(CHR_SELF, AILIST_FIRINGRANGE_HOSTAGE)
	endlist
};

u8 func0414_firingrange_hostage[] = {
	set_shotlist(AILIST_FIRINGRANGE_HOSTAGE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x04)

	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0a)
	goto_next(0x12)

	label(0x03)
	jog_to_pad(PAD_PRESET)

	beginloop(0x04)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0a)
		goto_next(0x12)
	endloop(0x04)

	label(0x08)
	stop_chr

	beginloop(0x0b)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0a)
		goto_next(0x12)
	endloop(0x0b)

	label(0x08)
	goto_first(0x03)

	label(0x0a)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_returnlist(CHR_SELF, AILIST_FIRINGRANGE_HOSTAGE)
	set_shotlist(AILIST_FIRINGRANGE_HOSTAGE)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Enemy not detected
	label(0x12)
	set_ailist(CHR_SELF, AILIST_INIT_SAVED_HOSTAGE)
	endlist
};

u8 func100e_setup_firingrange[] = {
	set_chr_chrflag(CHR_HOSTAGE_FR1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_HOSTAGE_FR2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_TAKER_FR1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_TAKER_FR2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	// Wait until guns complete or failed, or skip this check if Agent
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
		if_objective_complete(0, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_AUTOGUN_SWITCH_DESTROYED, TRUE, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_00000001, TRUE, /*goto*/ 0x2e)
		reloop(0x04)

		// Wait until player in foyer area
		label(0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0006, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0005, /*goto*/ 0x2e)
	endloop(0x04)

	// Configure FR takers and hostages
	label(0x2e)
	set_ailist(CHR_TAKER_FR1, AILIST_INIT_FIRINGRANGE_TAKER)
	set_ailist(CHR_TAKER_FR2, AILIST_INIT_FIRINGRANGE_TAKER)
	set_chr_flag_bankx(CHR_HOSTAGE_FR1, CHRFLAG0_00002000, BANK_0)
	set_chr_flag_bankx(CHR_HOSTAGE_FR2, CHRFLAG0_00002000, BANK_0)
	restart_timer

	// Wait until player in firing range entrance or door is opening
	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0007, /*goto*/ 0x08)
		if_door_state(0x23, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2f)
	endloop(0x0a)

	// Wait for player to enter room, or 10 seconds
	label(0x2f)
	restart_timer

	beginloop(0x71)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0007, /*goto*/ 0x08)
		if_timer_gt(600, /*goto*/ 0x08)
	endloop(0x71)

	// Unset invincible on hostages and takers
	label(0x08)
	destroy_object(OBJ_FR_GLASS)
	unset_chr_chrflag(CHR_HOSTAGE_FR1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_HOSTAGE_FR2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TAKER_FR1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TAKER_FR2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0419_init_firingrange_taker[] = {
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func041b_init_hostage_holo[] = {
	set_morale(3)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_HOSTAGE_HOLO)
	endlist
};

u8 func041a_hostage_holo[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_00040000)
	set_shotlist(AILIST_HOSTAGE_HOLO)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x04)

	// Dying
	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive - wait until holo room door opened
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_door_state(0x43, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		if_door_state(0x44, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	if_objective_complete(0, /*goto*/ 0x2e)
	set_stage_flag(STAGEFLAG_VISITED_HOSTAGES_BEFORE_AUTOGUNS)

	label(0x2e)
	assign_sound(0x1b0e, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	restart_timer

	// Wait until player in sight, or 2 seconds
	beginloop(0x0a)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x08)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x08)
		if_timer_gt(120, /*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	assign_sound(0x1b0f, CHANNEL_7)
	play_sound_from_entity(CHANNEL_7, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	label(0x08)
	label(0x08)
	try_spawn_chr_at_pad(BODY_CIFEMTECH, HEAD_SECRETARY, 0x0104, AILIST_INIT_HOLOCLONE1, 0x00002010, /*goto*/ 0x2e)
	label(0x2e)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	try_spawn_chr_at_pad(BODY_CIFEMTECH, HEAD_SECRETARY, 0x0105, AILIST_INIT_HOLOCLONE2, 0x00002010, /*goto*/ 0x2e)
	label(0x2e)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	try_spawn_chr_at_pad(BODY_CIFEMTECH, HEAD_SECRETARY, 0x0106, AILIST_INIT_HOLOCLONE3, 0x00002010, /*goto*/ 0x2e)
	label(0x2e)
	set_ailist(CHR_TAKER_HOLO1, AILIST_TAKER_HOLO1)
	set_ailist(CHR_TAKER_HOLO2, AILIST_TAKER_HOLO2)
	set_ailist(CHR_TAKER_HOLO3, AILIST_TAKER_HOLO3)
	jog_to_pad(0x0107)

	beginloop(0x0b)
		if_chr_stopped(/*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)

	label(0x12)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_HOLO_TAKERS_DEAD, TRUE, /*goto*/ 0x08)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x10)

	label(0x2e)
	goto_first(0x12)

	label(0x08)
	set_ailist(CHR_SELF, AILIST_INIT_SAVED_HOSTAGE)
	endlist
};

u8 func041c_init_holoclone1[] = {
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	play_sound(0x05bc, CHANNEL_9)
	set_shotlist(AILIST_HOLOCLONE_ONSHOT)
	set_chr_maxdamage(CHR_SELF, 1)
	set_chr_id(CHR_HOLOCLONE1)
	jog_to_pad(0x0108)
	set_ailist(CHR_SELF, AILIST_HOLOCLONE)
	endlist
};

u8 func041d_init_holoclone2[] = {
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	play_sound(0x05bc, CHANNEL_5)
	set_shotlist(AILIST_HOLOCLONE_ONSHOT)
	set_chr_maxdamage(CHR_SELF, 1)
	set_chr_id(CHR_HOLOCLONE2)
	jog_to_pad(0x0109)
	set_ailist(CHR_SELF, AILIST_HOLOCLONE)
	endlist
};

u8 func041e_init_holoclone3[] = {
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	play_sound(0x05bc, CHANNEL_6)
	set_shotlist(AILIST_HOLOCLONE_ONSHOT)
	set_chr_maxdamage(CHR_SELF, 1)
	set_chr_id(CHR_HOLOCLONE3)
	jog_to_pad(0x010a)
	set_ailist(CHR_SELF, AILIST_HOLOCLONE)
	endlist
};

u8 func041f_holoclone_onshot[] = {
	play_sound(0x05bb, CHANNEL_6)
	drop_gun_and_fade_out
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func041f_holoclone[] = {
	beginloop(0x0b)
		if_chr_stopped(/*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)

	label(0x12)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x10)

	label(0x2e)
	goto_first(0x12)

	endlist
};

#define holo_taker_logic(holoclone) \
	restart_timer \
	chr_do_animation(ANIM_SURPRISED_0202, 0, -1, 0x00, 0x10, CHR_SELF, 2) \
 \
	beginloop(0xba) \
		set_target_chr(CHR_BOND) \
		if_chr_sees_player(/*goto*/ 0xbb) \
		set_target_chr(CHR_COOP) \
		if_chr_sees_player(/*goto*/ 0xbb) \
		if_timer_gt(60, /*goto*/ 0xbb) \
	endloop(0xba) \
 \
	label(0xbb) \
	set_self_chrflag(CHRCFLAG_00000040) \
	set_accuracy(50) \
	set_target_chr(holoclone) \
	label(0x04) \
	yield \
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0xb9) \
	label(0xb9) \
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00) \
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x0a) \
 \
	beginloop(0x0a) \
		if_chr_stopped(/*goto*/ 0x08) \
	endloop(0x0a) \
 \
	label(0x08) \
	set_shotlist(GAILIST_UNALERTED) \
	set_returnlist(CHR_SELF, GAILIST_UNALERTED) \
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)



u8 func0420_taker_holo1[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	holo_taker_logic(CHR_HOLOCLONE1)
	endlist
};

u8 func0421_taker_holo2[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	assign_sound(0x025b, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	holo_taker_logic(CHR_HOLOCLONE2)
	endlist
};

u8 func0422_taker_holo3[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	holo_taker_logic(CHR_HOLOCLONE3)
	endlist
};

u8 func0423_init_shock[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(20)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(90)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0426_init_saved_hostage[] = {
	set_shotlist(AILIST_HOSTAGE_THANK_AND_RUN)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	set_chr_team(CHR_SELF, TEAM_NONCOMBAT)
	add_health_or_armor(80)
	set_chr_maxdamage(CHR_SELF, 1)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_HOSTAGE_THANK_AND_RUN)

	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0425_hostage_thank_and_run[] = {
	set_shotlist(AILIST_HOSTAGE_THANK_AND_RUN)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x03)

	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x03)
	set_target_chr(CHR_COOP)
	if_chr_sees_player(/*goto*/ 0x2e)
	set_chrpreset(CHR_BOND)
	goto_next(0x08)

	label(0x2e)
	set_chrpreset(CHR_COOP)

	label(0x08)
	restart_timer
	label(0x0a)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0b)

	beginloop(0x0b)
		if_timer_gt(60, /*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)
	if_sound_finished(CHANNEL_6, /*goto*/ 0x08)
	if_timer_gt(200, /*goto*/ 0x2f)
	goto_first(0x0b)

	label(0x08)
	play_cistaff_quip(BANK_3, CHANNEL_6)
	chr_do_animation(ANIM_TALKING_0231, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	label(0x2f)
	restart_timer

	beginloop(0x71)
		if_timer_gt(120, /*goto*/ 0x2e)
	endloop(0x71)

	label(0x2e)
	run_to_pad(0x00b7)

	beginloop(0x11)
		if_chr_stopped(/*goto*/ 0x10)
	endloop(0x11)

	// Unreachable
	set_target_chr(CHR_PRESET)

	beginloop(0x10)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x2e)
		set_target_chr(CHR_ANTI)
		if_chr_sees_player(/*goto*/ 0x2e)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x2e)
		if_distance_to_target_gt(500, /*goto*/ 0x08)
		label(0x2e)
	endloop(0x10)

	label(0x08)
	unset_self_chrflag(CHRCFLAG_KILLCOUNTABLE)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0428_init_drop_devastator[] = {
	unset_self_chrflag(CHRCFLAG_KILLCOUNTABLE)
	set_shotlist(AILIST_HOSTAGE_THANK_AND_RUN)
	set_chr_team(CHR_SELF, TEAM_NONCOMBAT)
	set_chr_maxdamage(CHR_SELF, 40)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_DROP_DEVASTATOR)
	endlist
};

u8 func0427_drop_devastator[] = {
	set_shotlist(AILIST_HOSTAGE_THANK_AND_RUN)
	if_stage_flag_eq(STAGEFLAG_DROPPED_DEVASTATOR, TRUE, /*goto*/ 0x2e)
	set_stage_flag(STAGEFLAG_DROPPED_DEVASTATOR)
	goto_next(0x08)

	// Other hostage already dropped Devastator
	label(0x2e)
	set_ailist(CHR_SELF, AILIST_HOSTAGE_THANK_AND_RUN)

	label(0x08)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x03)

	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x03)
	set_target_chr(CHR_COOP)
	if_chr_sees_player(/*goto*/ 0x2e)
	set_chrpreset(CHR_BOND)
	goto_next(0x08)

	label(0x2e)
	set_chrpreset(CHR_COOP)

	label(0x08)
	restart_timer
	label(0x0a)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0b)

	beginloop(0x0b)
		if_timer_gt(60, /*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)
	give_object_to_chr(OBJ_DEVASTATOR, CHR_SELF)
	yield
	drop_concealed_items(CHR_SELF)
	play_cistaff_quip(BANK_3, CHANNEL_6)
	chr_do_animation(ANIM_TALKING_0231, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	restart_timer

	beginloop(0x71)
		if_timer_gt(120, /*goto*/ 0x2e)
	endloop(0x71)

	label(0x2e)
	run_to_pad(0x00b7)

	beginloop(0x11)
		if_chr_stopped(/*goto*/ 0x10)
	endloop(0x11)

	// Unreachable
	set_target_chr(CHR_PRESET)

	beginloop(0x10)
		if_chr_sees_player(/*goto*/ 0x2e)
		if_distance_to_target_gt(500, /*goto*/ 0x08)
		label(0x2e)
	endloop(0x10)

	label(0x08)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_check_holo_takers_dead[] = {
	beginloop(0x03)
		if_chr_dying(CHR_TAKER_HOLO1, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_HOLO1, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_HOLO1, /*goto*/ 0x2e)
		reloop(0x03)

		label(0x2e)
		if_chr_dying(CHR_TAKER_HOLO2, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_HOLO2, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_HOLO2, /*goto*/ 0x2e)
		reloop(0x03)

		label(0x2e)
		if_chr_dying(CHR_TAKER_HOLO3, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_HOLO3, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_HOLO3, /*goto*/ 0x2e)
	endloop(0x03)

	label(0x2e)
	set_stage_flag(STAGEFLAG_HOLO_TAKERS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_check_device_takers_dead[] = {
	beginloop(0x03)
		if_chr_dying(CHR_TAKER_DEVICE_M, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_DEVICE_M, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_DEVICE_M, /*goto*/ 0x2e)
		reloop(0x03)

		label(0x2e)
		if_chr_dying(CHR_TAKER_DEVICE_F, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_DEVICE_F, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_DEVICE_F, /*goto*/ 0x2e)
	endloop(0x03)

	label(0x2e)
	set_stage_flag(STAGEFLAG_DEVICE_TAKERS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_check_info_takers_dead[] = {
	beginloop(0x03)
		if_chr_dying(CHR_TAKER_INFO_F, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_INFO_F, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_INFO_F, /*goto*/ 0x2e)
		reloop(0x03)

		label(0x2e)
		if_chr_dying(CHR_TAKER_INFO_M, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_INFO_M, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_INFO_M, /*goto*/ 0x2e)
	endloop(0x03)

	label(0x2e)
	set_stage_flag(STAGEFLAG_INFO_TAKERS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042c_init_hostage_device_f[] = {
	set_morale(1)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_DEVICEROOM_HOSTAGE)
	endlist
};

u8 func042d_init_hostage_device_m[] = {
	set_morale(6)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_DEVICEROOM_HOSTAGE)
	endlist
};

u8 func042b_deviceroom_hostage[] = {
	set_shotlist(AILIST_DEVICEROOM_HOSTAGE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x12)

	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x12)
	set_target_chr(CHR_BOND)
	if_chr_sees_player(/*goto*/ 0x2e)
	set_target_chr(CHR_COOP)
	if_chr_sees_player(/*goto*/ 0x2e)
	stop_chr
	goto_next(0x10)

	label(0x2e)
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_DEVICE_TAKERS_DEAD, TRUE, /*goto*/ 0x08)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x10)

	label(0x2e)
	goto_first(0x12)

	label(0x08)
	set_ailist(CHR_SELF, AILIST_INIT_SAVED_HOSTAGE)
	endlist
};

u8 func042f_init_taker_device_m[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_TAKER_DEVICE_M)
	endlist
};

u8 func042e_taker_device_m[] = {
	set_shotlist(AILIST_TAKER_DEVICE_M)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x08)

	// Dying
	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x08)
	set_self_chrflag(CHRCFLAG_00020000)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x08)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	if_objective_complete(0, /*goto*/ 0x2e)
	set_stage_flag(STAGEFLAG_VISITED_HOSTAGES_BEFORE_AUTOGUNS)

	label(0x2e)
	increase_squadron_alertness(100)
	assign_sound(0x025b, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	restart_timer
	chr_do_animation(ANIM_SURPRISED_0202, 0, -1, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0xba)
		if_timer_gt(60, /*goto*/ 0xbb)
	endloop(0xba)

	label(0xbb)
	set_self_chrflag(CHRCFLAG_00000040)
	set_accuracy(50)
	set_target_chr(CHR_HOSTAGE_DEVICE_M)
	set_ailist(CHR_SELF, AILIST_TAKER_ATTACK)
	endlist
};

u8 func0431_init_taker_device_f[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_TAKER_DEVICE_F)
	endlist
};

u8 func0430_taker_device_f[] = {
	set_shotlist(AILIST_TAKER_DEVICE_F)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x08)

	// Dying
	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x08)
	set_self_chrflag(CHRCFLAG_00020000)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x08)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	increase_squadron_alertness(100)
	set_self_flag_bankx(CHRFLAG1_00000020, BANK_1)
	restart_timer
	chr_do_animation(ANIM_RELOAD_0209, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0xbc)
		if_self_flag_bankx_eq(CHRFLAG1_00000020, FALSE, BANK_1, /*goto*/ 0x08)
		if_timer_lt(120, /*goto*/ 0x08)
		assign_sound(0x80f6, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, CHR_SELF, 0x0bb8, 0x1770, 0x01)
		unset_self_flag_bankx(CHRFLAG1_00000020, BANK_1)
		label(0x08)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0xbc)

	label(0x2e)
	set_self_chrflag(CHRCFLAG_00000040)
	set_accuracy(50)
	set_target_chr(CHR_HOSTAGE_DEVICE_F)
	set_ailist(CHR_SELF, AILIST_TAKER_ATTACK)
	endlist
};

u8 func0432_taker_attack[] = {
	set_shotlist(AILIST_TAKER_ATTACK)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x08)

	// Dying
	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x08)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x04)

	// Injured
	label(0x2e)
	restart_timer

	beginloop(0x71)
		if_chr_stopped(/*goto*/ 0x04)
		if_timer_gt(180, /*goto*/ 0x04)
	endloop(0x71)

	// Healthy
	label(0x04)
	yield
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0xb9)
	label(0xb9)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x0a)

	beginloop(0x0a)
		if_chr_stopped(/*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	label(0x0f)
	set_shotlist(GAILIST_UNALERTED)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func0434_init_hostage_info_m[] = {
	set_morale(2)
	add_health_or_armor(10)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_INFOROOM_HOSTAGE)
	endlist
};

u8 func0435_init_hostage_info_f[] = {
	set_morale(8)
	add_health_or_armor(10)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_INFOROOM_HOSTAGE)
	endlist
};

u8 func0433_inforoom_hostage[] = {
	set_shotlist(AILIST_INFOROOM_HOSTAGE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x04)

	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x08)
	endloop(0x04)

	label(0x08)
	if_objective_complete(0, /*goto*/ 0x2e)
	set_stage_flag(STAGEFLAG_VISITED_HOSTAGES_BEFORE_AUTOGUNS)

	// This flag is assigned at random to one of the two hostages
	label(0x2e)
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x0e)

	// Flag not set - run and cower
	run_to_pad(0x010d)

	beginloop(0x0a)
		if_stage_flag_eq(STAGEFLAG_INFO_TAKERS_DEAD, TRUE, /*goto*/ 0x0d)
		if_chr_stopped(/*goto*/ 0x12)
	endloop(0x0a)

	label(0x12)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_INFO_TAKERS_DEAD, TRUE, /*goto*/ 0x0d)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x10)

	label(0x2e)
	goto_first(0x12)

	// Flag was set - fight hostage taker
	label(0x0e)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2e)
	goto_next(0x0d)

	label(0x2e)
	unset_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	set_shotlist(AILIST_INFOROOM_HOSTAGE)
	set_returnlist(CHR_SELF, AILIST_INFOROOM_HOSTAGE)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	label(0x0d)
	if_kill_count_gt(1, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, AILIST_INIT_DROP_DEVASTATOR)

	label(0x2e)
	set_ailist(CHR_SELF, AILIST_INIT_SAVED_HOSTAGE)
	endlist
};

u8 func1012_info_room[] = {
	beginloop(0x04)
		if_door_state(0x19, DOORSTATE_OPEN, /*goto*/ 0x2e)
	endloop(0x04)

	// One hostage is randomly given chrflag0_00000004, which allows that
	// hostage to fight the taker.
	label(0x2e)
	call_rng
	if_rand_gt(128, /*goto*/ 0x0a)

	set_chr_flag_bankx(CHR_HOSTAGE_INFO_M, CHRFLAG0_00002000, BANK_0)
	set_chr_flag_bankx(CHR_HOSTAGE_INFO_F, CHRFLAG0_00002000, BANK_0)
	set_chr_flag_bankx(CHR_HOSTAGE_INFO_M, CHRFLAG0_00000004, BANK_0)
	set_chr_maxdamage(CHR_TAKER_INFO_M, 10)
	goto_next(0x2e)

	label(0x0a)
	set_chr_flag_bankx(CHR_HOSTAGE_INFO_M, CHRFLAG0_00002000, BANK_0)
	set_chr_flag_bankx(CHR_HOSTAGE_INFO_F, CHRFLAG0_00002000, BANK_0)
	set_chr_flag_bankx(CHR_HOSTAGE_INFO_F, CHRFLAG0_00000004, BANK_0)
	set_chr_maxdamage(CHR_TAKER_INFO_F, 10)

	label(0x2e)
	restart_timer

	beginloop(0x0b)
		if_timer_gt(60, /*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)
	set_chr_flag_bankx(CHR_TAKER_INFO_F, CHRFLAG0_00002000, BANK_0)
	set_chr_flag_bankx(CHR_TAKER_INFO_M, CHRFLAG0_00002000, BANK_0)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0437_init_taker_info_m[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_TAKER_INFO_M)
	endlist
};

u8 func0436_taker_info_m[] = {
	set_shotlist(AILIST_TAKER_INFO_M)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x08)

	// Dying
	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x08)

	beginloop(0x0a)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	set_self_chrflag(CHRCFLAG_00000040)
	set_accuracy(50)
	set_target_chr(CHR_HOSTAGE_INFO_M)
	set_ailist(CHR_SELF, AILIST_TAKER_ATTACK)
	endlist
};

u8 func0439_init_taker_info_f[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_TAKER_INFO_F)
	endlist
};

u8 func0438_taker_info_f[] = {
	set_shotlist(AILIST_TAKER_INFO_F)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x08)

	// Dying
	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x08)

	beginloop(0x0a)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	set_self_chrflag(CHRCFLAG_00000040)
	set_accuracy(20)
	set_target_chr(CHR_HOSTAGE_INFO_F)
	set_ailist(CHR_SELF, AILIST_TAKER_ATTACK)
	endlist
};

u8 func1013_check_hostages_saved[] = {
	yield
	yield

	beginloop(0x0a)
		if_chr_dying(CHR_HOSTAGE_FR1, /*goto*/ 0x2f)
		if_chr_death_animation_finished(CHR_HOSTAGE_FR1, /*goto*/ 0x2f)
		if_chr_unloaded(CHR_HOSTAGE_FR1, /*goto*/ 0x2f)
		goto_next(0x2e)

		// FR1 hostage dead
		label(0x2f)
		if_chr_dying(CHR_HOSTAGE_FR2, /*goto*/ 0x2f)
		if_chr_death_animation_finished(CHR_HOSTAGE_FR2, /*goto*/ 0x2f)
		if_chr_unloaded(CHR_HOSTAGE_FR2, /*goto*/ 0x2f)

		// FR1 hostage alive
		label(0x2e)
		if_chr_dying(CHR_TAKER_FR1, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_TAKER_FR1, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_FR1, /*goto*/ 0x2e)
	endloop(0x0a)

	// FR1 hostage alive and FR1 taker dead
	label(0x2e)
	if_chr_dying(CHR_TAKER_FR2, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_TAKER_FR2, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_TAKER_FR2, /*goto*/ 0x2e)
	goto_first(0x0a)

	// Both FR hostages dead
	label(0x2f)

	// Both FR takers dead
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_DEVICE_TAKERS_DEAD, TRUE, /*goto*/ 0x2e)
	if_chr_dying(CHR_HOSTAGE_DEVICE_F, /*goto*/ 0x2f)
	if_chr_death_animation_finished(CHR_HOSTAGE_DEVICE_F, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_HOSTAGE_DEVICE_F, /*goto*/ 0x2f)
	goto_first(0x0a)

	label(0x2f)
	if_chr_dying(CHR_HOSTAGE_DEVICE_M, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_HOSTAGE_DEVICE_M, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_HOSTAGE_DEVICE_M, /*goto*/ 0x2e)
	goto_first(0x0a)

	// FR and device room done
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_INFO_TAKERS_DEAD, TRUE, /*goto*/ 0x2e)
	if_chr_dying(CHR_HOSTAGE_INFO_M, /*goto*/ 0x2f)
	if_chr_death_animation_finished(CHR_HOSTAGE_INFO_M, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_HOSTAGE_INFO_M, /*goto*/ 0x2f)
	goto_first(0x0a)

	label(0x2f)
	if_chr_dying(CHR_HOSTAGE_INFO_F, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_HOSTAGE_INFO_F, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_HOSTAGE_INFO_F, /*goto*/ 0x2e)
	goto_first(0x0a)

	// FR, device and info rooms done
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_HOLO_TAKERS_DEAD, TRUE, /*goto*/ 0x2e)
	if_chr_dying(CHR_HOSTAGE_HOLO, /*goto*/ 0x2e)
	if_chr_death_animation_finished(CHR_HOSTAGE_HOLO, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_HOSTAGE_HOLO, /*goto*/ 0x2e)
	goto_first(0x0a)

	// All rooms done
	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_TOO_MANY_HOSTAGES_KILLED, TRUE, /*goto*/ 0x2e)
	show_hudmsg(CHR_BOND, L_IMP(17)) // "Hostages have been saved."
	set_stage_flag(STAGEFLAG_ENOUGH_HOSTAGES_SAVED)

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_carrington_messages[] = {
	restart_timer

	beginloop(0x03)
		if_chr_dying(CHR_CARRINGTON, /*goto*/ 0xd9)
		if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2e)
	endloop(0x03)

	#define carrington_sanity_checks \
		if_chr_dying(CHR_CARRINGTON, /*goto*/ 0xd9) \
		if_chr_dying(CHR_BOND, /*goto*/ 0x05) \
		goto_next(0x06) \
 \
		label(0x05) \
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0xd9) \
		label(0x06)



	label(0x2e)
	yield
	label(0x08)
	restart_timer

	beginloop(0x0a)
		carrington_sanity_checks
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x08)
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	restart_timer
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)
	speak(CHR_BOND, L_IMP(20), 0x8193, CHANNEL_6, COLOR_06_WHITE) // "Joanna - we're under attack."

	beginloop(0x0b)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0x0b)

	label(0x08)
	speak(CHR_BOND, L_IMP(21), 0x8194, CHANNEL_6, COLOR_06_WHITE) // "Get the guns back on line - hurry."

	beginloop(0x0c)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x0d)
	endloop(0x0c)

	beginloop(0x0d)
		set_stage_flag(STAGEFLAG_TRIGGER_AUTODEFENSES_MSG)
		carrington_sanity_checks
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x08)
		if_objective_complete(0, /*goto*/ 0x08)
	endloop(0x0d)

	label(0x08)
	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_HIDDEN)
	unlock_door(0x23, 0x04)
	unlock_door(0x24, 0x04)
	restart_timer

	beginloop(0xbd)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0xda)
	endloop(0xbd)

	label(0xda)
	restart_timer
	speak(CHR_BOND, L_IMP(22), 0x8195, CHANNEL_6, COLOR_06_WHITE) // "The Skedar have taken hostages."

	beginloop(0x0e)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0x0e)

	label(0x08)
	restart_timer
	speak(CHR_BOND, L_IMP(23), 0x8196, CHANNEL_6, COLOR_06_WHITE) // "Get up to the offices and save them."

	beginloop(0x0f)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x10)
	endloop(0x0f)

	label(0x10)
	set_stage_flag(STAGEFLAG_TRIGGER_COUNTINGONME_MSG)
	yield
	carrington_sanity_checks
	if_objective_complete(1, /*goto*/ 0x08)
	goto_first(0x10)

	label(0x08)
	restart_timer

	beginloop(0xbe)
		carrington_sanity_checks
		if_timer_gt(300, /*goto*/ 0x08)
		reloop(0xbe)

		label(0x08)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x08)
	endloop(0xbe)

	label(0x08)
	restart_timer
	speak(CHR_BOND, L_IMP(24), 0x8197, CHANNEL_6, COLOR_06_WHITE) // "They're using a new form of shield technology."

	beginloop(0x11)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0x11)

	label(0x08)
	restart_timer
	speak(CHR_BOND, L_IMP(25), 0x8198, CHANNEL_6, COLOR_06_WHITE) // "Foster was working on a new weapon which may be us..."

	beginloop(0x12)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0xbf)
	endloop(0x12)

	beginloop(0xbf)
		carrington_sanity_checks
		if_objective_complete(2, /*goto*/ 0x08)
	endloop(0xbf)

	label(0x08)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0xdb)
	restart_timer

	beginloop(0xc0)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0xc0)

	label(0x08)
#if VERSION >= VERSION_JAP_FINAL
	unset_object_flag(OBJ_SAFEINFO, OBJFLAG_INVINCIBLE)
#endif
	restart_timer
	speak(CHR_BOND, L_IMP(26), 0x8199, CHANNEL_6, COLOR_06_WHITE) // "Damn it. My office... If they get access..."

	beginloop(0xc1)
		carrington_sanity_checks
		if_timer_gt(240, /*goto*/ 0x08)
	endloop(0xc1)

	label(0x08)
	restart_timer
	speak(CHR_BOND, L_IMP(27), 0x819a, CHANNEL_6, COLOR_06_WHITE) // "Get there first, Jo, and destroy the files."

	beginloop(0xc2)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0xc3)
	endloop(0xc2)

	beginloop(0xc3)
		carrington_sanity_checks
		if_objective_complete(3, /*goto*/ 0x08)
	endloop(0xc3)

	label(0x08)
	label(0xdb)

	// Wait until no one in skedar shuttle area
	beginloop(0x71)
		if_chr_in_room(CHR_BOND, 0x00, 0x0045, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x0047, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x004d, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x0055, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x0046, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0xe5)
		if_chr_in_room(CHR_COOP, 0x00, 0x0045, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x0047, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x004d, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x0055, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x0046, /*goto*/ 0x2e)
		label(0xe5)
		if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0xe5)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0045, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0047, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x004d, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0055, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0046, /*goto*/ 0x2e)
		label(0xe5)
		goto_next(0x08)

		label(0x2e)
	endloop(0x71)

	label(0x08)
	restart_timer

	beginloop(0xc4)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0xc4)

	label(0x08)
	restart_timer
	speak(CHR_BOND, L_IMP(28), 0x819b, CHANNEL_6, COLOR_06_WHITE) // "Things are desperate. They've planted a bomb."

	beginloop(0xc5)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0xc5)

	label(0x08)
	restart_timer
	speak(CHR_BOND, L_IMP(29), 0x819c, CHANNEL_6, COLOR_06_WHITE) // "Find it and get it out of the building."

	beginloop(0xc6)
		carrington_sanity_checks
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0xc6)

	label(0x08)
	play_x_music(CHANNEL_10, 120)
	set_countdown_timer(120)
	show_countdown_timer
	start_countdown_timer

	beginloop(0xc7)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_SHUTTLE_TAKEOFF, TRUE, /*goto*/ 0x2e)
		if_countdown_timer_lt(1, /*goto*/ 0x08)
	endloop(0xc7)

	label(0x08)
	set_stage_flag(STAGEFLAG_BOMB_EXPLODING_ON_GROUND)
	hide_countdown_timer
	label(0x2e)
	restart_timer

	beginloop(0xc8)
		if_timer_gt(300, /*goto*/ 0x2e)
	endloop(0xc8)

	label(0x2e)
	carrington_sanity_checks
	restart_timer
	speak(CHR_BOND, L_IMP(32), 0x819d, CHANNEL_6, COLOR_06_WHITE) // "Well done, Joanna. We're nearly clear..."

	beginloop(0xc9)
		if_timer_gt(180, /*goto*/ 0x08)
	endloop(0xc9)

	label(0x08)
	carrington_sanity_checks
	speak(CHR_BOND, L_IMP(33), 0x819e, CHANNEL_6, COLOR_06_WHITE) // "The last dropship is waiting for you. Hurry."

	beginloop(0xca)
		if_timer_gt(180, /*goto*/ 0xcb)
	endloop(0xca)

	beginloop(0xcb)
		chr_toggle_p1p2(CHR_SELF)
		if_all_objectives_complete(/*goto*/ 0x2e)
		reloop(0xcb)

		label(0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0054, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0053, /*goto*/ 0x2e)
	endloop(0xcb)

	label(0x2e)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2e)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2e)
	goto_next(0x08)

	label(0x2e)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2e)
	goto_next(0x08)

	label(0x2e)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x08)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, 0x0418)

	label(0xd9)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_firingrange_pc[] = {
	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_FR_PC, /*goto*/ 0x08)
		if_object_in_good_condition(OBJ_FR_PC, /*goto*/ 0x2e)
		goto_next(0x2f)

		label(0x2e)
		reloop(0x0a)

		label(0x2f)
		show_hudmsg(CHR_BOND, L_IMP(34)) // "Critical mission object has been destroyed."
		set_stage_flag(STAGEFLAG_FR_PC_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x08)
		play_sound(0x8116, -1)
		if_objective_complete(1, /*goto*/ 0x08)
		show_hudmsg(CHR_P1P2, L_IMP(30)) // "Access denied - authorization failure."
		restart_timer

		beginloop(0x0b)
			if_timer_gt(120, /*goto*/ 0x2e)
		endloop(0x0b)

		label(0x2e)
	endloop(0x0a)

	label(0x08)
	show_hudmsg(CHR_P1P2, L_IMP(31)) // "Emergency overrides have been engaged."
	unset_object_flag(OBJ_RCP120, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag(OBJ_RCP120_GLASS, OBJFLAG_INVINCIBLE)
	destroy_object(OBJ_RCP120_GLASS)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define topspawner_logic(initfunc, clonefunc) \
	set_self_chrflag(CHRCFLAG_00000002) \
	set_self_chrflag(CHRCFLAG_HIDDEN) \
	set_self_chrflag(CHRCFLAG_00040000) \
 \
	beginloop(0x04) \
		if_objective_complete(1, /*goto*/ 0x2e) \
		reloop(0x04) \
 \
		label(0x2e) \
		dprint 'O','B','J','E','C','T','I','V','E',' ','D','O','N','E','\n',0, \
		if_never_been_onscreen(/*goto*/ 0x4f) \
		if_chr_sees_player(/*goto*/ 0x0a) \
		reloop(0x04) \
 \
		label(0x0a) \
		set_ailist(CHR_SELF, clonefunc) \
 \
		label(0x4f) \
		unset_self_chrflag(CHRCFLAG_HIDDEN) \
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f) \
		goto_first(0x04) \
 \
		label(0x4f) \
		try_spawn_clone2(CHR_SELF, initfunc, 0x00000000, /*goto*/ 0x2e) \
		set_ailist(CHR_SELF, clonefunc) \
 \
		label(0x2e) \
		yield \
	endloop(0x04)



#define inittopclone_logic(templatechr, clonefunc) \
	set_chr_dodge_rating(2, 0x00) \
	set_accuracy(20) \
	set_reaction_speed(70) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(90) \
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1) \
	label(0x04) \
	try_inherit_properties(templatechr, /*goto*/ 0x08) \
	label(0x08) \
	set_chr_team(CHR_SELF, TEAM_ENEMY) \
	rebuild_teams \
	rebuild_squadrons \
	set_ailist(CHR_SELF, clonefunc)



// Spawner at top of ramp at start
u8 func040a_spawner4[] = {
	topspawner_logic(AILIST_INIT_CLONE4, AILIST_CLONE4)
	endlist
};

u8 func040c_init_clone4[] = {
	inittopclone_logic(0x11, AILIST_CLONE4)
	endlist
};

u8 func040b_clone4[] = {
	set_target_chr(CHR_BOND)
	try_run_to_target(/*goto*/ 0x2e)
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

// Spawner at helipad
u8 func040d_spawner5[] = {
	topspawner_logic(AILIST_INIT_CLONE5, AILIST_CLONE5)
	endlist
};

u8 func040f_init_clone5[] = {
	inittopclone_logic(0x12, AILIST_CLONE5)
	endlist
};

u8 func040e_clone5[] = {
	call_rng
	if_rand_gt(128, /*goto*/ 0x08)
	run_to_pad(0x005b)
	goto_next(0x2e)

	label(0x08)
	run_to_pad(0x0069)

	label(0x2e)
	set_returnlist(CHR_SELF, AILIST_CLONE5)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * When the autoguns are completed, the game removes a single shock guard from
 * the tunnels area.
 *
 * Looks like the intention is to remove the bottom spawners once the autogun
 * objective is done, then remove the top spawners once the hostages are done,
 * but due to changed chr IDs and a probable incorrect goto, this function
 * fails pretty bad at achieving this.
 */
u8 func1016_remove_spawners[] = {
	beginloop(0x0a)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
		if_objective_complete(0, /*goto*/ 0x2e)
	endloop(0x0a)

	// Unreachable
	label(0x08)
	remove_chr(0x0c)
	remove_chr(0x0e)
	remove_chr(0x10)

	beginloop(0x0b)
		if_objective_complete(1, /*goto*/ 0x2e)
	endloop(0x0b)

	// Agent, or autoguns complete
	label(0x2e)
	remove_chr(0x0b) // invalid chr ID
	remove_chr(0x0d) // black guard
	remove_chr(0x0f) // invalid chr ID

	beginloop(0x0c)
		if_objective_complete(2, /*goto*/ 0x2e)
	endloop(0x0c)

	label(0x2e)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

// Spawner outside Jo's office
u8 func0410_spawner6[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_objective_complete(2, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x000c, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		dprint 'O','B','J','E','C','T','I','V','E',' ','D','O','N','E','\n',0,
		if_never_been_onscreen(/*goto*/ 0x4f)
		if_chr_sees_player(/*goto*/ 0x0a)
		reloop(0x04)

		label(0x0a)
		set_ailist(CHR_SELF, AILIST_CLONE6)

		label(0x4f)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		label(0x4f)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_CLONE6, 0x00000000, /*goto*/ 0x2e)
		set_ailist(CHR_SELF, AILIST_CLONE6)

		label(0x2e)
		yield
	endloop(0x04)

	endlist
};

u8 func0412_init_clone6[] = {
	inittopclone_logic(0x13, AILIST_CLONE6)
	endlist
};

u8 func0411_clone6[] = {
	set_target_chr(CHR_BOND)
	try_run_to_target(/*goto*/ 0x2e)
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func1022_skedar_shuttle[] = {
	beginloop(0x12)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)
		if_objective_complete(3, /*goto*/ 0x08)
		reloop(0x12)

		label(0x2e)
		if_objective_complete(2, /*goto*/ 0x08)
	endloop(0x12)

	label(0x08)

	beginloop(0x71)
		if_chr_in_room(CHR_BOND, 0x00, 0x0045, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x0047, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x004d, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x0055, /*goto*/ 0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x0046, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0xe5)
		if_chr_in_room(CHR_COOP, 0x00, 0x0045, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x0047, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x004d, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x0055, /*goto*/ 0x2e)
		if_chr_in_room(CHR_COOP, 0x00, 0x0046, /*goto*/ 0x2e)
		label(0xe5)
		if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0xe5)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0045, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0047, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x004d, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0055, /*goto*/ 0x2e)
		if_chr_in_room(CHR_ANTI, 0x00, 0x0046, /*goto*/ 0x2e)
		label(0xe5)
		goto_next(0x08)

		label(0x2e)
	endloop(0x71)

	label(0x08)
	show_object(OBJ_SKEDAR_SHUTTLE)
	set_object_flag2(OBJ_SKEDAR_SHUTTLE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_SKEDAR_SHUTTLE, OBJFLAG3_00000010)
	object_do_animation(0x045a, OBJ_SKEDAR_SHUTTLE, 0x04, 0xffff)
	set_object_part_visible(OBJ_SKEDAR_SHUTTLE, FALSE)
	set_object_flag(OBJ_SKEDAR_SHUTTLE, OBJFLAG_00000100)

	unset_chr_chrflag(CHR_BLONDE1, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE2, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE3, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE4, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE5, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE6, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_BLONDE2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_BLONDE3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_BLONDE4, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_BLONDE5, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_BLONDE6, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_BLONDE1, AILIST_INIT_BLONDE)
	set_ailist(CHR_BLONDE2, AILIST_INIT_BLONDE)
	set_ailist(CHR_BLONDE3, AILIST_INIT_BLONDE)
	set_ailist(CHR_BLONDE4, AILIST_INIT_BLONDE)
	set_ailist(CHR_BLONDE5, AILIST_INIT_BLONDE)
	set_ailist(CHR_BLONDE6, AILIST_INIT_BLONDE)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_BOMB_EXPLODING_ON_GROUND, TRUE, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_SHUTTLE_TAKEOFF, TRUE, /*goto*/ 0x0a)
		object_do_animation(0x045a, OBJ_SKEDAR_SHUTTLE, 0x04, 0xffff)
	endloop(0x04)

	// Bomb exploding while on ground
	label(0x2e)
	hide_countdown_timer
	stop_countdown_timer
	destroy_object(OBJ_SKEDAR_SHUTTLE)
	explosions_around_chr(CHR_BOND)
	restart_timer

	beginloop(0x72)
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x72)

	label(0x2e)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2f)
	explosions_around_chr(CHR_COOP)

	goto_next(0x41)
	label(0x2f)
	if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x41)
	explosions_around_chr(CHR_ANTI)

	label(0x41)
	restart_timer

	beginloop(0x73)
		if_timer_gt(90, /*goto*/ 0x2e)
	endloop(0x73)

	label(0x2e)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Bomb deactivated
	label(0x0a)
	hide_countdown_timer
	stop_countdown_timer
	object_do_animation(0x045b, OBJ_SKEDAR_SHUTTLE, 0x08, 0xffff)
	assign_sound(0x810a, CHANNEL_3)
	play_sound_from_object(CHANNEL_3, OBJ_SKEDAR_SHUTTLE, 0x0708, 0x0bb8)
	restart_timer

	beginloop(0x0b)
		dprint 'O','B','J','\n',0,
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x0b)

	label(0x2e)
	assign_sound(0x810b, CHANNEL_4)
	play_sound_from_object(CHANNEL_4, OBJ_SKEDAR_SHUTTLE, 0x0708, 0x0bb8)

	beginloop(0x0d)
		dprint 'O','B','J','\n',0,
		if_timer_gt(200, /*goto*/ 0x08)
	endloop(0x0d)

	label(0x08)
	dprint 'O','B','J','E','C','T','I','V','E',' ','D','O','N','E','\n',0,
	set_stage_flag(STAGEFLAG_BOMB_AIRBORNE)
	restart_timer

	beginloop(0x0c)
		if_timer_gt(240, /*goto*/ 0x2e)
	endloop(0x0c)

	label(0x2e)
	set_object_health(OBJ_SKEDAR_SHUTTLE, 0)
	mute_channel(CHANNEL_3)
	mute_channel(CHANNEL_4)
	destroy_object(OBJ_SKEDAR_SHUTTLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func043a_unused[] = {
	set_chr_maxdamage(CHR_SELF, 1)

	beginloop(0x12)
		if_objective_complete(3, /*goto*/ 0x08)
	endloop(0x12)

	label(0x08)

	beginloop(0x04)
	endloop(0x04)

	endlist
};

u8 unregistered_function1[] = {
	// All of these objects have been removed :\
	// Wait for all 4 objects destroyed
	beginloop(0x04)
		if_object_in_good_condition(0x1f, /*goto*/ 0x08)
		goto_next(0x2e)
		label(0x08)
		reloop(0x04)

		label(0x2e)
		if_object_in_good_condition(0x20, /*goto*/ 0x08)
		goto_next(0x2e)
		label(0x08)
		reloop(0x04)

		label(0x2e)
		if_object_in_good_condition(0x21, /*goto*/ 0x08)
		goto_next(0x2e)
		label(0x08)
		reloop(0x04)

		label(0x2e)
		if_object_in_good_condition(0x22, /*goto*/ 0x08)
		goto_next(0x2e)
		label(0x08)
	endloop(0x04)

	label(0x2e)
	restart_timer

	beginloop(0x71)
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x71)

	label(0x2e)
	set_stage_flag(STAGEFLAG_TRIGGER_SHUTTLE_TAKEOFF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func043b_init_blonde[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(20)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(90)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func043c_init_cisolder[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(20)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(90)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_DEFEND_PAD)
	endlist
};

u8 func043d_unused[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(30)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(90)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func043e_carrington[] = {
	set_shotlist(AILIST_CARRINGTON)
	jog_to_pad(0x0142)

	beginloop(0x04)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	stop_chr

	beginloop(0x0a)
	endloop(0x0a)

	endlist
};

u8 func0429_skedar4[] = {
	stop_chr
	set_accuracy(40)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(160)
	set_recovery_speed(0)
	set_shield(0)
	jog_to_pad(0x000c)
	set_ailist(CHR_SELF, GAILIST_RELATED_TO_SPAWNING)
	endlist
};

u8 func1018_hurt_carrington[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_VISITED_HOSTAGES_BEFORE_AUTOGUNS, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(600, /*goto*/ 0x08)
	endloop(0x0a)

	label(0x08)
	damage_chr(CHR_CARRINGTON, 18)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1019_setup_safeinfo[] = {
	label(0x08)
#if VERSION < VERSION_JAP_FINAL
	unset_object_flag(OBJ_SAFEDOOR, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_SAFEINFO, OBJFLAG_INVINCIBLE)
#endif
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101b_msg_autodefenses[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0a)

	beginloop(0x04)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_AUTODEFENSES_MSG, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	yield
	yield
	speak(CHR_BOND, L_IMP(35), 0x73d8, CHANNEL_6, COLOR_09_BLUE) // "The autodefenses will really help me out."
	label(0x0a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_msg_fosterworkingon[] = {
	beginloop(0x04)
		if_objective_complete(1, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	restart_timer

	beginloop(0x0a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0009, /*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)
	speak(CHR_P1P2, L_IMP(36), 0x73d9, CHANNEL_6, COLOR_09_BLUE) // "So this is what Foster was working on."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_msg_countingonme[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_COUNTINGONME_MSG, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	restart_timer

	beginloop(0x0a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2f)
		goto_first(0x04)

		label(0x2f)
		if_timer_gt(180, /*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)
	speak(CHR_BOND, L_IMP(37), 0x73da, CHANNEL_6, COLOR_09_BLUE) // "I'll have to go carefully... The hostages are coun..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This message is not played because no condition breaks out of the loop.
 */
u8 func101e_msg_wontknow[] = {
	beginloop(0x04)
	endloop(0x04)

	label(0x2e)
	speak(CHR_BOND, L_IMP(38), 0x73db, CHANNEL_6, COLOR_09_BLUE) // "Well, at least I won't know if I'm doing anything ..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_configure_cisoldiers[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_ailist(CHR_JONATHAN, AILIST_INIT_JONATHAN)
	set_ailist(0x15, AILIST_INIT_CISOLDIER)
	set_ailist(0x16, AILIST_INIT_CISOLDIER)
	set_ailist(0x17, AILIST_INIT_CISOLDIER)
	set_ailist(0x18, AILIST_INIT_CISOLDIER)
	set_ailist(0x19, AILIST_INIT_CISOLDIER)
	set_ailist(0x1a, AILIST_INIT_CISOLDIER)
	set_ailist(0x1b, AILIST_INIT_CISOLDIER)
	set_ailist(0x1c, AILIST_INIT_CISOLDIER)
	set_ailist(0x1d, AILIST_INIT_CISOLDIER)
	set_ailist(0x1e, AILIST_INIT_CISOLDIER)
	set_ailist(CHR_HANGARGUY, AILIST_INIT_CISOLDIER)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1020_trigger_spawning[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2e)
	endloop(0x04)

	// Wait 15 seconds
	label(0x2e)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(900, /*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)
	set_stage_flag(STAGEFLAG_TRIGGER_SPAWNING)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042a_init_jonathan[] = {
	set_accuracy(100)
	set_reaction_speed(100)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(1200)
	set_recovery_speed(100)
	set_ailist(CHR_SELF, AILIST_DEFEND_PAD)
	endlist
};

u8 func1021_setup_jonathan[] = {
	yield
	if_savefile_flag_is_set(SAVEFILEFLAG_DEFENSE_JON, /*goto*/ 0x08)
	remove_chr(CHR_JONATHAN)
	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1023_check_skeder_shuttle_destroyed[] = {
	beginloop(0x12)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)
		if_objective_complete(3, /*goto*/ 0x08)
		reloop(0x12)

		label(0x2e)
		if_objective_complete(2, /*goto*/ 0x08)
	endloop(0x12)

	beginloop(0x04)
		if_object_in_good_condition(OBJ_SKEDAR_SHUTTLE, /*goto*/ 0x08)
		goto_next(0x2e)

		label(0x08)
	goto_first(0x04)

	// Shuttle destroyed
	label(0x2e)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(30, /*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_BOMB_AIRBORNE, TRUE, /*goto*/ 0x0f)
	show_hudmsg(CHR_BOND, L_IMP(39)) // "The bomb has been detonated..."
	set_stage_flag(STAGEFLAG_BOMB_EXPLODING_ON_GROUND)
	explosions_around_chr(CHR_BOND)
	restart_timer

	beginloop(0x72)
		if_timer_gt(60, /*goto*/ 0x2e)
	endloop(0x72)

	label(0x2e)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2f)
	explosions_around_chr(CHR_COOP)
	goto_next(0x41)

	label(0x2f)
	if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x41)
	explosions_around_chr(CHR_ANTI)

	label(0x41)
	restart_timer

	beginloop(0x73)
		if_timer_gt(90, /*goto*/ 0x2e)
	endloop(0x73)

	label(0x2e)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x0f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1024_setup_lifts[] = {
	activate_lift(1, 0x41)
	activate_lift(2, 0x42)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1025_lift_door_sounds[] = {
	beginloop(0xe4)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x46, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x47, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x48, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x49, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x4a, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x4b, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x4c, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x4d, /*goto*/ 0x2e)
		reloop(0xe4)

		label(0x2e)
		play_sound(0x81b0, -1)
		restart_timer

		beginloop(0x0a)
			if_timer_gt(120, /*goto*/ 0x08)
		endloop(0x0a)

		label(0x08)
	endloop(0xe4)

	endlist
};

u8 func100e_setup_firingrange_doors[] = {
	// Wait until firing range doors opened
	beginloop(0xe4)
		if_door_state(0x23, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		if_door_state(0x23, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
	endloop(0xe4)

	// Unset some flags on them
	label(0x2e)
	unset_object_flag2(0x23, OBJFLAG2_AICANNOTUSE)
	unset_object_flag2(0x24, OBJFLAG2_AICANNOTUSE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1027_uplink[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_SKEDAR_SHUTTLE, /*goto*/ 0x2f)
		goto_next(0x0f)

		label(0x2f)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, OBJ_SKEDAR_SHUTTLE, /*goto*/ 0x2e)
		reloop(0x04)

		// Activated
		label(0x08)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_DATAUPLINK, /*goto*/ 0x2e)
		play_sound(0x8116, -1)
		show_hudmsg(CHR_TARGET, L_IMP(51)) // "You need the Data Uplink."
		reloop(0x04)

		// Activated with uplink
		label(0x2e)
		show_hudmsg(CHR_TARGET, L_IMP(52)) // "Connection has been made."
		restart_timer

		beginloop(0x0a)
			if_object_in_good_condition(OBJ_SKEDAR_SHUTTLE, /*goto*/ 0x2f)
			goto_next(0x0f)

			label(0x2f)
			if_timer_gt(60, /*goto*/ 0x08)
			if_chr_in_room(CHR_TARGET, 0x00, 0x0045, /*goto*/ 0x2e)
			goto_next(0x0b)

			label(0x2e)
			if_chr_weapon_equipped(CHR_TARGET, WEAPON_DATAUPLINK, /*goto*/ 0x2e)
			goto_next(0x0b)

			label(0x2e)
		endloop(0x0a)

		// 1 second since uplink
		label(0x08)
		show_hudmsg(CHR_TARGET, L_IMP(53)) // "Bypassing security systems."
		restart_timer
		assign_sound(0x01bf, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, OBJ_SKEDAR_SHUTTLE, TRUE)

		beginloop(0x13)
			if_object_in_good_condition(OBJ_SKEDAR_SHUTTLE, /*goto*/ 0x2f)
			goto_next(0x0f)

			label(0x2f)
			if_timer_gt(400, /*goto*/ 0x08)
			if_chr_in_room(CHR_TARGET, 0x00, 0x0045, /*goto*/ 0x2e)
			goto_next(0x0b)

			label(0x2e)
			if_chr_weapon_equipped(CHR_TARGET, WEAPON_DATAUPLINK, /*goto*/ 0x2e)
			goto_next(0x0b)

			label(0x2e)
		endloop(0x13)

		// 7.66 seconds since uplink
		label(0x08)
		mute_channel(CHANNEL_5)
		assign_sound(0x01c1, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, OBJ_SKEDAR_SHUTTLE, TRUE)
		show_hudmsg(CHR_TARGET, L_IMP(54)) // "Virus has been downloaded successfully."
		yield
		show_hudmsg(CHR_TARGET, L_IMP(55)) // "Ship's engines have been activated."
		set_stage_flag(STAGEFLAG_TRIGGER_SHUTTLE_TAKEOFF)

		beginloop(0x14)
			if_timer_gt(90, /*goto*/ 0x08)
		endloop(0x14)

		label(0x08)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		reloop(0x04)

		// Connection broken
		label(0x0b)
		show_hudmsg(CHR_TARGET, L_IMP(56)) // "Connection to ship has been broken."
		mute_channel(CHANNEL_5)
		assign_sound(0x01c0, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, OBJ_SKEDAR_SHUTTLE, TRUE)
		restart_timer

		beginloop(0x15)
			if_timer_gt(120, /*goto*/ 0x08)
		endloop(0x15)

		label(0x08)
		mute_channel(CHANNEL_6)
	endloop(0x04)

	label(0x0f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1028_shuttle_immunity[] = {
	beginloop(0xe4)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_SHUTTLE_TAKEOFF, TRUE, /*goto*/ 0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0045, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0046, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0047, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004d, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004e, /*goto*/ 0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0055, /*goto*/ 0x2e)
		reloop(0xe4)

		label(0x2e)
		unset_object_flag(OBJ_SKEDAR_SHUTTLE, OBJFLAG_INVINCIBLE)
	endloop(0xe4)

	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1029_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_DEVASTATOR, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102a_setup_lighting[] = {
	yield
	misc_command(0x0045, 0x06, 0x01)
	misc_command(0x0046, 0x06, 0x01)
	misc_command(0x0047, 0x06, 0x01)
	misc_command(0x0048, 0x06, 0x01)
	misc_command(0x0055, 0x06, 0x01)
	misc_command(0x0056, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102b_safedoor_immunity[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x10)
	set_object_flag(OBJ_SAFEDOOR, OBJFLAG_INVINCIBLE)

	beginloop(0x04)
		if_objective_complete(2, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_object_in_good_condition(OBJ_SAFEDOOR, /*goto*/ 0x2e)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2e)
		if_chr_in_room(CHR_BOND, 0x00, 0x000c, /*goto*/ 0x2e)
		goto_next(0x0b)

		label(0x2e)
		if_chr_weapon_equipped(CHR_BOND, WEAPON_LASER, /*goto*/ 0x0f)

		// Jo not in office room or laser not equipped
		label(0x0b)
		if_chr_in_room(CHR_COOP, 0x00, 0x000c, /*goto*/ 0x2e)
		goto_next(0x0e)

		label(0x2e)
		if_chr_weapon_equipped(CHR_COOP, WEAPON_LASER, /*goto*/ 0x0f)

		// No one in office room with laser equipped
		label(0x0e)
		set_object_flag(OBJ_SAFEDOOR, OBJFLAG_INVINCIBLE)
		reloop(0x04)

		label(0x0f)
		unset_object_flag(OBJ_SAFEDOOR, OBJFLAG_INVINCIBLE)
	endloop(0x04)

	// A and SA
	label(0x10)
	set_object_flag(OBJ_SAFEDOOR, OBJFLAG_INVINCIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102c_door_flags[] = {
	yield
	if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x0f)
	lock_door(0x23, 0x40)
	lock_door(0x24, 0x40)
	set_object_flag2(0x23, OBJFLAG2_00000004)
	set_object_flag2(0x24, OBJFLAG2_00000004)
	lock_door(0x43, 0x40)
	lock_door(0x44, 0x40)
	set_object_flag2(0x43, OBJFLAG2_00000004)
	set_object_flag2(0x44, OBJFLAG2_00000004)
	lock_door(0x54, 0x40)
	set_object_flag2(0x54, OBJFLAG2_00000004)
	lock_door(0x19, 0x40)
	set_object_flag2(0x19, OBJFLAG2_00000004)

	beginloop(0xe4)
		if_chr_activated_object(CHR_BOND, 0x23, /*goto*/ 0x0a)
		if_chr_activated_object(CHR_BOND, 0x23, /*goto*/ 0x0a)
		if_chr_activated_object(CHR_BOND, 0x43, /*goto*/ 0x0b)
		if_chr_activated_object(CHR_BOND, 0x44, /*goto*/ 0x0b)
		if_chr_activated_object(CHR_BOND, 0x54, /*goto*/ 0x0c)
		if_chr_activated_object(CHR_BOND, 0x19, /*goto*/ 0x0d)
		reloop(0xe4)

		label(0x0a)
		unlock_door(0x23, 0x40)
		unlock_door(0x24, 0x40)
		open_door(0x23)
		reloop(0xe4)

		label(0x0b)
		unlock_door(0x43, 0x40)
		unlock_door(0x44, 0x40)
		open_door(0x43)
		reloop(0xe4)

		label(0x0c)
		unlock_door(0x54, 0x40)
		open_door(0x54)
		reloop(0xe4)

		label(0x0d)
		unlock_door(0x19, 0x40)
		open_door(0x19)
	endloop(0xe4)

	label(0x0f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function2[] = {
	beginloop(0x03)
		restart_timer

		// Wait 10 seconds
		beginloop(0x0a)
			if_timer_gt(600, /*goto*/ 0x2e)
		endloop(0x0a)

		label(0x2e)
		chr_do_animation(0x02c3, -1, -1, 0x06, 0x00, 0x34, 4)
	endloop(0x03)

	endlist
};

u8 unregistered_function3[] = {
	beginloop(0x03)
		if_chr_unloaded(CHR_TAKER_INFO_F, /*goto*/ 0x11)
		if_chr_unloaded(CHR_TAKER_INFO_M, /*goto*/ 0x12)
		reloop(0x03)

		label(0x11)
		damage_chr(CHR_TAKER_INFO_F, 18)
		reloop(0x03)

		label(0x12)
		damage_chr(CHR_TAKER_INFO_M, 18)
	endloop(0x03)

	endlist
};

u8 func102d_firingrange_taker_invincibility[] = {
	beginloop(0x03)
		if_chr_death_animation_finished(CHR_TAKER_FR1, /*goto*/ 0x2e)
		if_chr_dying(CHR_TAKER_FR1, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_FR1, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR1, 0x00, 0x0007, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR1, 0x00, 0x0008, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR1, 0x00, 0x0009, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR1, 0x00, 0x000a, /*goto*/ 0x2e)
		unset_chr_chrflag(CHR_TAKER_FR1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

		label(0x2e)
		if_chr_death_animation_finished(CHR_TAKER_FR2, /*goto*/ 0x2e)
		if_chr_dying(CHR_TAKER_FR2, /*goto*/ 0x2e)
		if_chr_unloaded(CHR_TAKER_FR2, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR2, 0x00, 0x0007, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR2, 0x00, 0x0008, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR2, 0x00, 0x0009, /*goto*/ 0x2e)
		if_chr_in_room(CHR_TAKER_FR2, 0x00, 0x000a, /*goto*/ 0x2e)
		unset_chr_chrflag(CHR_TAKER_FR2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

		label(0x2e)
	endloop(0x03)

	endlist
};

struct ailist ailists[] = {
	{ func1400_setup_counterop,                 0x1400 },
	{ func1001_objectives_failed_msg,           0x1001 },
	{ func1002_intro,                           0x1002 },
	{ func1003_hide_blondes_and_skedar,         0x1003 },
	{ func1004_check_hostages_killed,           0x1004 },
	{ func1005_check_safeinfo_destroyed,        0x1005 },
	{ func1007_autogun_switch1,                 0x1007 },
	{ func1008_autogun_switch2,                 0x1008 },
	{ func1009_autogun_switch3,                 0x1009 },
	{ func100b_setup_autoguns,                  0x100b },
	{ func100c_check_carrington_dead,           0x100c },
	{ func100e_setup_firingrange,               0x100e },
	{ func100f_check_holo_takers_dead,          0x100f },
	{ func1010_check_device_takers_dead,        0x1010 },
	{ func1011_check_info_takers_dead,          0x1011 },
	{ func1012_info_room,                       0x1012 },
	{ func1013_check_hostages_saved,            0x1013 },
	{ func1014_carrington_messages,             0x1014 },
	{ func1015_firingrange_pc,                  0x1015 },
	{ func1016_remove_spawners,                 0x1016 },
	{ func1018_hurt_carrington,                 0x1018 },
	{ func1019_setup_safeinfo,                  0x1019 },
	{ func101b_msg_autodefenses,                0x101b },
	{ func101c_msg_fosterworkingon,             0x101c },
	{ func101d_msg_countingonme,                0x101d },
	{ func101e_msg_wontknow,                    0x101e },
	{ func101f_configure_cisoldiers,            0x101f },
	{ func1020_trigger_spawning,                0x1020 },
	{ func1021_setup_jonathan,                  0x1021 },
	{ func1022_skedar_shuttle,                  0x1022 },
	{ func1023_check_skeder_shuttle_destroyed,  0x1023 },
	{ func1024_setup_lifts,                     0x1024 },
	{ func1025_lift_door_sounds,                0x1025 },
	{ func100e_setup_firingrange_doors,         0x1026 },
	{ func1027_uplink,                          0x1027 },
	{ func1028_shuttle_immunity,                0x1028 },
	{ func1029_setup_rtracker,                  0x1029 },
	{ func102a_setup_lighting,                  0x102a },
	{ func102b_safedoor_immunity,               0x102b },
	{ func102c_door_flags,                      0x102c },
	{ func102d_firingrange_taker_invincibility, 0x102d },
	{ func1002_intro,                           0x0c00 },
	{ func0c01_outro,                           0x0c01 },
	{ func1002_intro,                           0x0417 },
	{ func0c01_outro,                           0x0418 },
	{ func0414_firingrange_hostage,             0x0414 },
	{ func0415_init_hostage_fr1,                0x0415 },
	{ func0416_init_hostage_fr2,                0x0416 },
	{ func0401_spawner1,                        0x0401 },
	{ func0404_spawner2,                        0x0404 },
	{ func0407_spawner3,                        0x0407 },
	{ func040a_spawner4,                        0x040a },
	{ func040d_spawner5,                        0x040d },
	{ func0410_spawner6,                        0x0410 },
	{ func0402_clone1,                          0x0402 },
	{ func0403_init_clone1,                     0x0403 },
	{ func0405_clone2,                          0x0405 },
	{ func0406_init_clone2,                     0x0406 },
	{ func0408_clone3,                          0x0408 },
	{ func0409_init_clone3,                     0x0409 },
	{ func040b_clone4,                          0x040b },
	{ func040c_init_clone4,                     0x040c },
	{ func040e_clone5,                          0x040e },
	{ func040f_init_clone5,                     0x040f },
	{ func0411_clone6,                          0x0411 },
	{ func0412_init_clone6,                     0x0412 },
	{ func0413_defend_pad,                      0x0413 },
	{ func0419_init_firingrange_taker,          0x0419 },
	{ func041a_hostage_holo,                    0x041a },
	{ func041b_init_hostage_holo,               0x041b },
	{ func041c_init_holoclone1,                 0x041c },
	{ func041d_init_holoclone2,                 0x041d },
	{ func041e_init_holoclone3,                 0x041e },
	{ func041f_holoclone,                       0x041f },
	{ func0420_taker_holo1,                     0x0420 },
	{ func0421_taker_holo2,                     0x0421 },
	{ func0422_taker_holo3,                     0x0422 },
	{ func0423_init_shock,                      0x0423 },
	{ func0425_hostage_thank_and_run,           0x0425 },
	{ func0426_init_saved_hostage,              0x0426 },
	{ func0427_drop_devastator,                 0x0427 },
	{ func0428_init_drop_devastator,            0x0428 },
	{ func0429_skedar4,                         0x0429 },
	{ func042a_init_jonathan,                   0x042a },
	{ func041f_holoclone_onshot,                0x0424 },
	{ func042b_deviceroom_hostage,              0x042b },
	{ func042c_init_hostage_device_f,           0x042c },
	{ func042d_init_hostage_device_m,           0x042d },
	{ func042e_taker_device_m,                  0x042e },
	{ func042f_init_taker_device_m,             0x042f },
	{ func0430_taker_device_f,                  0x0430 },
	{ func0431_init_taker_device_f,             0x0431 },
	{ func0432_taker_attack,                    0x0432 },
	{ func0433_inforoom_hostage,                0x0433 },
	{ func0434_init_hostage_info_m,             0x0434 },
	{ func0435_init_hostage_info_f,             0x0435 },
	{ func0436_taker_info_m,                    0x0436 },
	{ func0437_init_taker_info_m,               0x0437 },
	{ func0438_taker_info_f,                    0x0438 },
	{ func0439_init_taker_info_f,               0x0439 },
	{ func043a_unused,                          0x043a },
	{ func043b_init_blonde,                     0x043b },
	{ func043c_init_cisolder,                   0x043c },
	{ func043d_unused,                          0x043d },
	{ func043e_carrington,                      0x043e },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_FLYING },
	{ NULL, 0, 0 },
};

