//
// Villa
//

#include "stagesetup.h"

// Characters
#define CHR_SNIPER1    0x00
#define CHR_SNIPER2    0x01
#define CHR_SNIPER3    0x02
#define CHR_SNIPER4    0x03
#define CHR_SNIPER5    0x04
#define CHR_SNIPER6    0x05
#define CHR_SNIPER7    0x06
#define CHR_SNIPER8    0x07
#define CHR_BASEMENT1  0x43
#define CHR_BASEMENT2  0x44
#define CHR_BASEMENT3  0x45
#define CHR_BASEMENT4  0x46
#define CHR_BASEMENT5  0x47
#define CHR_BASEMENT6  0x48
#define CHR_BASEMENT7  0x49
#define CHR_BASEMENT8  0x4a
#define CHR_BASEMENT9  0x4b
#define CHR_TAKER1     0x4e
#define CHR_TAKER2     0x4f
#define CHR_NEGOTIATOR 0x50
#define CHR_CARRINGTON 0x51
#define CHR_HACKER1    0x52
#define CHR_HACKER2    0x53
#define CHR_HACKER3    0x54
#define CHR_CISOLDIER  0x55

// Objects
#define OBJ_DROPSHIP        0x00
#define OBJ_COOLING_SWITCH  0x03
#define OBJ_POWER_SWITCH    0x04
#define OBJ_WINDMILL_SWITCH 0x05
#define OBJ_KEYCARD         0x0a
#define OBJ_HACKERPC1       0x0b
#define OBJ_HACKERPC2       0x0c
#define OBJ_HACKERPC3       0x0d
#define OBJ_HACKERPC4       0x0e
#define OBJ_WINDMILL        0x0f
#define OBJ_CMP150_1        0x8e
#define OBJ_CMP150_2        0x8f
#define OBJ_DEVASTATOR      0x99

// Stage flags
#define STAGEFLAG_NEGOTIATOR_DEAD              0x00000100
#define STAGEFLAG_NEGOTIATOR_ESCAPED           0x00000200
#define STAGEFLAG_SNIPERS_DEAD                 0x00000400
#define STAGEFLAG_COOLING_ACTIVE               0x00000800
#define STAGEFLAG_POWER_ACTIVE                 0x00001000
#define STAGEFLAG_WINDMILL_ACTIVATED           0x00002000
#define STAGEFLAG_WINDMILL_SWITCH_DESTROYED    0x00004000
#define STAGEFLAG_HACKERS_DEAD                 0x00008000
#define STAGEFLAG_HACKERS_SUCCEEDED            0x00010000
#define STAGEFLAG_CARRINGTON_RESCUED           0x00020000
#define STAGEFLAG_TAKERS_DEAD                  0x00080000
#define STAGEFLAG_GUARD_CAPTURED               0x00100000
#define STAGEFLAG_HACKER_PC_DESTROYED          0x00200000
#define STAGEFLAG_HACKERS_STARTED              0x00400000
#define STAGEFLAG_INTRO_FINISHED               0x00800000
#define STAGEFLAG_ONE_BASEMENT_GUARD_REMAINING 0x01000000
#define STAGEFLAG_PLAYING_INTRO_FROM_MENU      0x02000000
#define STAGEFLAG_FORGOT_TO_KO_GUARD           0x04000000

// AI Lists
#define AILIST_INIT_TAKER          0x0401
#define AILIST_TAKER               0x0402
#define AILIST_NEGOTIATOR          0x0403
#define AILIST_SNIPER              0x0404
#define AILIST_HACKER              0x0405
#define AILIST_INIT_HACKER         0x0406
#define AILIST_INIT_SNIPER         0x0407
#define AILIST_OUTRO               0x0408
#define AILIST_INTRO               0x0409
#define AILIST_ENABLE_SNIPER       0x040a
#define AILIST_INIT_BASEMENT_GUARD 0x040b
#define AILIST_INIT_TYPE1_GUARD    0x040c
#define AILIST_INIT_TYPE2_GUARD    0x040d // has better accuracy on PA
#define AILIST_PATH01              0x040e
#define AILIST_PATH02              0x040f
#define AILIST_CARRINGTON          0x0410
#define AILIST_CISOLIDER           0x0411

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x2001)
	briefing(1, 0x2000)
	briefing(2, 0x2002)
	briefing(3, 0x2003)

	beginobjective(0, L_ELD(5), (DIFFBIT_A | DIFFBIT_SA)) // "Save the negotiator"
		complete_flags(STAGEFLAG_NEGOTIATOR_ESCAPED)
		fail_flags(STAGEFLAG_NEGOTIATOR_DEAD)
	endobjective

	beginobjective(1, L_ELD(6), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Eliminate rooftop snipers"
		complete_flags(STAGEFLAG_SNIPERS_DEAD)
	endobjective

	beginobjective(2, L_ELD(7), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Activate wind generator"
		complete_flags(STAGEFLAG_WINDMILL_ACTIVATED)
		fail_flags(STAGEFLAG_WINDMILL_SWITCH_DESTROYED)
	endobjective

	beginobjective(3, L_ELD(8), (DIFFBIT_PA | DIFFBIT_PD)) // "Locate and eliminate dataDyne hackers"
		complete_flags(STAGEFLAG_HACKERS_DEAD)
		fail_flags(STAGEFLAG_HACKERS_SUCCEEDED)
		fail_flags(STAGEFLAG_HACKER_PC_DESTROYED)
	endobjective

	beginobjective(4, L_ELD(10), (DIFFBIT_PA | DIFFBIT_PD)) // "Capture dataDyne guard"
		complete_flags(STAGEFLAG_GUARD_CAPTURED)
		fail_flags(STAGEFLAG_FORGOT_TO_KO_GUARD)
	endobjective

	beginobjective(5, L_ELD(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Rescue Carrington"
		complete_flags(STAGEFLAG_CARRINGTON_RESCUED)
	endobjective

	// Note these snipers are replaced with new ones further below.
	chr(0x00000061, 0x00, 0x0192, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000061, 0x01, 0x0193, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000061, 0x02, 0x0194, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000061, 0x05, 0x0197, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000061, 0x06, 0x0198, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)

	tag(0x8e, 2)
	tag(0x8f, 2)
	weapon(0x0100, MODEL_CHRCMP150, 0x019a, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x019a, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)

	chr(0x00000001, 0x04, 0x0196, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000001, 0x07, 0x0199, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000001, 0x03, 0x0195, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 40, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000081, 0x00, 0x0192, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 80, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000081, 0x01, 0x0193, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 80, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000081, 0x02, 0x0194, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 80, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000081, 0x05, 0x0197, BODY_DDSNIPER, HEAD_RANDOM, AILIST_INIT_SNIPER, -1, -1, 500, 80, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	chr(0x00000081, 0x06, 0x0198, BODY_DDSNIPER, HEAD_DDSNIPER, AILIST_INIT_SNIPER, -1, -1, 500, 80, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	tag(0x8e, 2)
	tag(0x8f, 2)
	weapon(0x0100, MODEL_CHRCMP150, 0x019a, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x019a, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	chr(0x00010401, CHR_NEGOTIATOR, 0x022b, BODY_SECRETARY, HEAD_SECRETARY, GAILIST_IDLE, -1, -1, 500, 50, 0x00004408, 0x00000000, TEAM_ALLY, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000001, 0x4e, 0x0229, BODY_DD_GUARD, HEAD_JON, GAILIST_IDLE, -1, -1, 500, 150, 0xc0004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000001, 0x4f, 0x022a, BODY_DD_GUARD, HEAD_BEAU1, GAILIST_IDLE, -1, -1, 500, 150, 0x80004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x08, 0x00b4, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0x80204208, 0x04000040, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x09, 0x022f, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0x80284208, 0x00000040, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x0a, 0x019b, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0x80284208, 0x04000040, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x0b, 0x00b8, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0x80284208, 0x00000040, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x0c, 0x0231, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0x80284208, 0x04000040, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x0d, 0x0232, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0x80284208, 0x00000040, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x23, 0x01b1, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003000, 0x00000000, TEAM_20, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0023, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x24, 0x01b2, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003000, 0x04000000, TEAM_20, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x25, 0x01b3, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003000, 0x00000000, TEAM_20, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0025, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x26, 0x01b4, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003000, 0x04000000, TEAM_20, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x27, 0x01b5, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003100, 0x00000000, TEAM_20, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0027, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x28, 0x01b6, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003100, 0x04000000, TEAM_20, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x29, 0x01b7, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003100, 0x00000000, TEAM_20, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0029, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x2a, 0x01b8, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003100, 0x04000000, TEAM_20, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x2b, 0x01b9, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc400b000, 0x00000000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x2c, 0x01ba, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc400b000, 0x04000000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x2d, 0x01bb, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc400b000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x2e, 0x01bc, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc400b000, 0x04000000, TEAM_20, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000261, 0x2f, 0x01bd, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc000e000, 0x00000000, TEAM_20, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000261, 0x30, 0x01be, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc000e000, 0x04000000, TEAM_20, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x31, 0x01bf, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc000e000, 0x00000000, TEAM_20, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x32, 0x01c0, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc000e000, 0x04000000, TEAM_20, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x33, 0x01c1, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003100, 0x00000000, TEAM_20, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x34, 0x01c2, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003100, 0x04000000, TEAM_20, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x35, 0x01c3, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003000, 0x00000000, TEAM_20, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0035, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x36, 0x01c4, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003000, 0x04000000, TEAM_20, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0036, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3d, 0x01cb, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4003000, 0x00000000, TEAM_20, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x37, 0x01c5, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4206200, 0x00000000, TEAM_20, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0037, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x38, 0x01c6, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4206200, 0x04000000, TEAM_20, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0038, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000201, 0x39, 0x01c7, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc4206200, 0x00000000, TEAM_20, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0039, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3a, 0x01c8, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0xc4003000, 0x04000000, TEAM_20, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3b, 0x01c9, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0xc4003000, 0x00000000, TEAM_20, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3c, 0x01ca, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0xc4003000, 0x04000000, TEAM_20, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3e, 0x01cc, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0xc4009000, 0x00000000, TEAM_20, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3f, 0x01cd, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0xc4009000, 0x04000000, TEAM_20, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x40, 0x01ce, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE2_GUARD, -1, -1, 500, 50, 0xc4009000, 0x00000000, TEAM_20, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0040, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x41, 0x01cf, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc0005000, 0x04000000, TEAM_20, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0041, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x42, 0x01d0, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 500, 50, 0xc0005000, 0x00000000, TEAM_20, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0042, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x43, 0x01d1, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, -1, -1, 500, 50, 0x80000201, 0x04000000, TEAM_20, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0043, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x44, 0x01d2, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, -1, -1, 500, 50, 0xc0005000, 0x00000000, TEAM_20, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0044, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x45, 0x01d3, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, -1, -1, 500, 50, 0xc0005000, 0x04000000, TEAM_20, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0045, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x46, 0x01d4, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, -1, -1, 500, 50, 0xd0082000, 0x00000000, TEAM_20, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0046, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x47, 0x01d5, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, -1, -1, 500, 50, 0xd0082000, 0x04000000, TEAM_20, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0047, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x48, 0x01d6, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, 0x0233, -1, 500, 50, 0xc1082000, 0x00000000, TEAM_20, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0048, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x49, 0x01d7, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, 0x00d2, -1, 500, 50, 0xc1082000, 0x04000000, TEAM_20, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0049, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x4a, 0x01d8, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, -1, -1, 500, 50, 0xd0082000, 0x00000000, TEAM_20, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x4b, 0x01d9, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_BASEMENT_GUARD, -1, -1, 500, 50, 0xd0082000, 0x04000000, TEAM_20, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x51, 0x00dc, BODY_CARRINGTON, HEAD_CARRINGTON, AILIST_CARRINGTON, -1, -1, 500, 50, 0x00000000, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x0000c000, 0x52, 0x022c, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_HACKER, -1, -1, 500, 30, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, 0x8d, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0052, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x0000c000, 0x53, 0x022d, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_HACKER, -1, -1, 500, 30, 0x00004408, 0x04000000, TEAM_20, SQUADRON_00, 0x8b, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0053, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x0000c000, 0x54, 0x022e, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_HACKER, -1, -1, 500, 30, 0x00004408, 0x00000000, TEAM_20, SQUADRON_00, 0x8c, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0054, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x4c, 0x0096, BODY_DD_GUARD, HEAD_RANDOM, AILIST_PATH01, -1, -1, 500, 50, 0xc000d000, 0x04000000, TEAM_20, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x4d, 0x0085, BODY_DD_GUARD, HEAD_RANDOM, AILIST_PATH02, -1, -1, 500, 50, 0xc000d000, 0x00000000, TEAM_20, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x55, 0x0234, BODY_CISOLDIER, HEAD_RANDOM, AILIST_CISOLIDER, -1, -1, 500, 50, 0x40005000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSNIPERRIFLE, 0x0055, 0x00004000, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0151, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0152, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0155, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0156, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0157, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0158, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0159, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x015a, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x015b, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x015c, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x015e, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0161, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x015f, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0162, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0164, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0166, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0167, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0168, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0169, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x016a, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x016b, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x0165, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x016c, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x016d, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x015d, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x016e, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x016f, 0x10020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012c0258, 0x0000ffff, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x0160, 0x00020262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x93, 2)
	tag(0x94, 2)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0170, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0171, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0172, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0173, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x90, 2)
	tag(0x91, 2)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0174, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0175, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x017c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x017d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x92, 1)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0176, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x06, 2)
	tag(0x07, 2)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0189, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x018a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x018b, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x018c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x018d, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x018e, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x95, 1)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0177, 0x30000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000080, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x97, 2)
	tag(0x98, 2)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0179, 0x90000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000080, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0178, 0xb0000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000080, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x018f, 0x90000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0190, 0xb0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x96, 1)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x017b, 0x30000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000080, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1e, 12)
	tag(0x1f, 12)
	tag(0x20, 12)
	tag(0x21, 12)
	tag(0x22, 12)
	tag(0x23, 12)
	tag(0x24, 12)
	tag(0x25, 12)
	tag(0x26, 12)
	tag(0x27, 12)
	tag(0x28, 12)
	tag(0x29, 12)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00e5, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00e6, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00e7, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00e8, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00e9, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00ea, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00eb, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00ec, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x00ed, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00ee, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00ef, 0x00200008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00f0, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x2a, 6)
	tag(0x2b, 6)
	tag(0x2c, 6)
	tag(0x2d, 6)
	tag(0x2e, 6)
	tag(0x2f, 6)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00f1, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00f2, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00f3, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00f4, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00f5, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00f6, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x30, 12)
	tag(0x31, 12)
	tag(0x32, 12)
	tag(0x33, 12)
	tag(0x34, 12)
	tag(0x35, 12)
	tag(0x36, 12)
	tag(0x37, 12)
	tag(0x38, 12)
	tag(0x39, 12)
	tag(0x3a, 12)
	tag(0x3b, 12)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00f7, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x00f8, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00f9, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00fa, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00fb, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00fc, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00fd, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x00fe, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x00ff, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0100, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0101, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0102, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x3c, 6)
	tag(0x3d, 6)
	tag(0x3e, 6)
	tag(0x3f, 6)
	tag(0x40, 6)
	tag(0x41, 6)
	glass(0x003a, MODEL_AIVILLABOT3, 0x0103, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0104, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0105, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0106, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x0107, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0108, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x42, 12)
	tag(0x43, 12)
	tag(0x44, 12)
	tag(0x45, 12)
	tag(0x46, 12)
	tag(0x47, 12)
	tag(0x48, 12)
	tag(0x49, 12)
	tag(0x4a, 12)
	tag(0x4b, 12)
	tag(0x4c, 12)
	tag(0x4d, 12)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0109, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x010a, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x010b, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x010c, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x010d, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x010e, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x010f, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0110, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0111, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0112, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0113, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0114, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x4e, 6)
	tag(0x4f, 6)
	tag(0x50, 6)
	tag(0x51, 6)
	tag(0x52, 6)
	tag(0x53, 6)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0115, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0116, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0117, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0118, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0119, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x011a, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x54, 6)
	tag(0x55, 6)
	tag(0x56, 6)
	tag(0x57, 6)
	tag(0x58, 6)
	tag(0x59, 6)
	glass(0x003a, MODEL_AIVILLABOT1, 0x011b, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x011c, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x011d, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x011e, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x011f, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0120, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x5a, 12)
	tag(0x5b, 12)
	tag(0x5c, 12)
	tag(0x5d, 12)
	tag(0x5e, 12)
	tag(0x5f, 12)
	tag(0x60, 12)
	tag(0x61, 12)
	tag(0x62, 12)
	tag(0x63, 12)
	tag(0x64, 12)
	tag(0x65, 12)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0121, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0122, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x0123, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0124, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0125, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0126, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x0127, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0128, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0129, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x012a, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x012b, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x012c, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x66, 6)
	tag(0x67, 6)
	tag(0x68, 6)
	tag(0x69, 6)
	tag(0x6a, 6)
	tag(0x6b, 6)
	glass(0x003a, MODEL_AIVILLABOT1, 0x012d, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x012e, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x012f, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0130, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0131, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0132, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x6c, 12)
	tag(0x6d, 12)
	tag(0x6e, 12)
	tag(0x6f, 12)
	tag(0x70, 12)
	tag(0x71, 12)
	tag(0x72, 12)
	tag(0x73, 12)
	tag(0x74, 12)
	tag(0x75, 12)
	tag(0x76, 12)
	tag(0x77, 12)
	glass(0x003a, MODEL_AIVILLABOT3, 0x0133, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0134, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0135, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0136, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0137, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0138, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0139, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x013a, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x013b, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x013c, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x013d, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x013e, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x78, 6)
	tag(0x79, 6)
	tag(0x7a, 6)
	tag(0x7b, 6)
	tag(0x7c, 6)
	tag(0x7d, 6)
	glass(0x003a, MODEL_AIVILLABOT3, 0x013f, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0140, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x0141, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0142, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0143, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0144, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x7e, 12)
	tag(0x7f, 12)
	tag(0x80, 12)
	tag(0x81, 12)
	tag(0x82, 12)
	tag(0x83, 12)
	tag(0x84, 12)
	tag(0x85, 12)
	tag(0x86, 12)
	tag(0x87, 12)
	tag(0x88, 12)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0145, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0146, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x0147, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT2, 0x0148, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x0149, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x014a, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x014b, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x014c, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT3, 0x014d, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x014e, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x003a, MODEL_AIVILLABOT1, 0x014f, 0x00200408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x0f, 1)
	autogun(0x0100, MODEL_AIVILLAWINDMILL, 0x0191, 0x00020408, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0xffff0000, 0x00000000, 0x00020000, 0xfffe0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x000a0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x019c, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x019d, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x019e, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x019f, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x01a1, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x01a2, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x01a3, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x01a4, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e5, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e6, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_DEVASTATOR)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e0, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e1, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01eb, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_DEVASTATOR)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01dc, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01dd, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_SMG)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01de, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01df, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_SMG)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ea, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01da, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_SMG)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01db, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_DEVASTATOR)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e7, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e2, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_SMG)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e3, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_SMG)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e4, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0xffff, 0x00028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_SMG)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e9, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e8, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ed, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ee, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_TABLE, 0x01a7, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_TABLE, 0x01a8, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_COFFEE_TABLE, 0x01ae, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_COFFEE_TABLE, 0x01ab, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_COFFEE_TABLE, 0x01ac, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x00, 1)
	stdobject(0x0100, MODEL_DROPSHIP, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 1)
	weapon(0x0100, MODEL_CHRDATATHIEF, 0x00bf, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0e, L_ELD(27), L_ELD(27), L_ELD(27), L_ELD(27), L_ELD(27), 0x0000, 0x0000) // "PC gun"
	tag(0x89, 1)
	weapon(0x0100, MODEL_CHRDATATHIEF, 0x00bf, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0e, L_ELD(27), L_ELD(27), L_ELD(27), L_ELD(27), L_ELD(27), 0x0000, 0x0000) // "PC gun"
	tag(0x02, 1)
	weapon(0x0100, MODEL_CHRDATATHIEF, 0x00c0, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x15, L_ELD(28), L_ELD(28), L_ELD(28), L_ELD(28), L_ELD(28), 0x0000, 0x0000) // "Sniper rifle"
	tag(0x8a, 1)
	weapon(0x0100, MODEL_CHRDATATHIEF, 0x00c0, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SNIPERRIFLE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x15, L_ELD(28), L_ELD(28), L_ELD(28), L_ELD(28), L_ELD(28), 0x0000, 0x0000) // "Sniper rifle"
	stdobject(0x00cc, MODEL_CV_TABLE, 0x01ef, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8c, 1)
	stdobject(0x0100, MODEL_CV_CHAIR4, 0x01f0, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_TABLE, 0x01f1, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_CHAIR4, 0x01f2, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_TABLE, 0x01f4, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8d, 1)
	stdobject(0x0100, MODEL_CV_CHAIR4, 0x01f3, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_TABLE, 0x01f5, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x8b, 1)
	stdobject(0x0100, MODEL_CV_CHAIR4, 0x01f6, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0b, 4)
	tag(0x0c, 4)
	tag(0x0d, 4)
	tag(0x0e, 4)
	singlemonitor(0x0100, MODEL_GOODPC, 0x01f9, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_GOODPC, 0x01fa, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_GOODPC, 0x01f8, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_GOODPC, 0x01f7, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x04, 3)
	tag(0x03, 3)
	tag(0x05, 3)
	multimonitor(0x0099, MODEL_CIHUB, 0x01fc, 0x00000002, 0x00000801, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	multimonitor(0x0099, MODEL_CIHUB, 0x01fb, 0x00000002, 0x00000801, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	multimonitor(0x0099, MODEL_CIHUB, 0x01fd, 0x00000002, 0x00000801, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x017f, 0xb0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0180, 0x90000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x09, 1)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0187, 0x30000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000040, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0188, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000040, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x08, 1)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0183, 0x30000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000040, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0184, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000040, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0185, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000600, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AIVILLADOOR2A, 0x0186, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0a, 1)
	key(0x0080, MODEL_KEYCARD, 0x004b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000040)
	rename_object(-1, 0x4a, L_ELD(30), L_ELD(31), L_ELD(32), L_ELD(33), L_ELD(34), 0x0000, 0x0000) // "Obtain door key."
	stdobject(0x0100, MODEL_CV_SOFA, 0x01a5, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_SOFA, 0x01a6, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_COFFEE_TABLE, 0x01af, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTRUBBER, 0x01fe, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIDER, 0x01ff, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0280, MODEL_DD_PLANTSPIKE, 0x0200, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTRUBBER, 0x0201, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTSPIDER, 0x0202, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTSPIKE, 0x0203, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTRUBBER, 0x0204, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0180, MODEL_DD_PLANTSPIDER, 0x0205, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTSPIKE, 0x0206, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTRUBBER, 0x0207, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIDER, 0x0208, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0180, MODEL_DD_PLANTSPIKE, 0x0209, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTRUBBER, 0x020a, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIDER, 0x020b, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTSPIKE, 0x020c, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_DD_PLANTSPIDER, 0x020d, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIKE, 0x020e, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTRUBBER, 0x020f, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIDER, 0x0210, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x014c, MODEL_DD_PLANTSPIKE, 0x0211, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0280, MODEL_DD_PLANTSPIKE, 0x0212, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIDER, 0x0213, 0x04000101, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0180, MODEL_DD_PLANTSPIKE, 0x0214, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0180, MODEL_DD_PLANTSPIKE, 0x0215, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0080, MODEL_DD_PLANTSPIKE, 0x0216, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0080, MODEL_DD_PLANTSPIKE, 0x0217, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0080, MODEL_DD_PLANTSPIKE, 0x0218, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x021a, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x021b, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_TABLE, 0x01b0, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x021c, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x021d, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x021e, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x021f, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x0220, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x0221, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x0222, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x0223, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x0224, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00cc, MODEL_CV_CHAIR1, 0x0225, 0x00000501, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0219, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_VILLASTOOL, 0x0237, 0x00000101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CV_F_BED, 0x0226, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_CV_CABINET, 0x0227, 0x00000501, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_CV_CABINET, 0x0228, 0x00000501, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x10, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0238, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x11, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0239, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ec, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	weapon(0x0100, MODEL_CHRDEVASTATOR, 0xffff, 0x40028000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DEVASTATOR, 0x00ffffff, 0x00000000)
	tag(0x99, -1)
	endprops
};

s32 intro[] = {
	spawn(0x00be)
	ammo(AMMOTYPE_RIFLE, 100)
	ammo(AMMOTYPE_SMG, 100)
	ammo(AMMOTYPE_DEVASTATOR, 3)
	intro_weapon(WEAPON_UNARMED, -1)
	intro_weapon(WEAPON_RTRACKER, -1)
	endintro
};

s32 path00[] = {
	0x0096,
	0x008a,
	0x008b,
	0x008c,
	0x0087,
	0x0088,
	0x0089,
	0x0083,
	0x0084,
	0x0085,
	-1,
};

s32 path01[] = {
	0x0085,
	0x0084,
	0x0083,
	0x0089,
	0x0088,
	0x0087,
	0x008c,
	0x008b,
	0x008a,
	0x0096,
	-1,
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_20)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1002_intro_from_menu[] = {
	set_stage_flag(STAGEFLAG_PLAYING_INTRO_FROM_MENU)
	set_ailist(CHR_SELF, AILIST_INTRO)
	endlist
};

u8 func1002_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	camera_movement(0x0171)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	if_stage_flag_eq(STAGEFLAG_PLAYING_INTRO_FROM_MENU, TRUE, /*goto*/ 0x2e)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	label(0x2e)
	chr_do_animation(0x0172, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	remove_chr(CHR_NEGOTIATOR)
	set_music_track(MUSIC_VILLA_INTRO3)
	goto_next(0x06)
	label(0x2d)
	set_music_track(MUSIC_VILLA_INTRO2)
	chr_do_animation(0x0172, -1, -1, 0x06, 0x00, CHR_NEGOTIATOR, 4)
	label(0x06)
	set_chr_chrflag(CHR_TAKER1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TAKER1, CHRHFLAG_00020000)
	chr_do_animation(0x0173, -1, -1, 0x06, 0x00, CHR_TAKER1, 4)
	set_chr_chrflag(CHR_TAKER2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TAKER2, CHRHFLAG_00020000)
	chr_do_animation(0x0174, -1, -1, 0x06, 0x00, CHR_TAKER2, 4)
	show_object(OBJ_DROPSHIP)
	set_object_flag2(OBJ_DROPSHIP, OBJFLAG2_04000000)
	set_object_flag3(OBJ_DROPSHIP, OBJFLAG3_00000010)
	object_do_animation(0x0175, OBJ_DROPSHIP, 0x04, 0xffff)
	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 110)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x56) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
 \
		label(0x06)



	wait_until(205, 0xab)
	speak(CHR_BOND, L_ELD(39), 0x73ff, CHANNEL_4, COLOR_09_BLUE) // "Agent Dark Mission Log, 1846 hours. Last night we ..."

	wait_until(680, 0x66)
	play_sound(0x0161, CHANNEL_7)

	wait_until(687, 0x67)
	play_sound(0x0162, CHANNEL_6)

	wait_until(708, 0x68)
	play_sound(0x0163, CHANNEL_7)

	wait_until(716, 0x69)
	play_sound(0x0164, CHANNEL_7)

	wait_until(914, 0x6a)
	play_sound(0x0171, CHANNEL_7)

	wait_until(1010, 0x6b)
	play_sound(0x0172, CHANNEL_7)

	wait_until(1048, 0x6c)
	play_sound(0x0173, CHANNEL_7)

	wait_until(1075, 0x6d)
	play_sound(0x0161, CHANNEL_7)

	wait_until(1100, 0xac)
	speak(CHR_BOND, L_ELD(40), 0x7400, CHANNEL_4, COLOR_09_BLUE) // "Unfortunately, we don't have it. Daniel and Dr. Ca..."

	wait_until(1118, 0x6e)
	play_sound(0x0162, CHANNEL_7)

	wait_until(1148, 0x6f)
	play_sound(0x0163, CHANNEL_7)

	wait_until(1175, 0x70)
	play_sound(0x0161, CHANNEL_7)

	wait_until(1193, 0x71)
	play_sound(0x0163, CHANNEL_7)

	wait_until(1214, 0x72)
	play_sound(0x0161, CHANNEL_7)

	wait_until(1313, 0x73)
	play_sound(0x0164, CHANNEL_7)

	wait_until(1313, 0x74)
	play_sound(0x0163, CHANNEL_6)

	wait_until(1331, 0x75)
	play_sound(0x0174, CHANNEL_7)

	wait_until(1348, 0x76)
	play_sound(0x0161, CHANNEL_7)

	wait_until(1366, 0x77)
	play_sound(0x0162, CHANNEL_7)

	wait_until(1386, 0x78)
	play_sound(0x0163, CHANNEL_7)

	wait_until(1390, 0x79)
	play_sound(0x0164, CHANNEL_7)

	wait_until(1450, 0x7a)
	play_sound(0x0161, CHANNEL_7)

	wait_until(1458, 0x7b)
	play_sound(0x0164, CHANNEL_7)

	wait_until(1519, 0x7c)
	play_sound(0x0162, CHANNEL_7)

	wait_until(1544, 0x7d)
	play_sound(0x0161, CHANNEL_7)

	wait_until(1554, 0x7e)
	play_sound(0x0164, CHANNEL_6)

	wait_until(1592, 0x7f)
	play_sound(0x0162, CHANNEL_7)

	wait_until(1618, 0x81)
	play_sound(0x0163, CHANNEL_7)

	wait_until(1645, 0x82)
	play_sound(0x0162, CHANNEL_7)

	wait_until(1654, 0x83)
	play_sound(0x0164, CHANNEL_6)

	wait_until(1657, 0x84)
	play_sound(0x0161, CHANNEL_6)

	wait_until(1679, 0x85)
	play_sound(0x0164, CHANNEL_6)

	wait_until(1683, 0x86)
	play_sound(0x0162, CHANNEL_6)

	wait_until(1692, 0x87)
	play_sound(0x0163, CHANNEL_6)

	wait_until(1716, 0x88)
	play_sound(0x0164, CHANNEL_6)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x56)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x56)
		label(0x2d)
	endloop(0x08)

	label(0x56)
	if_controller_button_pressed(/*goto*/ 0x56)
	camera_movement(0x01b7)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	if_stage_flag_eq(STAGEFLAG_PLAYING_INTRO_FROM_MENU, TRUE, /*goto*/ 0x2e)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	label(0x2e)
	chr_do_animation(0x01b8, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	goto_next(0x06)
	label(0x2d)
	chr_do_animation(0x01b8, -1, -1, 0x06, 0x00, CHR_NEGOTIATOR, 4)
	label(0x06)

	set_chr_chrflag(CHR_TAKER1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TAKER1, CHRHFLAG_00020000)
	chr_do_animation(0x01b9, -1, -1, 0x06, 0x00, CHR_TAKER1, 4)

	set_chr_chrflag(CHR_TAKER2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TAKER2, CHRHFLAG_00020000)
	chr_do_animation(0x01ba, -1, -1, 0x06, 0x00, CHR_TAKER2, 4)

	restart_timer

	wait_until(50, 0xaa)
	speak(CHR_BOND, L_ELD(41), 0x7401, CHANNEL_4, COLOR_09_BLUE) // "Hopefully our phoney negotiator ploy will give me ..."

	restart_timer
	wait_until(295, 0x89)
	play_sound(0x0179, CHANNEL_6)

	wait_until(302, 0x8a)
	play_sound(0x017a, CHANNEL_7)

	wait_until(333, 0x8b)
	play_sound(0x017b, CHANNEL_7)

	wait_until(338, 0x8c)
	play_sound(0x017a, CHANNEL_6)

	wait_until(344, 0x8d)
	play_sound(0x017c, CHANNEL_7)

	wait_until(353, 0x8e)
	play_sound(0x0179, CHANNEL_6)

	wait_until(372, 0x8f)
	play_sound(0x017a, CHANNEL_6)

	wait_until(412, 0x90)
	play_sound(0x017a, CHANNEL_6)

	wait_until(415, 0x91)
	play_sound(0x017b, CHANNEL_7)

	wait_until(466, 0x92)
	play_sound(0x0179, CHANNEL_6)

	wait_until(472, 0x93)
	play_sound(0x017c, CHANNEL_7)

	wait_until(515, 0x94)
	play_sound(0x017a, CHANNEL_6)

	wait_until(533, 0x95)
	play_sound(0x017b, CHANNEL_6)

	wait_until(535, 0x96)

	wait_until(561, 0x97)
	play_sound(0x017b, CHANNEL_6)

	wait_until(570, 0x98)
	play_sound(0x017c, CHANNEL_7)

	wait_until(572, 0x99)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x56)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x56)
		label(0x2d)
	endloop(0x09)

	label(0x56)
	if_stage_flag_eq(STAGEFLAG_PLAYING_INTRO_FROM_MENU, TRUE, /*goto*/ 0x4f)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x4e)
	goto_next(0x4f)
	label(0x4e)
	camera_movement(0x01bb)
	cmd0175(60)
	if_controller_button_pressed(/*goto*/ 0x56)

	set_chr_chrflag(CHR_NEGOTIATOR, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_NEGOTIATOR, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_NEGOTIATOR, CHRHFLAG_00020000)
	chr_do_animation(0x0001, -1, -1, 0x06, 0x00, CHR_NEGOTIATOR, 4)

	set_chr_chrflag(CHR_TAKER1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TAKER1, CHRHFLAG_00020000)
	chr_do_animation(0x0001, -1, -1, 0x06, 0x00, CHR_TAKER1, 4)

	set_chr_chrflag(CHR_TAKER2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_HIDDEN)
	chr_do_animation(0x0001, -1, -1, 0x06, 0x00, CHR_TAKER2, 4)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01bc, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	show_object(OBJ_DROPSHIP)
	set_object_flag2(OBJ_DROPSHIP, OBJFLAG2_04000000)
	set_object_flag3(OBJ_DROPSHIP, OBJFLAG3_00000010)
	object_do_animation(0x01bd, OBJ_DROPSHIP, 0x04, 0xffff)

	restart_timer

	wait_until(238, 0x9e)
	play_sound(0x046e, CHANNEL_6)

	wait_until(305, 0x9f)
	play_sound(0x046f, CHANNEL_6)

	wait_until(313, 0xa0)
	play_sound(0x04ae, CHANNEL_7)

	wait_until(350, 0xa1)
	play_sound(0x0085, CHANNEL_6)

	wait_until(380, 0xa2)
	play_sound(0x0161, CHANNEL_6)

	wait_until(381, 0xa3)
	play_sound(0x0162, CHANNEL_7)

	wait_until(400, 0xa4)
	play_sound(0x0163, CHANNEL_6)

	wait_until(429, 0xa5)
	play_sound(0x0164, CHANNEL_6)

	beginloop(0x0a)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x56)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x56)
		label(0x2d)
	endloop(0x0a)

	label(0x56)
	set_stage_flag(STAGEFLAG_INTRO_FINISHED)
	label(0x06)
	mute_channel(CHANNEL_0)
	mute_channel(CHANNEL_1)
	mute_channel(CHANNEL_2)
	mute_channel(CHANNEL_3)
	mute_channel(CHANNEL_4)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)

	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01bc, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	unset_chr_chrflag(CHR_NEGOTIATOR, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_NEGOTIATOR, CHRHFLAG_00020000)
	chr_do_animation(0x01b8, -2, -1, 0x06, 0x00, CHR_NEGOTIATOR, 2)

	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_TAKER1, CHRHFLAG_00020000)
	chr_do_animation(0x01b9, -2, -1, 0x06, 0x00, CHR_TAKER1, 2)

	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_TAKER2, CHRHFLAG_00020000)
	chr_do_animation(0x01ba, -2, -1, 0x06, 0x00, CHR_TAKER2, 2)

	hide_object(OBJ_DROPSHIP)
	restart_default_music
	reset_ambience
	play_x_music(CHANNEL_10, 30)
	unset_stage_flag(STAGEFLAG_PLAYING_INTRO_FROM_MENU)
	enter_firstperson
	yield
	chr_do_animation(0x0001, -1, -1, 0x02, 0x00, CHR_NEGOTIATOR, 2)
	chr_do_animation(0x0001, -1, -1, 0x02, 0x00, CHR_TAKER1, 2)
	chr_do_animation(0x0001, -1, -1, 0x02, 0x00, CHR_TAKER2, 2)
	set_ailist(CHR_TAKER1, AILIST_INIT_TAKER)
	set_ailist(CHR_TAKER2, AILIST_INIT_TAKER)
	set_ailist(CHR_NEGOTIATOR, AILIST_NEGOTIATOR)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x4f)
	camera_movement(0x01be)
	cmd0175(60)
	hide_object(OBJ_DROPSHIP)
	if_controller_button_pressed(/*goto*/ 0x56)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01bf, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(CHR_TAKER1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TAKER1, CHRHFLAG_00020000)
	chr_do_animation(0x01c0, -1, -1, 0x06, 0x00, CHR_TAKER1, 4)
	set_chr_chrflag(CHR_TAKER2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TAKER2, CHRHFLAG_00020000)
	chr_do_animation(0x01c1, -1, -1, 0x06, 0x00, CHR_TAKER2, 4)
	restart_timer
	label(0xa6)
	yield
	if_controller_button_pressed(/*goto*/ 0x56)
	if_timer_gt(17, /*goto*/ 0x06)
	goto_first(0xa6)

	label(0x06)
	play_sound(0x0179, CHANNEL_6)
	label(0xa7)
	yield
	if_controller_button_pressed(/*goto*/ 0x56)
	if_timer_gt(60, /*goto*/ 0x06)
	goto_first(0xa7)

	label(0x06)
	play_sound(0x017a, CHANNEL_6)
	label(0xa8)
	yield
	if_controller_button_pressed(/*goto*/ 0x56)
	if_timer_gt(96, /*goto*/ 0x06)
	goto_first(0xa8)

	label(0x06)
	play_sound(0x017b, CHANNEL_6)
	label(0xa9)
	yield
	if_controller_button_pressed(/*goto*/ 0x56)
	if_timer_gt(144, /*goto*/ 0x06)
	goto_first(0xa9)

	label(0x06)
	play_sound(0x017c, CHANNEL_6)
	label(0x0b)
	yield
	if_camera_animating(/*goto*/ 0x2d)
	goto_next(0x56)
	label(0x2d)
	if_controller_button_pressed(/*goto*/ 0x56)
	label(0x2d)
	goto_first(0x0b)

	label(0x56)
	set_stage_flag(STAGEFLAG_INTRO_FINISHED)
	label(0x06)
	mute_channel(CHANNEL_0)
	mute_channel(CHANNEL_1)
	mute_channel(CHANNEL_2)
	mute_channel(CHANNEL_3)
	mute_channel(CHANNEL_4)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01bf, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_TAKER1, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_TAKER1, CHRCFLAG_00000001)
	chr_do_animation(0x01c0, -2, -1, 0x06, 0x00, CHR_TAKER1, 2)
	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_TAKER2, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_TAKER2, CHRCFLAG_00000001)
	chr_do_animation(0x01c1, -2, -1, 0x06, 0x00, CHR_TAKER2, 2)
	hide_object(OBJ_DROPSHIP)
	restart_default_music
	reset_ambience
	play_x_music(CHANNEL_10, 30)
	enter_firstperson
	yield
	set_ailist(CHR_TAKER1, AILIST_TAKER)
	set_ailist(CHR_TAKER2, AILIST_TAKER)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c02_outro_from_menu[] = {
	set_ailist(CHR_CARRINGTON, GAILIST_IDLE)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func0408_outro[] = {
	camera_movement(0x017a)
	set_music_track(MUSIC_VILLA_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_UNEXPLODABLE)

	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x017c, -1, -1, 0x06, 0x00, CHR_P1P2, 4)

	set_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_CARRINGTON, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_CARRINGTON, CHRHFLAG_00020000)
	chr_do_animation(0x017b, -1, -1, 0x06, 0x00, CHR_CARRINGTON, 4)

	show_nonessential_chrs(FALSE)
	restart_timer
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)

	#define outro_wait_until1(time, msg, loopid) \
		beginloop(loopid) \
			dprint msg, '\n', 0, \
			if_controller_button_pressed(/*goto*/ 0x56) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)

	#define outro_wait_until2(time, msg1, msg2, loopid) \
		beginloop(loopid) \
			dprint msg1, msg2, '\n', 0, \
			if_controller_button_pressed(/*goto*/ 0x56) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)

	outro_wait_until1(14, '1', 0x66)
	play_sound(0x80d0, CHANNEL_7)

	outro_wait_until1(36, '2', 0x67)
	play_sound(0x80d1, CHANNEL_6)

	outro_wait_until1(40, '3', 0x68)
	speak(CHR_P1P2, L_ELD(42), 0x7402, CHANNEL_4, COLOR_09_BLUE) // "Sir? Are you injured?"

	outro_wait_until1(58, '4', 0xad)
	play_sound(0x80d2, CHANNEL_7)

	outro_wait_until1(80, '5', 0x69)
	play_sound(0x80d3, CHANNEL_7)

	outro_wait_until1(102, '6', 0x6a)
	play_sound(0x80d0, CHANNEL_7)

	outro_wait_until1(142, '7', 0x6b)
	play_sound(0x80d1, CHANNEL_7)

	outro_wait_until1(164, '8', 0x6c)
	play_sound(0x80cc, CHANNEL_7)

	outro_wait_until1(165, '9', 0xae)
	speak(CHR_P1P2, L_ELD(43), 0x7403, CHANNEL_4, COLOR_05_GREEN) // "No, Joanna, I'm okay, but those dataDyne thugs mad..."

	outro_wait_until2(195, '1','0', 0x6d)
	play_sound(0x80cd, CHANNEL_7)

	outro_wait_until2(213, '1','1', 0x6e)
	play_sound(0x80ce, CHANNEL_7)

	outro_wait_until2(231, '1','2', 0x6f)
	play_sound(0x80cf, CHANNEL_7)

	outro_wait_until2(235, '1','3', 0x70)
	play_sound(0x80cc, CHANNEL_7)

	// @bug: No check for button presses for about 8 seconds while Carrington is
	// saying the above line.
	beginloop(0xaf)
		dprint '1','4','\n',0,
		if_timer_gt(738, /*goto*/ 0x06)
	endloop(0xaf)

	label(0x06)
	speak(CHR_P1P2, L_ELD(44), 0x7404, CHANNEL_4, COLOR_09_BLUE) // "It's not your fault, sir. I should have been quick..."

	outro_wait_until2(956, '1','5', 0xb0)
	speak(CHR_P1P2, L_ELD(45), 0x7405, CHANNEL_4, COLOR_05_GREEN) // "Don't blame yourself, Joanna. Dr. Caroll told me t..."

	outro_wait_until2(2280, '2','2', 0xb1)
	speak(CHR_P1P2, L_ELD(46), 0x7406, CHANNEL_4, COLOR_09_BLUE) // "That won't be a problem, sir. So, did Dr. Caroll h..."

	outro_wait_until2(2457, '1','6', 0x71)
	play_sound(0x80cc, CHANNEL_7)

	outro_wait_until2(2496, '1','7', 0x72)
	play_sound(0x80cd, CHANNEL_7)

	outro_wait_until2(2620, '2','6', 0x7a)
	speak(CHR_P1P2, L_ELD(47), 0x7407, CHANNEL_5, COLOR_05_GREEN) // "Oh, yes, indeed. He certainly did, and I'll brief ..."

	outro_wait_until2(2730, '1','8', 0x73)
	play_sound(0x80ce, CHANNEL_7)

	outro_wait_until2(2808, '1','9', 0x74)
	play_sound(0x80cf, CHANNEL_7)

	outro_wait_until2(2861, '2','0', 0x75)
	play_sound(0x80cc, CHANNEL_7)

	outro_wait_until2(3030, '2','1', 0x76)
	play_sound(0x80d1, CHANNEL_7)

	outro_wait_until2(3098, '2','3', 0x77)
	play_sound(0x80cd, CHANNEL_7)

	outro_wait_until2(3194, '2','4', 0x78)
	play_sound(0x80ce, CHANNEL_7)

	outro_wait_until2(3276, '2','5', 0x79)
	play_sound(0x80cf, CHANNEL_7)

	outro_wait_until2(3370, '2','7', 0x7b)
	play_sound(0x80cc, CHANNEL_7)

	outro_wait_until2(3463, '2','8', 0x7c)
	play_sound(0x80cd, CHANNEL_7)

	outro_wait_until2(3503, '2','9', 0x7d)
	play_sound(0x80ce, CHANNEL_7)

	outro_wait_until2(3545, '3','0', 0x7e)
	play_sound(0x80cf, CHANNEL_7)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x56)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x56)
		label(0x2d)
	endloop(0x08)

	label(0x56)
	label(0x06)
	dprint '3','2','\n',0,
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_5)
	restart_default_music
	reset_ambience
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1003_give_items[] = {
	yield
	yield
	yield
	yield
	label(0x04)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)

	// PA
	give_object_to_chr(0x01, CHR_BOND)
	give_object_to_chr(0x89, CHR_COOP)
	chr_draw_weapon(CHR_BOND, WEAPON_UNARMED)
	chr_draw_weapon(CHR_COOP, WEAPON_UNARMED)
	hide_object(0x02)
	hide_object(0x8a)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// A and SA
	label(0x06)
	give_object_to_chr(0x02, CHR_BOND)
	give_object_to_chr(0x8a, CHR_COOP)
	chr_draw_weapon(CHR_BOND, WEAPON_SNIPERRIFLE)
	chr_draw_weapon(CHR_COOP, WEAPON_SNIPERRIFLE)
	hide_object(0x01)
	hide_object(0x89)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Velvet doesn't exist
	label(0x08)
	hide_object(0x8a)
	hide_object(0x89)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_check_negotiator[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x04)
	goto_next(0x2d)

	// A and SA
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_NEGOTIATOR_ESCAPED, TRUE, /*goto*/ 0x2d)
		if_chr_dying(CHR_NEGOTIATOR, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	show_hudmsg(CHR_BOND, L_ELD(11)) // "Negotiator has been killed."
	set_stage_flag(STAGEFLAG_NEGOTIATOR_DEAD)

	// PA
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0401_init_taker[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	if_difficulty_gt(DIFF_SA, /*goto*/ 0x2d)
	unset_self_flag_bankx(CHRFLAG0_80000000, BANK_0)
	label(0x2d)
	set_ailist(CHR_SELF, AILIST_TAKER)
	endlist
};

u8 func0402_taker[] = {
	set_self_chrflag(CHRCFLAG_00000040)
	yield
	yield
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)

	// PA
	set_shotlist(GAILIST_ALERTED)
	goto_next(0x06)

	// A and SA
	label(0x2d)
	set_shotlist(AILIST_TAKER)

	// All difficulties
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x61)
	goto_next(0x03)

	// Wait for injury recovery
	beginloop(0x61)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x61)

	// Injury recovered
	label(0x2d)
	goto_next(0x6f)

	label(0x03)
		if_difficulty_gt(DIFF_SA, /*goto*/ 0x2d)
		if_self_flag_bankx_eq(CHRFLAG0_04000000, TRUE, BANK_0, /*goto*/ 0x6f)
		set_self_flag_bankx(CHRFLAG0_04000000, BANK_0)
		label(0x2d)
		restart_timer
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x63)

		label(0x60)
		if_self_flag_bankx_eq(CHRFLAG0_NOHEAR, TRUE, BANK_0, /*goto*/ 0x06)
		set_target_chr(CHR_COOP)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x06)
		goto_next(0x03)
		label(0x06)
		set_target_chr(CHR_BOND)
		label(0x03)
		try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x05)

		beginloop(0x05)
			if_distance_to_target_gt(1000, /*goto*/ 0x2e)
			if_distance_to_target_lt(300, /*goto*/ 0x06)
			if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
			if_chr_weapon_equipped(CHR_BOND, WEAPON_LAPTOPGUN, /*goto*/ 0x0b)
			label(0x2d)
			if_timer_gt(600, /*goto*/ 0x06)
		endloop(0x05)

		// Jo got away
		label(0x2e)
		set_returnlist(CHR_SELF, GAILIST_ALERTED)
		set_ailist(CHR_SELF, GAILIST_ALERTED)

		// Jo got too close
		label(0x06)
		set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x09)
		label(0x09)
		yield
		if_chr_stopped(/*goto*/ 0x06)
		goto_first(0x09)

		label(0x06)
	goto_first(0x03)

	// Laptop gun equipped
	label(0x0b)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	say_quip(CHR_BOND, 0x12, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	restart_timer
	chr_do_animation(0x0202, 0, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x5f)
		if_timer_gt(180, /*goto*/ 0x5e)
	endloop(0x5f)

	label(0x5e)
	goto_first(0x60)

	label(0x63)
	restart_timer
	set_target_chr(CHR_NEGOTIATOR)
	label(0x03)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x04)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		dprint 'A','I','M','I','N','G',' ','A','T',' ','M','E','\n',0,
		if_chr_distance_to_pad_lt(CHR_P1P2, 200, 0x0236, /*goto*/ 0x06)
		label(0x2d)
		if_self_flag_bankx_eq(CHRFLAG0_00200000, TRUE, BANK_0, /*goto*/ 0x06)
		set_target_chr(CHR_NEGOTIATOR)
		if_chr_death_animation_finished(CHR_NEGOTIATOR, /*goto*/ 0x10)
		if_chr_dying(CHR_NEGOTIATOR, /*goto*/ 0x10)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
		if_timer_gt(600, /*goto*/ 0x06)
		reloop(0x04)

		label(0x2d)
		if_timer_gt(900, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_chr_flag_bankx(CHR_TAKER1, CHRFLAG0_00200000, BANK_0)
	set_chr_flag_bankx(CHR_TAKER2, CHRFLAG0_00200000, BANK_0)
	restart_timer

	beginloop(0x0c)
		if_chr_death_animation_finished(CHR_NEGOTIATOR, /*goto*/ 0x10)
		if_chr_dying(CHR_NEGOTIATOR, /*goto*/ 0x10)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
		if_timer_gt(600, /*goto*/ 0x06)
		reloop(0x0c)

		label(0x2d)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x0c)

	// Shoot
	label(0x6f)
	label(0x06)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x08)

	beginloop(0x08)
		if_chr_death_animation_finished(CHR_NEGOTIATOR, /*goto*/ 0x06)
		if_chr_dying(CHR_NEGOTIATOR, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	if_chr_death_animation_finished(CHR_NEGOTIATOR, /*goto*/ 0x10)
	if_chr_dying(CHR_NEGOTIATOR, /*goto*/ 0x10)
	goto_first(0x03)

	label(0x10)
	try_walk_to_target(/*goto*/ 0x0d)

	beginloop(0x0d)
		if_self_flag_bankx_eq(CHRFLAG0_NOHEAR, FALSE, BANK_0, /*goto*/ 0x06)
		if_distance_to_target_lt(200, /*goto*/ 0x2d)
		reloop(0x0d)

		label(0x06)
		if_distance_to_target_lt(200, /*goto*/ 0x2d)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x0d)

	label(0x2d)
	if_self_flag_bankx_eq(CHRFLAG0_NOHEAR, TRUE, BANK_0, /*goto*/ 0x06)
	chr_do_animation(0x01fd, 0, -1, 0x00, 0x0a, CHR_SELF, 2)
	goto_next(0x0e)
	label(0x06)
	chr_do_animation(0x0232, 0, -1, 0x00, 0x0a, CHR_SELF, 2)

	beginloop(0x0e)
		if_saw_injury(0x00, /*goto*/ 0x2e)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x0e)

	label(0x2d)
	if_self_flag_bankx_eq(CHRFLAG0_NOHEAR, TRUE, BANK_0, /*goto*/ 0x2d)
	walk_to_pad(0x004f)
	goto_next(0x11)
	label(0x2d)
	walk_to_pad(0x004f)

	beginloop(0x11)
		if_saw_injury(0x00, /*goto*/ 0x2e)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x11)

	label(0x2d)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2e)
	stop_chr
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_check_takers_dead[] = {
	beginloop(0x04)
		if_chr_dying(CHR_TAKER1, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_TAKER1, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_TAKER1, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_TAKER2, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_TAKER2, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_TAKER2, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	set_stage_flag(STAGEFLAG_TAKERS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0403_negotiator[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	stop_chr

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_TAKERS_DEAD, TRUE, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	run_to_pad(0x004f)

	beginloop(0x08)
		dprint 'R','U','N',' ','T','O',' ','P','A','D','\n',0,
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	show_hudmsg(CHR_BOND, L_ELD(13)) // "Negotiator has escaped to safety."
	set_stage_flag(STAGEFLAG_NEGOTIATOR_ESCAPED)
	stop_music_channel(CHANNEL_1)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_toggle_snipers[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	goto_next(0x2e)

	// A and SA
	label(0x2d)
	hide_chr(CHR_SNIPER1)
	hide_chr(CHR_SNIPER2)
	hide_chr(CHR_SNIPER3)
	hide_chr(CHR_SNIPER4)
	hide_chr(CHR_SNIPER5)
	hide_chr(CHR_SNIPER6)
	hide_chr(CHR_SNIPER7)
	hide_chr(CHR_SNIPER8)

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x002b, /*goto*/ 0x06)
	endloop(0x08)

	// PA
	label(0x2e)
	hide_chr(CHR_SNIPER1)
	hide_chr(CHR_SNIPER2)
	hide_chr(CHR_SNIPER3)
	hide_chr(CHR_SNIPER4)
	hide_chr(CHR_SNIPER6)
	hide_chr(CHR_SNIPER7)
	set_ailist(CHR_SNIPER5, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER8, AILIST_ENABLE_SNIPER)

	// Room 0x004e is the dock, ramp, and wooden floor at the top of the ramp.
	// @bug: When using small characters or play as Elvis cheats, the height
	// criteria is not met so the snipers cannot be unhidden. Fixed in PAL.
	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
#if VERSION >= VERSION_PAL_FINAL
		if_chr_y(CHR_P1P2, -550, OPERATOR_LESS_THAN, /*goto*/ 0x2d)
#else
		if_chr_y(CHR_P1P2, -500, OPERATOR_LESS_THAN, /*goto*/ 0x2d)
#endif
		if_chr_in_room(CHR_P1P2, 0x00, 0x004e, /*goto*/ 0x06)
		label(0x2d)
	endloop(0x09)

	// All difficulties
	label(0x06)
	show_chr(CHR_SNIPER1)
	yield
	show_chr(CHR_SNIPER2)
	yield
	show_chr(CHR_SNIPER3)
	yield
	show_chr(CHR_SNIPER4)
	yield
	show_chr(CHR_SNIPER6)
	yield
	show_chr(CHR_SNIPER7)
	yield
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	goto_next(0x06)

	// A and SA
	label(0x2d)
	yield
	show_chr(CHR_SNIPER5)
	yield
	show_chr(CHR_SNIPER8)
	rebuild_teams
	rebuild_squadrons

	// All difficulties
	label(0x06)
	set_ailist(CHR_SNIPER1, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER2, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER3, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER4, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER5, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER6, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER7, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SNIPER8, AILIST_ENABLE_SNIPER)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0404_sniper[] = {
	stop_chr
	set_shotlist(AILIST_SNIPER)
	set_target_chr(CHR_BOND)
	if_chr_dying(CHR_SELF, /*goto*/ 0x64)
	if_self_flag_bankx_eq(CHRFLAG0_08000000, TRUE, BANK_0, /*goto*/ 0x04)

	beginloop(0x60)
		if_near_miss(/*goto*/ 0x04)
		if_stage_flag_eq(STAGEFLAG_TAKERS_DEAD, TRUE, /*goto*/ 0x2d)
	endloop(0x60)

	label(0x2d)
	restart_timer

	beginloop(0x11)
		if_near_miss(/*goto*/ 0x04)
		if_chr_in_view(/*goto*/ 0x04)
		if_timer_gt(300, /*goto*/ 0x04)
	endloop(0x11)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		dprint 'S','T','A','R','T','\n',0,
		if_target_in_sight(/*goto*/ 0x58)

		// Choose a direction to face
		call_rng
		if_rand_lt(64, /*goto*/ 0x59)
		if_rand_lt(128, /*goto*/ 0x5a)
		if_rand_lt(196, /*goto*/ 0x5b)
		try_face_entity(ENTITYTYPE_DIRECTION, 0x0000, /*goto*/ 0x06)
		reloop(0x04)

		label(0x59)
		try_face_entity(ENTITYTYPE_DIRECTION, 0x4000, /*goto*/ 0x06)
		reloop(0x04)

		label(0x5a)
		try_face_entity(ENTITYTYPE_DIRECTION, 0x8000, /*goto*/ 0x06)
		reloop(0x04)

		label(0x5b)
		try_face_entity(ENTITYTYPE_DIRECTION, 0xc000, /*goto*/ 0x06)
		reloop(0x04)

		// Not actually running to a pad. Just waiting 2 seconds for the change
		// in direction, or until detected player.
		label(0x06)
		dprint 'R','U','N',' ','T','O',' ','P','A','D','\n',0,
		restart_timer

		beginloop(0x0a)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_target_in_sight(/*goto*/ 0x58)
			if_saw_death(0x00, /*goto*/ 0x58)
			if_saw_injury(0x00, /*goto*/ 0x58)
			dprint 'F','A','C','E','\n',0,
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0a)

		// 2 seconds passed
		label(0x06)
		restart_timer

		label(0x10)
			// 4 in 255 chance of looking around,
			// and the animation used is random too.
			call_rng
			if_rand_gt(3, /*goto*/ 0x0b)
			call_rng
			if_rand_lt(64, /*goto*/ 0x59)
			if_rand_lt(128, /*goto*/ 0x5a)
			if_rand_lt(196, /*goto*/ 0x5b)
			chr_do_animation(ANIM_LOOK_AROUND_025B, 0, -1, 0x50, 0x0a, CHR_SELF, 2)
			goto_next(0x0b)
			label(0x59)
			chr_do_animation(ANIM_LOOK_AROUND_025C, 0, -1, 0x50, 0x0a, CHR_SELF, 2)
			goto_next(0x0b)
			label(0x5a)
			chr_do_animation(ANIM_LOOK_AROUND_025D, 0, -1, 0x50, 0x0a, CHR_SELF, 2)
			goto_next(0x0b)
			label(0x5b)
			chr_do_animation(ANIM_LOOK_AROUND_025E, 0, -1, 0x50, 0x0a, CHR_SELF, 2)

			label(0x0b)
			yield
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_target_in_sight(/*goto*/ 0x58)
			if_saw_death(0x00, /*goto*/ 0x58)
			if_saw_injury(0x00, /*goto*/ 0x58)
			dprint 'R','U','N','\n',0,
			call_rng
			if_rand_gt(3, /*goto*/ 0x2d)
			if_timer_gt(600, /*goto*/ 0x06)
			label(0x2d)
			if_chr_idle(/*goto*/ 0x2d)
		goto_first(0x10)

		label(0x2d)
		goto_first(0x0b)

		label(0x06)
		goto_first(0x04)

		// Detected player
		label(0x58)
		if_in_disarm_range(/*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		restart_timer
		label(0x06)
		try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x08)
		reloop(0x04)

		label(0x08)
		yield
		label(0x06)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x09)
		reloop(0x04)

		beginloop(0x09)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
	endloop(0x04)

	label(0x64)
	dprint 'S','N','I','P','E',' ','D','I','E','\n',0,
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1006_check_snipers_dead[] = {
	beginloop(0x04)
		if_chr_dying(CHR_SNIPER1, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER1, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_SNIPER2, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER2, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_SNIPER3, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER3, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_SNIPER4, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER4, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_SNIPER5, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER5, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_SNIPER6, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER6, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_SNIPER7, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER7, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_SNIPER8, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_SNIPER8, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_ELD(12)) // "Snipers have been eliminated."
	set_stage_flag(STAGEFLAG_SNIPERS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_cooling_switch[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_COOLING_SWITCH, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_COOLING_SWITCH, TRUE)
		if_stage_flag_eq(STAGEFLAG_COOLING_ACTIVE, TRUE, /*goto*/ 0x06)
		show_hudmsg(CHR_P1P2, L_ELD(14)) // "Cooling systems have been activated."
		set_stage_flag(STAGEFLAG_COOLING_ACTIVE)
		assign_sound(0x8148, CHANNEL_1)
		control_sound_from_object(CHANNEL_1, OBJ_COOLING_SWITCH, TRUE)
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x08)

		label(0x2d)
		assign_sound(0x811c, CHANNEL_1)
		play_sound_from_object(CHANNEL_1, OBJ_COOLING_SWITCH, 0x04b0, 0x0640)
		reloop(0x04)

		label(0x06)
		mute_channel(CHANNEL_1)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_COOLING_SWITCH, TRUE)
		if_stage_flag_eq(STAGEFLAG_WINDMILL_ACTIVATED, FALSE, /*goto*/ 0x2d)
		show_hudmsg(CHR_P1P2, L_ELD(48)) // "Operation denied - windmill is active."
		goto_next(0x67)
		label(0x2d)
		assign_sound(0x8149, CHANNEL_1)
		control_sound_from_object(CHANNEL_1, OBJ_COOLING_SWITCH, TRUE)
		show_hudmsg(CHR_P1P2, L_ELD(15)) // "Cooling systems have been deactivated."
		unset_stage_flag(STAGEFLAG_COOLING_ACTIVE)
		label(0x67)
		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x09)

		label(0x2d)
	endloop(0x04)

	endlist
};

u8 func1008_power_switch[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_POWER_SWITCH, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_POWER_SWITCH, TRUE)
		if_stage_flag_eq(STAGEFLAG_POWER_ACTIVE, TRUE, /*goto*/ 0x06)
		show_hudmsg(CHR_P1P2, L_ELD(16)) // "Power systems have been activated."
		set_stage_flag(STAGEFLAG_POWER_ACTIVE)
		assign_sound(0x8148, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_POWER_SWITCH, TRUE)
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x08)

		label(0x2d)
		assign_sound(0x8146, CHANNEL_0)
		play_sound_from_object(CHANNEL_0, OBJ_POWER_SWITCH, 0x04b0, 0x0640)
		reloop(0x04)

		label(0x06)
		mute_channel(CHANNEL_0)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_POWER_SWITCH, TRUE)
		if_stage_flag_eq(STAGEFLAG_WINDMILL_ACTIVATED, FALSE, /*goto*/ 0x2d)
		show_hudmsg(CHR_P1P2, L_ELD(48)) // "Operation denied - windmill is active."
		goto_next(0x67)
		label(0x2d)
		assign_sound(0x8149, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_POWER_SWITCH, TRUE)
		show_hudmsg(CHR_P1P2, L_ELD(17)) // "Power systems have been deactivated."
		unset_stage_flag(STAGEFLAG_POWER_ACTIVE)
		label(0x67)
		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x09)

		label(0x2d)
	endloop(0x04)

	endlist
};

u8 func1009_windmill_switch[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_WINDMILL_SWITCH, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_COOLING_ACTIVE, FALSE, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_POWER_ACTIVE, FALSE, /*goto*/ 0x06)

		// Activating
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_WINDMILL_SWITCH, TRUE)
		assign_sound(0x8148, CHANNEL_2)
		control_sound_from_object(CHANNEL_2, OBJ_WINDMILL_SWITCH, TRUE)
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x08)

		label(0x2d)
		assign_sound(0x0438, CHANNEL_2)
		play_sound_from_object(CHANNEL_2, OBJ_WINDMILL_SWITCH, 0x0708, 0x0960)
		show_hudmsg(CHR_P1P2, L_ELD(18)) // "Windmill has been reactivated."
		yield
		set_stage_flag(STAGEFLAG_WINDMILL_ACTIVATED)
		set_object_flag2(OBJ_WINDMILL, OBJFLAG2_AICANNOTUSE)
		unlock_door(0x06, 0x02)
		unlock_door(0x07, 0x02)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Cooling and power not active
		label(0x06)
		assign_sound(0x043e, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_WINDMILL_SWITCH, TRUE)
		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x09)

		label(0x2d)
	endloop(0x04)

	endlist
};

u8 func100a_check_switches_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(0x03, /*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_COOLING_ACTIVE, TRUE, /*goto*/ 0x2d)
		show_hudmsg(CHR_BOND, L_ELD(21)) // "Critical mission object has been destroyed."
		set_stage_flag(STAGEFLAG_WINDMILL_SWITCH_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		if_object_in_good_condition(0x04, /*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_POWER_ACTIVE, TRUE, /*goto*/ 0x2d)
		show_hudmsg(CHR_BOND, L_ELD(21)) // "Critical mission object has been destroyed."
		set_stage_flag(STAGEFLAG_WINDMILL_SWITCH_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		if_object_in_good_condition(0x05, /*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_WINDMILL_ACTIVATED, TRUE, /*goto*/ 0x2d)
		show_hudmsg(CHR_BOND, L_ELD(21)) // "Critical mission object has been destroyed."
		set_stage_flag(STAGEFLAG_WINDMILL_SWITCH_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
	endloop(0x04)

	endlist
};

u8 func100b_invoke_hackers[] = {
	yield
	yield
	yield
	yield
	yield
	hide_chr(CHR_HACKER1)
	hide_chr(CHR_HACKER2)
	hide_chr(CHR_HACKER3)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	goto_next(0x04)

	// A or SA - exit
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// PA - wait for windmill
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_WINDMILL_ACTIVATED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	// Wait 10 seconds
	label(0x06)
	restart_timer

	beginloop(0x08)
		if_timer_gt(600, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	speak(CHR_BOND, L_ELD(22), 0x819f, CHANNEL_4, COLOR_05_GREEN) // "Joanna! It's Grimshaw. We've got hackers at the vi..."
	set_stage_flag(STAGEFLAG_HACKERS_STARTED)
	set_object_flag3(0x0b, OBJFLAG3_RTRACKED_YELLOW)
	set_object_flag3(0x0d, OBJFLAG3_RTRACKED_YELLOW)
	show_chr(CHR_HACKER1)
	yield
	show_chr(CHR_HACKER2)
	yield
	show_chr(CHR_HACKER3)
	yield
	set_ailist(CHR_HACKER1, AILIST_HACKER)
	set_ailist(CHR_HACKER2, AILIST_HACKER)
	set_ailist(CHR_HACKER3, AILIST_HACKER)
	unset_chr_chrflag(CHR_HACKER1, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_HACKER2, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_HACKER3, CHRCFLAG_HIDDEN)
	rebuild_teams
	rebuild_squadrons
	play_x_music(CHANNEL_10, 60)
	set_countdown_timer(60)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_HACKERS_DEAD, TRUE, /*goto*/ 0x2d)
		if_countdown_timer_lt(1, /*goto*/ 0x06)
	endloop(0x09)

	// Timer expired
	label(0x06)
	show_hudmsg(CHR_BOND, L_ELD(23)) // "Hackers have uploaded vital data."
	set_stage_flag(STAGEFLAG_HACKERS_SUCCEEDED)

	// Hackers dead
	label(0x2d)
	hide_countdown_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0406_init_hacker[] = {
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0405_hacker[] = {
	chr_do_animation(ANIM_SITTING_TYPING, 0, -1, 0x14, 0x00, CHR_SELF, 2)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_HACKERS_SUCCEEDED, TRUE, /*goto*/ 0x2d)
		if_chr_sees_player(/*goto*/ 0x09)
	endloop(0x04)

	// Hackers succeeded
	label(0x2d)
	run_to_pad(0x0070)

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x09)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	// Reached pad
	label(0x06)
	stop_chr
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Sees player
	label(0x09)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func100c_check_hackers_dead[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0d)

	beginloop(0x04)
		// Wait for hackers to start
		if_stage_flag_eq(STAGEFLAG_HACKERS_STARTED, TRUE, /*goto*/ 0x2d)
		reloop(0x04)

		// Wait until they're all dead
		label(0x2d)
		yield
		yield
		yield
		yield
		yield
		yield
		if_chr_dying(CHR_HACKER1, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_HACKER1, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_HACKER1, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_HACKER2, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_HACKER2, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_HACKER2, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_dying(CHR_HACKER3, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_HACKER3, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_HACKER3, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	if_stage_flag_eq(STAGEFLAG_HACKERS_SUCCEEDED, TRUE, /*goto*/ 0x2d)
	show_hudmsg(CHR_BOND, L_ELD(24)) // "Hackers have been eliminated."
	set_stage_flag(STAGEFLAG_HACKERS_DEAD)

	// Hackers succeeded
	label(0x2d)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_check_objectives_complete[] = {
	// @bug: This loop waits until the door is fully open, which allows the
	// player to enter the cellar while closing the door behind them and then
	// mess with Carrington.
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_door_state(0x09, DOORSTATE_OPEN, /*goto*/ 0x2d)
		if_door_state(0x08, DOORSTATE_OPEN, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_hudmsg(CHR_P1P2, L_ELD(25)) // "Carrington has been rescued."
	set_stage_flag(STAGEFLAG_CARRINGTON_RESCUED)
	yield
	yield
	set_invincible(CHR_BOND)
	revoke_control(CHR_BOND, 4)
	hide_countdown_timer
	stop_countdown_timer
	if_all_objectives_complete(/*goto*/ 0x5c)
	show_hudmsg(CHR_BOND, L_ELD(26)) // "All objectives not completed - mission failed."

	// If all objectives aren't complete, the player is shown the message, but
	// if the objective completes within the next 4 seconds you pass the level
	// anyway.
	label(0x2d)
	restart_timer

	beginloop(0x5d)
		if_timer_gt(280, /*goto*/ 0x5c)
	endloop(0x5d)

	label(0x5c)
	if_all_objectives_complete(/*goto*/ 0x2d)

	// Mission failed - objectives incomplete
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2d)
	goto_next(0x06)
	label(0x2d)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2d)
	goto_next(0x06)

	// Mission failed - players dead
	label(0x2d)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	if_chr_dying(CHR_CARRINGTON, /*goto*/ 0x2d)
	if_chr_death_animation_finished(CHR_CARRINGTON, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_CARRINGTON, /*goto*/ 0x2d)

	// Mission complete
	set_ailist(CHR_SELF, AILIST_OUTRO)

	// Carrington died... somehow
	label(0x2d)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_set_pa_negotiator_flag[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)
	set_stage_flag(STAGEFLAG_NEGOTIATOR_ESCAPED)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_setup_snipers[] = {
	set_chr_special_death_animation(CHR_SNIPER7, SPECIALDIE_1)
	set_chr_special_death_animation(CHR_SNIPER4, SPECIALDIE_2)
	set_chr_special_death_animation(CHR_SNIPER5, SPECIALDIE_3)
	set_chr_special_death_animation(CHR_SNIPER3, SPECIALDIE_4)
	set_chr_chrflag(CHR_SNIPER3, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_SNIPER4, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_SNIPER5, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_SNIPER7, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_SNIPER1, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_SNIPER2, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_SNIPER6, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_SNIPER8, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_check_guard_subdued[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)

	beginloop(0x04)
		if_num_subdued(0, OPERATOR_GREATER_THAN, /*goto*/ 0x06)
		if_self_flag_bankx_eq(CHRFLAG0_00100000, FALSE, BANK_0, /*goto*/ 0x66)
		unset_stage_flag(STAGEFLAG_GUARD_CAPTURED)
		label(0x66)
		reloop(0x04)

		// Captured someone
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_GUARD_CAPTURED, TRUE, /*goto*/ 0x2e)
		show_hudmsg(CHR_BOND, L_ELD(29)) // "Enemy guard has been subdued."
		label(0x2e)
		unset_stage_flag(STAGEFLAG_FORGOT_TO_KO_GUARD)
		yield
		set_stage_flag(STAGEFLAG_GUARD_CAPTURED)

		beginloop(0x67)
			if_num_subdued(1, OPERATOR_LESS_THAN, /*goto*/ 0x06)
		endloop(0x67)

		label(0x06)
		unset_stage_flag(STAGEFLAG_GUARD_CAPTURED)
	endloop(0x04)

	// A and SA
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_give_keycard[] = {
	set_chr_chrflag(CHR_BASEMENT1, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT2, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT3, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT4, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT5, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT6, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT7, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT8, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_BASEMENT9, CHRCFLAG_KILLCOUNTABLE)
	set_object_flag(OBJ_KEYCARD, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(OBJ_KEYCARD, OBJFLAG2_INVISIBLE)

	// Wait until one basement guard remaining
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ONE_BASEMENT_GUARD_REMAINING, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)

	#define give_keycard_if_alive(chr) \
		if_chr_death_animation_finished(chr, /*goto*/ 0x2d) \
		if_chr_dying(chr, /*goto*/ 0x2d) \
		if_chr_unloaded(chr, /*goto*/ 0x2d) \
		give_object_to_chr(OBJ_KEYCARD, chr) \
		goto_next(0x09) \
		label(0x2d)



	give_keycard_if_alive(CHR_BASEMENT1)
	give_keycard_if_alive(CHR_BASEMENT2)
	give_keycard_if_alive(CHR_BASEMENT3)
	give_keycard_if_alive(CHR_BASEMENT4)
	give_keycard_if_alive(CHR_BASEMENT5)
	give_keycard_if_alive(CHR_BASEMENT6)
	give_keycard_if_alive(CHR_BASEMENT7)
	give_keycard_if_alive(CHR_BASEMENT8)

	give_object_to_chr(OBJ_KEYCARD, CHR_BASEMENT9)
	goto_next(0x09)
	label(0x2d)

	// Gave key
	label(0x09)
	unset_object_flag(OBJ_KEYCARD, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_KEYCARD, OBJFLAG2_INVISIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_check_computers_destroyed[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x09)

	beginloop(0x04)
		if_object_in_good_condition(OBJ_HACKERPC1, /*goto*/ 0x2d)
		goto_next(0x08)
		label(0x2d)
		if_object_in_good_condition(OBJ_HACKERPC2, /*goto*/ 0x2d)
		goto_next(0x08)
		label(0x2d)
		if_object_in_good_condition(OBJ_HACKERPC3, /*goto*/ 0x2d)
		goto_next(0x08)
		label(0x2d)
		if_object_in_good_condition(OBJ_HACKERPC4, /*goto*/ 0x2d)
		goto_next(0x08)
		label(0x2d)
	endloop(0x04)

	label(0x08)
	show_hudmsg(CHR_BOND, L_ELD(21)) // "Critical mission object has been destroyed."
	set_stage_flag(STAGEFLAG_HACKER_PC_DESTROYED)
	label(0x09)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_guard(accuracy, reaction, health, recovery) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(accuracy) \
	set_reaction_speed(reaction) \
	set_chr_maxdamage(CHR_SELF, health) \
	add_health_or_armor(0) \
	set_recovery_speed(recovery) \
	set_shield(0)



u8 func040a_enable_sniper[] = {
	init_guard(13, 15, 10, 15)
	set_ailist(CHR_SELF, AILIST_SNIPER)
	endlist
};

u8 func040c_init_type1_guard[] = {
	init_guard(3, 15, 40, 0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func040d_init_type2_guard[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	init_guard(15, 15, 40, 0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	label(0x2d)
	init_guard(3, 15, 40, 0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func040b_init_basement_guard[] = {
	init_guard(13, 15, 40, 10)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1016_msg_generator[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0077, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_P1P2, L_ELD(35), 0x73ac, CHANNEL_6, COLOR_09_BLUE) // "If I get the wind generator back online, I'll get ..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_msg_gottobequick[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	restart_timer

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	speak(CHR_BOND, L_ELD(36), 0x73ad, CHANNEL_6, COLOR_09_BLUE) // "I've got to be quick, or they'll kill the negotiat..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_msg_hidingdaniel[] = {
	// Wait for windmill activated
	beginloop(0x04)
		if_objective_complete(2, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x08)
		if_objective_complete(3, /*goto*/ 0x08) // hackers objective
	endloop(0x04)

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0088, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	speak(CHR_P1P2, L_ELD(37), 0x73ae, CHANNEL_6, COLOR_09_BLUE) // "Here's where they must be holding Daniel."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1019_msg_hackershavetobestopped[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_HACKERS_STARTED, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_timer_gt(450, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	speak(CHR_BOND, L_ELD(38), 0x73af, CHANNEL_6, COLOR_09_BLUE) // "Those hackers have to be stopped before I rescue D..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040e_start_path00[] = {
	init_guard(3, 15, 40, 0)
	assign_path(0)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040f_start_path01[] = {
	init_guard(3, 15, 40, 0)
	assign_path(1)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func101b_toggle_basement_chrs[] = {
	yield
	yield
	hide_chr(CHR_BASEMENT1)
	hide_chr(CHR_BASEMENT2)
	hide_chr(CHR_BASEMENT3)
	hide_chr(CHR_BASEMENT4)
	hide_chr(CHR_BASEMENT5)
	hide_chr(CHR_BASEMENT6)
	hide_chr(CHR_BASEMENT7)
	hide_chr(CHR_BASEMENT8)
	hide_chr(CHR_CARRINGTON)

	// Not sure which room 0x0087 is
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0087, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_chr(CHR_BASEMENT1)
	yield
	show_chr(CHR_BASEMENT2)
	yield
	show_chr(CHR_BASEMENT3)
	yield
	show_chr(CHR_BASEMENT4)
	yield
	show_chr(CHR_BASEMENT5)
	yield
	show_chr(CHR_BASEMENT6)
	yield
	show_chr(CHR_BASEMENT7)
	yield
	show_chr(CHR_BASEMENT8)
	yield
	yield
	show_chr(CHR_CARRINGTON)
	yield
	rebuild_teams
	rebuild_squadrons

	// Every 5 frames, check if the wine bottles are destroyed.
	// There's a lot of stuff going on here without yielding. If you destroyed
	// all bottles except 0x88 then you might have a choppy experience.
	label(0x08)
	restart_timer

	beginloop(0x09)
		if_timer_gt(5, /*goto*/ 0x2d)
	goto_first(0x09)

	label(0x2d)
		if_object_in_good_condition(0x1e, /*goto*/ 0x06)
		if_object_in_good_condition(0x1f, /*goto*/ 0x06)
		if_object_in_good_condition(0x20, /*goto*/ 0x06)
		if_object_in_good_condition(0x21, /*goto*/ 0x06)
		if_object_in_good_condition(0x22, /*goto*/ 0x06)
		if_object_in_good_condition(0x23, /*goto*/ 0x06)
		if_object_in_good_condition(0x24, /*goto*/ 0x06)
		if_object_in_good_condition(0x25, /*goto*/ 0x06)
		if_object_in_good_condition(0x26, /*goto*/ 0x06)
		if_object_in_good_condition(0x27, /*goto*/ 0x06)
		if_object_in_good_condition(0x28, /*goto*/ 0x06)
		if_object_in_good_condition(0x29, /*goto*/ 0x06)
		if_object_in_good_condition(0x2a, /*goto*/ 0x06)
		if_object_in_good_condition(0x2b, /*goto*/ 0x06)
		if_object_in_good_condition(0x2c, /*goto*/ 0x06)
		if_object_in_good_condition(0x2d, /*goto*/ 0x06)
		if_object_in_good_condition(0x2e, /*goto*/ 0x06)
		if_object_in_good_condition(0x2f, /*goto*/ 0x06)
		if_object_in_good_condition(0x30, /*goto*/ 0x06)
		if_object_in_good_condition(0x31, /*goto*/ 0x06)
		if_object_in_good_condition(0x32, /*goto*/ 0x06)
		if_object_in_good_condition(0x33, /*goto*/ 0x06)
		if_object_in_good_condition(0x34, /*goto*/ 0x06)
		if_object_in_good_condition(0x35, /*goto*/ 0x06)
		if_object_in_good_condition(0x36, /*goto*/ 0x06)
		if_object_in_good_condition(0x37, /*goto*/ 0x06)
		if_object_in_good_condition(0x38, /*goto*/ 0x06)
		if_object_in_good_condition(0x39, /*goto*/ 0x06)
		if_object_in_good_condition(0x3a, /*goto*/ 0x06)
		if_object_in_good_condition(0x3b, /*goto*/ 0x06)
		if_object_in_good_condition(0x3c, /*goto*/ 0x06)
		if_object_in_good_condition(0x3d, /*goto*/ 0x06)
		if_object_in_good_condition(0x3e, /*goto*/ 0x06)
		if_object_in_good_condition(0x3f, /*goto*/ 0x06)
		if_object_in_good_condition(0x40, /*goto*/ 0x06)
		if_object_in_good_condition(0x41, /*goto*/ 0x06)
		if_object_in_good_condition(0x42, /*goto*/ 0x06)
		if_object_in_good_condition(0x43, /*goto*/ 0x06)
		if_object_in_good_condition(0x44, /*goto*/ 0x06)
		if_object_in_good_condition(0x45, /*goto*/ 0x06)
		if_object_in_good_condition(0x46, /*goto*/ 0x06)
		if_object_in_good_condition(0x47, /*goto*/ 0x06)
		if_object_in_good_condition(0x48, /*goto*/ 0x06)
		if_object_in_good_condition(0x49, /*goto*/ 0x06)
		if_object_in_good_condition(0x4a, /*goto*/ 0x06)
		if_object_in_good_condition(0x4b, /*goto*/ 0x06)
		if_object_in_good_condition(0x4c, /*goto*/ 0x06)
		if_object_in_good_condition(0x4d, /*goto*/ 0x06)
		if_object_in_good_condition(0x4e, /*goto*/ 0x06)
		if_object_in_good_condition(0x4f, /*goto*/ 0x06)
		if_object_in_good_condition(0x50, /*goto*/ 0x06)
		if_object_in_good_condition(0x51, /*goto*/ 0x06)
		if_object_in_good_condition(0x52, /*goto*/ 0x06)
		if_object_in_good_condition(0x53, /*goto*/ 0x06)
		if_object_in_good_condition(0x54, /*goto*/ 0x06)
		if_object_in_good_condition(0x55, /*goto*/ 0x06)
		if_object_in_good_condition(0x56, /*goto*/ 0x06)
		if_object_in_good_condition(0x57, /*goto*/ 0x06)
		if_object_in_good_condition(0x58, /*goto*/ 0x06)
		if_object_in_good_condition(0x59, /*goto*/ 0x06)
		if_object_in_good_condition(0x5a, /*goto*/ 0x06)
		if_object_in_good_condition(0x5b, /*goto*/ 0x06)
		if_object_in_good_condition(0x5c, /*goto*/ 0x06)
		if_object_in_good_condition(0x5d, /*goto*/ 0x06)
		if_object_in_good_condition(0x5e, /*goto*/ 0x06)
		if_object_in_good_condition(0x5f, /*goto*/ 0x06)
		if_object_in_good_condition(0x60, /*goto*/ 0x06)
		if_object_in_good_condition(0x61, /*goto*/ 0x06)
		if_object_in_good_condition(0x62, /*goto*/ 0x06)
		if_object_in_good_condition(0x63, /*goto*/ 0x06)
		if_object_in_good_condition(0x64, /*goto*/ 0x06)
		if_object_in_good_condition(0x65, /*goto*/ 0x06)
		if_object_in_good_condition(0x66, /*goto*/ 0x06)
		if_object_in_good_condition(0x67, /*goto*/ 0x06)
		if_object_in_good_condition(0x68, /*goto*/ 0x06)
		if_object_in_good_condition(0x69, /*goto*/ 0x06)
		if_object_in_good_condition(0x6a, /*goto*/ 0x06)
		if_object_in_good_condition(0x6b, /*goto*/ 0x06)
		if_object_in_good_condition(0x6c, /*goto*/ 0x06)
		if_object_in_good_condition(0x6d, /*goto*/ 0x06)
		if_object_in_good_condition(0x6e, /*goto*/ 0x06)
		if_object_in_good_condition(0x6f, /*goto*/ 0x06)
		if_object_in_good_condition(0x70, /*goto*/ 0x06)
		if_object_in_good_condition(0x71, /*goto*/ 0x06)
		if_object_in_good_condition(0x72, /*goto*/ 0x06)
		if_object_in_good_condition(0x73, /*goto*/ 0x06)
		if_object_in_good_condition(0x74, /*goto*/ 0x06)
		if_object_in_good_condition(0x75, /*goto*/ 0x06)
		if_object_in_good_condition(0x76, /*goto*/ 0x06)
		if_object_in_good_condition(0x77, /*goto*/ 0x06)
		if_object_in_good_condition(0x78, /*goto*/ 0x06)
		if_object_in_good_condition(0x79, /*goto*/ 0x06)
		if_object_in_good_condition(0x7a, /*goto*/ 0x06)
		if_object_in_good_condition(0x7b, /*goto*/ 0x06)
		if_object_in_good_condition(0x7c, /*goto*/ 0x06)
		if_object_in_good_condition(0x7d, /*goto*/ 0x06)
		if_object_in_good_condition(0x7e, /*goto*/ 0x06)
		if_object_in_good_condition(0x7f, /*goto*/ 0x06)
		if_object_in_good_condition(0x80, /*goto*/ 0x06)
		if_object_in_good_condition(0x81, /*goto*/ 0x06)
		if_object_in_good_condition(0x82, /*goto*/ 0x06)
		if_object_in_good_condition(0x83, /*goto*/ 0x06)
		if_object_in_good_condition(0x84, /*goto*/ 0x06)
		if_object_in_good_condition(0x85, /*goto*/ 0x06)
		if_object_in_good_condition(0x86, /*goto*/ 0x06)
		if_object_in_good_condition(0x87, /*goto*/ 0x06)
		if_object_in_good_condition(0x88, /*goto*/ 0x06)
		play_sound(0x17cb, -1)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x06)
	goto_first(0x08)

	endlist
};

/**
 * This function hides guards inside the villa on A and SA, then unhides them
 * once you approach the villa.
 */
u8 func101c_toggle_villa_guards[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// A and SA
	label(0x2d)
	hide_chr(0x23)
	hide_chr(0x24)
	hide_chr(0x25)
	hide_chr(0x26)
	hide_chr(0x27)
	hide_chr(0x28)
	hide_chr(0x29)
	hide_chr(0x2a)
	hide_chr(0x2b)
	hide_chr(0x2c)
	hide_chr(0x2d)
	hide_chr(0x2e)
	hide_chr(0x2f)
	hide_chr(0x30)
	hide_chr(0x31)
	hide_chr(0x32)
	hide_chr(0x33)
	hide_chr(0x34)
	hide_chr(0x35)
	hide_chr(0x36)
	hide_chr(0x37)
	hide_chr(0x38)
	hide_chr(0x39)
	hide_chr(0x3a)
	hide_chr(0x3b)
	hide_chr(0x3c)
	hide_chr(0x3d)
	hide_chr(0x3e)
	hide_chr(0x3f)
	hide_chr(0x40)
	hide_chr(0x41)
	hide_chr(0x42)

	// @bug: It is possible to cross room 0x002a in a single frame on coop if
	// hugging the corner tightly, which means the guards will not be unhidden.
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x002a, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_chr(0x23)
	yield
	show_chr(0x24)
	yield
	show_chr(0x25)
	yield
	show_chr(0x26)
	yield
	show_chr(0x27)
	yield
	show_chr(0x28)
	yield
	show_chr(0x29)
	yield
	show_chr(0x2a)
	yield
	show_chr(0x2b)
	yield
	show_chr(0x2c)
	yield
	show_chr(0x2d)
	yield
	show_chr(0x2e)
	yield
	show_chr(0x2f)
	yield
	show_chr(0x30)
	yield
	show_chr(0x31)
	yield
	show_chr(0x32)
	yield
	show_chr(0x33)
	yield
	show_chr(0x34)
	yield
	show_chr(0x35)
	yield
	show_chr(0x36)
	yield
	show_chr(0x37)
	yield
	show_chr(0x38)
	yield
	show_chr(0x39)
	yield
	show_chr(0x3a)
	yield
	show_chr(0x3b)
	yield
	show_chr(0x3c)
	yield
	show_chr(0x3d)
	yield
	show_chr(0x3e)
	yield
	show_chr(0x3f)
	yield
	show_chr(0x40)
	yield
	show_chr(0x41)
	yield
	show_chr(0x42)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_dual_cmp150[] = {
	// Probable @bug: This timer starts from the start of the intro cinema,
	// rather than from when you take control of Jo.
	yield
	restart_timer

	// Wait 38.3 seconds or for CMP150 sniper to die
	beginloop(0x04)
		if_chr_dying(CHR_SNIPER7, /*goto*/ 0x2d)
		if_timer_gt(2300, /*goto*/ 0x06)
	endloop(0x04)

	label(0x2d)
	pause_timer
	play_sound(L_ARCH(198), -1) // "My gun!"

	beginloop(0x08)
		if_chr_death_animation_finished(0x06, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	unset_object_flag(OBJ_CMP150_1, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag(OBJ_CMP150_2, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_CMP150_1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_CMP150_1, OBJFLAG2_INVISIBLE)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0407_init_sniper[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	stop_chr
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0410_carrington[] = {
	yield
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_chr_maxdamage(CHR_SELF, 1)
	chr_do_animation(0x017b, 1, 1, 0x06, 0x00, CHR_CARRINGTON, 2)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Unlock exterior doors on SA and PA.
 */
u8 func101e_unlock_doors[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
	unlock_door(0x90, 0x80)
	unlock_door(0x91, 0x80)
	unlock_door(0x92, 0x80)
	unlock_door(0x93, 0x80)
	unlock_door(0x94, 0x80)
	unlock_door(0x95, 0x80)
	unlock_door(0x96, 0x80)
	unlock_door(0x97, 0x80)
	unlock_door(0x98, 0x80)
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_check_one_basement_guard_remaining[] = {
	#define inc_var_if_chr_dead(chr) \
		if_chr_dying(chr, /*goto*/ 0x2d) \
		if_chr_death_animation_finished(chr, /*goto*/ 0x2d) \
		if_chr_unloaded(chr, /*goto*/ 0x2d) \
		goto_next(0x06) \
		label(0x2d) \
		add_morale(1) \
		label(0x06)



	beginloop(0x04)
		set_morale(0)

		inc_var_if_chr_dead(CHR_BASEMENT1)
		inc_var_if_chr_dead(CHR_BASEMENT2)
		inc_var_if_chr_dead(CHR_BASEMENT3)
		inc_var_if_chr_dead(CHR_BASEMENT4)
		inc_var_if_chr_dead(CHR_BASEMENT5)
		inc_var_if_chr_dead(CHR_BASEMENT6)
		inc_var_if_chr_dead(CHR_BASEMENT7)
		inc_var_if_chr_dead(CHR_BASEMENT8)
		inc_var_if_chr_dead(CHR_BASEMENT9)

		if_morale_lt(8, /*goto*/ 0x2d)
		set_stage_flag(STAGEFLAG_ONE_BASEMENT_GUARD_REMAINING)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2d)
	endloop(0x04)

	endlist
};

/**
 * Counterop only.
 */
u8 func1420_setup_portals[] = {
	yield
	configure_room_portals(0x0050)
	configure_room_portals(0x0052)
	configure_room_portals(0x006c)
	configure_room_portals(0x004d)
	configure_room_portals(0x0065)
	configure_room_portals(0x0059)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1423_setup_lighting[] = {
	yield
	misc_command(0x0027, 0x05, 0x01)
	misc_command(0x0027, 0x06, 0x01)
	misc_command(0x000c, 0x05, 0x01)
	misc_command(0x000c, 0x06, 0x01)
	misc_command(0x0029, 0x05, 0x01)
	misc_command(0x0035, 0x05, 0x01)
	misc_command(0x0035, 0x06, 0x01)
	misc_command(0x0036, 0x06, 0x01)
	misc_command(0x0037, 0x05, 0x01)
	misc_command(0x0037, 0x06, 0x01)
	misc_command(0x0038, 0x05, 0x01)
	misc_command(0x0038, 0x06, 0x01)
	misc_command(0x0039, 0x05, 0x01)
	misc_command(0x0039, 0x06, 0x01)
	misc_command(0x003a, 0x05, 0x01)
	misc_command(0x003a, 0x06, 0x01)
	misc_command(0x003b, 0x06, 0x01)
	misc_command(0x003c, 0x06, 0x01)
	misc_command(0x003d, 0x06, 0x01)
	misc_command(0x003e, 0x05, 0x01)
	misc_command(0x003e, 0x06, 0x01)
	misc_command(0x003f, 0x05, 0x01)
	misc_command(0x003f, 0x06, 0x01)
	misc_command(0x0040, 0x05, 0x01)
	misc_command(0x0040, 0x06, 0x01)
	misc_command(0x0041, 0x05, 0x01)
	misc_command(0x0043, 0x05, 0x01)
	misc_command(0x0044, 0x05, 0x01)
	misc_command(0x0045, 0x05, 0x01)
	misc_command(0x0046, 0x05, 0x01)
	misc_command(0x0046, 0x06, 0x01)
	misc_command(0x0047, 0x05, 0x01)
	misc_command(0x0048, 0x05, 0x01)
	misc_command(0x0048, 0x06, 0x01)
	misc_command(0x0049, 0x05, 0x01)
	misc_command(0x004a, 0x05, 0x01)
	misc_command(0x004b, 0x05, 0x01)
	misc_command(0x004b, 0x06, 0x01)
	misc_command(0x004c, 0x05, 0x01)
	misc_command(0x004c, 0x06, 0x01)
	misc_command(0x004e, 0x05, 0x01)
	misc_command(0x004e, 0x06, 0x01)
	misc_command(0x004f, 0x06, 0x01)
	misc_command(0x0050, 0x05, 0x01)
	misc_command(0x0050, 0x06, 0x01)
	misc_command(0x0051, 0x06, 0x01)
	misc_command(0x0053, 0x05, 0x01)
	misc_command(0x0053, 0x06, 0x01)
	misc_command(0x0054, 0x06, 0x01)
	misc_command(0x0056, 0x05, 0x01)
	misc_command(0x0056, 0x06, 0x01)
	misc_command(0x0057, 0x05, 0x01)
	misc_command(0x0059, 0x05, 0x01)
	misc_command(0x0059, 0x06, 0x01)
	misc_command(0x005a, 0x06, 0x01)
	misc_command(0x005b, 0x05, 0x01)
	misc_command(0x005b, 0x06, 0x01)
	misc_command(0x005c, 0x06, 0x01)
	misc_command(0x005d, 0x06, 0x01)
	misc_command(0x005e, 0x06, 0x01)
	misc_command(0x005f, 0x06, 0x01)
	misc_command(0x0060, 0x06, 0x01)
	misc_command(0x0061, 0x05, 0x01)
	misc_command(0x0061, 0x06, 0x01)
	misc_command(0x0062, 0x05, 0x01)
	misc_command(0x0062, 0x06, 0x01)
	misc_command(0x0063, 0x06, 0x01)
	misc_command(0x0064, 0x06, 0x01)
	misc_command(0x0065, 0x06, 0x01)
	misc_command(0x0066, 0x05, 0x01)
	misc_command(0x0066, 0x06, 0x01)
	misc_command(0x0068, 0x05, 0x01)
	misc_command(0x0068, 0x06, 0x01)
	misc_command(0x0069, 0x06, 0x01)
	misc_command(0x006a, 0x06, 0x01)
	misc_command(0x006b, 0x06, 0x01)
	misc_command(0x006c, 0x06, 0x01)
	misc_command(0x006d, 0x06, 0x01)
	misc_command(0x006e, 0x06, 0x01)
	misc_command(0x006f, 0x06, 0x01)
	misc_command(0x0070, 0x05, 0x01)
	misc_command(0x0070, 0x06, 0x01)
	misc_command(0x0071, 0x05, 0x01)
	misc_command(0x0071, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1021_toggle_last_basement_guard[] = {
	set_chr_chrflag(CHR_BASEMENT9, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BASEMENT9, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x04)
		if_difficulty_gt(DIFF_SA, /*goto*/ 0x2d)
		if_objective_complete(0, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
		if_objective_complete(1, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_objective_complete(2, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
		if_objective_complete(3, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
		if_objective_complete(4, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	unset_chr_chrflag(CHR_BASEMENT9, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BASEMENT9, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_CMP150_1, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_CMP150_2, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_DEVASTATOR, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0411_cisoldier[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	chr_drop_weapon(CHR_SELF)
	label(0x08)
	yield
	chr_do_animation(0x0487, -1, -1, 0x06, 0x00, CHR_CISOLDIER, 2)
	yield
	yield
	yield
	kill(CHR_CISOLDIER)
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This should be investigated more.
 */
u8 func1024_set_chr_flags_on_pa[] = {
	yield
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
	set_chr_hiddenflag(CHR_TAKER1, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x0a, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x23, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x2f, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x34, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x37, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x3e, CHRHFLAG_08000000)
	set_chr_hiddenflag(CHR_BASEMENT6, CHRHFLAG_08000000)
	set_chr_hiddenflag(CHR_BASEMENT8, CHRHFLAG_08000000)
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1025_check_basement_entered_without_subdue[] = {
	yield
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0d)

	beginloop(0x04)
		if_objective_complete(4, /*goto*/ 0x0c)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0087, /*goto*/ 0x06)
		label(0x0c)
	endloop(0x04)

	label(0x06)
	show_hudmsg(CHR_P1P2, L_ELD(49)) // "Mission unsuccessful - enemy guard not captured."
	set_stage_flag(STAGEFLAG_FORGOT_TO_KO_GUARD)

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func1400_setup_counterop,                       0x1400 },
	{ func1001_objectives_failed_msg,                 0x1001 },
	{ func1002_intro,                                 0x1002 },
	{ func1003_give_items,                            0x1003 },
	{ func1004_check_negotiator,                      0x1004 },
	{ func1005_toggle_snipers,                        0x1005 },
	{ func1006_check_snipers_dead,                    0x1006 },
	{ func1007_cooling_switch,                        0x1007 },
	{ func1008_power_switch,                          0x1008 },
	{ func1009_windmill_switch,                       0x1009 },
	{ func100a_check_switches_destroyed,              0x100a },
	{ func100b_invoke_hackers,                        0x100b },
	{ func100c_check_hackers_dead,                    0x100c },
	{ func100e_check_objectives_complete,             0x100e },
	{ func100f_check_takers_dead,                     0x100f },
	{ func1010_set_pa_negotiator_flag,                0x1010 },
	{ func1011_setup_snipers,                         0x1011 },
	{ func1013_check_guard_subdued,                   0x1013 },
	{ func1014_give_keycard,                          0x1014 },
	{ func1015_check_computers_destroyed,             0x1015 },
	{ func1016_msg_generator,                         0x1016 },
	{ func1017_msg_gottobequick,                      0x1017 },
	{ func1018_msg_hidingdaniel,                      0x1018 },
	{ func1019_msg_hackershavetobestopped,            0x1019 },
	{ func101b_toggle_basement_chrs,                  0x101b },
	{ func101c_toggle_villa_guards,                   0x101c },
	{ func101d_dual_cmp150,                           0x101d },
	{ func101e_unlock_doors,                          0x101e },
	{ func101f_check_one_basement_guard_remaining,    0x101f },
	{ func1420_setup_portals,                         0x1420 },
	{ func1021_toggle_last_basement_guard,            0x1021 },
	{ func1022_setup_rtracker,                        0x1022 },
	{ func1423_setup_lighting,                        0x1423 },
	{ func1024_set_chr_flags_on_pa,                   0x1024 },
	{ func1025_check_basement_entered_without_subdue, 0x1025 },
	{ func1002_intro,                                 0x0c00 },
	{ func1002_intro_from_menu,                       0x0c01 },
	{ func0c02_outro_from_menu,                       0x0c02 },
	{ func0401_init_taker,                            0x0401 },
	{ func0402_taker,                                 0x0402 },
	{ func0403_negotiator,                            0x0403 },
	{ func0404_sniper,                                0x0404 },
	{ func0405_hacker,                                0x0405 },
	{ func0406_init_hacker,                           0x0406 },
	{ func0407_init_sniper,                           0x0407 },
	{ func0408_outro,                                 0x0408 },
	{ func1002_intro,                                 0x0409 },
	{ func040a_enable_sniper,                         0x040a },
	{ func040b_init_basement_guard,                   0x040b },
	{ func040c_init_type1_guard,                      0x040c },
	{ func040d_init_type2_guard,                      0x040d },
	{ func040e_start_path00,                          0x040e },
	{ func040f_start_path01,                          0x040f },
	{ func0410_carrington,                            0x0410 },
	{ func0411_cisoldier,                             0x0411 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

